/*
 *  linux/drivers/mmc/mmc_pxa.h
 *
 *  Author: Vladimir Shebordaev, Igor Oblakov
 *  Copyright:  MontaVista Software Inc.
 *
 *  $Id: mmc_pxa.h,v 0.3.1.6 2002/09/25 19:25:48 ted Exp ted $
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.
 */
#ifndef __MMC_ZX_P_H__
#define __MMC_ZX_P_H__

#define SD_VERSION_SD	0x20000
#define SD_VERSION_2	(SD_VERSION_SD | 0x20)
#define SD_VERSION_1_0	(SD_VERSION_SD | 0x10)
#define SD_VERSION_1_10	(SD_VERSION_SD | 0x1a)
#define MMC_VERSION_MMC		0x10000
#define MMC_VERSION_UNKNOWN	(MMC_VERSION_MMC)
#define MMC_VERSION_1_2		(MMC_VERSION_MMC | 0x12)
#define MMC_VERSION_1_4		(MMC_VERSION_MMC | 0x14)
#define MMC_VERSION_2_2		(MMC_VERSION_MMC | 0x22)
#define MMC_VERSION_3		(MMC_VERSION_MMC | 0x30)
#define MMC_VERSION_4		(MMC_VERSION_MMC | 0x40)

#define MMC_MODE_HS		0x001
#define MMC_MODE_HS_52MHz	0x010
#define MMC_MODE_4BIT		0x100
#define MMC_MODE_8BIT		0x200

#define SD_DATA_4BIT	0x00040000

#define IS_SD(x) (x->version & SD_VERSION_SD)

#define MMC_DATA_READ		1
#define MMC_DATA_WRITE		2

#define NO_CARD_ERR		-16 /* No SD/MMC card inserted */
#define UNUSABLE_ERR		-17 /* Unusable Card */
#define COMM_ERR		-18 /* Communications Error */
#define TIMEOUT			-19

#define MMC_CMD_GO_IDLE_STATE		0
#define MMC_CMD_SEND_OP_COND		1
#define MMC_CMD_ALL_SEND_CID		2
#define MMC_CMD_SET_RELATIVE_ADDR	3
#define MMC_CMD_SET_DSR			4
#define MMC_CMD_SWITCH			6
#define MMC_CMD_SELECT_CARD		7
#define MMC_CMD_SEND_EXT_CSD		8
#define MMC_CMD_SEND_CSD		9
#define MMC_CMD_SEND_CID		10
#define MMC_CMD_STOP_TRANSMISSION	12
#define MMC_CMD_SEND_STATUS		13
#define MMC_CMD_SET_BLOCKLEN		16
#define MMC_CMD_READ_SINGLE_BLOCK	17
#define MMC_CMD_READ_MULTIPLE_BLOCK	18
#define MMC_CMD_WRITE_SINGLE_BLOCK	24
#define MMC_CMD_WRITE_MULTIPLE_BLOCK	25

#define MMC_CMD_ERASE_GROUP_START	35
#define MMC_CMD_ERASE_GROUP_END	    36
#define MMC_CMD_ERASE           	38

#define MMC_CMD_APP_CMD			55

#define SD_CMD_SEND_RELATIVE_ADDR	3
#define SD_CMD_SWITCH_FUNC		6
#define SD_CMD_SEND_IF_COND		8

#define SD_CMD_APP_SET_BUS_WIDTH	6
#define SD_CMD_APP_SEND_OP_COND		41
#define SD_CMD_APP_SEND_SCR		51

/* SCR definitions in different words */
#define SD_HIGHSPEED_BUSY	0x00020000
#define SD_HIGHSPEED_SUPPORTED	0x00020000

#define MMC_HS_TIMING		0x00000100
#define MMC_HS_52MHZ		0x2

#define OCR_BUSY	0x80000000
#define OCR_HCS		0x40000000

#define MMC_VDD_165_195		0x00000080	/* VDD voltage 1.65 - 1.95 */
#define MMC_VDD_20_21		0x00000100	/* VDD voltage 2.0 ~ 2.1 */
#define MMC_VDD_21_22		0x00000200	/* VDD voltage 2.1 ~ 2.2 */
#define MMC_VDD_22_23		0x00000400	/* VDD voltage 2.2 ~ 2.3 */
#define MMC_VDD_23_24		0x00000800	/* VDD voltage 2.3 ~ 2.4 */
#define MMC_VDD_24_25		0x00001000	/* VDD voltage 2.4 ~ 2.5 */
#define MMC_VDD_25_26		0x00002000	/* VDD voltage 2.5 ~ 2.6 */
#define MMC_VDD_26_27		0x00004000	/* VDD voltage 2.6 ~ 2.7 */
#define MMC_VDD_27_28		0x00008000	/* VDD voltage 2.7 ~ 2.8 */
#define MMC_VDD_28_29		0x00010000	/* VDD voltage 2.8 ~ 2.9 */
#define MMC_VDD_29_30		0x00020000	/* VDD voltage 2.9 ~ 3.0 */
#define MMC_VDD_30_31		0x00040000	/* VDD voltage 3.0 ~ 3.1 */
#define MMC_VDD_31_32		0x00080000	/* VDD voltage 3.1 ~ 3.2 */
#define MMC_VDD_32_33		0x00100000	/* VDD voltage 3.2 ~ 3.3 */
#define MMC_VDD_33_34		0x00200000	/* VDD voltage 3.3 ~ 3.4 */
#define MMC_VDD_34_35		0x00400000	/* VDD voltage 3.4 ~ 3.5 */
#define MMC_VDD_35_36		0x00800000	/* VDD voltage 3.5 ~ 3.6 */

#define MMC_SWITCH_MODE_CMD_SET		0x00 /* Change the command set */
#define MMC_SWITCH_MODE_SET_BITS	0x01 /* Set bits in EXT_CSD byte
						addressed by index which are
						1 in value field */
#define MMC_SWITCH_MODE_CLEAR_BITS	0x02 /* Clear bits in EXT_CSD byte
						addressed by index, which are
						1 in value field */
#define MMC_SWITCH_MODE_WRITE_BYTE	0x03 /* Set target byte to value */

#define SD_SWITCH_CHECK		0
#define SD_SWITCH_SWITCH	1

/*
 * EXT_CSD fields
 */

#define EXT_CSD_BUS_WIDTH	183	/* R/W */
#define EXT_CSD_HS_TIMING	185	/* R/W */
#define EXT_CSD_CARD_TYPE	196	/* RO */
#define EXT_CSD_REV		192	/* RO */
#define EXT_CSD_SEC_CNT		212	/* RO, 4 bytes */

/*
 * EXT_CSD field definitions
 */

#define EXT_CSD_CMD_SET_NORMAL		(1<<0)
#define EXT_CSD_CMD_SET_SECURE		(1<<1)
#define EXT_CSD_CMD_SET_CPSECURE	(1<<2)

#define EXT_CSD_CARD_TYPE_26	(1<<0)	/* Card can run at 26MHz */
#define EXT_CSD_CARD_TYPE_52	(1<<1)	/* Card can run at 52MHz */

#define EXT_CSD_BUS_WIDTH_1	0	/* Card is in 1 bit mode */
#define EXT_CSD_BUS_WIDTH_4	1	/* Card is in 4 bit mode */
#define EXT_CSD_BUS_WIDTH_8	2	/* Card is in 8 bit mode */

#define R1_ILLEGAL_COMMAND		(1 << 22)
#define R1_APP_CMD			(1 << 5)

#define MMC_RSP_PRESENT (1 << 0)
#define MMC_RSP_136     (1 << 1)                /* 136 bit response */
#define MMC_RSP_CRC     (1 << 2)                /* expect valid crc */
#define MMC_RSP_BUSY    (1 << 3)                /* card may send busy */
#define MMC_RSP_OPCODE  (1 << 4)                /* response contains opcode */

#define MMC_RSP_NONE    (0)
#define MMC_RSP_R1      (MMC_RSP_PRESENT|MMC_RSP_CRC|MMC_RSP_OPCODE)
#define MMC_RSP_R1b	(MMC_RSP_PRESENT|MMC_RSP_CRC|MMC_RSP_OPCODE| \
			MMC_RSP_BUSY)
#define MMC_RSP_R2      (MMC_RSP_PRESENT|MMC_RSP_136|MMC_RSP_CRC)
#define MMC_RSP_R3      (MMC_RSP_PRESENT)
#define MMC_RSP_R4      (MMC_RSP_PRESENT)
#define MMC_RSP_R5      (MMC_RSP_PRESENT|MMC_RSP_CRC|MMC_RSP_OPCODE)
#define MMC_RSP_R6      (MMC_RSP_PRESENT|MMC_RSP_CRC|MMC_RSP_OPCODE)
#define MMC_RSP_R7      (MMC_RSP_PRESENT|MMC_RSP_CRC|MMC_RSP_OPCODE)


struct mmc_cid {
	unsigned long psn;
	unsigned short oid;
	unsigned char mid;
	unsigned char prv;
	unsigned char mdt;
	char pnm[7];
};


#define MMC_DEFAULT_BLKLEN	512
#define MMC_DEFAULT_RCA		1

/*Ĵƫ*/
#define  ZXMCI_CTRL    	                (0x00)
#define  ZXMCI_PWREN   	                (0x04)
#define  ZXMCI_CLKDIV  	                (0x08)
#define  ZXMCI_CLKSRC  	                (0x0C)
#define  ZXMCI_CLKENA  	                (0x10)
#define  ZXMCI_TMOUT  	                (0x14)
#define  ZXMCI_CTYPE   	                (0x18)
#define  ZXMCI_BLKSIZ  	                (0x1C)
#define  ZXMCI_BYTCNT  	                (0x20)
#define  ZXMCI_INTMSK  	                (0x24)
#define  ZXMCI_CMDARG  	                (0x28)
#define  ZXMCI_CMD     	                (0x2C)
#define  ZXMCI_RESP0   	                (0x30)
#define  ZXMCI_RESP1   	                (0x34)
#define  ZXMCI_RESP2   	                (0x38)
#define  ZXMCI_RESP3   	                (0x3C)
#define  ZXMCI_MINTSTS 	                (0x40)
#define  ZXMCI_RINTSTS 	                (0x44)
#define  ZXMCI_STATUS  	                (0x48)
#define  ZXMCI_FIFOTH  	                (0x4C)

#define  ZXMCI_CDETECT 	                (0x50)
#define  ZXMCI_CDETECT_MASK             (0x3fffffff)

#define  ZXMCI_WRTPRT  	                (0x54)
#define  ZXMCI_GPIO    	                (0x58)
#define  ZXMCI_TCBCNT  	                (0x5C)
#define  ZXMCI_TBBCNT  	                (0x60)
#define  ZXMCI_DEBNCE  	                (0x64)
#define  ZXMCI_USRID   	                (0x68)
#define  ZXMCI_VERID   	                (0x6C)
#define  ZXMCI_HCON    	                (0x70)
#define  ZXMCI_BMOD		                (0x80)
#define  ZXMCI_PLDMND	                (0x84)
#define	 ZXMCI_DBADDR	                (0x88)
#define  ZXMCI_IDSTS	                (0x8C)
#define	 ZXMCI_IDINTEN	                (0x90)
#define  ZXMCI_DSCADDR	                (0x94)
#define  ZXMCI_BUFADDR	                (0x98)
#define  ZXMCI_CARDRDTHRCTRL	        (0x100)

#define  ZXMCI_FIFO		                (0x200)

#define ZXMCI_FIFO_DEPTH		        128

/*CTRL Register BIT*/
#define ZXMCI_CTRL_OD_PULLUP            (1 << 24)


/*rintstsж״̬Ĵ*/
#define ZXMCI_STS_CRC		            (1<<15)	//End-bit error (read)/write no CRC
#define ZXMCI_STS_ACD		            (1<<14)	//auto command done
#define ZXMCI_STS_SBE		            (1<<13)	//Start-bit error
#define ZXMCI_STS_HLE		            (1<<12)	//Hardware locked write error
#define ZXMCI_STS_FRUN		            (1<<11)	//FIFO underrun/overrun error
#define ZXMCI_STS_HTO		            (1<<10)	//Data starvation-by-host timeout
#define ZXMCI_STS_DRTO		            (1<<9)	//Data read timeout
#define ZXMCI_STS_RTO		            (1<<8)	//Response timeout 
#define ZXMCI_STS_DCRC		(1<<7)	//Data CRC error 
#define ZXMCI_STS_RCRC		(1<<6)	//Response CRC error
#define ZXMCI_STS_RXDR		(1<<5)	//Receive FIFO data request
#define ZXMCI_STS_TXDR		(1<<4)	//Transmit FIFO data request 
#define ZXMCI_STS_DTO		(1<<3)	//Data transfer over ݴ
#define ZXMCI_STS_CD		(1<<2)	//Command done
#define ZXMCI_STS_RE		(1<<1)	//Response error
#define ZXMCI_STS_CDT		(1<<0)	//Card detect 

/*Ĵ*/
#define ZXMCI_CMD_START	(1U<<31)	//Start command,Once command is taken by CIU, bit is cleared
#define ZXMCI_CMD_CCS		(1<<23)	// 1= Interrupts are enabled in CE-ATA device
#define ZXMCI_CMD_RCEATA	(1<<22)	// 1= Host is performing read access (RW_REG or RW_BLK)towards CE-ATA 
#define ZXMCI_CMD_UCREG	(1<<21)	//0= Normal command sequencregisters_only,1= Do not send commands
#define ZXMCI_CMD_CNUM		(1<<16) //Card number in use
#define ZXMCI_CMD_SINIT	(1<<15)	// 1= Send initialization sequence before sending this comman
#define ZXMCI_CMD_STOP		(1<<14)	// 1= Stop or abort command intended to stop current data transferin progress.
#define ZXMCI_CMD_WAITC	(1<<13)	// 1= Wait for previous data transfer completion before sending command
#define ZXMCI_CMD_SSTOP	(1<<12)	// 1= Send stop command at end of data transfe
#define ZXMCI_CMD_TMODE	(1<<11)	//0= Block data transfer command,1= Stream
#define ZXMCI_CMD_WRITE	(1<<10)	//0= Read from card,1= Write 
#define ZXMCI_CMD_DEXP		(1<<9)	//0= No data transfer expected (read/write)
#define ZXMCI_CMD_CRSP		(1<<8)	// 1= Check response CRC
#define ZXMCI_CMD_RSPLEN	(1<<7)	// 1= Long response expected from car,0=Short 
#define ZXMCI_CMD_RSPEXP	(1<<6)	//  1= Response expected from car
#define ZXMCI_CMD_INDEX	(1<<0)	//Command index
#define ZXMCI_CMD_INDEX_MASK  0x3f  

/*״̬Ĵ*/
#define ZXMCI_STA_DMAREQ	(1<<31)	//DMA request signal state
#define ZXMCI_STA_DMAACK	(1<<30)	//DMA acknowledge signal state
#define ZXMCI_STA_FIFOCNT	(1<<17)	//FIFO count= Number of filled locations in FIFO
#define ZXMCI_STA_PRERSP	(1<<11)	//Index of previous response, including any auto-stop sent by core
#define ZXMCI_STA_TMTBUSY	(1<<10)	//Data transmit or receive state-machine is busy
#define ZXMCI_STA_DATBUSY	(1<<9)	//Inverted version of raw selected card_data[0],1=BUSY
#define ZXMCI_STA_D3STA	(1<<8)	//Raw selected card_data[3];1=card present
#define ZXMCI_STA_FSMSTA	(1<<4)	//Command FSM states
#define ZXMCI_STA_FIFOFULL	(1<<3)	//FIFO is full status
#define ZXMCI_STA_FIFOEMPTY	(1<<2)	//FIFO is empty status
#define ZXMCI_STA_TXWMARK	(1<<1)	//﷧ֵFIFO reached Transmit watermark level; not qualified with data transfer
#define ZXMCI_STA_RXWMARK	(1<<0)	//FIFO reached Receive watermark level

#define ZXMCI_STA_FSM_MASK  (0xF0)
#define ZXMCI_STA_FSM_POS   (0x04)
#define ZXMCI_STA_FSM_IDLE  (0x00)


//#define R1				(ZXMCI_CMD_RSPEXP /*| ZXMCI_CMD_CRSP*/)
#define R1				(ZXMCI_CMD_RSPEXP | ZXMCI_CMD_CRSP)
#define R1B				(ZXMCI_CMD_RSPEXP | ZXMCI_CMD_CRSP)
//#define R2				(ZXMCI_CMD_RSPEXP | /*ZXMCI_CMD_CRSP |*/ZXMCI_CMD_RSPLEN)
#define R2				(ZXMCI_CMD_RSPEXP | ZXMCI_CMD_CRSP |ZXMCI_CMD_RSPLEN)
#define R3				(ZXMCI_CMD_RSPEXP)
#define R4				(ZXMCI_CMD_RSPEXP)
#define R5				(ZXMCI_CMD_RSPEXP | ZXMCI_CMD_CRSP)
#define R6				(ZXMCI_CMD_RSPEXP | ZXMCI_CMD_CRSP)
#define R7				(ZXMCI_CMD_RSPEXP | ZXMCI_CMD_CRSP)
#define CF_DATA			(ZXMCI_CMD_DEXP | ZXMCI_CMD_WAITC | ZXMCI_CMD_SSTOP)
#define CF_WR			ZXMCI_CMD_WRITE

#define ERR_STS			(ZXMCI_STS_CRC | ZXMCI_STS_DCRC | ZXMCI_STS_RCRC)	

/*SD/MMC */
#define SYS_EMMC_REGS_BASE                 0x01210000  //SD0
#define CFG_EMMC_CLK_REF	               26000000
#define	CFG_EMMC_CLK_ENUM		           400000
#define CFG_EMMC_CLK_WORK		           26000000 

#define SYS_STD_CRM_BASE                   0x1307000



#endif /* __MMC_PXA_P_H__ */
