/*  
 * (C) Copyright 2016, ZIXC Corporation.
 *
 */

#include <common.h>
#include <asm/proc-armv/ptrace.h>
#include <asm/arch/hardware.h>
#include <div64.h>
#include <asm/arch/lsp_crpm.h>


int clk_init(void)
{
    /* PLL_CPU_BUS */
    if( !(__REG(PLL_CPU_BUS_CFG0_REG) & PLL_CFG0_LOCK) ) 
    {   
        __REG(PLL_CPU_BUS_CFG1_REG) = 0x01000000;
        /* FoutPostDiv = 1100MHz, Fout1PH0 = 550MHz, Fout3 = 183MHz */
        __REG(PLL_CPU_BUS_CFG0_REG) = 0x08348989;
        while( !(__REG(PLL_CPU_BUS_CFG0_REG) & PLL_CFG0_LOCK ));
    }

    #if 0
    /* PLL_TD_LTE */
    __REG(PLL_TD_LTE_MUX_REG) = TD_LTE_MUX_MAIN_CLK;
    if( !(__REG(PLL_TD_LTE_CFG0_REG) & PLL_TD_LTE_CFG0_LOCK) ) 
    {   
        __REG(PLL_TD_LTE_CFG1_REG) = 0x00000000;
        /* FoutPostDiv = 491MHz,  */
        __REG(PLL_TD_LTE_CFG0_REG) = 0x08687ac9;
        while( !(__REG(PLL_TD_LTE_CFG0_REG) & PLL_TD_LTE_CFG0_LOCK ));
    }
    #endif

    /*config AP mux and div*/
    __REG(UFI_CLK_SEL_REG) = UFI_PLL_CLK_UFI;   /* AP clk src sel 400MHz */
    __REG(UFI_CLK_DIV_REG) = UFI_DIV_1;         /* 1 DIV */
	    
	return 0;
}
