
/*******************************************************************************
 * Copyright (C) 2016, ZIXC Corporation.
 *
 * File Name:cmd_compat_write.c
 * File Mark:
 * Description:
 * Others:
 * Version:       1.0
 * Author:        zangxiaofeng
 * Date:          2013-3-13
 * History 1:
 *     Date:
 *     Version:
 *     Author:
 *     Modification:
 * History 2:
  ********************************************************************************/


/****************************************************************************
* 	                                     Include files
****************************************************************************/
#include <common.h>
#include <command.h>
#include <net.h>
#include <jffs2/load_kernel.h>
#include "downloader_config.h"
#include "downloader_nand.h"
#include "downloader_serial.h"
#include "errno.h"

extern int downloader_readline (char * buffer);
extern char *tsp_console_buffer;
/*******************************************************************************
 * Function:do_ram_write
 * Description:
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
int do_ram_write( unsigned int offset, unsigned int size)
{
    char *ack = tsp_console_buffer;
    unsigned int addr = 0;
    unsigned int leftWriteLength = 0;
    unsigned int curWriteLength = 0;
#ifdef CONFIG_LOAD_CRC
    unsigned long crc = 0;
    unsigned long crc1 = 0;
#endif

    addr = offset ;
   
    if(size == 0)
    {
        sprintf(ack,"FAIL INVALID LENGTH");
        downloader_serial_write(ack, strlen(ack)+1);
        return EINVAL;	
    }
    leftWriteLength = size;
	
    while(leftWriteLength>0)
    {
        curWriteLength = MIN(leftWriteLength,DOWNLOADER_BUFFER_SIZE);
#ifdef CONFIG_LOAD_CRC
        sprintf(ack,"DATACRC %08x",curWriteLength);
#else
        sprintf(ack,"DATA %08x",curWriteLength);
#endif
	    downloader_serial_write(ack, strlen(ack)+1); 
#ifdef CONFIG_LOAD_CRC
        
		downloader_serial_read_actuallen((char *)DOWNLOADER_BUFFER_BASE, curWriteLength+4);
		memcpy(( char *)addr,(char *)DOWNLOADER_BUFFER_BASE,  curWriteLength+4 );


        crc = crc32(0,(unsigned char*)addr,curWriteLength);
        memcpy((unsigned char *)(&crc1),(unsigned char*)(addr+curWriteLength),4);
        if(crc != crc1)
        {
            sprintf(ack,"FAIL CRC ERROR");
            downloader_serial_write(ack, strlen(ack)+1);
            return ENOSYS;  /* Function not implemented */
        }
#else
        

	    downloader_serial_read_actuallen((char *)DOWNLOADER_BUFFER_BASE, curWriteLength);
		memcpy(( char *)addr,(char *)DOWNLOADER_BUFFER_BASE,  curWriteLength );

#endif
	    leftWriteLength -= curWriteLength;
	    addr += curWriteLength;
    }	
	
    sprintf(ack,"OKAY");
    downloader_serial_write(ack, strlen(ack)+1);
    return 0;
	
}

/*******************************************************************************
 * Function:do_ram_read
 * Description:
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
int do_ram_read(unsigned int offset, unsigned int size)
{
    char *rx_buffer = tsp_console_buffer;
    char *ack = tsp_console_buffer;
    unsigned int addr = 0;
    unsigned int leftReadLength = 0;
    unsigned int curReadLength = 0;
	
    addr = offset ;

 
    if((size == 0)||(size > CONFIG_SYS_SDRAM_SIZE))
    {
        sprintf(ack,"FAIL INVALID LENGTH");
        downloader_serial_write(ack, strlen(ack)+1);
        return EINVAL;	/* Invalid argument */
    }
    leftReadLength = size;
	
    sprintf(ack,"DATA %08x",MIN(size,DOWNLOADER_BUFFER_SIZE));
    downloader_serial_write(ack, strlen(ack)+1); 
    while(leftReadLength>0)
    {
        curReadLength = MIN(leftReadLength,DOWNLOADER_BUFFER_SIZE);        
        downloader_readline(rx_buffer); 
	    if(memcmp(rx_buffer,"OKAY",4) == 0)
	    {
		   	memcpy((char *)DOWNLOADER_BUFFER_BASE, (const char *)addr, curReadLength );
			downloader_serial_write_actuallen((const char *)DOWNLOADER_BUFFER_BASE, curReadLength);
        }
	    else
	    {
            sprintf(ack,"FAIL COMMAND ERROR");
            downloader_serial_write(ack, strlen(ack)+1);
	        return EBADRQC;		/* Invalid request code */
	    }
	    leftReadLength -= curReadLength;
	    addr += curReadLength;
    }

    downloader_readline(rx_buffer); 
    if(memcmp(rx_buffer,"OKAY",4) == 0)
    {
        return 0;
    }
    else
    {
        sprintf(ack,"FAIL COMMAND ERROR");
        downloader_serial_write(ack, strlen(ack)+1);
        return EBADRQC;		/* Invalid request code */
    }
	
}
