/*******************************************************************************
 * Copyright (C) 2016, ZIXC Corporation.
 *
 * File Name:cmd_ram_start.c
 * File Mark:
 * Description:
 * Others:
 * Version:       1.0
 * Author:        zangxiaofeng
 * Date:          2013-4-22
 * History 1:
 *     Date:
 *     Version:
 *     Author:
 *     Modification:
 * History 2:
  ********************************************************************************/


/****************************************************************************
* 	                                     Include files
****************************************************************************/
#include <common.h>
#include <command.h>
#include <net.h>
#include <jffs2/load_kernel.h>
#include "downloader_nand.h"
#include "downloader_config.h"
#include "downloader_serial.h"
#include <asm/arch/cpu.h>
#include <asm/io.h>


static is_flush = 0;
extern char *tsp_console_buffer;
extern uint32_t arm_ps_ep;
/****************************************************************************
*							Global Function Prototypes
****************************************************************************/
int start_core(uchar *core_name, unsigned int addr);

 
/*******************************************************************************
 * Function:do_ram_start
 * Description:
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
int do_ram_start(cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{
	char *ack = tsp_console_buffer;
	unsigned int i = 0;
	unsigned int addr = 0;

	if(argc < 1)
	{
		return cmd_usage(cmdtp);
	}
 
	sprintf(ack,"OKAY ram_start");
	downloader_serial_write(ack, strlen(ack)+1); 
	for(i=1; i<argc; i=i+2)
	{
		addr = (unsigned int)simple_strtoul (argv[i+1], NULL, 16);
		printf("core is %s, addr is %x\n",(uchar *)argv[i],addr);
		start_core((uchar *)argv[i], addr);
	}
	hang();
	return 0;
}

U_BOOT_CMD(
	ram_start, CONFIG_SYS_MAXARGS, 0, do_ram_start,
	"ram_start: ram_start",
	""
);

 int start_core(uchar *core_name, unsigned int addr)
{
	char *ack = tsp_console_buffer;

	if(strcmp((const char *)core_name,"ps") == 0)
	{
		if(addr != 0xffffffff)
		{
			/* д PS ת */ 

			/* flush d-cache */
			if( is_flush != 1 )
			{
				is_flush = 1;
				cleanup_before_linux();
			}
			arm_ps_ep = addr;            
			/* ͷ ARM_PS  */
			printf("Starting the arm_ps ...\n");
			start_arm_ps();
		}
		else
		{
			printf("No Starting the arm_ps ...\n");
		}
	}
	else if (strcmp((const char *)core_name,"phy") == 0)
	{
		if(addr != 0xffffffff)
		{
			/* д PHY ת */ 

			/* flush d-cache */
			/*if( is_flush != 1 )
			{
				is_flush = 1;
				cleanup_before_linux();
			}*/
			//load_zsp_image(addr);
			/* ͷ ARM_PHY  */

			printf("Starting the arm_phy ...\n");
		}
		else
		{
			printf("No Starting the arm_phy ...\n");
		}
	}
	else
	{
		sprintf(ack,"FAIL INVILID CORE NAME");
		downloader_serial_write(ack, strlen(ack)+1);
		return -1;
	}
	return 0;
}
        
