/*******************************************************************************
 * Copyright (C) 2016, ZIXC Corporation.
 *
 * File Name:    downloader_nand.h
 * File Mark:    
 * Description:  
 * Others:        
 * Version:       1.0
 * Author:        geanfeng
 * Date:          2013-03-04
 * History 1:      
 *     Date: 
 *     Version:
 *     Author: 
 *     Modification:  
 * History 2: 
  ********************************************************************************/
#ifndef _DOWNLOADER_NAND_H
#define _DOWNLOADER_NAND_H
/****************************************************************************
* 	                        Include files
****************************************************************************/
#include <common.h>
#include <linux/mtd/mtd.h>
#include <command.h>
#include <malloc.h>
#include <nand.h>
#include <jffs2/jffs2.h>
#include <partition_table.h>
/****************************************************************************
* 	                         Macros
****************************************************************************/

/****************************************************************************
* 	                         Types
****************************************************************************/
/****************************************************************************
* 	                         Constants
****************************************************************************/

/****************************************************************************
* 	                         Global  Variables
****************************************************************************/
extern unsigned char g_nor_flag;

/****************************************************************************
* 	                         Function Prototypes
****************************************************************************/

/*******************************************************************************
 * Function:downloader_get_part
 * Description:
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
partition_entry_t *  downloader_get_part(const char *partname);
/*******************************************************************************
 * Function:downloader_get_part_dl
 * Description:
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/

partition_entry_t *  downloader_get_part_dl(const char *partname);
/*******************************************************************************
 * Function:downloader_nand_read
 * Description:
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
int 	downloader_nand_read(partition_entry_t * part, uint offset,  uint size,  unchar * buffer);
/*******************************************************************************
 * Function:downloader_nand_write
 * Description:
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
int 	downloader_nand_write(partition_entry_t * part, uint offset,  uint size,  unchar * buffer);
/*******************************************************************************
 * Function:downloader_zftl_read
 * Description:
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
int 	downloader_zftl_read(partition_entry_t * part, uint offset,  uint size,  unchar * buffer);
/*******************************************************************************
 * Function:downloader_zftl_write
 * Description:
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
int 	downloader_zftl_write(partition_entry_t * part, uint offset,  uint size,  unchar * buffer);
/*******************************************************************************
 * Function:downloader_nand_fs_read
 * Description:
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
int 	downloader_nand_fs_read(partition_entry_t * part, uint offset,  uint size,  unchar * buffer);
/*******************************************************************************
 * Function:downloader_nand_fs_write
 * Description:
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
int 	downloader_nand_fs_write(partition_entry_t * part, uint offset,  uint size,  unchar * buffer);
/*******************************************************************************
 * Function:downloader_nand_erase
 * Description:
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
int 	downloader_nand_erase(partition_entry_t * part, uint  partEraseSize);
/*******************************************************************************
 * Function:downloader_nand_eraseall
 * Description:
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
int 	downloader_nand_eraseall(void);

/*******************************************************************************
 * Function:downloader_nand_auto
 * Description:
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
int 	downloader_nand_erase_auto(void);

int do_nand_read(partition_entry_t *part, char *par , unsigned int offset, unsigned int size );

int do_raw_read(unsigned int offset, unsigned int size);

int  do_ram_read(unsigned int offset, unsigned int size);

int do_zftl_read(partition_entry_t *part, char *par , unsigned int offset, unsigned int size);

int do_yaffs_read(partition_entry_t *part, char *par , unsigned int offset, unsigned int size);

int do_mmc_read(partition_entry_t *part, char *par , unsigned int offset,unsigned int size );

int do_nand_write(partition_entry_t *part, char *par , unsigned int offset, unsigned int size );

int do_raw_write(unsigned int offset, unsigned int size);

int do_yaffs_write(partition_entry_t *part, char *par , unsigned int offset, unsigned int size );

int do_zftl_write(partition_entry_t *part, char *par , unsigned int offset, unsigned int size);

int do_ram_write( unsigned int offset, unsigned int size);

int do_mmc_write(partition_entry_t *part, char *par , unsigned int offset,unsigned int size );

#endif

