/*******************************************************************************
 * Copyright (C) 2016, ZXIC Corporation.
 *
 * File Name:    hal_gpioinfo.c
 * File Mark:
 * Description:  gpio information table
 * Others:
 * Version:       1.0
 * Author:        zhangdongdong
 * Date:          2015-07-31
 * History 1:
 *     Date:
 *     Version:
 *     Author:
 *     Modification:
 ********************************************************************************/

/****************************************************************************
*                                              Include files
****************************************************************************/
#include <drvs_gpio.h>
#include "hal_gpio_v3.h"

/****************************************************************************
*                                              Local Macros
****************************************************************************/
	/*PIN MUX*/
#define ZX297520V2_PIN_MUX        0x01303000
#define GPIO_PINMUX_REG_BASE ZX297520V2_PIN_MUX
	
	/*PAD*/
#define ZX297520V2_A1_PAD_CTRL0   0x0013C000
#define PAD_CTRL_REG_BASE   ZX297520V2_A1_PAD_CTRL0
		
#define PD_FUNC_SEL_BASE        (GPIO_PINMUX_REG_BASE)
#define AON_FUNC_SEL_BASE		(PAD_CTRL_REG_BASE)
#define TOP_FUNC_SEL_BASE		(PAD_CTRL_REG_BASE)
#define IO_CFG_BASE				(PAD_CTRL_REG_BASE+0x800)

#define CPU_SHIFT						0x0

/****************************************************************************
*                                              Local Types
****************************************************************************/


/****************************************************************************
*                                              Local Constants
****************************************************************************/

/****************************************************************************
*                                              Local Variables
****************************************************************************/

/****************************************************************************
*                                             Global Constants
****************************************************************************/

/****************************************************************************
*                                             Global Variables
****************************************************************************/

/****************************************************************************
*                                             Global Function Prototypes
****************************************************************************/
T_Gpio gGpioInfoTable[] =
{
	[NAND_WE] = {
        .name       = "nand_we",
		.gpio       = GPIO0,
		.flag       = 0,
        .pdFuncSel  = {(PD_FUNC_SEL_BASE)>>CPU_SHIFT, 0, 1},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x1c)>>CPU_SHIFT, 0, 1},
        .ioCfg      = {(IO_CFG_BASE)>>CPU_SHIFT, 0, 2},
    },

	[NAND_CSN] = {
        .name       = "nand_csn",
		.gpio       = GPIO1,
		.flag       = 0,
        .pdFuncSel  = {(PD_FUNC_SEL_BASE)>>CPU_SHIFT, 1, 1},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x1c)>>CPU_SHIFT, 1, 1},
        .ioCfg      = {(IO_CFG_BASE)>>CPU_SHIFT, 2, 2},
    },

	[NAND_READY] = {
        .name       = "nand_ready",
		.gpio       = GPIO2,
		.flag       = 0,
		.pdFuncSel	= {(PD_FUNC_SEL_BASE)>>CPU_SHIFT, 2, 1},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x1c)>>CPU_SHIFT, 2, 1},
        .ioCfg      = {(IO_CFG_BASE)>>CPU_SHIFT, 4, 2},
    },

	[NAND_CLE_] = {
        .name       = "nand_cle",
		.gpio       = GPIO3,
		.flag       = 0,
        .pdFuncSel  = {(PD_FUNC_SEL_BASE)>>CPU_SHIFT, 3, 1},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x1c)>>CPU_SHIFT, 3, 1},
        .ioCfg      = {(IO_CFG_BASE)>>CPU_SHIFT, 6, 2},
    },

	[NAND_ALE_] = {
        .name       = "nand_ale",
		.gpio       = GPIO4,
		.flag       = 0,
		.pdFuncSel	= {(PD_FUNC_SEL_BASE)>>CPU_SHIFT, 4, 1},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x1c)>>CPU_SHIFT, 4, 1},
        .ioCfg      = {(IO_CFG_BASE)>>CPU_SHIFT, 8, 2},
    },

	[NAND_RE] = {
        .name       = "nand_re",
		.gpio       = GPIO5,
		.flag       = 0,
        .pdFuncSel  = {(PD_FUNC_SEL_BASE)>>CPU_SHIFT, 5, 1},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x1c)>>CPU_SHIFT, 5, 1},
        .ioCfg      = {(IO_CFG_BASE)>>CPU_SHIFT, 10, 2},
    },

	[NAND_WP] = {
        .name       = "nand_wp",
		.gpio       = GPIO6,
		.flag       = 0,
        .pdFuncSel  = {(PD_FUNC_SEL_BASE)>>CPU_SHIFT, 6, 1},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x1c)>>CPU_SHIFT, 6, 1},
        .ioCfg      = {(IO_CFG_BASE)>>CPU_SHIFT, 12, 2},
    },

	[NAND_DATA0] = {
        .name       = "nand_data0",
		.gpio       = GPIO7,
		.flag       = 0,
        .pdFuncSel  = {(PD_FUNC_SEL_BASE)>>CPU_SHIFT, 7, 1},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x1c)>>CPU_SHIFT, 7, 1},
        .ioCfg      = {(IO_CFG_BASE)>>CPU_SHIFT, 14, 2},
    },

	[NAND_DATA1] = {
        .name       = "nand_data1",
		.gpio       = GPIO8,
		.flag       = 0,
        .pdFuncSel  = {(PD_FUNC_SEL_BASE)>>CPU_SHIFT, 8, 1},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x1c)>>CPU_SHIFT, 8, 1},
        .ioCfg      = {(IO_CFG_BASE)>>CPU_SHIFT, 16, 2},
    },

	[NAND_DATA2] = {
        .name       = "nand_data2",
		.gpio       = GPIO9,
		.flag       = 0,
        .pdFuncSel  = {(PD_FUNC_SEL_BASE)>>CPU_SHIFT, 9, 1},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x1c)>>CPU_SHIFT, 9, 1},
        .ioCfg      = {(IO_CFG_BASE)>>CPU_SHIFT, 18, 2},
    },

	[NAND_DATA3] = {
        .name       = "nand_data3",
		.gpio       = GPIO10,
		.flag       = 0,
        .pdFuncSel  = {(PD_FUNC_SEL_BASE)>>CPU_SHIFT, 10, 1},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x1c)>>CPU_SHIFT, 10, 1},
        .ioCfg      = {(IO_CFG_BASE)>>CPU_SHIFT, 20, 2},
    },

	[NAND_DATA4] = {
        .name       = "nand_data4",
		.gpio       = GPIO11,
		.flag       = 0,
        .pdFuncSel  = {(PD_FUNC_SEL_BASE)>>CPU_SHIFT, 11, 1},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x1c)>>CPU_SHIFT, 11, 1},
        .ioCfg      = {(IO_CFG_BASE)>>CPU_SHIFT, 22, 2},
    },

	[NAND_DATA5] = {
        .name       = "nand_data5",
		.gpio       = GPIO12,
		.flag       = 0,
        .pdFuncSel  = {(PD_FUNC_SEL_BASE)>>CPU_SHIFT, 12, 1},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x1c)>>CPU_SHIFT, 12, 1},
        .ioCfg      = {(IO_CFG_BASE)>>CPU_SHIFT, 24, 2},
    },

	[NAND_DATA6] = {
        .name       = "nand_data6",
		.gpio       = GPIO13,
		.flag       = 0,
        .pdFuncSel  = {(PD_FUNC_SEL_BASE)>>CPU_SHIFT, 13, 1},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x1c)>>CPU_SHIFT, 13, 1},
        .ioCfg      = {(IO_CFG_BASE)>>CPU_SHIFT, 26, 2},
    },

	[NAND_DATA7] = {
        .name       = "nand_data7",
		.gpio       = GPIO14,
		.flag       = 0,
        .pdFuncSel  = {(PD_FUNC_SEL_BASE)>>CPU_SHIFT, 14, 1},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x1c)>>CPU_SHIFT, 14, 1},
        .ioCfg      = {(IO_CFG_BASE)>>CPU_SHIFT, 28, 2},
    },


	[CLK_OUT0] = {
        .name       = "clk_out0",
		.gpio       = GPIO15,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {(AON_FUNC_SEL_BASE)>>CPU_SHIFT, 0, 2},
        .topFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .ioCfg      = {(IO_CFG_BASE+0x4)>>CPU_SHIFT, 10, 2},
    },

	[CLK_OUT1] = {
        .name       = "clk_out1",
		.gpio       = GPIO16,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {(AON_FUNC_SEL_BASE)>>CPU_SHIFT, 2, 2},
        .topFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .ioCfg      = {(IO_CFG_BASE+0x4)>>CPU_SHIFT, 12, 2},
    },

	[CLK_OUT2] = {
        .name       = "clk_out2",
		.gpio       = GPIO17,
		.flag       = 0,
        .pdFuncSel  = {(PD_FUNC_SEL_BASE)>>CPU_SHIFT, 15, 2},
        .aonFuncSel = {(AON_FUNC_SEL_BASE)>>CPU_SHIFT, 4, 2},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x30)>>CPU_SHIFT, 0, 1},
        .ioCfg      = {(IO_CFG_BASE+0x4)>>CPU_SHIFT, 14, 2},
    },

	[CLK_32K_OUT] = {
        .name       = "clk_32k_out",
		.gpio       = GPIO18,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {(AON_FUNC_SEL_BASE)>>CPU_SHIFT, 6, 2},
        .topFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .ioCfg      = {(IO_CFG_BASE+0x4)>>CPU_SHIFT, 16, 2},
    },

	[RMII_CLK_I] = {
        .name       = "rmii_clk_i",
		.gpio       = GPIO19,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x1c)>>CPU_SHIFT, 15, 1},
        .ioCfg      = {(IO_CFG_BASE+0x3c)>>CPU_SHIFT, 0, 8},
    },

	[RMII_CLK_O] = {
        .name       = "rmii_clk_o",
		.gpio       = GPIO20,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x1c)>>CPU_SHIFT, 16, 1},
        .ioCfg      = {(IO_CFG_BASE+0x3c)>>CPU_SHIFT, 0, 8},
    },	

	[CLK_REQ0] = {
        .name       = "clk_req0",
		.gpio       = GPIO21,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {(AON_FUNC_SEL_BASE)>>CPU_SHIFT, 8, 2},
        .topFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .ioCfg      = {(IO_CFG_BASE+0x4)>>CPU_SHIFT, 18, 2},
    },	
    
    [CLK_REQ1] = {
        .name       = "clk_req1",
		.gpio       = GPIO22,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {(AON_FUNC_SEL_BASE)>>CPU_SHIFT, 10, 2},
        .topFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .ioCfg      = {(IO_CFG_BASE+0x4)>>CPU_SHIFT, 20, 2},
    },

	[PWR_CTRL] = {
        .name       = "pwr_ctrl",
		.gpio       = GPIO23,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {(AON_FUNC_SEL_BASE)>>CPU_SHIFT, 12, 2},
        .topFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .ioCfg      = {(IO_CFG_BASE+0x4)>>CPU_SHIFT, 22, 2},
    },

    [PS_HOLD] = {
        .name       = "ps_hold",
		.gpio       = GPIO24,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .ioCfg      = {(IO_CFG_BASE+0x4)>>CPU_SHIFT, 28, 2},
    },

	[SSP0_CS] = {
        .name       = "ssp0_cs",
		.gpio       = GPIO25,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x1c)>>CPU_SHIFT, 17, 1},
        .ioCfg      = {(IO_CFG_BASE+0x8)>>CPU_SHIFT, 0, 2},
    },

	[SSP0_CLK] = {
        .name       = "ssp0_clk",
		.gpio       = GPIO26,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x1c)>>CPU_SHIFT, 18, 1},
        .ioCfg      = {(IO_CFG_BASE+0x8)>>CPU_SHIFT, 2, 2},
    },

	[SSP0_RXD] = {
        .name       = "ssp0_rxd",
		.gpio       = GPIO27,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x1c)>>CPU_SHIFT, 19, 1},
        .ioCfg      = {(IO_CFG_BASE+0x8)>>CPU_SHIFT, 4, 2},
    },

	[SSP0_TXD] = {
        .name       = "ssp0_txd",
		.gpio       = GPIO28,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x1c)>>CPU_SHIFT, 20, 1},
        .ioCfg      = {(IO_CFG_BASE+0x8)>>CPU_SHIFT, 6, 2},
    },

	[UART0_RXD] = {
        .name       = "uart0_rxd",
		.gpio       = GPIO29,
		.flag       = 0,
        .pdFuncSel  = {(PD_FUNC_SEL_BASE+0x04)>>CPU_SHIFT, 0, 1},
        .aonFuncSel = {(AON_FUNC_SEL_BASE)>>CPU_SHIFT, 14, 2},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x20)>>CPU_SHIFT, 0, 1},
        .ioCfg      = {(IO_CFG_BASE+0x8)>>CPU_SHIFT, 10, 2},
    },

	[UART0_TXD] = {
        .name       = "uart0_txd",
		.gpio       = GPIO30,
		.flag       = 0,
        .pdFuncSel  = {(PD_FUNC_SEL_BASE+0x04)>>CPU_SHIFT, 1, 1},
        .aonFuncSel = {(AON_FUNC_SEL_BASE)>>CPU_SHIFT, 16, 2},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x20)>>CPU_SHIFT, 1, 1},
        .ioCfg      = {(IO_CFG_BASE+0x8)>>CPU_SHIFT, 12, 2},
    },
    
	[UART0_CTS] = {
        .name       = "uart0_cts",
		.gpio       = GPIO31,
		.flag       = 0,
        .pdFuncSel  = {(PD_FUNC_SEL_BASE+0x04)>>CPU_SHIFT, 2, 2},
        .aonFuncSel = {(AON_FUNC_SEL_BASE)>>CPU_SHIFT, 18, 2},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x20)>>CPU_SHIFT, 2, 1},
        .ioCfg      = {(IO_CFG_BASE+0x8)>>CPU_SHIFT, 14, 2},
    },

	[UART0_RTS] = {
        .name       = "uart0_rts",
		.gpio       = GPIO32,
		.flag       = 0,
        .pdFuncSel  = {(PD_FUNC_SEL_BASE+0x04)>>CPU_SHIFT, 4, 2},
        .aonFuncSel = {(AON_FUNC_SEL_BASE)>>CPU_SHIFT, 20, 2},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x20)>>CPU_SHIFT, 3, 1},
        .ioCfg      = {(IO_CFG_BASE+0x8)>>CPU_SHIFT, 16, 2},
    },

	[UART1_RXD] = {
        .name       = "uart1_rxd",
		.gpio       = GPIO33,
		.flag       = 0,
        .pdFuncSel  = {(PD_FUNC_SEL_BASE+0x4)>>CPU_SHIFT, 6, 2},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x20)>>CPU_SHIFT, 4, 1},
        .ioCfg      = {(IO_CFG_BASE+0x8)>>CPU_SHIFT, 18, 2},
    },

	[UART1_TXD] = {
        .name       = "uart1_txd",
		.gpio       = GPIO34,
		.flag       = 0,
        .pdFuncSel  = {(PD_FUNC_SEL_BASE+0x4)>>CPU_SHIFT, 8, 2},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x20)>>CPU_SHIFT, 5, 1},
        .ioCfg      = {(IO_CFG_BASE+0x8)>>CPU_SHIFT, 20, 2},
    },

	[I2S0_WS] = {
        .name       = "i2s0_ws",
		.gpio       = GPIO35,
		.flag       = 0,
        .pdFuncSel  = {(PD_FUNC_SEL_BASE+0x4)>>CPU_SHIFT, 10, 2},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x20)>>CPU_SHIFT, 6, 1},
        .ioCfg      = {(IO_CFG_BASE+0x8)>>CPU_SHIFT, 22, 2},
    },

	[I2S0_CLK] = {
        .name       = "i2s0_clk",
		.gpio       = GPIO36,
		.flag       = 0,
        .pdFuncSel  = {(PD_FUNC_SEL_BASE+0x4)>>CPU_SHIFT, 12, 2},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x20)>>CPU_SHIFT, 7, 1},
        .ioCfg      = {(IO_CFG_BASE+0x8)>>CPU_SHIFT, 24, 2},
    },

	[I2S0_DIN] = {
        .name       = "i2s0_din",
		.gpio       = GPIO37,
		.flag       = 0,
        .pdFuncSel  = {(PD_FUNC_SEL_BASE+0x4)>>CPU_SHIFT, 14, 2},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x20)>>CPU_SHIFT, 8, 1},
        .ioCfg      = {(IO_CFG_BASE+0x8)>>CPU_SHIFT, 26, 2},
    },
	
	[I2S0_DOUT] = {
        .name       = "i2s0_dout",
		.gpio       = GPIO38,
		.flag       = 0,
        .pdFuncSel  = {(PD_FUNC_SEL_BASE+0x4)>>CPU_SHIFT, 16, 2},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x20)>>CPU_SHIFT, 9, 1},
        .ioCfg      = {(IO_CFG_BASE+0x8)>>CPU_SHIFT, 28, 2},
    },

	[I2S1_WS] = {
        .name       = "i2s1_ws",
		.gpio       = GPIO39,
		.flag       = 0,
        .pdFuncSel  = {(PD_FUNC_SEL_BASE+0x4)>>CPU_SHIFT, 18, 2},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x20)>>CPU_SHIFT, 10, 1},
        .ioCfg      = {(IO_CFG_BASE+0x8)>>CPU_SHIFT, 30, 2},
    },

	[I2S1_CLK] = {
        .name       = "i2s1_clk",
		.gpio       = GPIO40,
		.flag       = 0,
        .pdFuncSel  = {(PD_FUNC_SEL_BASE+0x4)>>CPU_SHIFT, 20, 2},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x20)>>CPU_SHIFT, 11, 1},
        .ioCfg      = {(IO_CFG_BASE+0xc)>>CPU_SHIFT, 0, 2},
    },

	[I2S1_DIN] = {
        .name       = "i2s1_din",
		.gpio       = GPIO41,
		.flag       = 0,
        .pdFuncSel  = {(PD_FUNC_SEL_BASE+0x4)>>CPU_SHIFT, 22, 2},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x20)>>CPU_SHIFT, 12, 1},
        .ioCfg      = {(IO_CFG_BASE+0xc)>>CPU_SHIFT, 2, 2},
    },
	
	[I2S1_DOUT] = {
        .name       = "i2s1_dout",
		.gpio       = GPIO42,
		.flag       = 0,
        .pdFuncSel  = {(PD_FUNC_SEL_BASE+0x4)>>CPU_SHIFT, 24, 2},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x20)>>CPU_SHIFT, 13, 1},
        .ioCfg      = {(IO_CFG_BASE+0xc)>>CPU_SHIFT, 4, 2},
    },

	[SCL0] = {
        .name       = "scl0",
		.gpio       = GPIO43,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {(AON_FUNC_SEL_BASE+0x4)>>CPU_SHIFT, 0, 2},
        .topFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .ioCfg      = {(IO_CFG_BASE+0xc)>>CPU_SHIFT, 6, 2},
    },
		
	[SDA0] = {
        .name       = "sda0",
		.gpio       = GPIO44,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {(AON_FUNC_SEL_BASE+0x4)>>CPU_SHIFT, 2, 2},
        .topFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .ioCfg      = {(IO_CFG_BASE+0xc)>>CPU_SHIFT, 8, 2},
    },

	[SCL1] = {
        .name       = "scl1",
		.gpio       = GPIO45,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x20)>>CPU_SHIFT, 14, 1},
        .ioCfg      = {(IO_CFG_BASE+0xc)>>CPU_SHIFT, 10, 2},
    },
		
	[SDA1] = {
        .name       = "sda1",
		.gpio       = GPIO46,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x20)>>CPU_SHIFT, 15, 1},
        .ioCfg      = {(IO_CFG_BASE+0xc)>>CPU_SHIFT, 12, 2},
    },

	[EXT_INT0] = {
        .name       = "ext_int0",
		.gpio       = GPIO47,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {(AON_FUNC_SEL_BASE+0x4)>>CPU_SHIFT, 4, 2},
        .topFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .ioCfg      = {(IO_CFG_BASE+0xc)>>CPU_SHIFT, 14, 2},
    },

	[EXT_INT1] = {
        .name       = "ext_int1",
		.gpio       = GPIO48,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {(AON_FUNC_SEL_BASE+0x4)>>CPU_SHIFT, 6, 2},
        .topFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .ioCfg      = {(IO_CFG_BASE+0xc)>>CPU_SHIFT, 16, 2},
    },

	[EXT_INT2] = {
        .name       = "ext_int2",
		.gpio       = GPIO49,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {(AON_FUNC_SEL_BASE+0x4)>>CPU_SHIFT, 8, 2},
        .topFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .ioCfg      = {(IO_CFG_BASE+0xc)>>CPU_SHIFT, 18, 2},
    },

	[EXT_INT3] = {
        .name       = "ext_int3",
		.gpio       = GPIO50,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {(AON_FUNC_SEL_BASE+0x4)>>CPU_SHIFT, 10, 2},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x20)>>CPU_SHIFT, 16, 1},
        .ioCfg      = {(IO_CFG_BASE+0xc)>>CPU_SHIFT, 20, 2},
    },

	[EXT_INT4] = {
        .name       = "ext_int4",
		.gpio       = GPIO51,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {(AON_FUNC_SEL_BASE+0x4)>>CPU_SHIFT, 12, 2},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x20)>>CPU_SHIFT, 17, 1},
        .ioCfg      = {(IO_CFG_BASE+0xc)>>CPU_SHIFT, 22, 2},
    },

	[EXT_INT5] = {
        .name       = "ext_int5",
		.gpio       = GPIO52,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {(AON_FUNC_SEL_BASE+0x4)>>CPU_SHIFT, 14, 2},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x20)>>CPU_SHIFT, 18, 1},
        .ioCfg      = {(IO_CFG_BASE+0xc)>>CPU_SHIFT, 24, 2},
    },

	[EXT_INT6] = {
        .name       = "ext_int6",
		.gpio       = GPIO53,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {(AON_FUNC_SEL_BASE+0x4)>>CPU_SHIFT, 16, 2},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x20)>>CPU_SHIFT, 19, 1},
        .ioCfg      = {(IO_CFG_BASE+0xc)>>CPU_SHIFT, 26, 2},
    },

	[EXT_INT7] = {
        .name       = "ext_int7",
		.gpio       = GPIO54,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {(AON_FUNC_SEL_BASE+0x4)>>CPU_SHIFT, 18, 2},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x20)>>CPU_SHIFT, 20, 1},
        .ioCfg      = {(IO_CFG_BASE+0xc)>>CPU_SHIFT, 28, 2},
    },
    
	[RMII_TXEN] = {
        .name       = "rmii_txen",
		.gpio       = GPIO55,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x24)>>CPU_SHIFT, 0, 1},
        .ioCfg      = {(IO_CFG_BASE+0x3c)>>CPU_SHIFT, 0, 8},
    },
    
    [RMII_RXEN] = {
        .name       = "rmii_rxen",
		.gpio       = GPIO56,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x24)>>CPU_SHIFT, 1, 1},
        .ioCfg      = {(IO_CFG_BASE+0x3c)>>CPU_SHIFT, 0, 8},
    },
    
    [RMII_RXD0] = {
        .name       = "rmii_rxd0",
		.gpio       = GPIO57,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x24)>>CPU_SHIFT, 2, 1},
        .ioCfg      = {(IO_CFG_BASE+0x3c)>>CPU_SHIFT, 0, 8},
    },    
    
    [RMII_RXD1] = {
        .name       = "rmii_rxd1",
		.gpio       = GPIO58,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x24)>>CPU_SHIFT, 3, 1},
        .ioCfg      = {(IO_CFG_BASE+0x3c)>>CPU_SHIFT, 0, 8},
    },    
    
    [RMII_TXD0] = {
        .name       = "rmii_txd0",
		.gpio       = GPIO59,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x24)>>CPU_SHIFT, 4, 1},
        .ioCfg      = {(IO_CFG_BASE+0x3c)>>CPU_SHIFT, 0, 8},
    },    
    
    [RMII_TXD1] = {
        .name       = "rmii_txd1",
		.gpio       = GPIO60,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x24)>>CPU_SHIFT, 5, 1},
        .ioCfg      = {(IO_CFG_BASE+0x3c)>>CPU_SHIFT, 0, 8},
    },    
    
    [MDC_SCLK] = {
        .name       = "mdc_sclk",
		.gpio       = GPIO61,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x24)>>CPU_SHIFT, 6, 1},
        .ioCfg      = {(IO_CFG_BASE+0x3c)>>CPU_SHIFT, 0, 8},
    },
    
    [MDC_SDIO] = {
        .name       = "mdc_sdio",
		.gpio       = GPIO62,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x24)>>CPU_SHIFT, 7, 1},
        .ioCfg      = {(IO_CFG_BASE+0x3c)>>CPU_SHIFT, 0, 8},
    },    
    
    [PHY_RST] = {
        .name       = "phy_rst",
		.gpio       = GPIO63,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x24)>>CPU_SHIFT, 8, 1},
        .ioCfg      = {(IO_CFG_BASE+0x3c)>>CPU_SHIFT, 0, 8},
    },
    
    [PHY_INT] = {
        .name       = "phy_int",
		.gpio       = GPIO64,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x24)>>CPU_SHIFT, 9, 1},
        .ioCfg      = {(IO_CFG_BASE+0x3c)>>CPU_SHIFT, 0, 8},
    },    
    
    [PHY_WAKE] = {
        .name       = "phy_wake",
		.gpio       = GPIO65,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .ioCfg      = {(IO_CFG_BASE+0x3c)>>CPU_SHIFT, 0, 8},
    },
   
	[SD0_CLK] = {
        .name       = "sd0_clk",
		.gpio       = GPIO66,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {(AON_FUNC_SEL_BASE+0x8)>>CPU_SHIFT, 0, 2},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x24)>>CPU_SHIFT, 10, 1},
        .ioCfg      = {(IO_CFG_BASE+0x10)>>CPU_SHIFT, 0, 8},
    },

	[SD0_CMD] = {
        .name       = "sd0_cmd",
		.gpio       = GPIO67,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {(AON_FUNC_SEL_BASE+0x8)>>CPU_SHIFT, 2, 2},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x24)>>CPU_SHIFT, 11, 1},
        .ioCfg      = {(IO_CFG_BASE+0x10)>>CPU_SHIFT, 8, 8},
    },

	[SD0_DATA0] = {
        .name       = "sd0_data0",
		.gpio       = GPIO68,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {(AON_FUNC_SEL_BASE+0x8)>>CPU_SHIFT, 4, 2},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x24)>>CPU_SHIFT, 12, 1},
        .ioCfg      = {(IO_CFG_BASE+0x10)>>CPU_SHIFT, 16, 8},
    },

	[SD0_DATA1] = {
        .name       = "sd0_data1",
		.gpio       = GPIO69,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {(AON_FUNC_SEL_BASE+0x8)>>CPU_SHIFT, 6, 2},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x24)>>CPU_SHIFT, 13, 1},
        .ioCfg      = {(IO_CFG_BASE+0x10)>>CPU_SHIFT, 24, 8},
    },

	[SD0_DATA2] = {
        .name       = "sd0_data2",
		.gpio       = GPIO70,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {(AON_FUNC_SEL_BASE+0x8)>>CPU_SHIFT, 8, 2},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x24)>>CPU_SHIFT, 14, 1},
        .ioCfg      = {(IO_CFG_BASE+0x14)>>CPU_SHIFT, 0, 8},
    },

	[SD0_DATA3] = {
        .name       = "sd0_data3",
		.gpio       = GPIO71,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {(AON_FUNC_SEL_BASE+0x8)>>CPU_SHIFT, 10, 2},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x24)>>CPU_SHIFT, 15, 1},
        .ioCfg      = {(IO_CFG_BASE+0x14)>>CPU_SHIFT, 8, 8},
    },

	[SD1_CLK] = {
        .name       = "sd1_clk",
		.gpio       = GPIO72,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x24)>>CPU_SHIFT, 16, 1},
        .ioCfg      = {(IO_CFG_BASE+0x14)>>CPU_SHIFT, 16, 8},
    },

	[SD1_CMD] = {
        .name       = "sd1_cmd",
		.gpio       = GPIO73,
		.flag       = 0,
        .pdFuncSel  = {(PD_FUNC_SEL_BASE+0x8)>>CPU_SHIFT, 0, 2},
        .aonFuncSel = {(AON_FUNC_SEL_BASE+0x8)>>CPU_SHIFT, 12, 2},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x24)>>CPU_SHIFT, 17, 1},
        .ioCfg      = {(IO_CFG_BASE+0x14)>>CPU_SHIFT, 24, 8},
    },

	[SD1_DATA0] = {
        .name       = "sd1_data0",
		.gpio       = GPIO74,
		.flag       = 0,
        .pdFuncSel  = {(PD_FUNC_SEL_BASE+0x8)>>CPU_SHIFT, 2, 2},
        .aonFuncSel = {(AON_FUNC_SEL_BASE+0x8)>>CPU_SHIFT, 14, 2},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x24)>>CPU_SHIFT, 18, 1},
        .ioCfg      = {(IO_CFG_BASE+0x18)>>CPU_SHIFT, 0, 8},
    },

	[SD1_DATA1] = {
        .name       = "sd1_data1",
		.gpio       = GPIO75,
		.flag       = 0,        
		.pdFuncSel  = {(PD_FUNC_SEL_BASE+0x8)>>CPU_SHIFT, 4, 2},
        .aonFuncSel = {(AON_FUNC_SEL_BASE+0x8)>>CPU_SHIFT, 16, 2},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x24)>>CPU_SHIFT, 19, 1},
        .ioCfg      = {(IO_CFG_BASE+0x18)>>CPU_SHIFT, 8, 8},
    },

	[SD1_DATA2] = {
        .name       = "sd1_data2",
		.gpio       = GPIO76,
		.flag       = 0,        
		.pdFuncSel  = {(PD_FUNC_SEL_BASE+0x8)>>CPU_SHIFT, 6, 2},
        .aonFuncSel = {(AON_FUNC_SEL_BASE+0x8)>>CPU_SHIFT, 18, 2},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x24)>>CPU_SHIFT, 20, 1},
        .ioCfg      = {(IO_CFG_BASE+0x18)>>CPU_SHIFT, 16, 8},
    },

	[SD1_DATA3] = {
        .name       = "sd1_data3",
		.gpio       = GPIO77,
		.flag       = 0,        
		.pdFuncSel  = {(PD_FUNC_SEL_BASE+0x8)>>CPU_SHIFT, 8, 2},
        .aonFuncSel = {(AON_FUNC_SEL_BASE+0x8)>>CPU_SHIFT, 20, 2},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x24)>>CPU_SHIFT, 21, 1},
        .ioCfg      = {(IO_CFG_BASE+0x18)>>CPU_SHIFT, 24, 8},
    },

	[JTAG_TCK] = {
        .name       = "jtag_tck",
		.gpio       = GPIO78,
		.flag       = 0,
        .pdFuncSel  = {(PD_FUNC_SEL_BASE+0xc)>>CPU_SHIFT, 0, 2},
        .aonFuncSel = {(AON_FUNC_SEL_BASE+0xc)>>CPU_SHIFT, 0, 2},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x24)>>CPU_SHIFT, 22, 1},
        .ioCfg      = {(IO_CFG_BASE+0x1c)>>CPU_SHIFT, 0, 2},
    },

	[JTAG_TDI] = {
        .name       = "jtag_tdi",
		.gpio       = GPIO79,
		.flag       = 0,      
		.pdFuncSel  = {(PD_FUNC_SEL_BASE+0xc)>>CPU_SHIFT, 2, 2},
        .aonFuncSel = {(AON_FUNC_SEL_BASE+0xc)>>CPU_SHIFT, 2, 2},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x24)>>CPU_SHIFT, 23, 1},
        .ioCfg      = {(IO_CFG_BASE+0x1c)>>CPU_SHIFT, 2, 2},
    },

	[JTAG_TDO] = {
        .name       = "jtag_tdo",
		.gpio       = GPIO80,
		.flag       = 0,      
		.pdFuncSel  = {(PD_FUNC_SEL_BASE+0xc)>>CPU_SHIFT, 4, 2},
        .aonFuncSel = {(AON_FUNC_SEL_BASE+0xc)>>CPU_SHIFT, 4, 2},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x24)>>CPU_SHIFT, 24, 1},
        .ioCfg      = {(IO_CFG_BASE+0x1c)>>CPU_SHIFT, 4, 2},
    },

	[JTAG_TMS] = {
        .name       = "jtag_tms",
		.gpio       = GPIO81,
		.flag       = 0,      
		.pdFuncSel  = {(PD_FUNC_SEL_BASE+0xc)>>CPU_SHIFT, 6, 2},
        .aonFuncSel = {(AON_FUNC_SEL_BASE+0xc)>>CPU_SHIFT, 6, 2},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x24)>>CPU_SHIFT, 25, 1},
        .ioCfg      = {(IO_CFG_BASE+0x1c)>>CPU_SHIFT, 6, 2},
    },

	[JTAG_TRST] = {
        .name       = "jtag_trst",
		.gpio       = GPIO82,
		.flag       = 0,      
		.pdFuncSel  = {(PD_FUNC_SEL_BASE+0xc)>>CPU_SHIFT, 8, 2},
        .aonFuncSel = {(AON_FUNC_SEL_BASE+0xc)>>CPU_SHIFT, 8, 2},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x24)>>CPU_SHIFT, 26, 1},
        .ioCfg      = {(IO_CFG_BASE+0x1c)>>CPU_SHIFT, 8, 2},
    },

	[KBC_0] = {
        .name       = "kbc_0",
		.gpio       = GPIO83,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {(AON_FUNC_SEL_BASE+0xc)>>CPU_SHIFT, 10, 2},
        .topFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .ioCfg      = {(IO_CFG_BASE+0x1c)>>CPU_SHIFT, 10, 2},
    },

	[KBC_1] = {
        .name       = "kbc_1",
		.gpio       = GPIO84,
		.flag       = 0,
		.pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {(AON_FUNC_SEL_BASE+0xc)>>CPU_SHIFT, 12, 2},
        .topFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .ioCfg      = {(IO_CFG_BASE+0x1c)>>CPU_SHIFT, 12, 2},
    },

	[KBR_0] = {
        .name       = "kbr_0",
		.gpio       = GPIO85,
		.flag       = 0,
		.pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {(AON_FUNC_SEL_BASE+0xc)>>CPU_SHIFT, 14, 2},
        .topFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .ioCfg      = {(IO_CFG_BASE+0x1c)>>CPU_SHIFT, 14, 2},
    },

	[KBR_1] = {
        .name       = "kbr_1",
		.gpio       = GPIO86,
		.flag       = 0,
		.pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {(AON_FUNC_SEL_BASE+0xc)>>CPU_SHIFT, 16, 2},
        .topFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .ioCfg      = {(IO_CFG_BASE+0x1c)>>CPU_SHIFT, 16, 2},
    },	

	[CAM_SPI_CS] = {
        .name       = "cam_spi_cs",
		.gpio       = GPIO87,
		.flag       = 0,
		.pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x28)>>CPU_SHIFT, 0, 1},
        .ioCfg      = {(IO_CFG_BASE+0x1c)>>CPU_SHIFT, 18, 2},
    },	
    
    [CAM_SPI_CLK] = {
        .name       = "cam_spi_clk",
		.gpio       = GPIO88,
		.flag       = 0,
		.pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x28)>>CPU_SHIFT, 1, 1},
        .ioCfg      = {(IO_CFG_BASE+0x1c)>>CPU_SHIFT, 20, 2},
    },    
    
    [CAM_SPI_DATA0] = {
        .name       = "cam_spi_data0",
		.gpio       = GPIO89,
		.flag       = 0,
		.pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x28)>>CPU_SHIFT, 2, 1},
        .ioCfg      = {(IO_CFG_BASE+0x1c)>>CPU_SHIFT, 22, 2},
    },    
    
    [CAM_SPI_DATA1] = {
        .name       = "cam_spi_data1",
		.gpio       = GPIO90,
		.flag       = 0,
		.pdFuncSel  = {(PD_FUNC_SEL_BASE+0xc)>>CPU_SHIFT, 10, 1},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x28)>>CPU_SHIFT, 3, 1},
        .ioCfg      = {(IO_CFG_BASE+0x1c)>>CPU_SHIFT, 24, 2},
    },    
    
    [CAM_SPI_DATA2] = {
        .name       = "cam_spi_data2",
		.gpio       = GPIO91,
		.flag       = 0,
		.pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x28)>>CPU_SHIFT, 4, 1},
        .ioCfg      = {(IO_CFG_BASE+0x1c)>>CPU_SHIFT, 26, 2},
    },    
    
    [CAM_SPI_DATA3] = {
        .name       = "cam_spi_data3",
		.gpio       = GPIO92,
		.flag       = 0,
		.pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x28)>>CPU_SHIFT, 5, 1},
        .ioCfg      = {(IO_CFG_BASE+0x1c)>>CPU_SHIFT, 28, 2},
    },
    
    [SPIFC_CS] = {
        .name       = "spifc_cs",
		.gpio       = GPIO93,
		.flag       = 0,
		.pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x28)>>CPU_SHIFT, 6, 1},
        .ioCfg      = {(IO_CFG_BASE+0x20)>>CPU_SHIFT, 0, 2},
    },	
    
    [SPIFC_CLK] = {
        .name       = "spifc_clk",
		.gpio       = GPIO94,
		.flag       = 0,
		.pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x28)>>CPU_SHIFT, 7, 1},
        .ioCfg      = {(IO_CFG_BASE+0x20)>>CPU_SHIFT, 2, 2},
    },    
    
    [SPIFC_DATA0] = {
        .name       = "spifc_data0",
		.gpio       = GPIO95,
		.flag       = 0,
		.pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x28)>>CPU_SHIFT, 8, 1},
        .ioCfg      = {(IO_CFG_BASE+0x20)>>CPU_SHIFT, 4, 2},
    },    
    
    [SPIFC_DATA1] = {
        .name       = "spifc_data1",
		.gpio       = GPIO96,
		.flag       = 0,
		.pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x28)>>CPU_SHIFT, 9, 1},
        .ioCfg      = {(IO_CFG_BASE+0x20)>>CPU_SHIFT, 6, 2},
    },    
    
    [SPIFC_DATA2] = {
        .name       = "spifc_data2",
		.gpio       = GPIO97,
		.flag       = 0,
		.pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x28)>>CPU_SHIFT, 10, 1},
        .ioCfg      = {(IO_CFG_BASE+0x20)>>CPU_SHIFT, 8, 2},
    },    
    
    [SPIFC_DATA3] = {
        .name       = "spifc_data3",
		.gpio       = GPIO98,
		.flag       = 0,
		.pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x28)>>CPU_SHIFT, 11, 1},
        .ioCfg      = {(IO_CFG_BASE+0x20)>>CPU_SHIFT, 10, 2},
    },    
    
    [RESETB_OUT] = {
        .name       = "resetb_out",
		.gpio       = GPIO99,
		.flag       = 0,
		.pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .ioCfg      = {(IO_CFG_BASE+0x20)>>CPU_SHIFT, 12, 2},
    },

	[RF_SPI_STR] = {
        .name       = "rf_spi_str",
		.gpio       = GPIO100,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x28)>>CPU_SHIFT, 12, 1},
        .ioCfg      = {(IO_CFG_BASE+0x20)>>CPU_SHIFT, 14, 2},
    },
	
	[RF_SPI_CLK] = {
        .name       = "rf_spi_clk",
		.gpio       = GPIO101,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x28)>>CPU_SHIFT, 13, 1},
        .ioCfg      = {(IO_CFG_BASE+0x20)>>CPU_SHIFT, 16, 2},
    },

	[RF_SPI_DATA] = {
        .name       = "rf_spi_data",
		.gpio       = GPIO102,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x28)>>CPU_SHIFT, 14, 1},
        .ioCfg      = {(IO_CFG_BASE+0x20)>>CPU_SHIFT, 18, 2},
    },	
    
    [RF_ISOLATE_EN] = {
        .name       = "rf_isolate_en",
		.gpio       = GPIO103,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .ioCfg      = {(IO_CFG_BASE+0x20)>>CPU_SHIFT, 20, 2},
    },

	[RF_CONTROL0] = {
        .name       = "rf_control0",
		.gpio       = GPIO104,
		.flag       = 0,
        .pdFuncSel  = {(PD_FUNC_SEL_BASE+0x10)>>CPU_SHIFT, 0, 10},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x28)>>CPU_SHIFT, 15, 1},
        .ioCfg      = {(IO_CFG_BASE+0x24)>>CPU_SHIFT, 0, 2},
    },

	[RF_CONTROL1] = {
        .name       = "rf_control1",
		.gpio       = GPIO105,
		.flag       = 0,
        .pdFuncSel  = {(PD_FUNC_SEL_BASE+0x10)>>CPU_SHIFT, 10, 10},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x28)>>CPU_SHIFT, 16, 1},
        .ioCfg      = {(IO_CFG_BASE+0x24)>>CPU_SHIFT, 2, 2},
    },

	[RF_CONTROL2] = {
        .name       = "rf_control2",
		.gpio       = GPIO106,
		.flag       = 0,
        .pdFuncSel  = {(PD_FUNC_SEL_BASE+0x10)>>CPU_SHIFT, 20, 10},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x28)>>CPU_SHIFT, 17, 1},
        .ioCfg      = {(IO_CFG_BASE+0x24)>>CPU_SHIFT, 4, 2},
    },

	[RF_CONTROL3] = {
        .name       = "rf_control3",	
		.gpio       = GPIO107,
		.flag       = 0,
        .pdFuncSel  = {(PD_FUNC_SEL_BASE+0x14)>>CPU_SHIFT, 0, 10},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x28)>>CPU_SHIFT, 18, 1},
        .ioCfg      = {(IO_CFG_BASE+0x24)>>CPU_SHIFT, 6, 2},
    },

	[RF_CONTROL4] = {
        .name       = "rf_control4",	
		.gpio       = GPIO108,
		.flag       = 0,
        .pdFuncSel  = {(PD_FUNC_SEL_BASE+0x14)>>CPU_SHIFT, 10, 10},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x28)>>CPU_SHIFT, 19, 1},
        .ioCfg      = {(IO_CFG_BASE+0x24)>>CPU_SHIFT, 8, 2},
    },

	[RF_CONTROL5] = {
        .name       = "rf_control5",	
		.gpio       = GPIO109,
		.flag       = 0,
        .pdFuncSel  = {(PD_FUNC_SEL_BASE+0x14)>>CPU_SHIFT, 20, 10},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x28)>>CPU_SHIFT, 20, 1},
        .ioCfg      = {(IO_CFG_BASE+0x24)>>CPU_SHIFT, 10, 2},
    },

	[RF_CONTROL6] = {
        .name       = "rf_control6",		
		.gpio       = GPIO110,
		.flag       = 0,
        .pdFuncSel  = {(PD_FUNC_SEL_BASE+0x18)>>CPU_SHIFT, 0, 10},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x28)>>CPU_SHIFT, 21, 1},
        .ioCfg      = {(IO_CFG_BASE+0x24)>>CPU_SHIFT, 12, 2},
    },

	[RF_CONTROL7] = {
        .name       = "rf_control7",
		.gpio       = GPIO111,
		.flag       = 0,
        .pdFuncSel  = {(PD_FUNC_SEL_BASE+0x18)>>CPU_SHIFT, 10, 10},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x28)>>CPU_SHIFT, 22, 1},
        .ioCfg      = {(IO_CFG_BASE+0x24)>>CPU_SHIFT, 14, 2},
    },

	[RF_CONTROL8] = {
        .name       = "rf_control8",		
		.gpio       = GPIO112,
		.flag       = 0,
        .pdFuncSel  = {(PD_FUNC_SEL_BASE+0x18)>>CPU_SHIFT, 20, 10},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x28)>>CPU_SHIFT, 23, 1},
        .ioCfg      = {(IO_CFG_BASE+0x24)>>CPU_SHIFT, 16, 2},
    },

	[RF_CONTROL9] = {
        .name       = "rf_control9",
		.gpio       = GPIO113,
		.flag       = 0,
         .pdFuncSel  = {(PD_FUNC_SEL_BASE+0x1c)>>CPU_SHIFT, 0, 10},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x28)>>CPU_SHIFT, 24, 1},
        .ioCfg      = {(IO_CFG_BASE+0x24)>>CPU_SHIFT, 18, 2},
    },

	[RF_CONTROL10] = {
        .name       = "rf_control10",
		.gpio       = GPIO114,
		.flag       = 0,      
		.pdFuncSel  = {(PD_FUNC_SEL_BASE+0x1c)>>CPU_SHIFT, 10, 10},
        .aonFuncSel = {(AON_FUNC_SEL_BASE+0xc)>>CPU_SHIFT, 18, 2},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x28)>>CPU_SHIFT, 25, 1},
        .ioCfg      = {(IO_CFG_BASE+0x24)>>CPU_SHIFT, 20, 2},
    },

	[RF_CONTROL11] = {
        .name       = "rf_control11",
		.gpio       = GPIO115,
		.flag       = 0,      
		.pdFuncSel  = {(PD_FUNC_SEL_BASE+0x1c)>>CPU_SHIFT, 20, 10},
        .aonFuncSel = {(AON_FUNC_SEL_BASE+0xc)>>CPU_SHIFT, 20, 2},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x28)>>CPU_SHIFT, 26, 1},
        .ioCfg      = {(IO_CFG_BASE+0x24)>>CPU_SHIFT, 22, 2},
    },

	[RF_CONTROL12] = {
        .name       = "rf_control12",
		.gpio       = GPIO133,
		.flag       = 0,      
		.pdFuncSel  = {(PD_FUNC_SEL_BASE+0x20)>>CPU_SHIFT, 0, 10},
        .aonFuncSel = {(AON_FUNC_SEL_BASE+0x8)>>CPU_SHIFT, 22, 2},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x28)>>CPU_SHIFT, 27, 1},
        .ioCfg      = {(IO_CFG_BASE+0x40)>>CPU_SHIFT, 0, 8},
    },

	[RF_CONTROL13] = {
        .name       = "rf_control13",
		.gpio       = GPIO134,
		.flag       = 0,	
		.pdFuncSel  = {(PD_FUNC_SEL_BASE+0x20)>>CPU_SHIFT, 10, 10},
        .aonFuncSel = {(AON_FUNC_SEL_BASE+0x8)>>CPU_SHIFT, 24, 2},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x28)>>CPU_SHIFT, 28, 1},
        .ioCfg      = {(IO_CFG_BASE+0x40)>>CPU_SHIFT, 8, 8},
    },

	[RF_CONTROL14] = {
        .name       = "rf_control14",
		.gpio       = GPIO135,
		.flag       = 0,	
		.pdFuncSel  = {(PD_FUNC_SEL_BASE+0x20)>>CPU_SHIFT, 20, 10},
        .aonFuncSel = {(AON_FUNC_SEL_BASE+0x8)>>CPU_SHIFT, 26, 2},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x28)>>CPU_SHIFT, 29, 1},
        .ioCfg      = {(IO_CFG_BASE+0x40)>>CPU_SHIFT, 16, 8},
    },		
    
    [SIM_RST] = {
        .name       = "sim_rst",
		.gpio       = GPIO116,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {(AON_FUNC_SEL_BASE+0xc)>>CPU_SHIFT, 22, 2},
        .topFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .ioCfg      = {(IO_CFG_BASE+0x28)>>CPU_SHIFT, 0, 8},
    },

	[SIM_CLK] = {
        .name       = "sim_clk",
		.gpio       = GPIO117,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {(AON_FUNC_SEL_BASE+0xc)>>CPU_SHIFT, 24, 2},
        .topFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .ioCfg      = {(IO_CFG_BASE+0x28)>>CPU_SHIFT, 0, 8},
    },

	[SIM_DATA] = {
        .name       = "sim_data",
		.gpio       = GPIO118,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {(AON_FUNC_SEL_BASE+0xc)>>CPU_SHIFT, 26, 2},
        .topFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .ioCfg      = {(IO_CFG_BASE+0x28)>>CPU_SHIFT, 8, 8},
    },	
    
    [GPIO_119] = {
        .name       = "gpio119",
		.gpio       = GPIO119,
		.flag       = 0,      
		.pdFuncSel  = {(PD_FUNC_SEL_BASE+0x28)>>CPU_SHIFT, 0, 2},
        .aonFuncSel = {(AON_FUNC_SEL_BASE+0x10)>>CPU_SHIFT, 0, 2},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x2c)>>CPU_SHIFT, 0, 1},
        .ioCfg      = {(IO_CFG_BASE+0x2c)>>CPU_SHIFT, 0, 2},
    },    
    
    [GPIO_120] = {
        .name       = "gpio120",
		.gpio       = GPIO120,
		.flag       = 0,      
		.pdFuncSel  = {(PD_FUNC_SEL_BASE+0x28)>>CPU_SHIFT, 2, 2},
        .aonFuncSel = {(AON_FUNC_SEL_BASE+0x10)>>CPU_SHIFT, 2, 2},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x2c)>>CPU_SHIFT, 1, 1},
        .ioCfg      = {(IO_CFG_BASE+0x2c)>>CPU_SHIFT, 2, 2},
    },    
    
    [GPIO_121] = {
        .name       = "gpio121",
		.gpio       = GPIO121,
		.flag       = 0,      
		.pdFuncSel  = {(PD_FUNC_SEL_BASE+0x28)>>CPU_SHIFT, 4, 2},
        .aonFuncSel = {(AON_FUNC_SEL_BASE+0x10)>>CPU_SHIFT, 4, 2},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x2c)>>CPU_SHIFT, 2, 1},
        .ioCfg      = {(IO_CFG_BASE+0x2c)>>CPU_SHIFT, 4, 2},
    },    
    
    [GPIO_122] = {
        .name       = "gpio122",
		.gpio       = GPIO122,
		.flag       = 0,      
		.pdFuncSel  = {(PD_FUNC_SEL_BASE+0x28)>>CPU_SHIFT, 6, 2},
        .aonFuncSel = {(AON_FUNC_SEL_BASE+0x10)>>CPU_SHIFT, 6, 2},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x2c)>>CPU_SHIFT, 3, 1},
        .ioCfg      = {(IO_CFG_BASE+0x2c)>>CPU_SHIFT, 6, 2},
    },    
    
    [GPIO_123] = {
        .name       = "gpio123",
		.gpio       = GPIO123,
		.flag       = 0,      
		.pdFuncSel  = {(PD_FUNC_SEL_BASE+0x28)>>CPU_SHIFT, 8, 2},
        .aonFuncSel = {(AON_FUNC_SEL_BASE+0x10)>>CPU_SHIFT, 8, 2},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x2c)>>CPU_SHIFT, 4, 1},
        .ioCfg      = {(IO_CFG_BASE+0x2c)>>CPU_SHIFT, 8, 2},
    },    
    
    [GPIO_124] = {
        .name       = "gpio124",
		.gpio       = GPIO124,
		.flag       = 0,      
		.pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {(AON_FUNC_SEL_BASE+0x10)>>CPU_SHIFT, 10, 2},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x2c)>>CPU_SHIFT, 5, 1},
        .ioCfg      = {(IO_CFG_BASE+0x2c)>>CPU_SHIFT, 10, 2},
    },    
    
    [GPIO_125] = {
        .name       = "gpio125",
		.gpio       = GPIO125,
		.flag       = 0,      
		.pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {(AON_FUNC_SEL_BASE+0x10)>>CPU_SHIFT, 12, 2},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x2c)>>CPU_SHIFT, 6, 1},
        .ioCfg      = {(IO_CFG_BASE+0x2c)>>CPU_SHIFT, 12, 2},
    },    
    
    [GPIO_126] = {
        .name       = "gpio126",
		.gpio       = GPIO126,
		.flag       = 0,      
		.pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {(AON_FUNC_SEL_BASE+0x10)>>CPU_SHIFT, 14, 2},
        .topFuncSel = {(TOP_FUNC_SEL_BASE+0x2c)>>CPU_SHIFT, 7, 1},
        .ioCfg      = {(IO_CFG_BASE+0x2c)>>CPU_SHIFT, 14, 2},
    },    
    
    [GPIO_127] = {
        .name       = "gpio127",
		.gpio       = GPIO127,
		.flag       = 0,      
		.pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {(AON_FUNC_SEL_BASE+0x10)>>CPU_SHIFT, 16, 2},
        .topFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .ioCfg      = {(IO_CFG_BASE+0x2c)>>CPU_SHIFT, 16, 2},
    },    
    
    [GPIO_128] = {
        .name       = "gpio128",
		.gpio       = GPIO128,
		.flag       = 0,      
		.pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {(AON_FUNC_SEL_BASE+0x10)>>CPU_SHIFT, 18, 2},
        .topFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .ioCfg      = {(IO_CFG_BASE+0x2c)>>CPU_SHIFT, 18, 2},
    },    
    
    [GPIO_129] = {
        .name       = "gpio129",
		.gpio       = GPIO129,
		.flag       = 0,      
		.pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {(AON_FUNC_SEL_BASE+0x10)>>CPU_SHIFT, 20, 2},
        .topFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .ioCfg      = {(IO_CFG_BASE+0x2c)>>CPU_SHIFT, 20, 2},
    },    
    
    [GPIO_130] = {
        .name       = "gpio130",
		.gpio       = GPIO130,
		.flag       = 0,      
		.pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {(AON_FUNC_SEL_BASE+0x10)>>CPU_SHIFT, 22, 2},
        .topFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .ioCfg      = {(IO_CFG_BASE+0x2c)>>CPU_SHIFT, 22, 2},
    },    
    
    [GPIO_131] = {
        .name       = "gpio131",
		.gpio       = GPIO131,
		.flag       = 0,      
		.pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {(AON_FUNC_SEL_BASE+0x10)>>CPU_SHIFT, 24, 2},
        .topFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .ioCfg      = {(IO_CFG_BASE+0x2c)>>CPU_SHIFT, 24, 2},
    },    
    
    [GPIO_132] = {
        .name       = "gpio132",
		.gpio       = GPIO132,
		.flag       = 0,      
		.pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {(AON_FUNC_SEL_BASE+0x10)>>CPU_SHIFT, 26, 2},
        .topFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .ioCfg      = {(IO_CFG_BASE+0x2c)>>CPU_SHIFT, 26, 2},
    },
	
};

UINT32 gGpioNumMax = sizeof(gGpioInfoTable) / sizeof(T_Gpio);
		
