#include <dma_cfg.h>


#ifdef LYNQ_NV_CFG_SUPPORT
#include "../rsa/drv_rsa.h"
#include "../hash/drv_hash.h"
#include "lynq_uboot_nv_cfg.h"
#include "oem_nv_cfg.h"

#define LYNQ_ERROR(t) do{BOOT_PRINTF(UBOOT_NOTICE, t);}while(0)

#define DEBUG_LYNQ_NV_CFG 1

#ifdef DEBUG_LYNQ_NV_CFG
#define LYNQ_DEBUG(t) do{BOOT_PRINTF(UBOOT_NOTICE, t);}while(0)
extern void lynq_hex_display(u32 * buff, int len);
#else
#define lynq_hex_display(...) do{}while(0)
#define LYNQ_DEBUG(t) do{}while(0)
#endif

char* get_oem_nv_cfg(void)
{
    struct lynq_nv_cfg * oem_cfg, *lynq_cfg;
    int content_len, pos, len, x;
    T_Rsa_Paramter sRSAInput;
    u32 uiRet = -1;
    u32 uiHashResArr[4] = {0};
    u32 uiHashResLen = 0;
    u32 uiRsaResArr[RSA_U32_LEN] = {0};
    u32 puiArrPubKey[RSA_U32_LEN*2] = {0};
    u32 *puiRsaResAddr = NULL;
    char * tmp_buffer = malloc(MMC_LYNQ_NV_CFG_SIZE*3);
    memset(tmp_buffer, 0 , MMC_LYNQ_NV_CFG_SIZE*3);
    oem_cfg = (struct lynq_nv_cfg *)tmp_buffer;
    lynq_cfg = (struct lynq_nv_cfg *)lynq_nv_cfg_value;
    if (sizeof (oem_nv_cfg_publickey) != LYNQ_NV_CFG_PUBLICKEY_LEN)
    {
        LYNQ_ERROR("got bad oem public key\n");
        goto fail_exit;
    }
    if (sizeof (oem_nv_cfg_sign) != LYNQ_NV_CFG_SIGN_LEN )
    {
        LYNQ_ERROR("got bad oem sign\n");
        goto fail_exit;
    }
    if (sizeof(oem_nv_cfg_value) == sizeof(struct lynq_nv_cfg))
    {
        pos = 0;
        len = sizeof(oem_nv_cfg_value);
        memcpy(oem_cfg, oem_nv_cfg_value, len);
        pos += len;
        content_len = ((char*)&oem_cfg->tail - (char*)&oem_cfg->head) - sizeof (struct lynq_nv_cfg_header);
        if (oem_cfg->head.magic_flag == 0xaa55 && oem_cfg->tail.magic_flag == 0x55aa
                && oem_cfg->head.content_len == content_len  && oem_cfg->tail.content_len == content_len
                && oem_cfg->head.valid_flag == 1 && oem_cfg->tail.valid_flag == 1)
        {
            len = sizeof (oem_nv_cfg_version);
            memcpy(tmp_buffer+pos, oem_nv_cfg_version, len);
            pos += len;

            len = sizeof (lynq_nv_cfg_bitmap);
            memcpy(tmp_buffer+pos, lynq_nv_cfg_bitmap, len);
            pos += len;

            len = sizeof (oem_nv_cfg_bitmap);
            memcpy(tmp_buffer+pos, oem_nv_cfg_bitmap, len);
            pos += len;

            for(x=0; x < sizeof(lynq_nv_cfg_bitmap); x++)
            {
                oem_cfg->content[x] &= oem_nv_cfg_bitmap[x];
                oem_cfg->content[x] |= (lynq_cfg->content[x] & (~lynq_nv_cfg_bitmap[x]));
            }

            memcpy(puiArrPubKey, oem_nv_cfg_publickey, RSA_BYTE_LEN);
            memcpy((puiArrPubKey+(RSA_U32_LEN*2 -1)), oem_nv_cfg_publickey + RSA_BYTE_LEN, sizeof(u32));
            sRSAInput.udCalMode = RSA_MOD_EXPO_WITH_INIT;
            sRSAInput.udNbitLen = RAS_BIT_LEN;
            sRSAInput.udEbitLen = RAS_BIT_LEN;
            sRSAInput.pudInputM = (u32*)oem_nv_cfg_sign;
            sRSAInput.pudInputE = (u32*)puiArrPubKey + RSA_U32_LEN;
            sRSAInput.pudInputN = ((u32*)puiArrPubKey);
            sRSAInput.pudOutputP = uiRsaResArr;

            lynq_hex_display(sRSAInput.pudInputE, RSA_U32_LEN);
            lynq_hex_display(sRSAInput.pudInputN, RSA_U32_LEN);
            lynq_hex_display(sRSAInput.pudInputM, RSA_U32_LEN);

            uiRet = Rsa_Calculate(sRSAInput);
            if(uiRet != 0)
            {
                LYNQ_ERROR("oem calc rsa fail\n");
                goto fail_exit;
            }

            lynq_hex_display(uiRsaResArr, RSA_U32_LEN);

            uiRet = Hash_Calculate(HASH_MODE_MD5,
                                   HASH_SMALL_ENDIAN,
                                   (u32*)tmp_buffer,
                                   pos,
                                   NULL,
                                   0,
                                   uiHashResArr,
                                   &uiHashResLen);
            if(uiRet != 0)
            {
                LYNQ_ERROR("oem calc hash fail\n");
                goto fail_exit;
            }
            lynq_hex_display(uiHashResArr, uiHashResLen);

            puiRsaResAddr = sRSAInput.pudOutputP + (RSA_U32_LEN - uiHashResLen);

            if (memcmp(puiRsaResAddr, uiHashResArr, uiHashResLen*sizeof (u32)) != 0)
            {
                LYNQ_ERROR("not valid oem sign\n");
                goto fail_exit;
            }
        }
        else
        {
            LYNQ_ERROR("not valid oem head\n");
            goto fail_exit;
        }
    }
    else
    {
        LYNQ_ERROR("not valid oem cfg\n");
        goto fail_exit;
    }

    return tmp_buffer;
fail_exit:
    free(tmp_buffer);
    return NULL;
}

#endif

