/*
 * Author(s):    wang.yuesheng
 * Date:         2009-02-26
 * Purpose:
 * Description:  boot˫汾֧
 */
 
#include <config.h>



#ifndef _CMD_DOWNVER_H_
#define _CMD_DOWNVER_H_


/* 汾״̬־λ */
#define CFG_TB_LATELY				0x01	/* 汾¾Ա־λ */
#define CFG_TB_INTACT				0x02	/* 汾Ա־λ */
#define CFG_TB_KERNEL				0x04	/* ںԱ־λ */
#define CFG_TB_ROOTFS				0x08	/* ļϵͳԱ־λ */
#define CFG_TB_SYNCED				0x10	/* 汾Դ־λ   */
#define CFG_TB_HEADER				0x80	/* 汾ͷԱ־λ */

/* ļϵͳͶ */
#define CFG_FS_NONE				0x00	/* none */
#define CFG_FS_INITRAM				0x01	/* initramfs */
#define CFG_FS_JFFS2				0x02	/* jffs2 */
#define CFG_FS_SQUASH				0x04	/* squashfs */

/* ļϵͳ */
#define SQUASHFS_MAGIC				0x73717368
#define SQUASHFS_MAGIC_SWAP		0x68737173
#ifdef __BIG_ENDIAN
#define JFFS2_DIRENT_MAGIC		       0x1985E001
#define JFFS2_INODE_MAGIC			0x1985E002
#define JFFS2_CLEANMARKER_MAGIC	0x19852003
#define JFFS2_PADDING_MAGIC		0x19852004
#define JFFS2_SUMMARY_MAGIC		0x19852006
#define JFFS2_RWDELETE_MAGIC  	0x19850003
#else
#define JFFS2_DIRENT_MAGIC		       0xE0011985
#define JFFS2_INODE_MAGIC			0xE0021985
#define JFFS2_CLEANMARKER_MAGIC	0x20031985
#define JFFS2_PADDING_MAGIC		0x20041985
#define JFFS2_SUMMARY_MAGIC		0x20061985
#define JFFS2_RWDELETE_MAGIC  	0x00031985
#endif
#define CFG_EMPTY_BITMASK			0xFFFFFFFF
#define CFG_IMAGE_OKAY				0x00000000

#define MAGIC_MAX			4		// 
#define DESC_LEN			32		// 汾
#define	RESV_LEN			16		// ֶγ
#define CSP_HEADER_LEN		256		// 汾ͷ
#define CFG_ALLIGN_SIZE     16

/* 汾ͷ */
#define	CSP_MAGIC0		0x99999999
#define CSP_MAGIC1		0x44444444
#define CSP_MAGIC2		0x55555555
#define CSP_MAGIC3		0xaaaaaaaa

#define IMAGE_BAD		0xffffffff	// 汾
#define IMAGE_OKAY		0x00000000	// 汾
#define IMAGE_NEW		0xffffffff	// °汾
#define IMAGE_OLD      	0x00000000	// ɰ汾
#define IMAGE_UPGRADE	0xffffffff	// Դ
#define IMAGE_SYNCED	0x00000000	// Դͬ

/* Э */
#define VOIP_PROTO_NULL      0
#define VOIP_PROTO_H248      1
#define VOIP_PROTO_SIP       2
#define VOIP_PROTO_MGCP      3
#define VOIP_PROTO_UNKNOWN   0xffff

#define	IH_HCRC_OFFSET      (unsigned int)(&((hd_contend_desc*)0)->ih_hcrc)
#define ALIGN_SIZE16(x)     (((x)/16+(((x)%16)?1:0))*16)

typedef enum 
{
    FLASH_TYPE_NAND = 1,
    FLASH_TYPE_NOR = 2,
    FLASH_TYPE_INVALID = 255
}FLASH_TYPE_E;


typedef enum VersionType
{
    VERTYPE_BOOT = 1,
    VERTYPE_KERNEL,
    VERTYPE_ROOTFS,
    VERTYPE_VERSION,
    VERTYPE_INVALID = 255
}VERSION_TYPE_E;


/* ƽ̨汾вƷ */
typedef enum {
	PRODUCT_SERIES_DHOME = 0,
	PRODUCT_SERIES_XPON  = 1,
	PRODUCT_SERIES_STB   = 2,
	PRODUCT_SERIES_RFID  = 3
} PRODUCT_SERIES_ID;

/* 汾: ˫С */
typedef enum {
	VERSION_TYPE_SINGLE  = 0,		/* 汾 */
	VERSION_TYPE_DOUBLE  = 1,		/* ˫汾 */
	VERSION_TYPE_BIGSMALL= 2		/* С汾 */
} VERSION_TYPE_ID;


/* 汾Դ: δ֪ͬ */
typedef enum {
	VERSION_FROM_UPGRAGE = 0,		/* 汾 */
	VERSION_FROM_SYNC    = 1			/* ͬ汾 */
} VERSION_FROM_ID;


typedef struct {
	short	flags;		/* 汾״̬־λ */
	short	fstype;		/* ļϵͳ */
	long	entry;		/* 汾ڵַ */
	unsigned int	ih_size;		/* ں˴С           */
} vstat_t;

typedef struct {
	int		total;		/* İ汾 */
	vstat_t result[2];	/* Ч汾״̬ */
} search_desc;


typedef struct {
	unsigned int	ih_magic[MAGIC_MAX];/* 汾ͷ */
	unsigned int	ih_signatureSize;	/* ǩС */
	char			pSignature[0];		/* ǩ */
} hd_magic_desc;

typedef struct {
	unsigned int	productType;		/* Ʒ࣭DHomeSTBRFID... */
	unsigned int	firewareType;		/* ̼ͣ汾ļbootļļ֤ļ */
	unsigned int	upgradeKey1;		/* ͬһCPEı룬ͬӲͬжƷİ汾 */
	unsigned int	upgradeKey2;		/* ͬһCPEӦж汾ĲͬƷ */
	char			serialNum[16];		/* 汾 */
	unsigned int	headerVersion;		/* ͷ汾ţĿǰ */
	unsigned int	isExpanded;		/* ǷʹøӰ汾ͷӰ汾ͷչ256 ֽ */
	unsigned int	firewareSize;		/* ̼СĿǰ */
}hd_general_desc;

typedef struct {
	unsigned int	btMagic[4];	/* BOOT汾ͷ */
	char			btNumbers[16];		/* BOOT汾 */
	char			btCtime[20];		/* BOOT汾ʱ */
	unsigned int	btVerSize;			/* BOOT汾ĳ */
	unsigned int	btFlashOffset;		/* BOOT汾FlashƫƵַ */
	unsigned int	btFlashSize;		/* BOOT汾FlashС */
} hd_boot_file;


/* 汾ͷ */
typedef struct {
	unsigned short	ih_form;			/* 汾ʽ˫С汾 */
	unsigned short	ih_type;			/* 汾ͣ汾ںˡļϵͳС汾汾*/
	unsigned int	ih_size;			/* 汾 */
	
	unsigned int	ih_kern_size;		/* ں˴С                 */
	unsigned int	ih_kern_offset;	/* ںflashеƫ      */
	unsigned int	ih_kern_dcrc;		/* ںУ               */
	unsigned int	ih_fs_size;		/* ļϵͳС           */
	unsigned int	ih_fs_offset;		/* ļϵͳflashеƫ*/
	unsigned int	ih_fs_dcrc;		/* ļϵͳУ         */

	unsigned int	ih_im0_offset;		/* 汾0flashеƫ     */
	unsigned int	ih_im0_size;		/* 汾0С                */
	unsigned int	ih_fs0_offset;		/* ļϵͳ0flashеƫ */
	unsigned int	ih_fs0_size;		/* ļϵͳ0С            */
	unsigned int	ih_im1_offset;		/* 汾1flashеƫ     */
	unsigned int	ih_im1_size;		/* 汾1С                */
	unsigned int	ih_fs1_offset;		/* ļϵͳ1flashеƫ */
	unsigned int	ih_fs1_size;		/* ļϵͳ1С            */

	char			ih_desc[DESC_LEN];	/* 汾ļ */
	
	/* 2010/03/18, wys, boot汾16ֽ */
	unsigned short	ih_boot_included;	/* Ƿboot汾 */
	unsigned short	ih_boot_upgrade;	/* ǿbootʹ */
	unsigned int	ih_boot_size;		/* boot汾ݳ */
	unsigned int	ih_boot_offset;	/* boot汾ƫ */
	unsigned int	ih_boot_dcrc;		/* boot汾У */
	/* 2010/03/18, wys, end */

	unsigned int	ih_isdefault;		/* Ƿʹԭ汾Ĭ */
	unsigned int	ih_endiantype;		/* С */
	
	unsigned int	ih_hcrc;			/* 汾ͷУ֮ͣǰμУ */
	
	char			ih_time[16];		/* 汾ʱ         */
	unsigned int	ih_isfull;			/* 汾Ƿ         */
	unsigned int	ih_isnewly;		/* ǷΪ°汾       */
	unsigned int	ih_fromsync;		/* 汾Դͬ */
	unsigned int    ih_flashsize;		/* FlashС */
	unsigned short	ih_protocol;		/* 0-NULL, 1-H248, 2-SIP, 3-MGCP */
	unsigned short	ih_compatible;		/* 32MB CSP2102/1027汾Ƿ */
	char			ih_csp_version[8];	/* CSPƽ̨汾ţ磺V1.0.27 */
	char            ih_vidmask[24];     /*֧VID*/
} hd_contend_desc;

typedef struct {
	unsigned int	ih_upgradetimes;
	unsigned int	ih_flashtimes;
} hd_config_file;

typedef struct {
	hd_general_desc	general;
	hd_contend_desc contend;
} header_version;

typedef struct {
	hd_general_desc	general;
	hd_config_file	config;
} header_config;



/* function declarations */
int do_search (unsigned int start, unsigned int end, unsigned int step, search_desc *search);
int do_startup (search_desc *search);
int do_settings (int num, const search_desc *search);

#endif /* _CMD_DOWNVER_H_ */

