/*
 * (C) Copyright 2016, ZIXC Corporation.
 *
 */
#ifndef __CONFIG_H
#define __CONFIG_H

#include "board.h"
#include "../../downloader/downloader_config.h"
#include "dma_cfg.h"

/*================================================================= version ======== */
#define CONFIG_PRINTF               1  /*uart downloader,this should be set to 0*/
//#ifdef CONFIG_ZX297520V3E_MDL_AB
#if defined(CONFIG_ZX297520V3E_MDL_AB) || defined(CONFIG_ZX297520V3E_VEHICLE_DC)  || defined(CONFIG_ZX297520V3E_VEHICLE_DC_REF)
#define VERSION_RELEASE             1
#else
#define VERSION_RELEASE             0
#endif
#define CONFIG_USB_DL               1
#define CONFIG_UART_DL              0

/*==================================================================== gpio ======== */
#define	CONFIG_ZX75XX_LED		    1
#define CONFIG_ZX75XX_KEY           1


/*==================================================================== pmu ========= */
#include <module/pmu.h>


#define WORK_MODE_AMT				3
#define WORK_MODE_PRODUCTION		2
#define WORK_MODE_DEVELOPMENT		1
#define WORK_MODE_USER				0


/*=============================================================== modle config ===== */
#define	CONFIG_MODLE_LCD		    0

#define	CONFIG_MODLE_CHARGER		0
#define CONFIG_PMU_LOW_BATTERY      3100
#define CONFIG_PMU_FULL_BATTERY     4200
#define CONFIG_MAX_TIME_OUT         (20*1000000)    /* 20s */

/*=============================================================== cpu & boar ======= */
#define CONFIG_IDENT_STRING	    " for ZXIC "


/*================================================================ debub & log ===== */
#define NAND_DOWN_LOAD_CMD          1       /* 汾أӡ */
#define LOAD_IMAGE_CRC              1       /* 汾У */
#define LOAD_IMAGE_DEBUG            1
#define NAND_BAD_DEBUG              1
#define PRINTF_PARTITION_TABLE      1
#define TIME_DEBUG                  1
#define ZFTL_DEBUG                  1
#define DENALI_DEBUG                1
#define SPI_NAND_DEBUG              0
#define DEBUG                       1
#define CONFIG_DISPLAY_CPUINFO      1
#define CONFIG_DISPLAY_BOARDINFO    1
#define CONFIG_MTD_DEBUG            0
#define CONFIG_MTD_DEBUG_VERBOSE    2
#define CONFIG_MUTUAL_DEBUG         0       /* ʱʹãڿ̨Ľ */

/*================================================================== mmu =========== */
#define CONFIG_ENABLE_MMU           1
#if CONFIG_ZX297520V3T_64M_UBOOT
#define CONFIG_NAND_DMA_BUF_ADDR    0x23A00000
#elif CONFIG_ZX297520V3T_128M_UBOOT
#define CONFIG_NAND_DMA_BUF_ADDR    0x27A00000
#else
#define CONFIG_NAND_DMA_BUF_ADDR    0x21A00000
#endif

#define CONFIG_USB_DMA_BUF_ADDR     0x20000000
#define CONFIG_GMAC_DMA_BUF_ADDR    DOWNLOADER_BUFFER_BASE

/*================================================================ cache =========== */
#define CONFIG_SYS_ICACHE           1
#define CONFIG_SYS_DCACHE           1
#if !CONFIG_SYS_ICACHE
#define  CONFIG_SYS_ICACHE_OFF
#endif
#if !CONFIG_SYS_DCACHE
#define  CONFIG_SYS_DCACHE_OFF
#endif

/*================================================================== int =========== */
#define CONFIG_USE_IRQ          0
#define CONFIG_STACKSIZE_IRQ    (4*1024)
#define CONFIG_STACKSIZE_FIQ    (4*1024)
#define CONFIG_USE_VIC          0           /* ʹжϿ */
#define CONFIG_VIC_BASE	        0x0080000B
#define CONFIG_PERIPORT_SIZE	0x13

#define     CFG_TLOAD_MODE  0x87654321      /* ͬ LOADER */
#define     CFG_ZLOAD_MODE  0x12345678      /* ͬ LOADER */

#define     CFG_START_MODE_NAND         0x11111111              /* IRAM1 <--> U-BOOT */
#define     CFG_START_MODE_SPI_NAND     0x22222222              /* IRAM1 <--> U-BOOT */
#define     CFG_START_MODE_SDIO         0x33333333              /* IRAM1 <--> U-BOOT */
#define     CFG_START_MODE_EMMC         0x44444444              /* IRAM1 <--> U-BOOT */
#define     CFG_START_MODE_NOR          0x55555555              /* IRAM1 <--> U-BOOT */



/* ================================================================== iram ========= */
#define CONFIG_SYS_IRAM_BASE    0x82000000  /* Internal SRAM base address */
#define CONFIG_SYS_IRAM_SIZE    0x8000      /* 8 KB of internal SRAM memory */
#define CONFIG_SYS_IRAM_END     (CONFIG_SYS_IRAM_BASE + CONFIG_SYS_IRAM_SIZE)
#define CONFIG_SYS_INIT_SP_ADDR (CONFIG_SYS_IRAM_END - GENERATED_GBL_DATA_SIZE)


/* ================================================================== ddr ========== */
#define CONFIG_NR_DRAM_BANKS	        1
#define CONFIG_SYS_SDRAM_BASE	    0x20000800              /*2k DDR for soc test*/
#define PHYS_SDRAM_1		        CONFIG_SYS_SDRAM_BASE	/* SDRAM Bank #1	*/

#if CONFIG_ZX297520V3T_64M_UBOOT
#define PHYS_SDRAM_1_SIZE	        	0x04000000      /* 64MB */
#define CONFIG_SYS_SDRAM_SIZE	    	0x04000000	    /* 64MB in DDR */
#define CONFIG_SYS_SDRAM_CUTDOWN_SIZE	0x01000000
#define CONFIG_SYS_SDRAM_IMAGEFS_BASE	0x22300000
#define CONFIG_SYS_SDRAM_IMAGEFS_END	0x23000000
#define CONFIG_SYS_SDRAM_IMAGEFS_SIZE	(CONFIG_SYS_SDRAM_IMAGEFS_END - CONFIG_SYS_SDRAM_IMAGEFS_BASE)
#elif CONFIG_ZX297520V3T_128M_UBOOT
#define PHYS_SDRAM_1_SIZE	        	0x08000000     	/* 128MB */
#define CONFIG_SYS_SDRAM_SIZE	    	0x08000000	   	/* 128MB in DDR */
#define CONFIG_SYS_SDRAM_IMAGEFS_BASE	0x25000000
#define CONFIG_SYS_SDRAM_IMAGEFS_END	0x27000000
#define CONFIG_SYS_SDRAM_IMAGEFS_SIZE	(CONFIG_SYS_SDRAM_IMAGEFS_END - CONFIG_SYS_SDRAM_IMAGEFS_BASE)

#else
#define PHYS_SDRAM_1_SIZE	        	0x02000000     	/* 32MB */
#define CONFIG_SYS_SDRAM_SIZE	    	0x02000000	   	/* 32MB in DDR */
#define CONFIG_SYS_SDRAM_IMAGEFS_BASE	0x20C00000
#define CONFIG_SYS_SDRAM_IMAGEFS_END	0x21400000
#define CONFIG_SYS_SDRAM_IMAGEFS_SIZE	(CONFIG_SYS_SDRAM_IMAGEFS_END - CONFIG_SYS_SDRAM_IMAGEFS_BASE)
#endif

#define CONFIG_SYS_SDRAM_TEMP_BASE		0x21400000  	/* ddrݰ汾ʱַ */
#define CONFIG_SYS_SDRAM_TEMP_LZMA  	0X21600000  	/* ַڽѹ汾ʱʹ */
#define CONFIG_SYS_SDRAM_ROOTFS_BASE	0x25000000

#define CONFIG_SYS_SDRAM_UPDATE_ALIGNED_OFFSET	0x5000000 	/* 80MB for LocalUpdate Use. */

/* boot ݸkernelڴ*/
#define CONFIG_SYS_SDRAM32_A9_SIZE    			0x01BC0000    //27.75M          	
#define CONFIG_SYS_SDRAM32_RECOVERY_A9_SIZE     0x02000000

#ifdef CONFIG_ZX297520V3E_WATCH_CAP	
#define CONFIG_SYS_SDRAM64_A9_SIZE    			0x02AC0000 	//42.75M
#else
#define CONFIG_SYS_SDRAM64_A9_SIZE    			0x03BC0000  //59.75M
#endif
#define CONFIG_SYS_SDRAM64_RECOVERY_A9_SIZE     0x04000000  

#define CONFIG_SYS_SDRAM128_A9_SIZE    		    0x07BC0000	//123.75M    
#define CONFIG_SYS_SDRAM128_RECOVERY_A9_SIZE    0x08000000 	  

#define CONFIG_SYS_SDRAM256_A9_SIZE    		    0x0FBC0000	//251.75M    
#define CONFIG_SYS_SDRAM256_RECOVERY_A9_SIZE    0x10000000 	  


#define CONFIG_SYS_SDRAM512_A9_SIZE    		    0x1FBC0000	//507.75M    
#define CONFIG_SYS_SDRAM512_RECOVERY_A9_SIZE    0x20000000 	

#define AMT_MODE_FLAG				0x544D


/*  ================================================================= boot ========= */
#define CONFIG_MACH_TYPE		    7523
#define CONFIG_SETUP_MEMORY_TAGS    1
#define CONFIG_CMDLINE_TAG          1
#define CONFIG_INITRD_TAG           1

#define CONFIG_BOOTARGS     ""      /* partition.c */
#define CONFIG_BOOTCOMMAND  ""      /* load_image.c */
#define CONFIG_CMD_BOOTM


/* ================================================================= malloc ======== */
#define CONFIG_SYS_MALLOC_LEN		(CONFIG_ENV_SIZE + 2048 * 1024)/* 2M */


/* ================================================================ Command ======== */
#include <config_cmd_default.h>
#define CONFIG_CMD_CACHE

/* ============================================================= usb download ====== */
#define	CONFIG_USB_LOAD_MAX_LEN         CONFIG_SYS_SDRAM_SIZE-0x400000
#define CONFIG_USB_LOAD_MAX_PACKET_LEN  CONFIG_USB_LOAD_MAX_LEN


/* ==================================================================== nand ======= */
#define CONFIG_NAND             1
#define CONFIG_CMD_NAND_YAFFS
#define CONFIG_CMD_NAND
#define CONFIG_NAND_MTD         1
#define CONFIG_NAND_DENALI      1
#define CFG_DENALI_DMA_BUF_SIZE     0x4000  /* 16k */
#define CFG_DENALI_DMA_BUF_ADDR     (CONFIG_SYS_SDRAM_BASE + \
                                        CONFIG_SYS_SDRAM_SIZE - \
                                        CONFIG_SYS_UBOOT_SIZE - 0x10000 - \
                                        CFG_DENALI_DMA_BUF_SIZE)/* TLB 64K */
#define CONFIG_SYS_MAX_NAND_DEVICE	1
#define CONFIG_SYS_NAND_BASE		0x0     /* һʼû壬滹ʼ */
#define CONFIG_BOOT_NAND


/* ===================================================================== mtd ======= */
#define CONFIG_PARTITIONS

/* ================================================================== time ========= */
#define CONFIG_POWER_ON_DELAY_TIME      3000000 /* 3s */
#define CONFIG_SYS_HZ			        1000
#if CONFIG_MUTUAL_DEBUG
#define CONFIG_BOOTDELAY	            8
#else
#define CONFIG_BOOTDELAY	            0
#endif
#define CONFIG_ZERO_BOOTDELAY_CHECK


/* ============================================================ uboot system ======= */
#define CONFIG_SYS_UBOOT_SIZE		(2 * 1024 * 1024)
#define CONFIG_SYS_PHY_UBOOT_BASE	(CONFIG_SYS_SDRAM_BASE + \
                                        CONFIG_SYS_SDRAM_SIZE - \
                                        CONFIG_SYS_UBOOT_SIZE - 0x10000)
#define CONFIG_SYS_LONGHELP
#define CONFIG_SYS_PROMPT		"[ZXIC]# "
#define CONFIG_SYS_CBSIZE		256		/* Console I/O Buffer Size    */
#define CONFIG_SYS_PBSIZE		512		/* Print Buffer Size          */
#define CONFIG_SYS_MAXARGS		16		/* max number of command args */
#define CONFIG_SYS_BARGSIZE		CONFIG_SYS_CBSIZE	/* Boot Argument Buffer Size  */
#define CONFIG_SYS_MEMTEST_START	CONFIG_SYS_SDRAM_BASE	/* memtest works on	      */
#define CONFIG_SYS_MEMTEST_END		(CONFIG_SYS_SDRAM_BASE + CONFIG_SYS_SDRAM_SIZE) /* 32MB in DRAM */
#define CONFIG_SYS_LOAD_ADDR		CONFIG_SYS_SDRAM_BASE	/* default load address	*/

#define CONFIG_LOADADDR					0x22000000

/* ================================================================= serial ======== */
#define CONFIG_BAUDRATE		    921600
#define CONFIG_SERIAL1          1	/* we use SERIAL 1 	*/
#define CONFIG_SYS_HUSH_PARSER		/* use "hush" command parser	*/
#define CONFIG_SYS_BAUDRATE_TABLE	{ 9600, 19200, 38400, 57600, 115200, 921600}
#ifdef CONFIG_SYS_HUSH_PARSER
#define CONFIG_SYS_PROMPT_HUSH_PS2	"> "
#endif
#define CONFIG_AUTO_COMPLETE
#define CONFIG_CMDLINE_EDITING
#define CONFIG_ENV_OVERWRITE


/* ============================================================== nor flash ======== */
#define CONFIG_SYS_NO_FLASH

#define CONFIG_CMD_JFFS2
#define CONFIG_JFFS2_DEV	"nand0"
#define CONFIG_JFFS2_NAND
/* ================================================================= env =========== */
#define CONFIG_ENV_IS_NOWHERE   1
#define CONFIG_ENV_SIZE		    0x4000
#define CONFIG_ENV_OFFSET		0x0040000

#define NoBatteryTempratureVoltage 4000

#define CONFIG_CMD_MII              0
#define CONFIG_CMD_NET				1
#define CONFIG_CMD_PING				1
#define CONFIG_ZX_MDIO				1
#define CONFIG_CMD_TFTPPUT			1

#define CONFIG_ZTE_CMD                                 1
#define CONFIG_CMD_TFTPDOWNER          0   

/***************************************************/
/*ubootĶ*/

#if 1
//#define CONFIG_ETHADDR                          00:02:f7:ef:00:02     //?????macַȷ
#define CONFIG_ETHADDR                            ec:1d:7f:b0:2f:32     //?????macַȷ
//#define CONFIG_ETHADDR                          00:22:93:4e:d9:dd     //?????macַȷ
//#define CONFIG_ETHADDR                          6c:0b:84:3b:f8:42     //?????macַȷ
#define CONFIG_HOSTNAME	                        unknown
#define CONFIG_NETMASK                   255.255.255.0       /**/
#define CONFIG_IPADDR                    192.168.1.1      /*IPַ*/
#define CONFIG_SERVERIP                  192.168.1.20      /*IPַ*/
#define CONFIG_GATEWAYIP	             192.168.1.1        /*IPַ*/
#define CONFIG_BOOTFILE 				 ZX297520V3.bin
//#define CONFIG_ROOTPATH                         /opt/nfsroot        /*NFS Ŀ¼*/
#endif
#endif	/* __CONFIG_H */
