#include <linux/types.h>
#include <linux/netfilter.h>
#include <linux/slab.h>
#include <linux/module.h>
#include <linux/proc_fs.h>    /* Necessary because we use proc fs */
#include <linux/skbuff.h>
#include <linux/proc_fs.h>
#include <linux/seq_file.h>
#include <linux/percpu.h>
#include <linux/netdevice.h>
#include <linux/security.h>
#include <net/net_namespace.h>
#ifdef CONFIG_SYSCTL
#include <linux/sysctl.h>
#endif
#include <linux/rculist_nulls.h>
#include <net/netfilter/nf_conntrack.h>
#include <net/netfilter/nf_conntrack_core.h>
#include <net/netfilter/nf_conntrack_l3proto.h>
#include <net/netfilter/nf_conntrack_l4proto.h>
#include <net/netfilter/nf_conntrack_expect.h>
#include <net/netfilter/nf_conntrack_helper.h>
#include <net/netfilter/nf_conntrack_acct.h>
#include <net/netfilter/nf_conntrack_zones.h>
#include <net/netfilter/nf_conntrack_timestamp.h>

#include <net/SI/fastnat.h>
#include <net/SI/fast6.h>
#include <net/SI/fast_common.h>

#define PORT_LEN 10

extern int fastnat_ack_param;
extern int ackdrop_maxnum;
extern fast_list_t fast_del_list;

static void *fastnat_level_seq_start(struct seq_file *seq, loff_t *pos)
    __acquires(RCU)
{
    if (*pos >= 1)
        return NULL;
    return 1;
}

static void *fastnat_level_seq_next(struct seq_file *s, void *v, loff_t *pos)
{
    (*pos)++;
    return NULL;
}

static void fastnat_level_seq_stop(struct seq_file *s, void *v)
    __releases(RCU)
{
    return;
}

/* return 0 on success, 1 in case of error */
static int fastnat_level_seq_show(struct seq_file *s, void *v)
{
    seq_printf(s, "fastnat_level: %d, list:%d-%d, del:%d\n", fastnat_level, working_list.count, working_list6.count, fast_del_list.count);
    return 0;
}

static const struct seq_operations fastnat_level_seq_ops = {
    .start = fastnat_level_seq_start,
    .next  = fastnat_level_seq_next,
    .stop  = fastnat_level_seq_stop,
    .show  = fastnat_level_seq_show
};

static int fastnat_level_open(struct inode *inode, struct file *file)
{
    return seq_open(file, &fastnat_level_seq_ops);
}

//ûдĲο룬ùáȲ
static ssize_t fastnat_level_set(struct file *file,
        const char __user *buffer, size_t count, loff_t *pos)
{
    size_t size;
    char char_fastnat[5] = {0};
    int level = 0;

    //countβ1ֻ֧0-3
    if (count != 2)
        return -EINVAL;
    
    //size = min(count - 1, MAX_NET_DEVICE_NAME_LEN);
    //memset(char_fastnat, 0, MAX_NET_DEVICE_NAME_LEN + 1);
    if (copy_from_user(char_fastnat, buffer, 1))
        return -EFAULT;

    if ((char_fastnat[0] < '0' || char_fastnat[0] > '2') && (char_fastnat[0] != '5'))
        return -EINVAL;

    level = (int)(char_fastnat[0] - '0');

    //ÿתӺ
    fast_level_change(level);
    
    return count;
}

static void *fast_switch_seq_start(struct seq_file *seq, loff_t *pos)
    __acquires(RCU)
{
    if (*pos >= 1)
        return NULL;
    return 1;
}

static void *fast_switch_seq_next(struct seq_file *s, void *v, loff_t *pos)
{
    (*pos)++;
    return NULL;
}

static void fast_switch_seq_stop(struct seq_file *s, void *v)
    __releases(RCU)
{
    return;
}

/* return 0 on success, 1 in case of error */
static int fast_switch_seq_show(struct seq_file *s, void *v)
{
    seq_printf(s, "fast_switch: 0x%x\n", fast_switch);
    return 0;
}

static const struct seq_operations fast_switch_seq_ops = {
    .start = fast_switch_seq_start,
    .next  = fast_switch_seq_next,
    .stop  = fast_switch_seq_stop,
    .show  = fast_switch_seq_show
};

static int fast_switch_open(struct inode *inode, struct file *file)
{
    return seq_open(file, &fast_switch_seq_ops);
}

//ûдĲο룬ùáȲ
static ssize_t fast_switch_set(struct file *file,
        const char __user *buffer, size_t count, loff_t *pos)
{
    size_t size;
    char char_fastnat[5] = {0};
    int level = 0, i = 0;

    //countβ1ֻ֧0-3
    if (count > 5)
        return -EINVAL;
     
    memset(char_fastnat, 0,  5);
    if (copy_from_user(char_fastnat, buffer, 5))
        return -EFAULT;

    for(i = 0; i < count - 1; i++){
        if(char_fastnat[i] < '0' || char_fastnat[i] > '9')
            return -EINVAL;
        level = (int)(char_fastnat[i] - '0') + level*10;
    }
 
    //ÿתӺ
    fast_switch_change(level);
    return count;
}

static void *fastbr_level_seq_start(struct seq_file *seq, loff_t *pos)
    __acquires(RCU)
{
    if (*pos >= 1)
        return NULL;
    return 1;
}

static void *fastbr_level_seq_next(struct seq_file *s, void *v, loff_t *pos)
{
    (*pos)++;
    return NULL;
}

static void fastbr_level_seq_stop(struct seq_file *s, void *v)
    __releases(RCU)
{
    return;
}

/* return 0 on success, 1 in case of error */
static int fastbr_level_seq_show(struct seq_file *s, void *v)
{
    seq_printf(s, "fastbr_level: %d\n", fastbr_level);
    return 0;
}

static const struct seq_operations fastbr_level_seq_ops = {
    .start = fastbr_level_seq_start,
    .next  = fastbr_level_seq_next,
    .stop  = fastbr_level_seq_stop,
    .show  = fastbr_level_seq_show
};

static int fastbr_level_open(struct inode *inode, struct file *file)
{
    return seq_open(file, &fastbr_level_seq_ops);
}

//ûдĲο룬ùáȲ
static ssize_t fastbr_level_set(struct file *file,
        const char __user *buffer, size_t count, loff_t *pos)
{
    size_t size;
    char char_fastbr[5] = {0};

    //countβ1ֻ֧0-1
    if (count != 2)
        return -EINVAL;
    
    if (copy_from_user(char_fastbr, buffer, 1))
        return -EFAULT;

    if (char_fastbr[0] < '0' || char_fastbr[0] > '1')
        return -EINVAL;

    fastbr_level = (int)(char_fastbr[0] - '0');
    
    return count;
}

static void *fastnat_seq_start(struct seq_file *seq, loff_t *pos)
    __acquires(RCU)
{
    spin_lock_bh(&fastnat_spinlock);
    if (*pos >= nf_conntrack_htable_size) 
        return NULL;
    else 
    {
        if (*pos == 0)
        {
            seq_printf(seq, "fastnat have %d conn!!!\nskb_num4:%d,fastnat_num:%d\n",
                working_list.count, skb_num4, fastnat_num);
            seq_printf(seq, "fastbr_sum:%d,fastbr_num:%d\n", 
                skb_num4 + skb_num6 + skb_unknown - fastnat_num - fast6_num, fastbr_num);
            
            if ((fastnat_ack_param == 1) && (ackdrop_maxnum  >= 1))
            {
                seq_printf(seq, "fastnat ack_delay_stats : total_count = %d, forword_count = %d, drop_count = %d, "
                    "timeout_xmit_count = %d, timeout_drop_count = %d\n",
                    ack_delay_stats.total_count, ack_delay_stats.forword_count, ack_delay_stats.drop_count,
                    ack_delay_stats.timeout_xmit_count, ack_delay_stats.timeout_drop_count);
            }
        }
        return &working_hash[*pos];
    }

}

static void *fastnat_seq_next(struct seq_file *s, void *v, loff_t *pos)
{
    (*pos)++;
    //return fastnat_get_next(s, v);
    if (*pos >= nf_conntrack_htable_size) 
        return NULL;
    else
        return &working_hash[*pos];
}


static void fastnat_seq_stop(struct seq_file *s, void *v)
    __releases(RCU)
{
    spin_unlock_bh(&fastnat_spinlock);
    //rcu_read_unlock();
}

/* return 0 on success, 1 in case of error */
static int fastnat_seq_show(struct seq_file *s, void *v)
{
    struct hlist_nulls_head    *head = (struct hlist_nulls_head *) v;
    struct nf_conntrack_tuple_hash *h;
    struct hlist_nulls_node *n;
    fast_entry_data_t *nat_entry_data;
    fast_entry_t *nat_entry = NULL;
    const struct nf_conntrack_l3proto *l3proto;
    const struct nf_conntrack_l4proto *l4proto;
    int ret = 0;
    
    hlist_nulls_for_each_entry(h, n, head, hnnode) 
    {
        nat_entry_data = fast_hash_to_data(h);
        nat_entry = fast_data_to_entry(nat_entry_data);
        
        NF_CT_ASSERT(nat_entry->ct);
        if (unlikely(!atomic_inc_not_zero(&nat_entry->ct->ct_general.use)))
            return 0;

        /* we only want to print DIR_ORIGINAL */
        if (NF_CT_DIRECTION(h))
        {
            nf_ct_put(nat_entry->ct);
            continue;
        }
        
        l3proto = __nf_ct_l3proto_find(nf_ct_l3num(nat_entry->ct));
        NF_CT_ASSERT(l3proto);
        l4proto = __nf_ct_l4proto_find(nf_ct_l3num(nat_entry->ct), nf_ct_protonum(nat_entry->ct));
        NF_CT_ASSERT(l4proto);


        ret = -ENOSPC;
        if (seq_printf(s, "%-8s %u %-8s %u %ld %ld %ld ",
                   l3proto->name, nf_ct_l3num(nat_entry->ct),
                   l4proto->name, nf_ct_protonum(nat_entry->ct),
                   nat_entry->timeout.expires/HZ, tcp_timeouts[nat_entry->ct->proto.tcp.state]/HZ, jiffies/HZ) != 0)
        {
            nf_ct_put(nat_entry->ct);
            continue;
        }

        //tcp_conntrack_namesֻ˵TCP_CONNTRACK_MAXƣstate滹ж״̬
        if (nat_entry->ct->proto.tcp.state < TCP_CONNTRACK_MAX)
        {
            if (l4proto->print_conntrack && l4proto->print_conntrack(s, nat_entry->ct))
            {
                nf_ct_put(nat_entry->ct);
                continue;
            }
        }

        if (print_tuple(s, &nat_entry->ct->tuplehash[IP_CT_DIR_ORIGINAL].tuple,
                l3proto, l4proto))
        {
            nf_ct_put(nat_entry->ct);
            continue;
        }

        if (seq_print_acct(s, nat_entry->ct, IP_CT_DIR_ORIGINAL))
        {
            nf_ct_put(nat_entry->ct);
            continue;
        }

        if (!(test_bit(IPS_SEEN_REPLY_BIT, &nat_entry->ct->status)))
            if (seq_printf(s, "[UNREPLIED] "))
            {
                nf_ct_put(nat_entry->ct);
                continue;
            }

        if (print_tuple(s, &nat_entry->ct->tuplehash[IP_CT_DIR_REPLY].tuple,
                l3proto, l4proto))
        {
            nf_ct_put(nat_entry->ct);
            continue;
        }

        if (seq_print_acct(s, nat_entry->ct, IP_CT_DIR_REPLY))
        {
            nf_ct_put(nat_entry->ct);
            continue;
        }

        if (test_bit(IPS_ASSURED_BIT, &nat_entry->ct->status))
            if (seq_printf(s, "[ASSURED] "))
            {
                nf_ct_put(nat_entry->ct);
                continue;
            }

        seq_printf(s, "NAT_ip=%pI4 NAT_port==%hu  \n",&nat_entry->data[IP_CT_DIR_ORIGINAL].nat_addr,ntohs(nat_entry->data[IP_CT_DIR_ORIGINAL].nat_port));
        nf_ct_put(nat_entry->ct);
        //ret = 0;
    }

    return 0;
}


static const struct seq_operations fastnat_seq_ops = {
    .start = fastnat_seq_start,
    .next  = fastnat_seq_next,
    .stop  = fastnat_seq_stop,
    .show  = fastnat_seq_show
};

static int fastnat_open(struct inode *inode, struct file *file)
{
    //seq_printf(file, "fastnat  have  %pI4  conn!!!\n",&working_list.count);
    //seq_printf(file, "fastnat  have  %d  conn!!!\n",working_list.count);
    //return seq_open_net(inode, file, &fastnat_seq_ops,
    //        sizeof(struct fastnat_iter_state));
    return seq_open(file, &fastnat_seq_ops);
}

static void *fast6_seq_start(struct seq_file *seq, loff_t *pos)
    __acquires(RCU)
{
    spin_lock_bh(&fast6_spinlock);
    if (*pos >= nf_conntrack_htable_size) 
        return NULL;
    else 
    {
        if (*pos == 0)
        {
        #if 0
            seq_printf(seq, "fastnat ack_delay_stats : total_count = %d, forword_count = %d, drop_count = %d, "
                "timeout_xmit_count = %d, timeout_drop_count = %d\n",
                ack_delay_stats.total_count, ack_delay_stats.forword_count, ack_delay_stats.drop_count,
                ack_delay_stats.timeout_xmit_count, ack_delay_stats.timeout_drop_count);
            seq_printf(seq, "fastnat have %d conn!!!\nfastnat_recv_count:%d,fastnat_real_count:%d\n",
                working_list.count,fastnat_recv_count,fastnat_real_count);
            seq_printf(seq, "send_2_ps_failed:%u, send_2_usb_failed:%u\n", send_2_ps_failed, send_2_usb_failed);
        #endif
            seq_printf(seq, "fast6 have %d conn!!!\nskb_num6:%d,fast6_num:%d\n",
                working_list6.count, skb_num6, fast6_num);
        }
        return &working_hash6[*pos];
    }

    //struct fastnat_iter_state *st = seq->private;

    //st->time_now = ktime_to_ns(ktime_get_real());
    //rcu_read_lock();
    //seq_printf(seq, "fastnat  have  %d  conn!!!\n",working_list.count);
    //return fastnat_get_idx(seq, *pos);
}

static void *fast6_seq_next(struct seq_file *s, void *v, loff_t *pos)
{
    (*pos)++;
    //return fastnat_get_next(s, v);
    if (*pos >= nf_conntrack_htable_size) 
        return NULL;
    else
        return &working_hash6[*pos];
}


static void fast6_seq_stop(struct seq_file *s, void *v)
    __releases(RCU)
{
    spin_unlock_bh(&fast6_spinlock);
    //rcu_read_unlock();
}

/* return 0 on success, 1 in case of error */
static int fast6_seq_show(struct seq_file *s, void *v)
{
    struct hlist_nulls_head    *head = (struct hlist_nulls_head *) v;
    struct nf_conntrack_tuple_hash *h;
    struct hlist_nulls_node *n;
    fast_entry_data_t *fast6_entry_data;
    fast_entry_t *fast6_entry = NULL;
    const struct nf_conntrack_l3proto *l3proto;
    const struct nf_conntrack_l4proto *l4proto;
    int ret = 0;
    
    hlist_nulls_for_each_entry(h, n, head, hnnode) 
    {
        fast6_entry_data = fast_hash_to_data(h);
        fast6_entry = fast_data_to_entry(fast6_entry_data);
        
        NF_CT_ASSERT(fast6_entry->ct);
        if (unlikely(!atomic_inc_not_zero(&fast6_entry->ct->ct_general.use)))
            return 0;

        /* we only want to print DIR_ORIGINAL */
        if (NF_CT_DIRECTION(h))
        {
            nf_ct_put(fast6_entry->ct);
            continue;
        }
        
        l3proto = __nf_ct_l3proto_find(nf_ct_l3num(fast6_entry->ct));
        NF_CT_ASSERT(l3proto);
        l4proto = __nf_ct_l4proto_find(nf_ct_l3num(fast6_entry->ct), nf_ct_protonum(fast6_entry->ct));
        NF_CT_ASSERT(l4proto);

        ret = -ENOSPC;
        if (seq_printf(s, "%-8s %u %-8s %u %ld %ld %ld ",
                   l3proto->name, nf_ct_l3num(fast6_entry->ct),
                   l4proto->name, nf_ct_protonum(fast6_entry->ct),
                   fast6_entry->timeout.expires/HZ, tcp_timeouts[fast6_entry->ct->proto.tcp.state]/HZ, jiffies/HZ) != 0)
        {
            nf_ct_put(fast6_entry->ct);
            continue;
        }

        //tcp_conntrack_namesֻ˵TCP_CONNTRACK_MAXƣstate滹ж״̬
        if (fast6_entry->ct->proto.tcp.state < TCP_CONNTRACK_MAX)
        {
            if (l4proto->print_conntrack && l4proto->print_conntrack(s, fast6_entry->ct))
            {
                nf_ct_put(fast6_entry->ct);
                continue;
            }
        }

        if (print_tuple(s, &fast6_entry->ct->tuplehash[IP_CT_DIR_ORIGINAL].tuple,
                l3proto, l4proto))
        {
            nf_ct_put(fast6_entry->ct);
            continue;
        }

        if (seq_print_acct(s, fast6_entry->ct, IP_CT_DIR_ORIGINAL))
        {
            nf_ct_put(fast6_entry->ct);
            continue;
        }

        if (!(test_bit(IPS_SEEN_REPLY_BIT, &fast6_entry->ct->status)))
            if (seq_printf(s, "[UNREPLIED] "))
            {
                nf_ct_put(fast6_entry->ct);
                continue;
            }

        if (print_tuple(s, &fast6_entry->ct->tuplehash[IP_CT_DIR_REPLY].tuple,
                l3proto, l4proto))
        {
            nf_ct_put(fast6_entry->ct);
            continue;
        }

        if (seq_print_acct(s, fast6_entry->ct, IP_CT_DIR_REPLY))
        {
            nf_ct_put(fast6_entry->ct);
            continue;
        }

        if (test_bit(IPS_ASSURED_BIT, &fast6_entry->ct->status))
            if (seq_printf(s, "[ASSURED] "))
            {
                nf_ct_put(fast6_entry->ct);
                continue;
            }

        seq_printf(s, "\n");
        nf_ct_put(fast6_entry->ct);
    }

    return 0;
}

static const struct seq_operations fast6_seq_ops = {
    .start = fast6_seq_start,
    .next  = fast6_seq_next,
    .stop  = fast6_seq_stop,
    .show  = fast6_seq_show
};

static int fast6_open(struct inode *inode, struct file *file)
{
    return seq_open(file, &fast6_seq_ops);
}

//ûдĲο룬ùáȲ
static ssize_t dev_down_set(struct file *file,
        const char __user *buffer, size_t count, loff_t *pos)
{
    size_t size;
    char dev_name[MAX_NET_DEVICE_NAME_LEN + 1] = {0};

    //countβ1
    size = min(count - 1, MAX_NET_DEVICE_NAME_LEN);
    if (copy_from_user(dev_name, buffer, size))
        return -EFAULT;

    //ɾ豸ipv4,ipv6
    fast_device_down_event_by_name(dev_name);

    return count;
}

static void *nofast_port_seq_start(struct seq_file *seq, loff_t *pos)
    __acquires(RCU)
{
    if (*pos >= 1)
        return NULL;
    return 1;
}

static void *nofast_port_seq_next(struct seq_file *s, void *v, loff_t *pos)
{
    (*pos)++;
    return NULL;
}

static void nofast_port_seq_stop(struct seq_file *s, void *v)
    __releases(RCU)
{
    return;
}

static int nofast_port_seq_show(struct seq_file *s, void *v)
{
    int i = 0;
    
    if (nofast_port[0] == 0)
    {
        seq_printf(s, "All ports support fast! \n");
    }
    else
    {
        seq_printf(s, "Not supported ports include:\n%d", nofast_port[0]);
        
        for (i = 1; i < NOFAST_PROTO_MAX; i++)
        {
            //˿ں0
            if (nofast_port[i] == 0)
                break;
            seq_printf(s, "+%d", nofast_port[i]);
        }
        seq_printf(s, "\n\n");
    }
    return 0;
}

static const struct seq_operations nofast_port_seq_ops = {
    .start = nofast_port_seq_start,
    .next  = nofast_port_seq_next,
    .stop  = nofast_port_seq_stop,
    .show  = nofast_port_seq_show
};

static int nofast_port_open(struct inode *inode, struct file *file)
{
    return seq_open(file, &nofast_port_seq_ops);
}

struct nf_conntrack_tuple tuple_info;
/*
1~6 fast Ϣѯ
8 skbͷŵѯ
9 socket Ϣѯ
*/
int getconn_type = 0;

static void *conn_datainfo_seq_start(struct seq_file *seq, loff_t *pos)
    __acquires(RCU)
{
    if (*pos >= 1)
        return NULL;
    seq_printf(seq, "start fast4 count:%lu, fw:%lu, local4_recv:%lu, local4_output:%lu\n", skb_num4, fastnat_num, fast_local4_rcv_num, fast_local4_output_num);
    seq_printf(seq, "start fast6 count:%lu, fw:%lu, local6_recv:%lu, local6_output:%lu\n", skb_num6, fast6_num, fast_local6_rcv_num, fast_local6_output_num);
    return 1;
}

static void *conn_datainfo_seq_next(struct seq_file *s, void *v, loff_t *pos)
{
    (*pos)++;
    return NULL;
}

static void conn_datainfo_seq_stop(struct seq_file *s, void *v)
    __releases(RCU)
{
    return;
}

static int conn_datainfo_seq_show(struct seq_file *s, void *v)
{
    int i = 0, j = 0;
    struct nf_conntrack_tuple_hash *h;
    struct nf_conntrack_tuple_hash *h_rdir;
    struct nf_conn * ct;
    struct hlist_nulls_node *n;

    for(i = 0; i < init_net.ct.htable_size; i++){
        hlist_nulls_for_each_entry(h, n, &init_net.ct.hash[i], hnnode){
            if(h->tuple.dst.dir != IP_CT_DIR_ORIGINAL)
                continue;
            if(tuple_info.dst.protonum && tuple_info.dst.protonum != h->tuple.dst.protonum)
                continue;
            if(tuple_info.dst.u3.ip && memcmp(&tuple_info.dst.u3.ip6, h->tuple.dst.u3.ip6, 16) != 0)
                continue;
            if(tuple_info.src.u3.ip && memcmp(&tuple_info.src.u3.ip6, h->tuple.src.u3.ip6, 16) != 0)
                continue;
            if(tuple_info.dst.u.all && tuple_info.dst.u.all != h->tuple.dst.u.all){
                continue;
            }
            if(tuple_info.src.u.all && tuple_info.src.u.all != h->tuple.src.u.all){
                continue;        
            }       
            
            ct = container_of(h, struct nf_conn, tuplehash[h->tuple.dst.dir]);
            
            if(getconn_type && getconn_type != ct->fast_ct.isFast)
                continue;

            if (unlikely(!atomic_inc_not_zero(&ct->ct_general.use)))
                continue;

            h_rdir = &ct->tuplehash[IP_CT_DIR_REPLY];
            if(h->tuple.src.l3num == AF_INET){    
                seq_printf(s, "ctinfo protonum: %d  Original sip: %08x, sport: %d, dip: %08x, dport: %d, packets: %lu , bytes: %lu;", 
                    h->tuple.dst.protonum, ntohl(h->tuple.src.u3.ip), ntohs(h->tuple.src.u.all), ntohl(h->tuple.dst.u3.ip), ntohs(h->tuple.dst.u.all), 
                    ct->packet_info[IP_CT_DIR_ORIGINAL].packets, ct->packet_info[IP_CT_DIR_ORIGINAL].bytes);
                seq_printf(s, "    reply sip: %08x, sport: %d, dip: %08x, dport: %d, packets: %lu , bytes: %lu\n", 
                    ntohl(h_rdir->tuple.src.u3.ip), ntohs(h_rdir->tuple.src.u.all), ntohl(h_rdir->tuple.dst.u3.ip), ntohs(h_rdir->tuple.dst.u.all), 
                    ct->packet_info[IP_CT_DIR_REPLY].packets, ct->packet_info[IP_CT_DIR_REPLY].bytes);
            }
            else if(h->tuple.src.l3num == AF_INET6){
                seq_printf(s, "ctinfo  protonum: %d  Original sip: %x:%x:%x:%x:%x:%x:%x:%x sport: %d, dip: %x:%x:%x:%x:%x:%x:%x:%x, dport: %d, packets: %lu , bytes: %lu;", 
                    h->tuple.dst.protonum, ntohs(h->tuple.src.u3.in6.s6_addr16[0]), ntohs(h->tuple.src.u3.in6.s6_addr16[1]), ntohs(h->tuple.src.u3.in6.s6_addr16[2]), ntohs(h->tuple.src.u3.in6.s6_addr16[3]), 
                    ntohs(h->tuple.src.u3.in6.s6_addr16[4]), ntohs(h->tuple.src.u3.in6.s6_addr16[5]), ntohs(h->tuple.src.u3.in6.s6_addr16[6]), ntohs(h->tuple.src.u3.in6.s6_addr16[7]), ntohs(h->tuple.src.u.all),
                    ntohs(h->tuple.dst.u3.in6.s6_addr16[0]), ntohs(h->tuple.dst.u3.in6.s6_addr16[1]), ntohs(h->tuple.dst.u3.in6.s6_addr16[2]), ntohs(h->tuple.dst.u3.in6.s6_addr16[3]), 
                    ntohs(h->tuple.dst.u3.in6.s6_addr16[4]), ntohs(h->tuple.dst.u3.in6.s6_addr16[5]), ntohs(h->tuple.dst.u3.in6.s6_addr16[6]), ntohs(h->tuple.dst.u3.in6.s6_addr16[7]), ntohs(h->tuple.dst.u.all),
                    ct->packet_info[IP_CT_DIR_ORIGINAL].packets, ct->packet_info[IP_CT_DIR_ORIGINAL].bytes);
                seq_printf(s, "    Reply sip: %x:%x:%x:%x:%x:%x:%x:%x sport: %d, dip: %x:%x:%x:%x:%x:%x:%x:%x, dport: %d, packets: %lu , bytes: %lu\n", 
                    ntohs(h_rdir->tuple.src.u3.in6.s6_addr16[0]), ntohs(h_rdir->tuple.src.u3.in6.s6_addr16[1]), ntohs(h_rdir->tuple.src.u3.in6.s6_addr16[2]), ntohs(h_rdir->tuple.src.u3.in6.s6_addr16[3]), 
                    ntohs(h_rdir->tuple.src.u3.in6.s6_addr16[4]), ntohs(h_rdir->tuple.src.u3.in6.s6_addr16[5]), ntohs(h_rdir->tuple.src.u3.in6.s6_addr16[6]), ntohs(h_rdir->tuple.src.u3.in6.s6_addr16[7]), ntohs(h_rdir->tuple.src.u.all),
                    ntohs(h_rdir->tuple.dst.u3.in6.s6_addr16[0]), ntohs(h_rdir->tuple.dst.u3.in6.s6_addr16[1]), ntohs(h_rdir->tuple.dst.u3.in6.s6_addr16[2]), ntohs(h_rdir->tuple.dst.u3.in6.s6_addr16[3]), 
                    ntohs(h_rdir->tuple.dst.u3.in6.s6_addr16[4]), ntohs(h_rdir->tuple.dst.u3.in6.s6_addr16[5]), ntohs(h_rdir->tuple.dst.u3.in6.s6_addr16[6]), ntohs(h_rdir->tuple.dst.u3.in6.s6_addr16[7]), ntohs(h_rdir->tuple.dst.u.all),
                    ct->packet_info[IP_CT_DIR_REPLY].packets, ct->packet_info[IP_CT_DIR_REPLY].bytes);
            }
            if(ct->fast_ct.isFast == FAST_CT_LOCAL6 || ct->fast_ct.isFast == FAST_CT_LOCAL4){
                seq_printf(s, "ctinfo ->ISFAST: %d, sk: %p\n", ct->fast_ct.isFast, ct->fast_ct.sk);
            }else if(ct->fast_ct.isFast == FAST_CT_FW6 || ct->fast_ct.isFast == FAST_CT_FW4){
                seq_printf(s, "ctinfo ->ISFAST: %d", ct->fast_ct.isFast);
                if(ct->fast_ct.fast_dst[IP_CT_DIR_ORIGINAL])
                    seq_printf(s, "    Original fast_dst: %p", ct->fast_ct.fast_dst[IP_CT_DIR_ORIGINAL]);
                if(ct->fast_ct.fast_dst[IP_CT_DIR_REPLY])
                    seq_printf(s, "    Reply fast_dst: %p", ct->fast_ct.fast_dst[IP_CT_DIR_REPLY]);
                if(ct->fast_ct.fast_brport[IP_CT_DIR_ORIGINAL])
                    seq_printf(s, "    Original fast_brport: %p", ct->fast_ct.fast_brport[IP_CT_DIR_ORIGINAL]);
                if(ct->fast_ct.fast_brport[IP_CT_DIR_REPLY])
                    seq_printf(s, "    Reply fast_brport: %p", ct->fast_ct.fast_brport[IP_CT_DIR_REPLY]);
                seq_printf(s, "\n");
            }
            nf_ct_put(ct);
        }
    }
    return 0;
}

static const struct seq_operations conn_datainfo_seq_ops= {
    .start = conn_datainfo_seq_start,
    .next  = conn_datainfo_seq_next,
    .stop  = conn_datainfo_seq_stop,
    .show  = conn_datainfo_seq_show
    
};

static int conn_datainfo_open(struct inode *inode, struct file *file)
{
    return seq_open(file, &conn_datainfo_seq_ops);
}

//ʮַתΪ
static int str2int(char *str)
{
    int i = 0, value = 0, negative = 1;
    int len = strlen(str);
    
    for (i = 0; i < len; i++)
    {
        //ǰĿո
        if ((value == 0) && (str[i] == ' '))
            continue;

        //һЧַǸ
        if ((negative == 1) && (str[i] == '-'))
        {
            negative = -1;
            continue;
        }
        
        //ʮ
        if (str[i] < '0' || str[i] > '9')
            break;
        value = value * 10 + (str[i] - '0');
    }
    return value * negative;
}

static void parse_nofast_port(const char *str, char split)
{
    char *p = NULL;
    char *pre = str;
    char portStr[PORT_LEN] = {0}; //Э˿ںΪ65535
    int count = 0, port = 0, len = 0;

    printk("parse_nofast_port receve:%s, %p, %p, c:%c \n", str, str, pre, '+');

    memset(nofast_port, 0, NOFAST_PROTO_MAX * sizeof(nofast_port[0]));
    
    for (; (p = strchr(pre, split)) != NULL; pre = p + 1)
    {
        //һַǷָ
        if (p == pre)
            continue;

        memset(portStr, 0, PORT_LEN);
        len = min(p - pre, PORT_LEN - 1);
		snprintf(portStr,len+1,"%s",pre);
        //strncpy(portStr, pre, len);
        port = str2int(portStr);
        if (port <= 0 || port > 65535) //˿ں65535
        {
            printk("port:%s is invalid \n", portStr);
            continue;
        }
        nofast_port[count++] = port;
        if (count == NOFAST_PROTO_MAX)
            return;
    }

    if (*pre != '\0') //һǷָ
    {
        memset(portStr, 0, PORT_LEN);
        len = min(str + strlen(str) - pre, PORT_LEN - 1);
		snprintf(portStr,len+1,"%s",pre);
        //strncpy(portStr, pre, len);
        port = str2int(portStr);
        if (port <= 0 || port > 65535) //˿ں65535
        {
            printk("port:%s is invalid \n", portStr);
            return;
        }
        nofast_port[count++] = port;
    }
}

//ûдĲο룬ùáȲ
static ssize_t nofast_port_set(struct file *file,
        const char __user *buffer, size_t count, loff_t *pos)
{
    size_t size;
    char proto[1024] = {0};

    //countβ1
    size = min(count - 1, 1024);
    if (copy_from_user(proto, buffer, size))
        return -EFAULT;
	proto[1023]='\0';
    //ַ
    parse_nofast_port(proto, '+');
    
    return count;
}

extern int in4_pton(const char *src, int srclen,
         u8 *dst,
         int delim, const char **end);
extern int in6_pton(const char *src, int srclen,
         u8 *dst,
         int delim, const char **end);


static void conn_datainfo_get_str(char *str, char *start, char *end){
    strncat(str, start, end - start);
    *(str + (unsigned long)end - (unsigned long)start) = '\0';
}

/***************************************
ʽ:    Դip+Դport+Ŀip+Ŀport+l4Э+fast(ο enum conn_fast_type)
ʵ:        192.168.0.100+1111+192.168.30.102+2222+6+4
ע:        ȱʡĳһĬһȫƥ
            +++++:ʾȫϢ
***************************************/
static ssize_t conn_datainfo_set(struct file *file, 
    const char __user *buffer, size_t count, loff_t *pos)
{
    char tuple[1024] = "";
    int i = 0;
    char *split[5];
    char sip[40] = "";
    char sport[6] = "";
    char dip[40] = "";
    char dport[6] = "";
    char protonum[6] = "";
    char conn_type[6] = "";
    const char *end;
    if(copy_from_user(tuple, (char *)buffer, count))
    {
        //kfree(tuple);
        return -EFAULT;
    }
	tuple[1023]='\0';
    memset(&tuple_info, 0 ,sizeof(struct nf_conntrack_tuple));
    for(i = 0; i < 5; i++){
        if(i == 0)
            split[i] = strchr(tuple, '+');
        else
            split[i] = strchr(split[i-1] + 1, '+');
        if(!split[i])
            goto err_out;
        switch(i){
            case 0: 
                conn_datainfo_get_str(sip, tuple, split[i]);
                break;
            case 1:
                conn_datainfo_get_str(sport, split[i-1] + 1, split[i]);
                break;
            case 2:
                conn_datainfo_get_str(dip, split[i-1] + 1, split[i]);
                break;
            case 3:
                conn_datainfo_get_str(dport, split[i-1] + 1, split[i]);
                break;
            case 4:
                conn_datainfo_get_str(protonum, split[i-1] + 1, split[i]);
                break;
               default:
                goto err_out;
        }    
    }
    strncat(conn_type, split[i-1] + 1, sizeof(conn_type)-strlen(conn_type)-1);
    if(strlen(sip) > 0){
        if(strchr(sip,'.') != NULL && in4_pton(sip, strlen(sip), &tuple_info.src.u3.in, -1 , &end) != 1)
            goto err_out;
        else if(strchr(sip,':') != NULL && in6_pton(sip, strlen(sip), &tuple_info.src.u3.in6, -1 , &end) != 1)
            goto err_out;
    }
    if(strlen(sport) > 0){
        for(i = 0; i < strlen(sport); i++){
            if(sport[i] < '0' || sport[i] > '9')
                goto err_out;
            tuple_info.src.u.all = sport[i] - '0' + tuple_info.src.u.all*10;
        }
        if(tuple_info.src.u.all > 65535)
            goto err_out;
        tuple_info.src.u.all = htons(tuple_info.src.u.all);
    }
    if(strlen(dip) > 0){
        if(strchr(dip,'.') != NULL && in4_pton(dip, strlen(dip), &tuple_info.dst.u3.in, -1 , &end) != 1)
            goto err_out;
        else if(strchr(dip,':') != NULL && in6_pton(dip, strlen(dip), &tuple_info.dst.u3.in6, -1 , &end) != 1)
            goto err_out;
    }
    if(strlen(dport) > 0){
        for(i = 0; i < strlen(dport); i++){
            if(dport[i] < '0' || dport[i] > '9')
                goto err_out;
            tuple_info.dst.u.all = dport[i] - '0' + tuple_info.dst.u.all*10;
        }
        if(tuple_info.dst.u.all > 65535)
            goto err_out;
        tuple_info.dst.u.all = htons(tuple_info.dst.u.all);
    }    
    if(strlen(protonum) > 0){
        for(i = 0; i < strlen(protonum); i++){
            if(protonum[i] < '0' || protonum[i] > '9')
                goto err_out;
            tuple_info.dst.protonum = protonum[i] - '0' + tuple_info.dst.protonum*10;
        }
    }
    if(strlen(conn_type) > 0){
        getconn_type = 0;
        for(i = 0; i < strlen(conn_type) - 1; i++){
            if(conn_type[i] < '0' || conn_type[i] > '9')
                goto err_out;
            getconn_type = conn_type[i] - '0' + getconn_type*10;
        }
    }
    printk("Conn_datainfo input: count = %d sip = %s, sport = %s, dip = %s, dport = %s, protonum = %s getconn_type = %d, split: %s, %s, %s, %s, %s\n",
        count, sip, sport, dip, dport, protonum, getconn_type, split[0], split[1], split[2], split[3], split[4]);
    return count;
err_out:
    memset(&tuple_info, 0 ,sizeof(struct nf_conntrack_tuple));
    getconn_type = 0;
    printk("Conn_datainfo input error\n");
    return -EFAULT;
}

extern int pkt_lost_track;
static void *pkt_lostinfo_seq_start(struct seq_file *seq, loff_t *pos)
    __acquires(RCU)
{
    if (*pos >= 1)
        return NULL;
    return 1;
}

static void *pkt_lostinfo_seq_next(struct seq_file *s, void *v, loff_t *pos)
{
    (*pos)++;
    return NULL;
}

static void pkt_lostinfo_seq_stop(struct seq_file *s, void *v)
    __releases(RCU)
{
    return;
}

static int pkt_lostinfo_seq_show(struct seq_file *s, void *v)
{
    fast_entry_t *fast_entry = NULL;
    struct pkt_lost_info *lost_info = NULL;
    struct nf_conn *ct;
    int i = 0;
    if(pkt_lost_track != 1){
        seq_printf(s, "pkt_lost_track is not open\n");
        return 0;
    }
    lost_info = (struct pkt_lost_info *)kzalloc(sizeof(struct pkt_lost_info), GFP_KERNEL);
    if(!lost_info)
        return 0;

    memset(lost_info, 0, sizeof(struct pkt_lost_info));
    
    spin_lock_bh(&fastnat_spinlock);
    fast_entry = working_list.next;
    while(NULL != fast_entry)
    {
        ct= fast_entry->ct;
        if(ct)
        {
            if(IPPROTO_TCP == ct->tuplehash[0].tuple.dst.protonum)
            {
                for(i = 0; i < 2; i++)
                {
                    if(ct->packet_info[i].bytes >= 10000 && ct->packet_info[i].packets >= 100)
                    {
                        lost_info->stats[i].send_drops      += ct->conn_pktloss[i].send_drops;
                        lost_info->stats[i].recv_drops      += ct->conn_pktloss[i].recv_drops;
                        lost_info->stats[i].send_drop_bytes += ct->conn_pktloss[i].send_drop_bytes;
                        lost_info->stats[i].recv_drop_bytes += ct->conn_pktloss[i].recv_drop_bytes;
                        lost_info->stats[i].total_packets   += ct->packet_info[i].packets;
                        lost_info->stats[i].total_bytes     += ct->packet_info[i].bytes;
                    }
                }
            }
        }

        fast_entry = fast_entry->next;
    }
    spin_unlock_bh(&fastnat_spinlock);

    if((0 == lost_info->stats[0].total_packets) && (0 == lost_info->stats[1].total_packets))
    {
        seq_printf(s, "no packets receive by tcp conn\n");
		kfree(lost_info);
        return 0;
    }

    if((0 == lost_info->stats[0].recv_drops) && (0 == lost_info->stats[0].send_drops) &&
        (0 == lost_info->stats[1].recv_drops) && (0 == lost_info->stats[1].send_drops))
    {
        seq_printf(s, "if you have open pkt_lost_track, no packets loss by tcp conn\n");
		kfree(lost_info);
        return 0;
    }

    if(lost_info->stats[0].total_packets > 0 || lost_info->stats[1].total_packets > 0)
        seq_printf(s, "%10s %20s %20s %20s %20s %20s\n", "direction", "send drop pkts", "recv drop pkts", "total pkts", "send drop percent", "recv drop percent");

    if(lost_info->stats[0].total_packets > 0)
    {
        seq_printf(s, "%10s %20d %20d %20d %17d%% %17d%%\n", 
            "original",
            lost_info->stats[0].send_drops,
            lost_info->stats[0].recv_drops,
            lost_info->stats[0].total_packets,
            (lost_info->stats[0].send_drops * 100 / lost_info->stats[0].total_packets) , 
            (lost_info->stats[0].recv_drops * 100 / lost_info->stats[0].total_packets));
    }

    if(lost_info->stats[1].total_packets > 0)
    {
        seq_printf(s, "%10s %20d %20d %20d %17d%% %17d%%\n", 
            "reply", 
            lost_info->stats[1].send_drops,
            lost_info->stats[1].recv_drops,
            lost_info->stats[1].total_packets,
            (lost_info->stats[1].send_drops * 100 / lost_info->stats[1].total_packets), 
            (lost_info->stats[1].recv_drops * 100 / lost_info->stats[1].total_packets));
    }
	kfree(lost_info);
    return 0;
}

static const struct seq_operations pkt_lostinfo_seq_ops= {
    .start = pkt_lostinfo_seq_start,
    .next  = pkt_lostinfo_seq_next,
    .stop  = pkt_lostinfo_seq_stop,
    .show  = pkt_lostinfo_seq_show,
};

static int pkt_lostinfo_open(struct inode *inode, struct file *file)
{
    return seq_open(file, &pkt_lostinfo_seq_ops);
}

static ssize_t pkt_lostinfo_set(struct file *file, 
    const char __user *buffer, size_t count, loff_t *pos)
{
    size_t size;
    char temp[5] = {0};

    //countβ1ֻ֧0-1
    if (count != 2)
        return -EINVAL;
    
    if (copy_from_user(temp, buffer, 1))
        return -EFAULT;

    if (temp[0] < '0' || temp[0] > '1')
        return -EINVAL;

    pkt_lost_track = (int)(temp[0] - '0');
    
    return count;
}

extern void skb_debug_off(void);
static ssize_t skb_debug_off_set(struct file *file,
		const char __user *buffer, size_t count, loff_t *pos)
{
	skb_debug_off();
	printk("skb_debug_off\n");
	return count;
}

static ssize_t dev_reset_set(struct file *file,
		const char __user *buffer, size_t count, loff_t *pos)
{
	struct net_device *dev = NULL;
	size_t size;
	char dev_name[MAX_NET_DEVICE_NAME_LEN + 1] = {0};

	//countβ1
	size = min(count - 1, MAX_NET_DEVICE_NAME_LEN);
	if (copy_from_user(dev_name, buffer, size))
		return -EFAULT;

	//ɾ豸stat
	dev = dev_get_by_name(&init_net, dev_name);
	if (dev){
		memset(&dev->stats, 0, sizeof(struct net_device_stats));
		atomic_long_set(&dev->rx_dropped, 0);
		dev_put(dev);
	}else
		printk("dev_reset_set %s not find\n", dev_name);
	return count;
}

static const struct file_operations fastnat_level_file_ops = {
    .owner   = THIS_MODULE,
    .open    = fastnat_level_open,
    .read    = seq_read,
    .llseek  = seq_lseek,
    .release = seq_release, //seq_release_privateƺҲԣsingle_releaseseq_release_netпָ쳣
    .write = fastnat_level_set,
};

static const struct file_operations fast_switch_file_ops = {
    .owner   = THIS_MODULE,
    .open    = fast_switch_open,
    .read    = seq_read,
    .llseek  = seq_lseek,
    .release = seq_release, //seq_release_privateƺҲԣsingle_releaseseq_release_netпָ쳣
    .write = fast_switch_set,
};

static const struct file_operations fastbr_level_file_ops = {
    .owner   = THIS_MODULE,
    .open    = fastbr_level_open,
    .read    = seq_read,
    .llseek  = seq_lseek,
    .release = seq_release,
    .write = fastbr_level_set,
};

static const struct file_operations fastnat_file_ops = {
    .owner   = THIS_MODULE,
    .open    = fastnat_open,
    .read    = seq_read,
    .llseek  = seq_lseek,
    .release = seq_release,
};

static const struct file_operations fast6_file_ops = {
    .owner   = THIS_MODULE,
    .open    = fast6_open,
    .read    = seq_read,
    .llseek  = seq_lseek,
    .release = seq_release,
};

static const struct file_operations dev_down_file_ops = {
    .owner   = THIS_MODULE,
    .write = dev_down_set,
};

static const struct file_operations nofast_port_file_ops = {
    .owner   = THIS_MODULE,
    .open    = nofast_port_open,
    .read    = seq_read,
    .llseek  = seq_lseek,
    .release = seq_release,
    .write = nofast_port_set,
};

static const struct file_operations conn_datainfo_file_ops = {
    .owner = THIS_MODULE,
    .open = conn_datainfo_open,
    .read = seq_read,
    .llseek = seq_lseek,
    .release = seq_release,
    .write = conn_datainfo_set
};

static const struct file_operations pkt_lostinfo_file_ops = {
    .owner = THIS_MODULE,
    .open = pkt_lostinfo_open,
    .read = seq_read,
    .llseek = seq_lseek,
    .release = seq_release,
    .write = pkt_lostinfo_set,
};
	
static const struct file_operations skb_debug_off_file_ops = {
	.owner = THIS_MODULE,
	.write = skb_debug_off_set,
};

static const struct file_operations dev_reset_file_ops = {
	.owner = THIS_MODULE,
	.write = dev_reset_set,
};

//תprocļĳʼ
int fast_conntrack_init_proc(void)
{
    //תܿ
    proc_create("fastnat_level", 0440, init_net.proc_net, &fastnat_level_file_ops);

    //ת¾ɿأͿ
    proc_create("fast_switch", 0440, init_net.proc_net, &fast_switch_file_ops);

    //תȼ0-1
    proc_create("fastbr_level", 0440, init_net.proc_net, &fastbr_level_file_ops);

    //ipv4תͳ
    proc_create("fastnat", 0440, init_net.proc_net, &fastnat_file_ops);

    //ipv6תͳ
    proc_create("fast6", 0440, init_net.proc_net, &fast6_file_ops);

    //ĳЩ豸downȥҪɾ
    proc_create("dev_down", 0440, init_net.proc_net, &dev_down_file_ops);

    //֧fastnatЭ˿ڣֶ֧̬
    proc_create("nofast_port", 0440, init_net.proc_net, &nofast_port_file_ops);

    //ȡϢ
    proc_create("conn_datainfo", 0440, init_net.proc_net, &conn_datainfo_file_ops);

    //ȡӶϢ
    proc_create("pkt_lostinfo", 0440, init_net.proc_net, &pkt_lostinfo_file_ops);

    //turn off skb debug
    proc_create("skb_debug_off", 0440, init_net.proc_net, &skb_debug_off_file_ops);

    //reset dev stats
    proc_create("dev_reset_stats", 0440, init_net.proc_net, &dev_reset_file_ops);
    return 1;
}

EXPORT_SYMBOL(fast_conntrack_init_proc);


