/***********************************************************************
* Copyright (C) 2016, ZTE Corporation.
*
* File Name:  nvparam_drv.h
* File Mark:
* Description:  
* Others:
* Version:   v1.0
* Author:   wangxia
* Date:         2016-03-12
*
* History 1:
*     Date:
*     Version:
*     Author:
*     Modification:
* History 2:
**********************************************************************/
#ifndef NVPARAM_DRV_H
#define NVPARAM_DRV_H

/**************************************************************************
 *                                  Include files                         *
 **************************************************************************/
#include "RWNvConfig.h"
#include "NvParam_tsc.h"
/**************************************************************************
 *                                  Macro                                 *
 **************************************************************************/
#define	DRV_NV_ADDR					OS_FLASH_DRV_RW_NONFAC_BASE_ADDR
#define	DRV_NV_SIZE					OS_FLASH_DRV_RW_NONFAC_SIZE	/*16K*/

/*=====================================================================================================================
|----------------|----------------|---------------|--------------|----------------|-----------------|-----------------|
|  public(256B)  |    system(3K)  |  platfor(3K)  | highspeed(4K)| peripheral(3K) | 	audio(1K) 	| reserved(1.75K) |
|----------------|----------------|---------------|--------------|----------------|-----------------|-----------------|
=======================================================================================================================*/

#define	DRV_PUB_NV_ADDR				DRV_NV_ADDR
#define	DRV_PUB_NV_SIZE				(256)
#define	DRV_SYS_NV_ADDR				(DRV_PUB_NV_ADDR + DRV_PUB_NV_SIZE)
#define	DRV_SYS_NV_SIZE				(3 * 1024)
#define	DRV_PLAT_NV_ADDR			(DRV_SYS_NV_ADDR + DRV_SYS_NV_SIZE)
#define	DRV_PLAT_NV_SIZE			(3 * 1024)
#define	DRV_HS_PERI_NV_ADDR			(DRV_PLAT_NV_ADDR + DRV_PLAT_NV_SIZE)
#define	DRV_HS_PERI_NV_SIZE			(4 * 1024)
#define	DRV_PERI_NV_ADDR			(DRV_HS_PERI_NV_ADDR + DRV_HS_PERI_NV_SIZE)
#define	DRV_PERI_NV_SIZE			(3 * 1024)
#define	DRV_AUDIO_NV_ADDR			(DRV_PERI_NV_ADDR + DRV_PERI_NV_SIZE)
#define	DRV_AUDIO_NV_SIZE			(1 * 1024)
#define	DRV_RSVD_NV_ADDR			(DRV_AUDIO_NV_ADDR + DRV_AUDIO_NV_SIZE)
#define	DRV_RSVD_NV_SIZE			(1 * 1024 + 768)

#define	DRV_TOTAL_NV_SIZE			(DRV_PUB_NV_SIZE+DRV_SYS_NV_SIZE+DRV_PLAT_NV_SIZE+DRV_HS_PERI_NV_SIZE+DRV_PERI_NV_SIZE+DRV_AUDIO_NV_SIZE+DRV_RSVD_NV_SIZE)

/* user interface */
#define DRV_PUB_NV_ITEM_ADDR(x) 	(DRV_PUB_NV_ADDR + (UINT32)(&(((T_ZDrvNv_PubData*)(0x0))->x)))
#define DRV_PUB_NV_ITEM_SIZE(x) 	(sizeof(((T_ZDrvNv_PubData*)(0x0))->x))

#define DRV_SYS_NV_ITEM_ADDR(x) 	(DRV_SYS_NV_ADDR + (UINT32)(&(((T_ZDrvNv_SysData*)(0x0))->x)))
#define DRV_SYS_NV_ITEM_SIZE(x) 	(sizeof(((T_ZDrvNv_SysData*)(0x0))->x))

#define DRV_PLAT_NV_ITEM_ADDR(x) 	(DRV_PLAT_NV_ADDR + (UINT32)(&(((T_ZDrvNv_PlatData*)(0x0))->x)))
#define DRV_PLAT_NV_ITEM_SIZE(x) 	(sizeof(((T_ZDrvNv_PlatData*)(0x0))->x))

#define DRV_HS_PERI_NV_ITEM_ADDR(x) (DRV_HS_PERI_NV_ADDR + (UINT32)(&(((T_ZDrvNv_HSPeriData*)(0x0))->x)))
#define DDRV_HS_PER_NV_ITEM_SIZE(x) (sizeof(((T_ZDrvNv_HSPeriData*)(0x0))->x))

#define DRV_PER_NV_ITEM_ADDR(x) 	(DRV_PERI_NV_ADDR + (UINT32)(&(((T_ZDrvNv_PeriData*)(0x0))->x)))
#define DRV_PER_NV_ITEM_SIZE(x) 	(sizeof(((T_ZDrvNv_PeriData*)(0x0))->x))

#define DRV_AUDIO_NV_ITEM_ADDR(x) 	(DRV_AUDIO_NV_ADDR + (UINT32)(&(((T_ZDrvNv_AudioData*)(0x0))->x)))
#define DRV_AUDIO_NV_ITEM_SIZE(x) 	(sizeof(((T_ZDrvNv_AudioData*)(0x0))->x))

#define OS_FLASH_VOICE_DRV_RW_NONFAC_BASE_ADDR         (OS_FLASH_DRV_RW_NONFAC_BASE_ADDR + 15360)
#define OS_FLASH_VOICE_DRV_NONFAC_SIZE     1024

#if DRV_TOTAL_NV_SIZE > (OS_FLASH_DRV_RW_NONFAC_SIZE)
#error "error drv nv config!!!"
#endif

/****************************************************************************
* 	                         Types
****************************************************************************/


/******************************************************
* 	         Drv NV Config
******************************************************/
/***********************************
1. public nv_data
************************************/
typedef struct _T_ZDrvNv_PubData
{
	/* 0x00 */ 	CHAR  	chipName[16];
	/* 0x10 */ 	CHAR	prjName[16];
	/* 0x20 */ 	CHAR 	externalVer[16];
	/* 0x30 */ 	CHAR 	internalVer[16];
	/* 0x40 */ 	CHAR 	releaseTime[16];
	/* 0x50 */ 	UINT8 	productType;
	/* 0x51 */ 	UINT8 	reserved[DRV_PUB_NV_SIZE - 0x51];
} __attribute__ ((packed)) T_ZDrvNv_PubData;

/***********************************
2. system group nv_data
************************************/
typedef struct _T_ZDrvNv_SysData
{
	/* 0x000 */	T_SYS_NV_TSC_CONFIG tsc_config;
				UINT8 reserved0[12];
	/* 0x70 */	UINT32 buck1OnoffFlag;
	/* 0x74  */	UINT32 wdtSwitch;
	/* 0x78  */	UINT32 wdtPriority;
	/* 0x7C */	UINT8 uiccmodeSwitch;
	/* 0x7D */	UINT8 uiccPreSwitch; 
	/* 0x7E */	UINT8 uicc1modeSwitch;
	/* 0x7F */	UINT8 uicc1PreSwitch; 
	/* 0x80 */	UINT8 ishpnotsupported;
              UINT8 reserved[DRV_SYS_NV_SIZE - 129];
} __attribute__ ((packed)) T_ZDrvNv_SysData;

/***********************************
3. platform group nv_data
************************************/
typedef struct _T_ZDrvNv_PlatData
{
	UINT8 reserved[DRV_PLAT_NV_SIZE];
} __attribute__ ((packed)) T_ZDrvNv_PlatData;

/***********************************
4. hign-speed peripheral group nv_data
************************************/
typedef struct _T_ZDrvNv_HSPeriData
{
	UINT8 reserved[DRV_HS_PERI_NV_SIZE];
} __attribute__ ((packed)) T_ZDrvNv_HSPeriData;

/***********************************
5. common peripheral group nv_data
************************************/
typedef struct _T_ZDrvNv_PeriData
{
    UINT8 bat_det;
    UINT8 reserved[DRV_PERI_NV_SIZE-1];
} __attribute__ ((packed)) T_ZDrvNv_PeriData;

/***********************************
6. audio group nv_data
************************************/
typedef struct _T_ZDrvNv_AudioData
{
    UINT8 reserved[DRV_AUDIO_NV_SIZE];
} __attribute__ ((packed)) T_ZDrvNv_AudioData;

/***********************************
7. all driver_used nv_data
************************************/
typedef struct _T_ZDrv_NvData
{
	/* 0x0000 */	T_ZDrvNv_PubData	pubData;
	/* 0x0100 */	T_ZDrvNv_SysData	sysData;
	/* 0x0D00 */	T_ZDrvNv_PlatData	platData;
	/* 0x1900 */	T_ZDrvNv_HSPeriData	HSPeriData;
	/* 0x2900 */	T_ZDrvNv_PeriData	periData;
	/* 0x3500 */	T_ZDrvNv_AudioData	audioData;
	/* 0x3900 */	UINT8				reserved[DRV_RSVD_NV_SIZE];
} T_ZDrv_NvData;


/******************************************************
* 	check struct size
******************************************************/
static inline CHAR zDrvNv_CheckTypeSize(void)
{ \
	CHAR __dummy1[(sizeof(T_ZDrv_NvData)==DRV_NV_SIZE)?1:-1]={0}; \
	CHAR __dummy2[(sizeof(T_ZDrvNv_PubData)==DRV_PUB_NV_SIZE)?1:-1]={0}; \
	CHAR __dummy3[(sizeof(T_ZDrvNv_SysData)==DRV_SYS_NV_SIZE)?1:-1]={0}; \
	CHAR __dummy4[(sizeof(T_ZDrvNv_PlatData)==DRV_PLAT_NV_SIZE)?1:-1]={0}; \
	CHAR __dummy5[(sizeof(T_ZDrvNv_HSPeriData)==DRV_HS_PERI_NV_SIZE)?1:-1]={0}; \
	CHAR __dummy6[(sizeof(T_ZDrvNv_PeriData)==DRV_PERI_NV_SIZE)?1:-1]={0}; \
	CHAR __dummy7[(sizeof(T_ZDrvNv_AudioData)==DRV_AUDIO_NV_SIZE)?1:-1]={0}; \
	return (__dummy1[0]+__dummy2[0]+__dummy3[0]+__dummy4[0]+__dummy5[0]+__dummy6[0]+__dummy7[0]); \
}

/******************************************************
* 	old struct
******************************************************/
#if 0
typedef struct _T_Sys_Drv_Nv_Data
{
	T_SYS_NV_TSC_CONFIG tsc_config;
	UINT8 reserved[6];
	UINT32 wdtSwitch;
}T_Sys_Drv_Nv_Data;
#endif
typedef struct _T_Drv_Nv_Data
{
	UINT32 VpData[1024];//add by lvwenhua for voice 2013.12.6
}T_Drv_Nv_Data;

#define DRV_NV_ITEM_ADDRESS(x) (DRV_AUDIO_NV_ADDR + (UINT32)(&(((T_Drv_Nv_Data*)(0x0))->x)))
//flag use 32byte
typedef struct _T_Audio_NvFlag
{
    UINT8           isVpConfigInitOn;
    UINT8           isVpParamInNv;
    UINT8           isUseSlicCodec;
    UINT8           isUseVoiceProc;//4 UINT8           isUseNXP;
    UINT8           isUseCodecDsp;	
	UINT8			isUseNvWrite;
	UINT8			isCloseVpBufferBak;
	UINT8			isUseTdm;//8
	UINT8			isUseRxDtmfDet;
	UINT8			isUseTxDtmfDet;     
    UINT8			isUseRxMixData;
	UINT8			isUseTxMixData;//12
	UINT8			isUseEcall; //13
	UINT8 			isUseVoiceBuffer; //14  0 not use,1 use
	UINT8 			selVoiceBufferType; //15 0 single core, 1 dual core	
    UINT8           reserved[17];//32-15
	
}  T_Audio_NvFlag;

#endif

