/**
 * 
 * @file      zcat_ue_pc_int.h
 * @brief     
 *            This file is part of ZCAT.
 *            ZCATUEPCͷļ
 *            
 * @details   
 * @author    Tools Team.
 * @email     
 * @copyright Copyright (C) 2013 Sanechips Technology Co., Ltd.
 * @warning   
 * @date      2019/02/02
 * @version   1.1
 * @pre       
 * @post      
 *            
 * @par       
 * Change History :
 * ---------------------------------------------------------------------------
 * date        version  author         description
 * ---------------------------------------------------------------------------
 * 2013/01/21  1.0      lu.xieji       Create file
 * 2019/02/02  1.1      jiang.fenglin  ޸עͷʽΪdoxygen
 * ---------------------------------------------------------------------------
 * 
 * 
 */

#ifndef ZCAT_UE_PC_INT_H
#define ZCAT_UE_PC_INT_H
#include "zcat_dbg.h"

//UE ڴ鿴
#define ZCAT_UE_MEM_LOOKUP_READ      0
#define ZCAT_UE_MEM_LOOKUP_WRITE     1
#define ZCAT_UE_MEM_LOOKUP_AUDIO     2

// ZCATṹ
typedef struct
{
    UINT8   cmd_code;
    UINT8   padding;
    UINT16  reserved;
    UINT32  length;
    UINT32  timeStamp[2];
} T_ZCAT_HEADER;

typedef struct
{
    UINT16 diag_id;
    UINT16 len;
} T_ZCAT_DIAG_HEADER;

typedef struct
{
    T_ZCAT_HEADER       zcatHeader;
    T_ZCAT_DIAG_HEADER  diagHeader;
} T_ZCAT_DIAG_MSG;

typedef struct
{
    UINT16 type;
    UINT8  operation;
    UINT8  reserved;
} T_ZCAT_DIAG_CONFIG_REQ;

typedef enum
{
    DIAG_FILTER_CONFIG = 1,
    DIAG_DROP_COUNT,
    DIAG_LINK_MSG,
    DIAG_SIG_CONTROL_MSG,
    DIAG_NV_MSG,
    DIAG_LTE_CONTROL_MSG,
    DIAG_PS_GLB_MSG,
    DIAG_PS_FILTERRANK_MSG,
    DIAG_UE_MEM_LOOKUP,
    DIAG_RAMDUMP_MSG,
    DIAG_TSPVERSION_MSG,
    DIAG_SYSVIEW_MSG,
    DIAG_NVTOOL_MSG,
    DIAG_AUDIO_MSG,
    DIAG_AU_OPRATE_MSG
} T_ZCAT_DIAG_TYPE;

typedef enum
{
    ZCAT_SIG_REPORT     = 1,        // ׼ps log
    ZCAT_EVT_REPORT     = 2,        // EventϢ
    ZCAT_PRN_REPORT     = 3,        // modem print
    ZCAT_DBG_REPORT     = 4,        // phypsԭps쳣
    ZCAT_IPPPP_REPORT   = 5,        // ps EventϢ
    ZCAT_DIAG_REPORT    = 6,        // diagָ
    ZCAT_DIAG_NULL,                 // ֻռһλʹãʹPC

    ZCAT_AP_KERNEL_LOG  = 8,        // ap kernel log
    ZCAT_AP_APP_LOG     = 9,        // ap app log
    ZCAT_SIG_PHY        = 10,       // ׼phy log
    ZCAT_SMALL_CELL_LOG = 11,       // 
    ZCAT_SMALL_CELL_PRINT_LOG = 12, // 

	ZCAT_AP2_KERNEL_LOG  = 13,      // ap kernel log
    ZCAT_AP2_APP_LOG     = 14,      // ap app log
    
    ZCAT_CMDCODE_MAX
} T_ZCAT_CMDCODE;

typedef enum
{
    ZCAT_SIG_TYPE               = (ZCAT_SIG_REPORT),
    ZCAT_EVENT_TYPE             = (ZCAT_EVT_REPORT),
    ZCAT_PRINT_TYPE             = (ZCAT_PRN_REPORT),
    ZCAT_DBG_TYPE               = (ZCAT_DBG_REPORT),
    ZCAT_IPPPP_TYPE             = (ZCAT_IPPPP_REPORT),
    ZCAT_DIAG_TYPE              = (ZCAT_DIAG_REPORT),
    ZCAT_AP_KERNEL_TYPE         = (ZCAT_AP_KERNEL_LOG),
    ZCAT_AP_APP_TYPE            = (ZCAT_AP_APP_LOG),
    ZCAT_AP2_KERNEL_TYPE        = (ZCAT_AP2_KERNEL_LOG),
    ZCAT_AP2_APP_TYPE           = (ZCAT_AP2_APP_LOG),
    ZCAT_SMALL_CELL_TYPE        = (ZCAT_SMALL_CELL_LOG),
    ZCAT_SMALL_CELL_PRINT_TYPE  = (ZCAT_SMALL_CELL_PRINT_LOG),
    ZCAT_DBG_TYPE_TOTAL         = ((DBG_TYPE_TOTAL   << 8) | ZCAT_DBG_REPORT),
    ZCAT_DBG_GSM_PHY            = ((DBG_GSM_PHY      << 8) | ZCAT_DBG_REPORT),
    ZCAT_DBG_TD_PHY             = ((DBG_TD_PHY       << 8) | ZCAT_DBG_REPORT),
    ZCAT_DBG_LTE_PHY            = ((DBG_LTE_PHY      << 8) | ZCAT_DBG_REPORT),
    ZCAT_DBG_WCDMA_PHY          = ((DBG_WCDMA_PHY    << 8) | ZCAT_DBG_REPORT),
    ZCAT_DBG_PS_PRIMARY         = ((DBG_PS_PRIMARY   << 8) | ZCAT_DBG_REPORT),
    ZCAT_DBG_PS_EXCEPTION       = ((DBG_PS_EXCEPTION << 8) | ZCAT_DBG_REPORT),
    ZCAT_DBG_PS_GLOBAL          = ((DBG_PS_GLOBAL    << 8) | ZCAT_DBG_REPORT),
    ZCAT_DBG_ALL_TYPE           = ((DBG_ALL_TYPE     << 8) | ZCAT_DBG_REPORT),

    ZCAT_FILTER_VIEW            = 0xFFFE,
    ZCAT_ALL_TYPE               = 0xFFFF
} ZCAT_ENUM_TYPE;

typedef enum
{
    DISABLE_LOGGING = 0,
    ENABLE_LOGGING,
    GET_MASK,
    SET_MASK,

    DIAG_LAST_OPERATION
} T_ZCAT_DIAG_CONFIG_OPERATION_TYPE;

typedef struct
{
    UINT64 PCTime;
    UINT32 APTime;
    UINT32 CPTime;
}T_ZCAT_DIAG_UE_LINK_REQ;

typedef struct 
{
    UINT32      type;
    UINT32          addr;
    UINT32          len;
    UINT32     total;
    UINT32     index;
}T_ZCAT_UE_MEM_LOOKUP;

#define ZCAT_AUDIO_EXPORT_READ    0
#define ZCAT_AUDIO_EXPORT_RESEND  1
#define ZCAT_AUDIO_MAX_PACKET_LEN 32768
#define ZCAT_AUDIO_MAX_TRY_TIME   3

typedef struct
{
    UINT32 type;
    UINT32 operation;
    UINT32 index;
}T_ZCAT_AUDIO_EXPORT_REQ;

typedef struct
{
    UINT32 type;
    UINT32 blkNum;
    UINT32 index;
    UINT32 filelen;
}T_ZCAT_AUDIO_EXPORT_RSP;

#define ALIGNED_SIZE(size, alignment) (((size) + (alignment)) & ~(alignment))

#endif
