/*******************************************************************************
 * Copyright (C) 2016, ZIXC Corporation.
 *
 * File Name:cmd_bbt_count.c
 * File Mark:
 * Description:
 * Others:
 * Version:       1.0
 * Author:        lankai
 * Date:          2017-12-14
 * History 1:
 *     Date:
 *     Version:
 *     Author:
 *     Modification:
 * History 2:
  ********************************************************************************/


/****************************************************************************
* 	                                     Include files
****************************************************************************/
#include <common.h>
#include <command.h>
#include <nand.h>

#include "downloader_serial.h"
#include "errno.h"
#include <partition_table.h>
#include <boot_mode.h>

/****************************************************************************
*							Global Function Prototypes
****************************************************************************/
int crc_switch_flag = 0;
extern char *tsp_console_buffer;
extern partition_table_t *g_partition_table_dl;
extern partition_table_t *g_partition_table;


/*******************************************************************************
 * Function:do_bbt_count
 * Description:
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
 int do_bbt_count(cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{
	struct mtd_info *mtd = get_mtd_info();
	struct nand_chip *this = NULL;
	int bad_block_num = 0;
	int total_block_num = 0;
	char ack[64] = {0};

	if(argc != 1)
    {
        return cmd_usage(cmdtp);
    }

    if (NULL == mtd)
    {
    	printf("FAIL\n");
    	return ENODEV;
    }

	this = mtd->priv;
	bad_block_num = mtd->ecc_stats.badblocks;
	total_block_num = this->chipsize >> this->bbt_erase_shift;

	sprintf(ack, "bad_block_num:%04d total_block_num:%04d", bad_block_num, total_block_num);
	downloader_serial_write(ack, strlen(ack) + 1);

	return 0;
}

U_BOOT_CMD(
	bbt_count, CONFIG_SYS_MAXARGS, 0, do_bbt_count,	"bbt_count", ""
);

/*******************************************************************************
 * Function:do_crc
 * Description:
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
 int do_crc(cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{
	u_char *crc_flag = NULL;
	char *ack = tsp_console_buffer;
	
	if(argc<2)
	{
		return cmd_usage(cmdtp);
	}
	crc_flag = argv[1]; 

	if (strcmp((const char *)crc_flag,"on") == 0)
	{
        crc_switch_flag = 1;
		sprintf(ack,"OKAY");
	}
    else if (strcmp((const char *)crc_flag,"off") == 0)
    {
        crc_switch_flag = 0;
		sprintf(ack,"OKAY");
    }
	else
	{
		sprintf(ack,"FAIL COMMAND ERROR");
	}

	downloader_serial_write(ack, strlen(ack)+1);
	
	return 0;
}

U_BOOT_CMD(
	crc, CONFIG_SYS_MAXARGS, 0, do_crc,	"crc_check", ""
);


/*******************************************************************************
 * Function:do_crc
 * Description:
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
 int do_partition_bbc(cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{
	int i, j, len, bad_nums, partition_nums;
	char *ack = tsp_console_buffer;
	nand_info_t *nand = &nand_info[nand_curr_device];
	
	if(argc != 1)
	{
		return cmd_usage(cmdtp);
	}

	partition_entry_t *entry = NULL;
	uint32_t entry_nums = 0;
	if(get_load_mode() == TLOAD_MODE)
	{
		entry_nums = g_partition_table_dl->entrys;
		entry = &g_partition_table_dl->table[0];
	}
	else
	{
		entry_nums = g_partition_table->entrys;
		entry = &g_partition_table->table[0];
	}

	sprintf(ack, "partition_nums:%04d", entry_nums - 2);

	printf("entry_nums=%d\n", entry_nums - 2);

	for(i = 0; i < entry_nums - 2; i++)
	{ 
		printf("entry->part_offset=0x%x, entry->part_size=0x%x\n", 
				entry->part_offset, entry->part_size);
		bad_nums = 0;
		partition_nums = entry->part_size / nand->erasesize;
		for(j = 0; j < partition_nums; j++)
		{
			if(nand_block_isbad (nand, entry->part_offset + (loff_t)j * nand->erasesize))
			{
				printf("bad block addr = 0x%x\n", (entry->part_offset + j * nand->erasesize));
				bad_nums++;
			}
		}

		len = strlen(ack);
		sprintf(ack + len, " %s,%04d,%04d", entry->part_name, bad_nums, partition_nums);
		entry++;
	}

	printf("partition_bbc:%s\n", ack);
	
	downloader_serial_write(ack, strlen(ack) + 1);

	return 0;
}

U_BOOT_CMD(
	part_bbc, CONFIG_SYS_MAXARGS, 0, do_partition_bbc, "partition bad block count", ""
);


/*******************************************************************************
 * Function:do_single_partition_bbc
 * Description:
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
 int do_single_partition_bbc(cmd_tbl_t *cmdtp, int flag, 
 							 int argc, char * const argv[])
{
	int j, bad_nums, part_block_nums;
	u_char *partition_name = NULL;
	char *ack = tsp_console_buffer;
	nand_info_t *nand = &nand_info[nand_curr_device];
	partition_entry_t *entry = NULL;
	
	if(argc < 2)
	{
		return cmd_usage(cmdtp);
	}

	partition_name = argv[1];

	entry = find_partition_para(partition_name);
	if(entry == NULL)
	{
		BOOT_PRINTF(UBOOT_ERR, "[%s]: can't find the partition...\n", partition_name);
		return 1;
	}
	
	printf("entry->part_offset=0x%x, entry->part_size=0x%x\n", 
			entry->part_offset, entry->part_size);
	bad_nums = 0;
	part_block_nums = entry->part_size / nand->erasesize;
	for(j = 0; j < part_block_nums; j++)
	{
		if(nand_block_isbad (nand, entry->part_offset + (loff_t)j * nand->erasesize))
		{
			printf("bad block addr = 0x%x\n", (entry->part_offset + j * nand->erasesize));
			bad_nums++;
		}
	}

	sprintf(ack, "%s,%04d,%04d", entry->part_name, bad_nums, part_block_nums);
	printf("single_partition_bbc:%s\n", ack);	
	downloader_serial_write(ack, strlen(ack) + 1);

	return 0;
}

U_BOOT_CMD(
	single_part_bbc, CONFIG_SYS_MAXARGS, 0, do_single_partition_bbc, 
	"single partition bad block count", ""
);


/*******************************************************************************
 * Function:do_badblock_query
 * Description:
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
 int do_badblock_query(cmd_tbl_t *cmdtp, 
 					   int flag, 
 					   int argc, 
 					   char * const argv[])
{
	u_char *crc_flag = NULL;
	int flash_type = 0;
	char *ack = tsp_console_buffer;
	
	if(argc != 1)
	{
		return cmd_usage(cmdtp);
	}

	crc_flag = argv[0]; 	
	if(strcmp((const char *)crc_flag,"badblock_query") != 0)
	{
		sprintf(ack,"COMMAND ERROR");	
		downloader_serial_write(ack, strlen(ack) + 1);
		return -1;
	}

	flash_type = read_boot_flashtype();
	switch(flash_type)
	{
		case IF_TYPE_NAND:
		case IF_TYPE_SPI_NAND:		
			sprintf(ack,"SUPPORT");
			break;
		default:
			sprintf(ack,"UNSUPPORT");
			break;
	}	
	downloader_serial_write(ack, strlen(ack) + 1);

	return 0;
}

U_BOOT_CMD(
	badblock_query, CONFIG_SYS_MAXARGS, 0, do_badblock_query, 
	"is support bad block query", ""
);

/*
 ******************************************************************************
 * Function:do_part_valid_space_query
 * Description:
 * Parameters:
 *	 Input:
 *	 Output:
 * Returns:
 * Others:
 *******************************************************************************
 */
 int do_part_valid_space_query(cmd_tbl_t *cmdtp, int flag, 
 							 int argc, char * const argv[])
{
	int j, bad_nums, part_block_nums;
	u_char *partition_name = NULL;
	char *ack = tsp_console_buffer;
	nand_info_t *nand = &nand_info[nand_curr_device];
	partition_entry_t *entry = NULL;
	int flash_type = 0;
	unsigned int valid_space_size = 0;
	
	if(argc < 2)
	{
		return cmd_usage(cmdtp);
	}

	partition_name = argv[1];

	entry = find_partition_para(partition_name);
	if(entry == NULL)
	{
		BOOT_PRINTF(UBOOT_ERR, "[%s]: can't find the partition...\n", partition_name);
        sprintf(ack,"FAIL INVALID PARTITION");
        downloader_serial_write(ack, strlen(ack)+1);
		return -1;
	}

	flash_type = read_boot_flashtype();
	if(flash_type == IF_TYPE_NOR)
	{
		valid_space_size = entry->part_size;
	}
	else
	{
		bad_nums = 0;
		part_block_nums = entry->part_size / nand->erasesize;
		for(j = 0; j < part_block_nums; j++)
		{
			if(nand_block_isbad (nand, entry->part_offset + (loff_t)j * nand->erasesize))
			{
				printf("bad block addr = 0x%x\n", (entry->part_offset + j * nand->erasesize));
				bad_nums++;
			}
		}
		valid_space_size = entry->part_size - bad_nums * nand->erasesize;
	}

	sprintf(ack, "%s,%08x", entry->part_name, valid_space_size);
	printf("part_valid_space_query:%s\n", ack);	
	downloader_serial_write(ack, strlen(ack) + 1);

	return 0;
}

U_BOOT_CMD(
	part_valid_space_query, CONFIG_SYS_MAXARGS, 0, do_part_valid_space_query, 
	"get partition valid physics space size", ""
);



