/*******************************************************************************
* Ȩ (C)2013, ͨѶɷ޹˾
* 
* ļ:     cache.c
* ļʶ:     cache.c
* ժҪ:     tosں˻(cache)ģ
* 
* ޸        汾      ޸ı        ޸          ޸
* ------------------------------------------------------------------------------
* 2013/11/29      V1.0        Create                    
* 
*******************************************************************************/

/*******************************************************************************
*                                   ͷļ                                     *
*******************************************************************************/
#include "cache_v7_asm.h"

#ifdef __cplusplus
extern "C" {
#endif


/*******************************************************************************
*                                ⲿ                                  *
*******************************************************************************/


/*******************************************************************************
*                                ⲿ                                  *
*******************************************************************************/
void l2_cache_enable(void) {};
void l2_cache_disable(void) {};
void l2_cache_invalidate_range(unsigned long addr, unsigned long len) {};
void l2_cache_invalidate_all(void) {};
void l2_cache_clean_range(unsigned long addr, unsigned long len) {};
void l2_cache_clean_all(void) {};
void l2_cache_sync(void) {};


/*******************************************************************************
*                                                                      *
*******************************************************************************/


/*******************************************************************************
*                                   궨                                     *
*******************************************************************************/


/*******************************************************************************
*                                Ͷ                                  *
*******************************************************************************/


/*******************************************************************************
*                                ֲ                                  *
*******************************************************************************/


/*******************************************************************************
*                              ֲ̬                                *
*******************************************************************************/


/*******************************************************************************
*                                ȫֱ                                  *
*******************************************************************************/


/*******************************************************************************
*                                ֲʵ                                  *
*******************************************************************************/


/*******************************************************************************
*                                ȫֺʵ                                  *
*******************************************************************************/

/*******************************************************************************
* :     Cacheʹܺ
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     void
* ˵:     void
*******************************************************************************/
void cache_enable(void)
{
    u32 old_intr = 0;

    local_irq_save(old_intr);
    HAL_ICACHE_ENABLE();
    HAL_DCACHE_ENABLE();
    l2_cache_enable();
    local_irq_restore(old_intr);
}


/*******************************************************************************
* :     Cacheȥʹܺ
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     void
* ˵:     void
*******************************************************************************/
void cache_disable_asm(void)
{
    u32 old_intr = 0;

    local_irq_save(old_intr);
    HAL_ICACHE_DISABLE();
    HAL_DCACHE_DISABLE();
    l2_cache_disable();
	HAL_MMU_DISABLE();
    local_irq_restore(old_intr);
}

/*******************************************************************************
* :     CacheЧ
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     void
* ˵:     void
*******************************************************************************/
void cache_invalidate_range(unsigned long addr, unsigned long len)
{
    u32 old_intr = 0;

    local_irq_save(old_intr);
    HAL_ICACHE_INVALIDATE_BY_RANGE(addr, len);
    HAL_DCACHE_INVALIDATE_BY_RANGE(addr, len);
    HAL_DSB();
    l2_cache_invalidate_range(addr, len);
    l2_cache_sync();
    local_irq_restore(old_intr);
}

/*******************************************************************************
* :     DcacheЧ
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     void
* ˵:     void
*******************************************************************************/
void dcache_invalidate_range(unsigned long addr, unsigned long len)
{
    u32 old_intr = 0;

    local_irq_save(old_intr);
    HAL_DCACHE_INVALIDATE_BY_RANGE(addr, len);
    HAL_DSB();
    l2_cache_invalidate_range(addr, len);
    l2_cache_sync();
    local_irq_restore(old_intr);
}

/*******************************************************************************
* :     CacheЧ
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     void
* ˵:     void
*******************************************************************************/
void cache_invalidate_all(void)
{
    u32 old_intr = 0;

    local_irq_save(old_intr);
    HAL_ICACHE_INVALIDATE_ALL();
    HAL_DCACHE_INVALIDATE_ALL();
    HAL_DSB();
    l2_cache_invalidate_all();
    l2_cache_sync();
    local_irq_restore(old_intr);
}

/*******************************************************************************
* :     Cache
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     void
* ˵:     void
*******************************************************************************/
void cache_clean_range(unsigned long addr, unsigned long len)
{
    u32 old_intr = 0;

    local_irq_save(old_intr);
    HAL_DCACHE_CLEAN_BY_RANGE(addr, len);
    HAL_DSB();
    l2_cache_clean_range(addr, len);
    l2_cache_sync();
    local_irq_restore(old_intr);
}

/*******************************************************************************
* :     Cache
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     void
* ˵:     void
*******************************************************************************/
void cache_clean_all_asm(void)
{
    u32 old_intr = 0;

    local_irq_save(old_intr);
    HAL_DCACHE_CLEAN_ALL();
    HAL_DSB();
    l2_cache_clean_all();
    l2_cache_sync();
    local_irq_restore(old_intr);
}

/*******************************************************************************
* :     CacheЧ
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     void
* ˵:     void
*******************************************************************************/
void cache_clean_invalidate_range(unsigned long addr, unsigned long len)
{
    u32 old_intr = 0;

    local_irq_save(old_intr);
    HAL_DCACHE_CLEAN_BY_RANGE(addr, len);
    HAL_DSB();
    l2_cache_clean_range(addr, len);
    l2_cache_sync();
    l2_cache_invalidate_range(addr, len);
    l2_cache_sync();
    HAL_ICACHE_INVALIDATE_BY_RANGE(addr, len);
    HAL_DCACHE_INVALIDATE_BY_RANGE(addr, len);
    HAL_DSB();
    local_irq_restore(old_intr);
}

/*******************************************************************************
* :     CacheЧ
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     void
* ˵:     void
*******************************************************************************/
void cache_clean_invalidate_all(void)
{
    u32 old_intr = 0;

    local_irq_save(old_intr);
    HAL_DCACHE_CLEAN_ALL();
    HAL_DSB();
    l2_cache_clean_all();
    l2_cache_sync();
    l2_cache_invalidate_all();
    l2_cache_sync();
    HAL_ICACHE_INVALIDATE_ALL();
    HAL_DCACHE_INVALIDATE_ALL();
    HAL_DSB();
    local_irq_restore(old_intr);
}

#ifdef __cplusplus
}
#endif

