/*  
 * (C) Copyright 2016, ZIXC Corporation.
 *
 */

#include <common.h>
#include <asm/io.h> 
#include <asm/proc-armv/ptrace.h>
#include <asm/arch/hardware.h>
#include <div64.h>
#include <asm/arch/lsp_crpm.h>
#include <asm/arch/irq.h>
#include <asm/arch/gic.h>

#if CONFIG_USE_IRQ

typedef void (*Int_handlePtr)(void);             
Int_handlePtr g_irqHandlePtr[NR_IRQS] = {0};         
            
void do_irq (struct pt_regs *pt_regs)
{
    uint32_t irqstat, irqnr;
    irqstat = readl(GIC_CPU_BASE + GIC_CPU_INTACK);
	irqnr = (irqstat & ~0xc00) - GIC_SPI_START;
    if( g_irqHandlePtr[irqnr] == NULL )
        printf("NONE Interrupt Ptr\n");
    else
        (g_irqHandlePtr[irqnr])();
}

static void  gic_dist_init( void )
{
	unsigned int i;
	u32 cpumask;

	cpumask = 1;
	cpumask |= cpumask << 8;
	cpumask |= cpumask << 16;

	writel(0, GIC_DIST_BASE + GIC_DIST_CTRL);

	/*
	 * Set all global interrupts to be level triggered, active low.
	 */
	for (i = 32; i < NR_IRQS; i += 16)
		writel(0, GIC_DIST_BASE + GIC_DIST_CONFIG + i * 4 / 16);

	/*
	 * Set all global interrupts to this CPU only.
	 */
	for (i = 32; i < NR_IRQS; i += 4)
		writel(cpumask, GIC_DIST_BASE + GIC_DIST_TARGET + i * 4 / 4);

	/*
	 * Set priority on all global interrupts.
	 */
	for (i = 32; i < NR_IRQS; i += 4)
		writel(0xa0a0a0a0, GIC_DIST_BASE + GIC_DIST_PRI + i * 4 / 4);

	/*
	 * Disable all interrupts.  Leave the PPI and SGIs alone
	 * as these enables are banked registers.
	 */
	for (i = 32; i < NR_IRQS; i += 32)
		writel(0xffffffff, GIC_DIST_BASE + GIC_DIST_ENABLE_CLEAR + i * 4 / 32);

	writel(1, GIC_DIST_BASE + GIC_DIST_CTRL);
}

static void  gic_cpu_init(void)
{
	int i;

	/*
	 * Deal with the banked PPI and SGI interrupts - disable all
	 * PPI interrupts, ensure all SGI interrupts are enabled.
	 */
	writel(0xffff0000, GIC_DIST_BASE + GIC_DIST_ENABLE_CLEAR);
	writel(0x0000ffff, GIC_DIST_BASE + GIC_DIST_ENABLE_SET);

	/*
	 * Set priority on PPI and SGI interrupts
	 */
	for (i = 0; i < 32; i += 4)
		writel(0xa0a0a0a0, GIC_DIST_BASE + GIC_DIST_PRI + i * 4 / 4);

	writel(0xf0, GIC_CPU_BASE + GIC_CPU_PRIMASK);
	writel(1, GIC_CPU_BASE + GIC_CPU_CTRL);
}


int	arch_interrupt_init	(void)
{
    gic_dist_init();
    gic_cpu_init();   
}

#endif
