/*********************************************************************
 Copyright 2014 by  ZTE Corporation.
*
* FileName::
* File Mark:
* Description:
* Others:
* Version:
* Author:
* Date:

* History 1:
*     Date:
*     Version:
*     Author:
*     Modification:
* History 2:
**********************************************************************/

/*******************************************************************************
*                                  Include files
*******************************************************************************/
#include <common.h>
#include <errno.h>
#include <command.h>
#include <malloc.h>
#include <asm/io.h>
#include <boot_mode.h>
#include <i2c.h>
#include <drvs_gpio.h>
#include "drvs_aw9523b.h"
#include <lcd_blg.h>


/*******************************************************************************
*                                  Macro
*******************************************************************************/
#define AW9523B_AD1AD0              (0x3)   /* AD1, AD0 pin connection */
#define AW9523B_ROW_POS             (1)     /* start position of adjacent row pins */
#define AW9523B_ROW_NUM             (7)     /* count of adjacent row pins */
#define AW9523B_COL_POS             (4)     /* start position of adjacent column pins */
#define AW9523B_COL_NUM             (3)     /* count of adjacent column pins */

#define ROW_BITS_MASK               (((1<<AW9523B_ROW_NUM) - 1)<<AW9523B_ROW_POS)
#define COL_BITS_MASK               (((1<<AW9523B_COL_NUM) - 1)<<AW9523B_COL_POS)

#define AW9523B_I2C_SLAVE_ADDR      (I2C_ADDR_AW9523B_WITHOUT_AD | AW9523B_AD1AD0)

/*******************************************************************************
*                                  Types
*******************************************************************************/
typedef struct
{
    UINT8   addr;
    UINT8   value;
} T_ZDrvKpd_ChipConfig;

/*******************************************************************************
*                           Function Prototypes
*******************************************************************************/


/*******************************************************************************
*                           Global  Variable
*******************************************************************************/
static const UINT32 s_kpdGpioReset = 75;      /* keypad chip reset pin */
/* other chips which use the same i2c bus */
static const UINT32 s_codecGpioReset = 71;      /* codec chip reset pin */
static const UINT32 s_cameraGpioReset = 44;      /* camera chip reset pin */

/*******************************************************************************
*                           Function Defines
*******************************************************************************/

/*******************************************************************************
 * Function:    zx234290_i2c_read_reg
 * Description:
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
int aw9523b_i2c_read_reg(ushort reg, uchar *val)
{
    return i2c_read(1, AW9523B_I2C_SLAVE_ADDR, reg, 8, val, 1);
}

/*******************************************************************************
 * Function:    zx234290_i2c_write_reg
 * Description:
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
int aw9523b_i2c_write_reg(ushort reg, uchar *val)
{
	return i2c_write(1, AW9523B_I2C_SLAVE_ADDR, reg, 8, val, 1);
}

/*******************************************************************************
* Function:     kpd_ChipReset
* Description:  reset the keypad and backlight chip.
* Parameters:
*   Input:
*       None
*   Output:
*       None
* Returns:
*       DRV_SUCCESS or error code.
* Others:
*******************************************************************************/
static SINT32 kpd_ChipReset(VOID)
{
    SINT32 ret = SUCCESS;

#if 1
    /* reset camera */
    zDrvGpio_PullUpDown(s_cameraGpioReset, 0);
    zDrvGpio_SetFunc(s_cameraGpioReset, GPIO44_GPIO44);
    zDrvGpio_SetDirection(s_cameraGpioReset, GPIO_OUT);
    zDrvGpio_SetOutputValue(s_cameraGpioReset, GPIO_LOW);

    /* reset codec */
    zDrvGpio_PullUpDown(s_codecGpioReset, 0);
    zDrvGpio_SetFunc(s_codecGpioReset, GPIO71_GPIO71);
    zDrvGpio_SetDirection(s_codecGpioReset, GPIO_OUT);
    zDrvGpio_SetOutputValue(s_codecGpioReset, GPIO_LOW);
#endif

    ret = zDrvGpio_PullUpDown(s_kpdGpioReset, 0);
    if( ret != SUCCESS )
    {
        return -EIO;
    }

    ret = zDrvGpio_SetFunc(s_kpdGpioReset, GPIO75_GPIO75);
    if( ret != SUCCESS )
    {
        return -EIO;
    }

    zDrvGpio_SetDirection(s_kpdGpioReset, GPIO_OUT);
    zDrvGpio_SetOutputValue(s_kpdGpioReset, GPIO_LOW);

    udelay(100000/30/200); /*Actual 0.1s/200, i.e. 50us */

    zDrvGpio_SetOutputValue(s_kpdGpioReset, GPIO_HIGH);

    udelay(100000/30/200); /*Actual 0.1s/200, i.e. 50us */

    return SUCCESS;
}

/*******************************************************************************
* Function:     zDrvLcdBlg_Initiate
* Description:  Initiate the keypad and backlight chip
* Parameters:
*   Input:
*       None
*   Output:
*       None
* Returns:
*       DRV_SUCCESS or error code
* Others:
*******************************************************************************/
SINT32 zDrvLcdBlg_Initiate(VOID)
{
    const T_ZDrvKpd_ChipConfig aw9523b_configs[] = {
        {REG_MODE_P0, COL_BITS_MASK},
        {REG_MODE_P1, ROW_BITS_MASK},
    };
    SINT32  ret     = SUCCESS;
    SINT32  i       = 0;
    UINT8   tmp_reg = 0;

    ret = kpd_ChipReset();
    if(ret != SUCCESS)
    {
        return ret;
    }

    /* check I2C communication and chip status */
    ret = aw9523b_i2c_read_reg(REG_ID, &tmp_reg);
    if (ret != SUCCESS)
    {
        return -EIO;
    }
    if(tmp_reg != AW9523B_REG_ID_VALUE)
    {
        return -EIO;
    }

    /* set chip registers */
    for (i = 0; i < (sizeof(aw9523b_configs) / sizeof(aw9523b_configs[0])); i++)
    {
        ret = aw9523b_i2c_write_reg(aw9523b_configs[i].addr, &aw9523b_configs[i].value);
        if (ret != SUCCESS)
        {
            return -EIO;
        }
    }

    return SUCCESS;
}

/*******************************************************************************
* Function:     zDrvLcdBlg_SetBlg
* Description:  Set lcd backlight.
* Parameters:
*   Input:
*       brightness:
*   Output:
*       None
* Returns:
*       DRV_SUCCESS or error code
* Others:
*******************************************************************************/
SINT32 zDrvLcdBlg_SetBlg(UINT8 brightness)
{
    SINT32 ret = SUCCESS;
    uchar val = brightness;

    ret |= aw9523b_i2c_write_reg(REG_DIM0, &val);
    ret |= aw9523b_i2c_write_reg(REG_DIM4, &val);
    ret |= aw9523b_i2c_write_reg(REG_DIM5, &val);

    return ret;
}

