/*
 ******************************************************************************
 * Copyright (C) 2016, ZIXC Corporation.
 *
 * File Name:   hal_led.c
 * File Mark:
 * Description:  This file contains the hal layer routines for i2c driver.
 * Others:
 * Version:       V1.0
 * Author:        yx
 * Date:          2014-07-03
 * History 1:
 *     Date:
 *     Version:
 *     Author:
 *     Modification:
 * History 2:
 *****************************************************************************
 */

/*
***************************************************************************
*                                  Include files
***************************************************************************
*/
#include <drvs_gpio.h>
#include <led.h>

/*
***************************************************************************
* 	                                           Local Constants
***************************************************************************
*/
struct leds_device_para
{
    UINT32 gpio_id;            
    T_ZDrvGpio_FuncSel func_sel;          
    T_ZDrvGpio_IoDirection to_dir;        
    T_ZDrvGpio_IoVal to_value;            
};

const struct leds_device_para leds_defalut_config[] = {
	{LED_LTE_RED,LED_LTE_RED_FUNC_SEL,GPIO_OUT,GPIO_HIGH},
	{LED_LTE_BLUE,LED_LTE_BLUE_FUNC_SEL,GPIO_OUT,GPIO_HIGH},
	{LED_WIFI,LED_WIFI_FUNC_SEL,GPIO_OUT,GPIO_HIGH},
	{LED_WPS,LED_WPS_FUNC_SEL,GPIO_OUT,GPIO_HIGH},
	{LED_RJ11,LED_RJ11_FUNC_SEL,GPIO_OUT,GPIO_HIGH},
	{LED_4G_1,LED_4G_1_FUNC_SEL,GPIO_OUT,GPIO_HIGH},
	{LED_4G_2,LED_4G_2_FUNC_SEL,GPIO_OUT,GPIO_HIGH},
	{LED_4G_3,LED_4G_3_FUNC_SEL,GPIO_OUT,GPIO_HIGH},
	{LED_4G_4,LED_4G_4_FUNC_SEL,GPIO_OUT,GPIO_HIGH},
	{LED_4G_5,LED_4G_5_FUNC_SEL,GPIO_OUT,GPIO_HIGH},
	{0,}
}; 

/*
***************************************************************************
* 	                                           Local Constants
***************************************************************************
*/
void led_on(UINT32 led_id)
{
    zDrvGpio_SetOutputValue(led_id,GPIO_HIGH);
}

void led_off(UINT32 led_id)
{
    zDrvGpio_SetOutputValue(led_id,GPIO_LOW);
}

void zx29_led_init(void)
{
	struct leds_device_para *table = leds_defalut_config;

	for(; table->gpio_id != 0; table++)
	{
	    zDrvGpio_SetFunc(table->gpio_id,table->func_sel);
    	zDrvGpio_SetDirection(table->gpio_id,table->to_dir);
		zDrvGpio_SetOutputValue(table->gpio_id,table->to_value);
	}
}

void zx29_led_PowerOnLedOn(void)
{
	struct leds_device_para *table = leds_defalut_config;

	for(; table->gpio_id != 0; table++)
	{
		led_on(table->gpio_id);
	}
}
void zx29_led_PowerOnLedOff(void)
{	
	struct leds_device_para *table = leds_defalut_config;

	for(; table->gpio_id != 0; table++)
	{
		led_off(table->gpio_id);
	}
}

