#include <common.h>
#include <command.h>
#include <net.h>
#include <jffs2/load_kernel.h>
#include <common.h>
#include <asm/arch/hardware.h>
#include <i2c.h>
#include <asm/arch/uart.h>
#include <asm/arch/lsp_crpm.h>
#include "errno.h"

//#if CONFIG_HARDWARE_TEST
#if 0

#define TPS65912_I2C_SLAVE_ADDR0   (0x2D)

#define TPS65912_REG_ADDR_GPIO3            0x43
#define TPS65912_REG_ADDR_GPIO4            0x44
#define TPS65912_REG_ADDR_GPIO5            0x45
#define GPIO_ODEN_LSH			5
#define GPIO_CFG_LSH			2
#define GPIO_LED_ONOFF_LSH		0
#define GPIO_BIT_SET			1

#if 1
#define TPS65912_BITFVAL(var, lsh)   ( (var) << (lsh) )
#define TPS65912_BITFMASK(wid, lsh)  ( ((1U << (wid)) - 1) << (lsh) )
#define TPS65912_BITFEXT(var, wid, lsh)   ((var & TPS65912_BITFMASK(wid, lsh)) >> (lsh))

#define PMIC_ALL_BITS   0xFF
#endif

int zDrvPmic_SetRegister(uchar slv_addr, uchar reg_addr, uchar data, uchar mask)
{
    int ret = 0;
    uchar content =0;

    // If it is not updating the whole register (8 bits), we need to read
    // the register first.  Then we set the bits and write it back.
    if ((mask & PMIC_ALL_BITS) ^ PMIC_ALL_BITS) /* 0xFF=0b 1111 1111, mask xx11xxx , */
    {
        ret = i2c_read(0, slv_addr, reg_addr, 8, &content, 1);
        if (ret != 0)
        {
            return ret;
        }
        content &= ~mask;
        content |= data & mask;
    }
    else
    {
        content = data;
    }

    ret = i2c_write(0, slv_addr, reg_addr, 8, &content, 1);
    if (ret != 0)
    {
        return ret;
    }

    return ret;
}


int tcled_init(void)
{
	int ret = 0;
	uchar slv_addr=0, reg_addr=0, reg_val=0, mask=0;
	
#if 1		/* set led as GPIO	*/
	/* GPIO_3	*/
	/* ODEN	 - 1 */
	slv_addr = TPS65912_I2C_SLAVE_ADDR0;
	reg_addr = TPS65912_REG_ADDR_GPIO3;
	
	reg_val = TPS65912_BITFVAL(1, GPIO_ODEN_LSH );	/* һ val = 1;λ1 */
	mask = TPS65912_BITFMASK(GPIO_BIT_SET, GPIO_ODEN_LSH);
	ret = zDrvPmic_SetRegister(slv_addr, reg_addr, reg_val, mask);		
	/* CFG	 - 1 */
	reg_val = TPS65912_BITFVAL(1, GPIO_CFG_LSH);
	mask = TPS65912_BITFMASK(GPIO_BIT_SET, GPIO_CFG_LSH);
	ret = zDrvPmic_SetRegister(slv_addr, reg_addr, reg_val, mask);


	/* GPIO_4	*/
	/* ODEN	 - 1 */
	slv_addr = TPS65912_I2C_SLAVE_ADDR0;
	reg_addr = TPS65912_REG_ADDR_GPIO4;
	
	reg_val = TPS65912_BITFVAL(1, GPIO_ODEN_LSH );
	mask = TPS65912_BITFMASK(GPIO_BIT_SET, GPIO_ODEN_LSH);
	ret = zDrvPmic_SetRegister(slv_addr, reg_addr, reg_val, mask);		
	/* CFG	 - 1 */
	reg_val = TPS65912_BITFVAL(1, GPIO_CFG_LSH );
	mask = TPS65912_BITFMASK(GPIO_BIT_SET, GPIO_CFG_LSH);
	ret = zDrvPmic_SetRegister(slv_addr, reg_addr, reg_val, mask);


	/* GPIO_5	*/
	/* ODEN	 - 1 */
	slv_addr = TPS65912_I2C_SLAVE_ADDR0;
	reg_addr = TPS65912_REG_ADDR_GPIO5;
	
	reg_val = TPS65912_BITFVAL(1, GPIO_ODEN_LSH );
	mask = TPS65912_BITFMASK(GPIO_BIT_SET, GPIO_ODEN_LSH);
	ret = zDrvPmic_SetRegister(slv_addr, reg_addr, reg_val, mask);		
	/* CFG	 - 1 */
	reg_val = TPS65912_BITFVAL(1, GPIO_CFG_LSH);
	mask = TPS65912_BITFMASK(GPIO_BIT_SET, GPIO_CFG_LSH);
	ret = zDrvPmic_SetRegister(slv_addr, reg_addr, reg_val, mask);
#endif

	/* set the leds initial status */
	/* CLOSE LEDA - RED */
	slv_addr = TPS65912_I2C_SLAVE_ADDR0;
	reg_addr = TPS65912_REG_ADDR_GPIO3; 
	reg_val = TPS65912_BITFVAL(1, GPIO_LED_ONOFF_LSH);
	mask = TPS65912_BITFMASK(GPIO_BIT_SET, GPIO_LED_ONOFF_LSH);
	ret = zDrvPmic_SetRegister(slv_addr, reg_addr, reg_val, mask);

	/* CLOSE LEDB - GREEN	*/
	slv_addr = TPS65912_I2C_SLAVE_ADDR0;
	reg_addr = TPS65912_REG_ADDR_GPIO4;
	reg_val = TPS65912_BITFVAL(1, GPIO_LED_ONOFF_LSH);
	mask = TPS65912_BITFMASK(GPIO_BIT_SET, GPIO_LED_ONOFF_LSH);
	ret = zDrvPmic_SetRegister(slv_addr, reg_addr, reg_val, mask);

	/* CLOSE LEDC - BLUE	*/
	slv_addr = TPS65912_I2C_SLAVE_ADDR0;
	reg_addr = TPS65912_REG_ADDR_GPIO5;
	reg_val = TPS65912_BITFVAL(1, GPIO_LED_ONOFF_LSH);
	mask = TPS65912_BITFMASK(GPIO_BIT_SET, GPIO_LED_ONOFF_LSH);
	ret = zDrvPmic_SetRegister(slv_addr, reg_addr, reg_val, mask);

	return ret;

}

int tcled_on(int led_red, int led_green, int led_blue)
{
	int ret = 0;
	uchar slv_addr=0, reg_addr=0, reg_val=0, mask=0;
	uchar statusA = 0;
	uchar statusB = 0;
	uchar statusC = 0;

	slv_addr = TPS65912_I2C_SLAVE_ADDR0;

	statusA = led_red ? 0 : 1;	/* led_red=1,ʾGPIOΪ0	*/
	statusB = led_green ? 0 : 1;
	statusC = led_blue ? 0 : 1;

		/* LEDA  Ĳ	*/
	slv_addr = TPS65912_I2C_SLAVE_ADDR0;
	reg_addr = TPS65912_REG_ADDR_GPIO3; 	
	reg_val = TPS65912_BITFVAL(statusA, 0);
	mask = TPS65912_BITFMASK(1, 0);
	ret = zDrvPmic_SetRegister(slv_addr, reg_addr, reg_val, mask);

	/* LEDB  Ĳ	*/
	slv_addr = TPS65912_I2C_SLAVE_ADDR0;
	reg_addr = TPS65912_REG_ADDR_GPIO4;
	reg_val = TPS65912_BITFVAL(statusB, 0);		/* statusB=0: =1, */
	mask = TPS65912_BITFMASK(1, 0);
	ret = zDrvPmic_SetRegister(slv_addr, reg_addr, reg_val, mask);

	/* LEDC  Ĳ	*/
	slv_addr = TPS65912_I2C_SLAVE_ADDR0;
	reg_addr = TPS65912_REG_ADDR_GPIO5;
	reg_val = TPS65912_BITFVAL(statusB, 0);		/* statusB=0: =1, */
	mask = TPS65912_BITFMASK(1, 0);
	ret = zDrvPmic_SetRegister(slv_addr, reg_addr, reg_val, mask);	
}

void leds_on(void)
{	
	tcled_on(1, 0, 0);
	tcled_on(0, 1, 0);
	tcled_on(1, 0, 1);
	udelay(1000000);
	tcled_on(1, 1, 0);
	tcled_on(1, 0, 1);
	tcled_on(0, 1, 1);
	udelay(1000000);
	tcled_on(1, 1, 1);
	tcled_on(0, 0, 0);
}


int do_test_tcled(void) 
{
	tcled_init();
	
    uint8_t i = 10;
    while( i-- )
    {
        leds_on();
    }
    return 0;
}

U_BOOT_CMD(
	test_tcled, CONFIG_SYS_MAXARGS, 0, do_test_tcled,
	"test_TCled: test_tcled ",
	""
);

#endif


