#include "atci_common.h"
#include "atci_at_util.h"

int atci_at_skip_space(char **p_cur) {
  if (*p_cur == NULL) {
    return SYS_FAIL;
  }
  while (**p_cur == ATCI_SPACE) {
    (*p_cur)++;
  }
  return SYS_SUCC;
}
int atci_at_hasmore(char **p_cur) {
  if (*p_cur == NULL || **p_cur == ATCI_END_CHAR) {
    return SYS_FAIL;
  }
  return SYS_SUCC;
}

int atci_at_to_equal(char **p_cur) {
  if (*p_cur == NULL) {
    return SYS_FAIL;
  }
  *p_cur = strchr(*p_cur, ATCI_EQUAL);
  if (*p_cur == NULL) {
    return SYS_FAIL;
  }
  (*p_cur)++;
  return SYS_SUCC;
}
int atci_at_to_colon(char **p_cur) {
  if (*p_cur == NULL) {
    return SYS_FAIL;
  }
  *p_cur = strchr(*p_cur, ATCI_COLON);
  if (*p_cur == NULL) {
    return SYS_FAIL;
  }
  (*p_cur)++;
  return SYS_SUCC;
}
int atci_at_skip_next_comma(char **p_cur) {
  if (*p_cur == NULL) {
    return SYS_FAIL;
  }
  *p_cur = strchr(*p_cur, ATCI_COMMA);
  if (*p_cur == NULL) {
    return SYS_FAIL;
  }
  (*p_cur)++;
  return SYS_SUCC;
}
int atci_at_get_next_key(char **p_cur, char **p_out) {
  if (*p_cur == NULL) {
    return SYS_FAIL;
  }
  atci_at_skip_space(p_cur);
  if (**p_cur == ATCI_DOUBLE_QUOTE) {
    (*p_cur)++;
    *p_out = strsep(p_cur, "\"");
    atci_at_skip_next_comma(p_cur);
  } else {
    *p_out = strsep(p_cur, ",");
  }
  return SYS_SUCC;
}

/**
 * Parses the next integer in the  line and places it in *p_out
 * "uns" is indicate in unsigned or not
 * returns SYS_SUCC on success
 * returns SYS_FAIL  on fail
 * updates *p_cur
 * "base" is the same as the base param in strtol
 */
int atci_at_get_nextint_base(char **p_cur, int *p_out, int base, int uns) {
  char *ret;
  if (*p_cur == NULL) {
    return SYS_FAIL;
  }
  if (SYS_FAIL == atci_at_get_next_key(p_cur, &ret)) {
    return SYS_FAIL;
  } else {
    long l;
    char *end;
    if (uns) {
      l = strtoul(ret, &end, base);
    } else {
      l = strtol(ret, &end, base);
    }
    *p_out = (int) l;
    if (end == ret) {
      return SYS_FAIL;
    }
  }
  return SYS_SUCC;
}
int atci_at_get_nextint(char **p_cur, int *p_out) {
  return atci_at_get_nextint_base(p_cur, p_out, 10, 0);
}
int atci_at_get_nexthexint(char **p_cur, int *p_out) {
  return atci_at_get_nextint_base(p_cur, p_out, 16, 1);
}

