// SPDX-License-Identifier: MediaTekProprietary
/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 */
/* MediaTek Inc. (C) 2010. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */
#include "sms/sms.h"

#include <stdlib.h>
#include <binder/Parcel.h>

#include "sms/gsm/sms_pdu.h"
#include "sms/cdma/sms_pdu_cdma.h"
#include "common.h"
#include "ecall/eCall.h"
#include "util/utils.h"
/*Warren add for T800 platform 2021/11/19 start*/
#include "lynq_common.h"
/*Warren add for T800 platform 2021/11/19 end*/
#include "lynq_sms_manager.h"


#define GSM_PHONE 1

#undef LOG_TAG
#define LOG_TAG "DEMO_SMS"

#define PROP_ECALL_NUM "vendor.gost.ecall.ecall_sms_fallback_number"

//extern sms_manager * g_smsManagement;

static void constructGsmSendSmsRilRequest (android::Parcel &p, char *smscPDU, char *pdu) {
    p.writeInt32(2);
    writeStringToParcel(p, (const char *)smscPDU);
    writeStringToParcel(p, (const char *)pdu);
}

//RIL_REQUEST_SEND_SMS
int sendSMS(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI){
    char smscPDU[30]= {0};
    char **pdu;
    char smsc[4] = {0};
    kal_int32 msg_num = 0;
    kal_int32 msg_len = 0;
    kal_int32 status = MDAPI_RET_ERROR;
    kal_int32 index = 0;

    status = _mdapi_sms_get_msg_num(argv[3], atoi(argv[2]), &msg_num, &msg_len);
    RLOGD("%s, %s, %d, msg_len = [%d] ,msg_num=[%d]", __FILE__, __FUNCTION__, __LINE__, msg_len, msg_num);
    if(status == MDAPI_RET_ERROR){
        RLOGD("get message number failed");
    }else {
        //allocate memory for **pdu
        pdu = (char **)malloc(sizeof(char *) * msg_num);
        if(pdu == NULL){
            RLOGD("%s, %s, %d, allocate memory for pdu failed", __FILE__, __FUNCTION__, __LINE__);
            return 0;
        } else {
            for(index = 0; index < msg_num; index++){
                pdu[index] = (char *)malloc(sizeof(char)*MAX_PDU_SIZE);
                if(pdu[index] == NULL){
                    for(int i = 0; i < index; i++){
                        free(pdu[i]);
                    }
                    free(pdu);
                    pdu = NULL;
                    if(pRI != NULL)
                    {
                        free(pRI);
                    }
                    RLOGD("%s, %s, %d, allocate memory for pdu[%d] failed", __FILE__, __FUNCTION__, __LINE__,index);
                    return 0;
                }else {
                    memset(pdu[index], 0, MAX_PDU_SIZE);
                    RLOGD("%s, %s, %d, pdu[%d} init value is: %s ", __FILE__, __FUNCTION__, __LINE__, index, pdu[index]);
                }
            }
        }
        //allocate memory for **pdu success
        if(index == msg_num){
            if(argc < 5){
                smsPduEncode(smsc, argv[1], argv[3], atoi(argv[2]), smscPDU, pdu);
            } else {
                smsPduEncode(argv[4], argv[1], argv[3], atoi(argv[2]), smscPDU, pdu);
            }
            for (index = 0; index < msg_num; index++) {
                RLOGD("%s, %s, %d, smscPDU: %s, pdu: %s",__FILE__, __FUNCTION__, __LINE__, smscPDU, pdu[index]);
                android::Parcel p;
                size_t pos = p.dataPosition();
                RequestInfo *pRI_backup = (RequestInfo *)calloc(1, sizeof(RequestInfo));
                if(pRI_backup == NULL) {
                    return 0;
                }
                pRI_backup->token = pRI->token;
                pRI_backup->pCI = pRI->pCI;
                pRI_backup->socket_id = pRI->socket_id;
                pRI_backup->p_next = pRI->p_next;
                constructGsmSendSmsRilRequest(p, smscPDU, pdu[index]);
                p.setDataPosition(pos);
                pRI->pCI->dispatchFunction(p, pRI_backup);
            }
            for(index = 0; index < msg_num; index++){
                free(pdu[index]);
            }
        }

        free(pdu);
    }

    //for auto save sms to sim    
    if(argc < 5){
        saveSendedSmsInfo(atoi(argv[2]), argv[1], argv[3], smsc);
    } else {
        saveSendedSmsInfo(atoi(argv[2]), argv[1], argv[3], argv[4]);
    }

    if(pRI != NULL)
    {
        free(pRI);
    }

    return 0;
}


//RIL_REQUEST_SEND_SMS_EXPECT_MORE
int sendSMSExpectMore(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI){
    char smscPDU[512]= {0};
    char **pdu;
    char smsc[4] = {0};
    smsc[0] = '\0';
    kal_int32 msg_num = 0;
    kal_int32 msg_len = 0;
    kal_int32 status = MDAPI_RET_ERROR;
    kal_int32 index = 0;

    status = _mdapi_sms_get_msg_num(argv[3], atoi(argv[2]), &msg_num, &msg_len);
    RLOGD("%s, %s, %d, msg_len = [%d] ,msg_num=[%d]", __FILE__, __FUNCTION__, __LINE__, msg_len, msg_num);
    if(status == MDAPI_RET_ERROR){
        RLOGD("get message number failed");
    } else {
        //allocate memory for **pdu
        pdu = (char **)malloc(sizeof(char *) * msg_num);
        if(pdu == NULL){
            RLOGD("%s, %s, %d, allocate memory for pdu failed", __FILE__, __FUNCTION__, __LINE__);
            return 0;
        } else {
            for(index = 0; index < msg_num; index++){
                pdu[index] = (char *)malloc(sizeof(char)*MAX_PDU_SIZE);
                if(pdu[index] == NULL){
                    for(int i = 0; i < index; i++){
                        free(pdu[i]);
                    }
                    free(pdu);
                    pdu = NULL;
                    if(pRI != NULL)
                    {
                        free(pRI);
                    }
                    RLOGD("%s, %s, %d, allocate memory for pdu[%d] failed", __FILE__, __FUNCTION__, __LINE__,index);
                    return 0;
                } else {
                    memset(pdu[index], 0, MAX_PDU_SIZE);
                    RLOGD("%s, %s, %d, pdu[%d} init value is: %s ", __FILE__, __FUNCTION__, __LINE__, index, pdu[index]);
                }
            }
        }

        //allocate memory for **pdu success
        if(index == msg_num){
            if(argc < 5){
                smsPduEncode(smsc, argv[1], argv[3], atoi(argv[2]), smscPDU, pdu);
            } else {
                smsPduEncode(argv[4], argv[1], argv[3], atoi(argv[2]), smscPDU, pdu);
            }
            for (index = 0; index < msg_num; index++) {
                RLOGD("%s, %s, %d, smscPDU: %s, pdu: %s",__FILE__, __FUNCTION__, __LINE__, smscPDU, pdu[index]);
                android::Parcel p;
                size_t pos = p.dataPosition();
                RequestInfo *pRI_backup = (RequestInfo *)calloc(1, sizeof(RequestInfo));
                if(pRI_backup == NULL) {
                    return 0;
                }
                pRI_backup->token = pRI->token;
                pRI_backup->pCI = pRI->pCI;
                pRI_backup->socket_id = pRI->socket_id;
                pRI_backup->p_next = pRI->p_next;
                constructGsmSendSmsRilRequest(p, smscPDU, pdu[index]);
                p.setDataPosition(pos);
                pRI->pCI->dispatchFunction(p, pRI_backup);
            }

            for(index = 0; index < msg_num; index++){
                free(pdu[index]);
            }
        }

        free(pdu);
    }

    if(pRI != NULL)
    {
        free(pRI);
    }

    //for auto save sms to sim    
    if(argc < 5){
        saveSendedSmsInfo(atoi(argv[2]), argv[1], argv[3], smsc);
    } else {
        saveSendedSmsInfo(atoi(argv[2]), argv[1], argv[3], argv[4]);
    }

    return 0;
}

//RIL_REQUEST_IMS_SEND_SMS
int sendImsGsmSms(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI){
    char smscPDU[30]= {0};
    char **pdu;
    char smsc[4] = {0};
    kal_int32 msg_num = 0;
    kal_int32 msg_len = 0;
    kal_int32 status = MDAPI_RET_ERROR;
    kal_int32 index = 0;
    uint8_t retry = atoi(argv[4]);
    int32_t messageRef = atoi(argv[5]);

    status = _mdapi_sms_get_msg_num(argv[3], atoi(argv[2]), &msg_num, &msg_len);
    RLOGD("%s, %s, %d, msg_len = [%d] ,msg_num=[%d]", __FILE__, __FUNCTION__, __LINE__, msg_len, msg_num);
    if(status == MDAPI_RET_ERROR){
        RLOGD("get message number failed");
    } else {
        //allocate memory for **pdu
        pdu = (char **)malloc(sizeof(char *) * msg_num);
        if(pdu == NULL){
            RLOGD("%s, %s, %d, allocate memory for pdu failed", __FILE__, __FUNCTION__, __LINE__);
            return 0;
        } else {
            for(index = 0; index < msg_num; index++){
                pdu[index] = (char *)malloc(sizeof(char)*MAX_PDU_SIZE);
                if(pdu[index] == NULL){
                    for(int i = 0; i < index; i++){
                        free(pdu[i]);
                    }
                    free(pdu);
                    pdu = NULL;
                    if(pRI != NULL)
                    {
                        free(pRI);
                    }
                    RLOGD("%s, %s, %d, allocate memory for pdu[%d] failed", __FILE__, __FUNCTION__, __LINE__,index);
                    return 0;
                } else {
                    memset(pdu[index], 0, MAX_PDU_SIZE);
                    RLOGD("%s, %s, %d, pdu[%d} init value is: %s ", __FILE__, __FUNCTION__, __LINE__, index, pdu[index]);
                }
            }
        }

        //allocate memory for **pdu success
        if(index == msg_num){
            if(argc < 7){
                smsPduEncode(smsc, argv[1], argv[3], atoi(argv[2]), smscPDU, pdu);
            } else {
                smsPduEncode(argv[6], argv[1], argv[3], atoi(argv[2]), smscPDU, pdu);
            }
            for (index = 0; index < msg_num; index++) {
                RLOGD("%s, %s, %d, smscPDU: %s, pdu: %s",__FILE__, __FUNCTION__, __LINE__, smscPDU, pdu[index]);
                android::Parcel p;
                size_t pos = p.dataPosition();
                RequestInfo *pRI_backup = (RequestInfo *)calloc(1, sizeof(RequestInfo));
                if(pRI_backup == NULL) {
                    return 0;
                }
                pRI_backup->token = pRI->token;
                pRI_backup->pCI = pRI->pCI;
                pRI_backup->socket_id = pRI->socket_id;
                pRI_backup->p_next = pRI->p_next;
                p.writeInt32(RADIO_TECH_3GPP);
                p.write(&retry, sizeof(retry));
                p.write(&messageRef, sizeof(messageRef));
                constructGsmSendSmsRilRequest(p, smscPDU, pdu[index]);
                p.setDataPosition(pos);
                pRI->pCI->dispatchFunction(p, pRI_backup);
            }

            for(index = 0; index < msg_num; index++){
                free(pdu[index]);
            }
        }

        free(pdu);
    }

    if(pRI != NULL)
    {
        free(pRI);
        pRI = NULL;
    }

    //for auto save sms to sim    
    if(argc < 7){
        saveSendedSmsInfo(atoi(argv[2]), argv[1], argv[3], smsc);
    } else {
        saveSendedSmsInfo(atoi(argv[2]), argv[1], argv[3], argv[6]);
    }

    return 0;
}

int sendImsCdmaSms(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI) {
    uint8_t retry = atoi(argv[1]);
    int32_t messageRef = atoi(argv[2]);
    char* destAddr = argv[3];
    char* message = argv[4];
    createCdmaMessage(pRI,destAddr,message, false, retry, messageRef);
    return 0;
}

//RIL_REQUEST_WRITE_SMS_TO_SIM
int writeSmsToSim(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI){
    char smscPDU[30]= {0};
    char **pdu;
    char smsc[4] = {0};
    kal_int32 msg_num = 0;
    kal_int32 msg_len = 0;
    kal_int32 status = MDAPI_RET_ERROR;
    kal_int32 index = 0;

    status = _mdapi_sms_get_msg_num(argv[4], atoi(argv[3]), &msg_num, &msg_len);
    RLOGD("%s, %s, %d, msg_len = [%d] ,msg_num=[%d]", __FILE__, __FUNCTION__, __LINE__, msg_len, msg_num);
    if(status == MDAPI_RET_ERROR){
        RLOGD("get message number failed");
    } else {
        //allocate memory for **pdu
        pdu = (char **)malloc(sizeof(char *) * msg_num);
        if(pdu == NULL){
            RLOGD("%s, %s, %d, allocate memory for pdu failed", __FILE__, __FUNCTION__, __LINE__);
            return 0;
        } else {
            for(index = 0; index < msg_num; index++){
                pdu[index] = (char *)malloc(sizeof(char)*MAX_PDU_SIZE);
                if(pdu[index] == NULL){
                    for(int i = 0; i < index; i++){
                        free(pdu[i]);
                    }
                    free(pdu);
                    pdu = NULL;
                    if(pRI != NULL)
                    {
                        free(pRI);
                    }
                    RLOGD("%s, %s, %d, allocate memory for pdu[%d] failed", __FILE__, __FUNCTION__, __LINE__,index);
                    return 0;
                } else {
                    memset(pdu[index], 0, MAX_PDU_SIZE);
                    RLOGD("%s, %s, %d, pdu[%d} init value is: %s ", __FILE__, __FUNCTION__, __LINE__, index, pdu[index]);
                }
            }
        }
        //allocate memory for **pdu success
        if(index == msg_num){
            if(argc < 6){
                smsPduEncode(smsc, argv[2], argv[4], atoi(argv[3]), smscPDU, pdu);
            } else {
                smsPduEncode(argv[5], argv[2], argv[4], atoi(argv[3]), smscPDU, pdu);
            }
            for (index = 0; index < msg_num; index++) {
                RLOGD("%s, %s, %d, smscPDU: %s, pdu: %s",__FILE__, __FUNCTION__, __LINE__, smscPDU, pdu[index]);
                android::Parcel p;
                size_t pos = p.dataPosition();
                RequestInfo *pRI_backup = (RequestInfo *)calloc(1, sizeof(RequestInfo));
                if(pRI_backup == NULL) {
                    return 0;
                }
                pRI_backup->token = pRI->token;
                pRI_backup->pCI = pRI->pCI;
                pRI_backup->socket_id = pRI->socket_id;
                pRI_backup->p_next = pRI->p_next;
                p.writeInt32(atoi(argv[1]));
                writeStringToParcel(p, (const char *)pdu[index]);
                writeStringToParcel(p, (const char *)smscPDU);
                p.setDataPosition(pos);
                pRI->pCI->dispatchFunction(p, pRI_backup);
            }

            for(index = 0; index < msg_num; index++){
                free(pdu[index]);
            }
        }

        free(pdu);
    }
    if(pRI != NULL)
    {
        free(pRI);
    }

    return 0;
}

//RIL_REQUEST_DELETE_SMS_ON_SIM
int deleteSmsOnSim(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI){
    android::Parcel p;
    size_t pos = p.dataPosition();

    p.writeInt32(1);
    p.writeInt32(atoi(argv[1]));

    p.setDataPosition(pos);
    pRI->pCI->dispatchFunction(p, pRI);

    return 0;
}

//RIL_REQUEST_SMS_ACKNOWLEDGE
int acknowledgeLastIncomingGsmSms(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI){
    android::Parcel p;
    size_t pos = p.dataPosition();

    p.writeInt32(2);
    p.writeInt32(atoi(argv[1]) ? 1 : 0);
    p.writeInt32(atoi(argv[2]));

    p.setDataPosition(pos);
    pRI->pCI->dispatchFunction(p, pRI);

    return 0;
}

//RIL_REQUEST_ACKNOWLEDGE_INCOMING_GSM_SMS_WITH_PDU
int acknowledgeIncomingGsmSmsWithPdu(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI){
    android::Parcel p;
    size_t pos = p.dataPosition();

    p.writeInt32(2);
    p.writeInt32(atoi(argv[1]));
    p.writeInt32(atoi(argv[2]));

    p.setDataPosition(pos);
    pRI->pCI->dispatchFunction(p, pRI);

    return 0;
}

//RIL_REQUEST_REPORT_SMS_MEMORY_STATUS
int reportSmsMemoryStatus(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI){
    android::Parcel p;
    size_t pos = p.dataPosition();

    p.writeInt32(1);
    p.writeInt32(atoi(argv[1]) ? 1 : 0);

    p.setDataPosition(pos);
    pRI->pCI->dispatchFunction(p, pRI);

    return 0;
}

//RIL_REQUEST_SET_SMSC_ADDRESS
int setSmscAddress(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI){
    android::Parcel p;
    size_t pos = p.dataPosition();

    writeStringToParcel(p, (const char *)argv[1]);

    p.setDataPosition(pos);
    pRI->pCI->dispatchFunction(p, pRI);

    return 0;
}
//RIL_REQUEST_GET_SMSC_ADDRESS
int getSmscAddress(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI){
    android::Parcel p;
    size_t pos = p.dataPosition();

    p.setDataPosition(pos);
    pRI->pCI->dispatchFunction(p, pRI);

    return 0;
}

void sendSMSACK(RIL_SOCKET_ID soc_id)
{
    sendSmsMsg(soc_id); //for power manager test.
    android::requestSMSACKNOWLEDGE(soc_id);
    return;
}

int responseNewSMS(const char *data, size_t datalen, int soc_id,int32_t unsol){
    char smsc[512] = {0};
    char msg[512] = {0};
    char num[512] = {0};
    int charset = 0;
    RLOGD("slot: %d, len: %d, sms: %s",soc_id, datalen, data);
    smsPduDecode(data, datalen, num, smsc, msg, &charset);
    g_smsManagement->lynq_write_sms_to_memory(num,charset,0,smsc,msg,data,soc_id);
     RLOGD("SMS :%s, %s, %d\n", __FILE__, __FUNCTION__, __LINE__);
    /*Warren chenge for T800 platform 2021//11/19 start*/
    if(smsCb)
    {
        lynq_recive_new_sms_callback(soc_id,num,smsc,msg,charset);
        //s_Env->recive_new_sms_cb(soc_id,num,smsc,msg,charset);
    }
    /*Warren chenge for T800 platform 2021//11/19 end*/

    RLOGD("[EVENT][MT_SMS][SIM%d]PDU decode:smsc: %s, phone number: %s , charset: %d, msg_len: %d, message content: %s", soc_id, smsc, num, charset, strlen(msg), msg);
    if(isGostEcall() && (MDAPI_SMS_CHARSET_GSM_8BIT == charset))
    {
        gostParseSmsHandle(soc_id, num, msg);
    }

    return 0;
}

//#ifdef C2K_SUPPORT
//RIL_REQUEST_CDMA_GET_BROADCAST_SMS_CONFIG
int getCdmaBroadcastConfig(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI){
  printf("test function is %s\n", __func__);
  android::Parcel p;
  pRI->pCI->dispatchFunction(p, pRI);
  return 0;
}

//RIL_REQUEST_CDMA_DELETE_SMS_ON_RUIM
int deleteSmsOnRUIM(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI) {
  if(argc < 2) {
      RLOGE("%s parameter error!",__func__);
      free(pRI);
      return -1;
  }
  printf("test function is %s\n", __func__);
  android::Parcel p;
  size_t pos = p.dataPosition();

  p.writeInt32(1);
  p.writeInt32(atoi(argv[1]));

  p.setDataPosition(pos);
  pRI->pCI->dispatchFunction(p, pRI);

  return 0;
}

//RIL_REQUEST_CDMA_SET_BROADCAST_SMS_CONFIG
int setCdmaBroadcastConfig(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI){
  if(argc < 5) {
      RLOGE("%s parameter error!",__func__);
      free(pRI);
      return -1;
  }
  int from = atoi(argv[1]);
  int to = atoi(argv[2]);
  if (from < 0 || to < 0 || from > to) {
    RLOGE("%s parameter error: from > to !",__func__);
    free(pRI);
    return -1;
  }
  int num = (to - from) + 1;
  int language = atoi(argv[3]);
  int selected = atoi(argv[4]);
  if (selected > 0) {
    selected = 1;
  } else {
    selected = 0;
  }
  android::Parcel p;
  size_t pos = p.dataPosition();
  p.writeInt32(num);
  for(int index = from; index <= to ; index++){
    p.writeInt32(index);
    p.writeInt32(language);
    p.writeInt32(selected);
  }
  p.setDataPosition(pos);
  pRI->pCI->dispatchFunction(p, pRI);
  return 0;
}

//RIL_REQUEST_CDMA_SMS_BROADCAST_ACTIVATION
int setCdmaBroadcastActivation(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI){
  //printf("test function is %s\n", __func__);
  if(argc < 2) {
      RLOGE("%s parameter error!",__func__);
      free(pRI);
      return -1;
  }
  android::Parcel p;
  size_t pos =  p.dataPosition();
  p.writeInt32(1);
  p.writeInt32(atoi(argv[1])? 1 : 0);
  p.setDataPosition(pos);
  pRI->pCI->dispatchFunction(p, pRI);

  return 0;
}

//RIL_REQUEST_CDMA_WRITE_SMS_TO_RUIM
int writeSmsToRuim(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI){
  printf("test function is %s\n", __func__);
  char* destAddr = argv[1];
  char* message = argv[2];
  if(argc < 3 || destAddr == NULL || message == NULL ) {
      RLOGE("%s parameter error!",__func__);
      free(pRI);
      return -1;
  }
  createCdmaMessage(pRI,destAddr,message, true, 0 ,0);
  return 0;
}

//RIL_REQUEST_CDMA_SEND_SMS
int sendCdmaSms(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI){
  if(argc != 3) {
      RLOGE("%s parameter num error!",__func__);
      free(pRI);
      return -1;
  }
  char* destAddr = argv[1];
  char* message = argv[2];
  if(destAddr == NULL || message == NULL ) {
      RLOGE("%s parameter error!",__func__);
      free(pRI);
      return -1;
  }
  createCdmaMessage(pRI,destAddr,message, false, 0 ,0);
  return 0;
}

//RIL_REQUEST_CDMA_SMS_ACKNOWLEDGE
int acknowledgeLastIncomingCdmaSms(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI){
  //printf("test function is %s\n", __func__);
  android::Parcel p;
  size_t pos =  p.dataPosition();
  p.writeInt32(0);
  p.writeInt32(1);
  p.setDataPosition(pos);
  pRI->pCI->dispatchFunction(p, pRI);
  return 0;
}
//#endif /*C2K_SUPPORT*/

//RIL_REQUEST_GSM_GET_BROADCAST_SMS_CONFIG
int getGsmBroadcastConfig(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI){
    android::Parcel p;
    pRI->pCI->dispatchFunction(p, pRI);
    return 0;
}

//RIL_REQUEST_GSM_SET_BROADCAST_SMS_CONFIG
int setGsmBroadcastConfig(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI) {
    if((argc%5) != 1) {
        RLOGE("%s parameter error!",__func__);
        free(pRI);
        return -1;
    }
    int num = argc/5;
    android::Parcel p;
    size_t pos = p.dataPosition();
    p.writeInt32(num);
    RLOGD("%s write group num of input parameter to parcel: %d",__func__, num);
    for (int i = 1; i < argc; i++) {
        p.writeInt32(atoi(argv[i]));
        RLOGD("%s write input parameter to parcel: [%d] %d",__func__, i, atoi(argv[i]));
    }
    p.setDataPosition(pos);
    pRI->pCI->dispatchFunction(p, pRI);
    return 0;
}

//RIL_REQUEST_GSM_SMS_BROADCAST_ACTIVATION
int setGsmBroadcastActivation(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI) {
    if(argc != 2) {
        RLOGE("%s parameter error!",__func__);
        free(pRI);
        return -1;
    }
    android::Parcel p;
    size_t pos = p.dataPosition();
    p.writeInt32(1);
    p.writeInt32(atoi(argv[1]));
    p.setDataPosition(pos);
    pRI->pCI->dispatchFunction(p, pRI);
    return 0;
}

int getSmsSimMemStatus(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI){
    android::Parcel p;
    size_t pos = p.dataPosition();

    p.setDataPosition(pos);
    pRI->pCI->dispatchFunction(p, pRI);

    return 0;
}

static bool auto_save_sms_to_sim = false;
static bool Sim_sms_storage_full = false;
static smsSaveInfo* psmsSaveInfo = NULL;

int setAutoSaveSmsToSimFlag(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI){
    if(argc != 2) {
        RLOGE("%s parameter error!",__func__);
        free(pRI);
        return -1;
    }

    int enable = atoi(argv[1]);
    if(enable)
    {
        auto_save_sms_to_sim = true;
    }
    else
    {
        auto_save_sms_to_sim = false;
    }
    RLOGE("%s:%d", __FUNCTION__, auto_save_sms_to_sim);
    return 0;
}

int setSimSmsStorageFullFlag(bool enable)
{
    Sim_sms_storage_full = enable;
    RLOGE("%s:%d", __FUNCTION__, Sim_sms_storage_full);
    return 0;
}

//sent status save
int saveSendedSmsInfo(int charset, char* num, char* msg, char* smsc)
{
    if(psmsSaveInfo == NULL)
    {
        psmsSaveInfo = (smsSaveInfo*)malloc(sizeof(smsSaveInfo));
    }
    memset(psmsSaveInfo, 0, sizeof(psmsSaveInfo));

    psmsSaveInfo->charset = charset;
    psmsSaveInfo->sendStatus = 3; //UnRead|Read|UnSent|Sent
    strcpy(psmsSaveInfo->num, num);
    strcpy(psmsSaveInfo->sms, msg);
    strcpy(psmsSaveInfo->smsc, smsc);
    RLOGE("%s:send sms saved", __FUNCTION__);

    return 0;
}

int sendStatusWriteSmsToSim(int socket_id)
{
    if(psmsSaveInfo == NULL)
    {
        RLOGE("%s error psmsSaveInfo is null",__func__);
        return 0;
    }
    autoWriteSmsToSim(psmsSaveInfo, socket_id);
    free(psmsSaveInfo);
    psmsSaveInfo = NULL;
    return 0;
}

int autoWriteSmsToSim(smsSaveInfo *smsInfo, int id)
{
    int argc = 6;
    char *argv[6];
    RIL_SOCKET_ID socket_id;
    char charset[4] = {0};
    char status[4] = {0};

    if((true == auto_save_sms_to_sim)&&(false == Sim_sms_storage_full))
    {
        RequestInfo *pRI = creatRILInfoAndInit(RIL_REQUEST_WRITE_SMS_TO_SIM, UDP, (RIL_SOCKET_ID)(id));
        if(pRI == NULL)
        {
            RLOGE("error PRI is NULL");
            return 0;
        }
        sprintf(charset, "%d", smsInfo->charset);
        argv[3] = charset;

        argv[0] = "RIL_REQUEST_WRITE_SMS_TO_SIM";
        sprintf(status, "%d", smsInfo->sendStatus);
        argv[1] = status;
        argv[2] = smsInfo->num;
        argv[4] = smsInfo->sms;
        argv[5] = smsInfo->smsc;

        RLOGE("%s status:%s, num:%s, sms:%s, charset:%s, sms:%s",__func__,
                                                argv[1],argv[2],argv[3],argv[5],argv[4]);
        
        writeSmsToSim(argc, argv, pRI->socket_id, pRI);
    }
    return 0;
}

int unreadStatusWriteSMSToSim(const char *data, size_t datalen, int soc_id)
{
    char smscPDU[30]= {0};
    char pdu[MAX_PDU_SIZE] = {0};
    int32_t status = 0;
    RLOGD("%s:slot: %d, len: %d, sms: %s",__FUNCTION__, soc_id, datalen, data);

    if((true == auto_save_sms_to_sim)&&(false == Sim_sms_storage_full))
    {
        RequestInfo *pRI = creatRILInfoAndInit(RIL_REQUEST_WRITE_SMS_TO_SIM, UDP, (RIL_SOCKET_ID)(soc_id));
        if(pRI == NULL)
        {
            RLOGE("error PRI is NULL");
            return 0;
        }
        if(getNewSmsPduAndSmsc(data, datalen, smscPDU, pdu) < 0)
        {
            if(pRI != NULL)
            {
                free(pRI);
                pRI = NULL;
            }
            RLOGD("%s, %s, %d, smsc: ERR",__FILE__, __FUNCTION__, __LINE__);
            return 0;
        }
        RLOGD("%s, %s, %d, smsc: %s, msg: %s",__FILE__, __FUNCTION__, __LINE__, smscPDU, pdu);

        android::Parcel p;
        size_t pos = p.dataPosition();
        RequestInfo *pRI_backup = (RequestInfo *)calloc(1, sizeof(RequestInfo));
        if(pRI_backup == NULL) {
            return 0;
        }
        pRI_backup->token = pRI->token;
        pRI_backup->pCI = pRI->pCI;
        pRI_backup->socket_id = pRI->socket_id;
        pRI_backup->p_next = pRI->p_next;
        p.writeInt32(status);
        writeStringToParcel(p, (const char *)pdu);
        writeStringToParcel(p, (const char *)smscPDU);
        p.setDataPosition(pos);
        pRI->pCI->dispatchFunction(p, pRI_backup);

        if(pRI != NULL)
        {
            free(pRI);
            pRI = NULL;
        }
    }
    return 0;
}

int gostSendSmsForMsd(int id, char *num, char *msd)
{
    int argc = 4;
    char *argv[5];
    char charset[4] = {0};

    RequestInfo *pRI = creatRILInfoAndInit(RIL_REQUEST_SEND_SMS, UDP, (RIL_SOCKET_ID)(id));
    if(pRI == NULL)
    {
        RLOGE("error PRI is NULL");
        return 0;
    }
    char configNum[140]= {0};
    utils::mtk_property_get(PROP_ECALL_NUM, configNum, "112");

    sprintf(charset, "%d", MDAPI_SMS_CHARSET_GSM_8BIT);
    argv[2] = charset;

    argv[0] = "RIL_REQUEST_SEND_SMS";
    argv[1] = configNum;
    argv[3] = msd;
    gostSaveSmsData(argc, argv, (RIL_SOCKET_ID)(id));
    sendSMS(argc, argv, pRI->socket_id, pRI);

    return 0;
}

int getGsmBroadcastLanguage(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI){
    android::Parcel p;
    pRI->pCI->dispatchFunction(p, pRI);
    return 0;
}

int setGsmBroadcastLanguage(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI) {
    if(argc != 2) {
        RLOGE("%s parameter error!",__func__);
        free(pRI);
        return -1;
    }
    android::Parcel p;
    size_t pos = p.dataPosition();

    writeStringToParcel(p, (const char *)argv[1]);

    p.setDataPosition(pos);
    pRI->pCI->dispatchFunction(p, pRI);
    return 0;
}

