/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 *
 * MediaTek Inc. (C) 2016. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */

#include <log/log.h>
#include <cutils/properties.h>

#include "RatConfiguration.h"
#include "utils.h"

#define LOG_TAG "DEMO_RatConfig"

const std::string RatConfiguration::PROPERTY_BUILD_RAT_CONFIG =
        "ro.vendor.mtk_protocol1_rat_config";
/* the system property of active rat */
const std::string RatConfiguration::PROPERTY_RAT_CONFIG = "ro.boot.opt_ps1_rat";
const std::string RatConfiguration::PROPERTY_IS_USING_DEFAULT_CONFIG =
        "ro.boot.opt_using_default";
/* the valid characters of the human-readable rat config */
/* the defination must be sync with ratconfig.c */
const std::string RatConfiguration::CDMA = "C";
const std::string RatConfiguration::LteFdd = "Lf";
const std::string RatConfiguration::LteTdd = "Lt";
const std::string RatConfiguration::WCDMA = "W";
const std::string RatConfiguration::TDSCDMA = "T";
const std::string RatConfiguration::GSM = "G";
const std::string RatConfiguration::DELIMITER = "/";

/* bitmask */
/* the defination must be sync with ratconfig.c */
const int RatConfiguration::MASK_CDMA = (1 << 5);
const int RatConfiguration::MASK_LteFdd = (1 << 4);
const int RatConfiguration::MASK_LteTdd = (1 << 3);
const int RatConfiguration::MASK_WCDMA = (1 << 2);
const int RatConfiguration::MASK_TDSCDMA = (1 << 1);
const int RatConfiguration::MASK_GSM = (1);

const int RatConfiguration::MD_MODE_UNKNOWN = 0;
const int RatConfiguration::MD_MODE_LTG = 8;   //uLTG
const int RatConfiguration::MD_MODE_LWG = 9;   //uLWG
const int RatConfiguration::MD_MODE_LWTG = 10;  //uLWTG
const int RatConfiguration::MD_MODE_LWCG = 11;  //uLWCG
const int RatConfiguration::MD_MODE_LWCTG = 12;  //uLWTCG(Auto mode)
const int RatConfiguration::MD_MODE_LTTG = 13;  //LtTG
const int RatConfiguration::MD_MODE_LFWG = 14;  //LfWG
const int RatConfiguration::MD_MODE_LFWCG = 15;  //uLfWCG
const int RatConfiguration::MD_MODE_LCTG = 16;  //uLCTG
const int RatConfiguration::MD_MODE_LTCTG = 17;  //uLtCTG

int RatConfiguration::max_rat = 0;
bool RatConfiguration::max_rat_initialized = false;
int RatConfiguration::actived_rat = 0;
bool RatConfiguration::is_default_config = true;

RatConfiguration::RatConfiguration() {
    // TODO Auto-generated constructor stub

}

RatConfiguration::~RatConfiguration() {
    // TODO Auto-generated destructor stub
}

/*
 * transfer rat format from "L/T/G" to bitmask
 * @params String rat, the rat in format like "L/T/G"
 * @return int, the rat in bitmask.
 */
int RatConfiguration::ratToBitmask(std::string rat) {
    int iRat = 0;
    if (rat.find(CDMA) != std::string::npos) {
        iRat = iRat | MASK_CDMA;
    }
    if (rat.find(LteFdd) != std::string::npos) {
        iRat = iRat | MASK_LteFdd;
    }
    if (rat.find(LteTdd) != std::string::npos) {
        iRat = iRat | MASK_LteTdd;
    }
    if (rat.find(WCDMA) != std::string::npos) {
        iRat = iRat | MASK_WCDMA;
    }
    if (rat.find(TDSCDMA) != std::string::npos) {
        iRat = iRat | MASK_TDSCDMA;
    }
    if (rat.find(GSM) != std::string::npos) {
        iRat = iRat | MASK_GSM;
    }
    return iRat;
}

/*
 * get the rat of project config
 * @return int, the rat in bitmask.
 */
int RatConfiguration::getMaxRat() {
    if (!max_rat_initialized) {
        char rat[PROPERTY_VALUE_MAX] = {0};
        utils::mtk_property_get(PROPERTY_BUILD_RAT_CONFIG.c_str(), rat, "");
        std::string sMaxRat(rat);
        max_rat = ratToBitmask(sMaxRat);
        char def_rat[PROPERTY_VALUE_MAX] = {0};
        is_default_config = (utils::mtk_property_get_int32(PROPERTY_IS_USING_DEFAULT_CONFIG.c_str(), 1) != 0) ? true : false;
        max_rat_initialized = true;
        RLOGD("getMaxRat: initial %s %d ", sMaxRat.c_str(), max_rat);
    }
    return max_rat;
}

/*
 * check rat config is supported by project config
 * @params int iRat, the rat to be checked.
 * @return boolean,
 *              true, the rat is supported.
 *              false, the rat is not supported.
 */
bool RatConfiguration::checkRatConfig(int iRat) {
    int maxrat = getMaxRat();
    if ((iRat | maxrat) == maxrat) {
        return true;
    } else {
        RLOGD("checkRatConfig: FAIL with %d", iRat);
        return false;
    }
}

/*
 * get the active rat in bitmask.
 * @return int, the rat in bitmask.
 */
int RatConfiguration::getRatConfig() {
    int default_rat_config = getMaxRat();
    if (default_rat_config == 0) {
        actived_rat = 0;
        return actived_rat;
    }
    if (is_default_config) {
        actived_rat = default_rat_config;
        return default_rat_config;
    }
    char rat_config[PROPERTY_VALUE_MAX] = {0};
    utils::mtk_property_get(PROPERTY_RAT_CONFIG.c_str(), rat_config, "");
    std::string rat(rat_config);
    if (rat.length() > 0) {
        actived_rat = ratToBitmask(rat);
        if (checkRatConfig(actived_rat) == false) {
            RLOGD("getRatConfig: invalid PROPERTY_RAT_CONFIG, set to max_rat");
            actived_rat = getMaxRat();
        }
    } else {
        RLOGD("getRatConfig: ger property PROPERTY_RAT_CONFIG fail, initialize");
        actived_rat = getMaxRat();
    }
    return actived_rat;
}

/*
 * transfer the format from bitmask to "L/T/G".
 * @params int iRat, rat in bitmask
 * @return String, rat in format like "L/T/G".
 */
std::string RatConfiguration::ratToString(int iRat) {
    std::string rat = "";
    if ((iRat & MASK_CDMA) == MASK_CDMA) {
        rat += (DELIMITER + CDMA);
    }
    if ((iRat & MASK_LteFdd) == MASK_LteFdd) {
        rat += (DELIMITER + LteFdd);
    }
    if ((iRat & MASK_LteTdd) == MASK_LteTdd) {
        rat += (DELIMITER + LteTdd);
    }
    if ((iRat & MASK_WCDMA) == MASK_WCDMA) {
        rat += (DELIMITER + WCDMA);
    }
    if ((iRat & MASK_TDSCDMA) == MASK_TDSCDMA) {
        rat += (DELIMITER + TDSCDMA);
    }
    if ((iRat & MASK_GSM) == MASK_GSM) {
        rat += (DELIMITER + GSM);
    }
    if (rat.length() > 0) {
        // for remove the delimiter at rat[0]
        rat = rat.substr(1);
    }
    return rat;
}

/*
 * check C2k suppport
 * @return boolean, cases as following
 *       true, rat is active and project config supports it.
 *       false, rat is inactive no matter project config supports.
 */
bool RatConfiguration::isC2kSupported() {
    return (getMaxRat() & getRatConfig() & MASK_CDMA) == MASK_CDMA ?
            true : false;
}

/*
 * check LteFdd suppport
 * @return boolean, cases as following
 *       true, rat is active and project config supports it.
 *       false, rat is inactive no matter project config supports.
 */
bool RatConfiguration::isLteFddSupported() {
    return (getMaxRat() & getRatConfig() & MASK_LteFdd) == MASK_LteFdd ?
            true : false;
}

/*
 * check LteTdd suppport
 * @return boolean, cases as following
 *       true, rat is active and project config supports it.
 *       false, rat is inactive no matter project config supports.
 */
bool RatConfiguration::isLteTddSupported() {
    return (getMaxRat() & getRatConfig() & MASK_LteTdd) == MASK_LteTdd ?
            true : false;
}

/*
 * check Wcdma suppport
 * @return boolean, cases as following
 *       true, rat is active and project config supports it.
 *       false, rat is inactive no matter project config supports.
 */
bool RatConfiguration::isWcdmaSupported() {
    return (getMaxRat() & getRatConfig() & MASK_WCDMA) == MASK_WCDMA ?
            true : false;
}

/*
 * check Tdscdma suppport
 * @return boolean, cases as following
 *       true, rat is active and project config supports it.
 *       false, rat is inactive no matter project config supports.
 */
bool RatConfiguration::isTdscdmaSupported() {
    return (getMaxRat() & getRatConfig() & MASK_TDSCDMA) == MASK_TDSCDMA ?
            true : false;
}

/*
 * check GSM suppport
 * @return boolean, cases as following
 *       true, rat is active and project config supports it.
 *       false, rat is inactive no matter project config supports.
 */
bool RatConfiguration::isGsmSupported() {
    return (getMaxRat() & getRatConfig() & MASK_GSM) == MASK_GSM ? true : false;
}

/*
 * get the active rat
 * @return String, the rat in format like C/Lf/Lt/T/W/G
 */
std::string RatConfiguration::getActiveRatConfig() {
    std::string rat = ratToString(getRatConfig());
    RLOGD("getActiveRatConfig: %s", rat.c_str());
    return rat;
}
