/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 *
 * MediaTek Inc. (C) 2016. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */
#include "rfdesense/RfDesenseTxTestGsm.h"

#include <algorithm>
#include <iterator>
#include <stdexcept>

#include "em.h"
#include "rfdesense/RfDesenseTxTestBase.h"
#include "util/log_extra.h"
#include "util/utils.h"

#undef LOG_TAG
#define LOG_TAG "EM_RfDesenseTxTestGsm"
const int RfDesenseTxTestGsm::INDEX_BAND = 0;
const int RfDesenseTxTestGsm::INDEX_CHANNEL = 1;
const int RfDesenseTxTestGsm::INDEX_POWER = 2;
const int RfDesenseTxTestGsm::INDEX_AFC = 3;
const int RfDesenseTxTestGsm::INDEX_TSC = 4;
const int RfDesenseTxTestGsm::INDEX_PATTERN = 5;
std::string RfDesenseTxTestGsm::band = "128";
std::string RfDesenseTxTestGsm::channel ="190";
std::string RfDesenseTxTestGsm::power = "5";
std::string RfDesenseTxTestGsm::afc = "4100";
std::string RfDesenseTxTestGsm::tsc = "0";
std::string RfDesenseTxTestGsm::pattern = "0";

const std::vector<std::string> RfDesenseTxTestGsm::band_values = {"128","1", "2", "4", "8", "16"};
const std::vector<std::vector<std::string>> RfDesenseTxTestGsm::gsm_gmsk_limits = {
        {"190","128","251","128","251","5","5","19"},
        {"63","1","124","1","124","5","5","19"},
        {"62","0","124","975","1023","5","5","19"},
        {"61","0","124","955","1023","5","5","19"},
        {"700","512","885","512","885","0","0","15"},
        {"661","512","810","512","885","0","0","15"}};

std::shared_ptr<RfDesenseTxTestGsm> RfDesenseTxTestGsm::m_instance;
std::mutex RfDesenseTxTestGsm::mutex;

RfDesenseTxTestGsm::RfDesenseTxTestGsm() {

}

RfDesenseTxTestGsm::~RfDesenseTxTestGsm() {
    // TODO Auto-generated destructor stub
}

std::shared_ptr<RfDesenseTxTestGsm> RfDesenseTxTestGsm::get_instance() {
    if(!m_instance) {
        mutex.lock();
        if(!m_instance) {
            m_instance = std::make_shared<RfDesenseTxTestGsm>();
        }
        mutex.unlock();
    }
    return m_instance;
}

std::string RfDesenseTxTestGsm::get_command() {
    std::string command = "AT+ERFTX=2,1," + channel + "," + afc + "," + band + "," + tsc + "," + power + "," + pattern;
    LOG_D(LOG_TAG, "GSM command: %s\n", command.c_str());
    return command;
}

std::string RfDesenseTxTestGsm::get_band(){
    return band;
}

std::string RfDesenseTxTestGsm::get_power(){
    return power;
}

bool RfDesenseTxTestGsm::set_band(int value) {
    LOG_D(LOG_TAG, "values: %d", value);
    if (value < 0 || value >=  band_values.size()) {
        std::string s = utils::format("value(%d) is out of range\n", value);
        LOG_D(LOG_TAG, s.c_str());
        em_result_notify_fail(s);
        return false;
    }
    this->band = band_values[value];
    em_result_notify_ok("band: " + std::string(rfdesense_gsm_band[value].name));
    return true;
}

bool RfDesenseTxTestGsm::set_pattern(int value) {
    LOG_D(LOG_TAG, "values: %d", value);
    if(value < 0 || value > 6) {
        std::string s = utils::format("pattern(%s) is invalid, range is [0,6]\n" , pattern.c_str());
        LOG_D(LOG_TAG, s.c_str());
        em_result_notify_fail(s);
        return false;
    }
    this->pattern = std::to_string(value);
    em_result_notify_ok("pattern: " + std::string(rfdesense_gsm_pattern[value].name));
    return true;
}

bool RfDesenseTxTestGsm::set_channel(std::string value){
    int index = utils::find_index(band_values, band);
    if(check_channel(index,value)) {
        channel = value;
        em_result_notify_ok("channel: " + channel);
        return true;
    }
    return false;
}

bool RfDesenseTxTestGsm::set_power(std::string value){
    int index = utils::find_index(band_values, band);
    if(check_power(index, value)) {
        power = value;
        em_result_notify_ok("power: " + power);
        return true;
    }
    return false;
}
bool RfDesenseTxTestGsm::set_afc(std::string value){
    LOG_D(LOG_TAG,"set_afc: %s", value);
    if(check_afc(value)){
        afc = value;
        em_result_notify_ok("afc: " + afc);
        return true;
    }
    return false;
}

bool RfDesenseTxTestGsm::set_tsc(std::string value){
    if(check_tsc(value)) {
        tsc = value;
        em_result_notify_ok("tsc: " + tsc);
        return true;
    }
    return false;
}

bool RfDesenseTxTestGsm::check_channel(int index, std::string channel) {
    std::string s;
    if(index >= gsm_gmsk_limits.size()) {
        s = utils::format("check_channel,index(%d) is invalid", index);
        em_result_notify_fail(s);
        LOG_D(LOG_TAG, "check_channel,index(%d) is invalid", index);
        return false;
    }
    int value = -1;
    try {
        value = std::stoi(channel);
    } catch (std::invalid_argument &err) {
        s = utils::format("check_channel,channel(%s) is invalid, reason: %s", channel.c_str(), err.what());
        em_result_notify_fail(s);
        LOG_D(LOG_TAG, "check_channel,channel(%s) is invalid, reason: %s", channel.c_str(), err.what());
        return false;
    }
    step = 1;
    std::vector<std::string> limits = gsm_gmsk_limits[index];
    min = std::stoi(limits[RfDesenseTxTestBase::CHANNEL_MIN]);
    max =  std::stoi(limits[RfDesenseTxTestBase::CHANNEL_MAX]);
    min2 =  std::stoi(limits[RfDesenseTxTestBase::CHANNEL_MIN2]);
    max2 =  std::stoi(limits[RfDesenseTxTestBase::CHANNEL_MAX2]);
    if ((value < min || value > max) && (value < min2 || value > max2)) {
        s = utils::format("check_channel,channel(%s) is invalid, range is [%d, %d] or [%d, %d]" , channel.c_str(), min, max, min2, max2);
        em_result_notify_fail(s);
        LOG_D(LOG_TAG, "check_channel,channel(%s) is invalid, range is [%d, %d] or [%d, %d]" , channel.c_str(), min, max, min2, max2);
        return false;
    }
    return true;
}

bool RfDesenseTxTestGsm::check_power(int index ,std::string power) {
    std::string s;
    if(index >= gsm_gmsk_limits.size()) {
        s = utils::format("check_power,index(%d) is invalid", index);
        em_result_notify_fail(s);
        LOG_D(LOG_TAG, "check_power,index(%d) is invalid", index);
        return false;
    }
    int value = -1;
    try {
        value = std::stoi(power);
    } catch (std::invalid_argument &err) {
        s = utils::format("check_power,power(%s) is invalid, reason: %s", power.c_str(), err.what());
        em_result_notify_fail(s);
        LOG_D(LOG_TAG, "check_power,power(%s) is invalid, reason: %s", power.c_str(), err.what());
        return false;
    }
    step = 1;
    std::vector<std::string> limits = gsm_gmsk_limits[index];
    min = std::stoi(limits[RfDesenseTxTestBase::POWER_MIN]);
    max =  std::stoi(limits[RfDesenseTxTestBase::POWER_MAX]);
    if (value < min || value > max) {
        s = utils::format("check_power,power(%s) is invalid, range is [%d, %d]" , power.c_str(), min, max);
        em_result_notify_fail(s);
        LOG_D(LOG_TAG, "check_power,power(%s) is invalid, range is [%d, %d]" , power.c_str(), min, max);
        return false;
    }
    return true;
}

bool RfDesenseTxTestGsm::check_afc(std::string afc) {
    std::string s;
    int value = -1;
    try {
        value = std::stoi(afc);
    } catch (std::invalid_argument &err) {
        s = utils::format("check_afc, afc(%s) is invalid, reason: %s", afc.c_str(), err.what());
        em_result_notify_fail(s);
        LOG_D(LOG_TAG, "check_afc, afc(%s) is invalid, reason: %s", afc.c_str(), err.what());
        return false;
    }
    if(value < 0 || value > 8191) {
        em_result_notify_fail("check_afc,afc(%s) is invalid, range is (0,8191)");
        LOG_D(LOG_TAG, "check_afc,afc(%s) is invalid, range is (0,8191)" , afc.c_str());
        return false;
    }
    return true;
}

bool RfDesenseTxTestGsm::check_tsc(std::string tsc){
    std::string s;
    int value = -1;
    try {
        value = std::stoi(tsc);
    } catch (std::invalid_argument &err) {
        s = utils::format("check_tsc, tsc(%s) is invalid, reason: %s", tsc.c_str(), err.what());
        em_result_notify_fail(s);
        LOG_D(LOG_TAG, "check_tsc, tsc(%s) is invalid, reason: %s", tsc.c_str(), err.what());
        return false;
    }
    if(value < 0 || value > 7) {
        em_result_notify_fail("check_tsc, tsc(%s) is invalid, range is [0,7]");
        LOG_D(LOG_TAG, "check_tsc, tsc(%s) is invalid, range is [0,7]" , tsc.c_str());
        return false;
    }
    return true;
}

bool RfDesenseTxTestGsm::check_pattern(std::string pattern) {
    int value = -1;
    try {
        value = std::stoi(pattern);
    } catch (std::invalid_argument &err) {
        LOG_D(LOG_TAG, "check_pattern, pattern(%s) is invalid, reason: %s\n", pattern.c_str(), err.what());
        return false;
    }
    if(value < 0 || value > 6) {
        LOG_D(LOG_TAG, "check_pattern, pattern(%s) is invalid, range is [0,6]\n" , pattern.c_str());
        return false;
    }
    return true;
}

void RfDesenseTxTestGsm::show_default() {
    int band_index = utils::find_index(band_values, band);
    int pattern_index = std::stoi(pattern);
    std::string temp = "GSM parameter: Band: " + std::string(rfdesense_gsm_band[band_index].name) +
            ", Channel(ARFCN): " + channel + ", Power Level: " + power + ", AFC: " + afc + ", TSC: " + tsc +
            ", PATTERN: " + std::string(rfdesense_gsm_pattern[pattern_index].name);
    emResultNotifyWithDone(temp);
}

void RfDesenseTxTestGsm::show_channel(){
    emResultNotifyWithDone("Channel(ARFCN): " + channel);
}
void RfDesenseTxTestGsm::show_power(){
    emResultNotifyWithDone("Power Level: " + power);
}
void RfDesenseTxTestGsm::show_afc(){
    emResultNotifyWithDone("AFC: " + afc);
}
void RfDesenseTxTestGsm::show_tsc(){
    emResultNotifyWithDone("TSC: " + tsc);
}
