/*============================================================================= 
#     FileName: lynq_sms.h
#         Desc: about sms api
#       Author: zhouqunchao 
#      Version:  
#   LastChange: 2020-07-29 
#      History: 
 
=============================================================================*/

#ifndef YLNQ_SMS_H
#define YLNQ_SMS_H 1
#include <sys/types.h>
#include "lib_tele.h"
#ifdef __cplusplus
extern "C" {
#endif
#define MIN_MSM_PARAM_NUM 4
#define MIN_IMS_MSM_PARAM_NUM 6
#define MIN_WRITE_MSM_PARAM_NUM 5
#define MSG_MAX_LEN 1024
#define TELEPHONE_NUM_LEN 64
#define STORAGE_SMS_MAX_SIZE 128
#define SMSC_MAX_LEN 22

enum{
    SMS_OK = 0,
    SMS_FAIL,
    SMS_PARAM_ERR
};

typedef struct {
    char *telephonyNumber;
    char *charset;
    char *msg;
    char *smsc;
} SmsSendData;
typedef struct{
    lynqBase base;
    RIL_SMS_Response smsResp;
}smsResponse;
typedef struct {
    char *telephonyNumber;
    char *charset;
    char *msg;
    char *retryNum;
    char *messageRef;
    char *smsc;
} SmsImsSendData;

typedef struct {
    int  smsStatus; //UnRead\Read\UnSent\Sent
    char *recPhonNum;
    char *charset;
    char *msg;
    char *smsc;
} SmsInfo;

typedef struct{
    lynqBase base;
    int msgStoreIndex;
}messageStoreInfo;

typedef struct{
    lynqBase base;
    char *smsc;
}smscCbInfo;
typedef struct
{
    int index;          /*the index of sms in memory,0-255 */
    int status;         /* 0:read, 1:unread */
    int charset;        /* 0:7bit, 1:8bit, 2:16bit(chinese) */
    char smsc[SMSC_MAX_LEN];    /* smsc address */
    int smscLen;                /* smsc string  length */
    int smslen;                 /* the length of sms,the maximum length shall not exceed the length specified in 3GGP protocol(160/70) */
    char message[MSG_MAX_LEN];  /* sms content */
    RIL_SOCKET_ID soc_id;
    char teleNum[TELEPHONE_NUM_LEN];    /* telephony number */
    int numLen;                         /* telephony number strings length */
}lynq_sms_msg_info_t;

typedef struct{
    int index;              /*the index of sms in memory,0-255 */
    int status;             /* 0:read, 1:unread */
    uint64_t timestamp;     /* reciced message timestamp */
    char telephone_num[TELEPHONE_NUM_LEN];    /* sender telephone number */
}lynq_sms_info_t;

typedef struct{
    int num_msg;        /* numbers of messsage */
    lynq_sms_info_t lynq_sms_info[STORAGE_SMS_MAX_SIZE];  /* message information */
}lynq_sms_list_info_t;

int lynq_Ims_send_sms(const char *telephonyNumber, const int charset,const char *msg, const char*retryNum,const char *messageRef, const char *smsc,smsResponse *smsResp);
int lynq_write_sms_to_sim(const int smsStatus,const char *recPhonNum,const int charset,const char *msg,const char *smsc,messageStoreInfo *msgstroeInfo);
int lynq_report_sms_memory_status(const int status,lynqBase *base);
int lynq_delet_sms_on_sim(const int index,lynqBase *base);
int lynq_store_sms_to_memory(RIL_SOCKET_ID soc_id,const int status,char * num,const char* sms,lynqBase *base);
int lynq_get_sms_from_memory(const int index, lynq_sms_msg_info_t* sms,lynqBase *base);
int lynq_delete_message_from_memory(const int index,lynqBase *base);

typedef void (*lynq_recive_new_sms_cb)(RIL_SOCKET_ID soc_id,char * num, char * smsc, char * msg, int charset);
int lynq_sms_init(lynq_recive_new_sms_cb cb);
int lynq_sms_deinit(void);
int lynq_send_sms(char *telephony_num, int charset, char *msg);
int lynq_read_sms(int index, lynq_sms_msg_info_t *sms_msg_info);
int lynq_get_smsc_address(const char *service_num, int size);
int lynq_set_smsc_address(const char* service_num, int size);
int lynq_list_sms(lynq_sms_list_info_t *lynq_sms_list);
int lynq_delete_sms(int index);

#ifdef __cplusplus
}
#endif
#endif
