#include "lynq_common.h"
#include <liblog/lynq_deflog.h>
#include <sys/time.h>
#include "Phone_utils.h"
#include <stdio.h>
#undef LOG_TAG
#define LOG_TAG "LYNQ_COMMON"

extern apn_table_t apn_table[LYNQ_APN_CHANNEL_MAX] = {};
extern int apn_count = 0;
pthread_cond_t lynqCond;
pthread_mutex_t lynqMutex;
pthread_condattr_t attr;
extern lynq_data_call_state_cb dataCb = NULL;
extern lynq_recive_new_sms_cb smsCb = NULL;
extern lynq_incoming_call_cb callCb = NULL;
extern lynq_signal_strength_change_ind sigStrengthChangeCb = NULL;
extern lynq_voice_network_state_change_ind voiceChangeCb = NULL;
int lynq_data_callback(char apn[],char apnType[],int pdnState,char ifaceName[])
{
    if(dataCb==NULL)
    {
        RLOGD("dataCb is null!!!");
        return -1;
    }
    (*dataCb)(apn,apnType,pdnState,ifaceName);
    return 0;
}
int lynq_incoming_call_callback(RIL_SOCKET_ID soc_id,int index, char addr[], int callState, int toa)
{
    if(callCb==NULL)
    {
        RLOGD("callCb is null!!!");
        return -1;
    }
    (*callCb)(soc_id,index,addr,callState,toa);
    return 0;
}
int lynq_recive_new_sms_callback(RIL_SOCKET_ID soc_id,char num[], char smsc[], char msg[], int charset)
{
    if(smsCb==NULL)
    {
        RLOGD("callCb is null!!!");
        return -1;
    }
    (*smsCb)(soc_id,num,smsc,msg,charset);
    return 0;
}
int lynq_signal_strength_change_callback(int slot,signalStrength_t signalStrength)
{
    if(sigStrengthChangeCb==NULL)
    {
        RLOGD("sigStrengthChangeCb is null!!!");
        return -1;
    }
    (*sigStrengthChangeCb)(slot,signalStrength);
    return 0;
}
int lynq_voice_network_state_change_callback(int slot)
{
    
    if(voiceChangeCb==NULL)
    {
        RLOGD("voiceChangeCb is null!!!");
        return -1;
    }
    (*voiceChangeCb)(slot);
    return 0;
}
void lynqp_thread_cond_init()
{
    pthread_condattr_init(&attr);
    pthread_condattr_setclock(&attr, CLOCK_MONOTONIC);
    pthread_cond_init(&lynqCond, &attr);
    pthread_condattr_destroy(&attr);
    pthread_mutex_init(&lynqMutex, NULL);
    return;
}

/*
static long long tm_to_ns(struct timespec tm)
{
    return tm.tv_sec * 1000000000 + tm.tv_nsec;
}
 
static struct timespec ns_to_tm(long long ns)
{
    struct timespec tm;
    tm.tv_sec = ns / 1000000000;
    tm.tv_nsec = ns - (tm.tv_sec * 1000000000);
    return tm;
}
*/
/*time /ms*/
int lynqWaitRespWithTime(int wiatTime)
{
    int ret = 0;
    
    struct timespec start_tm;
    clock_gettime(CLOCK_MONOTONIC, &start_tm);
    struct timespec outtime;
    //gettimeofday(&now, NULL);//now.tv_sec(s),now.tv_usec(Micro s)
    outtime.tv_sec = start_tm.tv_sec + wiatTime;
    outtime.tv_nsec = start_tm.tv_sec;
    pthread_mutex_lock(&lynqMutex);
    ret = pthread_cond_timedwait(&lynqCond,&lynqMutex,&outtime);
    printf("wait ret = %d\n",ret);
    pthread_mutex_unlock(&lynqMutex);
    return ret;
}
int lynqUnlockWaitingReq()
{
    pthread_mutex_lock(&lynqMutex);
    pthread_cond_signal(&lynqCond);
    pthread_mutex_unlock(&lynqMutex);
    return 0;
}
void set_timer(int it_interval_sec, int it_interval_usec,int it_value_sec,int it_value_usec)
{
    struct itimerval itv, oldtv;
    itv.it_interval.tv_sec = it_interval_sec;
    itv.it_interval.tv_usec = it_interval_usec;
    itv.it_value.tv_sec = it_value_sec;
    itv.it_value.tv_usec = it_value_usec;
    setitimer(ITIMER_REAL, &itv, &oldtv);
}
 
int sleep_with_restart(int second) {
    int left = second;
    while (left > 0) 
    { 
       left = sleep(left);
    }
    return 0;
}
int millli_sleep_with_restart(int millisecond)
{
    int left = millisecond*1000;
    while (left > 0) 
    { 
        left = usleep(left);
    }

    return 0;
}
 int lynqNoneParame(const char *requestStr){
    char *argv[MAX_LEN];
    int32_t token;
    char *mRequestStr=new char[MAX_LEN];
    strcpy(mRequestStr, requestStr);
    argv[0] = mRequestStr;
    token=android::getRequestData(argv, 1);
    delete mRequestStr;
    return token;
}

int lynqIntParame(const char *requestStr,int parame){
    int32_t token;
    char *argv[MAX_LEN];
    char indexStr[MAX_QUEST_LEN] = {0};
    char *mRequestStr=new char[MAX_LEN];
    strcpy(mRequestStr, requestStr);
    sprintf(indexStr, "%d", parame);
    LYINFLOG("lynqIntParame,indexStr:%s,parame:%d\n", indexStr,parame);
    argv[0] = mRequestStr;
    argv[1] = indexStr;
    token = android::getRequestData(argv, 2);
    delete mRequestStr;
    return  token;
}

int lynqStringParame(const char *requestStr,const char *parameString){
    int32_t token;
    char *mRequestStr=new char[MAX_LEN];
    char *mParameString=new char[MAX_LEN];
    char *argv[MAX_LEN];
    strcpy(mRequestStr, requestStr);
    strcpy(mParameString, parameString);
    argv[0] = mRequestStr;
    argv[1] = mParameString;
    token = android::getRequestData(argv, 2);
    delete mRequestStr;
    delete mParameString;
    return  token;

}

int lynqStringParameOperate_enable(const char *requestStr, char *facility, char *pin, int serviceclass){
    int32_t token;
    char *mRequestStr=new char[MAX_LEN];
    char *mfacility=new char[MAX_LEN];
    char *mpin = new char[MAX_LEN];
    char mserviceclass[MAX_QUEST_LEN] = {0};
    char *argv[MAX_LEN];
    strcpy(mRequestStr, requestStr);
    strcpy(mfacility, facility);
    strcpy(mpin, pin);
    sprintf(mserviceclass, "%d", serviceclass);
    argv[0] = mRequestStr;
    argv[1] = mfacility;
    argv[2] = mpin;
    argv[3] = mserviceclass;
    argv[4] = "1";
    token=android::getRequestData(argv, 5);
    delete mRequestStr;
    delete mfacility;
    delete mpin;
    return token;
}

int lynqStringParameOperate_disable(const char *requestStr, char *facility, char *pin, int serviceclass){
    int32_t token;
    char *mRequestStr=new char[MAX_LEN];
    char *mfacility=new char[MAX_LEN];
    char *mpin = new char[MAX_LEN];
    char mserviceclass[MAX_QUEST_LEN] = {0};
    char *argv[MAX_LEN];
    strcpy(mRequestStr, requestStr);
    strcpy(mfacility, facility);
    strcpy(mpin, pin);
    sprintf(mserviceclass, "%d", serviceclass);
    argv[0] = mRequestStr;
    argv[1] = mfacility;
    argv[2] = mpin;
    argv[3] = mserviceclass;
    argv[4] = "0";
    token=android::getRequestData(argv, 5);
    delete mRequestStr;
    delete mfacility;
    delete mpin;
    return token;
}

int lynqStringParameQuery(const char *requestStr, char *facility, char *pin, int serviceclass){
    int32_t token;
    char *mRequestStr=new char[MAX_LEN];
    char *mfacility=new char[MAX_LEN];
    char *mpin = new char[MAX_LEN];
    char mserviceclass[MAX_QUEST_LEN] = {0};
    
    char *argv[MAX_LEN];
    strcpy(mRequestStr, requestStr);
    strcpy(mfacility, facility);
    strcpy(mpin, pin);
    sprintf(mserviceclass, "%d", serviceclass);
    //sprintf(mcmd, "%d", cmd);
    argv[0] = mRequestStr;
    argv[1] = mfacility;
    argv[2] = mpin;
    argv[3] = mserviceclass;
    //argv[4] = mcmd;
    token=android::getRequestData(argv, 4);
    delete mRequestStr;
    delete mfacility;
    delete mpin;
    return token;
}

int lynqStringParameChange(const char *requestStr, char *old_pin, char *new_pin){
    int32_t token;
    char *mRequestStr=new char[MAX_LEN];
    char *mold_pin=new char[MAX_LEN];
    char *mnew_pin = new char[MAX_LEN];

    char *argv[MAX_LEN];
    strcpy(mRequestStr, requestStr);
    strcpy(mold_pin, old_pin);
    strcpy(mnew_pin, new_pin);
    argv[0] = mRequestStr;
    argv[1] = mold_pin;
    argv[2] = mnew_pin;
    token=android::getRequestData(argv, 3);
    delete mRequestStr;
    delete mold_pin;
    delete mnew_pin;
    return token;
}

int triggerRequest(int request)
{
    int32_t token;
    switch (request)
    {
        case RIL_REQUEST_GET_SIM_STATUS:
        {
            token = lynqNoneParame("RIL_REQUEST_GET_SIM_STATUS");
            break;
        }
    }
    return 0;
}
int advanceCheckError(RIL_Errno err)
{
    RIL_Errno tempe = 0;
    RIL_CardState cardState =0;
    Service_State serviceState= 0;
    RIL_SOCKET_ID soc_id = (RIL_SOCKET_ID)Phone_utils::get_enable_sim_for_dsss();
    switch(err)
    {
        case RIL_E_GENERIC_FAILURE:
        {
            cardState = getSimState(soc_id);
            switch(cardState)
            {
                case 0:
                {
                    tempe = RIL_E_SIM_ABSENT;
                    return tempe;
                    //break;
                }
                case 2:
                {
                    tempe = (RIL_Errno)LYNQ_E_CARDSTATE_ERROR;
                    return tempe;
                    //break;
                }
                default:
                    break;
            }
            serviceState = get_reg_voice_service_state(RIL_REQUEST_VOICE_REGISTRATION_STATE, soc_id);
            switch(serviceState)
            {
                case 1:
                {
                    tempe = (RIL_Errno)LYNQ_E_STATE_OUT_OF_SERVICE;
                    return tempe;
                    //break;
                }
                case 2:
                {
                    tempe = (RIL_Errno)LYNQ_E_STATE_EMERGENCY_ONLY;
                    return tempe;
                    //break;
                }
                case 3:
                {
                    tempe = (RIL_Errno)LYNQ_E_STATE_POWER_OFF;
                    return tempe;
                    //break;
                }
                default:
                    break;
            }
            tempe = err;
            break;
        }
        default:
            tempe = err;
            break;
    }
    LYDBGLOG("[advanceCheckError] temp error is %d\n",tempe);
    return tempe;
}
int strUpper(char * str)
{
    int i=0;
    while(1)
    {
        if(str[i]=='\0')
        {
            break;
        }
        if(str[i]>='a'&&str[i]<='z')
        {
             str[i]=str[i]-32;
        }
        i++;
    }
    return 0;
}
lynqQueue *commonFindParcelmsg(const int32_t token,const int time,RIL_Errno&e)
{
    int timeCount = time;
    int num=0;
    lynqQueue *node = NULL;
    lynqQueue *temp =NULL;
    while(timeCount--)
    {
         millli_sleep_with_restart(10);
         temp=LynqQueueHead;
         if(temp==NULL)
         {
             LYDBGLOG("Queue head is NULL, maybe malloc fail!\n");
             continue;
         }
         node = searchTokeninQueue(token, temp);
         if(node ==NULL)
         {
             LYDBGLOG("can not find token %x\n",token);
             e=-1;
             return NULL;
         }
         if(node->t_Errno!=RIL_E_SUCCESS)
         {
             LYDBGLOG("get fail, the error code is %d\n",node->t_Errno);
             e = advanceCheckError(node->t_Errno);
             return NULL;
         }
         else
         {
            node->parcel.setDataPosition(0);
            if (node->parcel.dataAvail() > 0) 
            {
                e=node->t_Errno;
                
                return node;
             }
             else
             {
               continue;
             }
         }
    }
    if(timeCount<0)
    {
        LYDBGLOG("time out,can not find message!\n");
        e=(RIL_Errno)LYNQ_E_TIME_OUT;
    }
    return NULL;

}
lynqQueue *commonUpdateEstatus(const int32_t token,const int time,RIL_Errno&e)
{
    int timeCount = time;
    int num=0;
    lynqQueue *node = NULL;
    lynqQueue *temp =NULL;
    while(timeCount--)
    {
        millli_sleep_with_restart(10);
        temp=LynqQueueHead;
        if(temp==NULL)
        {  
            LYDBGLOG("Queue head is NULL, maybe malloc fail!\n");
            continue;
        }
        node = searchTokeninQueue(token, temp);
        if(node ==NULL)
        {    
            RLOGD("can not find token %x\n",token);
            e=-1;
            return NULL;
        }
        if(node->t_Errno!=RIL_E_SUCCESS)
        {  
            
            LYDBGLOG("get fail, the error code is %d\n",node->t_Errno);
            e = advanceCheckError(node->t_Errno);
            return node;
        }
        else
        {
            if (node->E_status==1) 
            {   
               
                e=node->t_Errno;
                return node;
            }
            else
            {
                continue;
            }
        }
    }
    if(timeCount<0)
    {
        LYDBGLOG("time out,can not find message!\n");
        e=(RIL_Errno)LYNQ_E_TIME_OUT;
    }
    return NULL;
}

FindOperator*find_ope_command (char *name,FindOperator *Class){
    register int i;
    for (i = 0; Class[i].MCCMCN; i++)
        if (strncmp (name, Class[i].MCCMCN, 5) == 0)
            return (&Class[i]);
    return ((FindOperator *)NULL);
}
