/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 */
/* MediaTek Inc. (C) 2010. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */
#ifndef __RIL_STAM__
#define __RIL_STAM__
#include  <vendor-ril/telephony/ril.h>
#include  "common.h"



using::android::Parcel;

#define MAX_IMSI  20
int getDeviceIdentity(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI);
int getIMEI(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI);
int getIMEISV(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI);
int getBasebandVersion(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI);
int resetRadio(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI);
int getScreenState(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI);
int setTRM(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI);
int setIMSEnable(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI);
int sendATCMD(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI);
void parseAtCmd(const char* line);
int setIMSCfg(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI);
#ifdef KEEP_ALIVE
int startKeepAlivePro(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI);
int stopKeepAlivePro(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI);
void handleKeepAliveResponse(int request, const void* data, size_t datalen, RIL_SOCKET_ID soc_id, bool is_error);


/*****mobiletek-add****/
typedef enum{
    LYNQ_CALL_ON=0,
    LYNQ_CALL_OFF,
}lynqCallStatus;
typedef struct {
int32_t token;
int callid;
int toa;
char * addr;
int isMpty;
int isMT;
int selflen;
RIL_CallState callState;
RIL_Errno lynq_error;
} lynq_call_list;
typedef struct callInfo
{
    int32_t token;
    int request;
    RIL_Errno Error_tok;
    Parcel parcel;
    lynq_call_list **calllist_tok;
    struct callInfo * next;
}callInfoLink;

extern lynq_call_list **pCallList;
extern callInfoLink * callInfoLinkhead;

extern lynqCallStatus s_callStatus;

callInfoLink * create_callInfoLink();

typedef struct LQueue
{
    int32_t token;
    int request;
    RIL_Errno t_Errno; //token error number.
    int E_status;
    Parcel parcel;
    struct LQueue * next;
}lynqQueue;
extern lynqQueue * LynqQueueHead;

lynqQueue * createLynqQueue();
int lynqApiInit();
lynqQueue * searchRequestinQueue(int32_t request,lynqQueue *head);
lynqQueue * searchTokeninQueue(int32_t token,lynqQueue *head);
void lynqDeQueue(int32_t token);
int getCallStatus(void);
int setCallStatus(lynqCallStatus callStatus);

typedef struct simInfo{
    int32_t token;
    int request;
    int simInfoLen;
    RIL_CardState card_status;
    RIL_AppType    card_type;
    RIL_PinState pin_state;
    RIL_Errno Error_tok;
    char imsi[MAX_IMSI];  
    //char *imsi;
    struct simInfo* next;
}simInfoLink;
extern simInfoLink *simInfoLinkHead;
char * lynqStrdupReadString(Parcel &p);
simInfoLink *createSimInfoLink();
void LYNQ_DispatchResponse(int request,int32_t token,RIL_Errno respe,lynq_call_list**nodeCallList,void *response,size_t respLen);
void updateLinkCallInfo(callInfoLink * callInfoLinkhead,lynq_call_list** nodeCallList);
callInfoLink* addCallInfo(int tok,int request,RIL_Errno respe,callInfoLink* head,lynq_call_list** nodeCallList);
void printlist(callInfoLink * callInfoLinkhead);

void setCallList(int token,RIL_Call **pCallLists,size_t respLen,RIL_Errno error);
int callListToParcel(void *response,size_t responselen,Parcel &p);

void updateAsyncData(RIL_Token t, RIL_Errno e,void * response, size_t responselen,lynqQueue* head);



void freeCallList(int respLen);

void addSimInfo(int request,RIL_Errno respe,int32_t token,simInfoLink *NodeSimInfoLink,void *response,size_t respLen);
simInfoLink * inSimQueue(int request,int32_t token,simInfoLink *head);
simInfoLink * deSimQueue(simInfoLink *head,int32_t token);
void LYNQ_DispatchRequest(int32_t request,int32_t token);
void addImsiInfo(int request,RIL_Errno respe,int32_t token,simInfoLink *head,void *response,size_t respLen);

/*****moblietek-end****/
#endif /*KEEP_ALIVE*/
#endif
