/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 */
/* MediaTek Inc. (C) 2010. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */
#ifndef __ATCI__
#define __ATCI__

#include "atci_common.h"

#define PHONE_NUMBER_LENGTH 256
//#define SPI_URI_LENGTH 256
#define ATCI_SERVER_SOCKET "/dev/socket/atci_server_socket"
#define SOCKET_BUF_SIZE 1024
#if ATCI_ENABLE_RESPONSE
#define RESPONSE_BUF_SIZE 512
#endif
#define COMMAND_LENGTH 1024
#define ATCI_MAX_ARGS 10
#define RIL_REQUEST_STRING_LENGTH 128
#define TELEPHONY_REQUEST_BASE 0
#define TELEPHONY_RESPONSE_BASE 1000

#define TELEPHONY_REQUEST_SET_CALL_FORWARD (TELEPHONY_REQUEST_BASE + 1)
#define TELEPHONY_REQUEST_SET_CALL_WAITING (TELEPHONY_REQUEST_BASE + 2)
#define TELEPHONY_REQUEST_SET_CALL_BARRING (TELEPHONY_REQUEST_BASE + 3)
#define TELEPHONY_REQUEST_DIAL (TELEPHONY_REQUEST_BASE + 4)
#define TELEPHONY_REQUEST_DROP_CONF_CALL_MEMBER (TELEPHONY_REQUEST_BASE + 5)
#define TELEPHONY_REQUEST_FLIGHT (TELEPHONY_REQUEST_BASE + 6)
#define TELEPHONY_REQUEST_SET_MUTE (TELEPHONY_REQUEST_BASE + 7)
#define TELEPHONY_REQUEST_MERGE_CONF_CALLS (TELEPHONY_REQUEST_BASE + 8)
#define TELEPHONY_REQUEST_CREATE_IMS_CONF_CALL (TELEPHONY_REQUEST_BASE +9)
#define TELEPHONY_REQUEST_DIAL_WITH_SIP_URI (TELEPHONY_REQUEST_BASE +10)

#define TELEPHONY_RESPONSE_FLIGHT (TELEPHONY_RESPONSE_BASE + 1)

#if ATCI_ENABLE_RESPONSE
extern char Respose_buf[RESPONSE_BUF_SIZE];
#endif
//request struct
typedef struct {
  int status;
  int reason;
  int service_class;
  int toa;
  char number[PHONE_NUMBER_LENGTH];
  int time_seconds;
} telephonyRequestSetCallForward;

typedef struct {
  int status;
  int service_class;
} telephonyRequestSetCallWaiting;

typedef struct {
  int status;
  char facility[32];
  char password[32];
  int serviceClass;
  char aid[32];
} telephonyRequestSetCallBarring;

typedef struct {
  int clir;
  char phonyNumber[PHONE_NUMBER_LENGTH];
} telephonyRequestDial;

typedef struct {
  int confCallID;
  char phonyNumber[PHONE_NUMBER_LENGTH];
  int callIDToAdd;
} telephonyRequestDropConfCallMember;

typedef struct {
  unsigned int flightModeOn;
} telephonyRequestFlight;

typedef struct {
  int isMute;
} telephonyRequestSetMute;

typedef struct {
  int reserve;
} telephonyRequestCreateIMSConfCall;

//response struct
typedef struct {
  int ret;
} telephonyResponseFlight;

#if 1 //socket data protocol.
typedef struct {
  int requestId;
  int datalen;
  char * data;
} socketData;
#endif

#ifdef ATCI_PARSE

#define MAX(a,b)  ((a)>(b)?(a):(b))

typedef enum {
  INCH_TYPE_MIN = 0,
  INCH_TYPE_UART,
  INCH_TYPE_CHAR,
  INCH_TYPE_UTCP,
  INCH_TYPE_MAX
} atci_inch_type_e;

typedef struct atci_num_resp_s {
  char resp[20];
  int num;
} atci_num_resp_t;

void sendAtciRequest(int request, char* reqStr, int argc, char** argv);
#endif

void ATCIResponse(int token, int error, char* data, int reqNum);
void ATCIResponseNoToken(int error, char* data, int reqNum); /*warren add for lynq atsvc on 20221208*/
int atci_send_data(char *data);
int atci_send_result(int error_code);
void * StartATCISocket(void *param);
#endif
