/*
*  Copyright (C) 2014 MediaTek Inc.
*
*  Modification based on code covered by the below mentioned copyright
*  and/or permission notice(s).
*/

/* 
**
** Copyright 2006 The Android Open Source Project
**
** Licensed under the Apache License, Version 2.0 (the "License");
** you may not use this file except in compliance with the License.
** You may obtain a copy of the License at
**
**     http://www.apache.org/licenses/LICENSE-2.0
**
** Unless required by applicable law or agreed to in writing, software
** distributed under the License is distributed on an "AS IS" BASIS,
** WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
** See the License for the specific language governing permissions and
** limitations under the License.
*/

#include <stdio.h>
#include <stdlib.h>
#include <dlfcn.h>
#include <string.h>
#include <stdint.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include <vendor-ril/telephony/ril.h>
#include <log/log.h>
#include <sys/file.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <signal.h>
#include "common.h"
#include "lynq_shm.h"

extern "C" void RIL_register (const RIL_RadioFunctions *callbacks);

extern "C" void RIL_onRequestComplete(RIL_Token t, RIL_Errno e,
                           void *response, size_t responselen);


#if defined(ANDROID_MULTI_SIM)
extern "C" void RIL_onUnsolicitedResponse(int unsolResponse, const void *data,
                                size_t datalen, RIL_SOCKET_ID socket_id);
#else
extern "C" void RIL_onUnsolicitedResponse(int unsolResponse, const void *data,
                                size_t datalen);
#endif

#ifdef RIL_TIME_CB
void RIL_requestTimedCallback (RIL_TimedCallback callback,void *param, const struct timeval *relativeTime)
{
    RLOGD("this is RIL_requestTimedCallback");
    callback(param);
}
#endif

#undef LOG_TAG
#define LOG_TAG "DEMO_MAIN"

static struct RIL_Env s_rilEnv = {
    RIL_onRequestComplete,
    RIL_onUnsolicitedResponse,
#ifdef RIL_TIME_CB
    RIL_requestTimedCallback
#else
    NULL
#endif
};

/**
 * @brief success return 1 else return 0
 * 
 * @return int 
 */
static int lynq_check_modem_state(void)
{
    FILE *fp;
    char buffer[64]={};
    fp = popen("cat /sys/kernel/ccci/boot","r");
    fgets(buffer,sizeof(buffer),fp);
    if(buffer[4] == '4')
    {
        pclose(fp);
        return 1;
    }
    else
    {
        pclose(fp);
        return 0;
    }
}

static void signal_handler(int signum)
{
    switch(signum)
    {
        case SIGABRT:
            RLOGD("function %s recv SIGABRT\n", __FUNCTION__);
            break;
        case SIGBUS:
            RLOGD("recv %s SIGBUS\n", __FUNCTION__);
            break;
        case SIGFPE:
            RLOGD("recv %sSIGFPE\n", __FUNCTION__);
            break;
        case SIGILL:
            RLOGD("recv %sSIGILL\n", __FUNCTION__);
            break;
        case SIGSEGV:
            RLOGD("recv %sSIGSEGV\n", __FUNCTION__);
            break;
        case SIGHUP:
            RLOGD("recv %s SIGHUP\n", __FUNCTION__);
            if(ttyGS3_fd > 0)
            {
                close(ttyGS3_fd);
                RLOGE("reopen need close");
            }
            ttyGS3_fd = open("/dev/ttyGS3",O_RDWR);
            if(ttyGS3_fd==-1)
            {
                RLOGE("open ttyGS3 failure!!!");
            }
            break;
         default:
            RLOGD("recv unknown signal\n");
            break;
    }
}


int main(int argc, char **argv) {
    /*lei add for gsw
    reason:Socket sending failed at GSW
    */
    //signal(SIGHUP, signal_handler);
    atexit (lynq_exit);
    system("route add -host 255.255.255.255 dev lo");
    int lock_file = open("/tmp/tel_demo_single_proc.lock", O_CREAT|O_RDWR, 0666);
    int rc = flock(lock_file,LOCK_EX|LOCK_NB);
    if(rc) {
        if(EWOULDBLOCK == errno) {
            printf("Error: cannot restart the telephony app repeatedly\n");
            RLOGD("Error: cannot restart the telephony app repeatedly");
            exit(0);
        }
    }

    if(ril_init_mem()!=0)
    {
        printf("Error: cannot ril_init_mem\n");
        RLOGD("Error: cannot ril_init_mem");
        exit(0);
    }
		
#ifdef BASELIB_DIR_LIB64
    const char *rilLibPath = "/lib64/libvendor-ril.so";
#else
    const char *rilLibPath = "/lib/libvendor-ril.so";
#endif
    void *dlHandle;
    const RIL_RadioFunctions *(*rilInit)(const struct RIL_Env *, int, char **);

    const RIL_RadioFunctions *funcs;

    RLOGD("**RIL Daemon Started**");
    //prctl(PR_SET_NAME,(unsigned long)"demo_main_thread");
    dlHandle = dlopen(rilLibPath, RTLD_NOW);

    if (dlHandle == NULL) {
        RLOGE("dlopen failed: %s", dlerror());       
        exit(EXIT_FAILURE);
    }

    android::RIL_startEventLoop();
	#ifndef RIL_TIME_CB
    android::startATCILoop();
	#else
	#endif
    //android::startPMLoop();
    //android::startWakupLoop();

    rilInit =
        (const RIL_RadioFunctions *(*)(const struct RIL_Env *, int, char **))
        dlsym(dlHandle, "RIL_Init");

    if (rilInit == NULL) {
        RLOGE("RIL_Init not defined or exported in %s", rilLibPath);
        exit(EXIT_FAILURE);
    }

    dlerror(); // Clear any previous dlerror
    RLOGD("start rilInit");
    funcs = rilInit(&s_rilEnv, 0, NULL);;
    RLOGD("start RIL_register");
    RIL_register(funcs);

    android::startGdbusLoop();
    RLOGD("RIL_Init RIL_register completed");
    printf("DemoApp launch done!\n");
    while (true) {
        sleep(UINT32_MAX);
    }
    close(lock_file);
}
