/**
 * @file pub_flags.h
 * @brief flagsֶ
 *
 * Copyright (C) 2023 Sanechips Technology Co., Ltd.
 * @author 
 * @ingroup 
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation. ѡGPLv2 Licence
 *
 */


#ifndef _PUB_FLAGS_H
#define _PUB_FLAGS_H


/*******************************************************************************
 *                           Include header files                              *
 ******************************************************************************/


/*******************************************************************************
 *                             Macro definitions                               *
 ******************************************************************************/
/**
 * @brief flagsƫƵַ
 */
#define	FLAGS_MAGIC (0x464C4147UL)

#define	DUALSYSTEM_STATUS_BOOTABLE		(0xB0AB)	/*  */
#define	DUALSYSTEM_STATUS_SUCCESSFUL	(0x5CCF)	/* ܳɹ */
#define	DUALSYSTEM_STATUS_UNBOOTABLE	(0xBABE)	/*  */

#define OTA_PARTITION_NUM_MAX 15

#define IMG_NAME_LEN 16
#define IMG_NUM_MAX 15


/*******************************************************************************
 *                             Type definitions                                *
 ******************************************************************************/
typedef struct
{
    int status;     /* bootable/successful/unbootable */
    int try_cnt;
} T_DualSystem_Status;

typedef enum
{
    DUAL_SYSTEM  = 0x875A,   /* һϵͳ */
    DUAL_SYSTEM2 = 0x986B,   /* ڶϵͳ */
} T_BOOT_TARGET;

#define NVRO_INIT        (0)       /* initial state */
#define NVRO_BACKED_UP   (0xBACE)  /* nvro backed up already */
#define NVRO_BACKING_UP  (0xBAC1)  /* nvro back up next boot */
#define NVRO_RESTORING   (0x2E20)  /* nvro restoring  */
#define NVRO_INVALID     (0xDEAD)  /* nvro invalid */

/* ˫ϵͳ */
typedef enum
{
    DUALSYSTEM_RECOVERY = 0x7575,          /* normal-recovery˫ϵͳ */
    DUALSYSTEM_AA       = 0xAAAA,          /* AA˫ϵͳ */
    DUALSYSTEM_AB       = 0xABAB           /* AB˫ϵͳ */
} T_BOOT_DUALSYSTEM_TYPE;

typedef struct
{
    T_BOOT_TARGET			boot_to;        /* ǰϵͳ־*/
    unsigned int			fota_status;    /* fota״̬ */
    T_DualSystem_Status		system;         /* һϵͳ״̬ */
    T_DualSystem_Status		system2;        /* ڶϵͳ״̬ */
} T_BOOT_FOTA_FLAG;

typedef struct
{
    T_BOOT_DUALSYSTEM_TYPE dualsys_type;  /* ˫ϵͳ */
    char system_boot_env[128];
    char system2_boot_env[128];
} T_BOOT_ENV;

typedef struct
{
	int  fs_status;  /* ļϵͳ쳣ʶ */
	char fs_mtd_name[16];
	char fs_ubi_vol_name[16];
} T_UBIFS_STATUS;

typedef struct
{
    int mtdnum;
    unsigned int len;
} T_AA_PARTITION_INFO;

typedef struct
{
    char         name[IMG_NAME_LEN];
    unsigned int size_a;
    unsigned int size_b;
} T_IMG_SIZE;

typedef struct
{
	unsigned int magic_start;  /* Чħ */
	
    T_BOOT_FOTA_FLAG 	boot_fota_flag;
    T_BOOT_ENV 			boot_env;
	T_UBIFS_STATUS		ubifs_status;
	unsigned int        nvro_flag;
	unsigned int		crc32;
	T_BOOT_TARGET		ota_system; /* ʱϵͳAϵͳB */
	T_AA_PARTITION_INFO ota_partiton_info[OTA_PARTITION_NUM_MAX]; /* 15imageС */
	unsigned int	poweron_time;
	char reserve[48];
	unsigned int magic_end;  /* Чħ */
	T_IMG_SIZE img_size[IMG_NUM_MAX];   /* ϵͳļС */
	T_BOOT_TARGET sync_system; /* ͬʱϵͳAϵͳB */
	unsigned int		crc32_1;
    int reserve2[292]; /* չֶ */
} T_FLAGS_INFO;


#endif // _PUB_FLAGS_H

