/*
 *
 * * Copyright 2023
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#include "zlog_com.h"

/**
 * 궨
 */

/**
 * ⲿ
 */
extern int 	port;
extern int 	debug;
extern char	*machinename;
extern char	*sttyparms;
extern char	*linkname;
extern int	isdaemon;
extern int	curConnects;
extern int	writeonly;
extern char	*sdevname;
extern int	maxConnects;
extern T_COMM_FS_PARAM gFsSaveParam;

/**
 * ⲿ
 */
extern int zLogAgt_Savefs_Main(int fd_devfile);
extern int zLogAgt_NetSerial_Main(int fd_usb);

/**
 * ȫֱ
 */

/**
* ֲ
 */
static void pusage(char *progname); 

/**
 * ֲ
 */
int zLogAgt_argv_proc(int argc, char *argv[])
{
    int opt;
    extern char *optarg;
    
    while ((opt=getopt(argc,argv,"ed:f:t:m:p:r:s:l:wx:")) != EOF)
        switch (opt) {
        case 'd':
            sdevname = optarg;
            break;
        case 'f':
            gFsSaveParam.localFsPath = optarg;
            break;
        case 't':
            gFsSaveParam.tMaxLogsize = atoi(optarg);
            break;
        case 'e':
            isdaemon = 1;
            break;
        case 'm':
            maxConnects = atoi(optarg);
            break;
        case 'p':
            port = atoi(optarg);
            break;
        case 'r':
            machinename = optarg;
            break;
        case 's':
            sttyparms = optarg;
            break;
        case 'l':
            linkname = optarg;
            break;
        case 'x':
            debug = atoi(optarg);
            break;
        case 'w':
            writeonly = 1;
            break;    
        default:
            pusage(argv[0]);
            break;
        }
}

static void pusage(char *progname) 
{
    printf("log trace serial version 1.3.  Usage:\n");
    printf("local save:[-d devicepath] [-f \"log save path\"][-s \"stty params\"]  \n\n");
    printf("net serial:[-d devicepath] [-r machinename] [-p netport] [-s \"stty params\"] [-m maxconnect] \n\n");
    printf("-d devpath    I/O device, either serial port or pseudo-tty master: (for example: ttyUSB0)\n");    
    printf("-f local fs path    Specifiy log save path: (for example: /tmp/logfile)\n");    
    printf("-t total log size    Specifiy the total log size can be saved /\n");
    printf("-r machinename    The remote machine name to connect to.  If not\n");
    printf("            specified, then this is the server side.\n");
    printf("-p netport    Specifiy IP port# (default 23000)\n");
    printf("-s     \"stty params\"    If serial port, specify stty parameters, see man stty\n");
    printf("-m max-connections    Maximum number of simultaneous client connections to allow\n");
    printf("-e                Run as a daemon program\n");
    printf("-x debuglevel    Set debug level, 0 is default, 1,2 give more info\n");
    printf("-l linkname        If the device name is a pseudo-tty, create a link to the slave\n");
    printf("-w              Only write to the device, no reading\n");
}

/**
 * main 
 */
int main(int argc, char *argv[])
{
    int devfd = 0;
    
    zLogAgt_argv_proc(argc, argv);
    
    if (sdevname == NULL) {
        printf("devpath is not config\n");
        exit(1);
    }    
    
    devfd = open(sdevname, O_RDWR, 0755);
    if (devfd < 0) {
        printf("Open of %s failed: %m\n", sdevname);
        exit(2);
    }

    if (sttyparms) 
        set_tty(devfd, sttyparms);
    else
        set_tty(devfd, ZLOG_DEFAULT_TTYBAUD);
        
    /*浽屾ļϵͳ*/
    if(gFsSaveParam.localFsPath)     
        zLogAgt_Savefs_Main(devfd);
    else 
        zLogAgt_NetSerial_Main(devfd);
}

