/***************************************************************/
//
//μ LPAӿĵV0.1 SGP.22, JSON
//   
/***************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <sys/time.h>
#include <termios.h>

#include "lpa_inner.h"


#define LPA_AUTH_DATA_LEN 512

/***************************************************************/
//
//euiccChallenge:صAPDU,9000
//euiccInfo1: صAPDU,9000
//smdpAddress:sdmpַ
//json
//
/***************************************************************/
char *InitiateAuthentication(char *euiccChallenge, char *euiccInfo1, char *smdpAddress)
{
	char *js_data = NULL;
	unsigned char clg_byte[APDU_BYTE_LEN] = {0};
	unsigned char info1_byte[APDU_BYTE_LEN] = {0};
	int clg_len = 0;
	int info1_len = 0;
	char *clg_b64 = NULL;
	char *info1_b64 = NULL;

	clg_len = string2bytes(euiccChallenge, clg_byte, strlen(euiccChallenge));
	clg_b64 = lpa_base64_encode(clg_byte, clg_len);
	if (clg_b64 == NULL)
		return NULL;

	info1_len = string2bytes(euiccInfo1, info1_byte, strlen(euiccInfo1));
	info1_b64 = lpa_base64_encode(info1_byte, info1_len);
	if (info1_b64 == NULL) {
		free(clg_b64);
		return NULL;
	}
	
	js_data = malloc(LPA_AUTH_DATA_LEN);
	if (js_data != NULL) {
		memset(js_data, 0, LPA_AUTH_DATA_LEN);
		snprintf(js_data, LPA_AUTH_DATA_LEN, "{\"euiccChallenge\":\"%s\",\"euiccInfo1\":\"%s\",\"smdpAddress\":\"%s\"}", 
    		clg_b64, info1_b64, smdpAddress);
		//printf("js_data:-%s-\n", js_data);
	}

	free(clg_b64);
	free(info1_b64);
	return js_data;
}

/***************************************************************/
//
//transactionId: smdp InitiateAuthenticationӿڷ
//authSerRespHex:صAPDU,9000
//
/***************************************************************/
char *AuthenticateClient(
char *transactionId,
char *authSerRespHex)
{
	char *ac_js = NULL;
	unsigned char *as_byte = NULL;
	int as_byte_len = 0;
	int ashex_len = strlen(authSerRespHex);
	char *as_b64 = NULL;
	int as_b64_len = 0;

	as_byte = malloc(ashex_len/2 + 1);
	if (as_byte == NULL) {
		return NULL;
	}
	memset(as_byte, 0, ashex_len/2 + 1);

	as_byte_len = string2bytes(authSerRespHex, as_byte, ashex_len);
	as_b64 = lpa_base64_encode(as_byte, as_byte_len);
	if (as_b64 == NULL) {
		free(as_byte);
		return NULL;	
	}
	as_b64_len = strlen(as_b64);
	
	ac_js = malloc(as_b64_len + 100);
	if (ac_js != NULL) {
		memset(ac_js, 0, as_b64_len + 100);
		snprintf(ac_js, as_b64_len + 100, "{\"transactionId\":\"%s\",\"authenticateServerResponse\":\"%s\"}", 
			transactionId, as_b64);
		//printf("js_data:-%s-\n", ac_js);
	}

	free(as_byte);
	free(as_b64);
	return ac_js;
}


/***************************************************************/
//
//transactionId: smdp AuthenticateClientӿڷ
//predlRespHex: prepareDownloadResponseHex صAPDU,9000
//
/***************************************************************/
char *GetBoundProfilePackage (
char *transactionId,
char *predlRespHex)
{
	char *bpp_js = NULL;
	unsigned char *pdl_byte = NULL;
	int pdl_byte_len = 0;
	int pdlhex_len = strlen(predlRespHex);
	char *pdl_b64 = NULL;
	int pdl_b64_len = 0;

	pdl_byte = malloc(pdlhex_len/2 + 1);
	if (pdl_byte == NULL) {
		return NULL;
	}
	memset(pdl_byte, 0, pdlhex_len/2 + 1);

	pdl_byte_len = string2bytes(predlRespHex, pdl_byte, pdlhex_len);
	pdl_b64 = lpa_base64_encode(pdl_byte, pdl_byte_len);
	if (pdl_b64 == NULL) {
		free(pdl_byte);
		return NULL;	
	}
	pdl_b64_len = strlen(pdl_b64);
	
	bpp_js = malloc(pdl_b64_len + 100);
	if (bpp_js != NULL) {
		memset(bpp_js, 0, pdl_b64_len + 100);
		snprintf(bpp_js, pdl_b64_len + 100, "{\"transactionId\":\"%s\",\"prepareDownloadResponse\":\"%s\"}", 
			transactionId, pdl_b64);
		//printf("js_data:-%s-\n", bpp_js);
	}

	free(pdl_byte);
	free(pdl_b64);
	return bpp_js;
}


/***************************************************************/
//
//pnfHex: pendingNotification صAPDU,9000
//
/***************************************************************/
char *HandleNotification(char *pnfHex)
{
	char *bpp_js = NULL;
	unsigned char *pdl_byte = NULL;
	int pdl_byte_len = 0;
	int pdlhex_len = strlen(pnfHex);
	char *pdl_b64 = NULL;
	int pdl_b64_len = 0;

	pdl_byte = malloc(pdlhex_len/2 + 1);
	if (pdl_byte == NULL) {
		return NULL;
	}
	memset(pdl_byte, 0, pdlhex_len/2 + 1);

	pdl_byte_len = string2bytes(pnfHex, pdl_byte, pdlhex_len);
	pdl_b64 = lpa_base64_encode(pdl_byte, pdl_byte_len);
	if (pdl_b64 == NULL) {
		free(pdl_byte);
		return NULL;	
	}
	pdl_b64_len = strlen(pdl_b64);
	
	bpp_js = malloc(pdl_b64_len + 100);
	if (bpp_js != NULL) {
		memset(bpp_js, 0, pdl_b64_len + 100);
		snprintf(bpp_js, pdl_b64_len + 100, 
			"{\"header\":{\"functionExecutionStatus\":{\"status\":\"Executed-Success\"}},\"pendingNotification\":\"%s\"}", pdl_b64);
		//printf("js_data:-%s-\n", bpp_js);
	}

	free(pdl_byte);
	free(pdl_b64);
	return bpp_js;
}


