/**
* @file upi_hash.h
* @brief ӿڼϢ
*
* Copyright (C) 2017 Sanechips Technology Co., Ltd.
* @author
*
*/

#ifndef _UPI_HASH_H
#define _UPI_HASH_H

/*******************************************************************************
 *                           Include header files                              *
 ******************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>


#include "upi_mtd.h"
/*******************************************************************************
 *                             Macro definitions                               *
 ******************************************************************************/






/*******************************************************************************
 *                             Type definitions                                *
 ******************************************************************************/

typedef enum E_HASH_TYPE{
	HASH_SHA512 = 0,
	HASH_SHA526 = 1
} hash_type_e;

/*******************************************************************************
 *                       Global variable declarations                          *
 ******************************************************************************/


/*******************************************************************************
 *                       Global function declarations                          *
 ******************************************************************************/
int check_image_hash(partition_mtd_info_t *mtd_info, int len, char * digest);

int get_hash_from_fd(int hash_type, int fd, unsigned int offset, unsigned int len, unsigned int read_size_per_time, unsigned char* digest);

int get_hash_from_file_path_segment(int hash_type, const char* file_path, unsigned int offset, unsigned int len, unsigned char* digest);


/*******************************************************************************
 *                      Inline function implementations                        *
 ******************************************************************************/




#endif // _UPI_HASH_H

