#ifndef UPI_LOG_H
#define UPI_LOG_H


#define  	FOTA_UPI_AB_LOG_ROOT										"/cache/zte_fota_ab/"

#define  	FOTA_UPI_AB_LOG_PATH										"/cache/zte_fota_ab/upi_ab.log"


#ifdef _IS_MIN


#define upi_print(ModID,...) do { \
							printf(__VA_ARGS__); \
						} while(0)


#else

#define upi_print(ModID,...) do { \
							printf(__VA_ARGS__); \
							char buffer_log[512] = {0}; \
							snprintf(buffer_log, 510, __VA_ARGS__); \
							upi_fwrite(ModID,buffer_log); \
						} while(0)


#endif



#define  upi_log(fmt, args...) \
 	do {upi_print(FOTA_UPI_AB_LOG_PATH,  "[%s][fota_upi] [%s-%d]: " fmt"\n", upi_get_time_us(),__FUNCTION__, __LINE__, ## args);} while (0)
#define  upi_err(fmt, args...)   \
	do {upi_print(FOTA_UPI_AB_LOG_PATH,  "[%s][fota_upi] [%s-%d]: " fmt"\n", upi_get_time_us(),__FUNCTION__, __LINE__, ## args);} while (0)
#if 0
#define  lib_log(fmt, args...)   \
	do {upi_print(FOTA_UPI_AB_LOG_PATH,  "" fmt"\n",  ## args);} while (0)
#endif


#define LOG_FUNC_BEGIN		upi_log("%s func begin!", __func__);
#define LOG_FUNC_END		upi_log("%s func end!", __func__);



void  upi_fwrite(char *filename, char* info);
void upi_close_logfile(void);
char * upi_get_time_us(void);

unsigned int timestamp_now(void);

#endif /*UPI_LOG_H*/
