/**
* @file upi_mtd.h
* @brief 汾Ϣ
*
* Copyright (C) 2017 Sanechips Technology Co., Ltd.
* @author
*
*/

#ifndef _UPI_MTD_H
#define _UPI_MTD_H

/*******************************************************************************
 *                           Include header files                              *
 ******************************************************************************/

#include "upi_img_interface.h"
#include "upi_update.h"
/*******************************************************************************
 *                             Macro definitions                               *
 ******************************************************************************/


/*******************************************************************************
 *                             Type definitions                                *
 ******************************************************************************/

typedef enum {
	DEVICE_MTD = 0,
	DEVICE_ZFTL = 1,
	DEVICE_MTD_BLOCK,
	DEVICE_UNKNOWN,
} device_type_t;

/*******************************************************************************
 *                       Global variable declarations                          *
 ******************************************************************************/


/*******************************************************************************
 *                       Global function declarations                          *
 ******************************************************************************/

/**
 * @brief
 * @note
 */

int mtd_find(const char *i_parti_name, char *o_mtd_path, device_type_t device_type, unsigned int o_mtd_path_len);
int get_partition_update_info(int target, const char *partition_name, device_data_t *device_data);
int mtd_erase_partition(int target, const char*partition_name);
int is_partition_exist(int target, char * partition_name);

/**
 * @brief
 * @note
 */

int write_mtd_partition_data(partition_mtd_info_t *mtd_info, int offset, int len, unsigned char *write_data);
int read_mtd_partition_data(partition_mtd_info_t *mtd_info, int offset, int len, char * read_data);


int get_partition_mtd_info(const char *partition_name, int partition_type, partition_mtd_info_t *mtd_info);


/*******************************************************************************
 *                      Inline function implementations                        *
 ******************************************************************************/




#endif // _UPI_MTD_H

