#ifndef UPI_UPDATE_H
#define UPI_UPDATE_H

#define _GNU_SOURCE
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/reboot.h>


#include "upi_public.h"
#include "upi_img_interface.h"
//#include "upi_mtd.h"
#include "zxic_fota_ab_upgrade.h"


#define  FOTA_PACKAGE_FILE    "/cache/zte_fota_ab/upgrade.package"

typedef enum {
	UPGRADE_STATUS_UNKNOWN = -1,
	UPGRADE_STATUS_VERIFING = 0,
	UPGRADE_STATUS_VERIFY_SUCCESS,
	UPGRADE_STATUS_VERIFY_FAIL,
	UPGRADE_STATUS_UPDATING,
	UPGRADE_STATUS_UPDATE_SUCCESS,
	UPGRADE_STATUS_UPDATE_FAIL,
	UPGRADE_STATUS_NO_NEED_UPDATE,
	UPGRADE_STATUS_NEED_UPDATE
} upgrade_status_s_type;

typedef struct {
	int upgrage_package_file_desc;			// upgrade package file description
	unsigned int upgrade_data_offset;		// upgrade package offset in file
	unsigned int upgrade_file_size;			// upgrade package file size
}partition_upgrade_package_info_t;


typedef struct {
	char 								partition_name[PARTITION_NAME_LEN];
	int									partition_type;
	long long							len;
	int									offset;
	int									zipped;
	char								hash[HASH_MAX_LEN];
	int									index;
	int									partition_total_count;
	partition_upgrade_package_info_t	pkg_info;
	partition_mtd_info_t				mtd_info;
} device_data_t;

int upi_update(z_upgrade_flush_status_t* flush_status);


#endif /*UPI_UPDATE_H*/
