/**
* @file zxic_fota_ab_upgrade.h
* @brief ABϵͳFOTAӿ
*
* Copyright (C) 2017 Sanechips Technology Co., Ltd.
* @author
*
*/

#ifndef ZXIC_FOTA_AB_UPGRADE_H
#define ZXIC_FOTA_AB_UPGRADE_H

/*******************************************************************************
 *                           Include header files                              *
 ******************************************************************************/



/*******************************************************************************
 *                             Macro definitions                               *
 ******************************************************************************/

#define		Z_FOTA_SUCCESS	(0)
#define		Z_FOTA_FAIL		(-1)

/*
 궨壺״̬
 */
#define		Z_UPGRAGE_STATUS_FREE				(-1)
#define		Z_UPGRADE_STATUS_VERIFING			(0)
#define		Z_UPGRADE_STATUS_VERIFY_SUCCESS		(1)
#define		Z_UPGRADE_STATUS_VERIFY_FAIL		(2)
#define		Z_UPGRADE_STATUS_UPDATING			(3)
#define		Z_UPGRADE_STATUS_UPDATE_SUCCESS		(4)
#define		Z_UPGRADE_STATUS_UPDATE_FAIL		(5)


/*
 * 궨壺˫ϵͳϵͳ״̬
 */
#define		Z_DUALSYSTEM_STATUS_BOOTABLE	(0xB0AB)	/*  */
#define		Z_DUALSYSTEM_STATUS_SUCCESSFUL	(0x5CCF)	/* ܳɹ */
#define		Z_DUALSYSTEM_STATUS_UNBOOTABLE	(0xBABE)	/*  */


#define		Z_DUAL_SYSTEM		(0x875A)
#define		Z_DUAL_SYSTEM2		(0x986B)


/*
 *궨壺
 */
#define 	Z_UPGRADE_TYPE_ALL			(0)		/* ȫ汾 */
#define 	Z_UPGRADE_TYPE_PLATFORM		(1)		/* ƽ̨ */
#define 	Z_UPGRADE_TYPE_OEM 			(2)		/* OEM */
#define		Z_UPGRADE_TYPE_INVALID		(-1)	/* Ч	*/


/*******************************************************************************
 *                             Type definitions                                *
 ******************************************************************************/
 


/*
 * ˵״̬Ϣṹ
 * upgrade_status:״̬ȡֵο״̬꡿
 * total_size:дܳ
 * upgraded_size:
 * ע⣺
 * Ϣ״̬ΪUPGRADE_STATUS_UPDATINGʱЧ״ֵ̬ʵ
 */

typedef struct {
	int					upgrade_status;
	int					total_size;
	int					upgraded_size;
}z_upgrade_status_info_t;


/*
 * ˵ϵͳ״̬
 * system:ǰϵͳ  Z_DUAL_SYSTEMZ_DUAL_SYSTEM2
 * status:ϵͳ״̬ Z_DUALSYSTEM_STATUS_BOOTABLEZ_DUALSYSTEM_STATUS_SUCCESSFULZ_DUALSYSTEM_STATUS_UNBOOTABLE
 * try_cnt:
 * ע⣺
 * Ϣ״̬ΪUPGRADE_STATUS_UPDATINGʱЧ״ֵ̬ʵ
 */
typedef struct {
	int		system;
	int		status;     /* bootable/successful/unbootable */
	int		try_cnt;
}z_system_info_t;


/*
 * ˵ϵͳ״̬
 * boot_to:´ϵͳ
 * system_1:ϵͳ1״̬
 * system_2:ϵͳ2״̬
 * ע⣺
 * 
 */
typedef struct 
{
	int						boot_to;        /* ǰϵͳ־*/
	int						fota_status;
	z_system_info_t			system_1;
	z_system_info_t			system_2;
}z_upgrade_system_info_t;


typedef struct {
	z_upgrade_status_info_t *status;
	void(* status_cb)(z_upgrade_status_info_t *status);
} z_upgrade_flush_status_t;


//typedef void(* flush_upgrade_status)(z_upgrade_status_info_t *status);


/*******************************************************************************
 *                       Global variable declarations                          *
 ******************************************************************************/


/*******************************************************************************
 *                       Global function declarations                          *
 ******************************************************************************/
 
/********************************************************************************
 *	:	zxic_dual_verify
 * :ϷУ		
 * ˵	
 * 		
 * 	:
 * ֵ	
 * 	Z_FOTA_SUCCESS		Уɹ
 *		Z_FOTA_FAILУʧ
 *	ע:		
 *		ͬӿڣ첽
 ********************************************************************************/
int zxic_dual_verify();	


/********************************************************************************
 * :	zxic_dual_upgrade		
 * :ʼ
 * ˵
 * 	
 *		flush_upgrade_status ״̬صӿ
 * 	:	
 * ֵ
 * 	Z_FOTA_SUCCESS		ɹ
 * 	Z_FOTA_FAILʧ
 * ע:	
 *		ͬӿڣ첽ã
 *		״̬صӿнֹӲ״̬
********************************************************************************/

int zxic_dual_upgrade(z_upgrade_flush_status_t* flush_status);




/********************************************************************************
 * :	zxic_dual_get_upgrade_status
 * :״̬ȡ		
 * ˵
 * 	
 * 	:	
 * 		upgrade_info_t *upgrade_info	 ״̬	
 * ֵ
 * 	Z_FOTA_SUCCESS		ɹ
 * 	Z_FOTA_FAILʧ
 * ע:	
********************************************************************************/
int zxic_dual_get_upgrade_status(z_upgrade_status_info_t *upgrade_info);

/********************************************************************************
 * :	zxic_dual_get_current_system
 * :ȡǰϵͳ	
 * ˵					
 * 				
 * 	:				
 * ֵ					
 * 	ǰϵͳ			
 * ע:
********************************************************************************/
int zxic_dual_get_current_system();

/********************************************************************************
 * :	zxic_dual_get_boot_to_system
 * :ȡĿϵͳ	
 * ˵					
 * 				
 * 	:				
 * ֵ					
 * 	ǰϵͳ			
 * ע:
********************************************************************************/
int zxic_dual_get_boot_to_system();



/********************************************************************************
 * :	zxic_dual_set_boot_to_system
 * :Ŀϵͳ	
 * ˵
 * 	
 *		system:Ŀϵͳ
 *		reboot_flag:ϺǷ 0:,1:
 * 	:	
 * 		ϵͳ״̬Ϣ		
 * ֵ
 * 	Z_FOTA_SUCCESS		ȡϢɹ
 * 	Z_FOTA_FAILȡϢʧ
 * ע:
 * 	ֵֻڲҪʱЧ
********************************************************************************/
int zxic_dual_set_boot_to_system(int system, int reboot_flag);	


/********************************************************************************
 * :	zxic_dual_get_system_status
 * :ѯABϵͳ״̬		
 * ˵
 * 	
 * 	:	
 * 		system_info ϵͳ״̬Ϣ		
 * ֵ
 * 	Z_FOTA_SUCCESS		ȡϢɹ	
 * 	Z_FOTA_FAILȡϢʧ	
 * ע:	
********************************************************************************/
int zxic_dual_get_system_status(z_upgrade_system_info_t *system_info);


/********************************************************************************
 * :	zxic_dual_set_system_status
 * :ϵͳ״̬		
 * ˵
 * 
 * 		system:ϵͳ
 * 		status:ϵͳ״̬
 * :
 * ֵ	
 * 	Z_FOTA_SUCCESS		ȡϢɹ	
 * 	Z_FOTA_FAILȡϢʧ	
 * ע:	
********************************************************************************/
int zxic_dual_set_system_status(int system, int status);

/*******************************************************************************
 *                      Inline function implementations                        *
 ******************************************************************************/


/********************************************************************************
 * :	zxic_init_flag_partition
 * :ʼflagϢ,Խӿڣ̲ʹ
 * ˵
 * :
 * :
 * ֵ	
 * 	Z_FOTA_SUCCESS		ȡϢɹ	
 * 	Z_FOTA_FAILȡϢʧ	
 * ע:	
********************************************************************************/

int zxic_init_flag_partition();




/********************************************************************************
 * :	zxic_dual_get_fota_status_for_nv
 * :ȡϵͳNVǷͬ־	
 * ˵					
 * 				
 * 	:				
 * ֵ					
 * 	״̬־ 0Ҫͬ1Ҫͬ			
 * ע:
********************************************************************************/
int zxic_dual_get_fota_status_for_nv();
int dual_AB_get_fota_status_for_nv();


/********************************************************************************
 * :	zxic_dual_set_fota_status_for_nv
 * :ϵͳNVǷͬ־		
 * ˵
 * 
 * 		status:״̬־0Ҫͬ1Ҫͬ
 * :
 * ֵ	
 * 	Z_FOTA_SUCCESS		óɹ	
 * 	Z_FOTA_FAIL			ʧ	
 * ע:	
********************************************************************************/
int zxic_dual_set_fota_status_for_nv(int status);
int dual_AB_set_fota_status_for_nv(int status);


/********************************************************************************
 * :	zxic_dual_sync_system
 * : AB-AAϵͳͬ		
 * ˵	
 * 	
 * : 
 * ֵ	
 * 	 Z_FOTA_SUCCESS	ͬɹ
 *	 Z_FOTA_FAIL ͬʧ
 * ע:		
 ********************************************************************************/
int zxic_dual_sync_system(void);	


/********************************************************************************
 * :	zxic_dual_get_upgrade_type
 * : ȡ
 * ˵	
 * 	
 * : 
 * ֵ	
 * 	 Z_UPGRADE_TYPE_ALL	ȫ汾
 *   Z_UPGRADE_TYPE_PLATFORM ƽ̨
 *   Z_UPGRADE_TYPE_OEM OEM
 *	 Z_UPGRADE_TYPE_INVALID Ч
 * ע:		
 ********************************************************************************/
int zxic_dual_get_upgrade_type(void);


/********************************************************************************
 * :	zxic_dual_get_sync_status
 * : ȡͬ״̬
 * ˵	
 * 	
 * : 
 *	 sync_status ͬ״̬
 * ֵ
 * ע:		
 ********************************************************************************/
void zxic_dual_get_sync_status(int *sync_status);


/********************************************************************************
 * :	zxic_dual_set_sync_status
 * : ͬ״̬
 * ˵	
 * 
 *	 sync_status ͬ״̬
 * : 
 * ֵ
 *	 Z_FOTA_SUCCESS óɹ
 *	 Z_FOTA_FAIL ʧ
 * ע:		
 ********************************************************************************/
int zxic_dual_set_sync_status(int sync_status);



#endif // ZXIC_FOTA_AB_UPGRADE_H

