#include <softap_api.h>
#include <errno.h>
#include "wlan_interface.h"

#define WIFI_SSID_LEN 33

#define WLAN_SECURITY_LEN 20
#define WLAN_ENCRYTYPE_LEN 10
#define WLAN_DEFAULTID_LEN 2
#define WLAN_WEPKEY_LEN 32
#define WLAN_PSK_LEN 65
#define WLAN_ENCODE_PSK_LEN 100

#define WF_AU_OPEN          "OPEN"            //wifi auth mode?
#define WF_AU_SHARE         "SHARED"
#define WF_AU_WEPAUTO       "WEPAUTO"
#define WF_AU_WPA           "WPAPSK"
#define WF_AU_WPA2          "WPA2PSK"
#define WF_AU_WPA_WPA2  	"WPAPSKWPA2PSK" 
#define WF_AU_WAPIPSK	    "WAPIPSK"
#define WF_ENCRY_NONE  "NONE"   //encrypt
#define WF_ENCRY_WEP    "WEP"
#define WF_ENCRY_TKIP   "TKIP"
#define WF_ENCRY_CCMP  "CCMP"
#define WF_ENCRY_AES    "AES"
#define WF_ENCRY_TKIP_CCMP "TKIPCCMP"
#define WF_ENCRY_TKIP_AES "TKIPAES"

static void zte_wlan_get_wifi_station_list(RT_802_11_MAC_TABLE *staionlist);


void zte_wlan_get_wifi_mac_list(RT_802_11_MAC_TABLE *maclist)
{
    int s = 0;
    int k = 0;

    FILE *pp = NULL;
    //FILE *pp2 = NULL;
    char buf[128]={0};
    char mac_tmp[18] = {0};
    char num_tmp[3] = {0};
    char *p = NULL;
    char *p_tmp = NULL;

    char authmode[20]={0};
    char encryptype[20]={0};
    
    char wifi_sta_connection[8]={0};
    
    char cmd[128]={0};
    char iifname[20]={0};
    RT_802_11_MAC_TABLE *mac_list=NULL ;
    memset(buf, 0, sizeof(buf)); 
    mac_list =(RT_802_11_MAC_TABLE*)malloc(sizeof(RT_802_11_MAC_TABLE));
    if(mac_list == NULL)
    {
            assert(mac_list);
    }
    else
    {
        memset(mac_list, 0, sizeof(RT_802_11_MAC_TABLE));
    }
   
    
    sc_cfg_get("wifi_sta_connection", wifi_sta_connection, sizeof(wifi_sta_connection));
   
    if(strncmp(wifi_sta_connection, "1",1) == 0){
        strcpy(iifname,"-i wl0.1");
    }

    //memset(&table,0,sizeof(table));

    sc_cfg_get("AuthMode",authmode,sizeof(authmode));
    sc_cfg_get("EncrypType",encryptype,sizeof(encryptype));
    if((!strcmp(authmode,"WPAPSK"))||(!strcmp(authmode,"WPA2PSK"))||(!strcmp(authmode,"WPAPSKWPA2PSK")))
    {
        sprintf(cmd,"wl %s autho_sta_list",iifname);
    }
    else
    {
        sprintf(cmd,"wl %s assoclist",iifname);
    }
    printf("[%s:%s]iifname:%s\n",__FILE__, __FUNCTION__, cmd);
    pp = popen(cmd, "r"); //ܵ
    if (!pp)
    {
        return ;
        
    } 
    
    strcpy(buf,"ABNORMAL");
again:       
    while(fgets(buf, 128, pp) != NULL)        
    {             
        
        if(strcmp(buf,"ABNORMAL")==0)  /*ps command error*/  
        {
            printf("[%s] detect_process strerror: %s\n",__FUNCTION__,strerror(errno));
            if(errno == EINTR) //Interrupted system call,ʱ
            {
                goto again;
            }
            
            pclose(pp);//رչܵ
            return ; 
         }
         memset(mac_tmp, 0, 18);            
         if((p = strstr(buf, ":")) != NULL)            
         {                
             p_tmp = p-2;               
             strncpy(mac_tmp, p_tmp, 17);               
                         
             for(s=0,k=0; s<6; s++,k+=3)                
             {                    
                 strncpy(num_tmp, mac_tmp + k, 2);                   
                //printf("zhouti num_tmp is %s\n", num_tmp);                    
                //table.Entry[sta_num].Addr[s]=atoi(num_tmp);                    
                mac_list->Entry[mac_list->Num].Addr[s] = s2x(num_tmp);  
                //mac_list->Entry[mac_list->Num].Addr[s] = 0; 
             }                
             mac_list->Num += 1;  
            
         }            
        memset(buf, 0, sizeof(buf));        
    }    
    (*maclist)= (*mac_list);
    if(mac_list) 
    {
        free(mac_list);
        mac_list=NULL;
    }
    pclose(pp); //رչܵ;
            
}

static void zte_wlan_get_wifi_station_list(RT_802_11_MAC_TABLE *staionlist)
{    
        
    int i = 0;
    char buf[128]={0};
    FILE *pp2 = NULL;
    char mac_tmp[18] = {0};
    char *p_tmp = NULL;
    char station_mac[18*32]={0}; // 00:00:00:00:00:00;
    char stationinfo[100] = {0};
    char mac_time[33] = {0};
    
    RT_802_11_MAC_TABLE *sta_list = NULL;
    sta_list = (RT_802_11_MAC_TABLE*)malloc(sizeof(RT_802_11_MAC_TABLE));
    if(sta_list == NULL)
    {
            assert(sta_list);
    }
    else
    {
        memset(sta_list, 0, sizeof(RT_802_11_MAC_TABLE)+1);
    }
    zte_wlan_get_wifi_mac_list(sta_list);

    for (i = 0; i <sta_list->Num; i++)
    {
        sprintf(station_mac + i * 18, "%2.2X:%2.2X:%2.2X:%2.2X:%2.2X:%2.2X;",\
                   sta_list->Entry[i].Addr[0], sta_list->Entry[i].Addr[1],
                    sta_list->Entry[i].Addr[2], sta_list->Entry[i].Addr[3],
                    sta_list->Entry[i].Addr[4], sta_list->Entry[i].Addr[5]);
        sprintf(stationinfo,"wl sta_info %2.2X:%2.2X:%2.2X:%2.2X:%2.2X:%2.2X \
            | grep \"in network\" | cut -d\" \" -f4",
                    sta_list->Entry[i].Addr[0], sta_list->Entry[i].Addr[1],
                    sta_list->Entry[i].Addr[2], sta_list->Entry[i].Addr[3],
                    sta_list->Entry[i].Addr[4], sta_list->Entry[i].Addr[5]);
        
        printf("[%s:%s]stationinfo:%s\n",__FILE__, __FUNCTION__, stationinfo);
        pp2 = popen(stationinfo, "r"); //ܵ
        
        if(NULL == pp2)    
        {        
            continue;
        } 
        memset(buf, 0, sizeof(buf)); 
        strcpy(buf,"ABNORMAL");
        while(fgets(buf, sizeof(buf), pp2))
        {

            if(strcmp(buf,"ABNORMAL")==0)  /*ps command error*/  
            {
                printf("[%s] detect_process strerror: %s\n",__FUNCTION__,strerror(errno));
       
                pclose(pp2);//رչܵ
                return ; 
            }
            memset(mac_time,0,33);
            strncpy(mac_time,buf,32);
           
            printf("[%s:%s]buf0:%s\n",__FILE__, __FUNCTION__, buf);
           
            if(NULL != mac_time)
            {
                sta_list->Entry[i].ConnectedTime = atol(mac_time);
                printf("[%s:%s]ConnectedTime->Num3:%d\n",__FILE__, __FUNCTION__, sta_list->Entry[i].ConnectedTime);
            }
            else
            {
                sta_list->Entry[i].ConnectedTime = 0;
            }
            memset(buf, 0, sizeof(buf));  
            printf("[%s:%s]mac_time:%d\n",__FILE__, __FUNCTION__, mac_time);
            
        }
        
      pclose(pp2); //رչܵ
    }
    
    (*staionlist)= (*sta_list);
    if(sta_list) 
    {
        free(sta_list); 
        sta_list=NULL;
    }
    
}

static void wlan_set_change_ssid_key_status()
{
	ipc_send_message(MODULE_ID_WLAN_SERVER, MODULE_ID_WIFI, MSG_CMD_MODIFY_SSID_KEY, 0, NULL, 0);
}

static int zte_wlan_ssid1_basic_set(char* ssid_in)
{
    char  *ssid = NULL; 
	char nv_tmp[WIFI_SSID_LEN] = {0};
	
	if(NULL == ssid_in)
	{
		printf("input ssid is null\n");
		return -1;
	}

	if((!strcmp(ssid_in, " ")) || (strlen(ssid_in) <= 0) || (strlen(ssid_in) > WIFI_SSID_LEN ))
	{
		printf("input ssid is error\n");
		return -1;
	}
    //ssid
    memset(nv_tmp,0,sizeof(nv_tmp));
    if(ssid_in != NULL)
    {  
       
       sc_cfg_get("SSID1",nv_tmp,sizeof(nv_tmp));
        if (0 != strcmp(ssid_in, nv_tmp))
        {
            sc_cfg_set("SSID1", ssid_in);
			//sc_cfg_save();
			wlan_set_change_ssid_key_status();
        }
		else
		{
			printf("input ssid is same \n");
			return 1;
		}
    }
    return 0;
}

static int zte_wlan_ssid1_security_set(char* password)
{	
    char authMode[WLAN_SECURITY_LEN]      = {0};
    char encrypType[WLAN_ENCRYTYPE_LEN]   = {0};
	char DefaultKeyID[WLAN_DEFAULTID_LEN] = {0};
   
	sc_cfg_get("AuthMode",authMode,sizeof(authMode));
	sc_cfg_get("EncrypType",encrypType,sizeof(encrypType));

	
    if(authMode != NULL && encrypType != NULL)
    {  
        printf("wlan_ssid1_security_set authMode = [%s]\n", authMode);
		printf("wlan_ssid1_security_set encrypType = [%s]\n", encrypType);   
		if(NULL == password && (!(!strcmp(authMode, WF_AU_OPEN) && !strcmp(encrypType, WF_ENCRY_NONE))))
		{
			printf("wlan_ssid1_security_set password is null\n");
			return -1;
		}
		
        if((!strcmp(authMode, WF_AU_OPEN))  || (!strcmp(authMode, WF_AU_SHARE)) ||  (!strcmp(authMode, WF_AU_WEPAUTO)))
        {   
            if(((!strcmp(authMode, WF_AU_OPEN)) && (!strcmp(authMode, WF_ENCRY_WEP))) ||
            	 (!strcmp(authMode, WF_AU_SHARE)) || (!strcmp(authMode, WF_AU_WEPAUTO))) 
            {
			    int len = 0;
				len = strlen(password);
				if(len != 5 || len != 10 || len != 13 || len != 26)
				{
					printf("wlan_ssid1_security_set wep psk len = [%s]\n", len);  
					return -1;
				}
				
				sc_cfg_get("DefaultKeyID",DefaultKeyID,sizeof(DefaultKeyID));
                if(DefaultKeyID != NULL)
				{
					char old_wep_key[WLAN_WEPKEY_LEN] = {0};
					
					if(!strcmp(DefaultKeyID, "1"))
					{
						sc_cfg_get("Key2Str1",old_wep_key,sizeof(old_wep_key));
						if(strcmp(old_wep_key, password))
						{
							sc_cfg_set("Key2Str1", password);
							//sc_cfg_save();
							wlan_set_change_ssid_key_status();
						}
						else
						{
							printf("wlan_ssid1_security_set wep psk is same\n");  
							return 1;
						}
					}
					else if(!strcmp(DefaultKeyID, "2"))
					{
						sc_cfg_get("Key3Str1",old_wep_key,sizeof(old_wep_key));
						if(strcmp(old_wep_key, password))
						{
							sc_cfg_set("Key3Str1", password);
							//sc_cfg_save();
							wlan_set_change_ssid_key_status();
						}
						else
						{
							printf("wlan_ssid1_security_set wep psk is same\n");  
							return 1;
						}
					}
					else if(!strcmp(DefaultKeyID, "3"))
					{
						sc_cfg_get("Key4Str1",old_wep_key,sizeof(old_wep_key));
						if(strcmp(old_wep_key, password))
						{
							sc_cfg_set("Key4Str1", password);
							//sc_cfg_save();
							wlan_set_change_ssid_key_status();
						}
						else
						{
							printf("wlan_ssid1_security_set wep psk is same\n");  
							return 1;
						}
					}
					else 
					{
						sc_cfg_get("Key1Str1",old_wep_key,sizeof(old_wep_key));
						if(strcmp(old_wep_key, password))
						{
							sc_cfg_set("Key1Str1", password);
							//sc_cfg_save();
							wlan_set_change_ssid_key_status();
						}
						else
						{
							printf("wlan_ssid1_security_set wep psk is same\n");  
							return 1;
						}
					}
				}
            }
            else if(!strcmp(authMode, WF_AU_OPEN) && !strcmp(encrypType, WF_ENCRY_NONE))
            {
                printf("authMode is open and not wep \n");
				wlan_set_change_ssid_key_status();
				return 1;

            }
        }
        else if(!strcmp(authMode, WF_AU_WPA)  || !strcmp(authMode, WF_AU_WPA2) || !strcmp(authMode,  WF_AU_WPA_WPA2))
        {
			char psk[WLAN_PSK_LEN]                = {0};
            int len = 0;
			char encode[WLAN_ENCODE_PSK_LEN] = {0};
			len = strlen(password);
			
			if(len < 8 || len > 64)
			{
				printf("%s password len is %d \n",authMode, len);
				return -1;
			}
			
			sc_cfg_get("WPAPSK1",psk,sizeof(psk));
			if(psk != NULL)
			{
				if(strcmp(psk, password))
				{
					sc_cfg_set("WPAPSK1", password);
					base64_encode(password, len, encode, WLAN_ENCODE_PSK_LEN);
					sc_cfg_set("WPAPSK1_encode", encode);
					//sc_cfg_save();
					wlan_set_change_ssid_key_status();
				}
			}
            else
			{
				sc_cfg_set("WPAPSK1", password);
				base64_encode(password, len, encode, WLAN_ENCODE_PSK_LEN);
				sc_cfg_set("WPAPSK1_encode", encode);
				//sc_cfg_save();
				wlan_set_change_ssid_key_status();
			}
        }
		else if(!strcmp(authMode, WF_AU_WAPIPSK))
		{
			char psk[WLAN_PSK_LEN]                = {0};
			int len = 0;
			char encode[WLAN_PSK_LEN] = {0};
			len = strlen(password);
			
			if(len < 8 || len > 64)
			{
				printf("WF_AU_WAPIPSK password len is %d \n", len);
				return -1;
			}
			
			sc_cfg_get("WPAPSK1",psk,sizeof(psk));
			if(psk != NULL)
			{
				if(strcmp(psk, password))
				{
					sc_cfg_set("WPAPSK1", password);
					base64_encode(password, len, encode, WLAN_ENCODE_PSK_LEN);
					sc_cfg_set("WPAPSK1_encode", encode);
					//sc_cfg_save();
					wlan_set_change_ssid_key_status();
				}
			}
            else
			{
				sc_cfg_set("WPAPSK1", password);
				base64_encode(password, len, encode, WLAN_ENCODE_PSK_LEN);
				sc_cfg_set("WPAPSK1_encode", encode);
				//sc_cfg_save();
				wlan_set_change_ssid_key_status();
			}
		}
        else
        {
            // other security mode is invalid
            printf("ERROR:security mode  is invalid\n");
            return -1;
        }
    }
    else
    {
        //security_mode is NULL
        printf("ERROR:security_mode is null\n");
        return -1;
    }

    return 0;
}

int zte_wlan_get_ssid1_settings(char* ssid, char* password, int ssid_len, int password_len)
{
	char authMode[WLAN_SECURITY_LEN]      = {0};
    char encrypType[WLAN_ENCRYTYPE_LEN]   = {0};
	char DefaultKeyID[WLAN_DEFAULTID_LEN] = {0};

	if(NULL == ssid || NULL == password)
	{
		printf("ERROR:input ssid && password is null\n");
		return -1;
	}
	
	if(NULL != ssid)
	{
		char old_ssid[WIFI_SSID_LEN] = {0};
		sc_cfg_get("SSID1",old_ssid,sizeof(old_ssid));
		if(old_ssid != NULL)
		{
			strncpy(ssid, old_ssid, ssid_len - 1);
		}
		else
		{
			printf("ERROR:input old_ssid is null\n");
			return -1;
		}
	}
	
	if(NULL != password)
	{		
		sc_cfg_get("AuthMode",authMode,sizeof(authMode));
		sc_cfg_get("EncrypType",encrypType,sizeof(encrypType));

		
		if(authMode != NULL && encrypType != NULL)
		{  
			printf("wlan_ssid1_security_get authMode = [%s]\n", authMode);   
			printf("wlan_ssid1_security_get encrypType = [%s]\n", encrypType);   

			if((!strcmp(authMode, WF_AU_OPEN))  || (!strcmp(authMode, WF_AU_SHARE)) ||  (!strcmp(authMode, WF_AU_WEPAUTO)))
			{   
				if(((!strcmp(authMode, WF_AU_OPEN)) && (!strcmp(authMode, WF_ENCRY_WEP))) ||
					(!strcmp(authMode, WF_AU_SHARE)) || (!strcmp(authMode, WF_AU_WEPAUTO))) 
				{
					sc_cfg_get("DefaultKeyID",DefaultKeyID,sizeof(DefaultKeyID));
					if(DefaultKeyID != NULL)
					{
						char old_wep_key[WLAN_WEPKEY_LEN] = {0};
						if(!strcmp(DefaultKeyID, "1"))
						{
							sc_cfg_get("Key2Str1",old_wep_key,sizeof(old_wep_key));
							if(old_wep_key != NULL)
							{
								strncpy(password, old_wep_key, password_len-1);
							}
							else
							{
								printf("ERROR:input old_wep_key is null\n");
								return -1;
							}
						}
						else if(!strcmp(DefaultKeyID, "2"))
						{
							sc_cfg_get("Key3Str1",old_wep_key,sizeof(old_wep_key));
							if(old_wep_key != NULL)
							{
								strncpy(password, old_wep_key, password_len-1);
							}
							else
							{
								printf("ERROR:input old_wep_key is null\n");
								return -1;
							}
						}
						else if(!strcmp(DefaultKeyID, "3"))
						{
							sc_cfg_get("Key4Str1",old_wep_key,sizeof(old_wep_key));
							if(old_wep_key != NULL)
							{
								strncpy(password, old_wep_key, password_len-1);
							}
							else
							{
								printf("ERROR:input old_wep_key is null\n");
								return -1;
							}
						}
						else 
						{
							sc_cfg_get("Key1Str1",old_wep_key,sizeof(old_wep_key));
							if(old_wep_key != NULL)
							{
								strncpy(password, old_wep_key, password_len-1);
							}
							else
							{
								printf("ERROR:input old_wep_key is null\n");
								return -1;
							}
						}
					}
				}
            }
			else if(!strcmp(authMode, WF_AU_WPA)  || !strcmp(authMode, WF_AU_WPA2) || !strcmp(authMode,  WF_AU_WPA_WPA2))
			{
				char psk[WLAN_PSK_LEN] = {0};
				sc_cfg_get("WPAPSK1",psk,sizeof(psk));
				if(psk != NULL)
				{
					strncpy(password, psk, password_len-1);
				}
				else
				{
					printf("ERROR:%s input psk is null\n", authMode);
					return -1;
				}
			}
			else if(!strcmp(authMode, WF_AU_WAPIPSK))
			{
				char psk[WLAN_PSK_LEN]                = {0};
				sc_cfg_get("WPAPSK1",psk,sizeof(psk));
				if(psk != NULL)
				{
					strncpy(password, psk, password_len-1);
				}
				else
				{
					printf("ERROR:%s input psk is null\n", authMode);
					return -1;
				}
			}
			else
			{
				return -1;
			}
		}
		else
		{
			return -1;
		}
    }
	return 0;
}

int zte_wlan_ssid1_set(char* ssid, char* password)
{
	int ret_for_basic = 0;
	int ret_for_security = 0;
	
	ret_for_basic = zte_wlan_ssid1_basic_set(ssid);
    if(-1 == ret_for_basic)
    {
        printf("wlan_ssid1_basic_set is false\n");
        return -1;
    }
	ret_for_security = zte_wlan_ssid1_security_set(password);
    if(-1 == ret_for_security)
    {
        printf("call lan_ssid1_security_set failure .\n");   
        return -1;
    }
	
    if(ret_for_basic == 0 || ret_for_security == 0)
	{
		if(0 == ipc_send_message(MODULE_ID_WLAN_SERVER, MODULE_ID_WIFI, MSG_CMD_WIFI_ADVANCED, 2, "1", 0))
		{ 
			sc_cfg_set("RadioOff", "0");
			printf("wifi set cmd done!\n");
		}
		else
		{
			printf("wifi set cmd wlan_ssid1_set error!\n");
			return -1;
		}
    }
    return 0; 
}


int zte_wlan_capture_sta_num()
{
    int total_station_num = 0;
    FILE *pp = NULL;
    char *tmp = NULL;
    char buf[128]={0};
    char authmode[20]={0};
	char radio_off[20] = {0};
    char wifi_sta_connection[8]={0};
    char cmd[128]={0};
    char iifname[16]={0};
	
    sc_cfg_get("RadioOff",radio_off,sizeof(radio_off));
    sc_cfg_get("wifi_sta_connection", wifi_sta_connection, sizeof(wifi_sta_connection));
    sc_cfg_get("AuthMode",authmode, 20);
	
	if (!strncmp(radio_off, "0", 1))
	{
	    printf("[wlan-interface]ap-service stopped! return!\n");
	    return 0;
	}
    
    if(strncmp(wifi_sta_connection, "1",1) == 0)
	{
		strcpy(iifname,"-i wl0.1");
	}
    else
	{
		strcpy(iifname,"-i wlan0");
	}

    if((!strcmp(authmode,"WPAPSK"))||(!strcmp(authmode,"WPA2PSK"))||(!strcmp(authmode,"WPAPSKWPA2PSK")))
	{
		sprintf(cmd, "wl %s autho_sta_list", iifname);
		sprintf(cmd, "wl %s autho_sta_list", iifname);
	}
	else
	{
		sprintf(cmd, "wl %s  assoclist", iifname);
	}

    if ( cmd == NULL )
	{
	    printf("[wlan-interface]error!! cmd is NULL!!\n");
	    return 0;
	}

    pp = popen(cmd, "r"); //pipe starts
    if (!pp)
    {
        printf("[wlan-interface]error!! create pipe failed!!\n");
        return 0;
    }

    strcpy(buf,"ABNORMAL");
    
Again:
    while(fgets(buf, 128, pp) != NULL)   
	{      
        if(strcmp(buf,"ABNORMAL")==0)  //fgets error 
        {
            printf("[wlan-interface]error!! [%s] strerror: %s\n",__FUNCTION__,strerror(errno));
            if(errno == EINTR) //Interrupted system call,try again
            {
                goto Again;
            }
            
            pclose(pp);//close pipe
            return 0; 
        }

        if(strlen(buf) > 0)
        {
		    if((tmp = strstr(buf, ":")) != NULL)            
		    {                
		      total_station_num += 1;            
		    }  
        }
        memset(buf,0,128);
        strcpy(buf,"ABNORMAL");
        	 		
	}    
	
    pclose(pp);//close pipe
    printf("[wlan-interface] total_station_num=%d\n",total_station_num);
    return total_station_num;
}


void zte_get_wifi_sta_list(RT_802_11_MAC_TABLE *staList)
{
  
         int i = 0;
	char station_mac[18*32]={0}; // 00:00:00:00:00:00;
	char station_mac_tmp[18*32]={0};
	char tmp_str[10] = {0};

       if(NULL == staList)
    {
        return;
    }
    zte_wlan_get_wifi_station_list(staList);
	
    printf("[%s:%s]staList->Num1:%d\n",__FILE__, __FUNCTION__, staList->Num);
    printf("[%s:%s]staList->ConnectedTime:%d\n",__FILE__, __FUNCTION__, staList->Entry[0].ConnectedTime);

    sprintf(tmp_str, "%d", staList->Num);	
	sc_cfg_set("wificount", tmp_str);
	sc_cfg_set("station_num", tmp_str);
    for(i=0; i<staList->Num; i++)
    {
        sprintf(station_mac + i * 18, "%2.2X:%2.2X:%2.2X:%2.2X:%2.2X:%2.2X;",\
	   	           staList->Entry[i].Addr[0], staList->Entry[i].Addr[1],
				    staList->Entry[i].Addr[2], staList->Entry[i].Addr[3],
				    staList->Entry[i].Addr[4], staList->Entry[i].Addr[5]);
    }
	if(staList->Num != 0)
	{
		strncpy(station_mac_tmp, station_mac, strlen(station_mac) - 1);
	}
	
	sc_cfg_set("station_mac", station_mac_tmp);   
	
}

#if 0 //kw 3
int get_channel()
{
	char channel[8]={0};
	pipecmd("wl channel | grep mac |cut -f2", channel);
	return atoi(channel);
}
#endif
