/* * Copyright (c) 2011 Qualcomm Atheros, Inc. * */

#include <linux/in.h>
#include <linux/ip.h>
#include <linux/udp.h>
#include <linux/tcp.h>
#include <linux/icmp.h>
#include <net/ip.h>
#include <linux/if_arp.h>

#include <linux/inetdevice.h>
#include <linux/netfilter.h>
#include <linux/netfilter_ipv4.h>
#include <linux/netfilter_arp.h>
#include <linux/netfilter_ipv4/ip_tables.h>
#include <linux/netfilter/xt_multiport.h>
#include <linux/netfilter/xt_iprange.h>
#include <linux/netfilter/nf_conntrack_tcp.h>
#include <net/checksum.h>
#include <net/dsfield.h>
#include <net/route.h>
#include <net/netfilter/nf_nat.h>
#include <net/netfilter/nf_nat_core.h>
#include <net/netfilter/nf_nat_rule.h>
#include <net/netfilter/nf_conntrack_helper.h>
#include <linux/module.h>

#include <linux/proc_fs.h>

#include <net/SI/fast_common.h>

#include <net/netfilter/nf_conntrack_l4proto.h>

#include <net/netfilter/nf_conntrack.h>
#include <net/netfilter/nf_conntrack_l3proto.h>
#include <net/netfilter/nf_conntrack_l4proto.h>
#include <net/netfilter/nf_conntrack_expect.h>
#include <net/netfilter/nf_conntrack_helper.h>
#include <net/netfilter/nf_conntrack_core.h>
#include <net/netfilter/nf_conntrack_extend.h>
#include <net/netfilter/nf_conntrack_acct.h>
#include <net/netfilter/nf_conntrack_ecache.h>
#include <net/netfilter/nf_conntrack_zones.h>
#include <net/netfilter/nf_conntrack_timestamp.h>
#include <net/netfilter/nf_conntrack_timeout.h>
#include <net/netfilter/nf_nat.h>
#include <net/netfilter/nf_nat_core.h>

MODULE_LICENSE("GPL");

/* ************************** תõı ************************** */
struct kmem_cache *fast_head_cache;

spinlock_t fast_fw_spinlock;             //ת໥
spinlock_t fastlocal_spinlock;           //໥    

spinlock_t fast_del_spinlock;
fast_list_t fast_del_list = {0};

struct sk_buff_head fast_txq;
struct tasklet_struct fast_tx_bh;

/* 
* 0: رfastnat߱׼linuxжԭ
* 1: IP׼fasnatжϵȣԲع
* 2: net_deviceж
* 5: رfastnat߱׼linuxԭӲ
* ͨproc޸ֵ
*/
int fastnat_level = FAST_NET_DEVICE;

/* λͼʽ  --- ӹܿתأοfast_common.hж*/
#ifndef CONFIG_PREEMPT_RT_FULL
unsigned long fast_switch = 0x67;
#else
unsigned long fast_switch = 0x0;
#endif
/* ************************  תر ************************ */
int fastbr_level = 1;                 //Ƿfastbr

/* **************************** ƽ̨ر **************************** */
/*
 *br_nameȼַͨprocڵã
 *˴Ƕ͸ֵ
 */
char br_name[MAX_NET_DEVICE_NAME_LEN + 1] = "br0";
char ps_name[MAX_NET_DEVICE_NAME_LEN + 1] = "wan1";
char usb_name[MAX_NET_DEVICE_NAME_LEN + 1] = "usblan0";
char ppp_name[MAX_NET_DEVICE_NAME_LEN + 1] = "ppp";
//cp:ˣģ̬Ҫ·ɶ
//ap:˫ˣģ̬ɼŽ
char need_jilian[MAX_NET_DEVICE_NAME_LEN + 1] = "0";

//ȼãֻ׼ǸɵӰ
int  fast_br_level = 1;
int  fast_fwd_level = 2;
int  fast_local_level = 0;
unsigned char zeromac[ETH_ALEN] = "";

/* ں·״̬ȵıӿ壬ںˣֲںʱҪ*/
#define sNO TCP_CONNTRACK_NONE
#define sSS TCP_CONNTRACK_SYN_SENT
#define sSR TCP_CONNTRACK_SYN_RECV
#define sES TCP_CONNTRACK_ESTABLISHED
#define sFW TCP_CONNTRACK_FIN_WAIT
#define sCW TCP_CONNTRACK_CLOSE_WAIT
#define sLA TCP_CONNTRACK_LAST_ACK
#define sTW TCP_CONNTRACK_TIME_WAIT
#define sCL TCP_CONNTRACK_CLOSE
#define sS2 TCP_CONNTRACK_SYN_SENT2
#define sIV TCP_CONNTRACK_MAX
#define sIG TCP_CONNTRACK_IGNORE

	

/* What TCP flags are set from RST/SYN/FIN/ACK. */
enum tcp_bit_set {
    TCP_SYN_SET,
    TCP_SYNACK_SET,
    TCP_FIN_SET,
    TCP_ACK_SET,
    TCP_RST_SET,
    TCP_NONE_SET,
};

//nf_conntrack_proto_tcp.c
static const u8 tcp_conntracks[2][6][TCP_CONNTRACK_MAX] = {
{
/* ORIGINAL */
/*          sNO, sSS, sSR, sES, sFW, sCW, sLA, sTW, sCL, sS2    */
/*syn*/       { sSS, sSS, sIG, sIG, sIG, sIG, sIG, sSS, sSS, sS2 },
/*
 *    sNO -> sSS    Initialize a new connection
 *    sSS -> sSS    Retransmitted SYN
 *    sS2 -> sS2    Late retransmitted SYN
 *    sSR -> sIG
 *    sES -> sIG    Error: SYNs in window outside the SYN_SENT state
 *            are errors. Receiver will reply with RST
 *            and close the connection.
 *            Or we are not in sync and hold a dead connection.
 *    sFW -> sIG
 *    sCW -> sIG
 *    sLA -> sIG
 *    sTW -> sSS    Reopened connection (RFC 1122).
 *    sCL -> sSS
 */
/*          sNO, sSS, sSR, sES, sFW, sCW, sLA, sTW, sCL, sS2    */
/*synack*/ { sIV, sIV, sSR, sIV, sIV, sIV, sIV, sIV, sIV, sSR },
/*
 *    sNO -> sIV    Too late and no reason to do anything
 *    sSS -> sIV    Client can't send SYN and then SYN/ACK
 *    sS2 -> sSR    SYN/ACK sent to SYN2 in simultaneous open
 *    sSR -> sSR    Late retransmitted SYN/ACK in simultaneous open
 *    sES -> sIV    Invalid SYN/ACK packets sent by the client
 *    sFW -> sIV
 *    sCW -> sIV
 *    sLA -> sIV
 *    sTW -> sIV
 *    sCL -> sIV
 */
/*          sNO, sSS, sSR, sES, sFW, sCW, sLA, sTW, sCL, sS2    */
/*fin*/    { sIV, sIV, sFW, sFW, sLA, sLA, sLA, sTW, sCL, sIV },
/*
 *    sNO -> sIV    Too late and no reason to do anything...
 *    sSS -> sIV    Client migth not send FIN in this state:
 *            we enforce waiting for a SYN/ACK reply first.
 *    sS2 -> sIV
 *    sSR -> sFW    Close started.
 *    sES -> sFW
 *    sFW -> sLA    FIN seen in both directions, waiting for
 *            the last ACK.
 *            Migth be a retransmitted FIN as well...
 *    sCW -> sLA
 *    sLA -> sLA    Retransmitted FIN. Remain in the same state.
 *    sTW -> sTW
 *    sCL -> sCL
 */
/*          sNO, sSS, sSR, sES, sFW, sCW, sLA, sTW, sCL, sS2    */
/*ack*/       { sES, sIV, sES, sES, sCW, sCW, sTW, sTW, sCL, sIV },
/*
 *    sNO -> sES    Assumed.
 *    sSS -> sIV    ACK is invalid: we haven't seen a SYN/ACK yet.
 *    sS2 -> sIV
 *    sSR -> sES    Established state is reached.
 *    sES -> sES    :-)
 *    sFW -> sCW    Normal close request answered by ACK.
 *    sCW -> sCW
 *    sLA -> sTW    Last ACK detected.
 *    sTW -> sTW    Retransmitted last ACK. Remain in the same state.
 *    sCL -> sCL
 */
/*          sNO, sSS, sSR, sES, sFW, sCW, sLA, sTW, sCL, sS2    */
/*rst*/    { sIV, sCL, sCL, sCL, sCL, sCL, sCL, sCL, sCL, sCL },
/*none*/   { sIV, sIV, sIV, sIV, sIV, sIV, sIV, sIV, sIV, sIV }
    },
    {
/* REPLY */
/*          sNO, sSS, sSR, sES, sFW, sCW, sLA, sTW, sCL, sS2    */
/*syn*/       { sIV, sS2, sIV, sIV, sIV, sIV, sIV, sIV, sIV, sS2 },
/*
 *    sNO -> sIV    Never reached.
 *    sSS -> sS2    Simultaneous open
 *    sS2 -> sS2    Retransmitted simultaneous SYN
 *    sSR -> sIV    Invalid SYN packets sent by the server
 *    sES -> sIV
 *    sFW -> sIV
 *    sCW -> sIV
 *    sLA -> sIV
 *    sTW -> sIV    Reopened connection, but server may not do it.
 *    sCL -> sIV
 */
/*          sNO, sSS, sSR, sES, sFW, sCW, sLA, sTW, sCL, sS2    */
/*synack*/ { sIV, sSR, sIG, sIG, sIG, sIG, sIG, sIG, sIG, sSR },
/*
 *    sSS -> sSR    Standard open.
 *    sS2 -> sSR    Simultaneous open
 *    sSR -> sIG    Retransmitted SYN/ACK, ignore it.
 *    sES -> sIG    Late retransmitted SYN/ACK?
 *    sFW -> sIG    Might be SYN/ACK answering ignored SYN
 *    sCW -> sIG
 *    sLA -> sIG
 *    sTW -> sIG
 *    sCL -> sIG
 */
/*          sNO, sSS, sSR, sES, sFW, sCW, sLA, sTW, sCL, sS2    */
/*fin*/    { sIV, sIV, sFW, sFW, sLA, sLA, sLA, sTW, sCL, sIV },
/*
 *    sSS -> sIV    Server might not send FIN in this state.
 *    sS2 -> sIV
 *    sSR -> sFW    Close started.
 *    sES -> sFW
 *    sFW -> sLA    FIN seen in both directions.
 *    sCW -> sLA
 *    sLA -> sLA    Retransmitted FIN.
 *    sTW -> sTW
 *    sCL -> sCL
 */
/*          sNO, sSS, sSR, sES, sFW, sCW, sLA, sTW, sCL, sS2    */
/*ack*/       { sIV, sIG, sSR, sES, sCW, sCW, sTW, sTW, sCL, sIG },
/*
 *    sSS -> sIG    Might be a half-open connection.
 *    sS2 -> sIG
 *    sSR -> sSR    Might answer late resent SYN.
 *    sES -> sES    :-)
 *    sFW -> sCW    Normal close request answered by ACK.
 *    sCW -> sCW
 *    sLA -> sTW    Last ACK detected.
 *    sTW -> sTW    Retransmitted last ACK.
 *    sCL -> sCL
 */
/*          sNO, sSS, sSR, sES, sFW, sCW, sLA, sTW, sCL, sS2    */
/*rst*/    { sIV, sCL, sCL, sCL, sCL, sCL, sCL, sCL, sCL, sCL },
/*none*/   { sIV, sIV, sIV, sIV, sIV, sIV, sIV, sIV, sIV, sIV }
    }
};

#define SECS * HZ
#define MINS * 60 SECS
#define HOURS * 60 MINS
#define DAYS * 24 HOURS

//nf_conntrack_proto_tcp.c
unsigned int tcp_timeouts[TCP_CONNTRACK_TIMEOUT_MAX] __read_mostly = {
    [TCP_CONNTRACK_SYN_SENT]    = 2 MINS,
    [TCP_CONNTRACK_SYN_RECV]    = 5 MINS, //60 SECS,
    [TCP_CONNTRACK_ESTABLISHED]    = 2 HOURS, //5 DAYS
    [TCP_CONNTRACK_FIN_WAIT]    = 2 MINS,
    [TCP_CONNTRACK_CLOSE_WAIT]    = 60 SECS,
    [TCP_CONNTRACK_LAST_ACK]    = 30 SECS,
    [TCP_CONNTRACK_TIME_WAIT]    = 2 MINS,
    [TCP_CONNTRACK_CLOSE]        = 120 SECS, /*normal is 10SEC*/
    [TCP_CONNTRACK_SYN_SENT2]    = 2 MINS,
/* RFC1122 says the R2 limit should be at least 100 seconds.
   Linux uses 15 packets as limit, which corresponds
   to ~13-30min depending on RTO. */
    //[TCP_CONNTRACK_MAX]    = 2 MINS,
    //[TCP_CONNTRACK_IGNORE]    = 2 MINS,
    [TCP_CONNTRACK_RETRANS]    = 5 MINS,
    [TCP_CONNTRACK_UNACK]      = 5 MINS,
};

unsigned int fast_udp_timeout_stream = 180*HZ; 
unsigned int fast_udp_timeout = 120*HZ; /*normal is 30*HZ*/

//֧fastnatЭ 
//ʹãĳͨproc̬뵽nofast_protoʱʱ䣬ÿ˽ӦĶ˿Э
unsigned int nofast_port[NOFAST_PROTO_MAX] = {
    21,      // FTP˿ڣʱļЭ (FSP)ʹ
    22,      // ssh ȫShell(SSH)
    23,      // telnet Telnet 
    25,      // smtp ʼЭ(SMTP)
    53,      // domain ( BIND) 
    67,      // serverdhcp˿
    68,      // clientdhcp˿
    69,      // tftp СļЭ(TFTP)
    110,     // ʾЭ汾3 
    115,     // sftp ȫļЭ(SFTP)
    123,     // ntp ʱЭ(NTP)
    443,     // https ȫıЭ(HTTP) 
    500,     // isakmp ȫԿ׹Э(ISAKMP) 
    1352,    // Lotus Notes 
    1723,    // PPTP TCP 
    1990,    // stun-p1 cisco STUN Priority 1 port
    1991,    // stun-p2 cisco STUN Priority 2 port
    1992,    // stun-p3 cisco STUN Priority 3 port,ipsendmsg IPsendmsg
    1993,    // snmp-tcp-port cisco SNMP TCP port
    1994,    // stun-port cisco serial tunnel portTCP
    1995,    // perf-port cisco perf portTCP 
    1996,    // tr-rsrb-port cisco Remote SRB portTCP 
    1997,    // gdp-port Cisco طЭ(GDP) 
    1998,    // x25-svc-port cisco X.25 service 
    4500,    // NAT-T UDP
    5060     // ˿ڶ˿:5060/udp:SessionInitiationProtocol(SIPػЭ)
};

/* *******************************  ******************************* */
int (*fast_nat4_proc)(struct sk_buff *skb);
int (*fast_nat6_proc)(struct sk_buff *skb);
int (*fast_fw4_proc)(struct nf_conn *tmpl, 
    struct sk_buff *skb, 
    struct nf_conn *ct, 
    struct nf_conntrack_l4proto *l4proto,
    unsigned int dataoff,
    int dir,
    u_int8_t protonum);
int (*fast_fw6_proc)(struct nf_conn *tmpl, 
    struct sk_buff *skb, 
    struct nf_conn *ct, 
    struct nf_conntrack_l4proto *l4proto,
    unsigned int dataoff,
    int dir,
    u_int8_t protonum);

int (*fast_local4_proc)(struct nf_conn *tmpl, 
    struct sk_buff *skb, 
    struct nf_conn *ct, 
    struct nf_conntrack_l4proto *l4proto,
    unsigned int dataoff,
    int dir,
    u_int8_t protonum);
int (*fast_local6_proc)(struct nf_conn *tmpl, 
    struct sk_buff *skb, 
    struct nf_conn *ct, 
    struct nf_conntrack_l4proto *l4proto,
    unsigned int dataoff,
    int dir,
    u_int8_t protonum);
int (*fast_local4_output_proc)(struct sk_buff *skb);
int (*fast_local6_output_proc)(struct sk_buff *skb);

int (*fast_br_proc)(struct sk_buff *skb);

extern int fast_nat_recv(struct sk_buff *skb);
extern int fast6_recv(struct sk_buff *skb);
extern  int nf_ct_ipv6_skip_exthdr(const struct sk_buff *skb, int start,
				  u8 *nexthdrp, int len);

unsigned long iphdr_err_num =0;
unsigned long ip6hdr_err_num =0;
unsigned long tcphdr_err_num =0;
unsigned long tcp6hdr_err_num =0;
unsigned long ip_lan_dos_num =0;
unsigned long ip6_dos_num =0;



extern int fast4_fw_recv(struct nf_conn *tmpl, 
    struct sk_buff *skb, 
    struct nf_conn *ct, 
    struct nf_conntrack_l4proto *l4proto,
    unsigned int dataoff,
    int dir,
    u_int8_t protonum);
extern int fast6_fw_recv(struct nf_conn *tmpl, 
    struct sk_buff *skb, 
    struct nf_conn *ct, 
    struct nf_conntrack_l4proto *l4proto,
    unsigned int dataoff,
    int dir,
    u_int8_t protonum);

extern int fast_br(struct sk_buff *skb);
extern struct net_device *getbrport_bydst(struct net_device *dev,unsigned char *dest);

extern int (*fast_from_softirq) (struct sk_buff *skb);
extern int (*fast_from_driver)(struct sk_buff *skb, struct net_device* dev);

extern void fastnat_cleanup_links(void);
extern void fast6_cleanup_links(void);

extern fast_entry_t *cur_timeout_entry;
extern int tcpack_timeout(fast_entry_t *entry, unsigned long *next_schedule, int *set_next);
extern int tcpack_rel(fast_entry_t *entry);

extern int tsp_fastnat_init(void);
extern int tsp_fastnat_cleanup(void);

extern int fast4_fw_init(void);
extern int fast6_fw_init(void);

extern int fast4_fw_cleanup(void);
extern int fast6_fw_cleanup(void);

extern int tsp_fast6_init(void);
extern int tsp_fast6_cleanup(void);

extern int fastnat_event(traverse_command_t *cmd);
extern int fast6_event(traverse_command_t *cmd);

//תprocļĳʼ
extern int fast_conntrack_init_proc(void );

//ںƽ̨procļĳʼ
extern int net_adapter_init_proc(void );

unsigned int (*tsp_mirror_handle)(struct sk_buff *skb);

extern void net_dbg_perf_dev_recv(char * packet_addr,char* node_str);
extern void net_dbg_perf_clear_last_item(struct sk_buff *skb);
/* ******************************* ʵ ******************************* */
#if _USE_VEHICLE_DC
static void fast_entry_unlink_cap(fast_entry_t *entry){
	if(entry->fwd_entry){
		WARN_ON(entry->fwd_entry->fwd_entry != entry);
		entry->fwd_entry->fwd_entry = NULL;
		entry->fwd_entry = NULL;
	}
	entry->ct->fast_entry = NULL;
}
#endif
static void fast_bh (unsigned long param)
{
	struct sk_buff_head *txq = (struct sk_buff_head *)param;
	struct sk_buff *skb = (txq ? skb_dequeue(txq) : NULL);

	while(skb != NULL) {
		dev_queue_xmit(skb);
		skb = skb_dequeue(txq);
	}
}

static int fast_iphdr_check(struct sk_buff *skb, int proto)
{
	const struct iphdr *iph;
	const struct ipv6hdr *ip6h;
	u32 len;
	
	if (proto == ETH_P_IP)
	{
		iph = ip_hdr(skb);

		if (iph->ihl < 5 || iph->version != 4)
			return 0;
		
		len = ntohs(iph->tot_len);
		if (skb->len < len) {
			return 0;
		} 
		if (len < (iph->ihl*4))
			return 0;
	}
	else if(proto == ETH_P_IPV6)
	{
		ip6h = ipv6_hdr(skb);
		if (ip6h->version != 6)
			return 0;
		
		len = ntohs(ip6h->payload_len);
		if (len || ip6h->nexthdr != NEXTHDR_HOP) {
			if (len + sizeof(struct ipv6hdr) > skb->len) {
				return 0;
			}
		}
	
	}

	return 1;
}
static int fast_tcphdr_check(struct sk_buff *skb, int proto)
{
	const struct iphdr *iph = NULL;
	const struct ipv6hdr *ip6h = NULL;
      struct tcphdr *tcph = NULL;
	unsigned int iphdr_len = 0;
	unsigned int ip6hdr_len = 0;
	unsigned int tcphdr_len = 0;
	unsigned char *l4head = NULL;
	__u8 protonum;
	int extoff = 0;
		
	if (proto == ETH_P_IP)
	{
		iph = ip_hdr(skb);
		iphdr_len = iph->ihl * 4;
		tcph = (struct tcphdr *)((unsigned char*)iph + iphdr_len);
		tcphdr_len = sizeof(struct tcphdr);

		if (tcphdr_len > skb->len - iphdr_len)
			return 0;
		
		//tcpͷȺdoffǷƥ
		if (tcph->doff < tcphdr_len/4)
			return 0;

		if (tcph->doff*4 > skb->len - iphdr_len)
			return 0;		
	}
	else if(proto == ETH_P_IPV6)
	{
		ip6h = ipv6_hdr(skb);
		ip6hdr_len = sizeof(struct ipv6hdr);
		tcphdr_len = sizeof(struct tcphdr);

		//οipv6_get_l4protoȡĲЭ
		extoff = skb_network_offset(skb) + ip6hdr_len;
		protonum = 0;
		if (skb_copy_bits(skb, skb_network_offset(skb) + offsetof(struct ipv6hdr, nexthdr),
			  &protonum, sizeof(protonum)) != 0) {
		    printk("fast_tcphdr_check: can't get nexthdr\n");
		    return 0;
		}
		extoff = nf_ct_ipv6_skip_exthdr(skb, extoff, &protonum, skb->len - extoff);

		if(protonum != NEXTHDR_TCP)
			return 1;

		tcph = (struct tcphdr *)((unsigned char*)ip6h + extoff);
		if (tcphdr_len > skb->len - extoff)
			return 0;
		
		//tcpͷȺdoffǷƥ
		if (tcph->doff < tcphdr_len/4)
			return 0;

		if (tcph->doff*4 > skb->len - extoff)
			return 0;	
	}


	return 1;
}
static inline int deliver_skb(struct sk_buff *skb,
                  struct packet_type *pt_prev,
                  struct net_device *orig_dev)
{
    atomic_inc(&skb->users);
    track_add(skb, 0, USER_INFO, 0);
    return pt_prev->func(skb, skb->dev, pt_prev, orig_dev);
}

//˴RAW_PACKET͵socketմԽ__netif_receive_skbץʱݰѱ޸ĵ
void fast_tcpdump(struct sk_buff *skb)
{
    struct packet_type *ptype = NULL;
    
    rcu_read_lock();
    list_for_each_entry_rcu(ptype, &ptype_all, list)
    {
        if (!ptype->dev || ptype->dev == skb->dev)
        {
            skbinfo_add(NULL, SKB_IRQ_FREE);
            deliver_skb(skb, ptype, skb->dev);
        }
    }
    rcu_read_unlock();
}

//οip_finish_output2,skbͷ
struct sk_buff *fast_expand_headroom(struct sk_buff *skb, struct net_device *dev){
    unsigned int hh_len = LL_RESERVED_SPACE(dev);
    struct sk_buff *skb2 = NULL;
    if (unlikely(skb_headroom(skb) < hh_len && dev->header_ops)) {
        skb2 = skb_realloc_headroom(skb, max(hh_len, NET_SKB_PAD));
		if(skb2)
			clean_cache(skb2->data,skb2->len);
        kfree_skb(skb);
        return skb2;
    }
    return skb;
}

//οip6_xmit,skbͷ
struct sk_buff *fast_expand_headroom_v6(struct sk_buff *skb, struct net_device *dev){
    unsigned int hh_len = LL_RESERVED_SPACE(dev);//EC616000622279v6ݰͷռ䲻 + sizeof(struct ipv6hdr);
    struct sk_buff *skb2 = NULL;
    if (unlikely(skb_headroom(skb) < hh_len)) {
        skb2 = skb_realloc_headroom(skb, max(hh_len, NET_SKB_PAD));
		if(skb2)
			clean_cache(skb2->data,skb2->len);
        kfree_skb(skb);
        return skb2;
    }
    return skb;
}


/* ɾһ */
fast_entry_t *fn_list_del(fast_list_t *list_head, fast_entry_t *entry, bool free_entry)
{
    fast_entry_t *ret_entry = NULL, **pprev = NULL;
    
    if (!entry)
    {
        return NULL;
    }

    pprev = &list_head->next;
    for (ret_entry = list_head->next; ret_entry; ret_entry = ret_entry->next)
    {
        if (ret_entry == entry)
        {
            *pprev = ret_entry->next;
            list_head->count--;
            break;
        }
        pprev = &ret_entry->next;
    }
	
	if (free_entry) {
#if _USE_VEHICLE_DC
		cap_conntrack_put(entry->cap_nfct, 1);
#endif
    	//kfree(entry);
#ifdef CONFIG_SLOB_OPT
		kfree(entry);	
#else
		kmem_cache_free(fast_head_cache, entry);	
#endif
	}
	
    netslab_dec(FAST_SLAB);
    return NULL;
}

//ӽڵ
void fn_list_add(fast_list_t *list_head, fast_entry_t *entry)
{
    entry->next = list_head->next;
    list_head->next = entry;
    list_head->count++;
}

//ѯڵڵ
int fn_list_find(fast_list_t *list_head, fast_entry_t *entry)
{
    fast_entry_t *ret_entry = NULL;
    
    if (!entry)
    {
        return 0;
    }

    for (ret_entry = list_head->next; ret_entry; ret_entry = ret_entry->next)
    {
        if (ret_entry == entry)
        {
            return 1;
        }
    }
	return 0;
}

//ѯ
fast_entry_data_t *fast_find_entry_data(const struct hlist_nulls_head *working_hash, const struct nf_conntrack_tuple *tuple)
{
    struct nf_conntrack_tuple_hash *h;
    struct hlist_nulls_node *n;
    unsigned int hash;

    hash = hash_conntrack_fast(tuple);
    //hlist_nulls_for_each_entry(h, n, &working_hash[hash], hnnode) 
    hlist_nulls_for_each_entry_rcu(h, n, &working_hash[hash], hnnode)
    {
        if (nf_ct_tuple_equal(tuple, &h->tuple)) 
        {
            return fast_hash_to_data(h);
        }
    }

    return NULL;
}

//ӽڵ
int fast_add_entry(struct hlist_nulls_head *working_hash, fast_entry_data_t *entry_data)
{
    unsigned int hash;

    if (fast_find_entry_data(working_hash, &entry_data->tuplehash.tuple))
    {
        return 0;
    }
    
    hash = hash_conntrack_fast(&entry_data->tuplehash.tuple);
    hlist_nulls_add_head_rcu(&entry_data->tuplehash.hnnode, &working_hash[hash]);
    //hlist_nulls_add_head(&entry_data->tuplehash.hnnode, &working_hash[hash]);
    //ΪڵǰУdevѾholdסˣԴ˴rcu_read_lock();ⲻ
    dev_hold(entry_data->outdev);

    return 0;
}

static void workinghash_del_node(fast_entry_t *entry)
{
    int i = 0;
    
    for (i = 0; i < IP_CT_DIR_MAX; i++)
    {
        if (entry->flags & (1 << i))
        {
            hlist_nulls_del_rcu(&entry->data[i].tuplehash.hnnode);
            //hlist_nulls_del(&entry->data[i].tuplehash.hnnode);
            dev_put(entry->data[i].outdev);
        }
    }
}

/*ɾ*/
static void fastlist_del_entry(fast_list_t *list_head, fast_entry_t *entry, bool free_entry)
{
    tcpack_rel(entry);
    entry->ct->timeout.function((unsigned long)entry->ct);
    //ct
    nf_ct_put(entry->ct);
#if _USE_VEHICLE_DC
	fast_entry_unlink_cap(entry);
#endif
    fn_list_del(list_head, entry, free_entry);
}

/*fastʱɾ*/
/*jiangjing, ޸ڲΪunsigned long*/
extern spinlock_t fast6_spinlock;
extern spinlock_t fastnat_spinlock;
extern fast_list_t working_list;

void fast_timeout_delentry(spinlock_t *pSpinlock, fast_entry_t *entry)
{
    fast_entry_t *ret_entry = NULL;
    struct fast_list_s *list_head = entry->list_head; 
	spinlock_t *fast_spinlock = entry->fast_spinlock;
	if(fast_spinlock == pSpinlock)
	{
	    spin_lock_bh(fast_spinlock);
	    for (ret_entry = list_head->next; ret_entry; ret_entry = ret_entry->next)
	    {
	        if (ret_entry == entry)
	        {
	            workinghash_del_node(entry);
	            fastlist_del_entry(entry->list_head, entry, false);
				spin_unlock_bh(fast_spinlock);

				//entryV4/V6, ɾlistͳһ¼
				spin_lock_bh(&fast_del_spinlock);
				if (fn_list_find(&fast_del_list, entry) == 1) {
					printk("time out add entry:0x%p already existed\n", entry);
				}
				else {
					entry->list_head = &fast_del_list;
					entry->fast_spinlock = &fast_del_spinlock;
					fn_list_add(&fast_del_list, entry);
					//printk("time out add:%u, entry:0x%x, list:0x%x \n", fast_del_list.count, entry, entry->list_head);
				}
				spin_unlock_bh(&fast_del_spinlock);
	            return;
	        }
	    }
	    spin_unlock_bh(fast_spinlock);
	}
}

extern spinlock_t fast6_spinlock;
extern spinlock_t fastnat_spinlock;

static void fast_timeout(unsigned long data)
{
    fast_entry_t *entry = (fast_entry_t *)data;

	fast_timeout_delentry(&fastnat_spinlock, entry);
    
	//printk("@@@@@@fast_spinlock err data=0x%X,lock=%p,4=%p,6=%p \n",data,&fastnat_spinlock,&fast6_spinlock);	
}

static void fast_timeout6(unsigned long data)
{
    fast_entry_t *entry = (fast_entry_t *)data;
	fast_timeout_delentry(&fast6_spinlock, entry);
}

void fast_entry_del_cleanup(void)
{
	fast_entry_t *entry, *next;

	//if (fast_del_list.count)
		//printk("@@@@@@fast_entry_del_cleanup count:%u \n", fast_del_list.count);

	spin_lock_bh(&fast_del_spinlock);
    for (entry = fast_del_list.next; entry; entry = next)
    {
    	next = entry->next;
		
        //ɾentryԶĶʱ --- Ȼdel listеtimerɾˣֹмбmodȥ
        del_timer(&entry->timeout);

		fn_list_del(&fast_del_list, entry, true);
    }
	spin_unlock_bh(&fast_del_spinlock);
}

//ѯڵ㣬鲻´
fast_entry_t *fast_get_entry(fast_list_t *list_head, struct nf_conn *ct, char dir, int version)
{
    fast_entry_t *ret = NULL;
    u_int8_t protocol;
	unsigned long expires;

    //for (ret = working_list.next; ret; ret = ret->next)
    for (ret = list_head->next; ret; ret = ret->next)
    {
        if (ret->ct == ct)
        {
        	protocol = nf_ct_protonum(ct);
			if (IPPROTO_TCP == protocol)
    		{
        		/*tcp*/
        		expires = jiffies + tcp_timeouts[ct->proto.tcp.state];
    		}
    		else
    		{
        		/*udp*/
        		if (fast_test_bit(IPS_SEEN_REPLY_BIT, ct->status))
        		{
            		expires = jiffies + fast_udp_timeout_stream;
        		}
        		else
        		{
            		expires = jiffies + fast_udp_timeout;
        		}

				
    		}			
        	//mod_timer(&ret->timeout, jiffies + tcp_timeouts[ct->proto.tcp.state]);
        	mod_timer(&ret->timeout, expires);
            return ret;
        }
    }

    /*ֻoriginal򴴽*/
    if (IP_CT_DIR_ORIGINAL != dir)
    {
        return NULL;
    }

    //ֶslabƣkmallocͨslabרslabĳרslab
    //ret = (fast_entry_t *)kmalloc(sizeof(fast_entry_t), GFP_ATOMIC);
#ifdef CONFIG_SLOB_OPT
    ret = kmalloc(kmem_cache_size(fast_head_cache), GFP_ATOMIC);
#else
    ret = kmem_cache_alloc(fast_head_cache, GFP_ATOMIC);
#endif
    if (ret == NULL)
    {
        //print_sun(SUN_ERR,"fast_get_entry: kmalloc fail!\n");
        return NULL;
    }
    netslab_inc(FAST_SLAB);
    memset(ret, 0, sizeof(fast_entry_t));
    ret->ct = ct;
    ret->list_head = list_head;
    
    //öʱ
    init_timer(&ret->timeout);

    protocol = nf_ct_protonum(ct);
    if (IPPROTO_TCP == protocol)
    {
        /*tcp*/
        ret->timeout.expires = jiffies + tcp_timeouts[ct->proto.tcp.state];
    }
    else
    {
        /*udp*/
        if (fast_test_bit(IPS_SEEN_REPLY_BIT, ct->status))
        {
            ret->timeout.expires = jiffies + fast_udp_timeout_stream;
        }
        else
        {
            ret->timeout.expires = jiffies + fast_udp_timeout;
        }
    }

    ret->timeout.data = (unsigned long)ret;
	if(version == 6)
	{
		ret->timeout.function = fast_timeout6;
	}
	else
	{		
    	ret->timeout.function = fast_timeout;
	}
    add_timer(&ret->timeout);
    
    //fn_list_add(&working_list, ret);
    fn_list_add(list_head, ret);

    return ret;
}

unsigned int get_conntrack_index(const struct tcphdr *tcph)
{
    if (tcph->rst) return TCP_RST_SET;
    else if (tcph->syn) return (tcph->ack ? TCP_SYNACK_SET : TCP_SYN_SET);
    else if (tcph->fin) return TCP_FIN_SET;
    else if (tcph->ack) return TCP_ACK_SET;
    else return TCP_NONE_SET;
}

/*tcpʱʱ*/
void update_tcp_timeout(fast_entry_t *entry, fast_entry_data_t *entry_data, struct tcphdr *tcph)
{
    enum tcp_conntrack new_state, old_state;
    unsigned int dir, index;

    old_state = entry->ct->proto.tcp.state;
    dir = entry_data->tuplehash.tuple.dst.dir;

    if (tcph == NULL || old_state >=TCP_CONNTRACK_MAX)
    {
        //print_sun(SUN_ERR,"update_tcp_timeout tcph is null! \n");
        return;
    }
    index = get_conntrack_index(tcph);

    /*TCP״̬*/
    new_state = tcp_conntracks[dir][index][old_state];
    if(old_state != new_state)
    {
        //οnf_conntrack_proto_tcp.ctcp_packet
        if (new_state == TCP_CONNTRACK_IGNORE)
            new_state = TCP_CONNTRACK_SYN_RECV;
        else if (new_state == TCP_CONNTRACK_MAX)
            return;
        
        entry->ct->proto.tcp.state = new_state;
        //ʱʱıʱŵóʱ⣬ٱ
        mod_timer(&entry->timeout, jiffies + tcp_timeouts[new_state]);
    }
}

/* ¼ӦmacϢɹ1򷵻0 */
int record_MAC_header(const struct hlist_nulls_head *working_hash, struct nf_conn *ct, 
    fast_entry_t *entry, fast_entry_data_t *entry_data, 
    struct neighbour *neigh, const struct net_device *out, int proto)
{
    struct ethhdr *eth;
    struct net_device *dst_out = NULL;
    int i;

    if (out == NULL)
        goto REL;

    //̫ڽMACͷԤֵPPPPPPoEЩǿɱģԤֵμalloc_netdevalloc_etherdevӿ
    if (out->type != ARPHRD_ETHER || neigh == NULL)
        return 1;
    
    //ڳΪbrʱֱӻȡL2豸usb0wifi0
    if (out->priv_flags & IFF_EBRIDGE)
    {
        if(out->dev_addr == NULL)
            goto REL;

        if (fastbr_level)
        {
#if 0
            //ĿMACַȡbrµĳdev
            rcu_read_lock();
            br_entry = fastL2DBFind(neigh->ha);
            //޷鵽MACַʱҪ쳣ͷ
            if (br_entry == NULL)
            {
                rcu_read_unlock();
                goto REL;
            }
            entry_data->outdev = br_entry->lan_dev;
            rcu_read_unlock();
#else
            dst_out = getbrport_bydst(out, neigh->ha);
            if (dst_out == NULL)
            {
                //print_sun(SUN_DBG,"!!!!! getbrport_bydst fail \n");
                goto REL;
            }
            entry_data->outdev = dst_out;
#endif
        }
        else
        {
             entry_data->outdev = out;
        }
        entry_data->hh_flag = 1;
        eth = (struct ethhdr *)entry_data->hh_data;
        eth->h_proto = proto;
        memcpy(eth->h_source, out->dev_addr, ETH_ALEN);
        memcpy(eth->h_dest, neigh->ha, ETH_ALEN);
    }
    //pppתֻҪIP
    else if (strncmp(out->name, ppp_name, strlen(ppp_name)) == 0)
    {
        if(out->dev_addr == NULL)
            goto REL;
        
        entry_data->outdev = out;
        entry_data->hh_flag = 0;
    }
    //̫ͨת
    else
    {
        if(out->dev_addr == NULL)
            goto REL;
        
        //wifi station/RJ45/USBȣҪֵMACͷ
        entry_data->outdev = out;
        entry_data->hh_flag = 1;
        eth = (struct ethhdr *)entry_data->hh_data;
        eth->h_proto = proto;
        memcpy(eth->h_source, out->dev_addr, ETH_ALEN);
        memcpy(eth->h_dest, neigh->ha, ETH_ALEN);
    }
    return 1;

REL:
    //֮ǰӿѱҪɾԴ
    for (i = 0; i < IP_CT_DIR_MAX; i++)
    {
        if (entry->flags & (1 << i))
        {
            hlist_nulls_del(&entry->data[i].tuplehash.hnnode);
            dev_put(entry->data[i].outdev);
        }
    }
    //ָctĳʱ
    add_timer(&ct->timeout);
    nf_ct_put(ct);
    del_timer(&entry->timeout);
    fn_list_del(entry->list_head, entry, true);
    return 0;
}

/* ĿMACŲŵ㣬ҵŵ㣬򷵻NULL */
struct net_device *getBridgePort(struct neighbour *neigh, const struct net_device *out)
{
    struct net_device *dst_out = NULL;

    if (!fast_test_bit(FAST_TYPE_BR_LOCAL_BIT, fast_switch))
        return NULL;

    if (!out || !neigh)
        return NULL;

    //̫ڽMACͷԤֵ
    if (out->type != ARPHRD_ETHER)
        return NULL;
    
    //ڳΪʱֱӻȡL2ŵ豸
    if (out->priv_flags & IFF_EBRIDGE)
    {
        if (out->dev_addr == NULL)
            return NULL;

        //ȡŵ
        dst_out = getbrport_bydst(out, neigh->ha);
        if (dst_out && dst_out != out)
            return dst_out;
        
        //print_sun(SUN_DBG, "!!!!! getbrport_bydst fail \n");
    }
    return NULL;
}

//жϲҪfastnatЭ
int check_skip_ports(unsigned int net_dst_port)
{
    int i = 0;
    unsigned int dst_port = htons(net_dst_port);

    if (!dst_port)
        return 0;
    
    for (i = 0; i < sizeof(nofast_port)/sizeof(nofast_port[0]); i++)
    {
        if (dst_port == nofast_port[i])
        {
            return 1;
        }
    }
    return 0;
}

//Ĳ庯ڲʵֳʱ豸¼
void traverse_process(fast_list_t *list_head, unsigned long param)
{
    fast_entry_t *entry, *next;
    traverse_command_t *cmd;
    int i, need_del;

    cmd = (traverse_command_t *)param;
    if (!cmd)
    {
        return;
    }

    //spin_lock_bh(&fastnat_spinlock);
    //for(entry = working_list.next; entry; entry = next)
    for(entry = list_head->next; entry; entry = next)
    {
        next = entry->next;
        need_del = 0;

        if (cmd->cmd == TRAVERSE_CMD_DEV_DOWN)
        {
            for (i = 0; i < IP_CT_DIR_MAX; i++)
            {
                if (entry->flags & (1 << i))
                {
                    const struct nf_conn_nat *nat = nfct_nat(entry->ct);
                    if ((entry->data[i].outdev && entry->data[i].outdev->ifindex == cmd->arg)
						|| (entry->data[i].indev && entry->data[i].indev->ifindex == cmd->arg)
                        || (nat && nat->masq_index == cmd->arg))
                    {
                        need_del = FAST_ALL_DIR;
                        break;
                    }
                }
            }
        }
#if 0
        //IPַӦMACַ仯ҪգhashеMACַᱻ
        else if(cmd->cmd == TRAVERSE_CMD_IP_MAC)
        {
            n = (struct neighbour *)cmd->arg;
            for(i = 0; i < IP_CT_DIR_MAX; i++)
            {
                if(entry->flags & (1 << i))
                {
                    if(!memcmp(n->primary_key, &(entry->data[i].tuplehash.tuple.src.u3.ip), 4) || 
                        !memcmp(n->primary_key, &(entry->data[i].tuplehash.tuple.dst.u3.ip), 4))
                    {
                        need_del = FAST_ALL_DIR;
                        break;
                    }
                }
            }
        }
#endif

        if (need_del)
        {
			workinghash_del_node(entry);
			fastlist_del_entry(entry->list_head, entry, false);
			//entryV4/V6, ɾlistͳһ¼
			spin_lock_bh(&fast_del_spinlock);
			if (fn_list_find(&fast_del_list, entry) == 1) {
				printk("dev down add entry:0x%p already existed\n", entry);
			}
			else {
				entry->list_head = &fast_del_list;
				entry->fast_spinlock = &fast_del_spinlock;
				fn_list_add(&fast_del_list, entry);
				//printk("dev down add:%u, entry:0x%x, list:0x%x \n", fast_del_list.count, entry, entry->list_head);
			}
			spin_unlock_bh(&fast_del_spinlock);
			/*
            del_timer(&entry->timeout);
            workinghash_del_node(entry);
            if (need_del == FAST_ALL_DIR)
            {
            	spin_lock_bh(&fast_del_spinlock);
				fn_list_del(&fast_del_list, entry, false);
				spin_unlock_bh(&fast_del_spinlock);
				
                fastlist_del_entry(entry->list_head, entry, true);
            }
            */
        }
    }
}

//fastnat_levelرգipv4,ipv6תϢԭct
void fast_cleanup_links(fast_list_t *list_head)
{
    fast_entry_t *entry, *next;

    //for (entry = working_list.next; entry; entry = next)
    for (entry = list_head->next; entry; entry = next)
    {
        next = entry->next;
        //ɾentryԶĶʱ
        del_timer(&entry->timeout);
        
        workinghash_del_node(entry);
        
        //رfastnatԭ
        //entry->ct->timeout.function((unsigned long)entry->ct);
        //ct
        //nf_ct_put(entry->ct);
        //fn_list_del(&working_list, entry);
        //ָctĳʱ
        add_timer(&entry->ct->timeout);
        fn_list_del(list_head, entry, true);

    }
}

void athr_fast_dump(int ctl)
{

}

/* ***************** תͳһ ********************************/
/* ѯתctϢ --- οnf_conntrack_inʵ */
struct nf_conn *skb_get_ct(struct nf_conn **tmpl,
          struct sk_buff *skb,
          struct nf_conntrack_l4proto **l4proto,
          unsigned int *dataoff,
          u_int8_t pf,
          unsigned int hooknum,
          int *dir,
          u_int8_t *protonum)
{
    struct nf_conntrack_l3proto *l3proto;
    int ret;
    struct nf_conntrack_tuple tuple;
    struct nf_conntrack_tuple_hash *h;
    struct nf_conn *ct;
    u16 zone; 
    enum ip_conntrack_info ctinfo;
    
    //²οnf_conntrack_inʵֲѯct
    if (skb->nfct) {
        /* Previously seen (loopback or untracked)?  Ignore. */
        *tmpl = (struct nf_conn *)skb->nfct;
        if (!nf_ct_is_template(*tmpl)) {
            goto err_out;
        }
        skb->nfct = NULL;
    }
    
    l3proto = __nf_ct_l3proto_find(pf);
    ret = l3proto->get_l4proto(skb, skb_network_offset(skb),
                       dataoff, protonum);

    if (ret <= 0) {
        goto err_out;
    }
        
    *l4proto = __nf_ct_l4proto_find(pf, *protonum);
    //tcp_error()лУͣռôCPUԻûʧܵ
    #if 0 
    if ((*l4proto)->error != NULL) {
        ret = (*l4proto)->error(&init_net, NULL, skb, *dataoff, &ctinfo,
                         pf, hooknum);
        if (ret <= 0) {
            goto err_out;
        }
        if (skb->nfct){
            goto err_out;
        }
    }
        
    #endif

    if (*protonum != IPPROTO_TCP && *protonum != IPPROTO_UDP)
        goto err_out;

    zone = *tmpl ? nf_ct_zone(*tmpl) : NF_CT_DEFAULT_ZONE;

    if (!nf_ct_get_tuple(skb, skb_network_offset(skb),
                 *dataoff, pf, *protonum, &tuple, l3proto,
                 *l4proto)) {
        goto err_out;
    }

    h = nf_conntrack_find_get(&init_net, zone, &tuple);
    if (!h || IS_ERR(h)){
        goto err_out;
    }
    
    ct = nf_ct_tuplehash_to_ctrack(h);
    if (!ct || IS_ERR(ct)) {
        goto err_out;
    }
    
    if (fast_test_bit(IPS_DYING_BIT, ct->status) || fast_test_bit(IPS_UNTRACKED_BIT, ct->status))
    {
        nf_conntrack_put(&ct->ct_general);
        //printk("skb_get_ct ct state err: 0x%x\n", ct->status);
        goto err_out;
    }
        
    if (*tmpl && *tmpl == ct)
    {
        nf_conntrack_put(&ct->ct_general);
        goto err_out;
    }

    //TCP˫߿ת
    if (IPPROTO_TCP == *protonum && !fast_test_bit(IPS_ASSURED_BIT, ct->status))
    {
        nf_conntrack_put(&ct->ct_general);
        goto err_out;
    }
    
    if (NF_CT_DIRECTION(h) == IP_CT_DIR_REPLY) {
        *dir = 1;
    } else {
        *dir = 0;
    }
    return ct;

err_out :
    //print_sun(SUN_DBG, "skb : 0x%x, skb_get_ct fail!!!!!!!!!!", skb);
    if (*tmpl){
        skb->nfct = &((*tmpl)->ct_general);
    }
    else{
        skb->nfct = NULL;
    }
    return NULL;
}

//µfastģʽʽ
int fast_for_ip_new(struct sk_buff *skb,
    int(*fast_fw)(struct nf_conn *, struct sk_buff *, struct nf_conn *, 
                   struct nf_conntrack_l4proto *, unsigned int, int, u_int8_t), 
    int(*fast_local_proc)(struct nf_conn *, struct sk_buff *, struct nf_conn *, 
                            struct nf_conntrack_l4proto *, unsigned int, int, u_int8_t), 
    int proto)
{
    struct nf_conn *ct = NULL, *tmpl = NULL;
    struct nf_conntrack_l4proto *l4proto;
    unsigned int dataoff;
    u_int8_t protonum;
    int dir = 0;
    
    if (proto == ETH_P_IP)
        ct = skb_get_ct(&tmpl, skb, &l4proto, &dataoff, PF_INET, NF_INET_PRE_ROUTING, &dir, &protonum);
    else if (proto == ETH_P_IPV6)
        ct = skb_get_ct(&tmpl, skb, &l4proto, &dataoff, PF_INET6, NF_INET_PRE_ROUTING, &dir, &protonum);

    if (!ct)
    {
        if (fast_br_proc && fast_br_proc(skb))
        {
            fastbr_num++;
            return 1;
        }
        return 0;
    }

    /*TCPֳɹfastɹ*/
    if (IPPROTO_TCP == protonum || NEXTHDR_TCP == protonum)
    {
    	int rdir = (IP_CT_DIR_ORIGINAL == dir) ? IP_CT_DIR_REPLY: IP_CT_DIR_ORIGINAL;
		if (!fast_test_bit(IPS_ASSURED_BIT, ct->status)) {
			nf_conntrack_put(&ct->ct_general);
            return 0;
		}
		if (!(ct->fast_ct.fast_dst[dir] && ct->fast_ct.fast_dst[rdir])) {
			nf_conntrack_put(&ct->ct_general);
			return 0;
		}
    }
    
    switch(ct->fast_ct.isFast)
    {
        case FAST_CT_FW4:
        case FAST_CT_FW6: 
            if (fast_fw && fast_fw(tmpl, skb, ct, l4proto, dataoff, dir, protonum)){
                if (proto == ETH_P_IP)
                    fastnat_num++;
                else if (proto == ETH_P_IPV6)
                    fast6_num++;
                return 1;
            }
            return 0;
        case FAST_CT_LOCAL4:
        case FAST_CT_LOCAL6:
            if (fast_local_proc && fast_local_proc(tmpl, skb, ct, l4proto, dataoff, dir, protonum)){
                if (proto == ETH_P_IP)
                    fast_local4_rcv_num++;
                else if (proto == ETH_P_IPV6)
                    fast_local6_rcv_num++;
                return 1;
            }
            return 0;
        default:
            nf_conntrack_put(&ct->ct_general);
            if (fast_br_proc && fast_br_proc(skb)){
                fastbr_num++;
                return 1;
            }
            return 0; 
    }
}

//ɵfastģʽʽ
int fast_for_ip(struct sk_buff *skb, int(*fast_fw)(struct sk_buff *),
    int(* fast_local_proc)(struct nf_conn *, struct sk_buff *, struct nf_conn *, 
                             struct nf_conntrack_l4proto *, unsigned int, int, u_int8_t), 
    int proto)
{
    struct nf_conn *ct = NULL, *tmpl = NULL;
    struct nf_conntrack_l4proto *l4proto;
    unsigned int dataoff;
    u_int8_t protonum;
    int dir = 0;
    
    //תŽӡ˳
    if (fast_fwd_level > fast_br_level && fast_br_level > fast_local_level)
    {
        if (fast_fw && fast_fw(skb))
        {
            if (proto == ETH_P_IP)
                fastnat_num++;
            else if (proto == ETH_P_IPV6)
                fast6_num++;
            return 1;
        }
        else if (fast_br_proc && fast_br_proc(skb) == 1)
        {
            fastbr_num++;
            return 1;
        }
    #if 0 //fastʱֱ֧ؿת
        else if (fast_local_proc)
        {
            if (proto == ETH_P_IP)
                ct = skb_get_ct(tmpl, skb, &l4proto, &dataoff, PF_INET, NF_INET_PRE_ROUTING, &dir);
            else if (proto == ETH_P_IPV6)
                ct = skb_get_ct(tmpl, skb, &l4proto, &dataoff, PF_INET6, NF_INET_PRE_ROUTING, &dir);
            
            if(!ct)
                return 0;
            
            if (fast_local_proc(tmpl, skb, ct, l4proto, dataoff, dir)){
                if (proto == ETH_P_IP)
                    fast_local4_rcv_num++;
                else if (proto == ETH_P_IPV6)
                    fast_local6_rcv_num++;
                return 1;
            }
        }
    #endif
    }
    //תءŽ˳
    else if (fast_fwd_level > fast_local_level && fast_local_level > fast_br_level)
    {
        if (fast_fw && fast_fw(skb))
        {
            if (proto == ETH_P_IP)
                fastnat_num++;
            else if (proto == ETH_P_IPV6)
                fast6_num++;
            return 1;
        }
    #if 0
        else if (fast_local_proc)
        {
            if (proto == ETH_P_IP)
                ct = skb_get_ct(tmpl, skb, &l4proto, &dataoff, PF_INET, NF_INET_PRE_ROUTING, &dir);
            else if (proto == ETH_P_IPV6)
                ct = skb_get_ct(tmpl, skb, &l4proto, &dataoff, PF_INET6, NF_INET_PRE_ROUTING, &dir);
            
            if (!ct)
                return 0;
            
            if (fast_local_proc(tmpl, skb, ct, l4proto, dataoff, dir)){
                if (proto == ETH_P_IP)
                    fast_local4_rcv_num++;
                else if (proto == ETH_P_IPV6)
                    fast_local6_rcv_num++;
                return 1;
            }
        }
    #endif
        else if (fast_br_proc && fast_br_proc(skb) == 1)
        {
            fastbr_num++;
            return 1;
        }
    }
    //Žӡת˳
    else if (fast_br_level > fast_fwd_level && fast_fwd_level > fast_local_level)
    {
        if (fast_br_proc && fast_br_proc(skb) == 1)
        {
            fastbr_num++;
            return 1;
        }
        else if (fast_fw && fast_fw(skb))
        {
            if (proto == ETH_P_IP)
                fastnat_num++;
            else if (proto == ETH_P_IPV6)
                fast6_num++;
            return 1;
        }
    #if 0
        else if (fast_local_proc)
        {
            if (proto == ETH_P_IP)
                ct = skb_get_ct(tmpl, skb, &l4proto, &dataoff, PF_INET, NF_INET_PRE_ROUTING, &dir);
            else if (proto == ETH_P_IPV6)
                ct = skb_get_ct(tmpl, skb, &l4proto, &dataoff, PF_INET6, NF_INET_PRE_ROUTING, &dir);
            
            if (!ct)
                return 0;
            
            if (fast_local_proc(tmpl, skb, ct, l4proto, dataoff, dir)){
                if (proto == ETH_P_IP)
                    fast_local4_rcv_num++;
                else if (proto == ETH_P_IPV6)
                    fast_local6_rcv_num++;
                return 1;
            }
        }
    #endif
    }
    //Žӡءת˳
    else if(fast_br_level > fast_local_level && fast_local_level > fast_fwd_level)
    {
        if (fast_br_proc && fast_br_proc(skb) == 1)
        {
            fastbr_num++;
            return 1;
        }
        else if (fast_local_proc)
        {
            if (proto == ETH_P_IP)
                ct = skb_get_ct(&tmpl, skb, &l4proto, &dataoff, PF_INET, NF_INET_PRE_ROUTING, &dir, &protonum);
            else if (proto == ETH_P_IPV6)
                ct = skb_get_ct(&tmpl, skb, &l4proto, &dataoff, PF_INET6, NF_INET_PRE_ROUTING, &dir, &protonum);
            
            if(!ct)
                return 0;
            
            if (fast_local_proc(tmpl, skb, ct, l4proto, dataoff, dir, protonum)){
                if (proto == ETH_P_IP)
                    fast_local4_rcv_num++;
                else if (proto == ETH_P_IPV6)
                    fast_local6_rcv_num++;
                return 1;
            }
        }
        else if (fast_fw && fast_fw(skb))
        {
            if (proto == ETH_P_IP)
                fastnat_num ++;
            else if (proto == ETH_P_IPV6)
                fast6_num++;
            return 1;
        }
    }
    //ءתŽ˳
    else if(fast_local_level > fast_fwd_level && fast_fwd_level > fast_br_level)
    {
    #if 0
        if (fast_local_proc)
        {
            if (proto == ETH_P_IP)
                ct = skb_get_ct(tmpl, skb, &l4proto, &dataoff, PF_INET, NF_INET_PRE_ROUTING, &dir);
            else if (proto == ETH_P_IPV6)
                ct = skb_get_ct(tmpl, skb, &l4proto, &dataoff, PF_INET6, NF_INET_PRE_ROUTING, &dir);
            
            if (!ct)
                return 0;
            
            if (fast_local_proc(tmpl, skb, ct, l4proto, dataoff, dir)){
                if (proto == ETH_P_IP)
                    fast_local4_rcv_num++;
                else if (proto == ETH_P_IPV6)
                    fast_local6_rcv_num++;
                return 1;
            }
        }
        else
    #endif
    if (fast_fw && fast_fw(skb))
        {
            if (proto == ETH_P_IP)
                fastnat_num++;
            else if (proto == ETH_P_IPV6)
                fast6_num++;
            return 1;
        }
        else if (fast_br_proc == 1 && fast_br_proc(skb) == 1)
        {
            fastbr_num++;
            return 1;
        }
    }
    //ءŽӡת˳
    else if(fast_local_level > fast_br_level && fast_br_level > fast_fwd_level)
    {
    #if 0
        if (fast_local_proc)
        {
            if (proto == ETH_P_IP)
                ct = skb_get_ct(tmpl, skb, &l4proto, &dataoff, PF_INET, NF_INET_PRE_ROUTING, &dir);
            else if (proto == ETH_P_IPV6)
                ct = skb_get_ct(tmpl, skb, &l4proto, &dataoff, PF_INET6, NF_INET_PRE_ROUTING, &dir);
            
            if (!ct)
                return 0;
            
            if (fast_local_proc(tmpl, skb, ct, l4proto, dataoff, dir)){
                if (proto == ETH_P_IP)
                    fast_local4_rcv_num++;
                else if (proto == ETH_P_IPV6)
                    fast_local6_rcv_num++;
                return 1;
            }
            return 0;    
        }
        else
    #endif
        if (fast_br_proc && fast_br_proc(skb) == 1)
        {
            fastbr_num++;
            return 1;
        }
        else if (fast_fw && fast_fw(skb))
        {
            if (proto == ETH_P_IP)
                fastnat_num++;
            else if (proto == ETH_P_IPV6)
                fast6_num++;
            return 1;
        }
    }
    return 0;
}

int btrunk_fw = 0;
module_param(btrunk_fw, int, 0644);
extern unsigned int lan_ipaddr;
extern unsigned int lan_netmask;
int lan_dos_enable = 0;
module_param(lan_dos_enable, int, 0644);

//v6ǰ׺
#define MAX_PREFIXS 4
static u_int16_t pswan1_prefix[MAX_PREFIXS];
static unsigned int wan1_prefix_c;
module_param_array(pswan1_prefix, ushort, &wan1_prefix_c, 0644);
static u_int16_t pswan2_prefix[MAX_PREFIXS];
static unsigned int wan2_prefix_c;
module_param_array(pswan2_prefix, ushort, &wan2_prefix_c, 0644);
static u_int16_t pswan3_prefix[MAX_PREFIXS];
static unsigned int wan3_prefix_c;
module_param_array(pswan3_prefix, ushort, &wan3_prefix_c, 0644);
static u_int16_t pswan4_prefix[MAX_PREFIXS];
static unsigned int wan4_prefix_c;
module_param_array(pswan4_prefix, ushort, &wan4_prefix_c, 0644);
static u_int16_t pswan5_prefix[MAX_PREFIXS];
static unsigned int wan5_prefix_c;
module_param_array(pswan5_prefix, ushort, &wan5_prefix_c, 0644);
static u_int16_t pswan6_prefix[MAX_PREFIXS];
static unsigned int wan6_prefix_c;
module_param_array(pswan6_prefix, ushort, &wan6_prefix_c, 0644);
static u_int16_t pswan7_prefix[MAX_PREFIXS];
static unsigned int wan7_prefix_c;
module_param_array(pswan7_prefix, ushort, &wan7_prefix_c, 0644);
static u_int16_t pswan8_prefix[MAX_PREFIXS];
static unsigned int wan8_prefix_c;
module_param_array(pswan8_prefix, ushort, &wan8_prefix_c, 0644);
static u_int16_t ethwan_prefix[MAX_PREFIXS];
static unsigned int wan9_prefix_c;
module_param_array(ethwan_prefix, ushort, &wan9_prefix_c, 0644);
static u_int16_t wifiwan_prefix[MAX_PREFIXS];
static unsigned int wan10_prefix_c;
module_param_array(wifiwan_prefix, ushort, &wan10_prefix_c, 0644);

//ƥǰ׺2,·ַ1
static int v6_addr_is_lan_prefix(const struct in6_addr *addr)
{	
	u_int16_t *wan_prefix[] = {
		pswan1_prefix,
		pswan2_prefix,
		pswan3_prefix,
		pswan4_prefix,
		pswan5_prefix,
		pswan6_prefix,
		pswan7_prefix,
		pswan8_prefix,
		ethwan_prefix,
		wifiwan_prefix
	};
	int i = 0;

	if (addr->s6_addr16[0] == htons(0xFE80)) {
		return 1;
	}

	for (i = 0; i < sizeof(wan_prefix)/sizeof(wan_prefix[0]); i++) {
		u_int16_t *t_prefix = wan_prefix[i];
		if (addr->s6_addr16[0] == htons(t_prefix[0]) &&
			addr->s6_addr16[1] == htons(t_prefix[1]) &&
			addr->s6_addr16[2] == htons(t_prefix[2]) &&
			addr->s6_addr16[3] == htons(t_prefix[3])) {
			return 2;
		}
	}

	return 0;
}

//Ŀĵַ鲥ַʱ,֮ǰѹ˵,ﲻ
//,ԴĿĵַǱ·ַ(FE80ͷ),һַǱصַ,Һǰ׺ƥʱ,
//,ԴĿĵַǰ׺ǰ׺ʱ,
static int v6_dos_check(struct sk_buff *skb)
{
	int flag_s = v6_addr_is_lan_prefix(&ipv6_hdr(skb)->saddr);
	int flag_d = v6_addr_is_lan_prefix(&ipv6_hdr(skb)->daddr);	

	if (flag_s == 1) {
		if (flag_d == 1 || flag_d == 2) {		
			return 0;
		}
	} else if (flag_s == 2) {
		return 0;
	} else if (flag_d == 2) {
		return 0;
	}
	
	return 1;
}

extern int fast_fwd_ip4addr_conflict(struct sk_buff *skb);
extern int fast_for_multicast(struct sk_buff *skb);
/*ڿܲMAC֡ͷPSڣҪͨIPͷʶskb->protocolֵ*/
int fast_for_ipdata(struct sk_buff *skb)
{
    if (skb->len > 1000)
        skb_big_num++;
    else if (skb->len < 100)
        skb_small_num++;

    if (skb->dev == NULL)
        return 0;
 
	if (skb->protocol == htons(ETH_P_IP)) //ipv4
    {
        skb_num4++;
        skb_bytes4 += skb->len;
		
		if(btrunk_fw && fast_fwd_ip4addr_conflict(skb) == 1)
		{
			return 1;		
		}

		//DOS,ĿiplanʱԴipͬһΣ
		if(unlikely(lan_dos_enable))
		{
			if (lan_ipaddr && lan_netmask
				&& (ip_hdr(skb)->daddr == lan_ipaddr)
				&& ((ip_hdr(skb)->saddr & lan_netmask) != (lan_ipaddr & lan_netmask)))
			{
				//printk("[fast_for_ipdata] drop: saddr = 0x%x, daddr = 0x%x, lan_netmask = 0x%x, lan_ipaddr = 0x%x \n", ip_hdr(skb)->saddr, ip_hdr(skb)->daddr, lan_netmask, lan_ipaddr);
				ip_lan_dos_num++;
				kfree_skb(skb);
				return 1;
			}
		}
		
        //Ŀתʵ֣ʱֻͳ
        if (ipv4_is_multicast(ip_hdr(skb)->daddr))
        {
            multicast_num4++;
			if(btrunk_fw && fast_for_multicast(skb) == 1)
			{
				return 1;		
			}
            return 0;
        }
        //㲥ֿ֧תֻͳ
        else if (ipv4_is_lbcast(ip_hdr(skb)->daddr)){
            broadcast_num4++;
            return 0;
        }
        
        if (ip_is_fragment(ip_hdr(skb)))
        {
            skbinfo_add(NULL, SKB_FRAG);
            return 0;
        }

        //ֻTCPUDPпת
        if (ip_hdr(skb)->protocol != IPPROTO_TCP && ip_hdr(skb)->protocol != IPPROTO_UDP)
        {
            return 0;
        }
		
        if(!fast_iphdr_check(skb, ETH_P_IP)) 
    	{
	    	iphdr_err_num++;
    		kfree_skb(skb);
			return 1;
		}
		
       /*paddingȥskbβpadding, οip_rcv*/
        skb_trim(skb, ntohs(ip_hdr(skb)->tot_len));

	/* tcpͷϢ*/
	if (ip_hdr(skb)->protocol == IPPROTO_TCP) {
		if (!fast_tcphdr_check(skb, ETH_P_IP))	{
			tcphdr_err_num++;
			printk("fast tcp hdr error \n");
#ifdef _USE_VEHICLE_DC
			return 0;
#else
			kfree_skb(skb);
			return 1;
#endif
	   	}
	}
        if (!fast_test_bit(FAST_TYPE_VERSION_BIT, fast_switch))
            return fast_for_ip(skb, fast_nat4_proc , fast_local4_proc, ETH_P_IP);
        else
	return fast_for_ip_new(skb, fast_fw4_proc, fast_local4_proc, ETH_P_IP);

    }
    else if (skb->protocol == htons(ETH_P_IPV6)) //ipv6
    {
        skb_num6++;
        skb_bytes6 += skb->len;

        //鲥Ŀתʵ֣ʱֱӷؿתʧ
        if(ipv6_addr_is_multicast(&ipv6_hdr(skb)->daddr))
        {
            multicast_num6++;
            return 0;
        }

        if (skb->nfct_reasm) {
            //printk("fast6_fw reasm\n");
            return 0;
        }

      	/*  if (ipv6_hdr(skb)->nexthdr != IPPROTO_TCP && ipv6_hdr(skb)->nexthdr != IPPROTO_UDP){
        //    printk("wrong protocol v6 = %d\n", ipv6_hdr(skb)->nexthdr);
            return 0;
        }*/

        if(!fast_iphdr_check(skb, ETH_P_IPV6)) 
    	{
	    	ip6hdr_err_num++;
    		kfree_skb(skb);
			return 1;
		}
		if(unlikely(lan_dos_enable))
		{
			if (v6_dos_check(skb) == 1) {
				ip6_dos_num++;
				kfree_skb(skb);
				return 1;
			}		
		}
		
        /*paddingȥskbβpaddingοipv6_rcv*/
        skb_trim(skb, ntohs(ipv6_hdr(skb)->payload_len) + sizeof(struct ipv6hdr));
		/* tcpͷϢ*/
		if (!fast_tcphdr_check(skb, ETH_P_IPV6))	{
			tcp6hdr_err_num++;
			printk("fast6 tcp hdr error \n");
#ifdef _USE_VEHICLE_DC
			return 0;
#else
			kfree_skb(skb);
			return 1;
#endif
		}
        if (!fast_test_bit(FAST_TYPE_VERSION_BIT, fast_switch))
            return fast_for_ip(skb, fast_nat6_proc, fast_local6_proc, ETH_P_IPV6);
        else
            return fast_for_ip_new(skb, fast_fw6_proc, fast_local6_proc, ETH_P_IPV6);
    }
    else
        skb_unknown++;

    //print_sun(SUN_DBG, "fastnat/fast6/fastbr   all     fail !!! \n");
    return 0;
}

/*skbָתIPͷ*/
static int set_skbdata_toip(struct sk_buff *skb)
{
    __be16 next_pro = skb->protocol;
again:
    if (next_pro == htons(ETH_P_IP) || next_pro == htons(ETH_P_IPV6))
    {
        skb_set_network_header(skb, 0);
        skb->protocol = next_pro;
        return 1;
    }
    //vlan
    else if (next_pro == cpu_to_be16(ETH_P_8021Q))
    {
        skb->isvlan = 1;
        skb_pull(skb, VLAN_HLEN);
        next_pro = *((__be16 *)(skb->data - 2));
        goto again;
    }
    
    //pppoe 
    else if (next_pro == htons(ETH_P_PPP_SES))
    {
        if (*(skb->data + 6) == 0x00 && *(skb->data + 7) == 0x21)
        {
            next_pro = htons(ETH_P_IP);
            __skb_pull(skb, PPPOE_HEADER_LEN);
            goto again;
        }
        else if(*(skb->data + 6) == 0x00 && *(skb->data + 7) == 0x57)
        {
            next_pro = htons(ETH_P_IPV6);
            __skb_pull(skb, PPPOE_HEADER_LEN);
            goto again;
        }
    }
    return 0;
}

/*ںdev.cݽпٴipppp*/
static int try_fast_for_netcoredata(struct sk_buff *skb)
{
    __be16 old_pro = skb->protocol;
    unsigned int old_len = skb->len;
    unsigned char * old_data = skb->data;
    
    //ipͷ4ֽڶ
    //if (((unsigned long)skb->data)%4 != 0) 
        //panic("ERR: fast from dev skb->data%4 != 0");

    if (skb->indev == NULL)
        skb->indev = skb->dev;

    //Ҫ׼ȷλIPͷڼppp/mac/pppoeȸֲ2ͷ
    if (set_skbdata_toip(skb) == 1 && fast_for_ipdata(skb))
        return 1;
    
    //ٴʧܣͨ¸ֵػԭʼskbֵɱ׼linuxں˴
    skb->protocol = old_pro;
    skb->data = old_data;
    skb->len = old_len;
    return 0;
}

/*skbָMAC֡ͷϱݽпٴ̫ܹ豸ϱݵĿٴ*/
static int try_fast_for_macdata(struct sk_buff *skb, struct net_device *dev)
{    
    struct ethhdr *eth;
/*
    if (!(skb->network_header == 0 || skb->network_header == ~0U))
        panic("network_header    ERR!!!!!!!!!!\n");
*/
    skb->dev = dev;
    if (skb->indev == NULL)
        skb->indev = dev;
    skb_reset_mac_header(skb);
    eth = eth_hdr(skb);
    skb->protocol = eth->h_proto;
    skb_pull(skb, ETH_HLEN);
    
    if (tsp_mirror_handle)
        tsp_mirror_handle(skb);

    //tcp/udp¼ʱӹܣҪserverܰװӦãתʧܣҪ¼
    net_dbg_perf_dev_recv(skb, skb->dev->name);
    
    if (try_fast_for_netcoredata(skb))
    {
        return 1;
    }

    //tcp/udp¼ʱӹܣҪserverܰװӦ
    net_dbg_perf_clear_last_item(skb);
    
    skb_push(skb, ETH_HLEN);
    return 0;
}

EXPORT_SYMBOL_GPL(tsp_mirror_handle);

/*֪ͨ¼*/
static int fast_event(struct notifier_block *this, unsigned long event, struct net_device *dev)
{
    traverse_command_t cmd;
    
    switch (event) {
        case NETDEV_DOWN:
            if (dev)
            {
                cmd.cmd = TRAVERSE_CMD_DEV_DOWN;
                cmd.arg = dev->ifindex;

                fastnat_event(&cmd);
                fast6_event(&cmd);
            }
            break;
    }
    return NOTIFY_DONE;
}

static int fast_device_event(struct notifier_block *this, unsigned long event, void *ptr)
{
    struct net_device *dev = (struct net_device *)ptr;

    return fast_event(this, event, dev);
}

static int fast_inet_event(struct notifier_block *this, unsigned long event, void *ptr)
{
    struct net_device *dev = ((struct in_ifaddr *)ptr)->ifa_dev->dev;

    return fast_event(this, event, dev);
}

/*priority should be higher than masquerade, otherwise kernel will hang*/
static struct notifier_block fast_dev_notifier = {
    .notifier_call    = fast_device_event,
    .priority = 1,
};

/*priority should be higher than masquerade, otherwise kernel will hang*/
static struct notifier_block fast_inet_notifier = {
    .notifier_call    = fast_inet_event,
    .priority = 1,
};

void fast_device_down_event_by_name(char *dev_name)
{
    struct net_device *dev = NULL;

    if (!dev_name)
    {
        //print_sun(SUN_ERR,"fast_device_down_event_by_name dev_name is null \n");
        return;
    }
    
    dev = dev_get_by_name(&init_net, dev_name);
    if (!dev)
    {
        //print_sun(SUN_ERR,"fast_device_down_event_by_name dev not found \n");
        return;
    }
    
    fast_event(NULL, NETDEV_DOWN, dev);

    /*add by jiangjing*/
    dev_put(dev);
}

/**** ²µfastģʽʹú ****/
extern void fast_local_conn_release(struct nf_conn *ct);
extern void fast_local_sock_release(struct sock *sk);

void fast_sk_add_ct(struct sk_buff *skb, struct sock *sk)
{    
    struct nf_conn *ct;
    struct conn_list* entry;
    int conn_flag = 0; 

    if (fastnat_level == FAST_CLOSE || fastnat_level == FAST_CLOSE_KEEP_LINK)
    {
        return;
    }

    if (skb->isFastlocal)
        return;
    
    //ֻTCPUDPsock״̬ϲŽ
    if (skb->protocol == htons(ETH_P_IP))
    {
        if (!fast_test_bit(FAST_TYPE_LOCAL4_BIT, fast_switch))
            return;
        
        struct iphdr *iph = (struct iphdr *)skb->network_header;
        if (!((IPPROTO_TCP == iph->protocol || IPPROTO_UDP == iph->protocol) && sk->sk_state == TCP_ESTABLISHED))
            return;
    }
    else if (skb->protocol == htons(ETH_P_IPV6))
    {
        if (!fast_test_bit(FAST_TYPE_LOCAL6_BIT, fast_switch))
            return;
        //οipv6_get_l4protoȡĲЭ
        int extoff = skb_network_offset(skb) + sizeof(struct ipv6hdr);
        u8 protonum = 0;
        if (skb_copy_bits(skb, skb_network_offset(skb) + offsetof(struct ipv6hdr, nexthdr),
			  &protonum, sizeof(protonum)) != 0) {
		    printk("ip6_conntrack_core: can't get nexthdr\n");
		    return;
	    }
        nf_ct_ipv6_skip_exthdr(skb, extoff, &protonum, skb->len - extoff);

        if (!((IPPROTO_TCP == protonum || IPPROTO_UDP == protonum) && sk->sk_state == TCP_ESTABLISHED))
            return;
    }
    else
        printk("Error: fast_sk_add_ct proto error: %d \n", skb->protocol);
    
    ct = (struct nf_conn *)skb->nfct;
    if (!ct)
        return;
    
    if (ct->fast_ct.sk && ct->fast_ct.sk == sk)
        return;
    
    //loopݲfast
    if (skb->indev && !strcmp(skb->indev->name, "lo"))
        return;

    //if((IPPROTO_TCP == iph->protocol || IPPROTO_UDP == iph->protocol) && sk->sk_state == TCP_ESTABLISHED)
    {
        spin_lock_bh(&fastlocal_spinlock);
        
        rcu_assign_pointer(ct->fast_ct.sk, sk);

        //sk洢ctʼ --- skĵطʼʣǵ϶ʱûȫñλʶ
        if (sk->conn_list_init == 0)
        {
            INIT_LIST_HEAD(&sk->conn_head);
            sk->conn_list_init = 1;
        }
        
        list_for_each_entry_rcu(entry, &sk->conn_head, list)
        {
            if (entry->nfct && entry->nfct == ct)
            {    
                conn_flag = 1;
                break;
            }
        }
        
        if (conn_flag == 0)
        {
            struct conn_list *conn_list_node =(struct conn_list*)kzalloc(sizeof(struct conn_list), GFP_KERNEL);
			if(conn_list_node){
            //memset(conn_list_node, 0, sizeof(struct conn_list));        
            rcu_assign_pointer(conn_list_node->nfct, ct);
            list_add_rcu(&conn_list_node->list, &sk->conn_head);
			}
            if (skb->protocol == htons(ETH_P_IP))
                ct->fast_ct.isFast = FAST_CT_LOCAL4;
            else if (skb->protocol == htons(ETH_P_IPV6))
                ct->fast_ct.isFast = FAST_CT_LOCAL6;
        }
        spin_unlock_bh(&fastlocal_spinlock);
    }
}

/* תctӵsock¼ */
void fast_dst_add_ct(struct dst_entry *dst, struct nf_conn *ct)
{
    struct conn_list *entry;
    int conn_flag = 0;

    list_for_each_entry_rcu(entry, &dst->conn_head, list)
    {
        if (entry->nfct == ct)
        {    
            conn_flag = 1;
            break;
        }
    }
    
    if (conn_flag == 0)
    {
        struct conn_list *conn_list_node =(struct conn_list*)kzalloc(sizeof(struct conn_list), GFP_KERNEL);
		if(conn_list_node){
        //memset(conn_list_node, 0, sizeof(struct conn_list));
        rcu_assign_pointer(conn_list_node->nfct, ct);
        list_add_rcu(&conn_list_node->list, &dst->conn_head);
		}
    }
}

/* net_deviceͷţͷת */
void fast_fw_conn_release_by_dev(struct net_device* dev)
{
	int hash = 0;
	struct nf_conntrack_tuple_hash *h;
	struct hlist_nulls_node *n;
	struct nf_conn *ct;
	int dir;
	struct net_device *net;
	
	if(fastnat_level == FAST_CLOSE)
		return ;
	
	rcu_read_lock();
	for (hash = 0; hash < init_net.ct.htable_size; hash++) 
	{
		local_bh_disable();
		hlist_nulls_for_each_entry_rcu(h, n, &init_net.ct.hash[hash], hnnode) 
		{
			if (h)
			{
				ct = nf_ct_tuplehash_to_ctrack(h);
				NF_CT_ASSERT(ct);

				//ͷŴؿתϢ
				for (dir = IP_CT_DIR_ORIGINAL; dir < IP_CT_DIR_MAX; dir++)
				{
					if ((net = ct->fast_ct.fast_brport[dir])!=0) 
					{
						if(!strcmp(dev->name, net->name))
						{
							spin_lock_bh(&fast_fw_spinlock);
							ct->fast_ct.fast_brport[dir] = NULL;
							spin_unlock_bh(&fast_fw_spinlock);
						}
					}
				}
			}
		}
		local_bh_enable();
	}
	rcu_read_unlock();
}
/* connͷţͷת */
void fast_fw_conn_release(struct nf_conn *ct)
{
    struct dst_entry *dst;
    struct conn_list *entry;
    int dir;
    
    for (dir = IP_CT_DIR_ORIGINAL; dir < IP_CT_DIR_MAX; dir++)
    {
        if (!(dst = dst_get_by_ct(ct, dir)))    
            continue;
    
        list_for_each_entry_rcu(entry, &dst->conn_head, list)
        {
            if (entry->nfct == ct)
            {
                entry->nfct = NULL;
                __list_del_entry(&entry->list);
                kfree(entry);
                break;
            }
        }
		//dst_get_by_ctholdһ£Ҫrelease
		dst_release(dst);
        rcu_assign_pointer(ct->fast_ct.fast_dst[dir], NULL);
        ct->fast_ct.fast_brport[dir] = NULL;
    }
    ct->fast_ct.isFast = 0;
}

//dst_entryͷţͷת
void fast_fw_dst_entry_release(struct dst_entry *dst)
{
    struct conn_list *entry = NULL;
    struct conn_list *entry_tmp = NULL;
    struct nf_conn *ct;
    struct list_head *tmp;

    list_for_each_entry_safe(entry, entry_tmp, &dst->conn_head, list){
        
        rcu_assign_pointer(ct, entry->nfct);
        if (!ct)
            continue;
        
        if (ct->fast_ct.fast_dst[IP_CT_DIR_ORIGINAL] && ct->fast_ct.fast_dst[IP_CT_DIR_ORIGINAL] == dst) {
            rcu_assign_pointer(ct->fast_ct.fast_dst[IP_CT_DIR_ORIGINAL], NULL);
            ct->fast_ct.fast_brport[IP_CT_DIR_ORIGINAL]   = NULL;
        }
        else if (ct->fast_ct.fast_dst[IP_CT_DIR_REPLY] && ct->fast_ct.fast_dst[IP_CT_DIR_REPLY] == dst) {
            rcu_assign_pointer(ct->fast_ct.fast_dst[IP_CT_DIR_REPLY], NULL);
            ct->fast_ct.fast_brport[IP_CT_DIR_REPLY]      = NULL;
        }
        else
            printk("Error: fast_fw_dst_entry_release \n");
        
		if (!ct->fast_ct.fast_brport[IP_CT_DIR_ORIGINAL] && !ct->fast_ct.fast_brport[IP_CT_DIR_REPLY])
			ct->fast_ct.isFast = 0;
        entry->nfct = NULL;
        __list_del_entry(&entry->list);
        kfree(entry);
    }
}

/* connͷ֪֪ͨͨfastͷ */
void fast_conn_release(struct nf_conn *ct, int mark)
{
    //ֻfast_localfast_fw
    if ((ct->fast_ct.isFast == FAST_CT_LOCAL4 || ct->fast_ct.isFast == FAST_CT_LOCAL6) && (mark & RELEASE_ALL_SK))
    {
        spin_lock_bh(&fastlocal_spinlock);
        fast_local_conn_release(ct);
        spin_unlock_bh(&fastlocal_spinlock);
    }
    else if ((ct->fast_ct.isFast == FAST_CT_FW4 || ct->fast_ct.isFast == FAST_CT_FW6) && (mark & RELEASE_ALL_DST))
    {
        spin_lock_bh(&fast_fw_spinlock);
        fast_fw_conn_release(ct);
        spin_unlock_bh(&fast_fw_spinlock);
    }
}

/* socketͷ֪֪ͨͨfastͷ */
void fast_sock_release(struct sock *sk)
{
    spin_lock_bh(&fastlocal_spinlock);
    fast_local_sock_release(sk);
    spin_unlock_bh(&fastlocal_spinlock);
}

/* dst_entryͷ֪֪ͨͨfastͷ */
void fast_dst_entry_release(struct dst_entry * dst)
{
    spin_lock_bh(&fast_fw_spinlock);
    fast_fw_dst_entry_release(dst);
    spin_unlock_bh(&fast_fw_spinlock);
}

/* ͷfastģʽпתϢ: ֻctǺdstskģͨctѯ */
void fast_release_all(int mark)
{
    int hash = 0;
    struct nf_conntrack_tuple_hash *h;
    struct hlist_nulls_node *n;
    struct nf_conn *ct;

    rcu_read_lock();
    for (hash = 0; hash < init_net.ct.htable_size; hash++) {
        local_bh_disable();
        hlist_nulls_for_each_entry_rcu(h, n, &init_net.ct.hash[hash], hnnode) {
            if (h)
            {
                ct = nf_ct_tuplehash_to_ctrack(h);
                NF_CT_ASSERT(ct);
                if (unlikely(!atomic_inc_not_zero(&ct->ct_general.use)))
                    continue;

                //ͷŴؿתϢ
                fast_conn_release(ct, mark);
                
                nf_ct_put(ct);
            }
        }
        local_bh_enable();
    }
    rcu_read_unlock();
}

/**** ²¾fastģʽõĺ ****/

//ȼòͬεĹӺĿǰĲǸߵȼĹӺֵ󣬵͵ȼĹӺҲһڣ
//ԽĳЩ豸ûиߵȼĹӺòԽɹӺƥʧܵĿܣƿ
void set_fast_level_cb(int param)
{
    //ݿתùⲿúָ
    if (param == FAST_CLOSE || param == FAST_CLOSE_KEEP_LINK)  //رտת
    {
        fast_from_softirq = NULL;
        fast_from_driver = NULL;
    }
    else if (param == FAST_NET_CORE) //ں˲תFAST_NEWֻ֧жеÿת
    {
        fast_from_softirq = try_fast_for_netcoredata;
        fast_from_driver = NULL;
    }
    //net_devicenet_deviceIPж
    else if (param == FAST_NET_DEVICE)
    {
        fast_from_softirq = try_fast_for_netcoredata;
        fast_from_driver = try_fast_for_macdata;
    }
    //else
        //print_sun(SUN_ERR,"fastnat_level error, shoud be 0~2!\n");
}

/* øӹܵĿתú */
void set_fast_switch_cb(unsigned long param)
{
    //¾ɿתʹõĲͬipv4ipv6ӿ
    if (fast_test_bit(FAST_TYPE_VERSION_BIT, fast_switch)) //µfastģʽ
    {
        //µfastģʽ: IPv4ؿתص
        if (fast_test_bit(FAST_TYPE_FW4_BIT, fast_switch))
            fast_fw4_proc = fast4_fw_recv;
        else
            fast_fw4_proc = NULL;

        //µfastģʽ: IPv6ؿתص
        if (fast_test_bit(FAST_TYPE_FW6_BIT, fast_switch))
            fast_fw6_proc = fast6_fw_recv;
        else
            fast_fw6_proc = NULL;

        //IPv4ؿתص
        if (fast_test_bit(FAST_TYPE_LOCAL4_BIT, fast_switch)){
            fast_local4_proc        = fast_local4_recv;
            fast_local4_output_proc = fast_local_output;
        }
        else
        {
            fast_local4_proc        = NULL;
            fast_local4_output_proc = NULL;
        }

        //IPv6ؿתص
        if (fast_test_bit(FAST_TYPE_LOCAL6_BIT, fast_switch)){
            fast_local6_proc        = fast_local6_recv;
            fast_local6_output_proc = fast_local_output_v6;
        }
        else
        {
            fast_local6_proc        = NULL;
            fast_local6_output_proc = NULL;
        }

        //תص
        if (fast_test_bit(FAST_TYPE_BR_BIT, fast_switch))
            fast_br_proc = fast_br;
        else
            fast_br_proc = NULL;
        
        fast_nat4_proc = NULL;
        fast_nat6_proc = NULL;
    }
    else //ϵfastģʽ
    {
        //ϵfastģʽ: IPv4ؿתص
        //if (fast_test_bit(FAST_TYPE_FW4_BIT, fast_switch))
            fast_nat4_proc = fast_nat_recv;
        
        //else
            //fast_nat4_proc = NULL;
        //ϵfastģʽ: IPv6ؿתص
        //if (fast_test_bit(FAST_TYPE_FW6_BIT, fast_switch))
            fast_nat6_proc = fast6_recv;
        //else
            //fast_nat6_proc = NULL;

        fast_br_proc = fast_br;
        fast_local4_proc         = NULL;
        fast_local4_output_proc  = NULL;
        fast_local6_proc         = NULL;
        fast_local6_output_proc  = NULL;
        fast_fw4_proc = NULL;
        fast_fw6_proc = NULL;
    }
}

void fast_level_change(int new_level)
{
    int old_level = 0;
    
    old_level = fastnat_level;
    
    if (old_level == new_level)
        return;
    
    fastnat_level = new_level;
    
    //µfastnat levelص
    set_fast_level_cb(fastnat_level);
    
     //fastnatرգϢ
    if (fastnat_level == FAST_CLOSE || fastnat_level == FAST_CLOSE_KEEP_LINK)
    {
        if (!fast_test_bit(FAST_TYPE_VERSION_BIT, fast_switch))
        {
            fastnat_cleanup_links();
            fast6_cleanup_links();

    		fast_entry_del_cleanup();
        } else {
            fast_release_all(RELEASE_ALL_DST | RELEASE_ALL_SK);
        }
    }
}

void fast_switch_change(unsigned long new_switch)
{
    unsigned long old_switch = fast_switch;
    
    if (old_switch == new_switch)
        return;

    fast_switch = new_switch;
    
    //ӹܿתλͼأӹܻص
    set_fast_switch_cb(fast_switch);

    //ӹܿתӴ򿪵رյģҪؿתϢ
    //ϵfastеµfastҪfastؿת
    if (!fast_test_bit(FAST_TYPE_VERSION_BIT, old_switch) && fast_test_bit(FAST_TYPE_VERSION_BIT, new_switch))
    {
        //ϵfastIPv4IPv6ķֿ
        //if (fast_test_bit(FAST_TYPE_FW4_BIT, old_switch))
             fastnat_cleanup_links();

        //if (fast_test_bit(FAST_TYPE_FW6_BIT, old_switch))
            fast6_cleanup_links();
			
			fast_entry_del_cleanup();
    }
    //µfastеɵfastҪfastؿת
    else if (fast_test_bit(FAST_TYPE_VERSION_BIT, old_switch) && !fast_test_bit(FAST_TYPE_VERSION_BIT, new_switch))
    {
        fast_release_all(RELEASE_ALL_DST | RELEASE_ALL_SK);
    }
    
    if (fast_test_bit(FAST_TYPE_VERSION_BIT, new_switch) && (!fast_test_bit(FAST_TYPE_FW4_BIT, new_switch) || !fast_test_bit(FAST_TYPE_FW6_BIT, new_switch))){
        printk("ct clean dst\n");
        fast_release_all(RELEASE_ALL_DST);
    }
    if (fast_test_bit(FAST_TYPE_VERSION_BIT, new_switch) && (!fast_test_bit(FAST_TYPE_LOCAL4_BIT, new_switch) || !fast_test_bit(FAST_TYPE_LOCAL6_BIT, new_switch))){
        printk("ct clean sk\n");
        fast_release_all(RELEASE_ALL_SK);
    }
}
/* function: ip_checksum_add
 * adds data to a checksum
 * current_value - the current checksum (or 0 to start a new checksum)
 * data        - the data to add to the checksum
 * len         - length of data
 */
uint32_t ip_checksum_add(uint32_t current_value, const void *data, int len) {
  uint32_t checksum = current_value;
  int left = len;
  const uint16_t *data_16 = data;

  while(left > 1) {
    checksum += *data_16;
    data_16++;
    left -= 2;
  }
  if(left) {
    checksum += *(uint8_t *)data_16;
  }

  return checksum;
}

/* function: ip_checksum_fold
 * folds a 32-bit partial checksum into 16 bits
 * temp_sum - sum from ip_checksum_add
 * returns: the folded checksum in network byte order
 */
uint16_t ip_checksum_fold(uint32_t temp_sum) {
  while(temp_sum > 0xffff)
    temp_sum = (temp_sum >> 16) + (temp_sum & 0xFFFF);

  return temp_sum;
}

/* function: ip_checksum_finish
 * folds and closes the checksum
 * temp_sum - sum from ip_checksum_add
 * returns: a header checksum value in network byte order
 */
uint16_t ip_checksum_finish(uint32_t temp_sum) {
  return ~ip_checksum_fold(temp_sum);
}

/* function: ip_checksum
 * combined ip_checksum_add and ip_checksum_finish
 * data - data to checksum
 * len  - length of data
 */
uint16_t ip_checksum(const void *data, int len) {
  uint32_t temp_sum;

  temp_sum = ip_checksum_add(0,data,len);
  return ip_checksum_finish(temp_sum);
}

/* function: ipv6_pseudo_header_checksum
 * calculate the pseudo header checksum for use in tcp/udp/icmp headers
 * ip6      - the ipv6 header
 * len      - the transport length (transport header + payload)
 * protocol - the transport layer protocol, can be different from ip6->ip6_nxt for fragments
 */
uint32_t ipv6_pseudo_header_checksum(const struct ipv6hdr *ip6, uint16_t len, uint8_t protocol) {
  uint32_t checksum_len, checksum_next;
  checksum_len = htonl((uint32_t) len);
  checksum_next = htonl(protocol);

  uint32_t current_value = 0;
  current_value = ip_checksum_add(current_value, &(ip6->saddr), sizeof(struct in6_addr));
  current_value = ip_checksum_add(current_value, &(ip6->daddr), sizeof(struct in6_addr));
  current_value = ip_checksum_add(current_value, &checksum_len, sizeof(checksum_len));
  current_value = ip_checksum_add(current_value, &checksum_next, sizeof(checksum_next));

  return current_value;
}

/* function: ipv4_pseudo_header_checksum
 * calculate the pseudo header checksum for use in tcp/udp headers
 * ip      - the ipv4 header
 * len     - the transport length (transport header + payload)
 */
uint32_t ipv4_pseudo_header_checksum(const struct iphdr *ip, uint16_t len) {
  uint16_t temp_protocol, temp_length;

  temp_protocol = htons(ip->protocol);
  temp_length = htons(len);

  uint32_t current_value = 0;
  current_value = ip_checksum_add(current_value, &(ip->saddr), sizeof(uint32_t));
  current_value = ip_checksum_add(current_value, &(ip->daddr), sizeof(uint32_t));
  current_value = ip_checksum_add(current_value, &temp_protocol, sizeof(uint16_t));
  current_value = ip_checksum_add(current_value, &temp_length, sizeof(uint16_t));

  return current_value;
}

/* function: ip_checksum_adjust
 * calculates a new checksum given a previous checksum and the old and new pseudo-header checksums
 * checksum    - the header checksum in the original packet in network byte order
 * old_hdr_sum - the pseudo-header checksum of the original packet
 * new_hdr_sum - the pseudo-header checksum of the translated packet
 * returns: the new header checksum in network byte order
 */
uint16_t ip_checksum_adjust(uint16_t checksum, uint32_t old_hdr_sum, uint32_t new_hdr_sum) {
  // Algorithm suggested in RFC 1624.
  // http://tools.ietf.org/html/rfc1624#section-3
  checksum = ~checksum;
  uint16_t folded_sum = ip_checksum_fold(checksum + new_hdr_sum);
  uint16_t folded_old = ip_checksum_fold(old_hdr_sum);
  if (folded_sum > folded_old) {
    return ~(folded_sum - folded_old);
  } else {
    return ~(folded_sum - folded_old - 1);  // end-around borrow
  }
}

//¼DST_NOCACHE־dstֵĴ
int no_cache = 0;
//¼ʹdstʱdst->neighbourΪյĴ
int no_neighbour = 0;
struct dst_entry * dst_get_by_ct(struct nf_conn * ct, int dir)
{
    struct dst_entry *dst;

    rcu_read_lock();
    dst = rcu_dereference_protected(ct->fast_ct.fast_dst[dir], 1);
    if (dst && dst->_neighbour && likely(!(dst->flags & DST_NOCACHE)))
        dst_use(dst, jiffies);
    else {
        dst = NULL;
        if (dst && likely(dst->flags & DST_NOCACHE))
            no_cache++;
    }
    rcu_read_unlock();
    return dst;
}
#if _USE_VEHICLE_DC
void fast_update_status_by_capct(void)
{
	fast_entry_t *entry, *next;
	unsigned int pkt0=0,len0=0,pkt1=0,len1=0;
	void *nfct = NULL;
	unsigned char in=0, out=0;

	spin_lock_bh(&fastnat_spinlock);
	for(entry = working_list.next; entry; entry = next)
	{
		next = entry->next;
		if(pkt0 || len0 || pkt1 || len1){
			cap_conntrack_update(nfct, pkt0, len0, pkt1, len1, in, out);
			pkt0 = 0;
			len0 = 0;
			pkt1 = 0;
			len1 = 0;
		}
		if(entry->cap_nfct && entry->data[0].zvnet_id && entry->data[1].zvnet_id){
			pkt0 = atomic_read(&entry->data[0].pkt);
			len0 = atomic_read(&entry->data[0].len);
			pkt1 = atomic_read(&entry->data[1].pkt);
			len1 = atomic_read(&entry->data[1].len);
			nfct = entry->cap_nfct;
			in = entry->data[1].zvnet_id;
			out = entry->data[0].zvnet_id;
			atomic_set(&entry->data[0].pkt, 0);
			atomic_set(&entry->data[0].len, 0);
			atomic_set(&entry->data[1].pkt, 0);
			atomic_set(&entry->data[1].len, 0);
		}
	}
	spin_unlock_bh(&fastnat_spinlock);
	if(pkt0 || len0 || pkt1 || len1)
		cap_conntrack_update_end(nfct, pkt0, len0, pkt1, len1, in, out);
}
#endif
/*fastʼ*/
static int __init
tsp_fast_init(void)
{
    int ret4 = 0, ret6 = 0;
    
    memset(zeromac, 0, sizeof(zeromac));
    
    spin_lock_init(&fast_fw_spinlock);
    spin_lock_init(&fast_del_spinlock);
	
    //רslab
    fast_head_cache = kmem_cache_create("fast_head_cache",
                          sizeof(struct fast_entry_s),
                          0,
                          SLAB_HWCACHE_ALIGN|SLAB_PANIC,
                          NULL);

    //ֱipv4ipv6ĳʼ
    ret4 = tsp_fastnat_init();
    ret6 = tsp_fast6_init();
    fast4_fw_init();
    fast6_fw_init();
    
    if ((ret4 != 0) && (ret6 != 0))
        return -EINVAL;
    
    /*ע֪ͨ*/
    register_netdevice_notifier(&fast_dev_notifier);
    register_inetaddr_notifier(&fast_inet_notifier);

    //תƽ̨procļʼ
    set_fast_level_cb(fastnat_level);
    set_fast_switch_cb(fast_switch);
    fast_conntrack_init_proc();
    net_adapter_init_proc();
    skb_queue_head_init(&fast_txq);
    fast_tx_bh.func = fast_bh;
    fast_tx_bh.data = (unsigned long)&fast_txq;
	
    return 0;
}

static void __exit
tsp_fast_cleanup(void)
{
    set_fast_level_cb(FAST_CLOSE);
    set_fast_switch_cb(0);
    unregister_netdevice_notifier(&fast_dev_notifier);
    unregister_inetaddr_notifier(&fast_inet_notifier);

    //ֱipv4ipv6ע
    tsp_fastnat_cleanup();
    tsp_fast6_cleanup();
    fast4_fw_cleanup();
    fast6_fw_cleanup();
    tasklet_kill(&fast_tx_bh);
}

//module_init(fast_proc_init); 
late_initcall(tsp_fast_init);
module_exit(tsp_fast_cleanup);

