/* * Copyright (c) 2011 Qualcomm Atheros, Inc. * */

#include <linux/in.h>
#include <linux/ip.h>
#include <linux/udp.h>
#include <linux/tcp.h>
#include <linux/icmp.h>
#include <net/ip.h>
#include <linux/if_arp.h>

#include <linux/inetdevice.h>
#include <linux/netfilter.h>
#include <linux/netfilter_ipv4.h>
#include <linux/netfilter_arp.h>
#include <linux/netfilter_ipv4/ip_tables.h>
#include <linux/netfilter/xt_multiport.h>
#include <linux/netfilter/xt_iprange.h>
#include <linux/netfilter/nf_conntrack_tcp.h>
#include <net/checksum.h>
#include <net/dsfield.h>
#include <net/route.h>
#include <net/netfilter/nf_nat.h>
#include <net/netfilter/nf_nat_core.h>
#include <net/netfilter/nf_nat_rule.h>
#include <net/netfilter/nf_conntrack_acct.h>
#include <net/netfilter/nf_conntrack_helper.h>
#include <linux/module.h>

#include <linux/proc_fs.h>

#include <net/SI/fastnat.h>
#include <net/SI/fast_common.h>

MODULE_LICENSE("GPL");

/* ***************** ipv4 תر ************************* */
spinlock_t fastnat_spinlock;          //Ĳ
fast_list_t working_list = {0};
struct hlist_nulls_head *working_hash;
extern int speedMode;
extern struct sk_buff_head fast_txq;
extern struct tasklet_struct fast_tx_bh;
/* ****************************  ************************ */
extern int zvnet_get_index_by_netdev(struct net_device *net);


/* **************************** ʵ ************************ */


int fast_nat_check(unsigned char *data)
{
    struct iphdr  *iph  = NULL;
    struct udphdr *udph = NULL;
    struct tcphdr *tcph = NULL;
    struct nf_conntrack_tuple tuple = {0};
    fast_entry_data_t *nat_entry_data = NULL;
	
    if (!data)
        return 0;
    iph = (struct iphdr *)data;

    /* only tcp/udp */
    if (IPPROTO_UDP == iph->protocol){
        udph = (struct udphdr *)(data + iph->ihl * 4);
        tuple.src.u.udp.port = udph->source;
        tuple.dst.u.udp.port = udph->dest;
    }else if (IPPROTO_TCP == iph->protocol){
        tcph = (struct tcphdr *)(data + iph->ihl * 4);
        tuple.src.u.tcp.port = tcph->source;
        tuple.dst.u.tcp.port = tcph->dest;
    }else{
        return 0;
    }
	
    tuple.src.l3num = AF_INET;
    tuple.src.u3.ip = iph->saddr;
    tuple.dst.u3.ip = iph->daddr;
    tuple.dst.protonum = iph->protocol;
    tuple.dst.dir = IP_CT_DIR_ORIGINAL;

    rcu_read_lock();
    nat_entry_data = fast_find_entry_data(working_hash, &tuple);
	rcu_read_unlock();
    return (nat_entry_data != NULL);
}

/*ȡԪϢ*/
int fast_nat_get_tuple(struct sk_buff *skb, struct nf_conntrack_tuple *tuple)
{
    struct iphdr  *iph  = NULL;
    struct udphdr *udph = NULL;
    struct tcphdr *tcph = NULL;

    if (!skb || !tuple)
    {
        return -1;
    }

    /* only IP packets */    
    if (htons(ETH_P_IP) != skb->protocol)
    {
        return -1;
    }

    iph = (struct iphdr *)skb->data;

    /* not deal with fragment packets now */    
    if (ntohs(iph->frag_off) & (IP_MF | IP_OFFSET))
    {
        skbinfo_add(NULL,SKB_FRAG);
        return -1;
    }

    if (iph->ttl <= 1)
    {
        return -1;
    }

    memset(tuple, 0, sizeof(struct nf_conntrack_tuple));

    /* only tcp/udp */
    if (IPPROTO_UDP == iph->protocol)
    {
        udph = (struct udphdr *)(skb->data + iph->ihl * 4);
        tuple->src.u.udp.port = udph->source;
        tuple->dst.u.udp.port = udph->dest;
        skb_udpnum++;
    }
    else if (IPPROTO_TCP == iph->protocol)
    {
        tcph = (struct tcphdr *)(skb->data + iph->ihl * 4);
        tuple->src.u.tcp.port = tcph->source;
        tuple->dst.u.tcp.port = tcph->dest;
        skb_tcpnum++;
    }
    else
    {
        return -1;
    }

    tuple->src.l3num = AF_INET;
    tuple->src.u3.ip = iph->saddr;
    tuple->dst.u3.ip = iph->daddr;
    tuple->dst.protonum = iph->protocol;
    tuple->dst.dir = IP_CT_DIR_ORIGINAL;

    return 0;
}

//˴Ҫֺdev_xmit_completeһ
//inline޷ȡļУֻfastnatfast6һ
static inline bool start_xmit_complete(int rc)
{
    /*
     * Positive cases with an skb consumed by a driver:
     * - successful transmission (rc == NETDEV_TX_OK)
     * - error while transmitting (rc < 0)
     * - error while queueing to a different device (rc & NET_XMIT_MASK)
     */
    if (likely(rc < NET_XMIT_MASK))
        return true;

    return false;
}
#ifndef CONFIG_PREEMPT_RT_FULL
extern int *vir_addr_ddrnet;
#endif
struct in6_addr g_plat_subnet;
struct in6_addr g_ipv6_local_subnet;
struct in_addr g_ipv4_local_subnet;
struct net_device *g_xlat_dev;
//ipv4ݰĿٴhashRCUƽбܵspinб
int fast_nat_recv(struct sk_buff *skb)
{
    struct nf_conntrack_tuple tuple;
    fast_entry_data_t *nat_entry_data = NULL;
    fast_entry_t *nat_entry = NULL;
    struct iphdr *iph = NULL;
    struct udphdr *udph = NULL;
    struct tcphdr *tcph = NULL;
    __sum16 *cksum = NULL;
    __be32 *oldip = NULL;
    __be16 *oldport = NULL;
    struct net_device *dev = NULL;
    u_int32_t skip_nat = 0;
	struct sk_buff *skb2 = NULL;
	struct nf_conn_counter *acct = NULL;
	int zvnet_id = -1;

#if 0//#if !FASTNAT_SUN
    if(!(dev = skb->dev) || !(in_dev = (struct in_device *)(dev->ip_ptr)) || !(in_dev->ifa_list))
    {
        XDBG_PRINT(XDBG_FASTNAT_PKT, XDBGLV_INFO, "%s not L3if\n", (dev? dev->name : "null"));
        if(dev==NULL)
            printk("skb->dev=null\n");
        else if(dev->ip_ptr==NULL)
            printk("in_dev=null,name=%s\n",dev->name);
        else
            printk("ifa_list=null\n");
        return 0;
    }
#endif
#ifndef CONFIG_PREEMPT_RT_FULL    
    /*ⲿʱpsbufַϷ*/
    if(skb->isExtern && ((unsigned long )skb->head < (unsigned long)vir_addr_ddrnet || (unsigned long )skb->head > ((unsigned long)vir_addr_ddrnet+PSBUFFER_MEM_SIZE)))
        panic("addr is not PSBUF mem!!!");
#endif
    iph = (struct iphdr *)skb->data;
    if (iph->protocol != IPPROTO_TCP && iph->protocol != IPPROTO_UDP)
        goto err_out;

    if (fast_nat_get_tuple(skb, &tuple) < 0)
    {
        //print_sun(SUN_DBG, "fast_nat_get_tuple  ERR  !!!\n");
        goto err_out;
    }

    rcu_read_lock();
    //spin_lock_bh(&fastnat_spinlock);
    nat_entry_data = fast_find_entry_data(working_hash, &tuple);
    if (nat_entry_data == NULL)
    {
        rcu_read_unlock();
        //spin_unlock_bh(&fastnat_spinlock);
        //print_sun(SUN_DBG, "fast_nat_find  ERR  !!!\n");
        goto err_out;
    }
    dev = nat_entry_data->outdev;
    /*Ƿ񳬹豸MTU*/
    if (!dev || (skb->len > dev->mtu))
    {
        skbinfo_add(NULL, SKB_OVER_MTU);
        rcu_read_unlock();
        //spin_unlock_bh(&fastnat_spinlock);
        //print_sun(SUN_DBG, "fast_nat_recv outdev mtu ERR !!!\n");
        goto err_out;
    }

    //شİֱͷŲ
    if (strcmp(skb->dev->name, dev->name) == 0)
    {
        skbinfo_add(NULL, SKB_LOOP);
        rcu_read_unlock();
        //spin_unlock_bh(&fastnat_spinlock);   /*add by jiangjing*/
        printk("loopback skb %s, free skb\n", dev->name);
        kfree_skb(skb);
        return 1;
    }
    
    nat_entry = fast_data_to_entry(nat_entry_data);
    if (!nat_entry)
    {
        rcu_read_unlock();
        //spin_unlock_bh(&fastnat_spinlock);
        //print_sun(SUN_DBG, "fast_nat_recv fast_nat_data_to_entry null !!!\n");
        goto err_out;
    }

    /* ֻе˫ӶɹFASTNAT߱׼ */
    if ((nat_entry->flags != FAST_ALL_DIR) && (IPPROTO_UDP != iph->protocol))
    {
        rcu_read_unlock();
        //spin_unlock_bh(&fastnat_spinlock);
        //print_sun(SUN_DBG, "fast_nat_recv flags is not FAST_ALL_DIR !!!\n");
        goto err_out;
    }

    //tcpdumpin_sq(skb);
#if _USE_VEHICLE_DC
    zvnet_id = zvnet_get_index_by_netdev(skb->indev);
	if(nat_entry->fwd_entry){
		fast_entry_data_t *cap_entry_data = &nat_entry->fwd_entry->data[nat_entry_data->tuplehash.tuple.dst.dir];
		if(zvnet_id < 0 && cap_entry_data->hh_flag &&
			(__nf_ct_tuple_src_equal(&cap_entry_data->tuplehash.tuple, &nat_entry_data->tuplehash.tuple) ||
			__nf_ct_tuple_dst_equal(&cap_entry_data->tuplehash.tuple, &nat_entry_data->tuplehash.tuple))){
			int cap_flag = -1;
			u_int32_t nat_addr;
			u_int16_t nat_port;
			dev = cap_entry_data->outdev;
			if(!__nf_ct_tuple_src_equal(&cap_entry_data->tuplehash.tuple, &nat_entry_data->tuplehash.tuple)){
				cap_flag = 1;
				nat_addr = cap_entry_data->tuplehash.tuple.src.u3.ip;
				nat_port = cap_entry_data->tuplehash.tuple.src.u.all;
			} else if(!__nf_ct_tuple_dst_equal(&cap_entry_data->tuplehash.tuple, &nat_entry_data->tuplehash.tuple)){
				cap_flag = 0;
				nat_addr = cap_entry_data->tuplehash.tuple.dst.u3.ip;
				nat_port = cap_entry_data->tuplehash.tuple.dst.u.all;
			}
			if (!(skb2 = fast_expand_headroom(skb, dev))){
				rcu_read_unlock();
				return 1;
			}
			if(skb2 != skb){
				iph = (struct iphdr *)skb2->data;
				skb = skb2;
			}
			fast_tcpdump(skb);
			//ץУݻclonefastɹҪıdataݣҪcopyһ
			if (skb_cloned(skb) && pskb_expand_head(skb, 0, 0, GFP_ATOMIC)){
				rcu_read_unlock();
				printk("pskb_expand_head0 skb failed, free skb\n");
				kfree_skb(skb);
				return 1;
			}
			
			/*ж*/
			if(IPPROTO_TCP == iph->protocol)
				packet_lost_track(skb, nat_entry->ct);
			skb_reset_network_header(skb);
			skb->isFastnat = 1;
			if (cap_flag >= 0){
				if (IPPROTO_TCP == iph->protocol){
					tcph = (struct tcphdr *)(skb->data + iph->ihl * 4);
					cksum = &tcph->check;
					oldport = cap_flag ? (&tcph->source): (&tcph->dest);
				}
				else if (IPPROTO_UDP == iph->protocol){
					udph = (struct udphdr *)(skb->data + iph->ihl * 4);
					cksum = &udph->check;
					oldport = cap_flag ? (&udph->source): (&udph->dest);
				}
				oldip = cap_flag? (&iph->saddr) : (&iph->daddr);
				if (cksum != NULL && (0!=*cksum || IPPROTO_TCP == iph->protocol)){
					inet_proto_csum_replace4(cksum, skb, *oldip, nat_addr, 0);
					inet_proto_csum_replace2(cksum, skb, *oldport, nat_port, 0);
				}
				csum_replace4(&iph->check, *oldip, nat_addr);
				if(oldport)
				*oldport = nat_port;
				*oldip = nat_addr;
			}
			else
			{
				if (IPPROTO_TCP == iph->protocol)
				{
					tcph = (struct tcphdr *)(skb->data + iph->ihl * 4);
				}
			}
			skb->priority = cap_entry_data->priority;
			skb->mark = cap_entry_data->mark;
			if (nat_entry_data->tuplehash.tuple.dst.dir == IP_CT_DIR_ORIGINAL){
				nat_entry->ct->packet_info[IP_CT_DIR_ORIGINAL].packets++;
				nat_entry->ct->packet_info[IP_CT_DIR_ORIGINAL].bytes += skb->len;
				nat_entry->fwd_entry->ct->packet_info[IP_CT_DIR_ORIGINAL].packets++;
				nat_entry->fwd_entry->ct->packet_info[IP_CT_DIR_ORIGINAL].bytes += skb->len;
			} else if (nat_entry_data->tuplehash.tuple.dst.dir == IP_CT_DIR_REPLY){
				nat_entry->ct->packet_info[IP_CT_DIR_REPLY].packets++;
				nat_entry->ct->packet_info[IP_CT_DIR_REPLY].bytes += skb->len;
				nat_entry->fwd_entry->ct->packet_info[IP_CT_DIR_REPLY].packets++;
				nat_entry->fwd_entry->ct->packet_info[IP_CT_DIR_REPLY].bytes += skb->len;
			} else {
				printk("fastnat packet error\n");
			}
			{
				enum ip_conntrack_info ctinfo;
				if (nat_entry_data->tuplehash.tuple.dst.dir == IP_CT_DIR_ORIGINAL)
					ctinfo = IP_CT_ESTABLISHED;
				else 
					ctinfo = IP_CT_ESTABLISHED_REPLY;
				acct = nf_conn_acct_find(nat_entry->ct);
				if (acct) {
					atomic64_inc(&acct[CTINFO2DIR(ctinfo)].packets);
					atomic64_add(skb->len, &acct[CTINFO2DIR(ctinfo)].bytes);
				}
				acct = nf_conn_acct_find(nat_entry->fwd_entry->ct);
				if (acct) {
					atomic64_inc(&acct[CTINFO2DIR(ctinfo)].packets);
					atomic64_add(skb->len, &acct[CTINFO2DIR(ctinfo)].bytes);
				}
				atomic_inc(&nat_entry_data->pkt);
				atomic_add(skb->len, &nat_entry_data->len);
				if(atomic_read(&nat_entry_data->len) > 1000000){
					cap_conntrack_update_end(nat_entry->cap_nfct,
						atomic_read(&nat_entry->data[0].pkt),atomic_read(&nat_entry->data[0].len),
						atomic_read(&nat_entry->data[1].pkt),atomic_read(&nat_entry->data[1].len),
						nat_entry->data[1].zvnet_id,nat_entry->data[0].zvnet_id);
						spin_lock_bh(&fastnat_spinlock);
						atomic_set(&nat_entry->data[0].pkt, 0);
						atomic_set(&nat_entry->data[0].len, 0);
						atomic_set(&nat_entry->data[1].pkt, 0);
						atomic_set(&nat_entry->data[1].len, 0);
						spin_unlock_bh(&fastnat_spinlock);
				}
			}
			if (fastnat_level == FAST_NET_DEVICE){
				if (nat_entry_data->indev){
					nat_entry_data->indev->stats.rx_packets++;
					nat_entry_data->indev->stats.rx_bytes += skb->len;
				}
				if (cap_entry_data->indev){
					cap_entry_data->indev->stats.rx_packets++;
					cap_entry_data->indev->stats.rx_bytes += skb->len;
				}
				if(skb->indev && nat_entry_data->indev != skb->indev && cap_entry_data->indev != skb->indev ){
					skb->indev->stats.rx_packets++;
					skb->indev->stats.rx_bytes += skb->len;
				}
			}
			skb->dev = dev;
			skb_push(skb, ETH_HLEN);
			//if (cap_entry_data->hh_flag)
			memcpy(skb->data, cap_entry_data->hh_data, ETH_HLEN);
			/*ӳʱ*/
			if (IPPROTO_TCP == iph->protocol){
				mod_timer(&nat_entry->timeout, jiffies + tcp_timeouts[nat_entry->ct->proto.tcp.state]);
				mod_timer(&nat_entry->fwd_entry->timeout, jiffies + tcp_timeouts[nat_entry->fwd_entry->ct->proto.tcp.state]);
				update_tcp_timeout(nat_entry, nat_entry_data, tcph);
				update_tcp_timeout(nat_entry->fwd_entry, cap_entry_data, tcph);
		 
				if(ackfilter(skb, nat_entry, &working_list) == 1 || ackfilter(skb, nat_entry->fwd_entry, &working_list) == 1){
					rcu_read_unlock();
					//spin_unlock_bh(&fastnat_spinlock);
					return 1;
				}
			}
			else if (IPPROTO_UDP == iph->protocol){
				/*udp*/
				if (fast_test_bit(IPS_SEEN_REPLY_BIT, nat_entry->ct->status)){
					mod_timer(&nat_entry->timeout, jiffies + fast_udp_timeout_stream);
					mod_timer(&nat_entry->fwd_entry->timeout, jiffies + fast_udp_timeout_stream);
				}else{
					mod_timer(&nat_entry->timeout, jiffies + fast_udp_timeout);
					mod_timer(&nat_entry->fwd_entry->timeout, jiffies + fast_udp_timeout);
				}
			}
			if (skb->dev->flags & IFF_UP){
				if (skb->dev->type == ARPHRD_PPP || skb->dev->type == ARPHRD_NONE)
					skb_pull(skb, ETH_HLEN);
				skb->now_location |= FASTNAT_SUCC;
				if(unlikely(skb->dev->type == ARPHRD_NONE)){
					struct ipv6hdr header = {0};
					const struct iphdr *old_header = (struct iphdr *)skb->data;
					unsigned int len = skb->len;
					int rc = -ENOMEM;
				
					header.version = 6;
					header.payload_len = htons(ntohs(old_header->tot_len) - sizeof(struct iphdr));
					header.nexthdr = old_header->protocol;
					header.hop_limit = old_header->ttl;
					header.saddr = g_ipv6_local_subnet;
					header.daddr = g_plat_subnet;
					header.daddr.s6_addr32[3] = old_header->daddr;
					skb_push(skb, sizeof(struct ipv6hdr) - sizeof(struct iphdr));
					memcpy(skb->data, &header, sizeof(struct ipv6hdr));
					if (!(skb2 = fast_expand_headroom(skb, g_xlat_dev))){
						rcu_read_unlock();
						return 1;
					}
					if(skb2 != skb)
						skb = skb2;
					skb_push(skb, ETH_HLEN);
					skb->dev = g_xlat_dev;
				}
				if (fastnat_level == FAST_NET_DEVICE){
					if(speedMode == 0)
						dev_queue_xmit(skb);
					else if(skb->dev->netdev_ops && skb->dev->netdev_ops->ndo_start_xmit
						&& skb->dev->netdev_ops->ndo_select_queue == NULL  
						&& (skb->dev->type != ARPHRD_PPP)){
						int rc = -ENOMEM;
						rc = skb->dev->netdev_ops->ndo_start_xmit(skb, skb->dev);
						if (!dev_xmit_complete(rc)) {
							skb->dev->stats_dbg.tx_dropped++;
							skb->dev->stats.tx_dropped++;
							skbinfo_add(NULL,SKB_ERRFREE);
							kfree_skb(skb);
						}
					}
					else if(skb->dev->type == ARPHRD_PPP){
						skb_queue_tail(&fast_txq, skb);
						tasklet_schedule(&fast_tx_bh);
					}
					else
						dev_queue_xmit(skb);
				}
				else if (fastnat_level == FAST_NET_CORE)
					dev_queue_xmit(skb);
				nat_entry_data->packet_num++;
				cap_entry_data->packet_num++;
			}
			else
				kfree_skb(skb);
			rcu_read_unlock();
			return 1;
		}
	}else{
		if(unlikely(fastbr_level != 1)){
			if(skb->nfct_bak && skb->capNfct){
				struct nf_conn *ct_fwd = (struct nf_conn *)skb->nfct_bak;
				if (ct_fwd->fast_entry){
					fast_entry_t *nat_entry_fwd = (fast_entry_t *)ct_fwd->fast_entry;
					if (nat_entry_fwd){
						/*skbѾƻˣfast¼capct*/
						spin_lock_bh(&fastnat_spinlock);
						nat_entry_fwd->fwd_entry = nat_entry;
						nat_entry_fwd->cap_nfct = skb->capNfct;
						nat_entry->fwd_entry = nat_entry_fwd;
						nat_entry->cap_nfct = skb->capNfct;
						atomic_set(&nat_entry->data[0].pkt, 0);
						atomic_set(&nat_entry->data[0].len, 0);
						atomic_set(&nat_entry->data[1].pkt, 0);
						atomic_set(&nat_entry->data[1].len, 0);
						atomic_set(&nat_entry_fwd->data[0].pkt, 0);
						atomic_set(&nat_entry_fwd->data[0].len, 0);
						atomic_set(&nat_entry_fwd->data[1].pkt, 0);
						atomic_set(&nat_entry_fwd->data[1].len, 0);
						spin_unlock_bh(&fastnat_spinlock);
						skb->capNfct = NULL;
						if(zvnet_id >= 0 && nat_entry_data->zvnet_id == 0){
							nat_entry_data->zvnet_id = zvnet_id+1;
							if(nat_entry_data->tuplehash.tuple.dst.dir == IP_CT_DIR_ORIGINAL){
								nat_entry->data[IP_CT_DIR_REPLY].zvnet_id = skb->zvnet_id;
								nat_entry_fwd->data[IP_CT_DIR_ORIGINAL].zvnet_id = nat_entry->data[IP_CT_DIR_ORIGINAL].zvnet_id;
								nat_entry_fwd->data[IP_CT_DIR_REPLY].zvnet_id = nat_entry->data[IP_CT_DIR_REPLY].zvnet_id;
							}else{
								nat_entry->data[IP_CT_DIR_ORIGINAL].zvnet_id = skb->zvnet_id;
								nat_entry_fwd->data[IP_CT_DIR_ORIGINAL].zvnet_id = nat_entry->data[IP_CT_DIR_ORIGINAL].zvnet_id;
								nat_entry_fwd->data[IP_CT_DIR_REPLY].zvnet_id = nat_entry->data[IP_CT_DIR_REPLY].zvnet_id;
							}
						}
					}
				}
			}
			if(zvnet_id < 0){
				/*zvnetݣߵfast¼ctfast*/
				nf_conntrack_put(skb->nfct);
				skb->nfct = &nat_entry->ct->ct_general;
				nf_conntrack_get(skb->nfct);
				nat_entry->ct->fast_entry = nat_entry;
			}
		}
	}
#endif
    if (!(skb2 = fast_expand_headroom(skb, dev))){
        rcu_read_unlock();
        return 1;
    }

	if(skb2 != skb)
	{
		iph = (struct iphdr *)skb2->data;
		skb = skb2;
	}
	
    fast_tcpdump(skb);
    
    //ץУݻclonefastɹҪıdataݣҪcopyһ
    if (skb_cloned(skb))
    {
        //print_sun(SUN_DBG, "fast_nat_recv clone \n");
        if (pskb_expand_head(skb, 0, 0, GFP_ATOMIC))
        {
            rcu_read_unlock();
            //spin_unlock_bh(&fastnat_spinlock);
            //print_sun(SUN_DBG, "fast_nat_recv clone copy failed !!!\n");
            printk("pskb_expand_head skb failed, free skb\n");
            kfree_skb(skb);
            return 1;
        }
    }
    
    /*ж*/
    if(IPPROTO_TCP == iph->protocol)
        packet_lost_track(skb, nat_entry->ct);
    
    //fastnatɹIPͷ׵ַ,Թcacheˢʱʹ
    skb_reset_network_header(skb);
    skb->isFastnat = 1;
    
    //֧NATԴַ/Ŀĵַ/˿ںŶҪı䣬ֱ͸
    if (nat_entry_data->is_not_nat)
        skip_nat = 1;
    
    if (!skip_nat)
    {
        /*natת*/
        if (IPPROTO_TCP == iph->protocol)
        {
            tcph = (struct tcphdr *)(skb->data + iph->ihl * 4);
            cksum = &tcph->check;
            oldport = (FN_TYPE_SRC == nat_entry_data->type)? (&tcph->source): (&tcph->dest);
        }
        else if (IPPROTO_UDP == iph->protocol)
        {
            udph = (struct udphdr *)(skb->data + iph->ihl * 4);
            cksum = &udph->check;
            oldport = (FN_TYPE_SRC == nat_entry_data->type)? (&udph->source): (&udph->dest);
        }

        oldip = (FN_TYPE_SRC == nat_entry_data->type)? (&iph->saddr) : (&iph->daddr);

        if (cksum != NULL && (0!=*cksum || IPPROTO_TCP == iph->protocol))
        {
            inet_proto_csum_replace4(cksum, skb, *oldip, nat_entry_data->nat_addr, 0);
            inet_proto_csum_replace2(cksum, skb, *oldport, nat_entry_data->nat_port, 0);
        }
        csum_replace4(&iph->check, *oldip, nat_entry_data->nat_addr);
        if(oldport)
        *oldport = nat_entry_data->nat_port;
        *oldip = nat_entry_data->nat_addr;
        //ip_decrease_ttl(iph);
    }
    else
    {
        if (IPPROTO_TCP == iph->protocol)
        {
            tcph = (struct tcphdr *)(skb->data + iph->ihl * 4);
        }
    }
    
/*
    if((nat_entry_data->tos & FAST_DSCP_MASK) != (iph->tos & FAST_DSCP_MASK))
    {
        ipv4_change_dsfield(iph, (u_int8_t)(~FAST_DSCP_MASK), nat_entry_data->tos);
    }
*/

    skb->priority = nat_entry_data->priority;
    skb->mark = nat_entry_data->mark;

    //ctӵͳ --- ͳIPMAC
    if (nat_entry_data->tuplehash.tuple.dst.dir == IP_CT_DIR_ORIGINAL){
        nat_entry->ct->packet_info[IP_CT_DIR_ORIGINAL].packets++;
        nat_entry->ct->packet_info[IP_CT_DIR_ORIGINAL].bytes += skb->len;
    } else if (nat_entry_data->tuplehash.tuple.dst.dir == IP_CT_DIR_REPLY){
        nat_entry->ct->packet_info[IP_CT_DIR_REPLY].packets++;
        nat_entry->ct->packet_info[IP_CT_DIR_REPLY].bytes += skb->len;
    } else {
        printk("fastnat packet error\n");
    }

    //ںԴĻӵͳ
    acct = nf_conn_acct_find(nat_entry->ct);
    if (acct) {
        enum ip_conntrack_info ctinfo;
        if (nat_entry_data->tuplehash.tuple.dst.dir == IP_CT_DIR_ORIGINAL)
            ctinfo = IP_CT_ESTABLISHED;
        else 
            ctinfo = IP_CT_ESTABLISHED_REPLY;

        atomic64_inc(&acct[CTINFO2DIR(ctinfo)].packets);
        atomic64_add(skb->len, &acct[CTINFO2DIR(ctinfo)].bytes);
    }

    /* ƹܣΪ˽UDPʱ޷֪indevͳⶨ */
    if ((nat_entry_data->indev == NULL) && skb->dev)
    {
        nat_entry_data->indev = skb->dev;
    }

    // ͳ豸Ľհ  --- οlinuxԭͳƵĶIP
    if (nat_entry_data->indev && (fastnat_level == FAST_NET_DEVICE))
    {
        nat_entry_data->indev->stats.rx_packets++;
        nat_entry_data->indev->stats.rx_bytes += skb->len;
    }
	//豸skb->indevʵdevfast¼
	if(skb->indev && nat_entry_data->indev != skb->indev && (fastnat_level == FAST_NET_DEVICE)){
        skb->indev->stats.rx_packets++;
        skb->indev->stats.rx_bytes += skb->len;
	}

    skb->dev = dev;

    //ֻеMACͷԤֵʱ׼ֵΪIPͷ
    skb_push(skb, ETH_HLEN);
    if (nat_entry_data->hh_flag == 1)
    {
        memcpy(skb->data, nat_entry_data->hh_data, ETH_HLEN);
    }
#if _USE_VEHICLE_DC
	else{
		if (fastbr_level != 1 && zvnet_id >= 0 && nat_entry_data->hh_flag == 0){
			spin_lock_bh(&fastnat_spinlock);
			memcpy(nat_entry_data->hh_data, skb->data, ETH_HLEN);
			nat_entry_data->hh_flag = 2;
			spin_unlock_bh(&fastnat_spinlock);
		}
	}
#endif
#if 0
    if(!(dev->flags & IFF_POINTOPOINT))
    {
        /*shouldn't set smac and dmac when out interface is p2p interface*/
        if(dev->header_ops && dev->header_ops->create)
        {
            dev->header_ops->create(skb, dev, ETH_P_IP, nat_entry_data->dmac, NULL, skb->len);
        }
        else
        {
            XDBG_PRINT(XDBG_FASTNAT_PKT, XDBGLV_INFO, "no header ops\n");
            return 0;
        }
    }
#endif

    /*ӳʱ*/
    if (IPPROTO_TCP == iph->protocol)
    {
        mod_timer(&nat_entry->timeout, jiffies + tcp_timeouts[nat_entry->ct->proto.tcp.state]);
        update_tcp_timeout(nat_entry, nat_entry_data, tcph);
 
        if(ackfilter(skb, nat_entry, &working_list) == 1)
        {
            rcu_read_unlock();
            //spin_unlock_bh(&fastnat_spinlock);
            return 1;
        }
    }
    else if (IPPROTO_UDP == iph->protocol)
    {
        /*udp*/
        if (fast_test_bit(IPS_SEEN_REPLY_BIT, nat_entry->ct->status))
        {
            mod_timer(&nat_entry->timeout, jiffies + fast_udp_timeout_stream);
        }
        else
        {
            mod_timer(&nat_entry->timeout, jiffies + fast_udp_timeout);
        }
    }

    if (skb->dev->flags & IFF_UP)
    {
        //pppֻҪIP
        if (skb->dev->type == ARPHRD_PPP || skb->dev->type == ARPHRD_NONE)//(strncmp(skb->dev->name, ppp_name, strlen(ppp_name)) == 0)
        {
           skb_pull(skb, ETH_HLEN);
        }
        
        skb->now_location |= FASTNAT_SUCC;

		if(unlikely(skb->dev->type == ARPHRD_NONE)){
			struct ipv6hdr header = {0};
			const struct iphdr *old_header = (struct iphdr *)skb->data;
			unsigned int len = skb->len;
			int rc = -ENOMEM;
		
			header.version = 6;
			header.payload_len = htons(ntohs(old_header->tot_len) - sizeof(struct iphdr));
			header.nexthdr = old_header->protocol;
			header.hop_limit = old_header->ttl;
			header.saddr = g_ipv6_local_subnet;
			header.daddr = g_plat_subnet;
			header.daddr.s6_addr32[3] = old_header->daddr;
			skb_push(skb, sizeof(struct ipv6hdr) - sizeof(struct iphdr));
			memcpy(skb->data, &header, sizeof(struct ipv6hdr));
			if (!(skb2 = fast_expand_headroom(skb, g_xlat_dev))){
				rcu_read_unlock();
				return 1;
			}
			if(skb2 != skb)
				skb = skb2;
			skb_push(skb, ETH_HLEN);
			skb->dev = g_xlat_dev;
		}
        if (fastnat_level == FAST_NET_DEVICE)
        {
            //print_sun(SUN_DBG, "fastnat-2 dev_queue_xmit, send to:%s !!!!!!!! \n", skb->dev->name);
            if(speedMode == 0)
            {
            	dev_queue_xmit(skb);
            }
			else if(skb->dev->netdev_ops && skb->dev->netdev_ops->ndo_start_xmit
				&& skb->dev->netdev_ops->ndo_select_queue == NULL  
				&& (skb->dev->type != ARPHRD_PPP))//wifi豸ڶҪskb_set_queue_mapping ҷppp0
			{
				int rc = -ENOMEM;
				rc = skb->dev->netdev_ops->ndo_start_xmit(skb, skb->dev);
				if (!dev_xmit_complete(rc)) {
					skb->dev->stats_dbg.tx_dropped++;
					skb->dev->stats.tx_dropped++;
					skbinfo_add(NULL,SKB_ERRFREE);
					kfree_skb(skb);
				}
			}
			else if(skb->dev->type == ARPHRD_PPP)
			{
				skb_queue_tail(&fast_txq, skb);
				tasklet_schedule(&fast_tx_bh);
			}
			else
			{
				dev_queue_xmit(skb);
			}
        }
        //صӦãֻ߱׼fastnaṭ޷вִ
        else if (fastnat_level == FAST_NET_CORE)
        {
            //print_sun(SUN_DBG, "fastnat ok-1, send to:%s !!!!!!!! \n", skb->dev->name);
            dev_queue_xmit(skb);
        }
        //else
            //print_sun(SUN_DBG,"fastnat_level:%d is not supported !!!!!!!! \n", fastnat_level);
        //dev_queue_xmit(skb);
        //dev_put(dev);

        nat_entry_data->packet_num++;
    }
    else
    {
        //print_sun(SUN_DBG, "ERR &&&&&& %s DOWN, kfree_skb!!!!!!!! \n", skb->dev->name);
        kfree_skb(skb);
    }

    //print_sun(SUN_DBG, "skb : 0x%x, fastnat succ--------", skb);
    rcu_read_unlock();
    //spin_unlock_bh(&fastnat_spinlock);
    
    return 1;
    
err_out :
    //print_sun(SUN_DBG, "skb : 0x%x, fastnat FAIL!!!!!!!!!!", skb);
    return 0; /* not fast nat */    
}

static struct nf_hook_ops nat_hook = {
    .hook = napt_handle,
    .owner = THIS_MODULE,
    .pf = PF_INET,
    .hooknum = NF_INET_POST_ROUTING,
    .priority = NF_IP_PRI_LAST,
};

//POST_ROUTINGڵ㣬fastӵĸֵhash
unsigned int napt_handle(unsigned int hooknum,
            struct sk_buff *skb,
            const struct net_device *in,
            const struct net_device *out, int (*okfn) (struct sk_buff *))
{
    struct nf_conn *ct;
    enum ip_conntrack_info ctinfo;
    u_int8_t protocol;
    fast_entry_t *nat_entry;
    fast_entry_data_t *entry_data;
    enum ip_conntrack_dir dir, rdir;
    struct dst_entry *dst = skb_dst(skb);
#ifdef CONFIG_ATHRS_HW_NAT
    u_int32_t mask =0;
#endif

    if (fastnat_level == FAST_CLOSE || fastnat_level == FAST_CLOSE_KEEP_LINK)
    {
        return NF_ACCEPT;
    }

    if (fast_test_bit(FAST_TYPE_VERSION_BIT, fast_switch))
    {
        return NF_ACCEPT;
    }

    if (ip_hdr(skb)->protocol != IPPROTO_TCP && ip_hdr(skb)->protocol != IPPROTO_UDP)
        return NF_ACCEPT;
    
    if (!out)
    {
        return NF_ACCEPT;
    }

    //㲥鲥
    if (ipv4_is_multicast(ip_hdr(skb)->daddr) || ipv4_is_lbcast(ip_hdr(skb)->daddr))
    {
        return NF_ACCEPT;
    }

    //˴ҪעǷƵfast֣Ƿɸ
    if (working_list.count > nf_conntrack_max)
    {
        return NF_ACCEPT;
    }

    if (!dst)
    {
        return NF_ACCEPT;
    }
	if(dst->_neighbour == NULL && ((ip_hdr(skb)->daddr & 0xff000000) == 0xff000000 )){
        return NF_ACCEPT;
	} 
    if (dst->_neighbour && memcmp(dst->_neighbour->ha, zeromac, ETH_ALEN) == 0)
    {
        if (strncmp(out->name, ppp_name, strlen(ppp_name)) != 0 && strncmp(out->name, "v4-", 3) != 0)
        {
            return NF_ACCEPT;
        }
    }

    if (!(ct = nf_ct_get(skb, &ctinfo)))
    {
        return NF_ACCEPT;
    }
    
    protocol = nf_ct_protonum(ct);
    
    /* skip alg */
   // if(ct->master)
   // {
   //     return NF_ACCEPT;
    //}
    //else
    if (ct->master == NULL)
    {
        //const struct nf_conntrack_helper *helper;
        struct nf_conn_help *temp_help = nfct_help(ct);
        //ĳϴhelpȹӣ뽻linuxעں˴ں˲ܻȡصݰϢ
        if(temp_help!=NULL)
        {
            //helper = rcu_dereference(temp_help->helper);
            //if(!(helper->tuple.src.u.all == htons(21)&&helper->tuple.dst.protonum == IPPROTO_TCP)) {
            return NF_ACCEPT;
             //   }
        }
    }

#if 0 //ģʽʵֿתģʽNAT
    /* only nat */
    if (!fast_test_bit(IPS_SRC_NAT_BIT, ct->status) && 
        !fast_test_bit(IPS_DST_NAT_BIT, ct->status))
    {
        return NF_ACCEPT;
    }
#endif

    /* only forward */
    if (!skb->skb_iif)
    {
        return NF_ACCEPT;
    }

    /*skip www because fastnat can't process url filter*/
#if 0
    if(ct->tuplehash[IP_CT_DIR_ORIGINAL].tuple.dst.u.all == WWW_PORT)
    {
        XDBG_PRINT(XDBG_FASTNAT_ADD_ENTRY, XDBGLV_DEBUG, "skip www\n");
        return NF_ACCEPT;
    }
#endif

    //˲ҪfastnatЭ,ݶ˿ںŽй
    if (check_skip_ports(ct->tuplehash[IP_CT_DIR_ORIGINAL].tuple.dst.u.all))
    {
        return NF_ACCEPT;
    }

    dir = CTINFO2DIR(ctinfo);
    
    rdir = (IP_CT_DIR_ORIGINAL == dir) ? IP_CT_DIR_REPLY: IP_CT_DIR_ORIGINAL;
    
    /*ֻTCP/UDPfastnat*/
    if (IPPROTO_TCP == protocol)
    {
        /* only established */
        /*TCPֳɹ*/
        if(!fast_test_bit(IPS_ASSURED_BIT, ct->status))
        {
            return NF_ACCEPT;
        }
    }
    else if (IPPROTO_UDP != protocol)
    {
        return NF_ACCEPT;
    }

    spin_lock_bh(&fastnat_spinlock);
    if (!(nat_entry = fast_get_entry(&working_list, ct, dir, 4)))
    {
        spin_unlock_bh(&fastnat_spinlock);
        return NF_ACCEPT;
    }
    nat_entry->fast_spinlock = &fastnat_spinlock;
 
    //״νȡctɾctʱ״νظܲ
    if (!(nat_entry->flags & FAST_ALL_DIR))
    {
        nf_conntrack_get(&ct->ct_general);
        del_timer(&ct->timeout);
    }

    entry_data = &nat_entry->data[dir];
    entry_data->tuplehash.tuple = ct->tuplehash[dir].tuple;
    //memcpy(entry_data->dmac, dst->_neighbour->ha, ETH_ALEN);
    //entry_data->tos = ip_hdr(skb)->tos;
    entry_data->priority = skb->priority;
    entry_data->mark = skb->mark;
    entry_data->outdev = out;

    /*¼MACַentry_data->hh_data*/
    if (!record_MAC_header(working_hash, ct, nat_entry, entry_data, dst->_neighbour, out, htons(ETH_P_IP)))
    {
        spin_unlock_bh(&fastnat_spinlock);
        return NF_ACCEPT;
    }

    /*ȡnatתҪIPportϢ*/
    if (fast_test_bit(IPS_SRC_NAT_BIT, ct->status))
    {
        if(IP_CT_DIR_ORIGINAL == dir)
        {
            entry_data->nat_addr = ct->tuplehash[rdir].tuple.dst.u3.ip;
            entry_data->nat_port = ct->tuplehash[rdir].tuple.dst.u.all;
            entry_data->type = FN_TYPE_SRC;
        }
        else
        {
            entry_data->nat_addr = ct->tuplehash[rdir].tuple.src.u3.ip;
            entry_data->nat_port = ct->tuplehash[rdir].tuple.src.u.all;
            entry_data->type = FN_TYPE_DST;
        }
    }
    else if (fast_test_bit(IPS_DST_NAT_BIT, ct->status))
    {
        if (IP_CT_DIR_ORIGINAL == dir)
        {
            entry_data->nat_addr = ct->tuplehash[rdir].tuple.src.u3.ip;
            entry_data->nat_port = ct->tuplehash[rdir].tuple.src.u.all;
            entry_data->type = FN_TYPE_DST;
        }
        else
        {
            entry_data->nat_addr = ct->tuplehash[rdir].tuple.dst.u3.ip;
            entry_data->nat_port = ct->tuplehash[rdir].tuple.dst.u.all;
            entry_data->type = FN_TYPE_SRC;
        }
    }
    else //֧NATĳ
    {
        //ֳԴַ/Ŀĵַ/˿ںŶҪı䣬ֱ͸
        entry_data->is_not_nat = 1;
    }

    //˴֤λͻ
    nat_entry->flags = nat_entry->flags | (1 << dir);
    
    //hashڵ
    fast_add_entry(working_hash, entry_data);
    
    if (nat_entry->flags == FAST_ALL_DIR)
    {
        nat_entry->data[0].indev = nat_entry->data[1].outdev;
        nat_entry->data[1].indev = nat_entry->data[0].outdev;
    }

    ct->fast_ct.isFast = FAST_CT_WND4;
    
    spin_unlock_bh(&fastnat_spinlock);

	//ɾentryбŻԿʱȴӴɾȡظͷ
	fast_entry_del_cleanup();
	
    return NF_ACCEPT;
}

/*֪ͨ¼*/
int fastnat_event(traverse_command_t *cmd)
{
    spin_lock_bh(&fastnat_spinlock);
    traverse_process(&working_list, cmd);
    spin_unlock_bh(&fastnat_spinlock);
	return 0;
}

//fastnat_levelرգipv4תϢ
void fastnat_cleanup_links(void)
{
    spin_lock_bh(&fastnat_spinlock);
    fast_cleanup_links(&working_list);
    spin_unlock_bh(&fastnat_spinlock);
}

/*fastnatʼ*/
int tsp_fastnat_init(void)
{
    int ret;
    
    //print_sun(SUN_DBG,"start init fastnat\n");
    
    working_hash = nf_ct_alloc_hashtable(&nf_conntrack_htable_size, /*&fastnat_hash_vmalloc,*/ 1);
    if (!working_hash)
    {
        //print_sun(SUN_ERR, "Unable to create working_hash\n");
        return -EINVAL;
    }

    spin_lock_init(&fastnat_spinlock);
    
    ret = nf_register_hook(&nat_hook);
    if (ret != 0)
    {
        //print_sun(SUN_ERR,"init fastnat failed\n");
        goto err;
    }
    //print_sun(SUN_DBG,"init fastnat done\n");

    return 0;
    
err:
    nf_ct_free_hashtable(working_hash, /*fastnat_hash_vmalloc, */nf_conntrack_htable_size);
    return -EINVAL;
}

int tsp_fastnat_cleanup(void)
{
    nf_unregister_hook(&nat_hook);
    nf_ct_free_hashtable(working_hash, /*fastnat_hash_vmalloc,*/ nf_conntrack_htable_size);
    
    //print_sun(SUN_DBG,"fastnat cleanup done\n");
    return 0;
}

