/*
 ***********************************************************	
 */

#include <common.h>
#include <asm/io.h>
#include <asm/string.h>
#include <sdio.h>
#include <image.h>
#include <key.h>


#include "efuse.h"
#include "drv_rsa.h"
#include "drv_hash.h"


#define E_N_LEN 256
#define HASH_LEN 128



/*
 ******************************************************************************
 * Function:     
 * Description: 
 * Parameters:
 *	 Input:
 *	 Output:
 * Returns:
 * Others:
 *******************************************************************************
 */
static u8 data_cmp_word(u32* src, u32* dst, u32 cnt)
{
	u32 i;
	for(i = 0; i < cnt; i++)
	{
		if(src[i] != dst[i])
		{
			return 1;
		}
	}
	return 0;
}


/*
 ******************************************************************************
 * Function:     
 * Description: 
 * Parameters:
 *	 Input:
 *	 Output:
 * Returns:
 * Others:
 *******************************************************************************
 */
int SecureVerify(u32 puiSdrmStartAddr)
{
	u32 uiLen = 0;
	u32 uiRet = -1;
	image_header_t *puiLegacyImgAddr = NULL;
	sImageHeader *psImageHeader = NULL;
	efuse_struct *psEfuseInfo = NULL;

	u32 *puiDataLoadAddr = NULL;
	u32 *puiArrPubKeyEN = NULL;
	u32 *puiArrHASH = NULL;
	u32 uiHashResArr[4] = {0};
	u32 uiHashResLen = 0;
	u32 uiHashVerifySize = 0;
	u32 uiRsaResArr[32] = {0};
	int guiEfuseStatus = 1;

	u32 sRamKey[5] = {SECURE_EN,SECURE_PUK_HASH0,SECURE_PUK_HASH1,
					  SECURE_PUK_HASH2,SECURE_PUK_HASH3};
	
	T_Rsa_Paramter sRSAInput;
	u32 *puiRsaResAddr = NULL;

	if(0 == puiSdrmStartAddr)
	{
		return -1;
	}

	psImageHeader = (sImageHeader *)puiSdrmStartAddr;
	puiLegacyImgAddr = (image_header_t *)(puiSdrmStartAddr + sizeof(sImageHeader));
	uiHashVerifySize = ___htonl(puiLegacyImgAddr->ih_size) + sizeof(image_header_t);

	guiEfuseStatus = get_secure_verify_status();
	if(guiEfuseStatus == 0)    //efuse secure verify.
		psEfuseInfo = (efuse_struct*)EFUSE_RAM_BASE;
	else
		psEfuseInfo = (efuse_struct*)sRamKey;

	/*
	 * 0. PubKeyǷ񱻴۸ġ
	 *  - PubKeyĽHASH_MD5㣬
	 *  efuseбpuk_hashȽϡ
	 *    - Ƚͬ0
	 *    - ͬ1
	 */
	uiLen = E_N_LEN;  //ԿEN256byteȡ
	puiArrPubKeyEN = psImageHeader->uiPubKeyRsaE;

	uiRet = Hash_Calculate(HASH_MODE_MD5, 
						   HASH_SMALL_ENDIAN, 
						   puiArrPubKeyEN, 
						   uiLen, 
						   NULL, 
						   0, 
						   uiHashResArr, 
						   &uiHashResLen);
	if(uiRet != 0)
	{
		return -1;
	}
	
	if(data_cmp_word((u32 *)psEfuseInfo->puk_hash, 
						uiHashResArr, uiHashResLen))
	{
		printf("Puk hash verify fail!\n");
		return -1;
	}

	puiArrHASH = psImageHeader->uiHashY;
	uiLen = HASH_LEN;

	/*
	 * 1. ùԿuiHashY'нܣõ1024bit
	 */
	sRSAInput.udCalMode = RSA_MOD_EXPO_WITH_INIT;
	sRSAInput.udNbitLen = 1024;
	sRSAInput.udEbitLen = 1024;
	sRSAInput.pudInputM = puiArrHASH;
	sRSAInput.pudInputE = puiArrPubKeyEN;
	sRSAInput.pudInputN = (puiArrPubKeyEN + 32);
	sRSAInput.pudOutputP = uiRsaResArr;
	
	uiRet = Rsa_Calculate(sRSAInput);
	if(uiRet != 0)
	{
		printf("Rsa_Calculate fail!\n");
		return -1;
	}

	//ȡ4ֽΪPubKeyܺHASH_MD5ֵ
	puiRsaResAddr = sRSAInput.pudOutputP + (32 - uiHashResLen);    

	/*
	 * 2. һHASH_MD5ֵ
	 *  - LegacyImage(64 BytesͷϢ+汾)hash㣬
	 * PubKeyǩĽбȽϡ
	 */
	uiLen = uiHashVerifySize;
	puiDataLoadAddr = (u32 *)(___htonl(puiLegacyImgAddr->ih_load)
								- sizeof(image_header_t));

	/* Cleanup Output Buffer. */
	uiHashResLen = 0;
	memset(uiHashResArr, 0, 4*sizeof(uiHashResArr[0]));
	
	uiRet = Hash_Calculate(HASH_MODE_MD5, 
						   HASH_SMALL_ENDIAN, 
						   puiDataLoadAddr, 
						   uiLen, 
						   NULL, 
						   0, 
						   uiHashResArr, 
						   &uiHashResLen);
	if(uiRet != 0)
	{
		printf("Hash_Calculate Fail!\n");
		return -1;
	}

	if(data_cmp_word(puiRsaResAddr, uiHashResArr, uiHashResLen))
	{
		printf("SignImage Verify Fail!\n");
		return -1;
	}

	return 0;
}




