#include "cfg_api.h"



//InternetGatewayDevice.DeviceInfo.Manufacturer
int cpe_get_igd_di_manufacturer(cwmp_t * cwmp, const char * name, char ** value, pool_t * pool)
{
    FUNCTION_TRACE();
    *value = cwmp_conf_pool_get(pool, "cwmp:cpe_manufacture");
    cwmp_log_debug("cpe_get_igd_di_manufacturer: value is %s", *value);
    return	FAULT_CODE_OK;
}

//InternetGatewayDevice.DeviceInfo.ManufacturerOUI
int cpe_get_igd_di_manufactureroui(cwmp_t * cwmp, const char * name, char ** value, pool_t * pool)
{
    FUNCTION_TRACE();
    *value = cwmp_conf_pool_get(pool, "cwmp:cpe_oui");
    return	FAULT_CODE_OK;
}

//InternetGatewayDevice.DeviceInfo.ProductClass
int cpe_get_igd_di_productclass(cwmp_t * cwmp, const char * name, char ** value, pool_t * pool)
{
    FUNCTION_TRACE();
    *value = cwmp_conf_pool_get(pool, "cwmp:cpe_pc");
    return	FAULT_CODE_OK;
}

//InternetGatewayDevice.DeviceInfo.SerialNumber
int cpe_get_igd_di_serialnumber(cwmp_t * cwmp, const char * name, char ** value, pool_t * pool)
{
	FUNCTION_TRACE();
    *value = cwmp_conf_pool_get(pool, "cwmp:cpe_sn");
    return	FAULT_CODE_OK;
}

//InternetGatewayDevice.DeviceInfo.SpecVersion
int cpe_get_igd_di_specversion(cwmp_t * cwmp, const char * name, char ** value, pool_t * pool)
{
	FUNCTION_TRACE();
    *value = cwmp_conf_pool_get(pool, "cwmp:cpe_specver");
    return	FAULT_CODE_OK;
}

//InternetGatewayDevice.DeviceInfo.HardwareVersion
int cpe_get_igd_di_hardwareversion(cwmp_t * cwmp, const char * name, char ** value, pool_t * pool)
{
	FUNCTION_TRACE();
    char hw[256+1] = {0};

	sc_cfg_get("hardware_version", hw, 256);

	*value = pool_pstrdup(pool, hw);
    return	FAULT_CODE_OK;
}

//InternetGatewayDevice.DeviceInfo.SoftwareVersion
int cpe_get_igd_di_softwareversion(cwmp_t * cwmp, const char * name, char ** value, pool_t * pool)
{
	FUNCTION_TRACE();
    char sw[256+1] = {0};

	sc_cfg_get("wa_version", sw, 256);

	*value = pool_pstrdup(pool, sw);

    return	FAULT_CODE_OK;
}

//InternetGatewayDevice.DeviceInfo.ProvisioningCode
int cpe_get_igd_di_provisioningcode(cwmp_t * cwmp, const char * name, char ** value, pool_t * pool)
{
	FUNCTION_TRACE();
    *value = cwmp_conf_pool_get(pool, "cwmp:cpe_pc");
    return	FAULT_CODE_OK;
}


int cpe_set_igd_di_softwareversion(cwmp_t * cwmp, const char * name, const char * value, int length, callback_register_func_t callback_reg)
{
    cwmp_log_info("set softwareversion:%s", value);
	cwmp_conf_set("cwmp:SoftwareVersion", value);
    return FAULT_CODE_OK;
}



int cpe_set_igd_di_hardwareversion(cwmp_t * cwmp, const char * name, const char * value, int length, callback_register_func_t callback_reg)
{
    cwmp_log_info("set hardwareversion:%s", value);
	cwmp_conf_set("cwmp:HardwareVersion", value);
    return FAULT_CODE_OK;
}



//InternetGatewayDevice.DeviceInfo.VendorConfigFile.Name
int cpe_get_igd_di_vc_name(cwmp_t * cwmp, const char * name, char ** value, pool_t * pool)
{
	FUNCTION_TRACE();
    *value = pool_pstrdup(pool, "cwmp.conf");
    return	FAULT_CODE_OK;
}

//InternetGatewayDevice.DeviceInfo.VendorConfigFile.Version
int cpe_get_igd_di_vc_version(cwmp_t * cwmp, const char * name, char ** value, pool_t * pool)
{
	FUNCTION_TRACE();
    *value = pool_pstrdup(pool, "V0.0.1");
    return	FAULT_CODE_OK;
}

//InternetGatewayDevice.DeviceInfo.VendorConfigFile.Date
int cpe_get_igd_di_vc_date(cwmp_t * cwmp, const char * name, char ** value, pool_t * pool)
{
	FUNCTION_TRACE();
	
	struct stat info; 
	char buff[64] = {0}; 
	struct tm * timeinfo;
	const char* unknown_date = "00 00 00:00";

	if(stat("/cache/cwmp.conf", &info)<0)
	{
	    *value = pool_pstrdup(pool, (void *)unknown_date);
	}
	else
	{
    	timeinfo = localtime (&(info.st_mtime)); 
    	if(NULL == timeinfo)
    	{
            *value = pool_pstrdup(pool, (void *)unknown_date);
    	}
    	else
    	{
    	    strftime(buff, sizeof(buff), "%b %d %H:%M", timeinfo); 
            *value = pool_pstrdup(pool, buff);
    	}
	}
	
    return	FAULT_CODE_OK;
}

//InternetGatewayDevice.DeviceInfo.VendorConfigFile.Description
int cpe_get_igd_di_vc_description(cwmp_t * cwmp, const char * name, char ** value, pool_t * pool)
{
	FUNCTION_TRACE();
    *value = pool_pstrdup(pool, "config file path: /cache/cwmp.conf");
    return	FAULT_CODE_OK;
}




