#include <sys/sem.h>
#include <sys/ipc.h>
#include <errno.h>
#include "softap_log.h"

//˴ȡֵFLUXSTATļеȡֵһµ
//ڲͬĽ̼ͬ
#define TIME_SEM_KEY 0x0666

extern int init_sem(int sem_id, int init_value);
extern int del_sem(int sem_id);
extern int sem_p(int sem_id);
extern int sem_v(int sem_id);
extern int get_sem(key_t sem_key);


union semun {
	int val;
	struct semid_ds *buf;
	unsigned short *array;
};

int get_sem(key_t sem_key)
{
	int sem_id = -1;

	sem_id = semget(sem_key, 1, 0666 | IPC_CREAT | IPC_EXCL);
	if (sem_id < 0) {
		//printf("[goahead]semget errno=%d\n", errno);
		if (errno == EEXIST) {
			//printf("[goahead]semget already exist==\n");
			return semget(sem_key, 1, 0666 | IPC_CREAT);
		}
		slog(MISC_PRINT, SLOG_ERR,"[goahead]semget == -1, return fail\n");
		return -1;
	}

	union semun sem_union;
	sem_union.val = 1;
	if (semctl(sem_id, 0, SETVAL, sem_union) == -1) {
		return -1;
	}
	//printf("[goahead]semget sem_id= %d, get sem success\n",sem_id);;
	return sem_id;
}


// źsem_idΪinit_value
int init_sem(int sem_id, int init_value)
{
	union semun sem_union;
	sem_union.val = init_value;
	if (semctl(sem_id, 0, SETVAL, sem_union) == -1) {
		return -1;
	}
	return 0;
}

// ɾsem_idź
int del_sem(int sem_id)
{
	union semun sem_union = {0}; //cov h
	if (semctl(sem_id, 0, IPC_RMID, sem_union) == -1) {
		return -1;
	}
	return 0;
}

// sem_idִp
int sem_p(int sem_id)
{
	struct sembuf sem_buf;
	sem_buf.sem_num = 0; //ź
	sem_buf.sem_op = -1; //P
	sem_buf.sem_flg = SEM_UNDO; //ϵͳ˳ǰδͷźϵͳԶͷ
	if (semop(sem_id, &sem_buf, 1) == -1) {
		return -1;
	}
	return 0;
}

// sem_idִV
int sem_v(int sem_id)
{
	struct sembuf sem_buf;
	sem_buf.sem_num = 0;
	sem_buf.sem_op = 1; //V
	sem_buf.sem_flg = SEM_UNDO;
	if (semop(sem_id, &sem_buf, 1) == -1) {
		return -1;
	}
	return 0;
}

