#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "libcpnv.h"
#include "flags_api.h"

static int nvro_restoring(int nvro_flag)
{
    int ret = -1;
    if (nvro_flag != NVRO_RESTORING)
    {
        ret = flags_set_nvroflag(NVRO_RESTORING);
        if (ret != 0)
        {
            printf("[error]nvro_tool set NVRO_RESTORING\n");
            return -1;
        }
        else
        {
            printf("nvro_tool set NVRO_RESTORING success\n");
        }
    }
    if (cpnv_NvroRestore() == CPNV_OK)
    {
        printf("cpnv_NvroRestore success\n");
        return 0;
    }
    else
    {
        printf("cpnv_NvroRestore fail\n");
        return -1;
    }
}

static int nvro_check(int flag)
{
    int ret = -1;

    if (cpnv_nvro_check(flag) == CPNV_OK)
    { // nvro hash check ok
        printf("nvro_tool nvro hash check ok\n");
        ret = 0;
    }
    else
    { // nvro hash check fail and try restore
        ret = nvro_restoring(NVRO_BACKED_UP);
    }
    return ret;
}

int main(int argc, char *argv[])
{
    unsigned int nvro_flag;
    int ret;

    if (argc == 1)
    {
        printf("%s backup     backup now\n", argv[0]);
        printf("%s restore    restore next boot\n", argv[0]);
        printf("%s backing_up backup next boot\n", argv[0]);
        printf("%s check      check now\n", argv[0]);
        printf("%s getflag    show nvro_flag\n", argv[0]);
        return -1;
    }
    if (argc > 1 && (strcmp("backup", argv[1]) == 0))
    {
        if (cpnv_NvroBackup() == CPNV_OK)
        {
            printf("cpnv_NvroBackup success\n");
            return 0;
        }
        else
        {
            printf("cpnv_NvroBackup fail\n");
            return -1;
        }
    }
    if (argc > 1 && (strcmp("restore", argv[1]) == 0))
    {
        ret = flags_set_nvroflag(NVRO_RESTORING);
        if (ret != 0)
        {
            printf("[error]nvro_tool set NVRO_RESTORING\n");
            return -1;
        }
        else
        {
            printf("nvro_tool set NVRO_RESTORING success\n");
            return 0;
        }
    }
    if (argc > 1 && (strcmp("backing_up", argv[1]) == 0))
    {
        ret = flags_set_nvroflag(NVRO_BACKING_UP);
        if (ret != 0)
        {
            printf("[error]nvro_tool set NVRO_BACKING_UP\n");
            return -1;
        }
        else
        {
            printf("nvro_tool set NVRO_BACKING_UP success\n");
            return 0;
        }
    }
    if (argc > 1 && (strcmp("check", argv[1]) == 0))
    {
        nvro_flag = flags_get_nvroflag();

        switch (nvro_flag)
        {
        case NVRO_RESTORING:
            ret = nvro_restoring(nvro_flag);
            break;
        case NVRO_BACKING_UP:
            if (cpnv_nvro_check(1) != CPNV_OK)
            { /* nvro check fail and restoring */
                ret = nvro_restoring(nvro_flag);
            }
            else
            { /* nvro check ok */
                if (cpnv_NvroBackup() == CPNV_OK)
                {
                    printf("cpnv_NvroBackup success\n");
                    ret = 0;
                }
                else
                {
                    printf("cpnv_NvroBackup fail\n");
                    ret = -1;
                }
            }
            break;
        case NVRO_BACKED_UP:
            ret = nvro_check(2);
            break;
        default:
            ret = -1;
            break;
        }
        return ret;
    }
    if (argc > 1 && (strcmp("getflag", argv[1]) == 0))
    {
        nvro_flag = flags_get_nvroflag();
        switch (nvro_flag)
        {
        case NVRO_INIT:
            printf("nvro_flag init:%08x\n", nvro_flag);
            break;
        case NVRO_BACKED_UP:
            printf("nvro_flag backed up:%08x\n", nvro_flag);
            break;
        case NVRO_BACKING_UP:
            printf("nvro_flag back up next reboot:%08x\n", nvro_flag);
            break;
        case NVRO_RESTORING:
            printf("nvro_flag restoring:%08x\n", nvro_flag);
            break;
        default:
            printf("nvro_flag invalid:%08x\n", nvro_flag);
            break;
        }
        return 0;
    }

    return -1;
}

