/*******************************************************************************
 * 版权所有 (C)2023, 深圳市中兴微电子技术有限公司。
 *
 * 文件名称: syslog_monitor.c
 * 文件标识: syslog_monitor
 * 内容摘要: V3V平台AP核syslog控制模块
 * 使用方法:
 *
 * 修改日期        版本号      修改标记        修改人          修改内容
 * ------------------------------------------------------------------------------
 * 2023/09/20      V1.0        Create          guowei          创建
 *
 *******************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <unistd.h>
#include <errno.h>
#include <sys/ipc.h>
#include <sys/msg.h>

#define MAX_BUFFER_SIZE 1024
#define SLOG_KEY  0xFFFF6C67
#define RLOG_KEY  0xFFFF4C47

// Define message queue structure
struct msg_buffer {
	long msg_type;
	char msg[MAX_BUFFER_SIZE];
} message;

main(int argc,char *argv[]) 
{
	key_t snd_key = SLOG_KEY;
	key_t rcv_key = RLOG_KEY;
	int snd_msg_id = 0;
	int rcv_msg_id = 0;
	size_t bytesRead = 0;
	int ret = 0;
	FILE *fp = NULL;
	
	rcv_msg_id = msgget(rcv_key, 0666 | IPC_CREAT); //create message queue and return id
	snd_msg_id = msgget(snd_key, 0666 | IPC_CREAT); //create message queue and return id
	//printf("syslog_monitor: recver message id %d sender message is %d\n", rcv_msg_id, snd_msg_id);

	while(1)
	{
		ret = msgrcv(rcv_msg_id, &message, sizeof(message), 1, 0); //used to receive message
		// display the message
		printf("syslog_monitor: receive message content is %s \n", message.msg);
		if (!ret)
		{
			printf("syslog_monitor: received from cap-core message error");
			return -1;
		}

		// exec received commond
		fp = popen(message.msg, "r");
		if (fp == NULL) {
			printf("syslog_monitor: exec %s commond fail \n", message.msg);
			return -1;
		}

		while (!feof(fp))
		{
			bytesRead = fread(message.msg, sizeof(char), sizeof(message.msg) - 1, fp);
			if (bytesRead == 0)
			{
				if (errno == EINTR)
				{
					continue;
				}
				else
				{
					break;
				}
			}
		}
		
		message.msg[bytesRead] = '\0';
		//printf("syslog_monitor: %s", message.msg);
		pclose(fp);
		
		ret = msgsnd(snd_msg_id, &message, sizeof(message), 0); //send message
		printf("syslog_monitor: send message content is %s \n", message.msg);

	}
	
	return 0;
}

