/**
 * 
 * @file      amt.c
 * @brief     
 *            This file is part of FTM.
 *            AMTӦò
 *            
 * @details   
 * @author    Tools Team.
 * @email     
 * @copyright Copyright (C) 2013 Sanechips Technology Co., Ltd.
 * @warning   
 * @date      2019/02/02
 * @version   1.1
 * @pre       
 * @post      
 *            
 * @par       
 * Change History :
 * ---------------------------------------------------------------------------
 * date        version  author         description
 * ---------------------------------------------------------------------------
 * 2015/04/28  1.0      lu.xieji       Create file
 * 2019/02/02  1.1      jiang.fenglin  ޸עͷʽΪdoxygen
 * ---------------------------------------------------------------------------
 * 
 * 
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <pthread.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <sys/msg.h>
#include <fcntl.h>
#include <unistd.h>
#include "linux/rpmsg_zx29.h"
#include <sys/socket.h>
#include <netdb.h>
#include <netinet/in.h>
#include <linux/netlink.h>
#include <arpa/inet.h>
#include <netinet/in.h>
#include <signal.h>
#include <errno.h>
#include "port_com.h"
#include "amt.h"
#include "os_type_def.h"
#include "softap_api.h"
#include "other_msg.h"
#include "message.h"
#include "amt_agent_devicetest.h"
#include "kwatch_msg.h"
#include "amtnv.h"
#include "libcpnv.h"
#include <sys/prctl.h>
#include "sys/wait.h"
#include "ref_nv_def.h"
#include "nv_api.h"




/**
 * ⲿ
 */
extern int Amt_Wifi_Init(void);
extern int Amt_Wifi_ProcessMsg(unsigned int msg_id, unsigned char *msg_buf, unsigned int msg_len);
extern int Amt_Gps_ProcessMsg(unsigned int msg_id, unsigned char *msg_buf, unsigned int msg_len);
extern int Amt_DeviceTest_ProcessMsg(unsigned int msg_id, unsigned char *msg_buf, unsigned int msg_len);
extern int Amt_Process_Gps_Rsp(MSG_BUF *msg,unsigned int msg_id);
extern int Amt_FuncTest_ProcessMsg(unsigned int msg_id, unsigned char *msg_buf, unsigned int msg_len);
extern int wifi_ioctl_handle(int cmd);


/**
 * ȫֱ
 */
static int g_amt_fd_cp = -1;
static int g_amt_fd_usb = -1;
static int g_amt_fd_usb_hotplug = -1;
static int g_amt_fd_socket_client = -1;
static int g_amt_fd_socket_server = -1;
static fd_set g_amt_fdsread;
static int g_amt_fd_max = 0;
static volatile int *g_amt_fd_current = NULL;
static int g_amt_iMsgHandle = 0;
unsigned int g_amt_at_mode = 0;
#ifdef USE_CAP_SUPPORT
static int g_amt_fd_cap = -1;
#endif
static unsigned int rat = 0;
static unsigned int ant_num = 0;
static void send_ok(int fd);
static void send_error(int fd);
static void send_query_result(int fd,char* cmd, char* param);


/**
 * @brief AMTϢ͸PC
 * @param[in] fd ļ
 * @param[in] buf buffer
 * @param[in] buf_len buffer
 * @return ط͵ݳ
 * @note
 * @see 
 */
static int Amt_SendData(int fd, unsigned char* buf, unsigned int buf_len)
{
    int write_len = PortSend(fd, (unsigned char*)&buf_len, sizeof(unsigned int), WAIT_ALL);

    //if (write_len > 0)
    {
        write_len = PortSend(fd, buf, buf_len, WAIT_ALL);

        if (write_len <= 0)
        {
            AmtPrintf(AMT_ERROR "%s: PortSend 'data' to device(fd = %d): write_len(%d) is wrong.\n", __FUNCTION__, fd, write_len);
        }
    }
	/*
    else
    {
        AmtPrintf(AMT_ERROR "%s: PortSend 'length' to device(fd = %d): write_len(%d) is wrong.\n", __FUNCTION__, fd, write_len);
    }
    */

    return write_len;
}

/**
 * @brief AMTϢ
 * @param[in] fd ļ
 * @param[in] buf buffer
 * @param[in] buf_len buffer
 * @return ط͵ݳ
 * @note
 * @see 
 */
static int Amt_SendDataToAmtagent(int fd, unsigned char* buf, unsigned int buf_len)
{
	int  write_len = PortSend(fd, buf, buf_len, NO_WAIT);

    if (write_len <= 0)
    {
    	AmtPrintf(AMT_ERROR "%s: PortSend 'data' to device(fd = %d): write_len(%d) is wrong.\n", __FUNCTION__, fd, write_len);
    }
	else
	{
        AmtPrintf(AMT_INFO "%s: PortSend 'data' to device(fd = %d): write_len(%d),buf_len(%d) \n", __FUNCTION__, fd, write_len,buf_len);
	}
    return write_len;
}


/**
 * @brief AMTϢ
 * @param[in] fd ļ
 * @param[in] buf buffer
 * @param[in] buf_len buffer
 * @return ؽյݳ
 * @note
 * @see 
 */
static int Amt_ReceiveData(int fd, unsigned char* buf, unsigned int buf_len)
{
    int read_len = PortRecv(fd, buf, sizeof(unsigned int), WAIT_ALL);

    if (read_len > 0)
    {
        unsigned int packet_len = *((unsigned int *)buf);
        if (packet_len > 0 && packet_len <= buf_len)
        {
            read_len = PortRecv(fd, buf, packet_len, WAIT_ALL);

            if (read_len <= 0)
            {
                AmtPrintf(AMT_ERROR "%s: PortRecv 'data' from device(fd = %d): read_len(%d) is wrong.\n", __FUNCTION__, fd, read_len);
            }
        }
        else
        {
            AmtPrintf(AMT_ERROR "%s: fd = %d, packet_len(%d) is wrong.\n", __FUNCTION__, fd, packet_len);
            read_len = -1;
        }
    }
    else
    {
        AmtPrintf(AMT_ERROR "%s: PortRecv 'length' from device(fd = %d): read_len(%d) is wrong.\n", __FUNCTION__, fd, read_len);
    }

    return read_len;
}

#if 0
static void str_to_int( int *data, char *str )
{
    int Lc = 0;
    int	Len = 0;
    char *Begb = NULL;
    char *Endb = NULL;
    char *ptr = NULL;
    char s1[100] = "";
    char s2[50] = "";	
    memset(s1, 0, sizeof(s1));
    strcpy(s1, str);
    strcat(s1, ",");
    Begb = s1;						//ʼַ
    Endb = strchr(s1,',');			//һλ
	if (Endb == NULL)
		return;
    Lc = 0;	
    do
    {
        Len = 0;
        Len = Endb - Begb;			//
        memset(s2, 0, sizeof(s2));	//ȡżַ
        strncpy(s2, Begb, Len);		//ȡżַ
        data[Lc] = atoi(s2);			//string to int
        ptr = Endb + 1;				//ָ¸ʼַ
        strcpy(s1, ptr);			//ȥתַ
        Begb = s1;					//ʼַ
        Endb = strchr(s1,',');		//¸λ
        Lc++;
    }while(Endb!=NULL); 
}
#endif

static void str_to_double( double *data, char *str )
{
    int Lc = 0;
    int	Len = 0;
    char *Begb = NULL;
    char *Endb = NULL;
    char *ptr = NULL;
    char s1[100] = "";
    char s2[50] = "";	
    memset(s1, 0, sizeof(s1));
    memcpy(s1, str,sizeof(s1) - 1);
    strcat(s1, ",");
    Begb = s1;						//ʼַ
    Endb = strchr(s1,',');			//һλ
	if (Endb == NULL)
		return;
    Lc = 0;	
    do
    {
        Len = 0;
        Len = Endb - Begb;			//
        memset(s2, 0, sizeof(s2));	//ȡżַ
        memcpy(s2, Begb, sizeof(s2) - 1);		//ȡżַ
        data[Lc] = atof(s2);			//string to int
        ptr = Endb + 1;				//ָ¸ʼַ
        memcpy(s1, ptr, 99);			//ȥתַ
        Begb = s1;					//ʼַ
        Endb = strchr(s1,',');		//¸λ
        Lc++;
    }while(Endb!=NULL); 
}

#ifdef USE_CAP_SUPPORT
/**
 * @brief ȡcapķϢ̺߳
 * @param[in] args ̺߳
 * @return N/A
 * @note
 * @see 
 */
static void* ReadFromCAPThread(void* args)
{
    // Read from AP-CAP channel
    char *receive_buffer = NULL;

	UNUSED(args);
	
	receive_buffer = malloc(MAX_PACKET_LENGTH);
    if (receive_buffer == NULL)
    {
        return NULL;
    }

	prctl(PR_SET_NAME, "AmtReadFromCAP");

    while (1)
    {
        int read_len = Amt_ReceiveData(g_amt_fd_cap, (unsigned char *)receive_buffer, MAX_PACKET_LENGTH);

        if (read_len > 0)
        {
            AmtPrintf(AMT_INFO "%s: Receive cap data, read_len = %d!.\n", __FUNCTION__, read_len);

            if (g_amt_fd_current && *g_amt_fd_current >= 0)
            {
                if(g_amt_at_mode != 1)
                {
                    Amt_SendData(*g_amt_fd_current, (unsigned char *)receive_buffer, read_len);
                }
            }
            else
            {
                AmtPrintf(AMT_ERROR "%s: Current fd is wrong.\n", __FUNCTION__);
            }
        }
    }

    free(receive_buffer);
    return NULL;
}
#endif

/**
 * @brief AMTϢתΪATַ͸PC
 * @param[in] fd ļ
 * @param[in] buf buffer
 * @param[in] buf_len buffer
 * @return ط͵ݳ
 * @note
 * @see 
 */
static int At_SendData(int fd, unsigned char* buf, unsigned int buf_len)
{
	unsigned char *pSTX = NULL;
    unsigned char *pETX = NULL;
    unsigned char *pTID = NULL;
    unsigned char *pFID = NULL;
    unsigned char *pCheck = NULL;
    unsigned char *pData = NULL;
    unsigned char CheckSum = 0;
    unsigned int msg_id;
    unsigned int i = 0;
	unsigned int phy_msg_id;
	unsigned int phy_ret;
    pTID = pTID;
    pCheck = pCheck;
    pData = pData;

    pSTX = &buf[0];
    pETX = &buf[buf_len - 1];
    pTID = &buf[1];
    pFID = &buf[1 + 1];
    pCheck = &buf[buf_len - 2];
    pData = &buf[1 + 1 + 1];

    if (!((0x02 == *pSTX) && (0x02 == *pETX)))
    {
        return -1;
    }

    CheckSum = 0;

    for (i = 0; i < (buf_len - 2); i++)
        CheckSum ^= buf[1 + i];

    if (CheckSum != 0)
    {
        return -1;
    }

    // TIDFIDʹչܺ
    msg_id = (*pTID << 8) | *pFID;

    AmtPrintf(AMT_INFO "%s: msg_id = %#04x, buf_len = %d.\n", __FUNCTION__, msg_id, buf_len);

	switch(msg_id)
	{
	    //LTEAMTϢ
		case FID_LTEA_PHY_MSG:
		{
			memcpy(&phy_msg_id, pData, 4);
			memcpy(&phy_ret, pData + 4, 4);
			AmtPrintf(AMT_INFO "%s: lte_phy_msg_id = %#04x, lte_phy_ret = %d.\n", __FUNCTION__, phy_msg_id,phy_ret);
			switch(phy_msg_id)
			{
				case 0x505://ZAMT_LTEA_GET_NST_RSRP
				{
				    typedef struct
				    {
						UINT32  dwMsgId;  //x0505
						UINT32  dwRet;    //=0,ʶɹ; ֵʶʧ
		    			UINT16 wAntRsrp[4];   // 4߽RSRPֵ
		    			UINT16 wAntRssi[2];   // ߽RSSIֵ
		    			UINT16 wAntRssiDec[2];   // ߽RSSIֵС
					}T_zAMT_LTEA_GetRsrp_Rsp; 
						
			        T_zAMT_LTEA_GetRsrp_Rsp stGetRsrp_Rsp = {0};
					
				    if(phy_ret == 0)
				    {
				    	memcpy(&stGetRsrp_Rsp, pData,sizeof(stGetRsrp_Rsp));
						AmtPrintf(AMT_INFO "%s: RSRP[0] = %d, RSRP[1] = %d,RSSI[0] = %d, RSSI[1] = %d,RSSIDec[0] = %d, RSSIDec[1] = %d\n", \
							__FUNCTION__, stGetRsrp_Rsp.wAntRsrp[0],stGetRsrp_Rsp.wAntRsrp[1],\
							stGetRsrp_Rsp.wAntRssi[0],stGetRsrp_Rsp.wAntRssi[1],\
							stGetRsrp_Rsp.wAntRssiDec[0],stGetRsrp_Rsp.wAntRssiDec[1]);\
						char strRSSI[100] = {0};
                        UINT16 wAnt0RSSI = stGetRsrp_Rsp.wAntRssi[0];
						UINT16 wAnt0RSSIDec = stGetRsrp_Rsp.wAntRssiDec[0];
						double dAnt0RSSI = (double)(wAnt0RSSI + (wAnt0RSSIDec/128.0) - 65535);
						UINT16 wAnt1RSSI = stGetRsrp_Rsp.wAntRssi[1];
						UINT16 wAnt1RSSIDec = stGetRsrp_Rsp.wAntRssiDec[1];
						double dAnt1RSSI = (double)(wAnt1RSSI + (wAnt1RSSIDec/128.0) - 65535);
						
						switch(ant_num)
						{
						    //ȡ·rssi
							case 10:
							{ 
							    sprintf(strRSSI,"%.2f",dAnt0RSSI);
						        send_query_result(fd, "RSSI",strRSSI);
								break;
							}
							//ȡ·rssi
							case 11:
							{
							    sprintf(strRSSI,"%.2f",dAnt1RSSI);
						        send_query_result(fd, "RSSI",strRSSI);
								break;
							}
							//ȡ·rssi
							default:
							{
							    sprintf(strRSSI,"%.2f,%.2f",dAnt0RSSI,dAnt1RSSI);
						        send_query_result(fd, "RSSI",strRSSI);
								break;
							}
					    }
					}
					else
					{
						send_error(fd);
					}
				    
					break;
				}
				case 0x500://ZAMT_LTEA_SET_NST_INIT
				{
				    if(phy_ret == 0)
				    {
				    	send_ok(fd);
				    }
					else
					{
						send_error(fd);
					}
					break;
				}
				default:
				{
					AmtPrintf(AMT_INFO "%s: lte_phy_msg_id = %#04x\n", __FUNCTION__, phy_msg_id);		
					break;
				}
			}
			
			break;
		}
		default:
		{
			AmtPrintf(AMT_INFO "%s: unknown msg_id = %#04x\n", __FUNCTION__, msg_id);		
	    	break;
		}
	}

	return 1;
    
}

/**
 * @brief ȡcpķϢ̺߳
 * @param[in] args ̺߳
 * @return N/A
 * @note
 * @see 
 */
static void* ReadFromCPThread(void* args)
{
    // Read from AP-CP channel
    char *receive_buffer = NULL;

	UNUSED(args);
	
	receive_buffer = malloc(MAX_PACKET_LENGTH);
    if (receive_buffer == NULL)
    {
        return NULL;
    }

	prctl(PR_SET_NAME, "AmtReadFromCP");

    while (1)
    {
        int read_len = Amt_ReceiveData(g_amt_fd_cp, (unsigned char *)receive_buffer, MAX_PACKET_LENGTH);

        if (read_len > 0)
        {
            AmtPrintf(AMT_INFO "%s: Receive cp data, read_len = %d!.\n", __FUNCTION__, read_len);

            if (g_amt_fd_current && *g_amt_fd_current >= 0)
            {
                if(g_amt_at_mode != 1)
                {
                    Amt_SendData(*g_amt_fd_current, (unsigned char *)receive_buffer, read_len);
                }
				else
				{
					
                   At_SendData(*g_amt_fd_current, (unsigned char *)receive_buffer, read_len);
				}
            }
            else
            {
                AmtPrintf(AMT_ERROR "%s: Current fd is wrong.\n", __FUNCTION__);
            }

#if 0            
            unsigned int status = cpnv_FsGcWait(FS_NVROFS);
            if(status != CPNV_OK)
                AmtPrintf(AMT_INFO "%s: cpnv_FsGcWait fail, err = %d.\n", __FUNCTION__, status);
#endif
		}
    }

    free(receive_buffer);
    return NULL;
}


/**
 * @brief ȡappϢ̺߳
 * @param[in] args ̺߳
 * @return N/A
 * @note
 * @see 
 */
static void* RecvMsgFromAppThread(void* args)
{
    int iRet ;
    MSG_BUF stMsg = {0};
    LONG msgSize =  sizeof(MSG_BUF) - sizeof(LONG);

	UNUSED(args);

    prctl(PR_SET_NAME, "AmtRecvAppMsg");
    while(1)
    {
        iRet = 0;
        memset(&stMsg, 0x00, sizeof(MSG_BUF));

        iRet = msgrcv(g_amt_iMsgHandle, &stMsg, msgSize, 0, 0);
        if(iRet >= 0)
        {
            AmtPrintf(AMT_INFO "%s: msgcmd = 0x%x,datalen=%d.\n", __FUNCTION__,stMsg.usMsgCmd,stMsg.usDataLen);
			
            switch (stMsg.usMsgCmd)
            {
            case MSG_CMD_AMT_BATTERY_VOLTAGE_TEST_RSP:
            {
                AmtPrintf(AMT_INFO "%s: recv  MSG_CMD_AMT_BATTERY_VOLTAGE_TEST_RSP.\n", __FUNCTION__);
                int result = AMT_SUCCESS_RET;
                Amt_DeviceTest_SendMsg(MSG_DEVICETEST_BATTERY_VOLTAGE, result, (unsigned char *)stMsg.aucDataBuf, stMsg.usDataLen);
                break;
            }
            
            case MSG_CMD_AMT_KEY_TEST_START_RSP:
            {
                int result = AMT_ERROR_RET;
				int* pAucDataBuf = (int*)stMsg.aucDataBuf;
                result =  *pAucDataBuf;
                if (result ==  0)
                {
                    result = AMT_SUCCESS_RET;
                }
                else
                {
                    result = AMT_ERROR_RET;
                    AmtPrintf(AMT_INFO "%s: KEY_TEST_START fail.", __FUNCTION__);
                }

                 Amt_DeviceTest_SendMsg(MSG_DEVICETEST_KEYBOARD_START, result, NULL, 0);
                 break;
            }
            
            case MSG_CMD_AMT_KEY_TEST_STOP_RSP:
            {
                int result = AMT_SUCCESS_RET;
                Amt_DeviceTest_SendMsg(MSG_DEVICETEST_KEYBOARD_STOP, result, (unsigned char *)stMsg.aucDataBuf, stMsg.usDataLen);
                break;
            }
            
            case MSG_CMD_AMT_LCD_TEST_START_RSP:
            {
                int result = AMT_ERROR_RET;
				int* pAucDataBuf = (int*)stMsg.aucDataBuf;
                result =  *pAucDataBuf;
                if (result ==  0)
                {
                    result = AMT_SUCCESS_RET;
                }
                else
                {
                    result = AMT_ERROR_RET;
                    AmtPrintf(AMT_INFO "%s: LCD_TEST_START fail.", __FUNCTION__);
                }

                Amt_DeviceTest_SendMsg(MSG_DEVICETEST_LCD_START, result, NULL, 0);
                break;
            }
            
            case MSG_CMD_AMT_LCD_TEST_STOP_RSP:
            {
                int result = AMT_ERROR_RET;
				int* pAucDataBuf = (int*)stMsg.aucDataBuf;
                result =  *pAucDataBuf;
				AmtPrintf(AMT_INFO "%s: LCD_TEST_STOP result=%d\n", __FUNCTION__,result);
                if (result ==  0)
                {
                    result = AMT_SUCCESS_RET;
                }
                else
                {
                    result = AMT_ERROR_RET;
                    AmtPrintf(AMT_INFO "%s: LCD_TEST_STOP fail.", __FUNCTION__);
                }

                Amt_DeviceTest_SendMsg(MSG_DEVICETEST_LCD_STOP, result, NULL, 0);
                break;
            }

            case MSG_CMD_AMT_LCD_BACKLIGHT_TEST_START_RSP:
            {
                int result = AMT_ERROR_RET;
				int* pAucDataBuf = (int*)stMsg.aucDataBuf;
                result =  *pAucDataBuf;
                if (result ==  1)
                {
                    result = AMT_SUCCESS_RET;
                }
                else
                {
                    result = AMT_ERROR_RET;
                    AmtPrintf(AMT_INFO "%s: LCD_BACKLIGHT_TEST_START fail.", __FUNCTION__);
                }

                Amt_DeviceTest_SendMsg(MSG_DEVICETEST_LCDBACKLIGHT_START, result, NULL, 0);
                break;
            }
            
            case MSG_CMD_AMT_LCD_BACKLIGHT_TEST_STOP_RSP:
            {
                int result = AMT_ERROR_RET;
				int* pAucDataBuf = (int*)stMsg.aucDataBuf;
                result =  *pAucDataBuf;
                if (result ==  0)
                {
                    result = AMT_SUCCESS_RET;
                }
                else
                {
                    result = AMT_ERROR_RET;
                    AmtPrintf(AMT_INFO "%s: LCD_BACKLIGHT_TEST_STOP fail.", __FUNCTION__);
                }

                Amt_DeviceTest_SendMsg(MSG_DEVICETEST_LCDBACKLIGHT_STOP, result, NULL, 0);
                break;
            }

            case MSG_CMD_AMT_VIBRATOR_TEST_START_RSP:
            {
                int result = AMT_ERROR_RET;
				int* pAucDataBuf = (int*)stMsg.aucDataBuf;
                result =  *pAucDataBuf;
                if (result ==  1)
                {
                    result = AMT_SUCCESS_RET;
                }
                else
                {
                    result = AMT_ERROR_RET;
                    AmtPrintf(AMT_INFO "%s: VIBRATOR_TEST_START fail.", __FUNCTION__);
                }

                Amt_DeviceTest_SendMsg(MSG_DEVICETEST_VIBRATOR_START, result, NULL, 0);
                break;
            }
            
            case MSG_CMD_AMT_VIBRATOR_TEST_STOP_RSP:
            {
                int result = AMT_ERROR_RET;
				int* pAucDataBuf = (int*)stMsg.aucDataBuf;
                result =  *pAucDataBuf;
                if (result ==  0)
                {
                    result = AMT_SUCCESS_RET;
                }
                else
                {
                    result = AMT_ERROR_RET;
                    AmtPrintf(AMT_INFO "%s: VIBRATOR_TEST_STOP fail.", __FUNCTION__);
                }

                Amt_DeviceTest_SendMsg(MSG_DEVICETEST_VIBRATOR_STOP, result, NULL, 0);
                break;
            }

            case MSG_CMD_AMT_CAMERA_TEST_START_RSP:
            {
                int result = AMT_ERROR_RET;
				int* pAucDataBuf = (int*)stMsg.aucDataBuf;
                result =  *pAucDataBuf;
                if (result ==  1)
                {
                    result = AMT_SUCCESS_RET;
                }
                else
                {
                    result = AMT_ERROR_RET;
                    AmtPrintf(AMT_INFO "%s: CAMERA_TEST_START fail.", __FUNCTION__);
                }

                Amt_DeviceTest_SendMsg(MSG_DEVICETEST_CAMERA_BACK_START, result, NULL, 0);
                break;
            }
            
            case MSG_CMD_AMT_CAMERA_TEST_STOP_RSP:
            {
                int result = AMT_ERROR_RET;
				int* pAucDataBuf = (int*)stMsg.aucDataBuf;
                result =  *pAucDataBuf;
                if (result ==  0)
                {
                    result = AMT_SUCCESS_RET;
                }
                else
                {
                    result = AMT_ERROR_RET;
                    AmtPrintf(AMT_INFO "%s: CAMERA_TEST_STOP fail.", __FUNCTION__);
                }

                Amt_DeviceTest_SendMsg(MSG_DEVICETEST_CAMERA_BACK_STOP, result, NULL, 0);
                break;
            }

            case MSG_CMD_AMT_SPEAKER_TEST_RSP:
            {
                AmtPrintf(AMT_INFO "%s: recv  MSG_CMD_AMT_SPEAKER_TEST_RSP.\n", __FUNCTION__);
                int result = AMT_ERROR_RET;
				int* pAucDataBuf = (int*)stMsg.aucDataBuf;
                result =  *pAucDataBuf;
                if (result ==  1)
                {
                    result = AMT_SUCCESS_RET;
                }
                else
                {
                    result = AMT_ERROR_RET;
                    AmtPrintf(AMT_INFO "%s: SPEAKER_TEST fail.", __FUNCTION__);
                }

                Amt_DeviceTest_SendMsg(MSG_DEVICETEST_AUDIO_MIC_SPEAKER, result, NULL, 0);
                break;
            }

            case MSG_CMD_AMT_SPEAKER_TEST_STOP_RSP:
            {
                AmtPrintf(AMT_INFO "%s: recv  MSG_CMD_AMT_SPEAKER_TEST_STOP_RSP.\n", __FUNCTION__);
                int result = AMT_SUCCESS_RET;
                Amt_DeviceTest_SendMsg(MSG_DEVICETEST_AUDIO_MIC_SPEAKER_STOP, result, NULL, 0);
                break;
            }
            
            case MSG_CMD_AMT_RECEIVER_TEST_RSP:
            {
                AmtPrintf(AMT_INFO "%s: recv  MSG_CMD_AMT_RECEIVER_TEST_RSP.\n", __FUNCTION__);
                int result = AMT_ERROR_RET;
				int* pAucDataBuf = (int*)stMsg.aucDataBuf;
                result =  *pAucDataBuf;
                if (result ==  1)
                {
                    result = AMT_SUCCESS_RET;
                }
                else
                {
                    result = AMT_ERROR_RET;
                    AmtPrintf(AMT_INFO "%s: RECEIVER_TEST fail.", __FUNCTION__);
                }

                Amt_DeviceTest_SendMsg(MSG_DEVICETEST_AUDIO_MIC_RECEIVER, result, NULL, 0);
                break;
            }

            case MSG_CMD_AMT_RECEIVER_TEST_STOP_RSP:
            {
                AmtPrintf(AMT_INFO "%s: recv  MSG_CMD_AMT_RECEIVER_TEST_STOP_RSP.\n", __FUNCTION__);
                int result = AMT_SUCCESS_RET;
                Amt_DeviceTest_SendMsg(MSG_DEVICETEST_AUDIO_MIC_RECEIVER_STOP, result, NULL, 0);
                break;
            }

            case MSG_CMD_AMT_TP_TEST_START_RSP:
            {
                int result = AMT_ERROR_RET;
				int* pAucDataBuf = (int*)stMsg.aucDataBuf;
                result =  *pAucDataBuf;
                if (result ==  1)
                {
                    result = AMT_SUCCESS_RET;
                }
                else
                {
                    result = AMT_ERROR_RET;
                    AmtPrintf(AMT_INFO "%s: TP_TEST_START fail.", __FUNCTION__);
                }

                Amt_DeviceTest_SendMsg(MSG_DEVICETEST_TP_START, result, NULL, 0);
                break;
            }
            
            case MSG_CMD_AMT_TP_TEST_STOP_RSP:
            {
                int result = AMT_ERROR_RET;
				int* pAucDataBuf = (int*)stMsg.aucDataBuf;
                result =  *pAucDataBuf;
                if (result ==  0)
                {
                    result = AMT_SUCCESS_RET;
                }
                else
                {
                    result = AMT_ERROR_RET;
                    AmtPrintf(AMT_INFO "%s: TP_TEST_STOP fail.", __FUNCTION__);
                }

                Amt_DeviceTest_SendMsg(MSG_DEVICETEST_TP_STOP, result, NULL, 0);
                break;
            }

            case MSG_CMD_AMT_GSENSOR_TEST_START_RSP:
            {
                break;
            }
            
            case MSG_CMD_AMT_GSENSOR_TEST_STOP_RSP:
            {
                break;
            }
			
	        case MSG_CMD_AMT_WIFI_TEST_START_RSP:
			{
				int result = AMT_ERROR_RET;
				int* pAucDataBuf = (int*)stMsg.aucDataBuf;
				result =  *pAucDataBuf;
                if (result ==  1)
                {
                	result = AMT_SUCCESS_RET;
                }
				else
				{
					result = AMT_ERROR_RET;
					AmtPrintf(AMT_INFO "%s: Wifi test fail!", __FUNCTION__);
				}

				Amt_DeviceTest_SendMsg(MSG_DEVICETEST_WIFI, result, NULL, 0);
				break;
			}

			case MSG_CMD_AMT_FLASHLIGHT_START_RSP:
			{
				int result = AMT_ERROR_RET;
				int* pAucDataBuf = (int*)stMsg.aucDataBuf;
				result =  *pAucDataBuf;
                if (result ==  1)
                {
                	result = AMT_SUCCESS_RET;
                }
				else
				{
					result = AMT_ERROR_RET;
					AmtPrintf(AMT_INFO "%s: flashlight test fail!", __FUNCTION__);
				}

				Amt_DeviceTest_SendMsg(MSG_DEVICETEST_FLASHLIGHT_START, result, NULL, 0);
				break;
			}
			//gpsϢӦ
            case KWATCH_MSG_GPS_RSP:
            {
                Amt_Process_Gps_Rsp(&stMsg,FID_GPS_MODULE_TEST);
                break;
            }
            default:
                break;
        }
      }
    }
	return NULL;
}


/**
 * @brief ذ΢WIFI̼
 * @param[in] args ̺߳
 * @return N/A
 * @note
 * @see 
 */
static void* LoadWifiFirmwareThread(void* args)
{
    int ret = -1;
    UNUSED(args);
	
	prctl(PR_SET_NAME, "LoadWifiFirmwareThread");

	#if (defined(__AIC_8800DW_CHIP__))
	ret = wifi_ioctl_handle(3); //زԹ̼
	if(ret < 0)
	{
		AmtPrintf(AMT_ERROR "%s: load AIC_8800DW firmware fail! ret=%d.\n", __FUNCTION__, ret);
	}
    else
	{
		AmtPrintf(AMT_INFO "%s: load AIC_8800DW firmware success! ret=%d.\n", __FUNCTION__, ret);
	}
	#endif
	
    return NULL;
}


/**
 * @brief AMTϢCP
 * @param[in] fd ļ
 * @param[in] msg_id FID
 * @param[in] buf buffer
 * @param[in] buf_len buffer
 * @return ɹ0
 * @note
 * @see 
 */
static int Amt_SendMessageToAmtagent(int fd, unsigned int msg_id, unsigned char* buf, unsigned int buf_len)
{
    // STX  TID  FID   Data  Check  ETX
    unsigned int CmdCount = 1 + 1 + 1 + buf_len + 1   + 1;
    unsigned char *pRsp = NULL;
    unsigned char *pSTX = NULL;
    unsigned char *pETX = NULL;
    unsigned char *pTID = NULL;
    unsigned char *pFID = NULL;
    unsigned char *pCheck = NULL;
    unsigned char *pData = NULL;
    unsigned char CheckSum = 0;
    unsigned int i = 0;

    pRsp = malloc(CmdCount);
	if(pRsp == NULL)
		return -1;
    memset(pRsp, 0, CmdCount);

    pSTX = &pRsp[0];
    pETX = &pRsp[1 + 1 + 1 + buf_len + 1];
    pTID = &pRsp[1];
    pFID = &pRsp[1 + 1];
    pCheck = &pRsp[1 + 1 + 1 + buf_len];
    pData = &pRsp[1 + 1 + 1];
	
    *pSTX = 0x02;
    *pETX = 0x02;
    *pTID = (msg_id & 0xFF00) >> 8;
    *pFID = (msg_id & 0xFF);

    if (buf != NULL && buf_len > 0)
    {
        memcpy(pData, buf, buf_len);
    }

    CheckSum = 0;

    for (i = 0; i < (1 + 1 + buf_len); i++)
        CheckSum ^= pRsp[1 + i];

    *pCheck = CheckSum;

    Amt_SendDataToAmtagent(fd, pRsp, CmdCount);

    free(pRsp);
    return 0;
}


/**
 * @brief AMTϢPC
 * @param[in] fd ļ
 * @param[in] msg_id FID
 * @param[in] buf buffer
 * @param[in] buf_len buffer
 * @return ɹ0
 * @note
 * @see 
 */
static int Amt_SendMessage(int fd, unsigned int msg_id, unsigned char* buf, unsigned int buf_len)
{
    // STX  TID  FID   Data  Check  ETX
    unsigned int CmdCount = 1 + 1 + 1 + buf_len + 1   + 1;
    unsigned char *pRsp = NULL;
    unsigned char *pSTX = NULL;
    unsigned char *pETX = NULL;
    unsigned char *pTID = NULL;
    unsigned char *pFID = NULL;
    unsigned char *pCheck = NULL;
    unsigned char *pData = NULL;
    unsigned char CheckSum = 0;
    unsigned int i = 0;

    pRsp = malloc(CmdCount);
	if(pRsp == NULL)
		return -1;
    memset(pRsp, 0, CmdCount);

    pSTX = &pRsp[0];
    pETX = &pRsp[1 + 1 + 1 + buf_len + 1];
    pTID = &pRsp[1];
    pFID = &pRsp[1 + 1];
    pCheck = &pRsp[1 + 1 + 1 + buf_len];
    pData = &pRsp[1 + 1 + 1];

    *pSTX = 0x02;
    *pETX = 0x02;
    *pTID = (msg_id & 0xFF00) >> 8;
    *pFID = (msg_id & 0xFF);

    if (buf != NULL && buf_len > 0)
    {
        memcpy(pData, buf, buf_len);
    }

    CheckSum = 0;

    for (i = 0; i < (1 + 1 + buf_len); i++)
        CheckSum ^= pRsp[1 + i];

    *pCheck = CheckSum;

    Amt_SendData(fd, pRsp, CmdCount);

    free(pRsp);
    return 0;
}

#ifdef USE_CAP_SUPPORT
/**
 * @brief AMTϢ
 * @param[in] fd ļ
 * @param[in] buf buffer
 * @param[in] buf_len buffer
 * @return ط͵ݳ
 * @note
 * @see 
 */
static int Amt_SendDataToCAP(int fd, unsigned char* buf, unsigned int buf_len)
{
    int write_len = PortSend(fd, (unsigned char*)&buf_len, sizeof(unsigned int), WAIT_ALL);

    if (write_len != sizeof(unsigned int))
    {
        AmtPrintf(AMT_ERROR "%s: Failed to send data_len to fd(%d)! write_len = %d.\n",
                  __FUNCTION__, fd, write_len);
        write_len = 0;
    }
    else
    {
        if (buf != NULL && buf_len > 0)
        {
            write_len = PortSend(fd, buf, buf_len, WAIT_ALL);

            if (write_len != (int)buf_len)
            {
                AmtPrintf(AMT_ERROR "%s: Failed to send data to fd(%d)! (write_len = %d) != (buf_len = %d).\n",
                          __FUNCTION__, fd, write_len, buf_len);
            }
        }
    }

    return write_len;
}


/**
 * @brief AMTϢCAP
 * @param[in] fd ļ
 * @param[in] msg_id FID
 * @param[in] buf buffer
 * @param[in] buf_len buffer
 * @return ɹ0
 * @note
 * @see 
 */
static int Amt_SendMessageToCAP(int fd, unsigned int msg_id, unsigned char* buf, unsigned int buf_len)
{
    // STX  TID  FID   Data  Check  ETX
    unsigned int CmdCount = 1 + 1 + 1 + buf_len + 1   + 1;
    unsigned char *pRsp = NULL;
    unsigned char *pSTX = NULL;
    unsigned char *pETX = NULL;
    unsigned char *pTID = NULL;
    unsigned char *pFID = NULL;
    unsigned char *pCheck = NULL;
    unsigned char *pData = NULL;
    unsigned char CheckSum = 0;
    unsigned int i = 0;

    pRsp = malloc(CmdCount);
	if(pRsp == NULL)
		return -1;
    memset(pRsp, 0, CmdCount);

    pSTX = &pRsp[0];
    pETX = &pRsp[1 + 1 + 1 + buf_len + 1];
    pTID = &pRsp[1];
    pFID = &pRsp[1 + 1];
    pCheck = &pRsp[1 + 1 + 1 + buf_len];
    pData = &pRsp[1 + 1 + 1];
	
    *pSTX = 0x02;
    *pETX = 0x02;
    *pTID = (msg_id & 0xFF00) >> 8;
    *pFID = (msg_id & 0xFF);

    if (buf != NULL && buf_len > 0)
    {
        memcpy(pData, buf, buf_len);
    }

    CheckSum = 0;

    for (i = 0; i < (1 + 1 + buf_len); i++)
        CheckSum ^= pRsp[1 + i];

    *pCheck = CheckSum;

    Amt_SendDataToCAP(fd, pRsp, CmdCount);

    free(pRsp);
    return 0;
}
#endif



/**
 * @brief AMTϢ
 * @param[in] msg_id FID
 * @param[in] buf buffer
 * @param[in] buf_len buffer
 * @return ɹ0
 * @note
 * @see 
 */
static int Amt_ProcessMessage(unsigned int msg_id, unsigned char* buf, unsigned int buf_len)
{
    if (msg_id >= FID_WIFI_CMD_NORTN && msg_id <= FID_WIFI_CMD_END) // wifi test
    {
        Amt_Wifi_ProcessMsg(msg_id, buf, buf_len);
    }
    else if (msg_id == FID_GET_CHIP_PLATFORM)
    {
         //
	    if(is_amt_mode())
	    {
	    	AmtPrintf(AMT_ERROR "AMT MODE!\n");
	    }
	    else
	    {
	    	AmtPrintf(AMT_ERROR "Normal MODE!\n");
	    }
        unsigned char chipType = 0;
        AmtPrintf(AMT_INFO "%s: Get chip platform msg_id = %#04x, buf_len = %d.\n",
                  __FUNCTION__, msg_id, buf_len);
        chipType = 1; /*1:7520V3 2:7100*/

        if (Amt_CreateResponse(msg_id, &chipType, sizeof(unsigned char)) == -1)
        {
            AmtPrintf(AMT_ERROR "%s: Send data failure.\n", __FUNCTION__);
        }
        else
        {
            AmtPrintf(AMT_INFO "%s: Send data success.\n", __FUNCTION__);
        }
    }
    else if (msg_id >= FID_GPS_MODULE_TEST && msg_id <= FID_GPS_CMD_END) // gps test
    {
        Amt_Gps_ProcessMsg(msg_id, buf, buf_len);
    }
    else if (msg_id >= MSG_DEVICETEST_START && msg_id <= MSG_DEVICETEST_END)
    {
        Amt_DeviceTest_ProcessMsg(msg_id, buf, buf_len);
    }
	else if (msg_id == FID_AMT_END)
    {
		unsigned int status = CPNV_OK;//cpnv_ChangeFsPartitionAttr(FS_NVROFS, 1);
		/*
	       if(status != CPNV_OK)
		{
			AmtPrintf(AMT_ERROR "%s: cpnv_ChangeFsPartitionAttr RW nvrofs failed!\n", __FUNCTION__);
			return -1;
		}*/
		
        status = cpnv_FsGcWait(FS_NVROFS);
		if(status == CPNV_OK)
			AmtPrintf(AMT_INFO "%s: cpnv_FsGcWait ok.\n", __FUNCTION__);
		else
			AmtPrintf(AMT_INFO "%s: cpnv_FsGcWait fail, err = %d.\n", __FUNCTION__, status);

		if (Amt_CreateResponse(msg_id, (unsigned char*)&status, sizeof(unsigned int)) == -1)
        {
            AmtPrintf(AMT_ERROR "%s: Send data failure.\n", __FUNCTION__);
        }
        else
        {
            AmtPrintf(AMT_INFO "%s: Send data success.\n", __FUNCTION__);
        }
    }
	else if (msg_id == FID_AMT_EXIT)
	{
	    unsigned int status = 0;
		if (Amt_CreateResponse(msg_id, (unsigned char*)&status, sizeof(unsigned int)) == -1)
        {
            AmtPrintf(AMT_ERROR "%s: Send data failure.\n", __FUNCTION__);
        }
        else
        {
            AmtPrintf(AMT_INFO "%s: Send data success.\n", __FUNCTION__);
        }
	}
    else if (msg_id == FID_EX_COMMON_SETBOOTMODE)
    {
        // set normal mode
        unsigned char bootmode[] = {0xFF, 0xFF};        
		unsigned int dwRet = CPNV_OK;

        //struct timespec ts;
		//clock_gettime(CLOCK_MONOTONIC, &ts);
		//AmtPrintf(AMT_INFO "[%8d.%03d] %s: cpnv_FsGcWait start.\n", ts.tv_sec, ts.tv_nsec / 1000000,__FUNCTION__);
        unsigned char mode = 4;
		if(buf_len == sizeof(mode))
		{
		    memcpy(&mode, buf, sizeof(mode));
		}
		AmtPrintf(AMT_INFO "%s: boot mode=%d\n", __FUNCTION__,mode);
		switch(mode)
		{
		     case 0: //user mode
             {   
                 nv_set_item(NV_RO, "usb_modetype", "user", 1);
				 nv_commit(NV_RO);
				 bootmode[0] =0x54;
                 bootmode[1] =0x00;
                 break;
             }
             case 1://debug mode
             {
                 nv_set_item(NV_RO, "usb_modetype", "debug", 1);
				 nv_commit(NV_RO);
				 bootmode[0] =0x54;
                 bootmode[1] =0x01;
                 break;
             }
             case 2://factory mode
             {
                 nv_set_item(NV_RO, "usb_modetype", "factory", 1);
				 nv_commit(NV_RO);
				 bootmode[0] =0x54;
                 bootmode[1] =0x02;
                 break;
             }
             case 3://amt mode
             {
			 	 //nv_set_item(NV_RO, "usb_modetype", "amt", 1);
			 	 //nv_commit(NV_RO);
				 bootmode[0] =0x54;
                 bootmode[1] =0x4D;
                 break;
             }
             default:
             {
                 break;
             }
		}

        dwRet = amt_set_bootmode(bootmode);
        if (dwRet == CPNV_OK)
        {
            AmtPrintf(AMT_INFO "%s: set boot mode: sucess.\n", __FUNCTION__);
        }
        else
        {
            AmtPrintf(AMT_ERROR "%s: set boot mode: failed.\n", __FUNCTION__);
        }
		//clock_gettime(CLOCK_MONOTONIC, &ts);
		//AmtPrintf(AMT_INFO "[%8d.%03d] %s: cpnv_FsGcWait ok.\n", ts.tv_sec, ts.tv_nsec / 1000000, __FUNCTION__);
      
        if (Amt_CreateResponse(msg_id, (unsigned char*)&dwRet, sizeof(unsigned int)) == -1)
        {
            AmtPrintf(AMT_ERROR "%s: Send data failure.\n", __FUNCTION__);
        }
        else
        {
            AmtPrintf(AMT_INFO "%s: Send data success.\n", __FUNCTION__);
        }
    }
	else if(msg_id == FID_CHECK_SOFTDOG_CIPHER_TEXT)
    {
        UINT8 softdog_cipher_texts[OS_FLASH_AMT_COMM_RO_SOFTDOG_CIPHER_TEXT_SIZE] = {0};
    	if(!amt_read_nv_item(ABSOFTDOG_CIPHER_TEXT_NVPARAM,softdog_cipher_texts,sizeof(softdog_cipher_texts)))
    	{
        	if (Amt_CreateResponse(msg_id, softdog_cipher_texts, sizeof(softdog_cipher_texts)) == -1)
            {
           		AmtPrintf(AMT_ERROR "%s: Send data failure.\n", __FUNCTION__);
        	}
       		else
        	{
            	AmtPrintf(AMT_INFO "%s: Send data success.\n", __FUNCTION__);
       		}
    	}
	    else
	    {
			AmtPrintf(AMT_ERROR "%s: read softdog cipher text in address:0x%x failure.\n", __FUNCTION__,OS_FLASH_AMT_COMM_RO_SOFTDOG_CIPHER_TEXT_ADDRESS);
		}
    }
	else if(msg_id == FID_SET_BAT_DET_FLAG)
    {
        unsigned int  retCode = CPNV_ERROR;
        int bat_value = -1;
        memcpy(&bat_value, buf, sizeof(int));
		retCode =amt_set_batdet_flag(bat_value);   
    
        if (retCode == CPNV_OK)
        {
        	AmtPrintf(AMT_INFO "%s: amt_set_batdet_flag success.\n", __FUNCTION__);
		}
    	else
    	{
    		AmtPrintf(AMT_INFO "%s: amt_set_batdet_flag fail.\n", __FUNCTION__);  
    	}
		if (Amt_CreateResponse(msg_id, (unsigned char*)&retCode, sizeof(retCode)) == -1)
        {
        	AmtPrintf(AMT_ERROR "%s: Send data failure.\n", __FUNCTION__);
        }
       	else
        {
        	AmtPrintf(AMT_INFO "%s: Send data success.\n", __FUNCTION__);
       	}
    }
	else if(msg_id == FID_GET_BAT_DET_FLAG)
    {
        unsigned int  retCode = CPNV_ERROR;
        int bat_value = 0;
        retCode =amt_get_batdet_flag(&bat_value);   
    
        if (retCode == CPNV_OK)
        {
        	AmtPrintf(AMT_INFO "%s: amt_get_batdet_flag success.bat_value=%d\n", __FUNCTION__,bat_value);
			if (Amt_CreateResponse(msg_id, (unsigned char*)&bat_value, sizeof(bat_value)) == -1)
	        {
	        	AmtPrintf(AMT_ERROR "%s: Send data failure.\n", __FUNCTION__);
	        }
	       	else
	        {
	        	AmtPrintf(AMT_INFO "%s: Send data success.\n", __FUNCTION__);
	       	}
		}
    	else
    	{
    		AmtPrintf(AMT_INFO "%s: amt_get_batdet_flag fail.\n", __FUNCTION__);  
    	}
	}
	else if(msg_id == FID_RINISOFTVERSION)
    {
        unsigned int retCode = CPNV_ERROR;
	    char TmpSoftVersion[ZPS_REF_MSINFO_MAX_SOFTVERSION_INT_LEN+1]={0};

	    retCode = cpnv_NvItemRead(ZPS_REF_MSINFO_SOFTVERSION_INT_BASE_ADDR, (unsigned char*)TmpSoftVersion, ZPS_REF_MSINFO_MAX_SOFTVERSION_INT_LEN);
	    if (retCode == CPNV_OK)
        {
            TmpSoftVersion[ZPS_REF_MSINFO_MAX_SOFTVERSION_INT_LEN] = '\0';
            AmtPrintf(AMT_INFO "%s: inner version=%s\n", __FUNCTION__,TmpSoftVersion);
			if (Amt_CreateResponse(msg_id, (unsigned char*)TmpSoftVersion, sizeof(TmpSoftVersion)) == -1)
	        {
	        	AmtPrintf(AMT_ERROR "%s: Send data failure.\n", __FUNCTION__);
	        }
	       	else
	        {
	        	AmtPrintf(AMT_INFO "%s: Send data success.\n", __FUNCTION__);
	       	}
		}
    	else
    	{
    	    AmtPrintf(AMT_INFO "%s: get inner version fail!\n", __FUNCTION__);  
    	}	
    }
	else if(msg_id == FID_ROUTSOFTVERSION)
    {
        unsigned int retCode = CPNV_ERROR;
        char TmpExtcgmr[ZPS_REF_MSINFO_MAX_SOFTVERSION_EXT_LEN+1]={0};

	    retCode =cpnv_NvItemRead(ZPS_REF_MSINFO_SOFTVERSION_EXT_BASE_ADDR, (unsigned char *)TmpExtcgmr, ZPS_REF_MSINFO_MAX_SOFTVERSION_EXT_LEN);
	    if (retCode == CPNV_OK)
        {
            TmpExtcgmr[ZPS_REF_MSINFO_MAX_SOFTVERSION_EXT_LEN] = '\0';
            AmtPrintf(AMT_INFO "%s: outer version=%s\n", __FUNCTION__,TmpExtcgmr);
			if (Amt_CreateResponse(msg_id, (unsigned char*)TmpExtcgmr, sizeof(TmpExtcgmr)) == -1)
	        {
	        	AmtPrintf(AMT_ERROR "%s: Send data failure.\n", __FUNCTION__);
	        }
	       	else
	        {
	        	AmtPrintf(AMT_INFO "%s: Send data success.\n", __FUNCTION__);
	       	}
		}
    	else
    	{
            AmtPrintf(AMT_INFO "%s: get outer version fail!\n", __FUNCTION__);  
    	}		
    }
	else if((msg_id >= FID_FUN_TEST_START)&&(msg_id <= FID_FUN_TEST_END))
	{
		Amt_FuncTest_ProcessMsg(msg_id, buf, buf_len);
	}
	#ifdef USE_CAP_SUPPORT
	else if((msg_id >= FID_CAP_TEST_START)&&(msg_id <= FID_CAP_TEST_END))
	{
		 AmtPrintf(AMT_INFO "%s: receive cap msg.\n", __FUNCTION__);
        // Send message to CAP
        if (Amt_SendMessageToCAP(g_amt_fd_cap, msg_id, buf, buf_len) == -1)
        {
            AmtPrintf(AMT_ERROR "%s: Failed to send data to cap, msg_id = %#04x, buf_len = %d.\n",
                      __FUNCTION__, msg_id, buf_len);
        }
        else
        {
            AmtPrintf(AMT_INFO "%s: Send data to cap, msg_id = %#04x, buf_len = %d.\n",
                      __FUNCTION__, msg_id, buf_len);
        }
	}
	#endif
    else // CP message
    {
        AmtPrintf(AMT_INFO "%s: receive old cp msg.\n", __FUNCTION__);
        // Send message to CP
       if (Amt_SendMessageToAmtagent(g_amt_fd_cp, msg_id, buf, buf_len) == -1)
        {
            AmtPrintf(AMT_ERROR "%s: Failed to send data to cp, msg_id = %#04x, buf_len = %d.\n",
                      __FUNCTION__, msg_id, buf_len);
        }
        else
        {
            AmtPrintf(AMT_INFO "%s: Send data to cp, msg_id = %#04x, buf_len = %d.\n",
                      __FUNCTION__, msg_id, buf_len);
        }
    }

    return 0;
}


/**
 * @brief AMTϢ
 * @param[in] buf buffer
 * @param[in] buf_len buffer
 * @return N/A
 * @note
 * @see 
 */
static void Amt_ComposeAndProcess(unsigned char *buf, unsigned int buf_len)
{
    unsigned char *pSTX = NULL;
    unsigned char *pETX = NULL;
    unsigned char *pTID = NULL;
    unsigned char *pFID = NULL;
    unsigned char *pCheck = NULL;
    unsigned char *pData = NULL;
    unsigned char CheckSum = 0;
    unsigned int msg_id;
    unsigned int i = 0;
    pTID = pTID;
    pCheck = pCheck;
    pData = pData;

    pSTX = &buf[0];
    pETX = &buf[buf_len - 1];
    pTID = &buf[1];
    pFID = &buf[1 + 1];
    pCheck = &buf[buf_len - 2];
    pData = &buf[1 + 1 + 1];

    if (!((0x02 == *pSTX) && (0x02 == *pETX)))
    {
        return;
    }

    CheckSum = 0;

    for (i = 0; i < (buf_len - 2); i++)
        CheckSum ^= buf[1 + i];

    if (CheckSum != 0)
    {
        return;
    }

    // TIDFIDʹչܺ
    msg_id = (*pTID << 8) | *pFID;

    AmtPrintf(AMT_INFO "%s: msg_id = %#04x, buf_len = %d.\n", __FUNCTION__, msg_id, buf_len);
    Amt_ProcessMessage(msg_id, pFID + 1, (buf_len - 1 - 1 - 1 - 1 - 1));
}


/**
 * @brief AMTϢ
 * @param[in] msg_id FID
 * @param[in] buf buffer
 * @param[in] buf_len buffer
 * @return ɹ0, ʧܷ-1
 * @note
 * @see 
 */
int Amt_CreateResponse(unsigned int msg_id, unsigned char* buf, unsigned int buf_len)
{
    if (g_amt_fd_current && *g_amt_fd_current >= 0)
    {
        return Amt_SendMessage(*g_amt_fd_current, msg_id, buf, buf_len);
    }
    else
    {
        AmtPrintf(AMT_ERROR "%s: Current fd is wrong.\n", __FUNCTION__);
        return -1;
    }
}

int wfsystem(const char * cmd)
{
	pid_t ret  =  0 ;
	ret = soft_system(cmd);
	AmtPrintf (AMT_ERROR "[%s]ret = %d, WIFEXITED(ret)=%d, WEXITSTATUS(ret) =%d",cmd, ret , WIFEXITED (ret), WEXITSTATUS (ret));
	if (! (-1 != ret && WIFEXITED (ret) && 0 == WEXITSTATUS (ret))) {
		return -1;
	}
	return 0;
}

int check_wlan (void)
{
	int find_wlan = -1;
	int i = 0, sum = 0;

	while (-1 == find_wlan) {
		AmtPrintf (AMT_ERROR "finding wlan  i=%d, %d s...", i , sum);
		find_wlan = wfsystem ("ifconfig wlan0");
		if (-1==find_wlan) {
			if (sum >= 60)
				return  -1;
			sum += 2 * i;
			sleep (2 * i++);
		}
	}
	return 0;
}

int Amt_ExecuteCmd(char *pcmd, char *pbuffer, int len)
{
    FILE *pPipe;
	static int wifi_init = 0;
    AmtPrintf(AMT_INFO "%s: execute \"%s\"!\n", __FUNCTION__, pcmd);
    if(0 == wifi_init)
    {
		if(0 == strcmp(pcmd, "ifconfig wlan0 up")){
			check_wlan();
			wifi_init = 1;
		}
	}
	
    if ((pPipe = popen(pcmd, "r")) == NULL)
    {
        AmtPrintf(AMT_ERROR "popen \"%s\" failure.\n", pcmd);
        return -1;
    }

    int read_len = fread(pbuffer, 1, len, pPipe);
    //AmtPrintf(AMT_INFO "fread, read_len = %d, pbuffer = %s.\n", read_len, pbuffer);

    pclose(pPipe);
    return read_len;
}

static int init_cp_channel(void)
{
    int fd = open(AMT_CP_CHANNEL, O_RDWR);

    if (fd < 0)
    {
        AmtPrintf(AMT_ERROR "Failed to open \"%s\"!\n", AMT_CP_CHANNEL);
        return -1;
    }

    if(ioctl(fd, RPMSG_CREATE_CHANNEL, (8*1024))!= 0)   // ͨС8K
    {
        AmtPrintf(AMT_ERROR "ioctrl:RPMSG_CREATE_CHANNEL fail!\n");
    }
    if(ioctl(fd, RPMSG_SET_INT_FLAG, NULL)!= 0)       // Ϣʱж
    {
        AmtPrintf(AMT_ERROR "ioctrl:RPMSG_SET_INT_FLAG fail!\n");
    }
    if(ioctl(fd, RPMSG_CLEAR_POLL_FLAG, NULL)!= 0)      // ķʽ
    {
        AmtPrintf(AMT_ERROR "ioctrl:RPMSG_CLEAR_POLL_FLAG fail!\n");
	}
    return fd;
}

static int init_usb_device(void)
{
    int fd = open(AMT_USB_DEV, O_RDWR);

    if (fd < 0)
    {
        AmtPrintf(AMT_ERROR "Failed to open \"%s\"!\n", AMT_USB_DEV);
        return -1;
    }

    PortSet(fd);
    return fd;
}

static int init_hotplug_nl(void)
{
    struct sockaddr_nl snl;
    bzero(&snl, sizeof(snl));
    snl.nl_family = AF_NETLINK;
    snl.nl_pid = getpid();
    snl.nl_groups = 1;

    int s = socket(PF_NETLINK, SOCK_DGRAM, NETLINK_KOBJECT_UEVENT);
    if (s == -1)
    {
        AmtPrintf(AMT_ERROR "Can't create hotplug socket!\n");
        return -1;
    }

    if (bind(s, (struct sockaddr *)&snl, sizeof(snl)) < 0)
    {
        AmtPrintf(AMT_ERROR "Can't bind hotplug socket!\n");
		close(s);
        return -1;
    }

    return s;
}

static int init_socket(int port)
{
    struct sockaddr_in seraddr;
    int sockfd = -1;

    AmtPrintf(AMT_INFO "port = %d.\n", port);

    sockfd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
    if (sockfd == -1)
    {
        AmtPrintf(AMT_ERROR "Can't create socket!\n");
        return -1;
    }

    memset(&seraddr,0,sizeof(seraddr));
    seraddr.sin_family = AF_INET;
    seraddr.sin_addr.s_addr = 0;
    seraddr.sin_port = htons(port);

    if (bind(sockfd, (struct sockaddr*)(&seraddr), sizeof(seraddr)) < 0)
    {
        AmtPrintf(AMT_ERROR "Can't bind port %d!\n", port);
		close(sockfd);
        return -1;
    }

    if (listen(sockfd, 1) == -1)
    {
        AmtPrintf(AMT_ERROR "Socket listen failed!\n");
		close(sockfd);
        return -1;
    }

    return sockfd;
}

#ifdef USE_CAP_SUPPORT
static int init_cap_channel(void)
{
    int fd = open(AMT_CAP_DEV, O_RDWR);

    if (fd < 0)
    {
        AmtPrintf(AMT_ERROR "Failed to open \"%s\"!\n", AMT_CAP_DEV);
        return -1;
    }

    if(ioctl(fd, RPMSG_CREATE_CHANNEL, (4*1024))!= 0)   // ͨС4K
    {
        AmtPrintf(AMT_ERROR "ioctrl:RPMSG_CREATE_CHANNEL fail!\n");
    }
    if(ioctl(fd, RPMSG_SET_INT_FLAG, NULL)!= 0)       // Ϣʱж
    {
        AmtPrintf(AMT_ERROR "ioctrl:RPMSG_SET_INT_FLAG fail!\n");
    }
    if(ioctl(fd, RPMSG_CLEAR_POLL_FLAG, NULL)!= 0)      // ķʽ
    {
        AmtPrintf(AMT_ERROR "ioctrl:RPMSG_CLEAR_POLL_FLAG fail!\n");
	}
    return fd;
}
#endif


static void set_fd(int fd)
{
    FD_SET(fd, &g_amt_fdsread);
    if (fd >= g_amt_fd_max)
    {
        g_amt_fd_max = fd + 1;
    }
}

static void clr_fd(int fd)
{
    FD_CLR(fd, &g_amt_fdsread);
}

static int CreateSendPacket(unsigned     short fid, unsigned char *data_buf, int data_len, unsigned char*packet_buf)
{
    int bRet = 0;
    BYTE *pSTX = NULL;
    BYTE *pETX = NULL;
	//FIDĸֽ
    BYTE *pHFID = NULL;
	//FIDĵֽ
    BYTE *pLFID = NULL;
    BYTE *pCheck = NULL;
    BYTE *pData = NULL;
    BYTE CheckSum = 0;
	int i = 0;

    //            STX FID  Data Check  ETX
    int CmdCount = 1 + 2 + data_len + 1   + 1;

    if ((data_len != 0) && (NULL == data_buf))
    {
        return bRet;
    }

    pSTX = &packet_buf[0];
    pETX = &packet_buf[1 + 2 + data_len + 1];
    pHFID = &packet_buf[1];
    pLFID = &packet_buf[1+1];
    pCheck = &packet_buf[1 + 2 + data_len];
    pData = &packet_buf[1 + 2];

    *pSTX = 0x02;
    *pETX = 0x02;
    *pHFID = (fid>>8)&0x00FF;
    *pLFID = fid&0x00FF;
    memcpy(pData, data_buf, data_len);
    CheckSum = 0;
	//CheckSumFIDDATAֶεУ
    for (i = 0; i < (2 + data_len); i++)
        CheckSum ^= packet_buf[1 + i];
    *pCheck = CheckSum;
    bRet = 1;
    return bRet;
}

static void send_enter_amt_mode_packet()
{
    u32 enter_amt_req[5] = {0};
	enter_amt_req[0] = 0x0100;
	enter_amt_req[1] = 1;
	enter_amt_req[2] = 1;
	enter_amt_req[3] = 0;
	enter_amt_req[4] = 0;

	unsigned char enter_amt_packet[25] = {0};
	unsigned short fid = 0x005f;
	CreateSendPacket(fid,(unsigned char*)enter_amt_req,sizeof(enter_amt_req),enter_amt_packet);
	Amt_ComposeAndProcess(enter_amt_packet, sizeof(enter_amt_packet));
}

static void send_exit_amt_mode_packet()
{
	u32 exit_amt_req[5] = {0};
	exit_amt_req[0] = 0x0100;
	exit_amt_req[1] = 0;
	exit_amt_req[2] = 1;
	exit_amt_req[3] = 0;
	exit_amt_req[4] = 0;

	unsigned char exit_amt_packet[25] = {0};
	unsigned short fid = 0x005f;
	CreateSendPacket(fid,(unsigned char*)exit_amt_req,sizeof(exit_amt_req),exit_amt_packet);
	Amt_ComposeAndProcess(exit_amt_packet, sizeof(exit_amt_packet));

}


static void send_tx_start_packet(unsigned int band,unsigned int channel,short int_power,short dec_power)
{
    typedef struct
    {
        UINT32  MsgId;
    	UINT32  wBandNum;       // Ƶ
    	UINT32  dwEarfcn;   
    	UINT32  wFreq;          // Ƶ㣬100kHzΪλ
    	UINT32  wBandWidth;     // 100kHzΪλ
    	UINT32  wAntennaPort;   // ߶˿  
    	UINT32  wModulation;    // Ʒʽ0QPSK116QAM264QAM
    	UINT32  wRBNum;         // RB
    	UINT32  wRBStartPosition;  // RBʼƫ
    	UINT32  wSingleWave;    // ǷΪز
    	SINT16 swRfIntPower; 	//
    	SINT16 swRfDecPower;	//С,[-2 -1 0 1 2 ][-0.5 -0.25 0 0.25 0.5]
	}T_zAMT_LTEA_SetTxInit_Req; 

	T_zAMT_LTEA_SetTxInit_Req stTxInitReq = {0};
	stTxInitReq.MsgId = 0x0700;
	stTxInitReq.wBandNum = band;
	stTxInitReq.dwEarfcn = channel;
	stTxInitReq.wFreq = 0;
	stTxInitReq.wBandWidth = 9;
	stTxInitReq.wAntennaPort = 0;
	stTxInitReq.wModulation = 0;
	stTxInitReq.wRBNum = 50;
	stTxInitReq.wRBStartPosition = 0;
	stTxInitReq.wSingleWave = 0;
	stTxInitReq.swRfIntPower = int_power;
	stTxInitReq.swRfDecPower = dec_power;

	unsigned char tx_start_packet[sizeof(stTxInitReq)+5] = {0};
	unsigned short fid = 0x005f;
	CreateSendPacket(fid,(unsigned char*)&stTxInitReq,sizeof(stTxInitReq),tx_start_packet);
	Amt_ComposeAndProcess(tx_start_packet, sizeof(tx_start_packet));
	
}

static void send_tx_stop_packet()
{
    u32 tx_close_req[1] = {0};
	tx_close_req[0] = 0x0201;
	unsigned char tx_stop_packet[1*4+5] = {0};
	unsigned short fid = 0x005f;
	CreateSendPacket(fid,(unsigned char*)tx_close_req,sizeof(tx_close_req),tx_stop_packet);
	Amt_ComposeAndProcess(tx_stop_packet, sizeof(tx_stop_packet));

}

static double lte_channel_to_freq(unsigned int band,unsigned int channel,unsigned int link)
{
    double freq = 0;
	typedef struct
	{
		int band;
		double dl_f_low;
		int dl_n_offset;
		double ul_f_low;
		int ul_n_offset;
		}stLteChannelArrangement; 

	stLteChannelArrangement info[64] = {

	{ 1, 2110, 0, 1920, 18000 },
	{ 2, 1930, 600, 1850, 18600 },
	{ 3, 1805, 1200, 1710, 19200 },
	{ 4, 2110, 1950, 1710, 19950 },
	{ 5, 869, 2400, 824, 20400 },
	{ 6, 875, 2650, 830, 20650 },
	{ 7, 2620, 2750, 2500, 20750 },
	{ 8, 925, 3450, 880, 21450 },
	{ 9, 1844.9, 3800, 1749.9, 21800 },
	{ 10, 2110, 4150, 1710, 22150 },
	{ 11, 1475.9, 4750, 1427.9, 22750 },
	{ 12, 729, 5010, 699, 23010 },
	{ 13, 746, 5180, 777, 23180 },
	{ 14, 758, 5280, 788, 23280 },
	{ 15, 0, 0, 0, 0 },
	{ 16, 0, 0, 0, 0 },
	{ 17, 734, 5730, 704, 23730 },
	{ 18, 860, 5850, 815, 23850 },
	{ 19, 875, 6000, 830, 24000 },
	{ 20, 791, 6150, 832, 24150 },
	{ 21, 1495.9, 6450, 1447.9, 24450 },
	{ 22, 3510, 6600, 3410, 24600 },
	{ 23, 2180, 7500, 2000, 25500 },
	{ 24, 1525, 7700, 1626.5, 25700 },
	{ 25, 1930, 8040, 1850, 26040 },
	{ 26, 859, 8690, 814, 26690 },
	{ 27, 852, 9040, 807, 27040 },
	{ 28, 758, 9210, 703, 27210 },
	{ 29, 0, 0, 0, 0 },
    { 30, 2350, 9770, 2305, 27660 },
    { 31, 462.5, 9870, 452.5, 27760 },
	{ 32, 0, 0, 0, 0 },
	{ 33, 1900, 36000, 1900, 36000 },
	{ 34, 2010, 36200, 2010, 36200 },
	{ 35, 1850, 36350, 1850, 36350 },
	{ 36, 1930, 36950, 1930, 36950 },
	{ 37, 1910, 37550, 1910, 37550 },
	{ 38, 2570, 37750, 2570, 37750 },
	{ 39, 1880, 38250, 1880, 38250 },
	{ 40, 2300, 38650, 2300, 38650 },
	{ 41, 2496, 39650, 2496, 39650 },
	{ 42, 3400, 41590, 3400, 41590 },
	{ 43, 3600, 43590, 3600, 43590 },
	{ 44, 703, 45590, 703, 45590 },
	{ 45, 0, 0, 0, 0 },
	{ 46, 0, 0, 0, 0 },
	{ 47, 0, 0, 0, 0 },
	{ 48, 0, 0, 0, 0 },
	{ 49, 0, 0, 0, 0 },
	{ 50, 0, 0, 0, 0 },
	{ 51, 0, 0, 0, 0 },
	{ 52, 0, 0, 0, 0 },
	{ 53, 0, 0, 0, 0 },
	{ 54, 0, 0, 0, 0 },
	{ 55, 0, 0, 0, 0 },
	{ 56, 0, 0, 0, 0 },
	{ 57, 0, 0, 0, 0 },
	{ 58, 0, 0, 0, 0 },
	{ 59, 0, 0, 0, 0 },
	{ 60, 0, 0, 0, 0 },
	{ 61, 0, 0, 0, 0 },
	{ 62, 0, 0, 0, 0 },
	{ 63, 0, 0, 0, 0 },
	{ 64, 0, 0, 0, 0 },

	};

	AmtPrintf(AMT_INFO "%s: beore transform band=%d,channel=%d,link=%d,freq=%f\n", __FUNCTION__, band,channel,link,freq);

	if (band > 0 && band <= 64)
	{
		freq = info[band - 1].ul_f_low + 0.1 * (channel - info[band - 1].ul_n_offset);
        if(link)
	    {
	    	freq = info[band -1].dl_f_low + 0.1 * (channel - info[band - 1].dl_n_offset);
        }
	}
	AmtPrintf(AMT_INFO "%s: after transform freq=%f\n", __FUNCTION__, freq);
	return freq;
}

static void send_lte_nst_init_packet(unsigned int band,unsigned int channel,unsigned int band_width)
{
	typedef struct 
	{
        u32 MsgId;
        unsigned short wBandNum[2];  // Ƶ
        unsigned short wFreq[2];  // Ƶ㣬100kHzΪλ
        unsigned short wBandWidth[2];  // 
        unsigned short wAntennaPort[2];  // ߶˿
        unsigned short wModulation[2];  // Ʒʽ0QPSK116QAM264QAM
        unsigned short wRbNum[2];  // rb num
        unsigned short wRbStartPostion[2];  // rb start
        unsigned short wSingleCarrier[2];   //0:ź 1:ز
    }T_zAMT_LTEA_NST_INIT;
	
	unsigned short freq = 0;
    freq = (unsigned short)(lte_channel_to_freq(band,channel,1)*10);
	
	
	T_zAMT_LTEA_NST_INIT stNSTInitReq = {0};
	stNSTInitReq.MsgId = 0x0500;
	stNSTInitReq.wBandNum[0] = band;
	stNSTInitReq.wFreq[0] = freq;
	stNSTInitReq.wBandWidth[0] = band_width;
	stNSTInitReq.wAntennaPort[0] = 1;
	stNSTInitReq.wModulation[0] = 0;
	stNSTInitReq.wRbNum[0] = 50;
	stNSTInitReq.wRbStartPostion[0] = 0;
	stNSTInitReq.wSingleCarrier[0] = 0;

	AmtPrintf(AMT_INFO "%s: stNSTInitReq:MsgId=%d,wBandNum[0]=%d,wFreq[0]=%d,wBandWidth[0]=%d\n",\
		__FUNCTION__, stNSTInitReq.MsgId,stNSTInitReq.wBandNum[0],stNSTInitReq.wFreq[0],stNSTInitReq.wBandWidth[0]);
	
	AmtPrintf(AMT_INFO "%s: stNSTInitReq:wAntennaPort[0]=%d,wModulation[0]=%d,wRbNum[0]=%d\n",\
		__FUNCTION__, stNSTInitReq.wAntennaPort[0],stNSTInitReq.wModulation[0],stNSTInitReq.wRbNum[0]);
	
	AmtPrintf(AMT_INFO "%s: wRbStartPostion[0]=%d,wSingleCarrier[0]=%d\n",\
		__FUNCTION__, stNSTInitReq.wRbStartPostion[0],stNSTInitReq.wSingleCarrier[0]);
	
	unsigned char lte_nst_init_packet[sizeof(stNSTInitReq)+5] = {0};
	unsigned short fid = 0x005f;
	CreateSendPacket(fid,(unsigned char*)&stNSTInitReq,sizeof(stNSTInitReq),lte_nst_init_packet);
	Amt_ComposeAndProcess(lte_nst_init_packet, sizeof(lte_nst_init_packet));

}

static void send_lte_get_rssi_packet()
{
	u32 lte_get_rssi_req[1] = {0};
	lte_get_rssi_req[0] = 0x0505;
	unsigned char lte_get_rssi_packet[1*4+5] = {0};
	unsigned short fid = 0x005f;
	CreateSendPacket(fid,(unsigned char*)lte_get_rssi_req,sizeof(lte_get_rssi_req),lte_get_rssi_packet);
	Amt_ComposeAndProcess(lte_get_rssi_packet, sizeof(lte_get_rssi_packet));
}

static void send_lte_rx_close_packet()
{
	u32 lte_rx_close_req[1] = {0};
	lte_rx_close_req[0] = 0x0301;
	unsigned char lte_rx_close_packet[1*4+5] = {0};
	unsigned short fid = 0x005f;
	CreateSendPacket(fid,(unsigned char*)lte_rx_close_req,sizeof(lte_rx_close_req),lte_rx_close_packet);
	Amt_ComposeAndProcess(lte_rx_close_packet, sizeof(lte_rx_close_packet));
}
static void send_switch_to_user_mode_packet()
{
    unsigned char bootmode[] = {0x54, 0x00};
	unsigned char atmode[] = {0xFF, 0xFF};
	nv_set_item(NV_RO, "usb_modetype", "user", 1);
	nv_commit(NV_RO);
	amt_set_amt_atmode(bootmode,atmode);
}

static void send_ok(int fd)
{
    char rep_ok[] = "OK\r\n";
	PortSend(fd, (unsigned char*)rep_ok, strlen(rep_ok), WAIT_ALL);
}

static void send_error(int fd)
{
    char rep_ok[] = "ERROR\r\n";
	PortSend(fd, (unsigned char*)rep_ok, strlen(rep_ok), WAIT_ALL);
}

static void send_query_result(int fd,char* cmd, char* param)
{
    char * at_str = NULL;
	int len = 0;

	if(param)
	{
	    len = 32 + strlen(cmd) + strlen(param);
    	at_str = malloc(len);
	}
	else
	{
	    len = 32 + strlen(cmd);
    	at_str = malloc(len);
	}
	assert(at_str);
	memset(at_str, 0, len);
    if(!param)
        sprintf(at_str,"\r\n+%s\r\n\r\nOK\r\n",cmd);
    else
        sprintf(at_str,"\r\n+%s: %s\r\n\r\nOK\r\n",cmd,param);

	PortSend(fd, (unsigned char*)at_str, strlen(at_str), WAIT_ALL);
	free(at_str);
}
/**
 * @brief AT
 * @param[in] fd ļ
 * @param[in] buf buffer
 * @param[in] buf_len buffer
 * @return ؽյݳ
 * @note
 * @see 
 */
static int At_ReceiveData(int fd, char* buf, unsigned int buf_len)
{
    int read_len = 0;
	int i = 0;
	read_len = PortRecv(fd, buf, 100, NO_WAIT);
    AmtPrintf(AMT_INFO "%s: read_len=%d.\n", __FUNCTION__, read_len);
    if (read_len > 0)
    {
        buf[read_len] = '\0';
        AmtPrintf(AMT_INFO "%s: receive [%s]\n", __FUNCTION__, buf);
		//תΪСд
		for(i = 0; i < read_len; i++)
		{
		    char at = tolower(buf[i]);
			buf[i] = at;
		}
		AmtPrintf(AMT_INFO "%s: after tolower [%s]\n", __FUNCTION__, buf);
        //at+txstart=band,channel,power
		if(strstr(buf,"at+txstart") != NULL)
		{
		    AmtPrintf(AMT_INFO "%s: receive at+txstart\n", __FUNCTION__);
			double data[3] = {0.0};
			unsigned int band = 0;
			unsigned int channel = 0;
			short int_power = 0;
			short idec_power = 0;
			double dec_power = 0.0;
			//ȡ
			buf = buf + strlen("at+txstart=");
			if(buf != NULL)
			{
			    str_to_double(data,buf);
				band = data[0];
				channel = data[1];
				int_power = data[2];
				dec_power = data[2] - int_power;
				idec_power = dec_power*4;
				AmtPrintf(AMT_INFO "%s: band=%d,channel=%d,int_power=%d,dec_power=%f,idec_power=%d\n", __FUNCTION__, band,channel,int_power,dec_power,idec_power);
				if(band == 0)
				{
				   AmtPrintf(AMT_ERROR "%s: invalid band!\n", __FUNCTION__);
				   return read_len;
				   	
				}
				if(channel == 0 )
				{
				   AmtPrintf(AMT_ERROR "%s: invalid channel!\n", __FUNCTION__);
				   return read_len;
				}
			}
			//תΪamtģʽtxinitAMTָ
			send_enter_amt_mode_packet();
			sleep(1);
			send_tx_start_packet(band,channel,int_power,idec_power);
			send_ok(fd); //ֱӸAT߻ظok
			
		}
		else if(strstr(buf,"at+txstop") != NULL)
		{
		    //תΪرշ˳amtģʽAMTָ
			send_tx_stop_packet();
		    sleep(1);
			send_exit_amt_mode_packet();
			send_ok(fd);
		}
		else if(strstr(buf,"at+zversiontype=3") != NULL)
		{
			send_switch_to_user_mode_packet();
			send_ok(fd);
		}
		else if(strstr(buf,"at+rxstart") != NULL)
		{
		    //ATat+rxstart=rat,band,channel,bandwidth,antnum,expect_level
		    AmtPrintf(AMT_INFO "%s: receive at+rxstart\n", __FUNCTION__);
			int data[6] = {0};
			//unsigned int rat = 0;
			unsigned int band = 0;
			unsigned int channel = 0;
			unsigned int band_width = 0;
			//unsigned int ant_num = 0;
			int expect_level = 0;
			int ret = 0;

			//ȡ
			buf = buf + strlen("at+rxstart=");
			if(buf != NULL)
			{
			    ret = sscanf(buf, "%d,%d,%d,%d,%d,%d", &data[0], &data[1], &data[2], &data[3],&data[4],&data[5]);
				if(ret == 6)
				{
				    rat = data[0];
					band = data[1];
					channel = data[2];
					band_width = data[3];
					ant_num = data[4];
					expect_level = data[5];
					AmtPrintf(AMT_INFO "%s: rat=%d,band=%d,channel=%d,band_width=%d,ant_num=%d,expect_level=%d\n", __FUNCTION__, rat,band,channel,band_width,ant_num,expect_level);
				    //rat(ʽ)ȡֵΧ[0,2] 0:GSM 1:WCDMA 2:LTE
					if((rat < 0) || (rat > 2))
					{
				   		AmtPrintf(AMT_ERROR "%s: invalid rat=%d[0,2]!\n", __FUNCTION__,rat);
				   		return read_len;
					}
					if(band == 0)
					{
				   		AmtPrintf(AMT_ERROR "%s: invalid band!\n", __FUNCTION__);
				   		return read_len;
				   	
					}
					if(channel == 0 )
					{
				   		AmtPrintf(AMT_ERROR "%s: invalid channel!\n", __FUNCTION__);
				   		return read_len;
					}
					//ant_numΧ[0,1000]
					if((ant_num < 0) || (ant_num > 1000))
					{
				   		AmtPrintf(AMT_ERROR "%s: invalid ant_num=%d[0,1000]!\n", __FUNCTION__,ant_num);
				   		return read_len;	
					}

					switch(rat)
					{
					    //LTE
						case 2:
						{
							//LTEΧ
							/*
							typedef enum TDDLTE_bandW
							{
							    RX1point75M = 0,
							    RX2point25M,
							    RX3point5M,
							    RX5M,
							    RX5point5M,
							    RX6M,
							    RX7M,
							    RX8M,
							    RX9M,
							    RX10M,
							    RX12M,
							    RX14M,
							    RX15M,
							    RX20M,
							    RX24M,
							    RX28M
							    RX1point4M
							} TDDLTE_BandWidth;*/
							if((band_width < 0) || (band_width > 16))
							{
						   		AmtPrintf(AMT_ERROR "%s: invalid LTE band_width=%d[0,16]!\n", __FUNCTION__,band_width);
						   		return read_len;
							}
							//תΪamtģʽnstinitAMTָ
							send_enter_amt_mode_packet();
							sleep(1);
							send_lte_nst_init_packet(band,channel,band_width);
						    break;
						}
						case 0:
						case 1:
						default:
						{
						    AmtPrintf(AMT_ERROR "%s: rat=%d not support\n", __FUNCTION__,rat);
							send_error(fd);
							break;
						}
					}
					
				}
				else
				{
					 AmtPrintf(AMT_INFO "%s: at+rxstart param parse error!\n", __FUNCTION__);
					 return read_len;
				}
			}
			else
			{
				AmtPrintf(AMT_INFO "%s: at+rxstart param str is empty!\n", __FUNCTION__);
			    return read_len;
			}
		}
		else if(strstr(buf,"at+rssi") != NULL)
		{
		    //ATat+rssi
		    AmtPrintf(AMT_INFO "%s: receive at+rssi\n", __FUNCTION__);
            switch(rat)
			{
				//LTE
				case 2:
				{
				    //תΪȡRSSIAMTָ
					send_lte_get_rssi_packet();
					break;
				}
			    case 0:
				case 1:
				default:
				{
				   AmtPrintf(AMT_ERROR "%s: rat=%d not support\n", __FUNCTION__,rat);
				   send_error(fd);
				   break;
				}
		    }
		}
		else if(strstr(buf,"at+rxstop") != NULL)
		{
		    //תΪرսջ˳amtģʽAMTָ
			send_lte_rx_close_packet();
		    sleep(1);
			send_exit_amt_mode_packet();
			send_ok(fd);
		}
		else
		{
		    AmtPrintf(AMT_ERROR "%s: unknown at %s.\n", __FUNCTION__, buf);
		}
    }
    else
    {
        AmtPrintf(AMT_ERROR "%s: PortRecv from device(fd = %d): read_len(%d) is wrong.\n", __FUNCTION__, fd, read_len);
    }

    return read_len;
}

/**
 * Main Function
 */
int main (int argc, char *argv[])
{
    extern char *optarg;
    extern int optind;
    int c;
	int socket_port = -1;

    /********************** Get arguments ********************/
    while ((c = getopt(argc,argv,"p:r:")) != EOF)
    {
        switch (c)
        {
            case 'p':
                socket_port = atoi(optarg);
                break;
            case '?':
                AmtPrintf(AMT_INFO "Usage: zte_amt [options]\n");
                AmtPrintf(AMT_INFO "-p ipport - Set IP port number to listen on\n");
                exit(1);
        }
    }

    AmtPrintf(AMT_INFO "start AMT!\n");

    FD_ZERO(&g_amt_fdsread);

    /********************** Init AP-CP channel ********************/
    g_amt_fd_cp = init_cp_channel();
    if (g_amt_fd_cp < 0)
    {
        return -1;
    }
    else
    {
        AmtPrintf(AMT_INFO "g_amt_fd_cp = %d.\n", g_amt_fd_cp);
    }

    /********************** Init USB device ***********************/
    g_amt_fd_usb = init_usb_device();
    if (g_amt_fd_usb >= 0)
    {
        AmtPrintf(AMT_INFO "g_amt_fd_usb = %d.\n", g_amt_fd_usb);
        set_fd(g_amt_fd_usb);

        //Init hotplug netlink
        g_amt_fd_usb_hotplug = init_hotplug_nl();
        if (g_amt_fd_usb_hotplug >= 0)
        {
            AmtPrintf(AMT_INFO "g_amt_fd_usb_hotplug = %d.\n", g_amt_fd_usb_hotplug);
            set_fd(g_amt_fd_usb_hotplug);
        }
    }
	
    /*********************** Create socket ***********************/
    if (socket_port > 0)
    {
        g_amt_fd_socket_server = init_socket(socket_port);
        if (g_amt_fd_socket_server >= 0)
        {
            AmtPrintf(AMT_INFO "g_amt_fd_socket_server = %d.\n", g_amt_fd_socket_server);
            set_fd(g_amt_fd_socket_server);
        }
    }
	
    #ifdef USE_CAP_SUPPORT
	/********************** Init AP-CAP channel ********************/
	g_amt_fd_cap = init_cap_channel();
    if (g_amt_fd_cap < 0)
    {
        return -1;
    }
    else
    {
        AmtPrintf(AMT_INFO "g_amt_fd_cap = %d.\n", g_amt_fd_cap);
    }

	 // Create CAP read thread
    pthread_t cap_read_thread;
    if (pthread_create(&cap_read_thread, NULL, ReadFromCAPThread, NULL) != 0)
    {
        AmtPrintf(AMT_ERROR "Failed to create CAP read thread!\n");
        return -1;
    }
	#endif

    // Create CP read thread
    pthread_t cp_read_thread;
    if (pthread_create(&cp_read_thread, NULL, ReadFromCPThread, NULL) != 0)
    {
        AmtPrintf(AMT_ERROR "Failed to create CP read thread!\n");
        return -1;
    }

    // Wifi init
    Amt_Wifi_Init();
    g_amt_iMsgHandle = msgget(MODULE_ID_AMT, IPC_CREAT|0600);
    if(-1 == g_amt_iMsgHandle) 
    {
   	    AmtPrintf(AMT_ERROR "%s: can not create msg queue for AMT!\n", __FUNCTION__);
	    return -1;
    }

    pthread_t msg_recv_thread;
    if (pthread_create(&msg_recv_thread, NULL, RecvMsgFromAppThread, NULL) != 0)
    {
   	 AmtPrintf(AMT_ERROR "Failed to create RecvMsgFromAppThread thread!\n");
         return -1;
    }
    // malloc receive buffer
    char *receive_buffer = malloc(MAX_PACKET_LENGTH);
    if (receive_buffer == NULL)
    {
        return -1;
    }

    int ret = -1;
    int read_len = 0;
    fd_set tmpfds;

	ret = cpnv_ChangeFsPartitionAttr(FS_NVROFS, 1);
	if(ret != CPNV_OK)
	{
		AmtPrintf(AMT_ERROR "%s: cpnv_ChangeFsPartitionAttr RW nvrofs failed!\n", __FUNCTION__);
		free(receive_buffer);
		return -1;
	}
	else
	{
	    AmtPrintf(AMT_INFO"%s: cpnv_ChangeFsPartitionAttr RW nvrofs ok!\n", __FUNCTION__);
	}

	//aic8800̼
    // Create load wifi firmware thread
    pthread_t load_wifi_firmware_thread;
    if (pthread_create(&load_wifi_firmware_thread, NULL, LoadWifiFirmwareThread, NULL) != 0)
    {
        AmtPrintf(AMT_ERROR "Failed to create load wifi firmware thread!\n");
		free(receive_buffer);
        return -1;
    }

	#if 0
	#if (defined(__AIC_8800DW_CHIP__))
	ret = wifi_ioctl_handle(3); //زԹ̼
	if(ret < 0)
	{
		AmtPrintf(AMT_ERROR "%s: load AIC_8800DW firmware fail! ret=%d.\n", __FUNCTION__, ret);
	}
    else
	{
		AmtPrintf(AMT_INFO "%s: load AIC_8800DW firmware success! ret=%d.\n", __FUNCTION__, ret);
	}
	#endif
	#endif

	g_amt_at_mode = is_amt_atmode();
	AmtPrintf(AMT_INFO"%s: g_amt_at_mode=%d\n", __FUNCTION__,g_amt_at_mode);

    while (1)
    {
        tmpfds = g_amt_fdsread;
        ret = select(g_amt_fd_max, &tmpfds, NULL, NULL, NULL);
        if (ret <= 0)
        {
            AmtPrintf(AMT_ERROR "select error: %s!\n", strerror(errno));
            continue;
        }

        if (g_amt_fd_usb_hotplug >= 0 && FD_ISSET(g_amt_fd_usb_hotplug, &tmpfds))
        {
            read_len = PortRecv(g_amt_fd_usb_hotplug, (unsigned char *)receive_buffer, MAX_PACKET_LENGTH - 1, NO_WAIT);
			if(read_len >= 0)
				receive_buffer[read_len] = '\0';

			// ǿӽ, read_len < MAX_PACKET_LENGTH
			receive_buffer[MAX_PACKET_LENGTH - 1] = '\0';

            if (strstr(receive_buffer, AMT_DETECT_USB_HOTREMOVE))
            {
                AmtPrintf(AMT_INFO "USB remove!\n");
                system("poweroff");
                break;
            }

            if (strstr(receive_buffer, AMT_DETECT_USB_OFFLINE))
            {
                AmtPrintf(AMT_INFO "USB offline!\n");

                if (g_amt_fd_usb >= 0)
                {
                    close(g_amt_fd_usb);
                    clr_fd(g_amt_fd_usb);
                    g_amt_fd_usb = -1;
                }
            }

            if (strstr(receive_buffer, AMT_DETECT_USB_ONLINE))
            {
                AmtPrintf(AMT_INFO "USB online!\n");

                if (g_amt_fd_usb >= 0)
                {
                    AmtPrintf(AMT_INFO "amt already open usb,do nothing\n");
                    //close(g_amt_fd_usb);
                    //clr_fd(g_amt_fd_usb);
                    //g_amt_fd_usb = -1;
                }
                else
                {
	                g_amt_fd_usb = init_usb_device();
	                if (g_amt_fd_usb >= 0)
	                {
	                    AmtPrintf(AMT_INFO "g_amt_fd_usb = %d.\n", g_amt_fd_usb);
	                    set_fd(g_amt_fd_usb);
	                }
                }
            }
        }

        if (g_amt_fd_socket_server >= 0 && FD_ISSET(g_amt_fd_socket_server, &tmpfds))
        {
            struct sockaddr_in cliaddr;
            int addrlen = sizeof(cliaddr);

            if (g_amt_fd_socket_client >= 0)
            {
                close(g_amt_fd_socket_client);
                clr_fd(g_amt_fd_socket_client);
                g_amt_fd_socket_client = -1;
            }

            if ((g_amt_fd_socket_client = accept(g_amt_fd_socket_server, (struct sockaddr*)&cliaddr, (socklen_t *)&addrlen)) == -1)
            {
                AmtPrintf(AMT_ERROR "Accept failed!\n");
            }
            else
            {
                unsigned long ip = ntohl(cliaddr.sin_addr.s_addr);
                AmtPrintf(AMT_INFO "Connect from %lu.%lu.%lu.%lu\n", (ip>>24)&0xff, (ip>>16)&0xff, (ip>>8)&0xff, (ip>>0)&0xff);
                set_fd(g_amt_fd_socket_client);
            }
        }

        if (g_amt_fd_usb >= 0 && FD_ISSET(g_amt_fd_usb, &tmpfds))
        {
            g_amt_fd_current = &g_amt_fd_usb;
        }
        else if (g_amt_fd_socket_client >= 0 && FD_ISSET(g_amt_fd_socket_client, &tmpfds))
        {
            g_amt_fd_current = &g_amt_fd_socket_client;
        }
        else
        {
            continue;
        }

		//NVжǷǽATʽ
		if(g_amt_at_mode == 1)
		{
		   //AT
		   At_ReceiveData(*g_amt_fd_current, receive_buffer, MAX_PACKET_LENGTH);
		   continue;
		}

        read_len = Amt_ReceiveData(*g_amt_fd_current, (unsigned char *)receive_buffer, MAX_PACKET_LENGTH);

        if (read_len > 0)
        {
            Amt_ComposeAndProcess((unsigned char *)receive_buffer, read_len);
        }
        else if (read_len == 0)
        {
            AmtPrintf(AMT_ERROR "%s: read_len = 0, close fd(%d)\n", __FUNCTION__, *g_amt_fd_current);
            close(*g_amt_fd_current);
            clr_fd(*g_amt_fd_current);
            *g_amt_fd_current = -1;
            g_amt_fd_current = NULL;
        }


        //struct timespec ts;
		//clock_gettime(CLOCK_MONOTONIC, &ts);
		//AmtPrintf(AMT_INFO "[%8d.%03d] %s: cpnv_FsGcWait start.\n", ts.tv_sec, ts.tv_nsec / 1000000,__FUNCTION__);
        //unsigned int status = cpnv_FsGcWait(FS_NVROFS);
		//if(status != CPNV_OK)
		//	AmtPrintf(AMT_INFO "%s: cpnv_FsGcWait fail, err = %d.\n", __FUNCTION__, status);
        //else
        //{
		//	clock_gettime(CLOCK_MONOTONIC, &ts);
		//	AmtPrintf(AMT_INFO "[%8d.%03d] %s: cpnv_FsGcWait ok.\n", ts.tv_sec, ts.tv_nsec / 1000000, __FUNCTION__);
		//}
		
    }

    free(receive_buffer);
    pthread_join(cp_read_thread, NULL);
#if 1
    cpnv_FsGcWait(FS_NVROFS);
	AmtPrintf(AMT_INFO "%s: cpnv_FsGcWait return.\n", __FUNCTION__);

	ret = cpnv_ChangeFsPartitionAttr(FS_NVROFS, 0);
	if(ret != CPNV_OK)
	{
		AmtPrintf(AMT_ERROR "%s: cpnv_ChangeFsPartitionAttr RO nvrofs failed!\n", __FUNCTION__);
		return -1;
	}
#endif
    close(g_amt_fd_cp);

    if (g_amt_fd_usb >= 0)
    {
        close(g_amt_fd_usb);
    }

    //if (g_amt_fd_usb_hotplug >= 0)
    {
        close(g_amt_fd_usb_hotplug);
    }

    if (g_amt_fd_socket_client >= 0)
    {
        close(g_amt_fd_socket_client);
    }

    if (g_amt_fd_socket_server >= 0)
    {
        close(g_amt_fd_socket_server);
    }

	#ifdef USE_CAP_SUPPORT
	close(g_amt_fd_cap);
	#endif

    AmtPrintf(AMT_INFO "AMT exit!\n");
    return 0;
}

