#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <stdarg.h>
#include <string.h>
#include <errno.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <sys/mman.h>
#include <sys/time.h>
#include <linux/ioctl.h>


typedef enum
{
    VP_PATH_HANDSET    =0,     
    VP_PATH_SPEAKER,  		
    VP_PATH_HEADSET,                     
    VP_PATH_BLUETOOTH,                    
    VP_PATH_BLUETOOTH_NO_NR,                    
    VP_PATH_HSANDSPK,
    
    VP_PATH_OFF = 255,					
    
    MAX_VP_PATH = VP_PATH_OFF               
}T_ZDrv_VpPath;

typedef enum
{
    VP_VOL_0    =0,               
    VP_VOL_1,                         
    VP_VOL_2,                       
    VP_VOL_3,                    
    VP_VOL_4,                    
    VP_VOL_5,                         
    VP_VOL_6,                       
    VP_VOL_7,                    
    VP_VOL_8,                    
    VP_VOL_9,                       
    VP_VOL_10,                    
    VP_VOL_11,                    
    
    MAX_VP_VOL              
}T_ZDrv_VpVol;

typedef enum
{
    VOICE_GSM_MODE = 0,
    VOICE_TD_MODE ,
    VOICE_WCDMA_MODE,
    VOICE_LTE_MODE,
    VOICE_GSM_TD_MODE,//GSM TD share
    VOICE_GSM_WCDMA_MODE,    //GSM WCDMA share 
    MAX_VOICE_MODE
} T_ZDrvVoice_MODE;

typedef struct testnxp{
	int fs;
	int voicemode;
	int vp_path; 
	int vp_vol;
	int framecount;
}T_TestNxp;

#define TESTNXP_IOCTL_RXIN_TO_RXOUT_START	_IOW('N', 1, T_TestNxp)
#define TESTNXP_IOCTL_RXIN_TO_RXOUT_STOP	_IO('N', 2)

#define MAX_NXP_BUF	640

static char *TESTNXP_DeviceName = (char *)"/dev/testnxp_dev";

int main(int argc, char** argv)
{
	int fd = -1;
	FILE *file_rxin, *file_rxout;
	T_TestNxp nxp_param = {8000, VOICE_GSM_MODE, VP_PATH_HANDSET, VP_VOL_4, 160};
	int size = 0, num_read = 0;
	char buffer[640] = {0};
	char *filename;
	
    if (argc < 2) {
        fprintf(stderr, "Usage: %s filename_in filename_out [-f fs] [-m voicemode 0:gsm 2:wcdma 3:lte] [-p path 0:handset 1:spk 2:headset] [-v vol]\n", argv[0]);
        return -1;
    }

	printf("nxp_test open 1\n");

	filename = argv[1];
    file_rxin = fopen(filename, "rb");
    if (!file_rxin) {
        fprintf(stderr, "Unable to open file '%s'\n", argv[1]);
        return -1;
    }
	printf("nxp_test open 2\n");
	
    file_rxout = fopen(argv[2], "wb");
    if (!file_rxout) {
        fprintf(stderr, "Unable to create file '%s'\n", argv[2]);
		fclose(file_rxin);
        return -1;
    }

    argv += 3;
    while (*argv) {
        if (strcmp(*argv, "-f") == 0) {
            argv++;
            if (*argv)
                nxp_param.fs = atoi(*argv);
        }
        if (strcmp(*argv, "-m") == 0) {
            argv++;
            if (*argv)
                nxp_param.voicemode = atoi(*argv);
        }
        if (strcmp(*argv, "-p") == 0) {
            argv++;
            if (*argv)
                nxp_param.vp_path = atoi(*argv);
        }
        if (strcmp(*argv, "-v") == 0) {
            argv++;
            if (*argv)
                nxp_param.vp_vol = atoi(*argv);
        }
        if (*argv)
            argv++;
    }
	
	printf("nxp_test open 3\n");
    fd = open(TESTNXP_DeviceName, O_RDWR);
    if(fd < 0)
    {
        printf("audiostart: open device error.\n");
		fclose(file_rxin);
		fclose(file_rxout);
        return -1;
    }
	
	printf("nxp_test open 4\n");

	if (nxp_param.fs = 8000)
		nxp_param.framecount = 160;
	else if(nxp_param.fs = 16000)
		nxp_param.framecount = 320;
	size = nxp_param.framecount * 2;

	if (ioctl(fd, TESTNXP_IOCTL_RXIN_TO_RXOUT_START, &nxp_param))
    { 
    	printf("testnxp: TESTNXP_IOCTL_RXIN_TO_RXOUT   error.\n");
		close(fd);
		fclose(file_rxin);
		fclose(file_rxout);
        return -1;
    }

    do {
        num_read = fread(buffer, 1, size, file_rxin);
        if (num_read > 0) {
            write(fd, buffer, num_read);
			read(fd, buffer, num_read);
            fwrite(buffer, 1, num_read, file_rxout); 
        }         
    } while (num_read > 0);

	ioctl(fd, TESTNXP_IOCTL_RXIN_TO_RXOUT_STOP, NULL);
	
	close(fd);
	fclose(file_rxin);
	fclose(file_rxout);
    return 0;
}
