
define("service","underscore jquery set CryptoJS".split(" "), function (_, $, config, CryptoJS) {
    function addTimerSomething(querys, cb) {
        if (_.isArray(querys)) {
            for (var i = 0; i < querys.length; i++) {
                addQueryString(querys[i]);
            }
        } else {
            addQueryString(querys);
        }
        addCallback(cb);
    }
    function removeTimerSomething(querys, cb) {
        if (_.isArray(querys)) {
            for (var i = 0; i < querys.length; i++) {
                removeQueryString(querys[i]);
            }
        } else {
            removeQueryString(querys);
        }
        removeCallback(cb);
    }
    function getCurretnMAC() {
        return getUserMacAddr({}).get_user_mac_addr;
    }
    function getDdnsParams(values, callback) {
        return stuffMake(arguments, {}, prepare, deal, null, false);
        function prepare(values, isPost) {
            return {
                multi_data: 1,
                cmd: "DDNS_Enable,DDNS_Mode,DDNSProvider,DDNSAccount,DDNSPassword,DDNS,DDNS_Hash_Value"
            };
        }
        function deal(paramD) {
            if (paramD) {
                return {
                    DDNS_Enable: paramD.DDNS_Enable,
                    DDNS_Mode: paramD.DDNS_Mode,
                    DDNSProvider: paramD.DDNSProvider,
                    DDNSAccount: paramD.DDNSAccount,
                    DDNSPassword: paramD.DDNSPassword,
                    DDNS: paramD.DDNS,
                    DDNS_Hash_Value: paramD.DDNS_Hash_Value
                }
            } else {
                return errUnknownObj;
            }
        }
    }
    function setDDNSForward() {
        return stuffMake(arguments, {}, prepare, deal, null, true);
        function prepare(values, isPost) {
            var valueReq = $.extend({}, values);
            return valueReq;
        }
        function deal(paramD) {
            if (paramD) {
                return paramD;
            } else {
                return errUnknownObj;
            }
        }
    }
   function getLoginData() {
        return stuffMake(arguments, {}, prepare, deal, null, false);
        function prepare(values, isPost) {
            var valueReq = {};
            valueReq.cmd = "modem_main_state,puknumber,pinnumber,blc_wan_mode,blc_wan_auto_mode,psw_fail_num_str,login_lock_time,psw_changed";
            valueReq.multi_data = 1;
            return valueReq;
        }
        function deal(paramD) {
            if (paramD) {
                if (paramD.blc_wan_mode == "AUTO") {
                    paramD.blc_wan_mode = paramD.blc_wan_auto_mode ? paramD.blc_wan_auto_mode : 'AUTO_PPP';
                } else {
                    paramD.blc_wan_mode = paramD.blc_wan_mode ? paramD.blc_wan_mode : 'PPP';
                }
                paramD.psw_fail_num_str = paramD.psw_fail_num_str == '' ? config.MAX_LOGIN_COUNT : paramD.psw_fail_num_str;
                paramD.login_lock_time = paramD.login_lock_time == '' ? '300' : paramD.login_lock_time;
                return paramD;
            } else {
                return errUnknownObj;
            }
        }
    }
    function login() {
        return stuffMake(arguments, {}, prepare, deal, {
            errorType: 'badPassword'
        }, true);
        function prepare(values, isPost) {
            var obj = {
                goformId: "LOGIN",
                password: config.PASSWORD_ENCODE ? Base64.encode(values.password) : values.password
            };
            return obj;
        }
        function deal(paramD) {
            if (paramD && (paramD.result == "0" || paramD.result == "4")) {
                informationAll.isLoggedIn = true;
                return {
                    result: true
                };
            } else {
                var loginError = {};
                switch (paramD.result) {
                case "1":
                    loginError = {
                        errorType: "Login Fail"
                    };
                    break;
                case "2":
                    loginError = {
                        errorType: "duplicateUser"
                    };
                    break;
                case "3":
                    loginError = {
                        errorType: "badPassword"
                    };
                    break;
                default:
                    loginError = {
                        errorType: "Login Fail"
                    };
                    break;
                }
                informationAll.isLoggedIn = false;
                return $.extend(errUnknownObj, loginError);
            }
        }
    }
    function getLoginStatus() {
        if (informationAll.isLoggedIn != undefined) {
            return stuffMake(arguments, {
                status: informationAll.isLoggedIn ? 'loggedIn' : 'loggedOut'
            });
        } else {
            var resultObject = {};
            if (!config.HAS_LOGIN) {
                resultObject.status = 'loggedIn';
                resultObject.errorType = 'no_login';
                informationAll.isLoggedIn = true;
            }
            return stuffMake(arguments, resultObject, prepare, deal, null, false);
        }
        function prepare(values, isPost) {
            var valueReq = {};
            valueReq.cmd = "loginfo";
            valueReq.multi_data = 1;
            return valueReq;
        }
        function deal(paramD) {
            if (paramD && paramD.loginfo || paramD.loginfo == "") {
                var loginStatus = {};
                switch (paramD.loginfo) {
                case "ok":
                    informationAll.isLoggedIn = true;
                    loginStatus.status = "loggedIn";
                    break;
                default:
                    informationAll.isLoggedIn = false;
                    loginStatus.status = "loggedOut";
                    break;
                }
                return loginStatus;
            } else {
                informationAll.isLoggedIn = undefined;
                return $.extend(errUnknownObj, {
                    errorType: "LoginStatusError"
                });
            }
        }
    }
    function enterPIN() {
        return stuffMake(arguments, {}, prepare, deal, {}, true);
        function prepare(values, isPost) {
            var obj = {};
            obj.goformId = "ENTER_PIN";
            obj.PinNumber = values.PinNumber;
            return obj;
        }
        function deal(paramD) {
            if (paramD && paramD.result === "success") {
                return {
                    result: true
                };
            } else {
                return {
                    result: false
                };
            }
        }
    }
    function enterPUK() {
        return stuffMake(arguments, {}, prepare, deal, {}, true);
        function prepare(values, isPost) {
            var obj = {};
            obj.goformId = "ENTER_PUK";
            obj.PUKNumber = values.PUKNumber;
            obj.PinNumber = values.PinNumber;
            return obj;
        }
        function deal(paramD) {
            if (paramD && paramD.result === "success") {
                return {
                    result: true
                };
            } else {
                return {
                    result: false
                };
            }
        }
    }	

    function getStatusInfo() {
        if (informationAll.isLoggedIn === undefined) {
            var loginStatus = getLoginStatus();
            return {
                networkType: informationAll.networkType,
                signalImg: informationAll.signalImg,
                networkOperator: informationAll.networkOperator,
                spn_b1_flag: informationAll.spn_b1_flag,
                spn_name_data: informationAll.spn_name_data,
                spn_b2_flag: informationAll.spn_b2_flag,
                connectStatus: informationAll.connectStatus,
                rj45ConnectStatus: informationAll.rj45ConnectStatus,
                ssid1AttachedNum: informationAll.ssid1AttachedNum,
                ssid2AttachedNum: informationAll.ssid2AttachedNum,
                wirelessDeviceNum: informationAll.ssid1AttachedNum + informationAll.ssid2AttachedNum,
                roamingStatus: informationAll.roamingStatus,
                wifiStatus: informationAll.wifiStatus,
                simStatus: informationAll.simStatus,
                pinStatus: informationAll.pinStatus,
                batteryStatus: informationAll.batteryStatus,
                batteryLevel: informationAll.batteryLevel,
                batteryPers: informationAll.batteryPers,
                batteryTime: informationAll.batteryTime,
                ssid: informationAll.ssid,
                authMode: informationAll.authMode,
                data_counter: informationAll.data_counter,
                isLoggedIn: loginStatus.status == "loggedIn",
                newSmsReceived: informationAll.newSmsReceived,
                smsReportReceived: informationAll.smsReportReceived,
                smsUnreadCount: informationAll.smsUnreadCount,
                limitVolumeEnable: informationAll.limitVolumeEnable,
                limitVolumeType: informationAll.limitVolumeType,
                limitVolumePercent: informationAll.limitVolumePercent,
                limitVolumeSize: informationAll.limitVolumeSize,
                connectWifiProfile: informationAll.connectWifiProfile,
                connectWifiSSID: informationAll.connectWifiSSID,
                connectWifiStatus: informationAll.connectWifiStatus,
                multi_ssid_enable: informationAll.multi_ssid_enable,
                roamMode: informationAll.roamMode,
                blc_wan_mode: informationAll.blc_wan_mode,
                current_upgrade_state: informationAll.current_upgrade_state,
                is_mandatory: informationAll.is_mandatory,
                new_version_state: informationAll.new_version_state,
                allowRoamingUpdate: informationAll.allowRoamingUpdate,
                ap_station_enable: informationAll.ap_station_enable,
                ap_station_mode: informationAll.ap_station_mode,
                dialMode: informationAll.dialMode,
                fota_package_already_download: informationAll.fota_package_already_download,
                ethWanMode: informationAll.ethWanMode,
                fota_user_selector: informationAll.fota_user_selector,
                defaultWanName: informationAll.defaultWanName
            };
        }
        return {
            networkType: informationAll.networkType,
            signalImg: informationAll.signalImg,
            networkOperator: informationAll.networkOperator,
            spn_b1_flag: informationAll.spn_b1_flag,
            spn_name_data: informationAll.spn_name_data,
            spn_b2_flag: informationAll.spn_b2_flag,
            connectStatus: informationAll.connectStatus,
            rj45ConnectStatus: informationAll.rj45ConnectStatus,
            ssid1AttachedNum: informationAll.ssid1AttachedNum,
            ssid2AttachedNum: informationAll.ssid2AttachedNum,
            wirelessDeviceNum: informationAll.ssid1AttachedNum + informationAll.ssid2AttachedNum,
            roamingStatus: informationAll.roamingStatus,
            wifiStatus: informationAll.wifiStatus,
            simStatus: informationAll.simStatus,
            pinStatus: informationAll.pinStatus,
            batteryStatus: informationAll.batteryStatus,
            batteryLevel: informationAll.batteryLevel,
            batteryPers: informationAll.batteryPers,
            batteryTime: informationAll.batteryTime,
            ssid: informationAll.ssid,
            authMode: informationAll.authMode,
            data_counter: informationAll.data_counter,
            isLoggedIn: informationAll.isLoggedIn,
            newSmsReceived: informationAll.newSmsReceived,
            smsReportReceived: informationAll.smsReportReceived,
            smsUnreadCount: informationAll.smsUnreadCount,
            limitVolumeEnable: informationAll.limitVolumeEnable,
            limitVolumeType: informationAll.limitVolumeType,
            limitVolumePercent: informationAll.limitVolumePercent,
            limitVolumeSize: informationAll.limitVolumeSize,
            connectWifiProfile: informationAll.connectWifiProfile,
            connectWifiSSID: informationAll.connectWifiSSID,
            connectWifiStatus: informationAll.connectWifiStatus,
            multi_ssid_enable: informationAll.multi_ssid_enable,
            blc_wan_mode: informationAll.blc_wan_mode,
            roamMode: informationAll.roamMode,
            current_upgrade_state: informationAll.current_upgrade_state,
            is_mandatory: informationAll.is_mandatory,
            new_version_state: informationAll.new_version_state,
            allowRoamingUpdate: informationAll.allowRoamingUpdate,
            ap_station_enable: informationAll.ap_station_enable,
            ap_station_mode: informationAll.ap_station_mode,
            dialMode: informationAll.dialMode,
            fota_package_already_download: informationAll.fota_package_already_download,
            ethWanMode: informationAll.ethWanMode,
            fota_user_selector: informationAll.fota_user_selector,
            defaultWanName: informationAll.defaultWanName
        };
    }
    function getConnectionInfo() {
        var isData = informationAll.limitVolumeType == '1';
        var result = {
            data_counter: informationAll.data_counter,
            connectStatus: informationAll.connectStatus,
            rj45ConnectStatus: informationAll.rj45ConnectStatus,
            limitVolumeEnable: informationAll.limitVolumeEnable,
            limitVolumeType: informationAll.limitVolumeType,
            limitVolumePercent: informationAll.limitVolumePercent,
            networkType: informationAll.networkType
        };
        if (isData) {
            result.limitDataMonth = informationAll.limitVolumeSize;
            result.limitTimeMonth = 0;
        } else {
            result.limitTimeMonth = informationAll.limitVolumeSize;
            result.limitDataMonth = 0;
        }
        result.blc_wan_mode = informationAll.blc_wan_mode;
        return result;
    }
    function resetNewSmsReceivedVar() {
        informationAll.newSmsReceived = false;
    }
    function resetSmsReportReceivedVar() {
        informationAll.smsReportReceived = false;
    }
    function getSmsCapability() {
        return stuffMake(arguments, {}, prepare, deal, null, false);
        function prepare(values, isPost) {
            var valueReq = {};
            valueReq.cmd = "sms_capacity_info";
            return valueReq;
        }
        function deal(paramD) {
            return {
                nvTotal: parseInt(paramD.sms_nv_total, 10),
                nvUsed: parseInt(paramD.sms_nv_rev_total, 10) + parseInt(paramD.sms_nv_send_total, 10) + parseInt(paramD.sms_nv_draftbox_total, 10),
                simTotal: parseInt(paramD.sms_sim_total, 10),
                simUsed: parseInt(paramD.sms_sim_rev_total, 10) + parseInt(paramD.sms_sim_send_total, 10) + parseInt(paramD.sms_sim_draftbox_total, 10),
                nvReceive: parseInt(paramD.sms_nv_rev_total, 10),
                nvSend: parseInt(paramD.sms_nv_send_total, 10),
                nvDraft: parseInt(paramD.sms_nv_draftbox_total, 10),
                simReceive: parseInt(paramD.sms_sim_rev_total, 10),
                simSend: parseInt(paramD.sms_sim_send_total, 10),
                simDraft: parseInt(paramD.sms_sim_draftbox_total, 10)
            };
        }
    }
    function connect() {
        var callback = arguments[1];
        var checkPoint = 0;
        return stuffMake(arguments, {}, prepare, deal, null, true);
        function prepare(values, isPost) {
            var valueReq = {};
            valueReq.notCallback = true;
            valueReq.goformId = "CONNECT_NETWORK";
            return valueReq;
        }
        function deal(paramD) {
            if (paramD.result == "success") {
                checkPoint = new Date().getTime();
                addCallback(checkConnectStatus);
            } else {
                callback({
                    result: false
                });
            }
        }
        function checkConnectStatus(paramD) {
            if (paramD.ppp_status == "ppp_connecting") {
                informationAll.connectStatus = "ppp_connecting";
            } else if (paramD.ppp_status == "ppp_connected") {
                removeCallback(checkConnectStatus);
                informationAll.connectStatus = "ppp_connected";
                callback({
                    result: true,
                    status: informationAll.connectStatus
                });
            } else if (new Date().getTime() - checkPoint < 1e4) {
                informationAll.connectStatus = "ppp_connecting";
            } else {
                removeCallback(checkConnectStatus);
                callback({
                    result: false
                });
            }
        }
    }
    function disconnect() {
        var callback = arguments[1];
        var checkPoint = 0;
        return stuffMake(arguments, {}, prepare, deal, null, true);
        function prepare(values, isPost) {
            var valueReq = {};
            valueReq.notCallback = true;
            valueReq.goformId = "DISCONNECT_NETWORK";
            return valueReq;
        }
        function deal(paramD) {
            if (paramD.result == "success") {
                checkPoint = new Date().getTime();
                addCallback(checkDisconnectStatus);
            } else {
                callback({
                    result: false
                });
            }
        }
        function checkDisconnectStatus(paramD) {
            if (paramD.ppp_status == "ppp_disconnecting") {
                informationAll.connectStatus = "ppp_disconnecting";
            } else if (paramD.ppp_status == "ppp_disconnected") {
                removeCallback(checkDisconnectStatus);
                informationAll.connectStatus = "ppp_disconnected";
                callback({
                    result: true,
                    status: informationAll.connectStatus
                });
            } else if (new Date().getTime() - checkPoint < 1e4) {
                informationAll.connectStatus = "ppp_disconnecting";
            } else {
                removeCallback(checkDisconnectStatus);
                callback({
                    result: false
                });
            }
        }
    }
    function getApnSettings() {
        return stuffMake(arguments, {}, prepare, deal, null, false);
        function prepare(values, isPost) {
            var valueReq = {};
            valueReq.cmd = "APN_configtmp0,APN_configtmp1,APN_configtmp2,APN_configtmp3,APN_configtmp4,APN_configtmp5,APN_configtmp6,APN_configtmp7,APN_configtmp8,APN_configtmp9," + "APN_configtmp10,APN_configtmp11,APN_configtmp12,APN_configtmp13,APN_configtmp14,APN_configtmp15,APN_configtmp16,APN_configtmp17,APN_configtmp18,APN_configtmp19," + "ipv6_APN_configtmp0,ipv6_APN_configtmp1,ipv6_APN_configtmp2,ipv6_APN_configtmp3,ipv6_APN_configtmp4,ipv6_APN_configtmp5,ipv6_APN_configtmp6,ipv6_APN_configtmp7,ipv6_APN_configtmp8,ipv6_APN_configtmp9," + "ipv6_APN_configtmp10,ipv6_APN_configtmp11,ipv6_APN_configtmp12,ipv6_APN_configtmp13,ipv6_APN_configtmp14,ipv6_APN_configtmp15,ipv6_APN_configtmp16,ipv6_APN_configtmp17,ipv6_APN_configtmp18,ipv6_APN_configtmp19," + "m_profile_name,profile_name,wan_dial,pdp_type,pdp_select,index,Current_index,apn_auto_config,ipv6_apn_auto_config," + "apn_mode,wan_apn,ppp_auth_mode,ppp_username,ppp_passtmp," + "ipv6_wan_apn,ipv6_pdp_type,ipv6_ppp_auth_mode,ipv6_ppp_username,ipv6_ppp_passtmp,apn_num_preset";
            valueReq.multi_data = 1;
            return valueReq;
        }
        function deal(result) {
            if (result) {
                return {
                    APNs: result.APN_configtmp0 + "||" + result.APN_configtmp1 + "||" + result.APN_configtmp2 + "||" + result.APN_configtmp3 + "||" + result.APN_configtmp4 + "||"
                    +result.APN_configtmp5 + "||" + result.APN_configtmp6 + "||" + result.APN_configtmp7 + "||" + result.APN_configtmp8 + "||" + result.APN_configtmp9 + "||"
                    +result.APN_configtmp10 + "||" + result.APN_configtmp11 + "||" + result.APN_configtmp12 + "||" + result.APN_configtmp13 + "||" + result.APN_configtmp14 + "||"
                    +result.APN_configtmp15 + "||" + result.APN_configtmp16 + "||" + result.APN_configtmp17 + "||" + result.APN_configtmp18 + "||" + result.APN_configtmp19,
                    ipv6APNs: result.ipv6_APN_configtmp0 + "||" + result.ipv6_APN_configtmp1 + "||" + result.ipv6_APN_configtmp2 + "||" + result.ipv6_APN_configtmp3 + "||" + result.ipv6_APN_configtmp4 + "||"
                    +result.ipv6_APN_configtmp5 + "||" + result.ipv6_APN_configtmp6 + "||" + result.ipv6_APN_configtmp7 + "||" + result.ipv6_APN_configtmp8 + "||" + result.ipv6_APN_configtmp9 + "||"
                    +result.ipv6_APN_configtmp10 + "||" + result.ipv6_APN_configtmp11 + "||" + result.ipv6_APN_configtmp12 + "||" + result.ipv6_APN_configtmp13 + "||" + result.ipv6_APN_configtmp14 + "||"
                    +result.ipv6_APN_configtmp15 + "||" + result.ipv6_APN_configtmp16 + "||" + result.ipv6_APN_configtmp17 + "||" + result.ipv6_APN_configtmp18 + "||" + result.ipv6_APN_configtmp19,
                    apnMode: result.apn_mode,
                    profileName: result.m_profile_name || result.profile_name,
                    wanDial: result.wan_dial,
                    pdpType: result.pdp_type == 'IP' ? 'IP' : result.ipv6_pdp_type,
                    pdpSelect: result.pdp_select,
                    index: result.index,
                    currIndex: result.Current_index,
                    autoApns: result.apn_auto_config,
                    autoApnsV6: result.ipv6_apn_auto_config,
                    wanApn: result.wan_apn,
                    authMode: result.ppp_auth_mode.toLowerCase(),
                    username: result.ppp_username,
                    password: result.ppp_passtmp,
                    dnsMode: "",
                    dns1: "",
                    dns2: "",
                    wanApnV6: result.ipv6_wan_apn,
                    authModeV6: result.ipv6_ppp_auth_mode.toLowerCase(),
                    usernameV6: result.ipv6_ppp_username,
                    passwordV6: result.ipv6_ppp_passtmp,
                    dnsModeV6: "",
                    dns1V6: "",
                    dns2V6: "",
                    apnNumPreset: result.apn_num_preset
                };
            } else {
                return {
                    result: false
                };
            }
        }
    }
    function deleteApn() {
        return stuffMake(arguments, {}, prepare, deal, null, true);
        function prepare(values, isPost) {
            var valueReq = {
                apn_action: "delete",
                apn_mode: "manual",
                index: values.index
            };
            valueReq.goformId = "APN_PROC_EX";
            return valueReq;
        }
        function deal(paramD) {
            if (paramD.result == "success") {
                return {
                    result: true
                };
            } else {
                return {
                    result: false
                };
            }
        }
    }
    function setDefaultApn() {
        return stuffMake(arguments, {}, prepare, deal, null, true);
        function prepare(values, isPost) {
            var requestParam = {
                goformId: "APN_PROC_EX",
                apn_mode: values.apnMode
            };
            if (values.apnMode == 'manual') {
                requestParam.apn_action = "set_default";
                requestParam.set_default_flag = "1";
                requestParam.pdp_type = values.pdpType;
                requestParam.index = values.index;
            }
            return requestParam;
        }
        function deal(paramD) {
            if (paramD.result == "success") {
                return {
                    result: true
                };
            } else {
                return {
                    result: false
                };
            }
        }
    }
    function addOrEditApn() {
        return stuffMake(arguments, {}, prepare, deal, null, true);
        function prepare(values, isPost) {
            var valueReq = {
                goformId: "APN_PROC_EX",
                apn_action: "save",
                apn_mode: "manual",
                profile_name: values.profileName,
                wan_dial: '*99#',
                pdp_type: values.pdpType,
                pdp_select: 'auto',
                index: values.index
            };
            if (values.pdpType == "IP") {
                $.extend(valueReq, {
                    wan_apn: values.wanApn,
                    ppp_auth_mode: values.authMode,
                    ppp_username: values.username,
                    ppp_passtmp: values.password,
                });
            } else if (values.pdpType == "IPv6") {
                $.extend(valueReq, {
                    ipv6_wan_apn: values.wanApnV6,
                    ipv6_ppp_auth_mode: values.authModeV6,
                    ipv6_ppp_username: values.usernameV6,
                    ipv6_ppp_passtmp: values.passwordV6
                });
            } else {
                $.extend(valueReq, {
                    wan_apn: values.wanApn,
                    ppp_auth_mode: values.authMode,
                    ppp_username: values.username,
                    ppp_passtmp: values.password,
                    dns_mode: values.dnsMode,
                    prefer_dns_manual: values.dns1,
                    standby_dns_manual: values.dns2,
                    ipv6_wan_apn: values.wanApnV6,
                    ipv6_ppp_auth_mode: values.authModeV6,
                    ipv6_ppp_username: values.usernameV6,
                    ipv6_ppp_passtmp: values.passwordV6
                });
            }
            return valueReq;
        }
        function deal(paramD) {
            if (paramD.result == "success") {
                return {
                    result: true
                };
            } else {
                return {
                    result: false
                };
            }
        }
    }
    var timerQueryString = ["modem_main_state", "pin_status", "blc_wan_mode", "blc_wan_auto_mode", "loginfo", "fota_new_version_state", "fota_current_upgrade_state", "fota_upgrade_selector", "network_provider", "is_mandatory", "sta_count", "m_sta_count"];
    var loginTimerQueryString = ["signalbar", "network_type", "sub_network_type", "ppp_status", "rj45_state", "EX_SSID1", "sta_ip_status", "EX_wifi_profile", "m_ssid_enable", "wifi_cur_state", "SSID1", "simcard_roam", "lan_ipaddr", "battery_charging", "battery_vol_percent", "battery_pers", "spn_name_data", "spn_b1_flag", "spn_b2_flag", "realtime_tx_bytes", "realtime_rx_bytes", "realtime_time", "realtime_tx_thrpt", "realtime_rx_thrpt", "monthly_rx_bytes", "monthly_tx_bytes", "traffic_alined_delta", "monthly_time", "date_month", "data_volume_limit_switch", "data_volume_limit_size", "data_volume_alert_percent", "data_volume_limit_unit", "roam_setting_option", "upg_roam_switch", "fota_package_already_download", 'ssid', 'dial_mode', 'ethwan_mode', 'default_wan_name'];
    if (config.HAS_SMS) {
        $.merge(loginTimerQueryString, ["sms_received_flag", "sts_received_flag", 'sms_unread_num']);
    }
    var timerCallbackStack = [];
    var timerCallbacks = [timerUpdateStatus];
    function timerUpdater() {
        if (!updateTimerFlag) {
            setTimeout(function () {
                timerUpdater();
            }, 1000);
            return;
        }
        var queryParams = checkTimerUpdaterParameters();
        reqAsync(queryParams, function (paramD) {
            for (var i = 0; i < timerCallbacks.length; i++) {
                if (typeof timerCallbacks[i] === "function") {
                    timerCallbacks[i](paramD);
                }
            }
            $.merge(timerCallbacks, timerCallbackStack);
            timerCallbackStack = [];
            setTimeout(function () {
                timerUpdater();
            }, 1000);
        }, function () {
            timerUpdaterErrorCallback();
            setTimeout(function () {
                timerUpdater();
            }, 1000);
        }, false);
    }
    function checkTimerUpdaterParameters() {
        var queryParams = {
            multi_data: 1,
        };
        if (window.location.hash && window.location.hash != '#entry' && informationAll.isLoggedIn) {
            if (config.HAS_SMS) {
                queryParams.sms_received_flag_flag = 0;
                queryParams.sts_received_flag_flag = 0;
            }
            if (loginTimerQueryString.length > 0 && _.indexOf(timerQueryString, loginTimerQueryString[0]) == -1) {
                $.each(loginTimerQueryString, function (i, n) {
                    timerQueryString.push(n);
                });
            }
        } else {
            if (loginTimerQueryString.length > 0 && _.indexOf(timerQueryString, loginTimerQueryString[0]) != -1) {
                timerQueryString = _.without(timerQueryString, loginTimerQueryString);
            }
        }
        queryParams.cmd = timerQueryString.join(",");
        return queryParams;
    }
    function addCallback(cb) {
        if (_.indexOf(timerCallbackStack, cb) == -1) {
            timerCallbackStack.push(cb);
        }
    }
    function removeCallback(cb) {
        timerCallbacks = _.without(timerCallbacks, cb);
        if (timerCallbacks.length == 0) {
            timerCallbacks.push(timerUpdateStatus);
        }
        return timerCallbackStack;
    }
    function addQueryString(query) {
        if (_.indexOf(timerQueryString, query) == -1) {
            timerQueryString.push(query);
        }
    }
    function removeQueryString(query) {
        timerQueryString = _.without(timerQueryString, query);
        return timerQueryString;
    }
    function timerUpdateStatus(paramD) {
        informationAll.defaultWanName = paramD.default_wan_name;
        informationAll.signalImg = typeof paramD.signalbar == 'undefined' ? '0' : paramD.signalbar;
        informationAll.networkType = paramD.sub_network_type ? paramD.sub_network_type : (paramD.network_type ? paramD.network_type : '');
        if (informationAll.networkType.toLowerCase().indexOf("limited_service") != -1 || informationAll.networkType.toLowerCase().indexOf("limited service") != -1) {
            informationAll.networkType = "limited_service";
        } else if (informationAll.networkType.toLowerCase().indexOf("no_service") != -1 || informationAll.networkType.toLowerCase().indexOf("no service") != -1) {
            informationAll.networkType = "no_service";
        }
        informationAll.networkOperator = paramD.network_provider ? paramD.network_provider : '';
        informationAll.spn_b1_flag = paramD.spn_b1_flag;
        informationAll.spn_b2_flag = paramD.spn_b2_flag;
        informationAll.spn_name_data = paramD.spn_name_data;
        informationAll.connectStatus = typeof paramD.ppp_status == 'undefined' ? 'ppp_disconnected' : paramD.ppp_status;
        informationAll.rj45ConnectStatus = (typeof paramD.rj45_state == 'undefined' || paramD.rj45_state == '') ? 'dead' : paramD.rj45_state;
        informationAll.ethWanMode = paramD.ethwan_mode;
        informationAll.ssid1AttachedNum = paramD.sta_count == "" ? 0 : parseInt(paramD.sta_count, 10);
        informationAll.ssid2AttachedNum = paramD.m_sta_count == "" ? 0 : parseInt(paramD.m_sta_count, 10);
        informationAll.roamingStatus = getRoamStatus(informationAll.networkType, paramD.modem_main_state, paramD.simcard_roam);
        informationAll.wifiStatus = paramD.wifi_cur_state == "1";
        informationAll.simStatus = paramD.modem_main_state;
        informationAll.pinStatus = paramD.pin_status;
        var needMinutes = 3 * 60 * 60;
        var batteryLevel = (paramD.battery_vol_percent && paramD.battery_vol_percent.length > 0) ? paramD.battery_vol_percent : 100;
        informationAll.batteryPers = paramD.battery_pers;
        var remainMinutes = Math.round(needMinutes * (1 - batteryLevel / 100));
        informationAll.batteryStatus = (typeof paramD.battery_charging == 'undefined') ? '0' : paramD.battery_charging;
        informationAll.batteryLevel = batteryLevel;
        informationAll.batteryTime = remainMinutes.toString();
        informationAll.data_counter = {
            uploadRate: paramD.realtime_tx_thrpt == '' ? 0 : paramD.realtime_tx_thrpt,
            downloadRate: paramD.realtime_rx_thrpt == '' ? 0 : paramD.realtime_rx_thrpt,
            currentSent: paramD.realtime_tx_bytes == '' ? 0 : paramD.realtime_tx_bytes,
            currentReceived: paramD.realtime_rx_bytes == '' ? 0 : paramD.realtime_rx_bytes,
            currentConnectedTime: paramD.realtime_time == '' ? 0 : paramD.realtime_time,
            monthlySent: paramD.monthly_tx_bytes == '' ? 0 : paramD.monthly_tx_bytes,
            monthlyReceived: paramD.monthly_rx_bytes == '' ? 0 : paramD.monthly_rx_bytes,
            traffic_alined_delta: paramD.traffic_alined_delta == '' ? 0 : paramD.traffic_alined_delta,
            monthlyConnectedTime: paramD.monthly_time == '' ? 0 : paramD.monthly_time,
            month: paramD.date_month == '' ? 1 : paramD.date_month
        };
        informationAll.ssid = paramD.SSID1;
        informationAll.authMode = paramD.AuthMode;
        informationAll.isLoggedIn = config.HAS_LOGIN ? paramD.loginfo == "ok" : true;
        if (config.HAS_SMS) {
            if (!informationAll.newSmsReceived) {
                informationAll.newSmsReceived = paramD.sms_received_flag > 0;
            }
            if (!informationAll.smsReportReceived) {
                informationAll.smsReportReceived = paramD.sts_received_flag > 0;
            }
            if (typeof paramD.sms_dev_unread_num != "undefined") {
                informationAll.smsUnreadCount = config.SMS_UNREAD_NUM_INCLUDE_SIM ? parseInt(paramD.sms_dev_unread_num | 0, 10) + parseInt(paramD.sms_sim_unread_num | 0, 10) : parseInt(paramD.sms_dev_unread_num | 0, 10);
            } else {
                informationAll.smsUnreadCount = parseInt(paramD.sms_unread_num | 0, 10)
            }
        }
        if (paramD.data_volume_limit_switch == '1') {
            informationAll.limitVolumeEnable = true;
            informationAll.limitVolumeType = paramD.data_volume_limit_unit == 'data' ? '1' : '0';
            informationAll.limitVolumePercent = paramD.data_volume_alert_percent;
            if (paramD.data_volume_limit_unit == 'data') {
                var limitMonth = paramD.data_volume_limit_size.split("_");
                informationAll.limitVolumeSize = limitMonth[0] * limitMonth[1] * 1024 * 1024;
            } else {
                informationAll.limitVolumeSize = paramD.data_volume_limit_size * 60 * 60;
            }
        } else {
            informationAll.limitVolumeEnable = false;
            informationAll.limitVolumeType = '1';
            informationAll.limitVolumePercent = '100';
            informationAll.limitVolumeSize = '0';
        }
        informationAll.connectWifiProfile = paramD.EX_wifi_profile;
        informationAll.connectWifiSSID = paramD.EX_SSID1;
        informationAll.connectWifiStatus = paramD.sta_ip_status;
        informationAll.multi_ssid_enable = paramD.m_ssid_enable;
        informationAll.roamMode = paramD.roam_setting_option;
        if (paramD.blc_wan_mode == "AUTO") {
            informationAll.blc_wan_mode = paramD.blc_wan_auto_mode ? paramD.blc_wan_auto_mode : 'AUTO_PPP';
        } else {
            informationAll.blc_wan_mode = paramD.blc_wan_mode ? paramD.blc_wan_mode : 'PPP';
        }
        informationAll.new_version_state = paramD.fota_new_version_state == "has_critical" || paramD.fota_new_version_state == "has_optional" || paramD.fota_new_version_state == "already_has_pkg";
        informationAll.current_upgrade_state = paramD.fota_current_upgrade_state;
        if (informationAll.current_upgrade_state == "verify_failed") {
            informationAll.current_upgrade_state = "upgrade_pack_error";
        }
        informationAll.fota_user_selector = paramD.fota_upgrade_selector;
        informationAll.is_mandatory = paramD.is_mandatory == "1" || paramD.fota_new_version_state == "has_critical";
        informationAll.allowRoamingUpdate = paramD.upg_roam_switch;
        informationAll.dialMode = paramD.dial_mode;
        informationAll.fota_package_already_download = paramD.fota_package_already_download;
    }
    function timerUpdaterErrorCallback() {
        informationAll.batteryStatus = '0';
    }
    function getRoamStatus(networkType, modemState, simcardRoam) {
        if (("" == $.trim(networkType)) || "no_service" == networkType.toLowerCase() || "limited_service" == networkType.toLowerCase() || "modem_sim_undetected" == modemState || "modem_waitpin" == modemState || "modem_waitpuk" == modemState) {
            return false;
        }
        if ("Internal" == simcardRoam || "International" == simcardRoam) {
            return true;
        } else {
            return false;
        }
    }
    $(document).ready(function () {
        setTimeout(function () {
            timerUpdater();
        }, 0);
    });
    function setNetwork(strNetworkNumber, nRat, nSubAct, callback) {
        if ((typeof(strNetworkNumber) !== "string") || (strNetworkNumber === "") || (typeof(nRat) !== "number") || (isNaN(nRat))) {
            if (typeof(callback) === "function") {
                callback(false);
                return;
            }
        }
        var nRat1 = -1;
        if (nRat === 0) {
            nRat1 = 0;
        } else if (nRat === 2) {
            nRat1 = 2;
        } else if (nRat == 7) {
            nRat1 = 7;
        } else {
            nRat1 = -1;
        }
        if (-1 === nRat1) {
            if (typeof(callback) === "function") {
                callback(false);
                return;
            }
        }
        var SubAct;
        if (nSubAct.toString() == "NaN") {
            SubAct = "";
        } else {
            SubAct = nSubAct;
        }
        reqAsync({
            goformId: "SET_NETWORK",
            NetworkNumber: strNetworkNumber,
            Rat: nRat,
            nSubrat: SubAct
        }, function (paramD) {
            if (paramD && paramD.result == "success") {
                var flag;
                var counter = 0;
                var timer = setInterval(function () {
                    var obj = reqSync({
                        cmd: 'm_netselect_result',
                    }, false);
                    if (!obj) {
                        callback(false);
                        return;
                    }
                    if (obj.m_netselect_result == "manual_success") {
                        flag = "1";
                        window.clearInterval(timer);
                        callback(true);
                    } else if (obj.m_netselect_result == "manual_fail") {
                        flag = "0";
                        window.clearInterval(timer);
                        callback(false);
                    } else if (counter < 120) {
                        counter++;
                    } else {
                        window.clearInterval(timer);
                        callback(false);
                    }
                }, 1000);
            } else {
                callback(false);
            }
        }, function (paramD) {
            callback(false);
        }, true);
    }
    function savePhoneBook() {
        var callback = arguments[1];
        return stuffMake(arguments, {}, prepare, deal, null, true);
        function prepare(values, isPost) {
            var valueReq = {};
            valueReq.notCallback = true;
            valueReq.goformId = "PBM_CONTACT_ADD";
            valueReq.location = values.location;
            valueReq.name = encodeMessage(values.name);
            valueReq.mobilephone_num = values.mobile_phone_number;
            if (valueReq.location == 1) {
                valueReq.add_index_pc = values.index;
                valueReq.homephone_num = values.home_phone_number;
                valueReq.officephone_num = values.office_phone_number;
                valueReq.email = encodeMessage(values.mail);
                valueReq.groupchoose = values.group;
                if (!valueReq.groupchoose) {
                    valueReq.groupchoose = "common";
                }
            } else {
                valueReq.edit_index = values.index;
            }
            if (values.delId != undefined) {
                valueReq.delId = values.delId;
            }
            return valueReq;
        }
        function deal(paramD) {
            if (paramD && paramD.result == "success") {
                addTimerSomething("pbm_write_flag", checkSavePhoneBook);
            } else {
                callback(paramD);
            }
        }
        function checkSavePhoneBook(paramD) {
            checkPbmWriteFlag(paramD, callback, checkSavePhoneBook);
        }
    }
    function checkPbmWriteFlag(paramD, callback, fn) {
        if (paramD.pbm_write_flag == "0") {
            removeTimerSomething("pbm_write_flag", fn);
            callback({
                result: "success"
            });
        } else if (paramD.pbm_write_flag == "6" || paramD.pbm_write_flag == "7" || paramD.pbm_write_flag == "8" || paramD.pbm_write_flag == "9" || paramD.pbm_write_flag == "10" || paramD.pbm_write_flag == "11" || paramD.pbm_write_flag == "14") {
            removeTimerSomething("pbm_write_flag", fn);
            callback({
                result: "fail"
            });
        } else {}
    }
    function deletePhoneBooks() {
        var callback = arguments[1];
        return stuffMake(arguments, {}, prepare, deal, null, true);
        function prepare(values, isPost) {
            var valueReq = {};
            valueReq.notCallback = true;
            valueReq.goformId = "PBM_CONTACT_DEL";
            valueReq.del_option = "delete_num";
            valueReq.delete_id = values.indexs.join(",");
            return valueReq;
        }
        function deal(paramD) {
            if (paramD && paramD.result == "success") {
                addTimerSomething("pbm_write_flag", checkDeletePhoneBooks);
            } else {
                callback(paramD);
            }
        }
        function checkDeletePhoneBooks(paramD) {
            checkPbmWriteFlag(paramD, callback, checkDeletePhoneBooks);
        }
    }
    function deleteAllPhoneBooks() {
        var callback = arguments[1];
        return stuffMake(arguments, {}, prepare, deal, null, true);
        function prepare(values, isPost) {
            var valueReq = {};
            valueReq.notCallback = true;
            valueReq.goformId = "PBM_CONTACT_DEL";
            valueReq.del_option = "delete_all";
            valueReq.del_all_location = values.location;
            return valueReq;
        }
        function deal(paramD) {
            if (paramD && paramD.result == "success") {
                addTimerSomething("pbm_write_flag", checkDeleteAllPhoneBooks);
            } else {
                callback(paramD);
            }
        }
        function checkDeleteAllPhoneBooks(paramD) {
            checkPbmWriteFlag(paramD, callback, checkDeleteAllPhoneBooks);
        }
    }
    function deleteAllPhoneBooksByGroup() {
        var callback = arguments[1];
        return stuffMake(arguments, {}, prepare, deal, null, true);
        function prepare(values, isPost) {
            var valueReq = {};
            valueReq.notCallback = true;
            valueReq.goformId = "PBM_CONTACT_DEL";
            valueReq.del_option = "delete_all_by_group";
            valueReq.del_all_location = 3;
            valueReq.del_group = values.group;
            return valueReq;
        }
        function deal(paramD) {
            if (paramD && paramD.result == "success") {
                addTimerSomething("pbm_write_flag", checkDeleteAllPhoneBooksByGroup);
            } else {
                callback(paramD);
            }
        }
        function checkDeleteAllPhoneBooksByGroup(paramD) {
            checkPbmWriteFlag(paramD, callback, checkDeleteAllPhoneBooksByGroup);
        }
    }
    function setConnectionMode() {
        return stuffMake(arguments, {}, prepare, deal, null, true);
        function prepare(values, isPost) {
            var valueReq = {};
            valueReq.goformId = "SET_CONNECTION_MODE";
            valueReq.ConnectionMode = values.connectionMode;
            valueReq.roam_setting_option = values.isAllowedRoaming;
            return valueReq;
        }
        function deal(paramD) {
            if (paramD) {
                return paramD;
            } else {
                callback(paramD);
            }
        }
    }
    function getConnectionMode() {
        return stuffMake(arguments, {}, prepare, deal, null, false);
        function prepare(values, isPost) {
            var valueReq = {};
            valueReq.cmd = "ConnectionMode";
            return valueReq;
        }
        function deal(paramD) {
            if (paramD) {
                var result = {};
                result.connectionMode = paramD.connectionMode;
                result.isAllowedRoaming = paramD.autoConnectWhenRoaming;
                return result;
            } else {
                return errUnknownObj;
            }
        }
    }
    function _getPhoneBooks(array, location) {
        if (array[0].data_per_page == 0) {
            return {
                "pbm_data": []
            };
        }
        return stuffMake(array, {}, prepare, deal, null, false);
        function prepare(values, isPost) {
            var valueReq = {};
            valueReq.mem_store = location;
            if (location == 2) {
                valueReq.cmd = "pbm_data_total";
            } else {
                valueReq.cmd = "pbm_data_info";
            }
            valueReq.page = values.page;
            valueReq.data_per_page = values.data_per_page;
            valueReq.orderBy = values.orderBy;
            valueReq.isAsc = values.isAsc;
            return valueReq;
        }
        function deal(paramD) {
            if (paramD && paramD.pbm_data) {
                var books = [];
                $.each(paramD.pbm_data, function (i) {
                    books.push({
                        pbm_id: paramD.pbm_data[i].pbm_id,
                        pbm_location: paramD.pbm_data[i].pbm_location,
                        pbm_number: paramD.pbm_data[i].pbm_number,
                        pbm_anr: paramD.pbm_data[i].pbm_anr,
                        pbm_anr1: paramD.pbm_data[i].pbm_anr1,
                        pbm_group: paramD.pbm_data[i].pbm_group,
                        pbm_name: decodeMessage(paramD.pbm_data[i].pbm_name),
                        pbm_email: decodeMessage(paramD.pbm_data[i].pbm_email)
                    });
                });
                return {
                    pbm_data: books
                };
            } else {
                return errUnknownObj;
            }
        }
    }
    function getPhoneBooksByGroup() {
        if (arguments[0].data_per_page == 0) {
            return {
                "pbm_data": []
            };
        }
        return stuffMake(arguments, {}, prepare, deal, null, false);
        function prepare(values, isPost) {
            var valueReq = {};
            valueReq.cmd = "pbm_data_total";
            valueReq.mem_store = 3;
            valueReq.pbm_group = values.group;
            valueReq.page = values.page;
            valueReq.data_per_page = values.data_per_page;
            valueReq.orderBy = values.orderBy;
            valueReq.isAsc = values.isAsc;
            return valueReq;
        }
        function deal(paramD) {
            if (paramD && paramD.pbm_data) {
                var books = [];
                $.each(paramD.pbm_data, function (i) {
                    books.push({
                        pbm_id: paramD.pbm_data[i].pbm_id,
                        pbm_location: paramD.pbm_data[i].pbm_location,
                        pbm_number: paramD.pbm_data[i].pbm_number,
                        pbm_anr: paramD.pbm_data[i].pbm_anr,
                        pbm_anr1: paramD.pbm_data[i].pbm_anr1,
                        pbm_group: paramD.pbm_data[i].pbm_group,
                        pbm_name: decodeMessage(paramD.pbm_data[i].pbm_name),
                        pbm_email: decodeMessage(paramD.pbm_data[i].pbm_email)
                    });
                });
                return {
                    pbm_data: books
                };
            } else {
                return errUnknownObj;
            }
        }
    }
    function getDevicePhoneBooks() {
        return _getPhoneBooks(arguments, 1);
    }
    function getSIMPhoneBooks() {
        return _getPhoneBooks(arguments, 0);
    }
    function getPhoneBooks() {
        return _getPhoneBooks(arguments, 2);
    }
    function getPhoneBookReady() {
        return stuffMake(arguments, {}, prepare, deal, null, false);
        function prepare(values, isPost) {
            var valueReq = {};
            valueReq.cmd = "pbm_init_flag";
            return valueReq;
        }
        function deal(paramD) {
            if (paramD) {
                return paramD;
            } else {
                return errUnknownObj;
            }
        }
    }
    function getPhoneBookCapacity(array, isSIM) {
        return stuffMake(array, {}, prepare, deal, null, false);
        function prepare(values, isPost) {
            var valueReq = {};
            valueReq.cmd = "pbm_capacity_info";
            if (isSIM) {
                valueReq.pbm_location = "pbm_sim";
            } else {
                valueReq.pbm_location = "pbm_native";
            }
            return valueReq;
        }
        function deal(paramD) {
            if (paramD) {
                return paramD;
            } else {
                return errUnknownObj;
            }
        }
    }
    function getSIMPhoneBookCapacity() {
        var paramD = getPhoneBookCapacity(arguments, true);
        return {
            simPbmTotalCapacity: parseInt(paramD.pbm_sim_max_record_num),
            simPbmUsedCapacity: parseInt(paramD.pbm_sim_used_record_num),
            simType: paramD.pbm_sim_type,
            maxNameLen: parseInt(paramD.pbm_sim_max_name_len),
            maxNumberLen: parseInt(paramD.pbm_sim_max_number_len) > 40 ? 40 : parseInt(paramD.pbm_sim_max_number_len)
        };
    }
    function getDevicePhoneBookCapacity() {
        var paramD = getPhoneBookCapacity(arguments, false);
        return {
            pcPbmTotalCapacity: parseInt(paramD.pbm_dev_max_record_num),
            pcPbmUsedCapacity: parseInt(paramD.pbm_dev_used_record_num)
        };
    }
    function getAttachedCableDevices() {
        return stuffMake(arguments, {}, prepare, deal, null, false);
        function prepare(values, isPost) {
            var obj = {
                cmd: "lan_station_list"
            };
            return obj;
        }
        function deal(paramD) {
            var deviceArr = [];
            var attachedDevices = paramD.lan_station_list || paramD.station_list;
            for (var i = 0; attachedDevices && i < attachedDevices.length; i++) {
                var obj = {};
                obj.macAddress = attachedDevices[i].mac_addr;
                var hostname = attachedDevices[i].hostname;
                obj.hostName = hostname == "" ? $.i18n.prop("unknown") : hostname;
                obj.ipAddress = attachedDevices[i].ip_addr;
                deviceArr.push(obj);
            }
            return {
                attachedDevices: deviceArr
            };
        }
    }
    function getCurrentlyAttachedDevicesInfo() {
        return stuffMake(arguments, {}, prepare, deal, null, false);
        function prepare(values, isPost) {
            var obj = {
                cmd: "station_list"
            };
            return obj;
        }
        function deal(paramD) {
            var deviceArr = [];
            var attachedDevices = paramD.station_list;
            for (var i = 0; attachedDevices && i < attachedDevices.length; i++) {
                var obj = {};
                obj.macAddress = attachedDevices[i].mac_addr;
                var hostname = attachedDevices[i].hostname;
                obj.hostName = hostname == "" ? $.i18n.prop("unknown") : hostname;
                obj.ipAddress = attachedDevices[i].ip_addr;
                deviceArr.push(obj);
            }
            return {
                attachedDevices: deviceArr
            };
        }
    }	

    function setLanguage() {
        return stuffMake(arguments, {}, prepare, deal, null, true);
        function prepare(values, isPost) {
            var valueReq = {};
            valueReq.goformId = "SET_WEB_LANGUAGE";
            valueReq.Language = values.Language;
            return valueReq;
        }
        function deal(paramD) {
            if (paramD) {
                return paramD;
            } else {
                return errUnknownObj;
            }
        }
    }
    function getLanguage() {
        return stuffMake(arguments, {}, prepare, deal, null, false);
        function prepare(values, isPost) {
            var valueReq = {};
            valueReq.cmd = "Language";
            valueReq.multi_data = 1;
            return valueReq;
        }
        function deal(paramD) {
            if (paramD) {
                var result = {};
                result.Language = (paramD && paramD.Language) ? paramD.Language : "en";
                return result;
            } else {
                return errUnknownObj;
            }
        }
    }	

    function setBearerPreference() {
        return stuffMake(arguments, {}, prepare, deal, null, true);
        function prepare(values, isPost) {
            var valueReq = {};
            valueReq.goformId = "SET_BEARER_PREFERENCE";
            valueReq.BearerPreference = values.strBearerPreference;
            return valueReq;
        }
        function deal(paramD) {
            if (paramD) {
                return paramD;
            } else {
                return errUnknownObj;
            }
        }
    }
    function scanForNetwork(callback) {
        $.post("/reqproc/proc_post", {
            goformId: "SCAN_NETWORK"
        }, function (paramD) {
            if (paramD.result == "success") {
                checkScanStatus();
            } else {
                callback(false, []);
            }
        }, "json").error(function () {
            callback(false, []);
        });
        function checkScanStatus() {
            $.getJSON("/reqproc/proc_get", {
                cmd: "m_netselect_status",
                "_": new Date().getTime()
            }, function (paramD) {
                if (paramD.m_netselect_status == "manual_selecting") {
                    setTimeout(checkScanStatus, 1000);
                } else {
                    $.getJSON("/reqproc/proc_get", {
                        cmd: "m_netselect_contents",
                        "_": new Date().getTime()
                    }, function (paramD2) {
                        if (trim(paramD2.m_netselect_contents) != "") {
                            parseScanResult(paramD2.m_netselect_contents);
                        } else {
                            callback(false, []);
                        }
                    }).error(function () {
                        callback(false, []);
                    });
                }
            }).error(function () {
                callback(false, []);
            });
        }
        function parseScanResult(result) {
            var pattern = /([^,;]*),([^,]*),([^,]*),([^,]*),([^,;]*)/g;
            var listNetwork = [];
            var mts;
            var unit = result.split(";");
            var unitString = "";
            for (i = 0; i < unit.length; i++) {
                var unitLength = unit[i].split(",").length;
                if (unitLength == 4) {
                    unitString += unit[i] + ",NON;";
                } else {
                    unitString += unit[i] + ";";
                }
            }
            while (mts = pattern.exec(unitString)) {
                if (mts != null) {
                    listNetwork.push({
                        strShortName: mts[2].replace(/\"/g, ''),
                        strNumeric: mts[3].replace(/\D/g, ''),
                        nRat: parseInt(mts[4], 10),
                        nState: parseInt(mts[1], 10),
                        SubAct: parseInt(mts[5], 10)
                    });
                }
            }
            callback(true, listNetwork);
        }
    }
	    function getNetSelectInfo() {
        return stuffMake(arguments, {}, prepare, deal, null, false);
        function prepare(values, isPost) {
            var valueReq = {};
            valueReq.cmd = "current_network_mode,m_netselect_save,net_select_mode,m_netselect_contents,net_select,ppp_status,modem_main_state";
            valueReq.multi_data = 1;
            return valueReq;
        }
        function deal(paramD) {
            if (paramD) {
                var result = {};
                result.current_network_mode = paramD.current_network_mode;
                result.net_select_mode = paramD.net_select_mode;
                result.m_netselect_save = paramD.m_netselect_save;
                result.m_netselect_contents = paramD.m_netselect_contents;
                result.net_select = paramD.net_select;
                result.ppp_status = paramD.ppp_status;
                result.modem_main_state = paramD.modem_main_state;
                return result;
            } else {
                return errUnknownObj;
            }
        }
    }	
 
    function getSMSMessages() {
        return stuffMake(arguments, {}, prepare, deal, {}, false);
        function prepare(values, isPost) {
            var obj = {
                cmd: "sms_data_total",
                page: values.page,
                data_per_page: config.SMS_DATABASE_SORT_SUPPORT ? values.smsCount : 500,
                mem_store: values.nMessageStoreType,
                tags: values.tags,
                order_by: values.orderBy
            };
            return obj;
        }
        function deal(paramD) {
            if (paramD && paramD.messages && paramD.messages.length > 0) {
                return {
                    messages: parseMessages(paramD.messages)
                };
            } else {
                return {
                    messages: []
                };
            }
        }
    }
    function parseMessages(messages, isReport) {
        var result = [];
        for (var i = 0; i < messages.length; i++) {
            if (!config.SHOW_UN_COMPLETE_CONCAT_SMS && typeof messages[i].received_all_concat_sms != "undefined" && messages[i].received_all_concat_sms == '0') {
                continue;
            }
            var oneMessage = {};
            oneMessage.id = messages[i].id;
            oneMessage.number = messages[i].number;
            oneMessage.content = isReport ? messages[i].content : decodeMessageContent(messages[i].content);
            oneMessage.time = transTime('20' + messages[i].date);
            oneMessage.isNew = messages[i].tag == "1";
            oneMessage.groupId = messages[i].draft_group_id;
            oneMessage.tag = messages[i].tag;
            oneMessage.receivedAll = messages[i].received_all_concat_sms == '1';
            result.push(oneMessage);
        }
        if (!config.SMS_DATABASE_SORT_SUPPORT) {
            var ids = [];
            var tmpResult = [];
            for (var i = result.length; i--; ) {
                var n = result[i];
                var idx = $.inArray(n.id, ids);
                if (idx == -1) {
                    ids.push(n.id);
                    tmpResult.push(n);
                } else {
                    if (n.content.length > tmpResult[idx].content.length) {
                        tmpResult[idx] = n;
                    }
                }
            }
            return _.sortBy(tmpResult, function (n) {
                return 0 - n.id;
            });
        } else {
            return result;
        }
    }
    function decodeMessageContent(msgContent) {
        return decodeMessage(escapeMessage(msgContent));
    }
    function sendSMS() {
        var callback = arguments[1];
        var errorCabllback = arguments[2] ? arguments[2] : callback;
        return stuffMake(arguments, {}, prepare, deal, null, true);
        function prepare(values, isPost) {
            var obj = {
                goformId: "SEND_SMS",
                notCallback: true,
                Number: values.number,
                sms_time: getCurrentTimeString(),
                MessageBody: escapeMessage(encodeMessage(values.message)),
                ID: values.id,
                encode_type: getEncodeType(values.message).encodeType
            };
            return obj;
        }
        function deal(paramD) {
            if (!paramD) {
                errorCabllback($.extend(errUnknownObj, {
                        errorType: "sendFail",
                        errorText: "send_fail_try_again"
                    }));
                return;
            }
            if (paramD.result == "success") {
                setTimeout(function () {
                    getSmsStatusInfo({
                        smsCmd: 4,
                        errorType: "sendFail",
                        errorText: "send_fail_try_again"
                    }, callback, errorCabllback);
                }, 1000);
            } else {
                errorCabllback($.extend(errUnknownObj, {
                        errorType: "sendFail",
                        errorText: "send_fail_try_again"
                    }));
            }
        }
    }
    function saveSMS() {
        var callback = arguments[1];
        var errorCabllback = arguments[2] ? arguments[2] : callback;
        return stuffMake(arguments, {}, prepare, deal, null, true);
        function prepare(values, isPost) {
            var obj = {
                notCallback: true,
                goformId: "SAVE_SMS",
                SMSMessage: escapeMessage(encodeMessage(values.message)),
                SMSNumber: values.numbers.join(";") + ";",
                Index: values.index,
                encode_type: getEncodeType(values.message).encodeType,
                sms_time: values.currentTimeString,
                draft_group_id: values.groupId
            };
            return obj;
        }
        function deal(paramD) {
            if (!paramD) {
                errorCabllback($.extend(errUnknownObj, {
                        errorType: "saveFail",
                        errorText: "save_fail"
                    }));
                return;
            }
            if (paramD.result == "success") {
                getSmsStatusInfo({
                    smsCmd: 5,
                    errorType: "saveFail",
                    errorText: "save_fail"
                }, callback, errorCabllback);
            } else {
                errorCabllback($.extend(errUnknownObj, {
                        errorType: "saveFail",
                        errorText: "save_fail"
                    }));
            }
        }
    }
    function deleteAllMessages() {
        var callback = arguments[1];
        var errorCabllback = arguments[2] ? arguments[2] : callback;
        return stuffMake(arguments, {}, prepare, deal, null, true);
        function prepare(values, isPost) {
            var obj = {
                goformId: "ALL_DELETE_SMS",
                notCallback: true,
                which_cgi: values.location
            };
            return obj;
        }
        function deal(paramD) {
            if (!paramD) {
                errorCabllback($.extend(errUnknownObj, {
                        errorType: "deleteFail",
                        errorText: "delete_fail_try_again"
                    }));
                return;
            }
            if (paramD.result == "success") {
                addTimerSomething("sms_cmd_status_info", checkDeleteStatus);
            } else {
                errorCabllback($.extend(errUnknownObj, {
                        errorType: "deleteFail",
                        errorText: "delete_fail_try_again"
                    }));
            }
        }
        function checkDeleteStatus(paramD) {
            var status = paramD.sms_cmd_status_info;
            if (status == "2") {
                removeTimerSomething("sms_cmd_status_info", checkDeleteStatus);
                errorCabllback($.extend(errUnknownObj, {
                        errorType: "deleteFail",
                        errorText: "delete_fail_try_again"
                    }));
            } else if (status == "3") {
                removeTimerSomething("sms_cmd_status_info", checkDeleteStatus);
                callback({
                    result: true
                });
            }
        }
    }
    function deleteMessage() {
        var callback = arguments[1];
        var errorCabllback = arguments[2] ? arguments[2] : callback;
        return stuffMake(arguments, {}, prepare, deal, null, true);
        function prepare(values, isPost) {
            var msgIds = values.ids.join(";") + ";";
            var obj = {
                goformId: "DELETE_SMS",
                msg_id: msgIds,
                notCallback: true
            };
            return obj;
        }
        function deal(paramD) {
            if (!paramD) {
                errorCabllback($.extend(errUnknownObj, {
                        errorType: "deleteFail",
                        errorText: "delete_fail_try_again"
                    }));
                return;
            }
            if (paramD.result == "success") {
                getSmsStatusInfo({
                    smsCmd: 6,
                    errorType: "deleteFail",
                    errorText: "delete_fail_try_again"
                }, callback, errorCabllback);
            } else {
                errorCabllback($.extend(errUnknownObj, {
                        errorType: "deleteFail",
                        errorText: "delete_fail_try_again"
                    }));
            }
        }
    }
    function getSmsStatusInfo(obj, callback, errorCabllback) {
        reqAsync({
            cmd: "sms_cmd_status_info",
            sms_cmd: obj.smsCmd,
        }, function (paramD) {
            if (paramD) {
                var status = paramD.sms_cmd_status_result;
                if (status == "2") {
                    errorCabllback($.extend(errUnknownObj, {
                            errorType: obj.errorType,
                            errorText: obj.errorText
                        }));
                } else if (status == "3") {
                    callback({
                        result: "success"
                    });
                } else {
                    window.setTimeout(function () {
                        getSmsStatusInfo(obj, callback, errorCabllback);
                    }, 1000);
                }
            } else {
                errorCabllback($.extend(errUnknownObj, {
                        errorType: obj.errorType,
                        errorText: obj.errorText
                    }));
            }
        }, function (paramD) {
            errorCabllback($.extend(errUnknownObj, {
                    errorType: obj.errorType,
                    errorText: obj.errorText
                }));
        }, false);
    }
    function getSMSReady() {
        if (config.smsIsReady) {
            var callback = arguments[1];
            if (callback) {
                return callback({
                    "sms_cmd": "1",
                    "sms_cmd_status_result": "3"
                });
            } else {
                return {
                    "sms_cmd": "1",
                    "sms_cmd_status_result": "3"
                };
            }
        } else {
            return stuffMake(arguments, {}, prepare, deal, null, false);
        }
        function prepare(values, isPost) {
            var valueReq = {};
            valueReq.cmd = "sms_cmd_status_info";
            valueReq.sms_cmd = 1;
            return valueReq;
        }
        function deal(paramD) {
            if (paramD) {
                if (paramD.sms_cmd_status_result == "3") {
                    config.smsIsReady = true;
                }
                return paramD;
            } else {
                return errUnknownObj;
            }
        }
    }
    function setSmsRead() {
        return stuffMake(arguments, {}, prepare, deal, null, true);
        function prepare(values, isPost) {
            var msgIds = values.ids.join(";");
            if (values.ids.length > 0) {
                msgIds += ";";
            }
            var obj = {
                goformId: "SET_MSG_READ",
                msg_id: msgIds,
                tag: 0
            };
            return obj;
        }
        function deal(paramD) {
            if (paramD.result == "success") {
                return {
                    result: true
                };
            } else {
                return {
                    result: false
                };
            }
        }
    }
    function getSMSDeliveryReport() {
        return stuffMake(arguments, {}, prepare, deal, {}, false);
        function prepare(values, isPost) {
            var obj = {
                cmd: "sms_status_rpt_data",
                page: values.page,
                data_per_page: values.smsCount
            };
            return obj;
        }
        function deal(paramD) {
            if (paramD) {
                return {
                    messages: parseMessages(paramD.messages, true)
                };
            } else {
                return errUnknownObj;
            }
        }
    }
    function logout() {
        return stuffMake(arguments, {}, prepare, deal, null, true);
        function prepare(values, isPost) {
            var obj = $.extend({}, values);
            obj.goformId = "LOGOUT";
            return obj;
        }
        function deal(paramD) {
            if (paramD && paramD.result == "success") {
                informationAll.isLoggedIn = false;
                return {
                    result: true
                };
            } else {
                return $.extend(errUnknownObj, {
                    errorType: "loggedOutError"
                });
            }
        }
    }
    function changeManageInfo() {
        return stuffMake(arguments, {}, prepare, deal, null, true);
        function prepare(values, isPost) {
            var obj = {};
            obj.newPassword = config.PASSWORD_ENCODE ? Base64.encode(values.newValue) : values.newValue;
            obj.oldPassword = config.PASSWORD_ENCODE ? Base64.encode(values.oldValue) : values.oldValue;
            obj.goformId = "CHANGE_PASSWORD";
            return obj;
        }
        function deal(paramD) {
            if (paramD && paramD.result === "success") {
                return {
                    result: true
                };
            } else {
                return $.extend(errUnknownObj, {
                    errorType: "badPassword"
                });
            }
        }
    }
    function getPinData() {
        return stuffMake(arguments, {}, prepare, deal, null, false);
        function prepare(values, isPost) {
            var valueReq = {};
            valueReq.cmd = "pinnumber,pin_status,puknumber";
            valueReq.multi_data = 1;
            return valueReq;
        }
        function deal(paramD) {
            if (paramD) {
                return paramD;
            } else {
                return errUnknownObj;
            }
        }
    }
    function enablePin() {
        return stuffMake(arguments, {}, prepare, deal, null, true);
        function prepare(values, isPost) {
            var obj = {};
            obj.goformId = "ENABLE_PIN";
            obj.OldPinNumber = values.oldPin;
            return obj;
        }
        function deal(paramD) {
            if (paramD && paramD.result === "success") {
                return {
                    result: true
                };
            } else {
                return {
                    result: false
                };
            }
        }
    }
    function disablePin() {
        return stuffMake(arguments, {}, prepare, deal, null, true);
        function prepare(values, isPost) {
            var obj = {};
            obj.goformId = "DISABLE_PIN";
            obj.OldPinNumber = values.oldPin;
            return obj;
        }
        function deal(paramD) {
            if (paramD && paramD.result === "success") {
                return {
                    result: true
                };
            } else {
                return {
                    result: false
                };
            }
        }
    }
    function changePin() {
        return stuffMake(arguments, {}, prepare, deal, null, true);
        function prepare(values, isPost) {
            var obj = {};
            obj.goformId = "ENABLE_PIN";
            obj.OldPinNumber = values.oldPin;
            obj.NewPinNumber = values.newPin;
            return obj;
        }
        function deal(paramD) {
            if (paramD && paramD.result === "success") {
                return {
                    result: true
                };
            } else {
                return {
                    result: false
                };
            }
        }
    }
    function getLanInfo() {
        return stuffMake(arguments, {}, prepare, deal, null, false);
        function prepare(values, isPost) {
            var valueReq = {};
            valueReq.cmd = "lan_ipaddr,lan_netmask,mac_address,dhcpEnabled,dhcpStart,dhcpEnd,dhcpLease_hour";
            valueReq.multi_data = 1;
            return valueReq;
        }
        function deal(paramD) {
            if (paramD) {
                var result = {};
                result.ipAddress = paramD.lan_ipaddr;
                result.subnetMask = paramD.lan_netmask;
                result.macAddress = paramD.mac_address;
                result.dhcpServer = paramD.dhcpEnabled;
                result.dhcpStart = paramD.dhcpStart;
                result.dhcpEnd = paramD.dhcpEnd;
                result.dhcpLease = parseInt(paramD.dhcpLease_hour, 10);
                return result;
            } else {
                return errUnknownObj;
            }
        }
    }
    function setLanInfo() {
        return stuffMake(arguments, {}, prepare, deal, null, true);
        function prepare(values, isPost) {
            var valueReq = {};
            valueReq.goformId = "DHCP_SETTING";
            valueReq.lanIp = values.ipAddress;
            valueReq.lanNetmask = values.subnetMask;
            valueReq.lanDhcpType = values.dhcpServer == "1" ? "SERVER" : "DISABLE";
            if (valueReq.lanDhcpType == "SERVER") {
                valueReq.dhcpStart = values.dhcpStart;
                valueReq.dhcpEnd = values.dhcpEnd;
                valueReq.dhcpLease = values.dhcpLease;
            }
            valueReq.dhcp_reboot_flag = 1;
            return valueReq;
        }
        function deal(paramD) {
            if (paramD) {
                return paramD;
            } else {
                return errUnknownObj;
            }
        }
    }
    function getSmsSetting() {
        return stuffMake(arguments, {}, prepare, deal, null, false);
        function prepare(values, isPost) {
            var valueReq = {};
            valueReq.cmd = "sms_parameter_info";
            return valueReq;
        }
        function deal(paramD) {
            if (paramD) {
                var result = {};
                result.centerNumber = paramD.sms_para_sca;
                result.memStroe = paramD.sms_para_mem_store;
                result.deliveryReport = paramD.sms_para_status_report;
                switch (parseInt(paramD.sms_para_validity_period, 10)) {
                case 143:
                    result.validity = "twelve_hours";
                    break;
                case 167:
                    result.validity = "one_day";
                    break;
                case 173:
                    result.validity = "one_week";
                    break;
                case 244:
                    result.validity = "largest";
                    break;
                case 255:
                    result.validity = "largest";
                    break;
                default:
                    result.validity = "twelve_hours";
                    break;
                }
                return result;
            } else {
                return errUnknownObj;
            }
        }
    }
    function setSmsSetting() {
        var callback = arguments[1];
        var errorCabllback = arguments[2] ? arguments[2] : callback;
        return stuffMake(arguments, {}, prepare, deal, null, true);
        function prepare(values, isPost) {
            var valueReq = {};
            valueReq.goformId = "SET_MESSAGE_CENTER";
            valueReq.save_time = values.validity;
            valueReq.MessageCenter = values.centerNumber;
            valueReq.status_save = values.deliveryReport;
            valueReq.save_location = 'native';
            valueReq.notCallback = true;
            return valueReq;
        }
        function deal(paramD) {
            if (!paramD) {
                errorCabllback($.extend(errUnknownObj, {
                        errorType: "smsSettingFail",
                        errorText: "error_info"
                    }));
                return;
            }
            if (paramD.result == "success") {
                getSmsStatusInfo({
                    smsCmd: 3,
                    errorType: "smsSettingFail",
                    errorText: "error_info"
                }, callback, errorCabllback);
            } else {
                errorCabllback($.extend(errUnknownObj, {
                        errorType: "deleteFail",
                        errorText: "delete_fail_try_again"
                    }));
            }
        }
    }
    function restoreFactorySettings() {
        var preErrorObj = {};
        if (config.HAS_PARENTAL_CONTROL && config.currentUserInChildGroup != false) {
            preErrorObj = {
                errorType: 'no_auth'
            };
        }
        return stuffMake(arguments, preErrorObj, prepare, deal, null, true);
        function prepare(values, isPost) {
            var valueReq = {};
            valueReq.goformId = "RESTORE_FACTORY_SETTINGS";
            return valueReq;
        }
        function deal(paramD) {
            if (paramD) {
                return paramD;
            } else {
                return errUnknownObj;
            }
        }
    }
    function checkRestoreStatus(successCallback) {
        var valueReq = {};
        valueReq.cmd = "restore_flag";
        valueReq.multi_data = 1;
        reqAsync(valueReq, function (paramD) {
            if (paramD && paramD.restore_flag === "1") {
                successCallback();
            } else {
                setTimeout(function () {
                    checkRestoreStatus(successCallback);
                }, 5000);
            }
        }, function () {
            setTimeout(function () {
                checkRestoreStatus(successCallback);
            }, 5000);
        }, false);
    }
    function getWpsInfo() {
        return stuffMake(arguments, {}, prepare, deal, null, false);
        function prepare(values, isPost) {
            var valueReq = {};
            valueReq.cmd = "wifi_wps_index,WscModeOption,AuthMode,wifi_cur_state,EncrypType,wps_mode,WPS_SSID,m_ssid_enable,SSID1,m_SSID,m_EncrypType,m_AuthMode,wifi_sta_connection";
            valueReq.multi_data = 1;
            return valueReq;
        }
        function deal(paramD) {
            if (paramD) {
                var result = {};
                result.wpsFlag = paramD.WscModeOption;
                result.authMode = paramD.AuthMode;
                result.wpsType = paramD.wps_mode;
                result.radioFlag = paramD.wifi_cur_state == "1" ? "1" : "0";
                result.encrypType = paramD.EncrypType;
                result.wpsSSID = paramD.WPS_SSID;
                result.ssidEnable = paramD.m_ssid_enable;
                result.ssid = paramD.SSID1;
                result.multiSSID = paramD.m_SSID;
                result.m_encrypType = paramD.m_EncrypType;
                result.wifi_wps_index = paramD.wifi_wps_index;
                result.AuthMode = paramD.AuthMode;
                result.m_AuthMode = paramD.m_AuthMode;
                result.ap_station_enable = paramD.wifi_sta_connection;
                return result;
            } else {
                return errUnknownObj;
            }
        }
    }
    function openWps() {
        return stuffMake(arguments, {}, prepare, deal, null, true);
        function prepare(values, isPost) {
            var valueReq = {};
            valueReq.goformId = "WIFI_WPS_SET";
            valueReq.WPS_SSID = values.wpsSSID;
            valueReq.wps_mode = values.wpsType;
            valueReq.wifi_wps_index = values.wpsIndex;
            if (valueReq.wps_mode == 'PIN') {
                valueReq.wps_pin = values.wpsPin;
            }
            return valueReq;
        }
        function deal(paramD) {
            if (paramD) {
                return paramD;
            } else {
                return errUnknownObj;
            }
        }
    }
    function openWps_5g() {
        return stuffMake(arguments, {}, prepare, deal, null, true);
        function prepare(values, isPost) {
            var valueReq = {};
            valueReq.goformId = "WIFI_M_WPS_SET";
            valueReq.m_WPS_SSID = values.wpsSSID;
            valueReq.m_wps_mode = values.wpsType;
            valueReq.m_wifi_wps_index = values.wpsIndex;
            if (valueReq.m_wps_mode == 'PIN') {
                valueReq.m_wps_pin = values.wpsPin;
            }
            return valueReq;
        }
        function deal(paramD) {
            if (paramD) {
                return paramD;
            } else {
                return errUnknownObj;
            }
        }
    }
    function getSleepMode() {
        return stuffMake(arguments, {}, prepare, deal, null, false);
        function prepare(values, isPost) {
            var valueReq = {};
            valueReq.cmd = "Sleep_interval";
            return valueReq;
        }
        function deal(paramD) {
            if (paramD) {
                var result = {};
                result.sleepMode = paramD.Sleep_interval;
                return result;
            } else {
                return errUnknownObj;
            }
        }
    }
    function setSleepMode() {
        return stuffMake(arguments, {}, prepare, deal, null, true);
        function prepare(values, isPost) {
            var valueReq = {};
            valueReq.goformId = "SET_WIFI_SLEEP_INFO";
            valueReq.sysIdleTimeToSleep = values.sleepMode;
            return valueReq;
        }
        function deal(paramD) {
            if (paramD) {
                return paramD;
            } else {
                return errUnknownObj;
            }
        }
    }
    function getSysSecurity() {
        return stuffMake(arguments, {}, prepare, deal, null, false);
        function prepare(values, isPost) {
            var valueReq = {};
            valueReq.cmd = "RemoteManagement,WANPingFilter";
            valueReq.multi_data = 1;
            return valueReq;
        }
        function deal(paramD) {
            if (paramD) {
                var result = {};
                result.remoteFlag = paramD.RemoteManagement == "1" ? "1" : "0";
                result.pingFlag = paramD.WANPingFilter == "1" ? "1" : "0";
                return result;
            } else {
                return errUnknownObj;
            }
        }
    }
    function setSysSecurity() {
        return stuffMake(arguments, {}, prepare, deal, null, true);
        function prepare(values, isPost) {
            var valueReq = {};
            valueReq.goformId = "FW_SYS";
            valueReq.remoteManagementEnabled = values.remoteFlag;
            valueReq.pingFrmWANFilterEnabled = values.pingFlag;
            return valueReq;
        }
        function deal(paramD) {
            if (paramD) {
                return paramD;
            } else {
                return errUnknownObj;
            }
        }
    }
    function getPortForward() {
        return stuffMake(arguments, {}, prepare, deal, null, false);
        function prepare(values, isPost) {
            var valueReq = {};
            valueReq.cmd = "PortForwardEnable,PortForwardRules_0,PortForwardRules_1,PortForwardRules_2,PortForwardRules_3,PortForwardRules_4,PortForwardRules_5,PortForwardRules_6,PortForwardRules_7,PortForwardRules_8,PortForwardRules_9";
            valueReq.multi_data = 1;
            return valueReq;
        }
        function deal(paramD) {
            if (paramD) {
                var result = {};
                result.portForwardEnable = paramD.PortForwardEnable;
                var rules = [];
                if (paramD.PortForwardRules_0 != "") {
                    rules.push([0, paramD.PortForwardRules_0]);
                }
                if (paramD.PortForwardRules_1 != "") {
                    rules.push([1, paramD.PortForwardRules_1]);
                }
                if (paramD.PortForwardRules_2 != "") {
                    rules.push([2, paramD.PortForwardRules_2]);
                }
                if (paramD.PortForwardRules_3 != "") {
                    rules.push([3, paramD.PortForwardRules_3]);
                }
                if (paramD.PortForwardRules_4 != "") {
                    rules.push([4, paramD.PortForwardRules_4]);
                }
                if (paramD.PortForwardRules_5 != "") {
                    rules.push([5, paramD.PortForwardRules_5]);
                }
                if (paramD.PortForwardRules_6 != "") {
                    rules.push([6, paramD.PortForwardRules_6]);
                }
                if (paramD.PortForwardRules_7 != "") {
                    rules.push([7, paramD.PortForwardRules_7]);
                }
                if (paramD.PortForwardRules_8 != "") {
                    rules.push([8, paramD.PortForwardRules_8]);
                }
                if (paramD.PortForwardRules_9 != "") {
                    rules.push([9, paramD.PortForwardRules_9]);
                }
                result.portForwardRules = parsePortForwardRules(rules);
                return result;
            } else {
                return errUnknownObj;
            }
        }
        function parsePortForwardRules(paramD) {
            var rules = [];
            if (paramD && paramD.length > 0) {
                for (var i = 0; i < paramD.length; i++) {
                    var aRule = {};
                    var elements = paramD[i][1].split(",");
                    aRule.index = paramD[i][0];
                    aRule.ipAddress = elements[0];
                    aRule.portRange = elements[1] + ' - ' + elements[2];
                    aRule.protocol = transProtocol(elements[3]);
                    aRule.comment = elements[4];
                    rules.push(aRule);
                }
            }
            return rules;
        }
    }
    function setPortForward() {
        return stuffMake(arguments, {}, prepare, deal, null, true);
        function prepare(values, isPost) {
            var valueReq = {};
            valueReq.goformId = "FW_FORWARD_ADD";
            valueReq.ipAddress = values.ipAddress;
            valueReq.portStart = values.portStart;
            valueReq.portEnd = values.portEnd;
            valueReq.protocol = values.protocol;
            valueReq.comment = values.comment;
            return valueReq;
        }
        function deal(paramD) {
            if (paramD) {
                return paramD;
            } else {
                return errUnknownObj;
            }
        }
    }
    function deleteForwardRules() {
        return stuffMake(arguments, {}, prepare, deal, null, true);
        function prepare(values, isPost) {
            var valueReq = {};
            valueReq.goformId = "FW_FORWARD_DEL";
            valueReq.delete_id = values.indexs.join(';') + ";";
            return valueReq;
        }
        function deal(paramD) {
            if (paramD) {
                return paramD;
            } else {
                return errUnknownObj;
            }
        }
    }
    function enableVirtualServer() {
        return stuffMake(arguments, {}, prepare, deal, null, true);
        function prepare(values, isPost) {
            var valueReq = {};
            valueReq.goformId = "VIRTUAL_SERVER";
            valueReq.PortForwardEnable = values.portForwardEnable;
            return valueReq;
        }
        function deal(paramD) {
            if (paramD) {
                return paramD;
            } else {
                return errUnknownObj;
            }
        }
    }
    function wifiDecode(fact1,fact2,encode_aes) {//wifiDecode(paramD.rnum_js,paramD.imei,paramD.WPAPSK1_enaes,paramD.m_WPAPSK1_enaes);
        var kstr = fact1 + fact2 + "FFFFFFFFFFFFFFFFFFFFFFFF";
        var kstr_final;
	var kiv_final;

        kstr_final = kstr.substring(0, 24);
	kiv_final = kstr.substring(0, 16);

        var tkey = CryptoJS.enc.Latin1.parse(kstr_final);
	var tiv = CryptoJS.enc.Latin1.parse(kiv_final);
        var decdata = CryptoJS.AES.decrypt(encode_aes, tkey, {
            iv: tiv,
            mode: CryptoJS.mode.CBC,
            padding: CryptoJS.pad.ZeroPadding
        }).toString(CryptoJS.enc.Utf8);

        return decdata;
    }
    function getQuickSettingInfo() {
        return stuffMake(arguments, {}, prepare, deal, null, false);
        function prepare(values, isPost) {
            var valueReq = {};
            var wpask = config.PASSWORD_ENCODE ? ",WPAPSK1_encode" : ",imei,rnum_js,WPAPSK1_enaes";
            valueReq.cmd = "pdp_type,ipv6_pdp_type,wifi_cur_state,SSID1,HideSSID,AuthMode,WscModeOption,ppp_status,apn_index,ipv6_apn_index,ipv6_APN_index,m_profile_name,apn_mode,EncrypType,DefaultKeyID,Key1Str1,Key2Str1,Key3Str1,Key4Str1" + wpask + ",APN_configtmp0,APN_configtmp1,APN_configtmp2,APN_configtmp3,APN_configtmp4,APN_configtmp5,APN_configtmp6,APN_configtmp7,APN_configtmp8,APN_configtmp9,APN_configtmp10,APN_configtmp11,APN_configtmp12,APN_configtmp13,APN_configtmp14,APN_configtmp15,APN_configtmp16,APN_configtmp17,APN_configtmp18,APN_configtmp19" + ",ipv6_APN_configtmp0,ipv6_APN_configtmp1,ipv6_APN_configtmp2,ipv6_APN_configtmp3,ipv6_APN_configtmp4,ipv6_APN_configtmp5,ipv6_APN_configtmp6,ipv6_APN_configtmp7,ipv6_APN_configtmp8,ipv6_APN_configtmp9,ipv6_APN_configtmp10,ipv6_APN_configtmp11,ipv6_APN_configtmp12,ipv6_APN_configtmp13,ipv6_APN_configtmp14,ipv6_APN_configtmp15,ipv6_APN_configtmp16,ipv6_APN_configtmp17,ipv6_APN_configtmp18,ipv6_APN_configtmp19";
            valueReq.multi_data = 1;
            return valueReq;
        }
        function deal(paramD) {
            if (paramD) {
                if (config.PASSWORD_ENCODE) {
                    paramD.WPAPSK1 = Base64.decode(paramD.WPAPSK1_encode);
                } else {
		    paramD.WPAPSK1 = wifiDecode(paramD.rnum_js,paramD.imei,paramD.WPAPSK1_enaes);
		}
                return paramD;
            } else {
                return errUnknownObj;
            }
        }
    }
    function setQuickSetting4IPv6() {
        stuffMakeAndCheckServerIsOnline(arguments, prepare, deal);
        function prepare(values) {
            var valueReq = {
                goformId: "QUICK_SETUP_EX",
                index: values.apn_index,
                pdp_type: values.pdp_type,
                apn_mode: values.apnMode,
                profile_name: values.profile_name,
                wan_apn: values.wan_apn,
                ppp_auth_mode: values.ppp_auth_mode,
                ppp_username: values.ppp_username,
                ppp_passtmp: values.ppp_passtmp,
                ipv6_wan_apn: values.ipv6_wan_apn,
                ipv6_ppp_auth_mode: values.ipv6_ppp_auth_mode,
                ipv6_ppp_username: values.ipv6_ppp_username,
                ipv6_ppp_passtmp: values.ipv6_ppp_passtmp,
                SSID_name: values.SSID_name,
                SSID_Broadcast: values.SSID_Broadcast,
                Encryption_Mode_hid: values.Encryption_Mode_hid,
                security_shared_mode: values.security_shared_mode,
                WPA_PreShared_Key: config.PASSWORD_ENCODE ? Base64.encode(values.WPA_PreShared_Key) : values.WPA_PreShared_Key,
                wep_default_key: values.wep_default_key,
                WPA_ENCRYPTION_hid: values.WPA_ENCRYPTION_hid
            }
            valueReq.wep_key_1 = values.wep_key_1;
            valueReq.wep_key_2 = values.wep_key_2;
            valueReq.wep_key_3 = values.wep_key_3;
            valueReq.wep_key_4 = values.wep_key_4;
            if (values.wep_default_key == '1') {
                valueReq.WEP2Select = values.WEP2Select;
            } else if (values.wep_default_key == '2') {
                valueReq.WEP3Select = values.WEP3Select;
            } else if (values.wep_default_key == '3') {
                valueReq.WEP4Select = values.WEP4Select;
            } else {
                valueReq.WEP1Select = values.WEP1Select;
            }
            return valueReq;
        }
        function deal(paramD) {
            if (paramD) {
                return paramD;
            } else {
                return $.extend(errUnknownObj, {
                    errorType: "SetSetUpError"
                });
            }
        }
    }
    function stuffMakeAndCheckServerIsOnline(arg, prepare, deal) {
        var isServerOnline = false;
        var isCallbackExecuted = false;
        var values = prepare(arg[0]);
        var callback = arg[1];
        var successCallback = function (paramD) {
            isServerOnline = true;
            if (!isCallbackExecuted && callback) {
                callback(deal(paramD));
            }
            isCallbackExecuted = true;
        };
        var errorMethod = arg[2];
        var errorCallback = function () {
            isServerOnline = true;
            if (errorMethod) {
                errorMethod();
            }
        };
        reqAsync(values, successCallback, errorCallback, true);
        addTimeout(function () {
            if (isServerOnline == false) {
                var timer = addInterval(function () {
                    if (isServerOnline == false) {
                        getLanguage({}, function (paramD) {
                            window.clearInterval(timer);
                            successCallback({
                                result: "success"
                            });
                        });
                    }
                }, 1000);
            }
        }, 5000);
    }
    function getSDConfiguration() {
        return stuffMake(arguments, {}, prepare, deal, null, false);
        function prepare(values, isPost) {
            var valueReq = {
                cmd: "sdcard_mode_option,sd_card_state,HTTP_SHARE_STATUS,HTTP_SHARE_WR_AUTH,HTTP_SHARE_FILE",
                multi_data: 1
            };
            return valueReq;
        }
        function deal(paramD) {
            if (paramD) {
                var fileToShare;
                if ("mmc2" == paramD.HTTP_SHARE_FILE || "/mmc2" == paramD.HTTP_SHARE_FILE || "/mmc2/" == paramD.HTTP_SHARE_FILE) {
                    fileToShare = "1";
                } else {
                    fileToShare = "0";
                }
                var result = {
                    sd_mode: paramD.sdcard_mode_option == "1" ? "0" : "1",
                    sd_status: paramD.sd_card_state,
                    share_status: paramD.HTTP_SHARE_STATUS == "Enabled" ? "1" : "0",
                    share_auth: paramD.HTTP_SHARE_WR_AUTH == "readOnly" ? "0" : "1",
                    file_to_share: fileToShare,
                    share_file: paramD.HTTP_SHARE_FILE
                };
                return result;
            } else {
                return errUnknownObj;
            }
        }
    }
    function setSdCardMode() {
        return stuffMake(arguments, {}, prepare, deal, null, true);
        function prepare(values, isPost) {
            var valueReq = {
                goformId: "HTTPSHARE_MODE_SET",
                mode_set: values.mode == "0" ? "http_share_mode" : "usb_mode"
            };
            return valueReq;
        }
        function deal(paramD) {
            if (paramD && paramD.result == 'success') {
                return {
                    result: 'success'
                };
            } else if (paramD && paramD.result == 'processing') {
                return {
                    result: 'processing'
                };
            } else {
                return {
                    result: false
                };
            }
        }
    }
    function checkFileExists() {
        return stuffMake(arguments, {}, prepare, deal, null, true);
        function prepare(values, isPost) {
            var valueReq = {
                goformId: "GOFORM_HTTPSHARE_CHECK_FILE",
                path_SD_CARD: values.path
            };
            return valueReq;
        }
        function deal(paramD) {
            if (paramD) {
                if (paramD.result == "no_sdcard") {
                    return {
                        status: "no_sdcard"
                    };
                } else if (paramD.result == "noexist") {
                    return {
                        status: "noexist"
                    };
                } else if (paramD.result == "processing") {
                    return {
                        status: "processing"
                    };
                } else {
                    return {
                        status: "exist"
                    };
                }
            } else {
                return errUnknownObj;
            }
        }
    }
    function getFileList() {
        return stuffMake(arguments, {}, prepare, deal, null, true);
        function prepare(values, isPost) {
            var valueReq = {
                goformId: "HTTPSHARE_ENTERFOLD",
                path_SD_CARD: values.path,
                indexPage: values.index
            };
            return valueReq;
        }
        function deal(paramD) {
            if (paramD) {
                if (paramD.result == 'failure') {
                    return $.extend(errUnknownObj, {
                        errorType: "get_file_list_failure"
                    });
                } else if (paramD.result == "no_sdcard") {
                    return $.extend(errUnknownObj, {
                        errorType: "no_sdcard"
                    });
                } else {
                    return parseSdCardFile(paramD.result);
                }
            } else {
                return errUnknownObj;
            }
        }
        function parseSdCardFile(result) {
            var fileInfo = {};
            fileInfo.totalRecord = result.totalRecord;
            var fileArr = [];
            var details = result.fileInfo;
            for (var i = 0; details && i < details.length; i++) {
                if (details[i].fileName == "") {
                    continue;
                }
                var obj = {};
                obj.fileName = details[i].fileName;
                obj.attribute = details[i].attribute;
                obj.size = details[i].size;
                obj.lastUpdateTime = details[i].lastUpdateTime;
                fileArr.push(obj);
            }
            fileInfo.details = fileArr;
            return fileInfo;
        }
    }
    function fileRename() {
        return stuffMake(arguments, {}, prepare, deal, null, true);
        function prepare(values, isPost) {
            var d = new Date();
            var currentTime = d.getTime();
            var zoneOffsetSeconds = d.getTimezoneOffset() * 60;
            return {
                goformId: "HTTPSHARE_FILE_RENAME",
                path_SD_CARD: values.path,
                OLD_NAME_SD_CARD: values.oldPath,
                NEW_NAME_SD_CARD: values.newPath,
                path_SD_CARD_time: transUnixTime(currentTime),
                path_SD_CARD_time_unix: Math.round((currentTime - zoneOffsetSeconds * 1000) / 1e3)
            };
        }
        function deal(paramD) {
            if (paramD) {
                if (paramD.result == "success") {
                    return {
                        result: true
                    };
                } else if (paramD.result == "no_sdcard") {
                    return $.extend(errUnknownObj, {
                        errorType: "no_sdcard"
                    });
                } else if (paramD.result == "noexist") {
                    return $.extend(errUnknownObj, {
                        errorType: "no_exist"
                    });
                } else if (paramD.result == "processing") {
                    return $.extend(errUnknownObj, {
                        errorType: "sd_file_processing_cant_rename"
                    });
                } else {
                    return {
                        result: false
                    };
                }
            } else {
                return errUnknownObj;
            }
        }
    }
    function getSdMemorySizes() {
        return stuffMake(arguments, {}, prepare, deal, null, false);
        function prepare(values, isPost) {
            var valueReq = {
                cmd: "HTTPSHARE_GETCARD_VALUE"
            };
            return valueReq;
        }
        function deal(paramD) {
            if (!paramD || (paramD.result && paramD.result == "no_sdcard")) {
                return $.extend(errUnknownObj, {
                    errorType: "no_sdcard"
                });
            } else {
                return {
                    totalMemorySize: paramD.sd_card_total_size == "" ? 0 : paramD.sd_card_total_size * 32 * 1024,
                    availableMemorySize: paramD.sd_card_avi_space == "" ? 0 : paramD.sd_card_avi_space * 32 * 1024
                };
            }
        }
    }
    function deleteFilesAndFolders() {
        return stuffMake(arguments, {}, prepare, deal, null, true);
        function prepare(values, isPost) {
            var currentTime = new Date().getTime();
            var valueReq = {
                goformId: "HTTPSHARE_DEL",
                path_SD_CARD: values.path,
                name_SD_CARD: values.names,
                path_SD_CARD_time: transUnixTime(currentTime),
                path_SD_CARD_time_unix: Math.round(currentTime / 1e3)
            };
            return valueReq;
        }
        function deal(paramD) {
            if (paramD.result && paramD.result == "failure") {
                return {
                    status: "failure"
                };
            } else if (paramD.result && paramD.result == "no_sdcard") {
                return {
                    status: "no_sdcard"
                };
            } else if (paramD.result && paramD.result == "processing") {
                return {
                    status: "processing"
                };
            } else if (paramD.result && paramD.result == "success") {
                return {
                    status: "success"
                };
            } else {
                return errUnknownObj;
            }
        }
    }
    function createFolder() {
        return stuffMake(arguments, {}, prepare, deal, null, true);
        function prepare(values, isPost) {
            var d = new Date();
            var currentTime = d.getTime();
            var zoneOffsetSeconds = d.getTimezoneOffset() * 60;
            return {
                goformId: "HTTPSHARE_NEW",
                path_SD_CARD: values.path,
                path_SD_CARD_time: transUnixTime(currentTime),
                path_SD_CARD_time_unix: Math.round((currentTime - zoneOffsetSeconds * 1000) / 1e3)
            };
        }
        function deal(paramD) {
            if (paramD.result && paramD.result == "failure") {
                return $.extend(errUnknownObj, {
                    errorType: "create_folder_failure"
                });
            } else if (paramD.result && paramD.result == "no_sdcard") {
                return $.extend(errUnknownObj, {
                    errorType: "no_sdcard"
                });
            } else if (paramD.result && paramD.result == "success") {
                return {
                    result: true
                };
            } else {
                return errUnknownObj;
            }
        }
    }
    function setSdCardSharing() {
        return stuffMake(arguments, {}, prepare, deal, null, true);
        function prepare(values, isPost) {
            var valueReq = {
                goformId: "HTTPSHARE_AUTH_SET",
                HTTP_SHARE_STATUS: values.share_status == "1" ? "Enabled" : "Disabled",
                HTTP_SHARE_WR_AUTH: values.share_auth == "1" ? "readWrite" : "readOnly",
                HTTP_SHARE_FILE: values.share_file
            };
            return valueReq;
        }
        function deal(paramD) {
            if (paramD) {
                if (paramD.result == "no_sdcard") {
                    return $.extend(errUnknownObj, {
                        errorType: "no_sdcard"
                    });
                } else {
                    return {
                        result: true
                    };
                }
            } else {
                return errUnknownObj;
            }
        }
    }
    function getPortFilter() {
        return stuffMake(arguments, {}, prepare, deal, null, false);
        function prepare(values, isPost) {
            var valueReq = {};
            valueReq.cmd = "IPPortFilterEnable,DefaultFirewallPolicy,IPPortFilterRules_0,IPPortFilterRules_1,IPPortFilterRules_2,IPPortFilterRules_3,IPPortFilterRules_4,IPPortFilterRules_5,IPPortFilterRules_6,IPPortFilterRules_7,IPPortFilterRules_8,IPPortFilterRules_9";
            valueReq.cmd += ",IPPortFilterRulesv6_0,IPPortFilterRulesv6_1,IPPortFilterRulesv6_2,IPPortFilterRulesv6_3,IPPortFilterRulesv6_4,IPPortFilterRulesv6_5,IPPortFilterRulesv6_6,IPPortFilterRulesv6_7,IPPortFilterRulesv6_8,IPPortFilterRulesv6_9";
            valueReq.multi_data = 1;
            return valueReq;
        }
        function deal(paramD) {
            if (paramD) {
                var result = {};
                result.portFilterEnable = paramD.IPPortFilterEnable;
                result.defaultPolicy = paramD.DefaultFirewallPolicy;
                var rules = [];
                if (paramD.IPPortFilterRules_0 != "") {
                    rules.push([0, paramD.IPPortFilterRules_0]);
                }
                if (paramD.IPPortFilterRules_1 != "") {
                    rules.push([1, paramD.IPPortFilterRules_1]);
                }
                if (paramD.IPPortFilterRules_2 != "") {
                    rules.push([2, paramD.IPPortFilterRules_2]);
                }
                if (paramD.IPPortFilterRules_3 != "") {
                    rules.push([3, paramD.IPPortFilterRules_3]);
                }
                if (paramD.IPPortFilterRules_4 != "") {
                    rules.push([4, paramD.IPPortFilterRules_4]);
                }
                if (paramD.IPPortFilterRules_5 != "") {
                    rules.push([5, paramD.IPPortFilterRules_5]);
                }
                if (paramD.IPPortFilterRules_6 != "") {
                    rules.push([6, paramD.IPPortFilterRules_6]);
                }
                if (paramD.IPPortFilterRules_7 != "") {
                    rules.push([7, paramD.IPPortFilterRules_7]);
                }
                if (paramD.IPPortFilterRules_8 != "") {
                    rules.push([8, paramD.IPPortFilterRules_8]);
                }
                if (paramD.IPPortFilterRules_9 != "") {
                    rules.push([9, paramD.IPPortFilterRules_9]);
                }
                result.portFilterRules = parsePortFilterRules(rules, "IPv4");
                var v6Rules = [];
                if (paramD.IPPortFilterRulesv6_0 != "") {
                    v6Rules.push([10, paramD.IPPortFilterRulesv6_0]);
                }
                if (paramD.IPPortFilterRulesv6_1 != "") {
                    v6Rules.push([11, paramD.IPPortFilterRulesv6_1]);
                }
                if (paramD.IPPortFilterRulesv6_2 != "") {
                    v6Rules.push([12, paramD.IPPortFilterRulesv6_2]);
                }
                if (paramD.IPPortFilterRulesv6_3 != "") {
                    v6Rules.push([13, paramD.IPPortFilterRulesv6_3]);
                }
                if (paramD.IPPortFilterRulesv6_4 != "") {
                    v6Rules.push([14, paramD.IPPortFilterRulesv6_4]);
                }
                if (paramD.IPPortFilterRulesv6_5 != "") {
                    v6Rules.push([15, paramD.IPPortFilterRulesv6_5]);
                }
                if (paramD.IPPortFilterRulesv6_6 != "") {
                    v6Rules.push([16, paramD.IPPortFilterRulesv6_6]);
                }
                if (paramD.IPPortFilterRulesv6_7 != "") {
                    v6Rules.push([17, paramD.IPPortFilterRulesv6_7]);
                }
                if (paramD.IPPortFilterRulesv6_8 != "") {
                    v6Rules.push([18, paramD.IPPortFilterRulesv6_8]);
                }
                if (paramD.IPPortFilterRulesv6_9 != "") {
                    v6Rules.push([19, paramD.IPPortFilterRulesv6_9]);
                }
                result.portFilterRules = _.union(result.portFilterRules, parsePortFilterRules(v6Rules, "IPv6"));
                return result;
            } else {
                return errUnknownObj;
            }
        }
        function parsePortFilterRules(paramD, ipTypeTmp) {
            var rules = [];
            if (paramD && paramD.length > 0) {
                for (var i = 0; i < paramD.length; i++) {
                    var aRule = {};
                    var elements = paramD[i][1].split(",");
                    aRule.index = paramD[i][0];
                    aRule.macAddress = elements[11];
                    aRule.destIpAddress = elements[4] == "any/0" ? "" : elements[4];
                    aRule.sourceIpAddress = elements[0] == "any/0" ? "" : elements[0];
                    aRule.destPortRange = elements[6] == '0' ? '' : elements[6] + " - " + elements[7];
                    aRule.sourcePortRange = elements[2] == '0' ? '' : elements[2] + " - " + elements[3];
                    aRule.action = elements[9] == 1 ? "filter_accept" : "filter_drop";
                    aRule.protocol = transProtocol(elements[8]);
                    aRule.comment = elements[10];
                    aRule.ipType = ipTypeTmp;
                    rules.push(aRule);
                }
            }
            return rules;
        }
    }
    function setPortFilterBasic() {
        return stuffMake(arguments, {}, prepare, deal, null, true);
        function prepare(values, isPost) {
            var valueReq = {};
            valueReq.goformId = "BASIC_SETTING";
            valueReq.portFilterEnabled = values.portFilterEnable;
            valueReq.defaultFirewallPolicy = values.defaultPolicy;
            return valueReq;
        }
        function deal(paramD) {
            if (paramD) {
                return paramD;
            } else {
                return errUnknownObj;
            }
        }
    }
    function setPortFilter() {
        return stuffMake(arguments, {}, prepare, deal, null, true);
        function prepare(values, isPost) {
            var valueReq = {};
            valueReq.goformId = "ADD_IP_PORT_FILETER_V4V6";
            valueReq.ip_version = values.ipType;
            valueReq.mac_address = values.macAddress;
            valueReq.dip_address = values.destIpAddress;
            valueReq.sip_address = values.sourceIpAddress;
            valueReq.dFromPort = values.destPortStart;
            valueReq.dToPort = values.destPortEnd;
            valueReq.sFromPort = values.sourcePortStart;
            valueReq.sToPort = values.sourcePortEnd;
            valueReq.action = values.action;
            valueReq.protocol = values.protocol;
            valueReq.comment = values.comment;
            return valueReq;
        }
        function deal(paramD) {
            if (paramD) {
                return paramD;
            } else {
                return errUnknownObj;
            }
        }
    }
    function deleteFilterRules() {
        return stuffMake(arguments, {}, prepare, deal, null, true);
        function prepare(values, isPost) {
            var valueReq = {};
            var deleteIds = _.filter(values.indexs, function (item) {
                return item.length == 1;
            });
            valueReq.goformId = "DEL_IP_PORT_FILETER_V4V6";
            var deletev6Ids = [];
            _.each(values.indexs, function (item) {
                if (item.length == 2) {
                    deletev6Ids.push(item.substring(1));
                }
            });
            valueReq.delete_id_v6 = deletev6Ids.length > 0 ? deletev6Ids.join(';') + ";" : "";
            valueReq.delete_id = deleteIds.length > 0 ? deleteIds.join(';') + ";" : "";
            return valueReq;
        }
        function deal(paramD) {
            if (paramD) {
                return paramD;
            } else {
                return errUnknownObj;
            }
        }
    }
    function getWifiAdvance() {
        return stuffMake(arguments, {}, prepare, deal, null, false);
        function prepare(values, isPost) {
            var valueReq = {};
            valueReq.cmd = "WirelessMode,CountryCode,Channel,HT_MCS,wifi_band,wifi_11n_cap,MAX_Access_num,m_MAX_Access_num,MAX_Station_num,wifi_sta_connection";
            valueReq.multi_data = 1;
            return valueReq;
        }
        function deal(paramD) {
            if (paramD) {
                var result = {
                    mode: paramD.WirelessMode,
                    countryCode: paramD.CountryCode,
                    channel: paramD.Channel,
                    rate: paramD.HT_MCS,
                    wifiBand: paramD.wifi_band == 'a' ? 'a' : 'b',
                    bandwidth: paramD.wifi_11n_cap,
                    MAX_Station_num: $.isNumeric(paramD.MAX_Station_num) ? paramD.MAX_Station_num : config.MAX_STATION_NUMBER,
                    MAX_Access_num: paramD.MAX_Access_num,
                    m_MAX_Access_num: paramD.m_MAX_Access_num,
                    ap_station_enable: paramD.wifi_sta_connection
                };
                return result;
            } else {
                return errUnknownObj;
            }
        }
    }
    function setWifiAdvance() {
        stuffMakeAndCheckServerIsOnline(arguments, prepare, deal);
        function prepare(values) {
            var valueReq = {
                goformId: "SET_WIFI_INFO",
                wifiMode: values.mode,
                countryCode: values.countryCode,
                MAX_Access_num: values.station,
                m_MAX_Access_num: values.m_station
            };
            if (config.WIFI_BAND_SUPPORT) {
                valueReq.wifi_band = values.wifiBand;
            }
            if (config.WIFI_BAND_SUPPORT && values.wifiBand == 'a') {
                valueReq.selectedChannel = 'auto';
            } else {
                valueReq.selectedChannel = values.channel;
                valueReq.abg_rate = values.rate;
            }
            if (config.WIFI_BANDWIDTH_SUPPORT) {
                valueReq.wifi_11n_cap = values.bandwidth;
            }
            return valueReq;
        }
        function deal(paramD) {
            if (paramD) {
                return paramD;
            } else {
                return errUnknownObj;
            }
        }
    }
    function getDeviceInfo() {
        return stuffMake(arguments, {}, prepare, deal, null, false);
        function prepare(values, isPost) {
	    var wpask = config.PASSWORD_ENCODE ? "WPAPSK1_encode,m_WPAPSK1_encode," : "rnum_js,WPAPSK1_enaes,m_WPAPSK1_enaes,";
            var valueReq = {
                cmd: "wifi_coverage,m_ssid_enable,imei,network_type,sub_network_type,rssi,rscp,lte_rsrp,imsi,sim_imsi,cr_version,hw_version,MAX_Access_num," + wpask + "SSID1,AuthMode,m_SSID,m_AuthMode,m_HideSSID,m_MAX_Access_num,lan_ipaddr," + "mac_address,msisdn,LocalDomain,wan_ipaddr,static_wan_ipaddr,ipv6_wan_ipaddr,ipv6_pdp_type,pdp_type,ppp_status,sta_ip_status,rj45_state,ethwan_mode",
                multi_data: 1
            };
            return valueReq;
        }
        function deal(paramD) {
            if (paramD) {
                return {
                    ssid: paramD.SSID1,
                    authMode: paramD.AuthMode,
                    passPhrase: config.PASSWORD_ENCODE ? Base64.decode(paramD.WPAPSK1_encode) : wifiDecode(paramD.rnum_js,paramD.imei,paramD.WPAPSK1_enaes),
                    m_ssid: paramD.m_SSID,
                    m_AuthMode: paramD.m_AuthMode,
                    m_passPhrase: config.PASSWORD_ENCODE ? Base64.decode(paramD.m_WPAPSK1_encode) : wifiDecode(paramD.rnum_js,paramD.imei,paramD.m_WPAPSK1_enaes),
                    m_max_access_num: paramD.m_MAX_Access_num,
                    multi_ssid_enable: paramD.m_ssid_enable,
                    ipAddress: paramD.lan_ipaddr,
                    wanIpAddress: paramD.wan_ipaddr,
                    staticWanIpAddress: paramD.static_wan_ipaddr,
                    ipv6WanIpAddress: paramD.ipv6_wan_ipaddr,
                    ipv6PdpType: paramD.ipv6_pdp_type,
                    macAddress: paramD.mac_address,
                    simSerialNumber: paramD.msisdn,
                    lanDomain: paramD.LocalDomain,
                    imei: paramD.imei,
                    signal: convertSignal(paramD),
                    imsi: paramD.imsi || paramD.sim_imsi,
                    sw_version: paramD.cr_version,
                    hw_version: paramD.hw_version,
                    max_access_num: paramD.MAX_Access_num,
                    wifiRange: paramD.wifi_coverage,
                    pdpType: paramD.pdp_type,
                    rj45ConnectStatus: (typeof paramD.rj45_state == 'undefined' || paramD.rj45_state == '') ? 'dead' : paramD.rj45_state,
                    blc_wan_mode: informationAll.blc_wan_mode,
                    connectStatus: paramD.ppp_status,
                    wifiConStatus: paramD.sta_ip_status,
                    ethwan_mode: paramD.ethwan_mode.toUpperCase()
                };
            } else {
                return errUnknownObj;
            }
        }
    }
    function getDeviceInfoLow() {
        return stuffMake(arguments, {}, prepare, deal, null, false);
        function prepare(values, isPost) {
            var valueReq = {
                cmd: "imei,rnum_js",
                multi_data: 1
            };
            return valueReq;
        }
        function deal(paramD) {
            if (paramD) {
                var kstr = paramD.rnum_js + paramD.imei + "FFFFFFFFFFFFFFFFFFFFFFFF";
                var kstr_final;
		var kiv_final;

                kstr_final = kstr.substring(0, 24);
		kiv_final = kstr.substring(0, 16);

                return {
                    skey: kstr_final,
		    siv: kiv_final
            	};
            } else {
				
	        return {
                    skey: "FFFFFFFFFFFFFFFFFFFFFFFF",
		    siv: "FFFFFFFFFFFFFFFF"
            	};
            }
        }
    }
    function getWifiRange() {
        return stuffMake(arguments, {}, prepare, deal, null, false);
        function prepare(values, isPost) {
            var valueReq = {};
            valueReq.cmd = "wifi_coverage";
            return valueReq;
        }
        function deal(paramD) {
            if (paramD) {
                var result = {};
                result.wifiRangeMode = paramD.wifi_coverage;
                return result;
            } else {
                return errUnknownObj;
            }
        }
    }
    function setWifiRange() {
        return stuffMake(arguments, {}, prepare, deal, null, true);
        function prepare(values, isPost) {
            var valueReq = {};
            valueReq.goformId = "SET_WIFI_COVERAGE";
            valueReq.wifi_coverage = values.wifiRangeMode;
            return valueReq;
        }
        function deal(paramD) {
            if (paramD) {
                return paramD;
            } else {
                return errUnknownObj;
            }
        }
    }
    function getUpnpSetting() {
        return stuffMake(arguments, {}, prepare, deal, null, false);
        function prepare(values, isPost) {
            var valueReq = {};
            valueReq.cmd = "upnpEnabled";
            valueReq.multi_data = 1;
            return valueReq;
        }
        function deal(paramD) {
            if (paramD) {
                var result = {};
                result.upnpSetting = paramD.upnpEnabled == "1" ? "1" : "0";
                return result;
            } else {
                return errUnknownObj;
            }
        }
    }
    function setUpnpSetting() {
        return stuffMake(arguments, {}, prepare, deal, null, true);
        function prepare(values, isPost) {
            var valueReq = {};
            valueReq.goformId = "UPNP_SETTING";
            valueReq.upnp_setting_option = values.upnpSetting;
            return valueReq;
        }
        function deal(paramD) {
            if (paramD) {
                return paramD;
            } else {
                return errUnknownObj;
            }
        }
    }
    function getDmzSetting() {
        return stuffMake(arguments, {}, prepare, deal, null, false);
        function prepare(values, isPost) {
            var valueReq = {};
            valueReq.cmd = "DMZEnable,DMZIPAddress";
            valueReq.multi_data = 1;
            return valueReq;
        }
        function deal(paramD) {
            if (paramD) {
                var result = {};
                result.dmzSetting = paramD.DMZEnable == "1" ? "1" : "0";
                result.ipAddress = paramD.DMZIPAddress;
                return result;
            } else {
                return errUnknownObj;
            }
        }
    }
    function setDmzSetting() {
        return stuffMake(arguments, {}, prepare, deal, null, true);
        function prepare(values, isPost) {
            var valueReq = {};
            valueReq.goformId = "DMZ_SETTING";
            valueReq.DMZEnabled = values.dmzSetting;
            if (valueReq.DMZEnabled == '1') {
                valueReq.DMZIPAddress = values.ipAddress;
            }
            return valueReq;
        }
        function deal(paramD) {
            if (paramD) {
                return paramD;
            } else {
                return errUnknownObj;
            }
        }
    }
    function getPortMap() {
        return stuffMake(arguments, {}, prepare, deal, null, false);
        function prepare(values, isPost) {
            var valueReq = {};
            valueReq.cmd = "PortMapEnable,PortMapRules_0,PortMapRules_1,PortMapRules_2,PortMapRules_3,PortMapRules_4,PortMapRules_5,PortMapRules_6,PortMapRules_7,PortMapRules_8,PortMapRules_9",
            valueReq.multi_data = 1;
            return valueReq;
        }
        function deal(paramD) {
            if (paramD) {
                var result = {};
                result.portMapEnable = paramD.PortMapEnable;
                var rules = [];
                if (paramD.PortMapRules_0 != "") {
                    rules.push([0, paramD.PortMapRules_0]);
                }
                if (paramD.PortMapRules_1 != "") {
                    rules.push([1, paramD.PortMapRules_1]);
                }
                if (paramD.PortMapRules_2 != "") {
                    rules.push([2, paramD.PortMapRules_2]);
                }
                if (paramD.PortMapRules_3 != "") {
                    rules.push([3, paramD.PortMapRules_3]);
                }
                if (paramD.PortMapRules_4 != "") {
                    rules.push([4, paramD.PortMapRules_4]);
                }
                if (paramD.PortMapRules_5 != "") {
                    rules.push([5, paramD.PortMapRules_5]);
                }
                if (paramD.PortMapRules_6 != "") {
                    rules.push([6, paramD.PortMapRules_6]);
                }
                if (paramD.PortMapRules_7 != "") {
                    rules.push([7, paramD.PortMapRules_7]);
                }
                if (paramD.PortMapRules_8 != "") {
                    rules.push([8, paramD.PortMapRules_8]);
                }
                if (paramD.PortMapRules_9 != "") {
                    rules.push([9, paramD.PortMapRules_9]);
                }
                result.portMapRules = parsePortMapRules(rules);
                return result;
            } else {
                return errUnknownObj;
            }
        }
        function parsePortMapRules(paramD) {
            var rules = [];
            if (paramD && paramD.length > 0) {
                for (var i = 0; i < paramD.length; i++) {
                    var aRule = {};
                    var elements = paramD[i][1].split(",");
                    aRule.index = paramD[i][0];
                    aRule.sourcePort = elements[1];
                    aRule.destIpAddress = elements[0];
                    aRule.destPort = elements[2];
                    aRule.protocol = transProtocol(elements[3]);
                    aRule.comment = elements[4];
                    rules.push(aRule);
                }
            }
            return rules;
        }
    }
    function setPortMap() {
        return stuffMake(arguments, {}, prepare, deal, null, true);
        function prepare(values, isPost) {
            var valueReq = {};
            valueReq.goformId = "ADD_PORT_MAP";
            valueReq.portMapEnabled = values.portMapEnable;
            valueReq.fromPort = values.sourcePort;
            valueReq.ip_address = values.destIpAddress;
            valueReq.toPort = values.destPort;
            valueReq.protocol = values.protocol;
            valueReq.comment = values.comment;
            return valueReq;
        }
        function deal(paramD) {
            if (paramD) {
                return paramD;
            } else {
                return errUnknownObj;
            }
        }
    }
    function enablePortMap() {
        return stuffMake(arguments, {}, prepare, deal, null, true);
        function prepare(values, isPost) {
            var valueReq = {};
            valueReq.goformId = "ADD_PORT_MAP";
            valueReq.portMapEnabled = values.portMapEnable;
            return valueReq;
        }
        function deal(paramD) {
            if (paramD) {
                return paramD;
            } else {
                return errUnknownObj;
            }
        }
    }
    function deleteMapRules() {
        return stuffMake(arguments, {}, prepare, deal, null, true);
        function prepare(values, isPost) {
            var valueReq = {};
            valueReq.goformId = "DEL_PORT_MAP";
            valueReq.delete_id = values.indexs.join(';') + ";";
            return valueReq;
        }
        function deal(paramD) {
            if (paramD) {
                return paramD;
            } else {
                return errUnknownObj;
            }
        }
    }
    function getTrafficAlertInfo() {
        return stuffMake(arguments, {}, prepare, deal, null, false);
        function prepare(values, isPost) {
            return {
                cmd: "data_volume_limit_switch,data_volume_limit_unit,data_volume_limit_size,data_volume_alert_percent,monthly_tx_bytes,monthly_rx_bytes,monthly_time,traffic_alined_delta",
                multi_data: 1
            };
        }
        function deal(paramD) {
            if (paramD) {
                var isData = paramD.data_volume_limit_unit == 'data';
                var result = {
                    dataLimitChecked: paramD.data_volume_limit_switch,
                    dataLimitTypeChecked: isData ? '1' : '0',
                    limitDataMonth: isData ? paramD.data_volume_limit_size : '0',
                    alertDataReach: isData ? paramD.data_volume_alert_percent : '0',
                    limitTimeMonth: isData ? '0' : paramD.data_volume_limit_size,
                    alertTimeReach: isData ? '0' : paramD.data_volume_alert_percent,
                    monthlySent: paramD.monthly_tx_bytes == '' ? 0 : paramD.monthly_tx_bytes,
                    monthlyReceived: paramD.monthly_rx_bytes == '' ? 0 : paramD.monthly_rx_bytes,
                    monthlyConnectedTime: paramD.monthly_time == '' ? 0 : paramD.monthly_time,
                    traffic_alined_delta: paramD.traffic_alined_delta == '' ? 0 : paramD.traffic_alined_delta
                };
                return result;
            } else {
                return errUnknownObj;
            }
        }
    }
    function setTrafficAlertInfo() {
        return stuffMake(arguments, {}, prepare, deal, null, true);
        function prepare(values, isPost) {
            var isData = values.dataLimitTypeChecked == '1';
            var valueReq = {
                goformId: "DATA_LIMIT_SETTING",
                data_volume_limit_switch: values.dataLimitChecked
            };
            if (values.dataLimitChecked == '1') {
                valueReq.data_volume_limit_unit = isData ? 'data' : 'time';
                valueReq.data_volume_limit_size = isData ? values.limitDataMonth : values.limitTimeMonth;
                valueReq.data_volume_alert_percent = isData ? values.alertDataReach : values.alertTimeReach;
            }
            return valueReq;
        }
        function deal(paramD) {
            if (paramD) {
                return paramD;
            } else {
                return errUnknownObj;
            }
        }
    }
    function getUSSDResponse() {
        var callback = arguments[1];
        return stuffMake(arguments, {}, prepare, deal, null, true);
        function prepare(values, isPost) {
            if (values.sendOrReply == "send") {
                return {
                    goformId: "USSD_PROCESS",
                    USSD_operator: values.operator,
                    USSD_send_number: values.strUSSDCommand,
                    notCallback: true
                };
            } else if (values.sendOrReply == "reply") {
                return {
                    goformId: "USSD_PROCESS",
                    USSD_operator: values.operator,
                    USSD_reply_number: values.strUSSDCommand,
                    notCallback: true
                };
            }
        }
        function deal(paramD) {
            if (!paramD) {
                callback(false, "ussd_fail");
                return;
            }
            if (paramD.result == "success") {
                callbackTemp = callback;
                getResponse();
            } else {
                callback(false, "ussd_fail");
            }
        }
    }
    function getResponse() {
        $.ajax({
            url: "/reqproc/proc_get",
            data: {
                cmd: "ussd_write_flag"
            },
            cache: false,
            async: true,
            dataType: "json",
            success: function (result) {
                if (result.ussd_write_flag == "1") {
                    callbackTemp(false, "ussd_no_service");
                } else if (result.ussd_write_flag == "4" || result.ussd_write_flag == "unknown" || result.ussd_write_flag == "3") {
                    callbackTemp(false, "ussd_timeout");
                } else if (result.ussd_write_flag == "15") {
                    setTimeout(getResponse, 1000);
                } else if (result.ussd_write_flag == "10") {
                    callbackTemp(false, "ussd_retry");
                } else if (result.ussd_write_flag == "99") {
                    callbackTemp(false, "ussd_unsupport");
                } else if (result.ussd_write_flag == "41") {
                    callbackTemp(false, "operation_not_supported");
                } else if (result.ussd_write_flag == "2") {
                    callbackTemp(false, "network_terminated");
                } else if (result.ussd_write_flag == "16") {
                    $.ajax({
                        url: "/reqproc/proc_get",
                        data: {
                            cmd: "ussd_data_info"
                        },
                        dataType: "json",
                        async: true,
                        cache: false,
                        success: function (paramD) {
                            var content = {};
                            content.data = paramD.ussd_data;
                            content.ussd_action = paramD.ussd_action;
                            content.ussd_dcs = paramD.ussd_dcs;
                            callbackTemp(true, content);
                        },
                        error: function () {
                            callbackTemp(false, "ussd_info_error");
                        }
                    });
                } else {
                    callbackTemp(false, "ussd_fail");
                }
            },
            error: function () {
                callbackTemp(false, "ussd_fail");
            }
        });
    }
    function USSDReplyCancel(callback) {
        $.ajax({
            url: "/reqproc/proc_post",
            data: {
                goformId: "USSD_PROCESS",
                USSD_operator: "ussd_cancel"
            },
            cache: false,
            dataType: "json",
            success: function (paramD) {
                if (paramD.result == "success") {
                    getCancelResponse();
                } else {
                    callback(false);
                }
            }
        });
        function getCancelResponse() {
            $.ajax({
                url: "/reqproc/proc_get",
                data: {
                    cmd: "ussd_write_flag"
                },
                cache: false,
                async: true,
                dataType: "json",
                success: function (result) {
                    if (result.ussd_write_flag == "15") {
                        setTimeout(getCancelResponse, 1000);
                    } else if (result.ussd_write_flag == "13") {
                        callback(true);
                    } else {
                        callback(false);
                    }
                },
                error: function () {
                    callback(false);
                }
            });
        }
    }
    function unlockNetwork() {
        var callback = arguments[1];
        var checkPoint = 0;
        return stuffMake(arguments, {}, prepare, deal, null, true);
        function prepare(values) {
            return {
                goformId: "UNLOCK_NETWORK",
                notCallback: true,
                unlock_network_code: values.unlock_network_code
            };
        }
        function deal(paramD) {
            if (paramD && paramD.result == "success") {
                addCallback(checkUnlockNetworkStatus);
            } else {
                callback({
                    result: 'fail'
                });
            }
        }
        function checkUnlockNetworkStatus() {
            if (checkPoint > 5) {
                removeCallback(checkUnlockNetworkStatus);
                callback({
                    result: 'fail'
                });
            } else if (informationAll.simStatus != 'modem_imsi_waitnck') {
                removeCallback(checkUnlockNetworkStatus);
                callback({
                    result: 'success'
                });
            }
            checkPoint++;
        }
    }
    function getNetworkUnlockTimes() {
        return stuffMake(arguments, {}, prepare, deal, null, false);
        function prepare(values, isPost) {
            return {
                cmd: "unlock_nck_time"
            };
        }
        function deal(paramD) {
            if (paramD) {
                return paramD;
            } else {
                return errUnknownObj;
            }
        }
    }
    function setUpdateInfoWarning() {
        var callback = arguments[1];
        return stuffMake(arguments, {}, prepare, deal, null, true);
        function prepare(values) {
            return {
                goformId: "SET_UPGRADE_NOTICE",
                upgrade_notice_flag: values.upgrade_notice_flag,
                notCallback: true
            };
        }
        function deal(paramD) {
            if (paramD.result == "success") {
                callback(true);
            } else {
                callback(false);
            }
        }
    }
    function getUpdateInfoWarning() {
        return stuffMake(arguments, {}, prepare, deal, null, false);
        function prepare(values, isPost) {
            return {
                cmd: "upgrade_notice_flag"
            };
        }
        function deal(paramD) {
            if (paramD) {
                return paramD;
            } else {
                return errUnknownObj;
            }
        }
    }
    function getAPStationBasic() {
        return stuffMake(arguments, {}, prepare, deal, null, false);
        function prepare(values, isPost) {
            return {
                multi_data: 1,
                cmd: "wifi_sta_connection,pswan_priority,wifiwan_priority,ethwan_priority"
            };
        }
        function deal(paramD) {
            if (paramD) {
                return {
                    ap_station_enable: paramD.wifi_sta_connection,
                    ap_station_mode: parseInt(paramD.wifiwan_priority, 10) > parseInt(paramD.pswan_priority, 10) ? "wifi_pref" : "dial_pref"
                }
            } else {
                return errUnknownObj;
            }
        }
    }
    function setAPStationBasic() {
        var tmp = arguments[0];
        return stuffMake(arguments, {}, prepare, deal, null, true);
        function prepare(values) {
            return {
                goformId: "WIFI_STA_CONTROL",
                wifi_sta_connection: values.ap_station_enable
            };
        }
        function deal(paramD) {
            if (paramD && paramD.result == "success") {
                informationAll.ap_station_enable = tmp.ap_station_enable == 1;
                return paramD;
            } else {
                return errUnknownObj;
            }
        }
    }
    function refreshAPStationStatus() {
        return getAPStationBasic({}, function (paramD) {
            informationAll.ap_station_enable = paramD.ap_station_enable == 1;
            informationAll.ap_station_mode = paramD.ap_station_mode;
        });
    }
    function getHotspotList() {
        return stuffMake(arguments, {}, prepare, deal, null, false);
        function prepare(values, isPost) {
            var cmdStr = "wifi_profile_num,wifi_profile";
            for (var i = 1; i < config.AP_STATION_LIST_LENGTH; i++) {
                cmdStr = cmdStr + ",wifi_profile" + i;
            }
            return {
                multi_data: 1,
                cmd: cmdStr
            };
        }
        function deal(paramD) {
            if (paramD) {
                var wifiList = [];
                for (var i = 0; i < config.AP_STATION_LIST_LENGTH; i++) {
                    var wifiStr = "";
                    if (i == 0) {
                        wifiStr = paramD.wifi_profile;
                    } else {
                        wifiStr = paramD["wifi_profile" + i];
                    }
                    var wifiArray = wifiStr.split(";");
                    for (var j = 0; j < wifiArray.length; j++) {
                        var item = wifiArray[j].split(",");
                        if (!item[0]) {
                            break;
                        }
                        var wifiJson = {
                            profileName: item[0],
                            fromProvider: item[1],
                            connectStatus: item[2],
                            signal: item[3],
                            ssid: item[4],
                            authMode: item[5],
                            encryptType: item[6],
                            password: item[7] == "0" ? "" : item[7],
                            keyID: item[8],
                            mac: item[9]
                        };
                        wifiList.push(wifiJson);
                    }
                }
                return {
                    hotspotList: wifiList
                };
            } else {
                return errUnknownObj;
            }
        }
    }
    function searchHotspot() {
        return stuffMake(arguments, {}, prepare, deal, null, true);
        function prepare(values) {
            return {
                goformId: "WLAN_SET_STA_REFRESH"
            };
        }
        function deal(paramD) {
            if (paramD) {
                return paramD;
            } else {
                return errUnknownObj;
            }
        }
    }
    function getSearchHotspotList() {
        return stuffMake(arguments, {}, prepare, deal, null, false);
        function prepare(values, isPost) {
            return {
                multi_data: 1,
                cmd: "scan_finish,EX_APLIST,EX_APLIST1"
            }
        }
        function deal(paramD) {
            if (paramD) {
                if (paramD.scan_finish == "0") {
                    return {
                        scan_finish: "0",
                        hotspotList: []
                    };
                }
                if (paramD.scan_finish == "2") {
                    return {
                        scan_finish: "2",
                        hotspotList: []
                    };
                }
                var wifiList = [];
                for (var i = 0; i <= 1; i++) {
                    var wifiStr;
                    if (i == 0) {
                        wifiStr = paramD.EX_APLIST;
                    } else {
                        wifiStr = paramD.EX_APLIST1;
                    }
                    var wifiArray = wifiStr.split(";");
                    for (var j = 0; j < wifiArray.length; j++) {
                        var item = wifiArray[j].split(",");
                        if (!item[0]) {
                            break;
                        }
                        var wifiJson = {
                            fromProvider: item[0],
                            connectStatus: item[1],
                            ssid: item[2],
                            signal: item[3],
                            channel: item[4],
                            authMode: item[5],
                            encryptType: item[6],
                            mac: item[7]
                        }
                        wifiList.push(wifiJson);
                    }
                }
                return {
                    scan_finish: "1",
                    hotspotList: wifiList
                };
            } else {
                return errUnknownObj;
            }
        }
    }
    function creatHotspotString(hotspot) {
        var tmp = [];
        tmp.push(hotspot.profileName);
        tmp.push(hotspot.fromProvider || "0");
        tmp.push(hotspot.connectStatus || "0");
        tmp.push(hotspot.signal);
        tmp.push(hotspot.ssid);
        tmp.push(hotspot.authMode);
        tmp.push(hotspot.encryptType);
        tmp.push(hotspot.password || "0");
        tmp.push(hotspot.keyID);
        tmp.push(hotspot.mac);
        return tmp.join(",");
    }
    function saveHotspot() {
        return stuffMake(arguments, {}, prepare, deal, null, true);
        function prepare(values) {
            var apList = values.apList;
            var action = "modify";
            if (values.profileName == "") {
                action = "add";
                var newName = (jQuery.fn.jquery + Math.random()).replace(/\D/g, "");
                values.profileName = newName;
                apList.push({
                    profileName: newName,
                    fromProvider: "0",
                    connectStatus: "0",
                    signal: values.signal,
                    ssid: values.ssid,
                    authMode: values.authMode,
                    encryptType: values.encryptType,
                    password: values.password || "0",
                    keyID: values.keyID,
                    mac: values.mac
                });
            }
            var wifi = {
                "profile0": []
            };
            for (var i = 1; i < config.AP_STATION_LIST_LENGTH; i++) {
                wifi["profile" + i] = [];
            }
            var activeHotspotStr = "";
            for (var i = 0; i < apList.length; i++) {
                var hotspotStr = "";
                if (values.profileName == apList[i].profileName) {
                    hotspotStr = creatHotspotString(values);
                    activeHotspotStr = hotspotStr;
                } else {
                    hotspotStr = creatHotspotString(apList[i]);
                }
                var index = parseInt(i % 10);
                wifi["profile" + index].push(hotspotStr);
            }
            var profileParams = {
                wifi_profile: wifi.profile0.join(";")
            };
            for (var i = 1; i < config.AP_STATION_LIST_LENGTH; i++) {
                profileParams["wifi_profile" + i] = wifi["profile" + i].join(";");
            }
            var valueReq = $.extend({
                goformId: "WIFI_SPOT_PROFILE_UPDATE",
                wifi_profile_num: apList.length,
                wifi_update_profile: activeHotspotStr,
                action: action
            }, profileParams);
            return valueReq;
        }
        function deal(paramD) {
            if (paramD) {
                return paramD;
            } else {
                return errUnknownObj;
            }
        }
    }
    function deleteHotspot() {
        return stuffMake(arguments, {}, prepare, deal, null, true);
        function prepare(values) {
            var apList = values.apList;
            var wifi = {
                "profile0": []
            };
            for (var i = 1; i < config.AP_STATION_LIST_LENGTH; i++) {
                wifi["profile" + i] = [];
            }
            var foundDelete = false;
            var activeHotspotStr = "";
            for (var i = 0; i < apList.length; i++) {
                var hotspotStr = creatHotspotString(apList[i]);
                if (apList[i].profileName == values.profileName) {
                    foundDelete = true;
                    activeHotspotStr = hotspotStr;
                    continue;
                }
                var idIndex = i;
                if (foundDelete) {
                    idIndex = i - 1;
                }
                var index = parseInt(idIndex % 10);
                wifi["profile" + index].push(hotspotStr);
            }
            var num = foundDelete ? apList.length - 1 : apList.length;
            var profileParams = {
                wifi_profile: wifi.profile0.join(";")
            };
            for (var i = 1; i < config.AP_STATION_LIST_LENGTH; i++) {
                profileParams["wifi_profile" + i] = wifi["profile" + i].join(";");
            }
            var valueReq = $.extend({
                goformId: "WIFI_SPOT_PROFILE_UPDATE",
                wifi_profile_num: num,
                wifi_update_profile: activeHotspotStr,
                action: "delete"
            }, profileParams);
            return valueReq;
        }
        function deal(paramD) {
            if (paramD) {
                return paramD;
            } else {
                return errUnknownObj;
            }
        }
    }
    function connectHotspot() {
        return stuffMake(arguments, {}, prepare, deal, null, true);
        function prepare(values) {
            return {
                goformId: "WLAN_SET_STA_CON",
                EX_SSID1: values.EX_SSID1,
                EX_AuthMode: values.EX_AuthMode,
                EX_EncrypType: values.EX_EncrypType,
                EX_DefaultKeyID: values.EX_DefaultKeyID,
                EX_WEPKEY: values.EX_WEPKEY,
                EX_WPAPSK1: values.EX_WPAPSK1,
                EX_wifi_profile: values.EX_wifi_profile,
                EX_mac: values.EX_mac
            };
        }
        function deal(paramD) {
            if (paramD && (paramD.result == "success" || paramD.result == "processing")) {
                return paramD;
            } else {
                return errUnknownObj;
            }
        }
    }
    function disconnectHotspot() {
        return stuffMake(arguments, {}, prepare, deal, null, true);
        function prepare(values) {
            return {
                goformId: "WLAN_SET_STA_DISCON"
            };
        }
        function deal(paramD) {
            if (paramD && paramD.result == "success") {
                return paramD;
            } else {
                return errUnknownObj;
            }
        }
    }
    function getOpMode() {
        return stuffMake(arguments, {}, prepare, deal, null, false);
        function prepare(values, isPost) {
            return {
                multi_data: 1,
                cmd: "blc_wan_mode,blc_wan_auto_mode,loginfo,ppp_status,rj45_state,ethwan_mode"
            };
        }
        function deal(paramD) {
            if (paramD) {
                var result = {};
                if (paramD.blc_wan_mode == 'AUTO') {
                    result.blc_wan_mode = paramD.blc_wan_auto_mode ? paramD.blc_wan_auto_mode : 'AUTO_PPP';
                } else {
                    result.blc_wan_mode = paramD.blc_wan_mode ? paramD.blc_wan_mode : 'PPP';
                }
                result.loginfo = paramD.loginfo;
                result.ppp_status = paramD.ppp_status;
                result.rj45_state = (typeof paramD.rj45_state == 'undefined' || paramD.rj45_state == '') ? 'dead' : paramD.rj45_state;
                result.ethwan_mode = paramD.ethwan_mode.toUpperCase();
                return result;
            } else {
                return errUnknownObj;
            }
        }
    }
    function getRj45PlugState() {
        return stuffMake(arguments, {}, prepare, deal, null, false);
        function prepare(values, isPost) {
            return {
                cmd: "rj45_plug"
            };
        }
        function deal(paramD) {
            if (paramD) {
                var result = {};
                result.rj45_plug = paramD.rj45_plug == "" ? "wan_lan_off" : paramD.rj45_plug;
                return result;
            } else {
                return errUnknownObj;
            }
        }
    }
    function checkOpMode(opmode, rj45state) {
        if (config.RJ45_SUPPORT) {
            if (rj45state == "dead" || rj45state == "") {
                return 'PPP';
            } else if (!opmode || opmode == "undefined") {
                if (rj45state == "working") {
                    return 'PPPOE';
                } else {
                    return 'PPP';
                }
            } else {
                return opmode;
            }
        } else {
            return 'PPP';
        }
    }
    function SetOperationMode(values, callback) {
        return stuffMake(arguments, {}, prepare, deal, null, true);
        function prepare(values) {
            var valueReq = $.extend({
                goformId: "OPERATION_MODE"
            }, values);
            return valueReq;
        }
        function deal(paramD) {
            if (paramD && paramD.result == "success") {
                return paramD;
            } else {
                return errUnknownObj;
            }
        }
    }
    function getPppoeParams() {
        return stuffMake(arguments, {}, prepare, deal, null, false);
        function prepare(values, isPost) {
            return {
                multi_data: 1,
                cmd: "opms_wan_auto_mode,ethwan_mode,pppoe_username,pppoe_cc,ethwan_dialmode,ppp_status,static_wan_ipaddr,static_wan_netmask,static_wan_gateway,static_wan_primary_dns,static_wan_secondary_dns,rj45_state,lan_ipaddr,lan_netmask"
            };
        }
        function deal(paramD) {
            if (paramD) {
                return {
                    opms_wan_auto_mode: paramD.opms_wan_auto_mode,
                    ethwan_mode: paramD.ethwan_mode.toUpperCase(),
                    pppoe_username: paramD.pppoe_username,
                    pppoe_cc: paramD.pppoe_cc,
                    ethwan_dialmode: paramD.ethwan_dialmode == "manual" ? "manual_dial" : "auto_dial",
                    ppp_status: paramD.ppp_status,
                    static_wan_ipaddr: paramD.static_wan_ipaddr,
                    static_wan_netmask: paramD.static_wan_netmask,
                    static_wan_gateway: paramD.static_wan_gateway,
                    static_wan_primary_dns: paramD.static_wan_primary_dns,
                    static_wan_secondary_dns: paramD.static_wan_secondary_dns,
                    rj45_state: (typeof paramD.rj45_state == 'undefined' || paramD.rj45_state == '') ? 'dead' : paramD.rj45_state,
                    lan_ipaddr: paramD.lan_ipaddr,
                    lan_netmask: paramD.lan_netmask
                }
            } else {
                return errUnknownObj;
            }
        }
    }
    function setPppoeDialMode(values, callback) {
        return stuffMake(arguments, {}, prepare, deal, null, true);
        function prepare(values) {
            var valueReq = $.extend({
                notCallback: true
            }, values);
            return valueReq;
        }
        function deal(paramD) {
            if (paramD.result == "success") {
                callback({
                    result: true
                });
            } else {
                callback({
                    result: false
                });
            }
        }
    }
    function getSntpParams(values, callback) {
        return stuffMake(arguments, {}, prepare, deal, null, false);
        function prepare(values, isPost) {
            return {
                multi_data: 1,
                cmd: "sntp_year,sntp_month,sntp_day,sntp_hour,sntp_minute,sntp_second,sntp_time_set_mode,sntp_static_server0,sntp_static_server1,sntp_static_server2,sntp_server0,sntp_server1,sntp_server2,sntp_server3,sntp_server4,sntp_server5,sntp_server6,sntp_server7,sntp_server8,sntp_server9,sntp_other_server0,sntp_other_server1,sntp_other_server2,sntp_timezone,sntp_timezone_index,sntp_dst_enable,ppp_status,sntp_process_result,rj45_state"
            };
        }
        function deal(paramD) {
            if (paramD) {
                var sntp_servers = getSntpServers(paramD);
                return {
                    sntp_year: paramD.sntp_year,
                    sntp_month: paramD.sntp_month,
                    sntp_day: paramD.sntp_day,
                    sntp_hour: paramD.sntp_hour,
                    sntp_minute: paramD.sntp_minute,
                    sntp_second: paramD.sntp_second,
                    sntp_time_set_mode: paramD.sntp_time_set_mode,
                    sntp_servers: sntp_servers,
                    sntp_server0: paramD.sntp_server0,
                    sntp_server1: paramD.sntp_server1,
                    sntp_server2: paramD.sntp_server2,
                    sntp_static_server0: paramD.sntp_static_server0,
                    sntp_static_server1: paramD.sntp_static_server1,
                    sntp_static_server2: paramD.sntp_static_server2,
                    sntp_other_server0: paramD.sntp_other_server0,
                    sntp_other_server1: paramD.sntp_other_server1,
                    sntp_other_server2: paramD.sntp_other_server2,
                    sntp_timezone: paramD.sntp_timezone,
                    sntp_timezone_index: paramD.sntp_timezone_index ? paramD.sntp_timezone_index : "0",
                    sntp_dst_enable: paramD.sntp_dst_enable,
                    ppp_status: paramD.ppp_status,
                    blc_wan_mode: informationAll.blc_wan_mode,
                    sntp_process_result: paramD.sntp_process_result,
                    rj45_state: (typeof paramD.rj45_state == 'undefined' || paramD.rj45_state == '') ? 'dead' : paramD.rj45_state
                }
            } else {
                return errUnknownObj;
            }
        }
        function getSntpServers(paramD) {
            var serverArray = [];
            for (var i = 0; i < 3; i++) {
                var tmp = "sntp_static_server" + (i).toString();
                if (paramD[tmp] != "") {
                    var obj = {};
                    obj.name = paramD[tmp];
                    obj.value = paramD[tmp];
                    serverArray.push(obj);
                }
            }
            var otherArray = [{
                    name: "Other",
                    value: "Other"
                }, {
                    name: "NONE",
                    value: ""
                }
            ];
            for (var j = 0; j < 2; j++) {
                serverArray.push(otherArray[j]);
            }
            return serverArray;
        }
    }
    function setSNTPDate(values, callback) {
        return stuffMake(arguments, {}, prepare, deal, null, true);
        function prepare(values) {
            var valueReq = $.extend({}, values);
            return valueReq;
        }
        function deal(paramD) {
            if (paramD && paramD.result == "success") {
                return paramD;
            } else {
                return errUnknownObj;
            }
        }
    }
    function setSntpSetting(values, callback) {
        var valueReq = $.extend({}, values); {
            $.post("reqproc/proc_post", valueReq, function (paramD) {
                if (paramD && paramD.result == "success") {
                    if (values.manualsettime == "auto") {
                        setTimeout(checkSyncStatus, 2000);
                        callback(paramD);
                    } else {
                        callback(true);
                    }
                } else if (paramD && paramD.result == "processing") {
                    callback(paramD);
                } else {
                    callback(false);
                }
            }, "json");
        }
        function checkSyncStatus() {
            $.ajax({
                url: "reqproc/proc_get",
                dataType: "json",
                data: {
                    cmd: "sntp_process_result"
                },
                cache: false,
                async: false,
                success: function (paramD) {
                    if (paramD.sntp_process_result == "failure") {
                        callback(false);
                    } else if (paramD.sntp_process_result == "success") {
                        callback(true);
                    } else {
                        setTimeout(checkSyncStatus, 2000);
                    }
                },
                error: function () {
                    callback(false);
                }
            });
        }
    }
    function addUrlFilterRule(values, callback) {
        return stuffMake(arguments, {}, prepare, deal, null, true);
        function prepare(values) {
            var valueReq = $.extend({}, values);
            return valueReq;
        }
        function deal(paramD) {
            if (paramD && paramD.result == "success") {
                return paramD;
            } else {
                return errUnknownObj;
            }
        }
    }
    function getUrlFilterList() {
        return stuffMake(arguments, {}, prepare, deal, null, false);
        function prepare(values, isPost) {
            return {
                cmd: "websURLFilters"
            };
        }
        function deal(paramD) {
            var urlFilterRules = [];
            if (paramD) {
                if (paramD.websURLFilters.length == 0) {
                    return {
                        urlFilterRules: []
                    };
                } else {
                    var tempArray = paramD.websURLFilters.split(";");
                    for (var i = 0; i < tempArray.length; i++) {
                        var aRule = {};
                        aRule.index = i;
                        aRule.url = tempArray[i];
                        urlFilterRules.push(aRule);
                    }
                    return {
                        urlFilterRules: urlFilterRules
                    };
                }
            } else {
                return errUnknownObj;
            }
        }
    }
    function deleteSelectedRules(values, callback) {
        return stuffMake(arguments, {}, prepare, deal, null, true);
        function prepare(values) {
            var valueReq = $.extend({}, values);
            return valueReq;
        }
        function deal(paramD) {
            if (paramD && paramD.result == "success") {
                return paramD;
            } else {
                return errUnknownObj;
            }
        }
    }
    function getWdsInfo() {
        return stuffMake(arguments, {}, prepare, deal, null, false);
        function prepare(values, isPost) {
            return {
                multi_data: "1",
                cmd: "wifi_wds_mode,wifi_wds_ssid,wifi_wds_AuthMode,wifi_wds_EncrypType,wifi_wds_WPAPSK1,wifi_cur_state "
            };
        }
        function deal(paramD) {
            if (paramD) {
                return {
                    currentMode: paramD.wifi_wds_mode,
                    wdsSSID: paramD.wifi_wds_ssid,
                    wdsAuthMode: paramD.wifi_wds_AuthMode,
                    wdsEncrypType: paramD.wifi_wds_EncrypType,
                    wdsWPAPSK1: paramD.wifi_wds_WPAPSK1,
                    RadioOff: paramD.wifi_cur_state == "1" ? "1" : "0"
                };
            } else {
                return errUnknownObj;
            }
        }
    }
    function setWDS(values, callback) {
        return stuffMake(arguments, {}, prepare, deal, null, true);
        function prepare(values) {
            var valueReq = $.extend({}, values);
            return valueReq;
        }
        function deal(paramD) {
            if (paramD && paramD.result == "success") {
                return paramD;
            } else {
                return errUnknownObj;
            }
        }
    }
    function getSyslogInfo() {
        return stuffMake(arguments, {}, prepare, deal, null, false);
        function prepare(values, isPost) {
            return {
                multi_data: "1",
                cmd: "syslog_mode,debug_level"
            };
        }
        function deal(paramD) {
            if (paramD) {
                return {
                    currentMode: paramD.syslog_mode,
                    debugLevel: paramD.debug_level
                };
            } else {
                return errUnknownObj;
            }
        }
    }
    function setSysLog(values, callback) {
        return stuffMake(arguments, {}, prepare, deal, null, true);
        function prepare(values) {
            var valueReq = $.extend({}, values);
            return valueReq;
        }
        function deal(paramD) {
            if (paramD && paramD.result == "success") {
                return paramD;
            } else {
                return errUnknownObj;
            }
        }
    }
    function getMacFilterInfo() {
        return stuffMake(arguments, {}, prepare, deal, null, false);
        function prepare(values, isPost) {
            return {
                multi_data: "1",
                cmd: "ACL_mode,wifi_mac_black_list,wifi_hostname_black_list,wifi_cur_state,user_ip_addr,client_mac_address,wifi_mac_white_list"
            };
        }
        function deal(paramD) {
            if (paramD) {
                return {
                    ACL_mode: paramD.ACL_mode,
                    wifi_mac_black_list: paramD.wifi_mac_black_list,
                    wifi_hostname_black_list: paramD.wifi_hostname_black_list,
                    RadioOff: paramD.wifi_cur_state == "1" ? "1" : "0",
                    user_ip_addr: paramD.user_ip_addr,
                    client_mac_address: paramD.client_mac_address,
                    wifi_mac_white_list: paramD.wifi_mac_white_list
                };
            } else {
                return errUnknownObj;
            }
        }
    }
    function setMacFilter() {
        return stuffMake(arguments, {}, prepare, deal, null, true);
        function prepare(values) {
            var valueReq = $.extend({
                goformId: 'WIFI_MAC_FILTER',
            }, values);
            return valueReq;
        }
        function deal(paramD) {
            if (paramD && paramD.result == "success") {
                return paramD;
            } else {
                return errUnknownObj;
            }
        }
    }
    function getFastbootSetting() {
        return stuffMake(arguments, {}, prepare, deal, null, false);
        function prepare(values) {
            return {
                cmd: "mgmt_quicken_power_on,need_hard_reboot,need_sim_pin",
                multi_data: 1
            };
        }
        function deal(paramD) {
            return {
                fastbootEnabled: paramD.mgmt_quicken_power_on == '1' ? '1' : '0',
                need_hard_reboot: paramD.need_hard_reboot,
                need_sim_pin: paramD.need_sim_pin == 'yes' ? 'yes' : 'no'
            };
        }
    }
    function setFastbootSetting() {
        return stuffMake(arguments, {}, prepare, deal, null, true);
        function prepare(values) {
            return {
                goformId: "MGMT_CONTROL_POWER_ON_SPEED",
                mgmt_quicken_power_on: values.fastbootEnabled
            };
        }
        function deal(paramD) {
            if (paramD && paramD.result == "success") {
                return paramD;
            } else {
                return errUnknownObj;
            }
        }
    }
    function turnOffDevice() {
        return stuffMake(arguments, {}, prepare, deal, null, true);
        function prepare(values, isPost) {
            var valueReq = {};
            valueReq.goformId = "TURN_OFF_DEVICE";
            return valueReq;
        }
        function deal(paramD) {
            if (paramD) {
                return paramD;
            } else {
                return errUnknownObj;
            }
        }
    }
    function restart() {
        return stuffMake(arguments, {}, prepare, deal, null, true);
        function prepare(values, isPost) {
            var valueReq = {};
            valueReq.goformId = "REBOOT_DEVICE";
            return valueReq;
        }
        function deal(paramD) {
            if (paramD) {
                return paramD;
            } else {
                return errUnknownObj;
            }
        }
    }
    function getNewVersionState() {
        return stuffMake(arguments, {}, prepare, deal, null, false);
        function prepare(values, isPost) {
            var valueReq = {};
            valueReq.cmd = "fota_new_version_state,fota_current_upgrade_state,fota_package_already_download";
            valueReq.multi_data = 1;
            return valueReq;
        }
        function deal(paramD) {
            if (paramD) {
                var hasNewVersion = (paramD.fota_new_version_state == 'has_critical' || paramD.fota_new_version_state == 'has_optional' || paramD.fota_new_version_state == 'already_has_pkg');
                paramD.hasNewVersion = hasNewVersion;
                return paramD;
            } else {
                return errUnknownObj;
            }
        }
    }
    function getMandatory() {
        return stuffMake(arguments, {}, prepare, deal, null, false);
        function prepare(values, isPost) {
            var valueReq = {};
            if (config.UPGRADE_TYPE == "OTA") {
                valueReq.cmd = "is_mandatory";
            } else {
                valueReq.cmd = "fota_new_version_state";
            }
            return valueReq;
        }
        function deal(paramD) {
            if (paramD) {
                if (config.UPGRADE_TYPE == "OTA") {
                    return {
                        "is_mandatory": paramD.is_mandatory == "1"
                    };
                } else {
                    return {
                        "is_mandatory": paramD.fota_new_version_state == "has_critical"
                    };
                }
            } else {
                return errUnknownObj;
            }
        }
    }
    function getUpgradeResult() {
        return stuffMake(arguments, {}, prepare, deal, null, false);
        function prepare(values, isPost) {
            var valueReq = {};
            valueReq.cmd = "upgrade_result";
            return valueReq;
        }
        function deal(paramD) {
            if (paramD) {
                return paramD;
            } else {
                return errUnknownObj;
            }
        }
    }
    function getCurrentUpgradeState() {
        return stuffMake(arguments, {}, prepare, deal, null, false);
        function prepare(values, isPost) {
            var valueReq = {};
            valueReq.cmd = "fota_current_upgrade_state";
            return valueReq;
        }
        function deal(paramD) {
            if (paramD) {
                paramD.current_upgrade_state = paramD.fota_current_upgrade_state;
                return paramD;
            } else {
                return errUnknownObj;
            }
        }
    }
    function getPackSizeInfo() {
        return stuffMake(arguments, {}, prepare, deal, null, false);
        function prepare(values, isPost) {
            var valueReq = {};
            valueReq.cmd = "fota_pkg_total_size,fota_dl_pkg_size";
            valueReq.multi_data = 1;
            return valueReq;
        }
        function deal(paramD) {
            if (paramD) {
                return paramD;
            } else {
                return errUnknownObj;
            }
        }
    }
    function setUpgradeSelectOp() {
        return stuffMake(arguments, {}, prepare, deal, null, true);
        function prepare(values, isPost) {
            var valueReq = {};
            valueReq.goformId = "IF_UPGRADE";
            valueReq.select_op = values.selectOp;
            if (valueReq.select_op == 'check') {
                valueReq.ota_manual_check_roam_state = 1;
            }
            return valueReq;
        }
        function deal(paramD) {
            if (paramD) {
                return paramD;
            } else {
                return errUnknownObj;
            }
        }
    }
    function getOTAUpdateSetting() {
        return stuffMake(arguments, {}, prepare, deal, null, false);
        function prepare(values, isPost) {
            var valueReq = {};
            valueReq.cmd = "fota_updateMode,fota_updateIntervalDay,fota_allowRoamingUpdate";
            valueReq.multi_data = 1;
            return valueReq;
        }
        function deal(paramD) {
            if (paramD) {
                return {
                    updateMode: paramD.fota_updateMode,
                    updateIntervalDay: paramD.fota_updateIntervalDay,
                    allowRoamingUpdate: paramD.fota_allowRoamingUpdate
                };
            } else {
                return errUnknownObj;
            }
        }
    }
    function setOTAUpdateSetting() {
        return stuffMake(arguments, {}, prepare, deal, null, true);
        function prepare(values, isPost) {
            var valueReq = {};
            valueReq.goformId = "SetUpgAutoSetting";
            valueReq.UpgMode = values.updateMode;
            valueReq.UpgIntervalDay = values.updateIntervalDay;
            valueReq.UpgRoamPermission = values.allowRoamingUpdate;
            return valueReq;
        }
        function deal(paramD) {
            if (paramD && paramD.result == "success") {
                return paramD;
            } else {
                return errUnknownObj;
            }
        }
    }
    function getOTAlastCheckTime() {
        return getParams({
            nv: ['dm_last_check_time']
        }, arguments[1], arguments[2]);
    }
    function getSignalStrength() {
        return getParams({
            nv: ['network_type', 'sub_network_type', 'rssi', 'rscp', 'lte_rsrp']
        }, arguments[1], arguments[2]);
    }
    function clearUpdateResult() {
        return stuffMake(arguments, {}, prepare, deal, null, true);
        function prepare(values, isPost) {
            var valueReq = {};
            valueReq.goformId = "RESULT_RESTORE";
            return valueReq;
        }
        function deal(paramD) {
            if (paramD && paramD.result == "success") {
                return paramD;
            } else {
                return errUnknownObj;
            }
        }
    }
    function childGroupList() {
        return stuffMake(arguments, {}, prepare, deal, null, false);
        function prepare(values, isPost) {
            var valueReq = {
                cmd: "childGroupList"
            };
            return valueReq;
        }
        function deal(paramD) {
            if (paramD && (paramD.childGroupList || paramD.devices)) {
                return paramD;
            } else {
                return {
                    devices: []
                };
            }
        }
    }
    function addChildGroup() {
        return stuffMake(arguments, config.currentUserInChildGroup == false ? {}
             : {
            errorType: 'no_auth'
        }, prepare, deal, null, true);
        function prepare(values, isPost) {
            var valueReq = {
                goformId: "ADD_DEVICE",
                mac: values.macAddress
            };
            return valueReq;
        }
        function deal(paramD) {
            if (paramD && paramD.result == 'success') {
                return paramD;
            } else {
                return errUnknownObj;
            }
        }
    }
    function removeChildGroup() {
        return stuffMake(arguments, config.currentUserInChildGroup == false ? {}
             : {
            errorType: 'no_auth'
        }, prepare, deal, null, true);
        function prepare(values, isPost) {
            var valueReq = {
                goformId: "DEL_DEVICE",
                mac: values.mac
            };
            return valueReq;
        }
        function deal(paramD) {
            if (paramD && paramD.result == 'success') {
                return paramD;
            } else {
                return errUnknownObj;
            }
        }
    }
    function checkCurrentUserInChildGroup(devices) {
        if (typeof config.currentUserInChildGroup == "undefined") {
            var childGroupDevice = [];
            if (typeof devices != "undefined") {
                childGroupDevice = devices;
            } else {
                childGroupDevice = childGroupList({}).devices;
            }
            var userMacAddr = getUserMacAddr({}).get_user_mac_addr;
            var found = _.find(childGroupDevice, function (item) {
                return item.mac == userMacAddr;
            });
            config.currentUserInChildGroup = typeof found != 'undefined';
            return {
                result: typeof found != 'undefined'
            };
        }
        return {
            result: config.currentUserInChildGroup
        };
    }
    function getUserMacAddr() {
        return getParams({
            nv: 'get_user_mac_addr'
        }, arguments[1], arguments[2]);
    }
    function getHostNameList() {
        return stuffMake(arguments, {}, prepare, deal, null, false);
        function prepare(values, isPost) {
            var valueReq = {
                cmd: "hostNameList"
            };
            return valueReq;
        }
        function deal(paramD) {
            if (paramD && (paramD.hostNameList || paramD.devices)) {
                return paramD;
            } else {
                return {
                    devices: []
                };
            }
        }
    }
    function editHostName() {
        return stuffMake(arguments, {}, prepare, deal, null, true);
        function prepare(values, isPost) {
            var valueReq = {
                goformId: "EDIT_HOSTNAME",
                mac: values.mac,
                hostname: values.hostname
            };
            return valueReq;
        }
        function deal(paramD) {
            if (paramD && paramD.result == 'success') {
                return paramD;
            } else {
                return errUnknownObj;
            }
        }
    }
    function getSiteWhiteList() {
        return stuffMake(arguments, {}, prepare, deal, null, false);
        function prepare(values, isPost) {
            var valueReq = {
                cmd: "site_white_list"
            };
            return valueReq;
        }
        function deal(paramD) {
            if (paramD && (paramD.site_white_list || paramD.siteList)) {
                return paramD;
            } else {
                return {
                    siteList: []
                };
            }
        }
    }
    function removeSiteWhite() {
        return stuffMake(arguments, config.currentUserInChildGroup == false ? {}
             : {
            errorType: 'no_auth'
        }, prepare, deal, null, true);
        function prepare(values, isPost) {
            var valueReq = {
                goformId: "REMOVE_WHITE_SITE",
                ids: values.ids.join(',')
            };
            return valueReq;
        }
        function deal(paramD) {
            if (paramD && paramD.result == 'success') {
                return paramD;
            } else {
                return errUnknownObj;
            }
        }
    }
    function saveSiteWhite() {
        return stuffMake(arguments, config.currentUserInChildGroup == false ? {}
             : {
            errorType: 'no_auth'
        }, prepare, deal, null, true);
        function prepare(values, isPost) {
            var valueReq = {
                goformId: "ADD_WHITE_SITE",
                name: values.name,
                site: values.site
            };
            return valueReq;
        }
        function deal(paramD) {
            if (paramD && paramD.result == 'success') {
                return paramD;
            } else {
                return errUnknownObj;
            }
        }
    }
    function getTimeLimited() {
        var defaultResult = {
            '0': [],
            '1': [],
            '2': [],
            '3': [],
            '4': [],
            '5': [],
            '6': []
        };
        return stuffMake(arguments, {}, prepare, deal, null, false);
        function prepare(values, isPost) {
            var valueReq = {
                cmd: "time_limited"
            };
            return valueReq;
        }
        function deal(paramD) {
            if (paramD) {
                return parseTimeLimited(paramD);
            } else {
                return defaultResult;
            }
        }
        function parseTimeLimited(paramD) {
            if (paramD.time_limited == '') {
                return {
                    time_limited: []
                };
            }
            var weeks = paramD.time_limited.split(';');
            _.each(weeks, function (week) {
                var weekTime = week.split('+');
                if (weekTime.length == 2) {
                    defaultResult[weekTime[0]] = weekTime[1].split(',');
                }
            });
            return defaultResult;
        }
    }
    function saveTimeLimited() {
        return stuffMake(arguments, config.currentUserInChildGroup == false ? {}
             : {
            errorType: 'no_auth'
        }, prepare, deal, null, true);
        function prepare(values, isPost) {
            var valueReq = {
                goformId: "SAVE_TIME_LIMITED",
                time_limited: values.time
            };
            return valueReq;
        }
        function deal(paramD) {
            if (paramD && paramD.result == 'success') {
                return paramD;
            } else {
                return errUnknownObj;
            }
        }
    }
    function getTsw() {
        return stuffMake(arguments, {}, prepare, deal, null, false);
        function prepare(values, isPost) {
            var valueReq = {
                cmd: "openEnable,closeEnable,openTime,closeTime",
                multi_data: '1'
            };
            return valueReq;
        }
        function deal(paramD) {
            if (paramD) {
                if (paramD.openTime.indexOf(':') != -1) {
                    var open = paramD.openTime.split(':');
                    paramD.openH = leftInsert(open[0], 2, '0');
                    paramD.openM = leftInsert(open[1], 2, '0');
                } else {
                    paramD.openH = '06';
                    paramD.openM = '00';
                }
                if (paramD.closeTime.indexOf(':') != -1) {
                    var close = paramD.closeTime.split(':');
                    paramD.closeH = leftInsert(close[0], 2, '0');
                    paramD.closeM = leftInsert(close[1], 2, '0');
                } else {
                    paramD.closeH = '22';
                    paramD.closeM = '00';
                }
                return paramD;
            } else {
                return errUnknownObj;
            }
        }
    }
    function saveTsw() {
        return stuffMake(arguments, {}, prepare, deal, null, true);
        function prepare(values, isPost) {
            var valueReq = {
                goformId: "SAVE_TSW",
                openEnable: values.openEnable,
                closeEnable: values.closeEnable
            };
            if (values.openEnable == '1') {
                valueReq.openTime = values.openTime;
                valueReq.closeTime = values.closeTime;
            }
            return valueReq;
        }
        function deal(paramD) {
            if (paramD && paramD.result == 'success') {
                return paramD;
            } else if (paramD && paramD.result == 'failure') {
                return paramD;
            } else {
                return errUnknownObj;
            }
        }
    }
    function trafficCalibration() {
        return stuffMake(arguments, {}, prepare, deal, null, true);
        function prepare(values, isPost) {
            var valueReq = {
                goformId: "FLOW_CALIBRATION_MANUAL",
                calibration_way: values.way,
                time: values.way == 'time' ? values.value : 0,
                data: values.way == 'data' ? values.value : 0
            };
            return valueReq;
        }
        function deal(paramD) {
            if (paramD && paramD.result == 'success') {
                return paramD;
            } else {
                return errUnknownObj;
            }
        }
    }
    function getParams() {
        return stuffMake(arguments, {}, prepare, deal, null, false);
        function prepare(values, isPost) {
            var valueReq = {};
            if (_.isArray(values.nv)) {
                valueReq.cmd = values.nv.join(',');
                valueReq.multi_data = 1;
            } else {
                valueReq.cmd = values.nv;
            }
            return valueReq;
        }
        function deal(paramD) {
            if (paramD) {
                return paramD;
            } else {
                return errUnknownObj;
            }
        }
    }
    function getRedirectData() {
        return stuffMake(arguments, {}, prepare, deal, null, false);
        function prepare(values, isPost) {
            var valueReq = {};
            valueReq.cmd = "vwim_mc_state,traffic_overrun,detect_new_version";
            valueReq.multi_data = 1;
            return valueReq;
        }
        function deal(paramD) {
            if (paramD) {
                var result = {};
                result.vwim_mc_state = paramD.vwim_mc_state;
                result.traffic_overrun = paramD.traffic_overrun;
                result.detect_new_version = paramD.detect_new_version;
                result.blc_wan_mode = informationAll.blc_wan_mode;
                return result;
            } else {
                return errUnknownObj;
            }
        }
    }
    function clearRedirectFlag() {
        return stuffMake(arguments, {}, prepare, deal, null, true);
        function prepare(values, isPost) {
            var valueReq = {};
            valueReq.goformId = "CLEAR_REDIRECT_FLAG";
            valueReq.flag_id = values.redirectFlags;
            return valueReq;
        }
        function deal(paramD) {
            if (paramD) {
                return paramD;
            } else {
                return errUnknownObj;
            }
        }
    }
    function getV4Switch() {
        return stuffMake(arguments, {}, prepare, deal, null, false);
        function prepare(values, isPost) {
            var valueReq = {};
            valueReq.cmd = "lock_zone_enable,pin_interlock_and_V4_lock";
            valueReq.multi_data = 1;
            return valueReq;
        }
        function deal(paramD) {
            if (paramD) {
                return paramD;
            } else {
                return errUnknownObj;
            }
        }
    }
    function setV4Switch() {
        return stuffMake(arguments, {}, prepare, deal, null, true);
        function prepare(values, isPost) {
            var valueReq = {};
            valueReq.goformId = "PIN_LOCK_V4_ENCODE";
            valueReq.pin_interlock_and_V4_lock = values.pin_interlock_and_V4_lock;
            valueReq.TspLock_key_data = values.TspLock_key_data;
            return valueReq;
        }
        function deal(paramD) {
            if (paramD && paramD.result == "success") {
                return paramD;
            } else {
                return errUnknownObj;
            }
        }
    }
    function getCellId() {
        return stuffMake(arguments, {}, prepare, deal, null, false);
        function prepare(values, isPost) {
            var valueReq = {};
            valueReq.cmd = "cell_id_list,global_cell_id,network_type,sub_network_type,cell_not_correct";
            valueReq.multi_data = 1;
            return valueReq;
        }
        function deal(paramD) {
            if (paramD) {
                return paramD;
            } else {
                return errUnknownObj;
            }
        }
    }
    function setCellIdSwitch() {
        return stuffMake(arguments, {}, prepare, deal, null, true);
        function prepare(values, isPost) {
            var valueReq = {};
            valueReq.goformId = "LOCK_ZONE";
            valueReq.lock_zone_enable = values.lock_zone_enable;
            return valueReq;
        }
        function deal(paramD) {
            if (paramD && paramD.result == "success") {
                return paramD;
            } else {
                return errUnknownObj;
            }
        }
    }
    function getUpdateType() {
        return stuffMake(arguments, {}, prepare, deal, null, false);
        function prepare(values, isPost) {
            var valueReq = {
                cmd: "update_type"
            };
            return valueReq;
        }
        function deal(paramD) {
            return {
                update_type: paramD.update_type ? paramD.update_type : "mifi_fota"
            }
        }
    }
    function getSecurityInfo() {
        return stuffMake(arguments, {}, prepare, deal, null, false);
        function prepare(values, isPost) {
            var valueReq = {};
            valueReq.cmd = "AuthMode,passPhrase";
            valueReq.multi_data = 1;
            return valueReq;
        }
        function deal(paramD) {
            if (paramD) {
                var result = {};
                result.AuthMode = paramD.AuthMode;
                result.passPhrase = config.PASSWORD_ENCODE ? Base64.decode(paramD.passPhrase) : paramD.passPhrase;
                return result;
            } else {
                return errUnknownObj;
            }
        }
    }
    //can delete
    function setSecurityInfo() {
        return stuffMake(arguments, {}, prepare, deal, null, true);
        function prepare(values, isPost) {
            var valueReq = {};
            valueReq.goformId = "SET_WIFI_SECURITY_INFO";
            valueReq.AuthMode = values.AuthMode;
            if (valueReq.AuthMode == "WPAPSKWPA2PSK") {
                valueReq.passPhrase = config.PASSWORD_ENCODE ? Base64.encode(values.passPhrase) : values.passPhrase;
            }
            return valueReq;
        }
        function deal(paramD) {
            if (paramD) {
                return paramD;
            } else {
                return errUnknownObj;
            }
        }
    }	
    function setWifiBasic() {
        stuffMakeAndCheckServerIsOnline(arguments, prepare, deal);
        function prepare(values) {
            var valueReq = {
                goformId: "SET_WIFI_SSID1_SETTINGS",
                ssid: values.SSID,
                broadcastSsidEnabled: values.broadcast,
                MAX_Access_num: values.station,
                security_mode: values.AuthMode,
                cipher: values.cipher,
                NoForwarding: values.NoForwarding,
                show_qrcode_flag: values.show_qrcode_flag
            };
            if (config.WIFI_WEP_SUPPORT) {
                valueReq.wep_default_key = values.wep_default_key;
                valueReq.wep_key_1 = values.wep_key_1;
                valueReq.wep_key_2 = values.wep_key_2;
                valueReq.wep_key_3 = values.wep_key_3;
                valueReq.wep_key_4 = values.wep_key_4;
                if (values.wep_default_key == '1') {
                    valueReq.WEP2Select = values.WEP2Select;
                } else if (values.wep_default_key == '2') {
                    valueReq.WEP3Select = values.WEP3Select;
                } else if (values.wep_default_key == '3') {
                    valueReq.WEP4Select = values.WEP4Select;
                } else {
                    valueReq.WEP1Select = values.WEP1Select;
                }
            }
            if (values.AuthMode == "WPAPSK" || values.AuthMode == "WPA2PSK" || values.AuthMode == "WPAPSKWPA2PSK" || values.AuthMode == "WPA3Personal" || values.AuthMode == "WPA2WPA3") {
                valueReq.security_shared_mode = values.cipher;
                valueReq.passphrase = config.PASSWORD_ENCODE ? Base64.encode(values.passPhrase) : values.passPhrase;
            } else if (values.AuthMode == "SHARED") {
                valueReq.security_shared_mode = "WEP";
                valueReq.security_mode = "SHARED";
            } else {
                if (values.encryptType == "WEP") {
                    valueReq.security_shared_mode = "WEP";
                    valueReq.security_mode = "OPEN";
                } else {
                    valueReq.security_shared_mode = "NONE";
                }
            }
            return valueReq;
        }
        function deal(paramD) {
            if (paramD) {
                return paramD;
            } else {
                return errUnknownObj;
            }
        }
    }
    function setWifiBasic4SSID2() {
        stuffMakeAndCheckServerIsOnline(arguments, prepare, deal);
        function prepare(values) {
            var valueReq = {
                goformId: "SET_WIFI_SSID2_SETTINGS",
                m_SSID: values.m_SSID,
                m_HideSSID: values.m_broadcast,
                m_MAX_Access_num: values.m_station,
                m_AuthMode: values.m_AuthMode,
                cipher: values.m_cipher,
                m_NoForwarding: values.m_NoForwarding,
                m_show_qrcode_flag: values.m_show_qrcode_flag
            };
            if (config.WIFI_WEP_SUPPORT) {
                valueReq.m_DefaultKeyID = values.m_wep_default_key;
                valueReq.m_Key1Str1 = values.m_wep_key_1;
                valueReq.m_Key2Str1 = values.m_wep_key_2;
                valueReq.m_Key3Str1 = values.m_wep_key_3;
                valueReq.m_Key4Str1 = values.m_wep_key_4;
                if (values.m_wep_default_key == '1') {
                    valueReq.m_Key2Type = values.m_WEP2Select;
                } else if (values.m_wep_default_key == '2') {
                    valueReq.m_Key3Type = values.m_WEP3Select;
                } else if (values.m_wep_default_key == '3') {
                    valueReq.m_Key4Type = values.m_WEP4Select;
                } else {
                    valueReq.m_Key1Type = values.m_WEP1Select;
                }
            }
            if (values.m_AuthMode == "WPAPSK" || values.m_AuthMode == "WPA2PSK" || values.m_AuthMode == "WPAPSKWPA2PSK" || values.m_AuthMode == "WPA3Personal" || values.m_AuthMode == "WPA2WPA3") {
                valueReq.m_EncrypType = values.m_cipher;
                valueReq.m_WPAPSK1 = config.PASSWORD_ENCODE ? Base64.encode(values.m_passPhrase) : values.m_passPhrase;
            } else if (values.m_AuthMode == "SHARED") {
                valueReq.m_EncrypType = "WEP";
                valueReq.m_security_mode = "SHARED";
            } else {
                if (values.m_encryptType == "WEP") {
                    valueReq.m_EncrypType = "WEP";
                    valueReq.m_security_mode = "OPEN";
                } else {
                    valueReq.m_EncrypType = "NONE";
                }
            }
            return valueReq;
        }
        function deal(paramD) {
            if (paramD) {
                return paramD;
            } else {
                return errUnknownObj;
            }
        }
    }
    function getWifiBasic() {
        return stuffMake(arguments, {}, prepare, deal, null, false);
        function prepare(values, isPost) {
            var valueReq = {};
            var wpapsk = config.PASSWORD_ENCODE ? "WPAPSK1_encode,m_WPAPSK1_encode," : "imei,rnum_js,WPAPSK1_enaes,m_WPAPSK1_enaes,";
            valueReq.cmd = "m_ssid_enable,wifi_cur_state,NoForwarding,m_NoForwarding," + wpapsk + "MAX_Station_num," + "SSID1,AuthMode,HideSSID,MAX_Access_num,show_qrcode_flag,EncrypType,Key1Str1,Key2Str1,Key3Str1,Key4Str1,DefaultKeyID," + "m_SSID,m_AuthMode,m_HideSSID,m_MAX_Access_num,m_EncrypType,m_show_qrcode_flag,m_DefaultKeyID,m_Key1Str1,m_Key2Str1,m_Key3Str1,m_Key4Str1,rotationFlag,wifi_sta_connection";
            valueReq.multi_data = 1;
            return valueReq;
        }
        function deal(paramD) {
            if (paramD) {
                var result = {
                    wifi_enable: paramD.wifi_cur_state == "1" ? "1" : "0",
                    multi_ssid_enable: paramD.m_ssid_enable,
                    MAX_Station_num: $.isNumeric(paramD.MAX_Station_num) ? paramD.MAX_Station_num : config.MAX_STATION_NUMBER,
                    AuthMode: paramD.AuthMode,
                    SSID: paramD.SSID1,
                    broadcast: paramD.HideSSID,
                    apIsolation: paramD.NoForwarding,
                    passPhrase: config.PASSWORD_ENCODE ? Base64.decode(paramD.WPAPSK1_encode) : wifiDecode(paramD.rnum_js,paramD.imei,paramD.WPAPSK1_enaes),
                    MAX_Access_num: paramD.MAX_Access_num,
                    cipher: paramD.EncrypType == "TKIP" ? "0" : paramD.EncrypType == "AES" ? 1 : 2,
                    encryptType: paramD.EncrypType,
                    show_qrcode_flag: paramD.show_qrcode_flag == "1" ? true : false,
                    keyID: paramD.DefaultKeyID,
                    Key1Str1: paramD.Key1Str1,
                    Key2Str1: paramD.Key2Str1,
                    Key3Str1: paramD.Key3Str1,
                    Key4Str1: paramD.Key4Str1,
                    m_SSID: paramD.m_SSID,
                    m_broadcast: paramD.m_HideSSID,
                    m_apIsolation: paramD.m_NoForwarding,
                    m_MAX_Access_num: paramD.m_MAX_Access_num,
                    m_AuthMode: paramD.m_AuthMode,
                    m_passPhrase: config.PASSWORD_ENCODE ? Base64.decode(paramD.m_WPAPSK1_encode) : wifiDecode(paramD.rnum_js,paramD.imei,paramD.m_WPAPSK1_enaes),
                    m_cipher: paramD.m_EncrypType == "TKIP" ? "0" : paramD.m_EncrypType == "AES" ? 1 : 2,
                    m_show_qrcode_flag: paramD.m_show_qrcode_flag == "1" ? true : false,
                    m_encryptType: paramD.m_EncrypType,
                    m_keyID: paramD.m_DefaultKeyID,
                    m_Key1Str1: paramD.m_Key1Str1,
                    m_Key2Str1: paramD.m_Key2Str1,
                    m_Key3Str1: paramD.m_Key3Str1,
                    m_Key4Str1: paramD.m_Key4Str1,
                    rotationFlag: paramD.rotationFlag,
                    ap_station_enable: paramD.wifi_sta_connection
                };
                return result;
            } else {
                return errUnknownObj;
            }
        }
    }	
    function setWifiBasicMultiSSIDSwitch() {
        stuffMakeAndCheckServerIsOnline(arguments, prepare, deal);
        function prepare(values) {
            var paraTemp = values;
            if (values.wifiEnabled == '0') {
                paraTemp = {
                    wifiEnabled: values.wifiEnabled
                }
            }
            var valueReq = $.extend({
                goformId: "SET_WIFI_INFO",
            }, paraTemp);
            return valueReq;
        }
        function deal(paramD) {
            if (paramD) {
                return paramD;
            } else {
                return errUnknownObj;
            }
        }
    }
    function stuffMake(array, result, prepare, dealMethod, errorObject, isPost) {
        var values = array[0],
        callback = array[1],
        errorCallback = array[2];
        var objectToReturn;
        if (result && typeof result.errorType === 'string') {
            objectToReturn = $.extend(errUnknownObj, result);
            if (!callback) {
                return objectToReturn;
            }
            doCallback(objectToReturn, callback, errorCallback);
        } else {
            objectToReturn = $.extend({}, result);
            var valueReq;
            if (prepare) {
                valueReq = prepare(values, isPost);
            } else {
                valueReq = values;
            }
            if (!callback) {
                if (valueReq && (valueReq.cmd || valueReq.goformId)) {
                    var r = reqSync(valueReq, isPost);
                    if (dealMethod) {
                        objectToReturn = $.extend({}, dealMethod(r));
                    } else {
                        objectToReturn = r;
                    }
                }
                return objectToReturn;
            } else {
                if (valueReq && (valueReq.cmd || valueReq.goformId)) {
                    reqAsync(valueReq, function (paramD) {
                        if (dealMethod) {
                            objectToReturn = $.extend({}, dealMethod(paramD));
                        } else {
                            objectToReturn = $.extend({}, paramD);
                        }
                        if (!valueReq.notCallback) {
                            doCallback(objectToReturn, callback, errorCallback);
                        }
                    }, function () {
                        if (errorObject) {
                            objectToReturn = $.extend(errUnknownObj, errorObject);
                        } else {
                            objectToReturn = $.extend(errUnknownObj, {
                                errorType: 'Unknown'
                            });
                        }
                        doCallback(objectToReturn, callback, errorCallback);
                    }, isPost);
                } else {
                    doCallback(objectToReturn, callback, errorCallback);
                }
            }
        }
        function doCallback(resultToReturn, callback, errorCallback) {
            errorCallback = errorCallback ? errorCallback : callback;
            if (isErrorObject(resultToReturn)) {
                switch (resultToReturn.errorType) {
                case 'cellularNetworkError':
                case 'deviceError':
                case 'wifiConnectionError':
                    window.receivedNonSpecificError(resultToReturn);
                    break;
                default:
                    errorCallback(resultToReturn);
                }
            } else {
                callback(resultToReturn);
            }
        }
    }	
    function reqSync(values, isPost) {
        return reqAJAX(values, null, null, false, isPost);
    }
    function reqAsync(values, successCallback, errorCallback, isPost) {
        reqAJAX(values, successCallback, errorCallback, true, isPost);
    }
    function getString(values){
    var regexp = /^[A-z0-9]+$/;
    var matches = values.match(regexp);
    if (matches == null){
        return "error";
    } else {
        return values;
    }
    }
    function reqAJAX(values, successCallback, errorCallback, async, isPost) {
        var result = null;
        $.ajax({
            type: !!isPost ? "POST" : "GET",
            url: isPost ? "/reqproc/proc_post" : values.cmd ? "/reqproc/proc_get" : "/reqproc/proc_post",
            data: values,
            dataType: "json",
            async: !!async,
            cache: false,
            error: function (paramD) {
                if (async) {
                    errorCallback(paramD);
                } else if (paramD.status == 200) {
                    result = jQuery.parseJSON('(' + getString(paramD.responseText) + ')');
                }
            },
            success: function (paramD) {
                if (async) {
                    successCallback(paramD);
                } else {
                    result = paramD;
                }
            }
        });
        if (!async) {
            return result;
        }
    }
	    var informationAll = {
        networkType: "",
        signalImg: "0",
        spn_b1_flag: "1",
        spn_name_data: "",
        spn_b2_flag: "1",
        networkOperator: "China Mobile",
        connectStatus: "ppp_disconnected",
        rj45ConnectStatus: "rj45_dead",
        attachedDevices: [],
        ssid1AttachedNum: 0,
        ssid2AttachedNum: 0,
        data_counter: {
            uploadRate: 0,
            downloadRate: 0,
            totalSent: 0,
            totalReceived: 0,
            totalConnectedTime: 0,
            currentSent: 0,
            currentReceived: 0,
            currentConnectedTime: 0,
            monthlySent: 0,
            monthlyReceived: 0,
            monthlyConnectedTime: 0,
            month: ''
        },
        newSmsReceived: false,
        smsReportReceived: false,
        smsUnreadCount: "0",
        isLoggedIn: undefined,
        limitVolumeEnable: false,
        limitVolumeType: '1',
        limitVolumePercent: "100",
        limitVolumeSize: "0",
        allowRoamingUpdate: "0",
        blc_wan_mode: "",
        ap_station_enable: undefined,
        ap_station_mode: undefined,
        dialMode: '',
        ethWanMode: 'AUTO',
        fota_user_selector: '',
        defaultWanName: ""
    };
    var errUnknownObj = {
        errorType: 'UnknownError',
        errorId: '123',
        errorText: 'UnknownError'
    };
    var updateTimerFlag = true;	
    return {
        clearRedirectFlag: clearRedirectFlag,
        connect: connect,
        disconnect: disconnect,
        getSIMPhoneBookCapacity: getSIMPhoneBookCapacity,
        getDevicePhoneBookCapacity: getDevicePhoneBookCapacity,
		getDevicePhoneBooks: getDevicePhoneBooks,
        getSIMPhoneBooks: getSIMPhoneBooks,
        getPhoneBooks: getPhoneBooks,
        getPhoneBookReady: getPhoneBookReady,
        getPhoneBooksByGroup: getPhoneBooksByGroup,
        deletePhoneBooks: deletePhoneBooks,
        deleteAllPhoneBooks: deleteAllPhoneBooks,
        deleteAllPhoneBooksByGroup: deleteAllPhoneBooksByGroup,		
        savePhoneBook: savePhoneBook,
        deleteAllMessages: deleteAllMessages,
        deleteMessage: deleteMessage,
        setSmsRead: setSmsRead,
        sendSMS: sendSMS,
        saveSMS: saveSMS,
        getSMSReady: getSMSReady,
        getSMSMessages: getSMSMessages,
        getSMSDeliveryReport: getSMSDeliveryReport,
        getSmsCapability: getSmsCapability,
        resetNewSmsReceivedVar: resetNewSmsReceivedVar,
        resetSmsReportReceivedVar: resetSmsReportReceivedVar,
        getSmsSetting: getSmsSetting,
        setSmsSetting: setSmsSetting,
		getAttachedCableDevices: getAttachedCableDevices,
		getCurrentlyAttachedDevicesInfo: getCurrentlyAttachedDevicesInfo,
		getConnectionInfo: getConnectionInfo,
        getRedirectData: getRedirectData,
        getLanguage: getLanguage,
        setLanguage: setLanguage,
        getNetSelectInfo: getNetSelectInfo,		
        getSecurityInfo: getSecurityInfo,
        setSecurityInfo: setSecurityInfo,
        getStatusInfo: getStatusInfo,
        getConnectionMode: getConnectionMode,
        setConnectionMode: setConnectionMode,
        getWifiBasic: getWifiBasic,
        setWifiBasic: setWifiBasic,
        setWifiBasic4SSID2: setWifiBasic4SSID2,
        setWifiBasicMultiSSIDSwitch: setWifiBasicMultiSSIDSwitch, 
        getWpsInfo: getWpsInfo,
        openWps: openWps,
        getSleepMode: getSleepMode,
        setSleepMode: setSleepMode,
        getWifiAdvance: getWifiAdvance,
        setWifiAdvance: setWifiAdvance,
        getWifiRange: getWifiRange,
        setWifiRange: setWifiRange,
		
        getLoginStatus: getLoginStatus,
        getLoginData: getLoginData,
        login: login,
        logout: logout, 
        changeManageInfo: changeManageInfo,
        getPinData: getPinData,
        enablePin: enablePin,
        disablePin: disablePin,
        changePin: changePin,
		enterPIN: enterPIN,
        enterPUK: enterPUK,
        getLanInfo: getLanInfo,
        setLanInfo: setLanInfo,       
        getApnSettings: getApnSettings,
        deleteApn: deleteApn,
        setDefaultApn: setDefaultApn,
        addOrEditApn: addOrEditApn,
        getQuickSettingInfo: getQuickSettingInfo,
        setQuickSetting4IPv6: setQuickSetting4IPv6,
        scanForNetwork: scanForNetwork,
        setBearerPreference: setBearerPreference,
        editHostName: editHostName,
        getSiteWhiteList: getSiteWhiteList,
        removeSiteWhite: removeSiteWhite,
        saveSiteWhite: saveSiteWhite,
        setNetwork: setNetwork,
        getUpnpSetting: getUpnpSetting,
        setUpnpSetting: setUpnpSetting,
        getDmzSetting: getDmzSetting,
        setDmzSetting: setDmzSetting,
        getDeviceInfo: getDeviceInfo,
        getDeviceInfoLow: getDeviceInfoLow,
        getPortForward: getPortForward,
        setPortForward: setPortForward,
        getPortFilter: getPortFilter,
        setPortFilterBasic: setPortFilterBasic,
        setPortFilter: setPortFilter,
        deleteFilterRules: deleteFilterRules,
        getPortMap: getPortMap,
        setPortMap: setPortMap,
        enablePortMap: enablePortMap,
        deleteMapRules: deleteMapRules,
        getTrafficAlertInfo: getTrafficAlertInfo,
        setTrafficAlertInfo: setTrafficAlertInfo,
        getCurrentUpgradeState: getCurrentUpgradeState,
        setUpgradeSelectOp: setUpgradeSelectOp,
        addTimerThings: addTimerSomething,
        removeTimerThings: removeTimerSomething,
        getPackSizeInfo: getPackSizeInfo,
        getMandatory: getMandatory,
        getOTAUpdateSetting: getOTAUpdateSetting,
        setOTAUpdateSetting: setOTAUpdateSetting,
        getSignalStrength: getSignalStrength,
        getOTAlastCheckTime: getOTAlastCheckTime,
        clearUpdateResult: clearUpdateResult,
        refreshAPStationStatus: refreshAPStationStatus,
        getSntpParams: getSntpParams,
        setSntpSetting: setSntpSetting,
        setSNTPDate: setSNTPDate,
        restoreFactorySettings: restoreFactorySettings,
        checkRestoreStatus: checkRestoreStatus,
        getSysSecurity: getSysSecurity,
        setSysSecurity: setSysSecurity,
        deleteForwardRules: deleteForwardRules,
        enableVirtualServer: enableVirtualServer,
        getSDConfiguration: getSDConfiguration,
        setSdCardMode: setSdCardMode,
        checkFileExists: checkFileExists,
        getFileList: getFileList,
        fileRename: fileRename,
        getSdMemorySizes: getSdMemorySizes,
        deleteFilesAndFolders: deleteFilesAndFolders,
        createFolder: createFolder,
        setSdCardSharing: setSdCardSharing,
        setUpdateInfoWarning: setUpdateInfoWarning,
        getUpdateInfoWarning: getUpdateInfoWarning,
        getAPStationBasic: getAPStationBasic,
        setAPStationBasic: setAPStationBasic,
        getWdsInfo: getWdsInfo,
        setWDS: setWDS,
        addUrlFilterRule: addUrlFilterRule,
        getUrlFilterList: getUrlFilterList,
        deleteSelectedRules: deleteSelectedRules,
        getMacFilterInfo: getMacFilterInfo,
        setMacFilter: setMacFilter,
        getFastbootSetting: getFastbootSetting,
        setFastbootSetting: setFastbootSetting,
        turnOffDevice: turnOffDevice,
        restart: restart,
        updateTimerFlag: updateTimerFlag,
        childGroupList: childGroupList,
        addChildGroup: addChildGroup,
        removeChildGroup: removeChildGroup,
        checkCurrentUserInChildGroup: checkCurrentUserInChildGroup,
        getTimeLimited: getTimeLimited,
        saveTimeLimited: saveTimeLimited,
        getHostNameList: getHostNameList,
        getHotspotList: getHotspotList,
        searchHotspot: searchHotspot,
        getSearchHotspotList: getSearchHotspotList,
        saveHotspot: saveHotspot,
        deleteHotspot: deleteHotspot,
        connectHotspot: connectHotspot,
        disconnectHotspot: disconnectHotspot,
        getOpMode: getOpMode,
        getRj45PlugState: getRj45PlugState,
        SetOperationMode: SetOperationMode,
        getPppoeParams: getPppoeParams,
        setPppoeDialMode: setPppoeDialMode,
        getTsw: getTsw,
        saveTsw: saveTsw,
        trafficCalibration: trafficCalibration,
        getParams: getParams,
        getNewVersionState: getNewVersionState,
        getUpgradeResult: getUpgradeResult,
        getV4Switch: getV4Switch,
        setV4Switch: setV4Switch,
        getCellId: getCellId,
        setCellIdSwitch: setCellIdSwitch,
        getDdnsParams: getDdnsParams,
        setDDNSForward: setDDNSForward,
        getUpdateType: getUpdateType,
        getCurretnMAC: getCurretnMAC,
        getUSSDResponse: getUSSDResponse,
        USSDReplyCancel: USSDReplyCancel,
        getNetworkUnlockTimes: getNetworkUnlockTimes,
        unlockNetwork: unlockNetwork,	
        getSyslogInfo: getSyslogInfo,
        setSysLog: setSysLog,		
    };
});

 // Router

define("adm_lan","jquery knockout set service".split(" "),

    function ($, ko, config, service) {
	
    var originfrmLan = "";
	
    // ȡ·Ϣ
    function getLanInfo() {
        return service.getLanInfo();
    }	
	
    function hex(val) {
        var h = (val - 0).toString(16);
        if (h.length == 1)
            h = '0' + h;
        return h.toUpperCase();
    }	
	
    function LanViewModel() {
        var target = this;

        var info = getLanInfo();

        target.dhcpStart = ko.observable(info.dhcpStart);
        target.dhcpEnd   = ko.observable(info.dhcpEnd);
        target.dhcpLease = ko.observable(info.dhcpLease);		
		
        target.ipAddress  = ko.observable(info.ipAddress);
        target.subnetMask = ko.observable(info.subnetMask);
        target.dhcpServer = ko.observable(info.dhcpServer);

		target.macAddress = ko.observable(info.macAddress);
        target.showMacAddress = ko.observable(config.SHOW_MAC_ADDRESS);
		
        target.hasWifi        = ko.observable(config.HAS_WIFI);
        target.hasUssd        = config.HAS_USSD;
        target.hasDdns        = config.DDNS_SUPPORT;
	
        target.hasUpdateCheck = config.HAS_UPDATE_CHECK;
				
        target.clear = function () {
            clearTimer();
            init();
            clearValidateMsg();
        };		
		
        target.refreshStatus = function () {
            var connInfo = service.getConnectionInfo();
            if (connInfo.connectStatus == 'ppp_disconnected') {
                $('input', '#frmLan').each(function () {
                    $(this).attr("disabled", false);
                });
            } else {
                $('input', '#frmLan').each(function () {
                    $(this).attr("disabled", true);
                });

                clearValidateMsg();
            }
        };

        // Ӧñ
        target.saveAct = function () {
            showLoading();
            var params = {
                ipAddress:  target.ipAddress(),
                subnetMask: target.subnetMask(),
                dhcpServer: target.dhcpServer(),
                dhcpStart:  target.dhcpStart(),
                dhcpEnd:    target.dhcpEnd(),
                dhcpLease:  target.dhcpLease()
            };
			
            service.setLanInfo(params, function (result) {
                if (result.result == "success") {
                    successOverlay();
                    target.clear();
                } else {
                    errorOverlay();
                }
            });
        };		

        // Ӧñ
        target.save = function () {
            var frmLanObj = $('#frmLan').serialize();
            if (frmLanObj == originfrmLan) {
                showAlert("setting_no_change");
                return false;
            }
            if (config.RJ45_SUPPORT) {
                var pppObj = service.getPppoeParams();
                if (sf_isValidate_StaticIP(pppObj.static_wan_ipaddr, target.ipAddress(), target.subnetMask())) {
                    showAlert("lan_tip_staticip_notsame");
                    return false;
                }
            }
            showConfirm("lan_confirm_reopen", function () {
                target.saveAct();
            });
        };

            target.refreshStatus();
            // dhcpServerлӦ
            target.dhcpServerHandler = function () {
                $("#txtIpAddress").parent().find(".error").hide();
                $("#txtIpAddress").show();
                return true;
            };
        addTimeout(function () {
            originfrmLan = $('#frmLan').serialize();
        }, 500);
    }

			
    function sf_opAnd4Byte(i_v1, i_v2) {
        var index;
        var var1 = [];
        var var2 = [];
        var result='0x';

        for (index=2,index_tmp=0; index<10; index+=2,index_tmp++) {
            var1[index_tmp]='0x'+i_v1.substring(index,index+2);
            var2[index_tmp]='0x'+i_v2.substring(index,index+2);
        }

        for (index=0; index<4; index++) {
            result = result + hex(var1[index]&var2[index]);
        }

        return result - 0;
    }

    // رУ	
    $.validator.addMethod("dhcp_check", function (i_value, i_element, i_parameter) {
        var dhcpIp =  i_parameter == "start" ?  $('#txtDhcpIpPoolStart').val() : $('#txtDhcpIpPoolEnd').val();
        var result = sf_isValidate_Gateway($('#txtIpAddress').val(), $('#txtSubnetMask').val(), dhcpIp);
        return this.optional(i_element) || result;
    });

    $.validator.addMethod("dhcpCompare", function (i_value, i_element, i_parameter) {
        var result;
        if(i_parameter == "#txtDhcpIpPoolStart") {
            result = sf_isValidate_StartEndIp($('#txtIpAddress').val(), $('#txtSubnetMask').val(), $(i_parameter).val(), i_value);
        }
        else {
            result = sf_isValidate_StartEndIp($('#txtIpAddress').val(), $('#txtSubnetMask').val(), i_value, $(i_parameter).val());
        }
        return result != 1;
    });

    $.validator.addMethod("ipRange", function (i_value, i_element, i_parameter) {
        var DHCP_flag = false;
        if($('#dhcpEnable').is(':checked')){
            DHCP_flag = true;
        }
        var result = sf_isValidate_StartEndIp(i_value, $('#txtSubnetMask').val(), $('#txtDhcpIpPoolStart').val(), $('#txtDhcpIpPoolEnd').val(), DHCP_flag);
        return result != 2;
    });
	
    $.validator.addMethod("subnetmask_check", function (i_value, i_element, i_parameter) {
        var result = sf_isValidate_Netmask(i_value);
        return this.optional(i_element) || result;
    });	
	

    // ̬ЧIPУ麯
    function sf_isValidate_StaticIP(i_ip, i_lanIp, i_lanMask){
            if(!i_ip || !i_lanIp || !i_lanMask){//Ϊ
                return false;
            }
		
		       //IP
            if (i_ip == i_lanIp) { 
                return true;
            }
		
            var res1 = [];
            var res2 = [];
		
            var mask_array = [];
		
            ip_array = i_ip.split(".");
            lanIp_array = i_lanIp.split(".");
            mask_array  = i_lanMask.split(".");
            for(var index = 0; index < ip_array.length; index += 1){
                res1.push(parseInt(mask_array[index]) & parseInt(ip_array[index]));
                res2.push(parseInt(mask_array[index]) & parseInt(lanIp_array[index]));
            }
            if(res2.join(".") != res1.join(".")){//ڲͬ
                return false;
            }else{//ͬһ
                return true;
            }
        }
	

    function sf_isValidate_NetmaskIP(i_ip) {
        return (i_ip == 255
      		 || i_ip == 254 
			 || i_ip == 252 
			 || i_ip == 248
             || i_ip == 240 
			 || i_ip == 224 
			 || i_ip == 192 
			 || i_ip == 128
			 || i_ip == 0);
    }
	
	function sf_convertIpToString(i_ip)
	{
        var s_i1 = i_ip.indexOf('.');
        var s_i2 = i_ip.indexOf('.', (s_i1 + 1));
        var s_i3 = i_ip.indexOf('.', (s_i2 + 1));
        o_ip = hex(i_ip.substring(0, s_i1)) + hex(i_ip.substring((s_i1 + 1), s_i2)) + hex(i_ip.substring((s_i2 + 1), s_i3)) + hex(i_ip.substring((s_i3 + 1), i_ip.length));
        o_ip = '0x' + o_ip;

        return 	o_ip;	
	}
	
	function sf_getIpString_3(i_ip)
	{
        var i1 = i_ip.indexOf('.');
        var i2 = i_ip.indexOf('.', (i1 + 1));
        var i3 = i_ip.indexOf('.', (i2 + 1));
        var i4 = i_ip.substring((i3+1),i_ip.length)-0;

        return 	i4;	
	}	

	
    // У麯
    function sf_isValidate_Gateway(i_wanIp, i_netmaskIp, i_gatewayIp) {
	    var s_wanIp = sf_convertIpToString(i_wanIp);
		var lan4 = sf_getIpString_3(i_wanIp);
		
	    var s_netmaskIp = sf_convertIpToString(i_netmaskIp);
		var mask4 = sf_getIpString_3(i_netmaskIp);		
		
	    var s_gatewayIp = sf_convertIpToString(i_gatewayIp);
		var pool4 = sf_getIpString_3(i_gatewayIp);	
		
        var net_no;
        var lo_broadcast;		

        if (sf_opAnd4Byte(s_wanIp, s_netmaskIp) != sf_opAnd4Byte(s_gatewayIp, s_netmaskIp)) {
            return false;
        }

        net_no       = (lan4 & mask4);
        lo_broadcast =  (lan4 & mask4) + (255-mask4);

        return !(pool4==net_no || pool4==lo_broadcast);		
	
    }	

	// У麯		
    function sf_isValidate_Netmask(i_netmask) {
        var addr = i_netmask.split(".");
		
		if ("0.0.0.0" == i_netmask || "255.255.255.255" == i_netmask) {
            return false;
        }

        if (addr.length != 4) {
            return false;
        }

        addr[0] = parseInt(addr[0]);
        addr[1] = parseInt(addr[1]);
        addr[2] = parseInt(addr[2]);
        addr[3] = parseInt(addr[3]);

        if (addr[3] != 0) {
            if (addr[0] != 255 || addr[1] != 255 || addr[2] != 255) {
                return false;
            } else {
                if (!sf_isValidate_NetmaskIP(addr[3])) {
                    return false;
                }
            }
        }

        if (addr[2] != 0) {
            if (addr[0] != 255 || addr[1] != 255) {
                return false;
            } else {
                if (!sf_isValidate_NetmaskIP(addr[2])) {
                    return false;
                }
            }
        }

        if (addr[1] != 0) {
            if (addr[0] != 255) {
                return false;
            } else {
                if (!sf_isValidate_NetmaskIP(addr[1])) {
                    return false;
                }
            }
        }
			
        if (addr[0] != 255) {
            return false;
        }
			
        return true;
    }
	
    // DHCP IPУ麯
    function sf_isValidate_StartEndIp(i_lanIpaddr, i_netIp, i_startIp, i_endIp, i_DHCPFlag) {
	    s_startIp = sf_convertIpToString(i_startIp);
		s_endIp   = sf_convertIpToString(i_endIp);
		s_lanIp   = sf_convertIpToString(i_lanIpaddr);

		if(s_startIp>s_endIp) {
            return 1;
        }
		
        if(s_lanIp >= s_startIp && s_lanIp <= s_endIp) {
            return 2;
        }

        return 0;		
	}


    function init() {
        var container = $('#container');
        ko.cleanNode(container[0]);
        var fwVm = new LanViewModel();
        ko.applyBindings(fwVm, container[0]);

        addInterval(fwVm.refreshStatus, 1000);

        $('#frmLan').validate({
            submitHandler:function () {
                fwVm.save();
            },
			
            rules:{
                txtIpAddress: {
                    lanip_check: true,
                    ipRange: true
                },
                txtSubnetMask: {
                    ipv4: true,
                    subnetmask_check: true
                },
                txtDhcpIpPoolStart: {
                    lanip_check: true,
                    dhcp_check: "start",
                    dhcpCompare: "#txtDhcpIpPoolEnd"
                },
                txtDhcpIpPoolEnd: {
                    lanip_check: true,
                    dhcp_check: "end",
                    dhcpCompare: "#txtDhcpIpPoolStart"
                },
                txtDhcpLease: {
                    range: [1, 65535],
                    digits: true
                }
            },
				
            groups: {
                lanip_check: "txtDhcpIpPoolStart txtDhcpIpPoolEnd"
            },
				
            errorPlacement: function (error, element) {
                if (element.attr("name") == "txtDhcpLease") {
                    error.insertAfter("#errorHolder");
                } else if (element.attr("name") == "txtDhcpIpPoolStart") {
                    error.insertAfter("#txtDhcpIpPoolEnd");
                } else {
                    error.insertAfter(element);
                }
			}
        });

    }
		
		
    return {
        init:init
    }
});

// others ģ:Fast Boot SettingsRestart and ResetSNTPTurn Off DevicePIN Management
define("adm_others","jquery knockout set service underscore".split(" "),

    function ($, ko, config, service, _) {
		
		var timeSetModes = _.map(config.sntpTimeSetMode, function(item) {
			return new Option(item.name, item.value);
		});
		
		var timeZones    = _.map(config.timeZone, function(item){
			return new Option(item.name, item.value);
		});
		
		var daylightSave = _.map(config.daylightSave, function(item){
			return new Option(item.name, item.value);
		});
		
		var sv_sntpYears    = [];
		var sv_sntpMonths   = [];
		var sv_sntpDates    = [];  //ݴС
		var sv_sntpHours    = [];
		var sv_sntpMinutes  = [];
			
		var sf_bigMonth     = [1, 3, 5, 7, 8, 10, 12];
		var sf_smallMonth   = [4, 6, 9, 11];
		
		function sf_produceArray(start, end, arryName) {
			var item = {};
			for(var i = start; i <= end; i++) {
				item.name  = i;
				item.value = i;
				arryName.push(new Option(item.name, item.value));
			}
		}
		
		//ꡢ¡ʱֵ
		sf_produceArray(2000, 2030, sv_sntpYears);
		sf_produceArray(1, 12, sv_sntpMonths);
		sf_produceArray(0, 23, sv_sntpHours);
		sf_produceArray(0, 59, sv_sntpMinutes);			
		
        function othersViewModel() {
            var target = this;
			
			var inChildGroup = false;
			
            target.fastbootSupport    = config.FAST_BOOT_SUPPORT;
            target.turnOffSupport     = config.TURN_OFF_SUPPORT;     
            target.SNTPSupport        = config.HAS_SNTP;
			target.hasUssd            = config.HAS_USSD;
			target.hasDdns            = config.DDNS_SUPPORT;
			target.hasUpdateCheck     = config.HAS_UPDATE_CHECK;

			
            if (config.HAS_PARENTAL_CONTROL) {
                inChildGroup = service.checkCurrentUserInChildGroup().result;
            }
            target.currentUserInChildGroup = ko.observable(inChildGroup);

            var sv_fastbootInfo = service.getFastbootSetting();
            target.fastbootEnableFlag =  ko.observable(config.RJ45_SUPPORT ? (sv_fastbootInfo.need_sim_pin != "yes" && service.getRj45PlugState().rj45_plug == "wan_lan_off") : sv_fastbootInfo.need_sim_pin != "yes");
            target.fastbootSetting = ko.observable(sv_fastbootInfo.fastbootEnabled);


            // @method addInterval		
			addInterval(function(){
				target.fastbootEnableFlag(config.RJ45_SUPPORT ? (sv_fastbootInfo.need_sim_pin != "yes" && service.getRj45PlugState().rj45_plug == "wan_lan_off") : sv_fastbootInfo.need_sim_pin != "yes");
			}, 1000);				

            // ָ
            // @event restore
            target.restore = function () {
                showConfirm("restore_confirm", function () {
                    showLoading("restoring");
                    service.restoreFactorySettings({}, function (info) {
                        if (info && info.result == "success") {
                            successOverlay();
                        } else {
                            errorOverlay();
                        }
                    }, function (result) {
                        if (isErrorObject(result) && result.errorType == 'no_auth') {
                            errorOverlay();
                        }
                    });
                });
            };

            target.restart = function () {
                showConfirm("restart_confirm", function () {
                    restartDevice(service);
                });
            };
			
            // ٿػ
            target.saveFastBoot = function() {
                showLoading();
                var params = {
                    fastbootEnabled: target.fastbootSetting(),
                    need_hard_reboot: sv_fastbootInfo.need_hard_reboot
                };
                service.setFastbootSetting(params, function(result) {
                    if (result.result == "success") {
                        successOverlay();
                    } else {
                        errorOverlay();
                    }
                });
            };
			
            // ػ
            target.turnoff = function () {
                showConfirm("turnoff_confirm", function () {
                    showLoading("turnoff");
                    service.turnOffDevice({}, function (info) {
                        if (info && info.result == "success") {
                            successOverlay();
                        } else {
                            errorOverlay();
                        }
                    }, $.noop);
                });
            };
					
			//SNTPserverУ׼ʱ
			service.setSNTPDate({
				goformId: "SNTP_Getdatastatic"
			});
			
			var target       = this;
			var sntpInfo   = service.getSntpParams();
			
			globalTime     = new Date(parseInt(sntpInfo.sntp_year, 10),parseInt(sntpInfo.sntp_month, 10)-1, parseInt(sntpInfo.sntp_day, 10), parseInt(sntpInfo.sntp_hour, 10), parseInt(sntpInfo.sntp_minute, 10), parseInt(sntpInfo.sntp_second, 10));

			target.day       = ko.observable();
			target.localTime = ko.observable();
			
			//ʼǰʱ
			//target.updateCurrentTime; cov_2
			target.timeSetModes    = ko.observableArray(timeSetModes);
			target.isManualSetTime = ko.observable(false);
			target.isAutoSntpTime  = ko.observable(false);
			
			target.currentMode = ko.observable(sntpInfo.sntp_time_set_mode);
			
			changeSetTimeMode();
			target.changeSetTimeMode = function(){
				changeSetTimeMode();
			};
			
			target.currentYear   = ko.observable(parseInt(sntpInfo.sntp_year, 10));
			target.currentMonth  = ko.observable(parseInt(sntpInfo.sntp_month, 10));
			target.currentDate   = ko.observable(parseInt(sntpInfo.sntp_day, 10));
			target.currentHour   = ko.observable(parseInt(sntpInfo.sntp_hour, 10));
			target.currentMinute = ko.observable(parseInt(sntpInfo.sntp_minute, 10));
			

			// Ҫˢбݣע˳ 

			target.years  = ko.observableArray(sv_sntpYears);
			target.months = ko.observableArray(sv_sntpMonths);				
			//ûѡ·ݵʱıѡѡ
			target.initDateList = function(){
				initDateList();
				target.dates(sv_sntpDates);
			}
		
			//ʼб
			initDateList();
			target.dates   = ko.observableArray(sv_sntpDates);
			target.hours   = ko.observableArray(sv_sntpHours);
			target.minutes = ko.observableArray(sv_sntpMinutes);
			
			//ԶSNTPȡʱݰ󶨴
			var serverArray = _.map(sntpInfo.sntp_servers, function(item) {
				return new Option(item.name, item.value)
			});
			
			target.serverList          = ko.observableArray(serverArray);

			// ֲ޸ģ޸޷ˢҳ

			target.currentServer0 = ko.observable(sntpInfo.sntp_server0);
			target.currentServer1 = ko.observable(sntpInfo.sntp_server1);
			target.currentServer2 = ko.observable(sntpInfo.sntp_server2);
			target.customServer0 = ko.observable(sntpInfo.sntp_other_server0);
			target.customServer1 = ko.observable(sntpInfo.sntp_other_server1);
			target.customServer2 = ko.observable(sntpInfo.sntp_other_server2);
			target.isOther0 = ko.observable(false);
			target.isOther1 = ko.observable(false);
			target.isOther2 = ko.observable(false);
			
			initOtherServer();

			target.changeServerSelect = function(){
				initOtherServer();
			}
			
			target.timeZones           = ko.observableArray(timeZones);
			target.currentTimeZone     = ko.observable(sntpInfo.sntp_timezone + "_" + sntpInfo.sntp_timezone_index);
			target.daylightSaves       = ko.observableArray(daylightSave);
			target.currentDaylightSave = ko.observable(sntpInfo.sntp_dst_enable);
			
			//µǰʾʱ
			target.updateCurrentTime = function() {
			    var globalDay = globalTime.getDay();
				
				switch(globalDay){
				    case 6:
				    	target.day($.i18n.prop("saturday"));
				    	break;		
				    case 5:
				    	target.day($.i18n.prop("friday"));
				    	break;	
				    case 4:
				    	target.day($.i18n.prop("thursday"));
				    	break;	
				    case 3:
				    	target.day($.i18n.prop("wednesday"));
				    	break;
				    case 2:
				    	target.day($.i18n.prop("tuesday"));
				    	break;	
				    case 1:
				    	target.day($.i18n.prop("monday"));
				    	break;						
				    case 0:
				    	target.day($.i18n.prop("sunday"));
				    	break;
				    default:
			        	break;
				}
					
				var localCurrentTime = globalTime.getFullYear() + "-" + getTwoDigit(globalTime.getMonth()+1) + "-" + getTwoDigit(globalTime.getDate()) + " " + getTwoDigit(globalTime.getHours()) + ":" + getTwoDigit(globalTime.getMinutes()) + ":" + getTwoDigit(globalTime.getSeconds());
				target.localTime(localCurrentTime);
				globalTime.setTime(globalTime.getTime()+1000);			
			};
				
            // SNTP		
			target.apply = function(){
				var tmpArray = [];
				for(var i=0; i< sntpInfo.sntp_servers.length; i++){
					tmpArray.push(sntpInfo.sntp_servers[i].value);
				}
				var staInfo = service.getStatusInfo();
				if(!checkConnectedStatus(staInfo.connectStatus, staInfo.rj45ConnectStatus, staInfo.connectWifiStatus) && target.currentMode() == "auto"){
					showAlert("sntp_syn_time_wan_connected");
					return;
				}
				
				showLoading("");
				var requestParams = {
					goformId: "SNTP",
					manualsettime : target.currentMode(),
					sntp_server1_ip : target.currentServer0(),
					sntp_server2_ip : target.currentServer1(),
					sntp_server3_ip : target.currentServer2(),
					sntp_other_server0 : target.customServer0(),
					sntp_other_server1 : target.customServer1(),
					sntp_other_server2 : target.customServer2(),
					timezone : target.currentTimeZone().split("_")[0],
					sntp_timezone_index : target.currentTimeZone().split("_")[1],
					DaylightEnabled : target.currentDaylightSave(),
					time_year : target.currentYear(),
					time_month : target.currentMonth(),
					time_day : target.currentDate(),
					time_hour : target.currentHour(),
					time_minute : target.currentMinute()
				};
        
				service.setSntpSetting(requestParams, function(data2){
					if(data2) {
					    if(data2.result == "success" && target.currentMode() == "auto"){
                            successOverlay("sntp_req_success");
							//hideLoading();
						}else if(data2.result == "processing" && target.currentMode() == "auto"){
							successOverlay("sntp_processing");
						}else{
							//serverУ׼ʱ
							service.setSNTPDate({
								goformId: "SNTP_Getdatastatic"
							}, function(result){
									var sntpInfo = 	service.getSntpParams();
									globalTime = new Date(parseInt(sntpInfo.sntp_year, 10),parseInt(sntpInfo.sntp_month, 10)-1, parseInt(sntpInfo.sntp_day, 10), parseInt(sntpInfo.sntp_hour, 10), parseInt(sntpInfo.sntp_minute, 10), parseInt(sntpInfo.sntp_second, 10));
									successOverlay();
							});
						}
					} else {
						errorOverlay();
					}
				});
			}
			
            // ֶ/ԶлӦ		
			function changeSetTimeMode() {
				if(target.currentMode() == "manual") {
					target.isManualSetTime(true);
					target.isAutoSntpTime(false);
				} else {
					target.isManualSetTime(false);
					target.isAutoSntpTime(true);
				}
				return true;
			}
			
            // ʼʱ
			function initDateList(){
				sv_sntpDates = [];
				if($.inArray(parseInt(target.currentMonth(), 10), sf_smallMonth) != -1) {
					sf_produceArray(1, 30, sv_sntpDates);
				} else if($.inArray(parseInt(target.currentMonth(), 10), sf_bigMonth) != -1) {
					sf_produceArray(1, 31, sv_sntpDates);
				} else if(parseInt(target.currentYear(), 10)%4 == 0) {
					sf_produceArray(1, 29, sv_sntpDates);
				} else {
					sf_produceArray(1, 28, sv_sntpDates);
				}
			}
			
            // ʼ			
			function initOtherServer(){
				target.isOther0(target.currentServer0() == "Other");
				target.isOther1(target.currentServer1() == "Other");
				target.isOther2(target.currentServer2() == "Other");
				!target.isOther0() && $("#sntp_server0").find(".error").hide();
				!target.isOther1() && $("#sntp_server1").find(".error").hide();
				!target.isOther2() && $("#sntp_server2").find(".error").hide();
			}

			
        }

	    // ʼ ViewModelͼ
        function init() {
            var fwVm = new othersViewModel();
            var container = $('#container')[0];
		    ko.cleanNode(container);
            ko.applyBindings(fwVm, container);
			fwVm.updateCurrentTime();
		
		    addInterval(function(){
			    fwVm.updateCurrentTime();
		    }, 1000);
		
		    $("#sntpForm").validate({
			    submitHandler: function(){
				    fwVm.apply();
			    },
			    rules: {
				    sntp_other_server0 : "sntp_invalid_server_name",
				    sntp_other_server1 : "sntp_invalid_server_name",
				    sntp_other_server2 : "sntp_invalid_server_name"
			    }
		    });
        }

        return {
            init:init
        }
    });
//  ģ

define("adm_management","jquery knockout set service underscore CryptoJS".split(" "),

    function ($, ko, config, service, _, CryptoJS) {

        function manageViewModel() {
            var target = this;
            
            target.currentValue = ko.observable();
            target.newValue     = ko.observable();
            target.confirmValue = ko.observable();
            
            function sf_changeValue() {
            var sv_manageInfo = {};
            if (config.PASSWORD_ENCODE) {
                sv_manageInfo.oldValue = target.currentValue();
                sv_manageInfo.newValue = target.newValue(); 
            } else {            
                var pwdRegex = new RegExp('(?=.*[0-9])(?=.*[a-zA-Z])(?=.*[^a-zA-Z0-9]).{8,32}');
  
                if (!pwdRegex.test(target.newValue())) {
                    showConfirm("password_note_too_low", function () {

                    var kparam = service.getDeviceInfoLow();
                    var tkey = CryptoJS.enc.Latin1.parse(kparam.skey);
					var tiv = CryptoJS.enc.Latin1.parse(kparam.siv);
                    var cipherold = CryptoJS.AES.encrypt(target.currentValue(), tkey, {
                            iv: tiv,
                            mode: CryptoJS.mode.CBC,
                            padding: CryptoJS.pad.ZeroPadding
                            }).toString();
                    var ciphernew = CryptoJS.AES.encrypt(target.newValue(), tkey, {
                            iv: tiv,
                            mode: CryptoJS.mode.CBC,
                            padding: CryptoJS.pad.ZeroPadding
                            }).toString();

                    sv_manageInfo.oldValue = cipherold;
                    sv_manageInfo.newValue = ciphernew;
                
                    showLoading();
                
                    service.changeManageInfo(sv_manageInfo, function (resultInfo) {
                        target.cancel();
                        if (resultInfo && resultInfo.result == true) {
                            successOverlay();
                        } else {
                            if (resultInfo && resultInfo.errorType == "badPassword") {
                                hideLoading();
                                showAlert("current_password_error",function(){
                                    $("#txtCurrent").focus();
                                });
                            } else {
                                errorOverlay();
                            }
                        }
                    });
                    });
                    return;
               }
                var kparam = service.getDeviceInfoLow();
                var tkey = CryptoJS.enc.Latin1.parse(kparam.skey);
		var tiv = CryptoJS.enc.Latin1.parse(kparam.siv);
                var cipherold = CryptoJS.AES.encrypt(target.currentValue(), tkey, {
                        iv: tiv,
                        mode: CryptoJS.mode.CBC,
                        padding: CryptoJS.pad.ZeroPadding
                        }).toString();
                var ciphernew = CryptoJS.AES.encrypt(target.newValue(), tkey, {
                        iv: tiv,
                        mode: CryptoJS.mode.CBC,
                        padding: CryptoJS.pad.ZeroPadding
                        }).toString();

                sv_manageInfo.oldValue = cipherold;
                sv_manageInfo.newValue = ciphernew;
                }

                showLoading();
                
                service.changeManageInfo(sv_manageInfo, function (resultInfo) {
                    target.cancel();
                    if (resultInfo && resultInfo.result == true) {
                        successOverlay();
                    } else {
                        if (resultInfo && resultInfo.errorType == "badPassword") {
                            hideLoading();
                            showAlert("current_password_error",function(){
                                $("#txtCurrent").focus();
                            });
                        } else {
                            errorOverlay();
                        }
                    }
                });     
            }
            
            // 
            function sf_cancel() {
                target.currentValue("");
                target.newValue("");
                target.confirmValue("");
            }           
            
            target.cancel = sf_cancel;
            
            // ޸
            target.changeValue = sf_changeValue;
        }

        function init() {
            var container = $('#container');
            ko.cleanNode(container[0]);
            var fwVm = new manageViewModel();
            ko.applyBindings(fwVm, container[0]);
                  
            $('#frmPassword').validate({
                submitHandler:function () {
                    fwVm.changeValue();
                },
                rules:{
                    txtCurrent:"manage_info_check",
                    txtNew:"manage_info_check",
                    txtConfirm:{ equalTo:"#txtNew"}
                }
            });
        }

        return {
            init:init
        }
    }
);
// PINģ

define("adm_pin","jquery knockout set service".split(" "),

    function ($, ko, config, service) {
        var pageState = {common:0, requirePin:1, modifyPin:2, requirePuk:3, destroyed:4};
        var pinStatus = {enable:"1", disable:"0"};


        function pinViewModel() {
            var target = this;
            var sv_currentPinData     = service.getPinData();
			
            target.isDataCard         = config.PRODUCT_TYPE == 'DATACARD';
            target.originPinStatus    = ko.observable(sv_currentPinData.pin_status);
			
            target.pinStatus          = ko.observable(sv_currentPinData.pin_status);
            target.pinNumber          = ko.observable(sv_currentPinData.pinnumber);
            target.pukNumber          = ko.observable(sv_currentPinData.puknumber);
			
            target.currentPin         = ko.observable();
            target.newPin             = ko.observable();
            target.confirmPin         = ko.observable();
			
            target.puk                = ko.observable();
			
            target.pageState          = ko.observable();
            // ɹ־λ
            target.operateSuccessFlag = true;
			
			target.callback           = sf_callback;		
			
			function sf_callback(info) {
                if (info && info.result == true) {
                    target.operateSuccessFlag = true;
                    successOverlay();
                } else {
                    target.operateSuccessFlag = false;
					
                    // һǰҪʾ					 
                    if(target.pinNumber() == 2){
                      showAlert("last_enter_pin");    
                    } else if(target.pukNumber() == 2){
                      showAlert("last_enter_puk");    
                    }
                    else{
                      errorOverlay();      
                    }   
                }
                init(target);
            }
            	

            // ȷť¼޸PINPUKPINPINʹ״̬
			
            function sf_changePin() {
                if (target.isConnectedNetWork()) {
                    showAlert("cannot_operate_when_connected");
                    return;
                }

                if (target.pageState() == pageState.common) {
                    return;
                }

                var sv_pinPara = {
                    oldPin:target.currentPin(),
                    newPin:target.newPin()
                };
                showLoading();

                if (target.pageState() == pageState.modifyPin) {
                    service.changePin(sv_pinPara, target.callback);
                } else if (target.pageState() == pageState.requirePuk) {
                    sv_pinPara = {
                        PinNumber:target.newPin(),
                        PUKNumber:target.puk()
                    };
                    service.enterPUK(sv_pinPara, target.callback);
                } else {
                    if (target.pinStatus() == pinStatus.enable) {
                        service.enablePin(sv_pinPara, target.callback);
                    } else {
                        service.disablePin(sv_pinPara, target.callback);
                    }
                }
            }	
			

			// ȡ¼
            function sf_cancel() {
                target.pageState(pageState.common);
                target.pinStatus(target.originPinStatus());
                target.clear();
            }		

            // ҳͼϢ
			function sf_clear() {
                target.confirmPin("");			
                target.currentPin("");
                target.newPin("");
                target.puk("");
                clearValidateMsg();
            }	

            // ݣõǰҳ״̬
            function sf_computePageState(i_pinData) {
                if (i_pinData.pinnumber > 0) {
                    //ɹҳصʼ״̬ʧܲpinnumber>0,ҳ治ת
                    if (target.operateSuccessFlag) {
                        target.cancel();
                    } else {
                        target.clear();
                    }
                } else {
                    target.clear();
                    if (i_pinData.puknumber > 0) {
                        target.pageState(pageState.requirePuk);
                    } else {
                        target.pageState(pageState.destroyed);
                    }
                }
            }
			
            // PIN޸״̬¼
			function sf_displayModifyPinPage() {
                if (target.isConnectedNetWork()) {
                    showAlert("cannot_operate_when_connected");
                    return;
                }
                target.pinStatus(target.originPinStatus());
                target.pageState(pageState.modifyPin);
                target.clear();
            }
			
			// ҳԪصʹ״̬
			function sf_fixPageEnable() {
                if (target.isConnectedNetWork()) {
                    $('#frmPin :input').each(function () {
                        disableBtn($(this));
                    });
                    clearValidateMsg();
                } else {
                    $('#frmPin :input').each(function () {
                        if (this.id == "txtPin" || this.id == "btnPinApply") {
                            if (target.pageState() == pageState.common) {
                                disableBtn($(this));
                                return;
                            }
                        }
                        if (this.id == "btnModifyPin") {
                            if (target.originPinStatus() != pinStatus.enable) {
                                disableBtn($(this));
                                return;
                            }
                        }
                        if (this.id == "pinEnable" || this.id == "pinDisable") {
                            if (target.pageState() == pageState.modifyPin) {
                                disableBtn($(this));
                                return;
                            }
                        }
                        enableBtn($(this));
                    });

                }
            }
			
			// Ƿ
			function sf_isConnectedNetWork() {
                var info = service.getConnectionInfo();
                return info.connectStatus == "ppp_connected";
            }
			
            // PINʹܸıʱ¼
			function sf_pinStatusChangeEvent() {
                if (target.pinStatus() == target.originPinStatus()) {
                    target.pageState(pageState.common);
                } else {
                    target.pageState(pageState.requirePin);
                }
                target.clear();
            }
			
            target.changePin            = sf_changePin;
            target.cancel               = sf_cancel;
            target.clear                = sf_clear;	
            target.computePageState     = sf_computePageState;
			
            target.computePageState(sv_currentPinData);			
			
            target.displayModifyPinPage = sf_displayModifyPinPage;   
            target.fixPageEnable        = sf_fixPageEnable;		
            target.isConnectedNetWork   = sf_isConnectedNetWork;
			
            target.pinStatusChangeEvent = ko.dependentObservable(sf_pinStatusChangeEvent, this);			
        }

        function init(oldViewModel) {
		
            var fwVm = oldViewModel;		
		
            if (fwVm) {
                var sv_currentPinData = service.getPinData();
                fwVm.originPinStatus(sv_currentPinData.pin_status);
                fwVm.pinNumber(sv_currentPinData.pinnumber);
                fwVm.pukNumber(sv_currentPinData.puknumber);
                fwVm.computePageState(sv_currentPinData);
            } else {
                fwVm = new pinViewModel();
                addInterval(function () {
                    fwVm.fixPageEnable();
                }, 1000);
            }
			
            var container = $('#container')[0];
		    ko.cleanNode(container);
            ko.applyBindings(fwVm, container);
            fwVm.fixPageEnable();

            $('#frmPin').validate({
                submitHandler:function () {
                    fwVm.changePin();
                },
                rules:{
                    txtPuk:"puk_check",
                    txtPin:"pin_check",
                    txtNewPin:"pin_check",
                    txtConfirmPin:{equalToPin:"#txtNewPin"}
                }
            });
        }

        return {
            init:init
        }
    }
);

// 
define("adm_quick_set","jquery knockout set service underscore CryptoJS".split(" "),

    function ($, ko, config, service, _, CryptoJS) {

        var sv_wifiState = {ok:0, wps_on:1, wifi_off:2};
        var sv_apnMode   = {auto:"auto", manual:"manual"};
        var sv_minStep   = 1;
        var sv_maxStep   = 5;

        // ȡȨʽ
        function sf_fetchAuthenticationModes() {
            return _.map(config.APN_AUTH_MODES, function (item) {
                return new Option(item.name, item.value);
            });
        }
		
        // WIFIȫģʽѡ
        var sv_securityModes = _.map(config.WIFI_WEP_SUPPORT ? config.AUTH_MODES_WEP : config.AUTH_MODES, function (item) {
            return new Option(item.name, item.value);
        });


        function quickSettingViewModel() {
            var target = this;
			
            var sv_quickSettingInfo        = service.getQuickSettingInfo();

            target.currentStep            = ko.observable(sv_minStep);
            target.ipType                 = ko.observable(sv_quickSettingInfo.pdp_type == "IP" ? "IP" : sv_quickSettingInfo.ipv6_pdp_type);			
            target.supportIPv6            = config.IPV6_SUPPORT;
            target.supportIpv4AndIpv6     = config.IPV4_AND_V6_SUPPORT;

            target.wpsFlag                = ko.observable(sv_quickSettingInfo.WscModeOption);		

            function sf_apnDisabled() {
                return (sv_quickSettingInfo.apn_index < config.defaultApnSize || sv_quickSettingInfo.ppp_status == "ppp_connected" || sv_quickSettingInfo.ppp_status == "ppp_connecting");
            }

			function sf_apnModeDisabled() {
                return (sv_quickSettingInfo.ppp_status == "ppp_connected" || sv_quickSettingInfo.ppp_status == "ppp_connecting" || (!target.profileName() && target.apnMode() == sv_apnMode.auto));//ѡΪջӻ
            }	

            function sf_currAPN() {
                var sv_APNText = sv_quickSettingInfo["APN_configtmp" + sv_quickSettingInfo.apn_index];
                var strIPv6APN = sv_quickSettingInfo["ipv6_APN_configtmp" + sv_quickSettingInfo.apn_index];
				
                var sv_apn     = [];
                var sv_ipv6APNItems = [];
				
                if (sv_APNText) {
                    sv_apn = sv_APNText.split("($)");
                }

                if (strIPv6APN) {
                    sv_ipv6APNItems = strIPv6APN.split("($)");
                }

                return {
                    m_profile_name:sv_apn[0],
                    wan_apn:sv_apn[1],
                    ppp_auth_mode: sv_apn[4] == "" || typeof(sv_apn[4]) == "undefined" ? "" : sv_apn[4].toLowerCase(),					
                    ppp_username:sv_apn[5],
                    ppp_passtmp:sv_apn[6],						
                    pdp_type: sv_apn[7],			
                    ipv6_wan_apn:sv_ipv6APNItems[1],	
                    ipv6_ppp_auth_mode:typeof(sv_ipv6APNItems[4]) == "undefined" || sv_ipv6APNItems[4] == ""? "" : sv_ipv6APNItems[4].toLowerCase(),
                    ipv6_ppp_username:sv_ipv6APNItems[5],					
                    ipv6_ppp_passtmp:sv_ipv6APNItems[6],					
                    ipv6_pdp_type:sv_ipv6APNItems[7]			
                }
            }			
			
            // ǰAPN			
            target.currAPN                = ko.computed(sf_currAPN);
			
			target.apn                    = ko.observable(target.currAPN().wan_apn);
			target.ipv6_apn               = ko.observable(target.currAPN().ipv6_wan_apn);
            target.ipv6_selectedAuthMode  = ko.observable(target.currAPN().ipv6_ppp_auth_mode);				
            target.ipv6_username          = ko.observable(target.currAPN().ipv6_ppp_username);
            target.ipv6_password          = ko.observable(target.currAPN().ipv6_ppp_passtmp);			
			target.profileName            = ko.observable(target.currAPN().m_profile_name);	
			target.selectedAuthMode       = ko.observable(target.currAPN().ppp_auth_mode);
            target.username               = ko.observable(target.currAPN().ppp_username);
            target.password               = ko.observable(target.currAPN().ppp_passtmp);

            target.transAPN               = ko.observable("apn_ipv4_apn");
			target.transAPNIPv6           = ko.observable("apn_ipv6_apn");			
            target.transAuthMode          = ko.observable("apn_authentication_ipv4");
			target.transAuthModeIPv6      = ko.observable("apn_authentication_ipv6");
            target.transUserName          = ko.observable("apn_user_name_ipv4");
            target.transPassword          = ko.observable("apn_password_ipv4");     
            target.transUserNameIPv6      = ko.observable("apn_user_name_ipv6");
            target.transPasswordIPv6      = ko.observable("apn_password_ipv6");	

		
			
            target.apnDisabled            = ko.computed(sf_apnDisabled);
			target.apnMode                = ko.observable(sv_quickSettingInfo.apn_mode);	
            target.apnModeDisabled        = ko.computed(sf_apnModeDisabled);
            target.authModes              = ko.observableArray(sf_fetchAuthenticationModes());
 
            if (target.ipType() == "IPv6") {
                target.showIPv4 = false;
                target.showIPv6 = true;
                target.transAPNIPv6("apn");
                target.transAuthModeIPv6("apn_authentication");
                target.transUserNameIPv6("apn_user_name");
                target.transPasswordIPv6("apn_password");
            } else if (config.IPV4_AND_V6_SUPPORT && target.ipType() == "IPv4v6") {
                target.showIPv4 = true;
                target.showIPv6 = true;
                //ʹĬ
            } else if (target.ipType() == "IP" || target.ipType() == "IPv4") {
                target.showIPv4 = true;
                target.showIPv6 = false;
                target.transAPN("apn");
                target.transAuthMode("apn_authentication");
                target.transUserName("apn_user_name");
                target.transPassword("apn_password");
            } else { //pdp_type == "IPv4v6" && config.IPV4V6_SUPPORT
                target.showIPv4 = true;
                target.showIPv6 = false;
                target.transAPN("apn");
                target.transAuthMode("apn_authentication");
                target.transUserName("apn_user_name");
                target.transPassword("apn_password");
            }

            target.wifiDisabled                  = (sv_quickSettingInfo.wifi_cur_state != "1");
            target.ssid                          = ko.observable(sv_quickSettingInfo.SSID1);
            target.broadcast                     = ko.observable(sv_quickSettingInfo.HideSSID);
	    target.hasWifiWep                    = config.WIFI_WEP_SUPPORT;
	    target.hasWifiWpa3                   = config.WIFI_WAP3_SUPPORT;
	    target.hasWifiWpa23                  = config.WIFI_WPA2_WAP3_SUPPORT;

            target.securityModes                 = ko.observableArray(sv_securityModes);
            target.selectedSecurityMode          = ko.observable(sv_quickSettingInfo.AuthMode);
            target.WPAKey                        = ko.observable(sv_quickSettingInfo.WPAPSK1);

            target.apnMode_display               = ko.observable("");
			
            target.apnMode_trans                 = ko.computed(sf_apnMode_trans);
            target.selectedAuthMode_display      = ko.computed(sf_selectedAuthMode_display);
            target.ipv6_selectedAuthMode_display = ko.computed(sf_ipv6_selectedAuthMode_display);

            target.showWifiPassword              = ko.observable(false);
            target.showWifiPasswordHandler       = sf_showWifiPasswordHandler;
            
			//жǷ802 n only
			var sv_adInfo                        = service.getWifiAdvance();
			target.adBand                        = ko.observable(sv_adInfo.wifiBand);
			target.adMode                        = ko.observable(sv_adInfo.mode);
			
			target.encryptType                   = ko.observable(sv_quickSettingInfo.EncrypType);
			target.keyID                         = ko.observable(sv_quickSettingInfo.DefaultKeyID);
			target.wepPassword                   = ko.observable("");
			
			target.getWepPassword                = sf_getWepPassword;
			target.wepPassword(target.getWepPassword());
			target.profileChangeHandler          = sf_profileChangeHandler;
			
            target.broadcast_display             = ko.observable("");
            target.broadcast_trans               = ko.computed(sf_broadcast_trans);

            target.selectedSecurityMode_display  = ko.observable();   
            target.selectedSecurityMode_trans    = ko.computed(sf_selectedSecurityMode_trans);
			

            target.callback                      = sf_callback;
            target.next                          = sf_button_next;			
            target.previous                      = sf_button_previous;					
            target.save                          = sf_button_save;

			function sf_apnMode_trans() {
                if (sv_apnMode.auto == target.apnMode()) {
                    target.apnMode_display($.i18n.prop("apn_auto_apn"));
                    return "apn_auto_apn";
                } else {
                    target.apnMode_display($.i18n.prop("apn_manual_apn"));
                    return "apn_manual_apn";
                }
            }
			
			function sf_broadcast_trans() {
                if ("0" == target.broadcast()) {
                    target.broadcast_display($.i18n.prop("enable"));
                    return "enable";
                } else {
                    target.broadcast_display($.i18n.prop("disable"));
                    return "disable";
                }
            }
			
			function sf_button_next() {
                var currentStep = target.currentStep();
                var toStep = target.currentStep() + 1;
                sf_changeStep(toStep);
				
                if (currentStep == 1 && target.apnMode() == sv_apnMode.auto) {
                    toStep = target.currentStep() + 1;
                    sf_changeStep(toStep);
                }
            }
			
			function sf_button_previous() {
			
                var currentStep = target.currentStep();
                var toStep = target.currentStep() - 1;
				
                sf_changeStep(toStep);
				
                if (currentStep == 3 && target.apnMode() == sv_apnMode.auto) {
                    toStep = target.currentStep() - 1;
                    sf_changeStep(toStep);
                }
            }
			function sf_button_save() {
                var submit = function () {
                    sf_quickSetting4IPv6();
                };
                var result = sf_isDisabled_Wifi();
                if(result == sv_wifiState.wifi_off){
                    showConfirm("quick_setting_wifi_disable_confirm", submit);
                } else if (result == sv_wifiState.wps_on) {
                    showAlert("wps_on_info");
                } else{
                    showConfirm("quick_setting_param_changed_confirm", submit);//submit();
                }
            }
            // ύĻص
			function sf_callback(data) {
                if (data.result == "success") {
                    successOverlay();
                    location.hash = "#network_choose";
                }
                else {
                    errorOverlay();
                }
            }

            // 任ʱ
            function sf_changeStep(i_step) {
                if (i_step > sv_maxStep) {
                    i_step = sv_maxStep;
                } else if (i_step < sv_minStep) {
                    i_step = sv_minStep;
                }
				
                target.currentStep(i_step);
                return true;
            }			
		
			function sf_ipv6_selectedAuthMode_display() {
                var mode = target.ipv6_selectedAuthMode();
                return sf_getAuthModeNameByValue(mode);
            }
			// ݼȨģʽֵ
            function sf_getAuthModeNameByValue(authMode) {
                for (var i = 0; i < config.APN_AUTH_MODES.length; i++) {
                    if (authMode == config.APN_AUTH_MODES[i].value) {
                        return config.APN_AUTH_MODES[i].name;
                    }
                }
            }
			
			function sf_getWepPassword(){
				return target.keyID() == '3' ? sv_quickSettingInfo.Key4Str1 : (target.keyID() == '2' ? sv_quickSettingInfo.Key3Str1 : target.keyID() == '1' ? sv_quickSettingInfo.Key2Str1 : sv_quickSettingInfo.Key1Str1);
			}
			
            function sf_isDisabled_Wifi() {
                var s_wpsInfo = service.getWpsInfo();
                if(s_wpsInfo.radioFlag == "0"){
                    return sv_wifiState.wifi_off;
                }else if (s_wpsInfo.wpsFlag == '1') {
                    return sv_wifiState.wps_on;
                }
                return sv_wifiState.ok;
            }			
			function sf_profileChangeHandler(i_data, i_event) {
			    $("#pwdWepKey").parent().find("label[class='error']").hide();		
			    target.wepPassword(target.getWepPassword());
			    return true;
		    }
			
           // ύ(֧IPv6
            function sf_quickSetting4IPv6() {
                showLoading();
                var useIPv4ForV6 = config.IPV4V6_SUPPORT && target.currAPN().pdp_type == "IPv4v6";

                var ciphertext = "";
                if (config.PASSWORD_ENCODE) {
		    ciphertext = target.WPAKey();
		} else {
                    var kparam = service.getDeviceInfoLow();
                    var tkey = CryptoJS.enc.Latin1.parse(kparam.skey);
		    var tiv = CryptoJS.enc.Latin1.parse(kparam.siv);
                    ciphertext = CryptoJS.AES.encrypt(target.WPAKey(), tkey, {
                        iv: tiv,
                        mode: CryptoJS.mode.CBC,
                        padding: CryptoJS.pad.ZeroPadding
                        }).toString();
		}
				
                var s_quickSettingParameters = {
                    apn_index: sv_quickSettingInfo.apn_index,
                    apnMode: target.apnMode(),		
                    Encryption_Mode_hid: target.selectedSecurityMode(),	
                    ipv6_ppp_auth_mode: useIPv4ForV6 ? target.selectedAuthMode() : target.ipv6_selectedAuthMode(),
                    ipv6_ppp_username: useIPv4ForV6 ? target.username() : target.ipv6_username(),
                    ipv6_ppp_passtmp: useIPv4ForV6 ? target.password() : target.ipv6_password(),	
                    ipv6_wan_apn: useIPv4ForV6 ? target.apn() : target.ipv6_apn(),					
                    pdp_type: target.ipType(),
                    ppp_auth_mode: target.selectedAuthMode(),
                    ppp_username: target.username(),
                    ppp_passtmp: target.password(),
                    profile_name: target.profileName(),
                    //Ŀǰģʽֻ2֣3Ϊ̶ֵ
                    //ҪΪ5ֵ֣Ҫ
                    security_shared_mode: "NONE",					
                    SSID_Broadcast: target.broadcast(),
                    SSID_name: target.ssid(),
                    wan_apn: target.apn(),		
                    wep_default_key: 0,				
                    WPA_ENCRYPTION_hid: target.selectedSecurityMode() == "OPEN" ? "NONE" : target.selectedSecurityMode() == "WPA2PSK" ? 1 : 2,					
                    WPA_PreShared_Key: ciphertext
                }
				
				s_quickSettingParameters.wep_default_key = target.keyID();	
				
				if(target.encryptType() == "SHARED" || target.selectedSecurityMode() == "WEP") {
				
					s_quickSettingParameters.security_shared_mode = "WEP";
					
                    s_quickSettingParameters.wep_key_1 = sv_quickSettingInfo.Key1Str1;
					s_quickSettingParameters.wep_key_2 = sv_quickSettingInfo.Key2Str1;
					s_quickSettingParameters.wep_key_3 = sv_quickSettingInfo.Key3Str1;
					s_quickSettingParameters.wep_key_4 = sv_quickSettingInfo.Key4Str1;
					
					var WEPSelectTmp = '0';
					
                    if(target.wepPassword().length =='5' ||target.wepPassword().length =='13'){
						WEPSelectTmp = '1';	
					}else{
						WEPSelectTmp = '0';	
					}	
					
					if(target.keyID() =='3'){
						s_quickSettingParameters.wep_key_4  = target.wepPassword();
						s_quickSettingParameters.WEP4Select = WEPSelectTmp;						
					}else if(target.keyID() =='2'){	
						s_quickSettingParameters.wep_key_3  = target.wepPassword();
						s_quickSettingParameters.WEP3Select = WEPSelectTmp;						
					}else if(target.keyID() =='1'){						
						s_quickSettingParameters.wep_key_2  = target.wepPassword();
						s_quickSettingParameters.WEP2Select = WEPSelectTmp;					
					}else{
						s_quickSettingParameters.wep_key_1  = target.wepPassword();
						s_quickSettingParameters.WEP1Select = WEPSelectTmp;					
					}					
				}else if(target.encryptType() == "WPAPSKWPA2PSK") {
					s_quickSettingParameters.security_shared_mode = "NONE";
				}else {
					s_quickSettingParameters.security_shared_mode = "NONE";
				}
				
                service.setQuickSetting4IPv6(s_quickSettingParameters, target.callback);
            }			
			
			function sf_selectedAuthMode_display() {
                var mode = target.selectedAuthMode();
                return sf_getAuthModeNameByValue(mode);
            }
			
            function sf_selectedSecurityMode_trans() {
                var mode = target.selectedSecurityMode();
				var modesOption = config.WIFI_WEP_SUPPORT ? config.AUTH_MODES_WEP : config.AUTH_MODES;
                for (var i = 0; i < modesOption.length; i++) {
                    if (mode == modesOption[i].value) {
                        target.selectedSecurityMode_display($.i18n.prop("security_mode_" +  modesOption[i].value));
                        return "security_mode_" +  modesOption[i].value;
                    }
                }
            }
			
			function sf_showWifiPasswordHandler(){
				$("#pwdWepKey").parent().find(".error").hide();
                $("#codeWPAKey").parent().find(".error").hide();
                var checkbox = $("#showWifiPassword:checked");
                if(checkbox && checkbox.length == 0){
                    target.showWifiPassword(true);
                }else{
                    target.showWifiPassword(false);
                }
            }			
			
        }

        function init() {
            var container = $('#container');
            ko.cleanNode(container[0]);
            var fwVm = new quickSettingViewModel();
            ko.applyBindings(fwVm, container[0]);
            
            $('#quickSettingForm').validate({
                submitHandler:function () {
                    if (fwVm.currentStep() < 5) {
                        fwVm.next();
                    } else {
                        fwVm.save();
                    }
                },
                rules:{
                    txtAPN:"apn_check",
                    txtIPv6APN:"apn_check",
                    txtSSID:'ssid',
                    pwdWepKey:{wifi_wep_password_check:true,wifi_password_check: true},
                    txtWepKey:{wifi_wep_password_check:true,wifi_password_check: true},
                    txtWPAKey:'wifi_password_check',
                    codeWPAKey:'wifi_password_check',
                    txtUserName:'ppp_username_check',
                    txtIPv6UserName:'ppp_username_check',
                    txtSecretCode:"ppp_secretcode_check",
                    txtIPv6SecretCode:"ppp_secretcode_check"
                },
                errorPlacement:function (error, element) {
                    var id = element.attr("id");
                    if (id == "pwdWepKey" || id == "txtWepKey"){
						error.insertAfter("#lblShowWepPassword");
					} else if (id == "txtWPAKey" || id == "codeWPAKey") {
                        error.insertAfter("#lblShowWifiPassword");
                    } else {
                        error.insertAfter(element);
                    }
                }
            });
        }

        return {
            init:init
        };
    }
);

define("main","set service knockout underscore jquery statusBar echarts".split(" "), function (set, fnc, libko, libus, libjq, barStat, echarts) {

    var chartOptions = {
        color: ['red', 'red', 'red', 'red', 'red'],	
        series: [{
                name: '',
                type: 'pie',
                radius: ['0', '72'],
                itemStyle: {
                    normal: {
                        label: {
                            show: false
                        },
                        labelLine: {
                            show: false
                        }
                    }
                },
                data: [],
                selectedOffset: 3
            }
        ],
		animation: false,
        title: {
            text: '',
            x: 'center',
            y: 'center',
            itemGap: 0,
            textStyle: {
                color: '#FFF',
                fontFamily: '΢ź',
                fontSize: 20,
                fontWeight: 'bolder'
            },
            subtextStyle: {
                color: '#FFF',
                fontFamily: '΢ź',
                fontSize: 16,
                fontWeight: 'bolder'
            }
        },
        tooltip: {
            formatter: "{b}"
        },
    };
	var languageOld = window.language;
	var num_refresh = 0;
	var traffic_graphic_chart = null;
    var connStat = {
        CONNECTED: 1,
        DISCONNECTED: 2,
        CONNECTING: 3,
        DISCONNECTING: 4
    };
	function init() {
        num_refresh = 0;
        homeUtil.oldUsedData = null;
        homeUtil.oldAlarmData = null;
        traffic_graphic_chart = echarts.init(libjq("#traffic_graphic")[0]);
        var container = libjq('#container')[0];
        libko.cleanNode(container);
        var tmp = new VmHome();
        libko.applyBindings(tmp, container);
		var data = fnc.getLoginData();
		var psw_flg = data.psw_changed;
		if (psw_flg != "1") {
			showConfirm("password_note_first_change", function () {
                    window.location.hash = '#pwd_mode';
                });
			return;
		}										
    }
    
    var homeUtil = {
        initStatus: null,
        initShownStatus: function (data) {
            this.initStatus = {};
            var ipv6Mode = data.ipv6PdpType.toLowerCase().indexOf("v6") > 0;
            if (set.RJ45_SUPPORT) {
                var mode = checkCableMode(data.blc_wan_mode);
                if (mode) {
                    this.initStatus.showIpv6WanIpAddr = false;
                    this.initStatus.showIpv4WanIpAddr = true;
                } else if (set.IPV6_SUPPORT) {
                    if (data.pdpType == "IP") {
                        this.initStatus.showIpv6WanIpAddr = false;
                        this.initStatus.showIpv4WanIpAddr = true;
                    } else if (ipv6Mode) {
                        if (data.ipv6PdpType == "IPv6") {
                            this.initStatus.showIpv6WanIpAddr = true;
                            this.initStatus.showIpv4WanIpAddr = false;
                        } else {
                            this.initStatus.showIpv6WanIpAddr = true;
                            this.initStatus.showIpv4WanIpAddr = true;
                        }
                    }
                } else {
                    this.initStatus.showIpv6WanIpAddr = false;
                    this.initStatus.showIpv4WanIpAddr = true;
                }
            } else {
                if (set.IPV6_SUPPORT) {
                    if (data.pdpType == "IP") {
                        this.initStatus.showIpv6WanIpAddr = false;
                        this.initStatus.showIpv4WanIpAddr = true;
                    } else if (ipv6Mode) {
                        if (data.ipv6PdpType == "IPv6") {
                            this.initStatus.showIpv6WanIpAddr = true;
                            this.initStatus.showIpv4WanIpAddr = false;
                        } else {
                            this.initStatus.showIpv6WanIpAddr = true;
                            this.initStatus.showIpv4WanIpAddr = true;
                        }
                    }
                } else {
                    this.initStatus.showIpv6WanIpAddr = false;
                    this.initStatus.showIpv4WanIpAddr = true;
                }
            }
        },
        wanIpGet: function (data) {
            var addrInfo = {
                wanIpAddress: '',
                ipv6WanIpAddress: ''
            };
            addrInfo.wanIpAddress = verifyDeviceInfo(data.wanIpAddress);
            addrInfo.ipv6WanIpAddress = verifyDeviceInfo(data.ipv6WanIpAddress);
            return addrInfo;
        },
        cachedAPStationBasic: null,
        cachedConnectionMode: null,
        getCanConnectNetWork: function (param) {
            var status = fnc.getStatusInfo();
            if (status.simStatus != "modem_init_complete") {
                return false;
            }
            var typeNetworkTmp = status.networkType.toLowerCase();
            if (typeNetworkTmp == 'searching') {
                return false;
            }
            if (typeNetworkTmp == '' || typeNetworkTmp == 'limited service') {
                typeNetworkTmp = 'limited_service';
            }
            if (typeNetworkTmp == 'no service') {
                typeNetworkTmp = 'no_service';
            }
            if (typeNetworkTmp == 'limited_service' || typeNetworkTmp == 'no_service') {
                if (param.cStatus() != connStat.CONNECTED) {
                    return false;
                }
            }
            if (set.AP_STATION_SUPPORT) {
                if (status.connectWifiStatus == "connect") {
                    if (status.ap_station_mode == "wifi_pref") {
                        return false;
                    }
                }
            }
            return true;
        },
        doConnect: function () {
            showLoading('connecting');
            fnc.connect({}, function (data) {
                if (data.result) {
                    successOverlay();
                } else {
                    errorOverlay();
                }
            });
        },
        refreshHomeData: function (param) {
            var info = fnc.getConnectionInfo();
            param.connectStatus(info.connectStatus);
            param.canConnect(this.getCanConnectNetWork(param));
            param.networkType(homeUtil.getNetworkType(info.networkType));
            if (info.connectStatus == "ppp_connected") {
                param.current_Flux(transUnit(parseInt(info.data_counter.currentReceived, 10) + parseInt(info.data_counter.currentSent, 10), false));
                param.connected_Time(transSecond2Time(info.data_counter.currentConnectedTime));
                param.up_Speed(transUnit(info.data_counter.uploadRate, true));
                param.down_Speed(transUnit(info.data_counter.downloadRate, true));
            } else {
                param.current_Flux(transUnit(0, false));
                param.connected_Time(transSecond2Time(0));
                param.up_Speed(transUnit(0, true));
                param.down_Speed(transUnit(0, true));
            }
            param.trafficAlertEnable(info.limitVolumeEnable);
            if (info.limitVolumeEnable) {
                if (info.limitVolumeType == '1') {
                    param.trafficUsed(transUnit(parseInt(info.data_counter.monthlySent, 10) + parseInt(info.data_counter.monthlyReceived, 10), false));
                    param.trafficLimited(transUnit(info.limitDataMonth, false));
                } else {
                    param.trafficUsed(transSecond2Time(info.data_counter.monthlyConnectedTime));
                    param.trafficLimited(transSecond2Time(info.limitTimeMonth));
                }
            }
            if (languageOld != window.language) {
                languageOld = window.language;
                num_refresh = 1;
            }
            if (param.showTraffic()) {
                homeUtil.updateEcharts(info);
            } else {
                homeUtil.allFreeEcharts();
            }
            homeUtil.refreshStationInfo(param);
        },
        allFreeEcharts: function () {
            var usedData = homeUtil.data.free;
            usedData.value = 1;
            usedData.selected = false;
            usedData.name = libjq.i18n.prop("echarts_no");
            chartOptions.series[0].data = [usedData];
            chartOptions.title.text = '';
            homeUtil.setEcharts(chartOptions, libjq.i18n.prop("echarts_no"));
        },
        getNetworkType: function (networkType) {
            var typeNetworkTmp = networkType.toLowerCase();
            if (typeNetworkTmp == '' || typeNetworkTmp == 'limited service') {
                typeNetworkTmp = 'limited_service';
            }
            if (typeNetworkTmp == 'no service') {
                typeNetworkTmp = 'no_service';
            }
            if (typeNetworkTmp == 'limited_service' || typeNetworkTmp == 'no_service') {
                return libjq.i18n.prop("network_type_" + typeNetworkTmp);
            } else {
                return networkType;
            }
        },
        data: {
            full: {
                value: 30,
                name: '',
                itemStyle: {
                    normal: {
                        color: '#DF4313'
                    }
                }
            },		
            used: {
                value: 30,
                name: 'ʹ',
                itemStyle: {
                    normal: {
                        color: '#8CC916'
                    }
                }
            },
            left1: {
                value: 50,
                name: 'ֵδʹ',
                itemStyle: {
                    normal: {
                        color: '#D8D8D8'
                    }
                }
            },
            free: {
                value: 50,
                name: 'δʹ',
                itemStyle: {
                    normal: {
                        color: '#D8D8D8'
                    }
                }
            },
            alert: {
                value: 1,
                name: 'ֵ',
                itemStyle: {
                    normal: {
                        color: '#FF5500'
                    }
                }
            },
            alarm: {
                value: 19.7,
                name: '',
                itemStyle: {
                    normal: {
                        color: '#8CC916'
                    }
                }
            },
            start: {
                value: 50,
                name: 'ֵδʹ',
                itemStyle: {
                    normal: {
                        color: '#D8D8D8'
                    }
                }
            },
        },
		getDataInfo: function (value) {
            return {
                data: /\d+(.\d+)?/.exec(value)[0],
                unit: /[A-Z]{1,2}/.exec(value)[0]
            }
        },
        oldAlarmData: null,
        oldUsedData: null,
        updateEcharts: function (info) {
            var startName = libjq.i18n.prop("echarts_no");
            num_refresh++;
            if (num_refresh % 10 != 2) {
                return false;
            }
            var total = 0,
            used = 0,
            reach = 0,
            left = 0,
            alarm = 0,
            left1 = 0;
            if (info.limitVolumeEnable) {
                startName = libjq.i18n.prop("echarts_used");
                chartOptions.series[0].data = [];
                if (info.limitVolumeType == '1') {
                    var limitedDataFormatted = transUnit(info.limitDataMonth, false);
                    chartOptions.series[0].data = [];
                    if (info.limitDataMonth == 0) {
                        var usedData = homeUtil.data.used;
                        usedData.value = 1;
                        usedData.selected = false;
                        usedData.name = libjq.i18n.prop("echarts_used");
                        chartOptions.series[0].data.push(usedData);
                    } else {
                        var dataInfo = homeUtil.getDataInfo(limitedDataFormatted);
                        total = dataInfo.data * homeUtil.getUnitValue(dataInfo.unit) * 1048576;
                        used = parseInt(info.data_counter.monthlySent, 10) + parseInt(info.data_counter.monthlyReceived, 10);
                        reach = total * info.limitVolumePercent / 100;
                        if (used >= total) {
                            var fullData = homeUtil.data.full;
                            fullData.value = 100;
                            fullData.name = libjq.i18n.prop("echarts_full");
                            chartOptions.series[0].data.push(fullData);
                            startName = libjq.i18n.prop("echarts_full");
                        } else {
                            if (reach - used > 0) {
                                left1 = reach - used;
                                left = total - reach;
                            } else {
                                alarm = used - reach;
                                left = total - used;
                            }
                            var usedData = homeUtil.data.used;
                            if (reach - used > 0) {
                                usedData.value = used;
                            } else {
                                usedData.value = reach;
                            }
                            usedData.name = libjq.i18n.prop("echarts_used");
                            chartOptions.series[0].data.push(usedData);
                            if (left1 > 0) {
                                var left1Data = homeUtil.data.left1;
                                left1Data.value = left1;
                                left1Data.name = libjq.i18n.prop("echarts_left1");
                                chartOptions.series[0].data.push(left1Data);
                            }
                            var alertData = homeUtil.data.alert;
                            alertData.value = total / 200;
                            alertData.name = libjq.i18n.prop("echarts_alert");
                            chartOptions.series[0].data.push(alertData);
                            if (alarm > 0) {
                                var alarmData = homeUtil.data.alarm;
                                alarmData.value = alarm;
                                alarmData.name = libjq.i18n.prop("echarts_alarm");
                                chartOptions.series[0].data.push(alarmData);
                            }
                            var freeData = homeUtil.data.free;
                            freeData.value = left;
                            freeData.name = libjq.i18n.prop("echarts_free");
                            chartOptions.series[0].data.push(freeData);
                        }
                    }
                } else {
                    chartOptions.series[0].data = [];
                    if (info.limitTimeMonth == 0) {
                        var usedData = homeUtil.data.used;
                        usedData.value = 1;
                        usedData.selected = false;
                        usedData.name = libjq.i18n.prop("echarts_used");
                        chartOptions.series[0].data.push(usedData);
                    } else {
                        total = info.limitTimeMonth;
                        used = info.data_counter.monthlyConnectedTime;
                        reach = total * info.limitVolumePercent / 100;
                        if (used >= total) {
                            var fullTime = homeUtil.data.full;
                            fullTime.value = 100;
                            fullTime.name = libjq.i18n.prop("echarts_full");
                            chartOptions.series[0].data.push(fullTime);
                            startName = libjq.i18n.prop("echarts_full");
                        } else {
                            if (reach - used > 0) {
                                left1 = reach - used;
                                left = total - reach;
                            } else {
                                alarm = used - reach;
                                left = total - used;
                            }
                            var usedTime = homeUtil.data.used;
                            if (reach - used > 0) {
                                usedTime.value = used;
                            } else {
                                usedTime.value = reach;
                            }
                            usedTime.name = libjq.i18n.prop("echarts_used");
                            chartOptions.series[0].data.push(usedTime);
                            if (left1 > 0) {
                                var left1Time = homeUtil.data.left1;
                                left1Time.value = left1;
                                left1Time.name = libjq.i18n.prop("echarts_left1");
                                chartOptions.series[0].data.push(left1Time);
                            }
                            var alertTime = homeUtil.data.alert;
                            alertTime.value = total / 200;
                            alertTime.name = libjq.i18n.prop("echarts_alert");
                            chartOptions.series[0].data.push(alertTime);
                            if (alarm > 0) {
                                var alarmTime = homeUtil.data.alarm;
                                alarmTime.value = alarm;
                                alarmTime.name = libjq.i18n.prop("echarts_alarm");
                                chartOptions.series[0].data.push(alarmTime);
                            }
                            var freeTime = homeUtil.data.free;
                            freeTime.value = left;
                            freeTime.name = libjq.i18n.prop("echarts_free");
                            chartOptions.series[0].data.push(freeTime);
                        }
                    }
                }
            } else {
                var usedData = homeUtil.data.used;
                usedData.value = 1;
                usedData.selected = false;
                usedData.name = libjq.i18n.prop("echarts_no");
                chartOptions.series[0].data = [usedData];
                chartOptions.title.text = '';
            }
            var firstEle = libus.find(chartOptions.series[0].data, function (n) {
                return n.name == libjq.i18n.prop("echarts_used");
            });
            var alarmEle = libus.find(chartOptions.series[0].data, function (n) {
                return n.name == libjq.i18n.prop("echarts_alarm");
            });
            if (!alarmEle) {
                alarmEle = {
                    value: 0
                };
            }
            if (typeof firstEle == "undefined") {
                homeUtil.setEcharts(chartOptions, startName);
            } else if (homeUtil.oldUsedData != firstEle.value || homeUtil.oldAlarmData != alarmEle.value) {
                homeUtil.oldUsedData = firstEle.value;
                homeUtil.oldAlarmData = alarmEle.value;
                homeUtil.setEcharts(chartOptions, startName);
            }
        },
        getUnitValue: function (unit) {
            unit = unit.toUpperCase();
            if (unit == 'GB') {
                return '1024';
            } else if (unit == 'TB') {
                return '1048576';
            } else {
                return '1';
            }
        },		
        setEcharts: function (options, startName) {
            var startPart = homeUtil.data.start;
            startPart.value = 0;
            startPart.name = startName;
            startPart.selected = false;
            var arr = [startPart].concat(options.series[0].data);
            options.series[0].data = arr;
            traffic_graphic_chart.setOption(options, true);
            addTimeout(function () {
                traffic_graphic_chart.resize();
            }, 1000);
        },
        refreshStationInfo: function (param) {
            param.wirelessDeviceNum(fnc.getStatusInfo().wirelessDeviceNum);
            if (num_refresh % 10 == 2) {
                fnc.getAttachedCableDevices({}, function (data) {
                    param.wireDeviceNum(data.attachedDevices.length);
                });
            }
        },		
        getUnit: function (val) {
            if (val == '1024') {
                return 'GB';
            } else if (val == '1048576') {
                return 'TB';
            } else {
                return 'MB';
            }
        },
        refreshOpmodeInfo: function (param) {
            var obj = fnc.getOpMode();
            param.isLoggedIn(obj.loginfo == "ok");
            var currentMode = checkCableMode(obj.blc_wan_mode);
            if (param.opCurMode() && !currentMode) {
                var data = fnc.getLoginData();
                var state = data.modem_main_state;
                if (state == "modem_sim_undetected" || state == "modem_undetected" || state == "modem_sim_destroy" || state == "modem_waitpin" || state == "modem_waitpuk" || state == "modem_imsi_waitnck") {
                    window.location.reload();
                    return;
                }
            }
            param.opCurMode(currentMode);
            if (currentMode && obj.ethwan_mode == "DHCP") {
                param.enableFlag(false);
            } else if ((!currentMode && obj.ppp_status != "ppp_disconnected") || (currentMode && obj.rj45_state != "idle" && obj.rj45_state != "dead")) {
                param.enableFlag(true);
            } else {
                param.enableFlag(false);
            }
            var mode = (obj.blc_wan_mode == "AUTO_PPP" || obj.blc_wan_mode == "AUTO_PPPOE") ? "AUTO" : obj.blc_wan_mode;
            var currentOpMode = "";
            switch (mode) {
            case "AUTO":
                currentOpMode = "opmode_auto";
                break;
            case "PPPOE":
                currentOpMode = "opmode_cable";
                break;
            case "PPP":
                currentOpMode = "opmode_gateway";
                break;
            default:
                break;
            }
            libjq("#opmode").attr("data-trans", currentOpMode).text(libjq.i18n.prop(currentOpMode));
            param.isShowHomeConnect(!currentMode);
            param.showTraffic(set.TRAFFIC_SUPPORT && !currentMode);
            param.isSupportQuicksetting(set.HAS_QUICK_SETTING && !currentMode);
        }
    };
	function VmHome() {
        var target = this;
        target.hasSms = set.HAS_SMS;
        target.hasPhonebook = set.HAS_PHONEBOOK;
        target.isSupportSD = set.SD_CARD_SUPPORT;
        target.isCPE = set.PRODUCT_TYPE == 'CPE';
        target.hasRj45 = set.RJ45_SUPPORT;
        target.notDataCard = set.PRODUCT_TYPE != 'DATACARD';
        target.hasParentalControl = set.HAS_PARENTAL_CONTROL;
        var wifiInfo = fnc.getWifiBasic();
        if (set.WIFI_SUPPORT_QR_SWITCH) {
            target.showQRCode = set.WIFI_SUPPORT_QR_CODE && wifiInfo.show_qrcode_flag;
        } else {
            target.showQRCode = set.WIFI_SUPPORT_QR_CODE;
        }
        target.qrcodeSrc = './pic/qrcode_ssid_wifikey.png?_=' + libjq.now();
        if (target.hasRj45) {
            var opModeObj = checkCableMode(fnc.getOpMode().blc_wan_mode);
            target.opCurMode = libko.observable(opModeObj);
            target.isShowHomeConnect = libko.observable(!opModeObj);
            target.showTraffic = libko.observable(set.TRAFFIC_SUPPORT && !opModeObj);
            target.isSupportQuicksetting = libko.observable(set.HAS_QUICK_SETTING && !opModeObj);
        } else {
            target.isShowHomeConnect = libko.observable(true);
            target.showTraffic = libko.observable(set.TRAFFIC_SUPPORT);
            target.isSupportQuicksetting = libko.observable(set.HAS_QUICK_SETTING);
        }
        if (set.PRODUCT_TYPE == 'DATACARD') {
            libjq('#home_image').addClass('data-card');
        }
        var info = fnc.getConnectionInfo();
        target.networkType = libko.observable(homeUtil.getNetworkType(info.networkType));
        target.connectStatus = libko.observable(info.connectStatus);
        target.canConnect = libko.observable(false);
        target.cStatus = libko.computed(function () {
            if (target.connectStatus().indexOf('_connected') != -1) {
                return connStat.CONNECTED;
            } else if (target.connectStatus().indexOf('_disconnecting') != -1) {
                return connStat.DISCONNECTING;
            } else if (target.connectStatus().indexOf('_connecting') != -1) {
                return connStat.CONNECTING;
            } else {
                return connStat.DISCONNECTED;
            }
        });
        target.current_Flux = libko.observable(transUnit(0, false));
        target.connected_Time = libko.observable(transSecond2Time(0));
        target.up_Speed = libko.observable(transUnit(0, true));
        target.down_Speed = libko.observable(transUnit(0, true));
        target.isLoggedIn = libko.observable(false);
        target.enableFlag = libko.observable(true);
        target.simSerialNumber = libko.observable('');
        target.imei = libko.observable('');
        target.imsi = libko.observable('');
        target.ssid = libko.observable('');
        target.hasWifi = set.HAS_WIFI;
        target.showMultiSsid = libko.observable(set.HAS_MULTI_SSID && wifiInfo.multi_ssid_enable == "1");
        target.trafficAlertEnable = libko.observable(false);
        target.trafficUsed = libko.observable('');
        target.trafficLimited = libko.observable('');
        target.wireDeviceNum = libko.observable(fnc.getAttachedCableDevices().attachedDevices.length);
        target.wirelessDeviceNum = libko.observable(fnc.getStatusInfo().wirelessDeviceNum);
        target.showOpModeWindow = function () {
            if (target.enableFlag()) {
                return;
            }
            showSettingWindow("change_mode", "opmode_popup", "opmode_popup", 400, 300, function () {});
        };
        target.currentOpMode = libko.observable("0");
        var popoverShown = false;
        libjq('#showDetailInfo').popover({
            html: true,
            placement: 'top',
            trigger: 'focus',
            title: function () {
                return libjq.i18n.prop('device_info')
            },
            content: function () {
                return getDetailInfoContent();
            }
        }).on('shown.bs.popover', function () {
            popoverShown = true;
        }).on('hidden.bs.popover', function () {
            popoverShown = false;
        });
        function fetchDeviceInfo() {
            var data = fnc.getDeviceInfo();
            target.simSerialNumber(verifyDeviceInfo(data.simSerialNumber));
            target.imei(verifyDeviceInfo(data.imei));
            target.imsi(verifyDeviceInfo(data.imsi));
            target.ssid(verifyDeviceInfo(data.ssid));
            target.showMultiSsid(set.HAS_MULTI_SSID && data.multi_ssid_enable == "1");
            return data;
        }
        fetchDeviceInfo();
        function getDetailInfoContent() {
            var data = fetchDeviceInfo();
            homeUtil.initShownStatus(data);
            var addrInfo = homeUtil.wanIpGet(data);
            var compiled = libus.template(libjq("#detailInfoTmpl").html());
            var tmpl = compiled({
                simSerialNumber: verifyDeviceInfo(data.simSerialNumber),
                imei: verifyDeviceInfo(data.imei),
                imsi: verifyDeviceInfo(data.imsi),
                signal: signalFormat(data.signal),
                hasWifi: set.HAS_WIFI,
                isCPE: set.PRODUCT_TYPE == 'CPE',
                hasRj45: set.RJ45_SUPPORT,
                showMultiSsid: set.HAS_MULTI_SSID && data.multi_ssid_enable == "1",
                ssid: verifyDeviceInfo(data.ssid),
                max_access_num: verifyDeviceInfo(data.max_access_num),
                m_ssid: verifyDeviceInfo(data.m_ssid),
                m_max_access_num: verifyDeviceInfo(data.m_max_access_num),
                wifi_long_mode: "wifi_des_" + data.wifiRange,
                lanDomain: verifyDeviceInfo(data.lanDomain),
                ipAddress: verifyDeviceInfo(data.ipAddress),
                showMacAddress: set.SHOW_MAC_ADDRESS,
                macAddress: verifyDeviceInfo(data.macAddress),
                showIpv4WanIpAddr: homeUtil.initStatus.showIpv4WanIpAddr,
                wanIpAddress: addrInfo.wanIpAddress,
                showIpv6WanIpAddr: homeUtil.initStatus.showIpv6WanIpAddr,
                ipv6WanIpAddress: addrInfo.ipv6WanIpAddress,
                sw_version: verifyDeviceInfo(data.sw_version),
                hw_version: verifyDeviceInfo(data.hw_version)
            });
            return libjq(tmpl).translate();
        }
        target.connectHandler = function () {
            if (target.connectStatus() == "ppp_connected") {
                showLoading('disconnecting');
                fnc.disconnect({}, function (data) {
                    if (data.result) {
                        successOverlay();
                    } else {
                        errorOverlay();
                    }
                });
            } else {
                if (fnc.getStatusInfo().roamingStatus) {
                    showConfirm('dial_roaming_connect', function () {
                        target.connect();
                    });
                } else {
                    target.connect();
                }
            }
        };
        target.connect = function () {
            var statusInfo = fnc.getStatusInfo();
            var trafficResult = barStat.getTrafficResult(statusInfo);
            if (statusInfo.limitVolumeEnable && trafficResult.showConfirm) {
                var confirmMsg = null;
                if (trafficResult.usedPercent > 100) {
                    confirmMsg = {
                        msg: 'traffic_beyond_connect_msg'
                    };
                    barStat.setTrafficAlertPopuped(true);
                } else {
                    confirmMsg = {
                        msg: 'traffic_limit_connect_msg',
                        params: [trafficResult.limitPercent]
                    };
                    barStat.setTrafficAlert100Popuped(false);
                }
                showConfirm(confirmMsg, function () {
                    homeUtil.doConnect();
                });
            } else {
                homeUtil.doConnect();
            }
        };
        fnc.getSignalStrength({}, function (data) {
            var signalTxt = signalFormat(convertSignal(data));
            libjq("#fresh_signal_strength").text(signalTxt);
            if (popoverShown) {
                libjq("#popoverSignalTxt").text(signalTxt);
            }
        });
        homeUtil.refreshHomeData(target);
        addInterval(function () {
            fnc.getSignalStrength({}, function (data) {
                var signalTxt = signalFormat(convertSignal(data));
                libjq("#fresh_signal_strength").text(signalTxt);
                if (popoverShown) {
                    libjq("#popoverSignalTxt").text(signalTxt);
                }
            });
            homeUtil.refreshHomeData(target);
        }, 1000);
        if (target.hasRj45) {
            homeUtil.refreshOpmodeInfo(target);
            addInterval(function () {
                homeUtil.refreshOpmodeInfo(target);
            }, 1000);
        }
        target.showNetworkSettingsWindow = function () {
            if (target.hasRj45) {
                fnc.getOpMode({}, function (data) {
                    var mode = checkCableMode(data.blc_wan_mode);
                    if (mode) {
                        window.location.hash = '#network_set';
                    } else {
                        window.location.hash = '#conn_set';
                    }
                });
            } else {
                window.location.hash = '#conn_set';
            }
        }
    };
    return {
        init: init
    };
});


define("language","knockout service jquery set underscore".split(" "), 
    function(ko, service, $, config, _) {

    //  ȡǰ
    function getCurrentLanguage() {
        return service.getLanguage();
    }		

    //  Դҳϵbody
    //  @param {String} current :zh-cn
    function loadLanguageAndRefresh(current){
        window.CURRENT_LANGUAGE = current;
        $("body").attr('lang', current);
        $.i18n.properties({
            name:'Messages',
            path:'i18n/',
            mode:'map',
            cache: true,
            language:current,
            callback: function() {
                jQuery.validator.messages = $.i18n.map;
                $('body').translate();
            }
        });
    }
    
	window.language = null;
	

    function LanguageViewModel() {
        var target = this;
        var currentLan = getCurrentLanguage();
        var languages = _.map(config.LANGUAGES, function(item) {
            return new Option(item.name, item.value);
        });

        document.title = config.WEBUI_TITLE;
        if($('#webui_title')[0]) {
            $('#webui_title').html(config.WEBUI_TITLE);
        }

        target.languages   = ko.observableArray(languages);
        target.currentLan = ko.observable(currentLan.Language);
		window.language      = target.currentLan();

        //  л¼
        //  @event langChangeHandler 
        target.langChangeHandler = function(info, event) {
            clearValidateMsg();

            service.setLanguage({Language: target.currentLan()}, function() {
                loadLanguageAndRefresh(target.currentLan());
				window.language = target.currentLan();
            });
        };

        // бˢ½
        loadLanguageAndRefresh(target.currentLan());
    }

    //  ʼVM
    function init() {
        ko.applyBindings(new LanguageViewModel(), $('#language')[0]);
    }

    return {
        init: init
    };
});


// ½ ģ
define("entry","jquery knockout set service underscore menu logout CryptoJS".split(" "), 
	function($, ko,config, service, _, menu, logout, CryptoJS) {
	

        var pageState      = {LOGIN:0, WAIT_PIN:1, WAIT_PUK:2, PUK_LOCKED:3, LOGGEDIN:4, LOADING:5};
        var timer          = loginStatusCheckingTimer();
        var loginLockTimer = 0;
        var lastLoginStatus = "0";
        
        function loginViewModel() {
            var target        = this;
            var data        = service.getLoginData();
            var loginStatus = service.getLoginStatus();

            target.confirmPIN           = ko.observable();	
            target.leftSeconds          = ko.observable(0);				
            target.loginCount           = ko.observable(0);
            target.loginSecuritySupport = ko.observable(config.LOGIN_SECURITY_SUPPORT);
            target.newPIN               = ko.observable();			
            target.password             = ko.observable();
            target.PIN                  = ko.observable();
            target.pinNumber            = ko.observable(data.pinnumber);			
            target.PUK                  = ko.observable();
            target.pukNumber            = ko.observable(data.puknumber);	
            target.showEntrance         = ko.observable(false);
            target.sharePathInvalid     = ko.observable(false);			
            target.uiLoginTimer         = ko.observable(300);

            // ע˳򣬵ǰ޷ˢ³
            target.accountLocked        = ko.computed(function () {
                return target.loginCount() == config.MAX_LOGIN_COUNT && target.leftSeconds() != '-1';
            });			
			
            target.leftUnlockTime       = ko.computed(function () {
                target.leftSeconds();
                var formatted = transSecond2Time(target.uiLoginTimer());
                return formatted.substring(formatted.indexOf(':') + 1, formatted.length);
            });


            if(config.SD_CARD_SUPPORT){
                service.getSDConfiguration({}, function (data) {
                    target.showEntrance(data.sd_status == "1" && data.share_status == "1" && data.sd_mode == "0");
                    if(target.showEntrance()){
                        service.checkFileExists({
                            path: data.share_file
                        }, function (data1) {
                            if (data1.status == 'exist' || data1.status == 'processing') {
                                target.sharePathInvalid(false);
                            } else {
                                target.sharePathInvalid(true);
                            }
                        });
                    }
                });
            }

            var state = computePageState(loginStatus, data);
            target.pageState = ko.observable(state);
            if (state == pageState.LOADING) {
                addTimeout(refreshPage, 500);
            }
            setFocus();

            
            // login ¼
            
            target.login = function () {
                if(config.LOGIN_SECURITY_SUPPORT && target.accountLocked()){
                    showAlert("password_error_account_lock_time", function () {
                        setFocus();
                    });
                    return false;
                }
                target.pageState(pageState.LOADING);
                window.clearInterval(timer);
                var ciphertext = "";
                if (config.PASSWORD_ENCODE) {
		    ciphertext = target.password();
		} else {
                    var kparam = service.getDeviceInfoLow();
                    var tkey = CryptoJS.enc.Latin1.parse(kparam.skey);
		    var tiv = CryptoJS.enc.Latin1.parse(kparam.siv);
                    ciphertext = CryptoJS.AES.encrypt(target.password(), tkey, {
                        iv: tiv,
                        mode: CryptoJS.mode.CBC,
                        padding: CryptoJS.pad.ZeroPadding
                        }).toString();
		}
                service.login({
                    password:ciphertext
                }, function (info) {
                    setTimeout(function () {
                        timer = loginStatusCheckingTimer();
                    }, 1300);
                    if (info.result) {
                        target.pageState(pageState.LOGGEDIN);
                        if(config.LOGIN_SECURITY_SUPPORT){
                            target.loginCount(0);
                            target.uiLoginTimer(300);
                            clearInterval(loginLockTimer);
                        }
                        $("#container").empty();
                        window.location.hash = "#main";
                        logout.init();
                    } else {
                        target.password("");
                        if(config.LOGIN_SECURITY_SUPPORT){
                            target.checkLoginData(function(){
                                if (target.loginCount() == config.MAX_LOGIN_COUNT) {
                                    showAlert("password_error_five_times", function () {
                                        setFocus();
                                    });
                                    target.startLoginLockInterval();
                                } else {
                                    showAlert({msg: 'password_error_left', params: [config.MAX_LOGIN_COUNT - target.loginCount()]}, function () {
                                        setFocus();
                                    });
                                }
                            });
                        }else {
                            showAlert("password_error", function () {
                                setFocus();
                            });
                        }
                        target.pageState(pageState.LOGIN);
                    }
                });
            };

            

            
            // ȡ¼Ϣ          
            target.checkLoginData = function(cb){
                service.getLoginData({}, function(r){
                    var failTimes = parseInt(r.psw_fail_num_str, 10);
                    target.loginCount(config.MAX_LOGIN_COUNT - failTimes);
                    target.leftSeconds(r.login_lock_time);
                    target.uiLoginTimer(r.login_lock_time);
                    if($.isFunction(cb)){
                        cb();
                    } else if (target.loginCount() == config.MAX_LOGIN_COUNT) {
                        target.startLoginLockInterval();
                    }
                });
            };
            
            // ʱʱ
            target.startLoginLockInterval = function () {
                loginLockTimer = setInterval(function () {
                    service.getLoginData({}, function (data) {
                        if (data.login_lock_time <= 0 || data.psw_fail_num_str == 5) {
                            target.loginCount(0);
                            clearInterval(loginLockTimer);
                        }
                        if(target.leftSeconds() != data.login_lock_time){
                            target.leftSeconds(data.login_lock_time);
                            target.uiLoginTimer(data.login_lock_time);
                        } else {
                            target.uiLoginTimer(target.uiLoginTimer() > 0 ? target.uiLoginTimer() - 1 : 0);
                        }
                    });
                }, 1000);
            };            

            target.checkLoginData();


            
            // ֤PIN¼
            target.enterPIN = function () {
                target.pageState(pageState.LOADING);
                var pin = target.PIN();
                service.enterPIN({
                    PinNumber:pin
                }, function (data) {
                    if (!data.result) {
                        showAlert("pin_error", function () {
                            refreshPage();
                        });
                        target.PIN('');
                    } else {
                        refreshPage();
                    }
                });
            };

            function setFocus(){
                setTimeout(function () {
                    var txtAdmin = $('#txtAdmin:visible');
                    var txtPIN = $('#txtPIN:visible');
                    var txtPUK = $('#txtPUK:visible');
                    if (txtAdmin.length > 0) {
                        txtAdmin.focus();
                    } else if (txtPIN.length > 0) {
                        txtPIN.focus();
                    } else if (txtPUK.length > 0) {
                        txtPUK.focus();
                    }
                }, 100);
            }            

            
            // ˢҳ״̬           
            function refreshPage() {
                var data = service.getLoginData();
                var loginStatus = service.getLoginStatus();
                var state = computePageState(loginStatus, data);
                if (state == pageState.LOADING) {
                    addTimeout(refreshPage, 500);
                } else {
                    target.pageState(state);
                    target.pinNumber(data.pinnumber);
                    target.pukNumber(data.puknumber);
                }
                setFocus();
            }

            // PUKPIN¼
            target.enterPUK = function () {
                target.pageState(pageState.LOADING);
                var newPIN = target.newPIN();
                var confirmPIN = target.confirmPIN();
                var params = {};
                params.PinNumber = newPIN;
                params.PUKNumber = target.PUK();
                service.enterPUK(params, function (data) {
                    if (!data.result) {
                        showAlert("puk_error", function () {
                            refreshPage();
                        });
                        target.PUK('');
                        target.newPIN('');
                        target.confirmPIN('');
                    } else {
                        refreshPage();
                    }
                });
            };            



            // ݵ¼״̬SIM״̬ҳ״̬
            function checkPinAfterLogin(loginStatus, data) {
                if (loginStatus.status == "loggedIn") {
                    var currentState = data.modem_main_state; // cov_2
                    if (currentState == "modem_waitpin") {
                        return pageState.WAIT_PIN;
                    } else if ((currentState == "modem_waitpuk" || data.pinnumber == 0) && (data.puknumber != 0)) {
                        return pageState.WAIT_PUK;
                    } else if ((data.puknumber == 0 || currentState == "modem_sim_destroy")
                        && currentState != "modem_sim_undetected" && currentState != "modem_undetected") {
                        return pageState.PUK_LOCKED;
                    } else {
                        return pageState.LOGGEDIN;
                    }
                } else {
                    var currentState = data.modem_main_state;
                    if ($.inArray(currentState, config.TEMPORARY_MODEM_MAIN_STATE) != -1) {
                        return pageState.LOADING;
                    } else {
                        return pageState.LOGIN;
                    }
                }
            }			
            
            // ݵ¼״̬SIM״̬ҳ״̬
            function computePageState(loginStatus, data) {
                //PX-880 ȵ¼ٽPIN֤routerԭ򣬵¼PIN֤ڵ¼ҳУݿ֤һ¡
                if (config.LOGIN_THEN_CHECK_PIN) {
                    return checkPinAfterLogin(loginStatus, data);
                } else {
                    return loginAfterCheckPin(loginStatus, data);
                }
            }
			
            // ݵ¼״̬SIM״̬ҳ״̬
            function loginAfterCheckPin(loginStatus, data) {
                if (loginStatus.status == "loggedIn") {
                    return pageState.LOGGEDIN;
                } else {
                    var currentState = data.modem_main_state;
						if ($.inArray(currentState, config.TEMPORARY_MODEM_MAIN_STATE) != -1) {
							return pageState.LOADING;
						} else if (currentState == "modem_waitpin") {
							return pageState.WAIT_PIN;
						} else if ((currentState == "modem_waitpuk" || parseInt(data.pinnumber) === 0) && (parseInt(data.puknumber) != 0)) {
							return pageState.WAIT_PUK;
						} else if ((parseInt(data.puknumber) === 0 || currentState == "modem_sim_destroy") && currentState != "modem_sim_undetected" && currentState != "modem_undetected") {
							return pageState.PUK_LOCKED;
						} else {
							return pageState.LOGIN;
					}                    
                }
            }
        }
			
        
        // 鵱ǰwindow.location.hash쳣תindex.html      
        function gotoLogin() {
            if (window.location.hash != config.defaultRoute && _.indexOf(config.GUEST_HASH, window.location.hash) == -1) {
                if (!manualLogout && lastLoginStatus == "1") {
                    manualLogout = false;
                    lastLoginStatus = 'UNREAL';
                    showAlert('need_login_again', function () {
                        window.location = "index.html";
                    });
                } else if (lastLoginStatus == 'UNREAL') {
                    //do nothing, only popup need_login_again alert one time
                    return;
                } else {
                    window.location = "index.html";
                }
            }
        }
		
        // ʱ¼״̬      
        function loginStatusCheckingTimer() {
            return setInterval(function () {
                var info = service.getStatusInfo();
                if (!info.isLoggedIn) {
                    gotoLogin();
                    return;
                }
                lastLoginStatus = service.getStatusInfo().isLoggedIn ? "1" : "0";
            }, 1000);
        }	
		
        function init() {
            var info = service.getStatusInfo();
            if (info.isLoggedIn) {
                window.location.hash = '#main';
                return;
            }

            var container = $('#container')[0];
            ko.cleanNode(container);
            var fwVm = new loginViewModel();
            ko.applyBindings(fwVm, container);

            $('#frmLogin').validate({
                submitHandler:function () {
                    fwVm.login();
                },
                rules: {
                    txtAdmin: 'login_password_length_check'
                }
            });
            $('#frmPIN').validate({
                submitHandler:function () {
                    fwVm.enterPIN();
                },
                rules:{
                    txtPIN:"pin_check"
                }
            });
            $('#frmPUK').validate({
                submitHandler:function () {
                    fwVm.enterPUK();
                },
                rules:{
                    txtNewPIN:"pin_check",
                    txtConfirmPIN:{equalToPin:"#txtNewPIN"},
                    txtPUK:"puk_check"
                }
            });
        }
		
	
        return {
            init:init,
            gotoLogin:gotoLogin
        };
    });
	

// Logout ģ
define("logout","set service knockout underscore jquery".split(" "),
    function (config, service, ko, _, $) {

    function logoutViewModel() {
        var target = this;
        // ȡǷ¼
        var loginFlag = function () {
            var loginInfo = service.getLoginStatus();
            return (loginInfo.status == "loggedIn");
        }
        ();
        target.loggedIn = ko.observable(loginFlag);

        // ˳ϵͳ
        target.logout = function () {
            showConfirm("confirm_logout", function () {
                manualLogout = true;
                service.logout({}, setLocation());
            });
        };

        // Ƿʾ˳ť
        target.showLogout = function () {
            if (config.HAS_LOGIN) {
                return target.loggedIn();
            } else {
                return false;
            }
        };
    }
    function setLocation() {
        window.location = 'index.html';
    }
    function initialize() {
        var fwVm = new logoutViewModel();
        bindContainer(fwVm);
    }
    function bindContainer(fwVm) {
        var con = $('#logout')[0];
        ko.cleanNode(con);
        ko.applyBindings(fwVm, con);
    }
    return {
        init: initialize
    };
});

// operation mode ģ
define("opmode","knockout service jquery set underscore".split(" "),

    function (ko, service, $, config, _) {

	function currentOperationModeViewMode(){
		var target = this;
		target.isLoggedIn = ko.observable(false);	
		target.enableFlag = ko.observable(false);

		target.showOpModeWindow = function () {
			showSettingWindow("change_mode", "opmode_popup", "opmode_popup", 400, 300, function () {
			});
		};
		target.currentOpMode = ko.observable("0");
		
		service.getOpMode({}, function(info){
			target.isLoggedIn(info.loginfo == "ok");
			if (info.opms_wan_mode != "PPP" && info.rj45_state != "idle" && info.rj45_state != "dead") {
				target.enableFlag(false);
			} else if (info.opms_wan_mode == "PPP" && info.ppp_status != "ppp_disconnected") {
				target.enableFlag(false);
			} else if(info.opms_wan_mode == "DHCP"){
				target.enableFlag(true);
			} else {
				target.enableFlag(true);
			}
			
			var opmsWanMode = (info.opms_wan_mode == "DHCP" || info.opms_wan_mode == "STATIC") ? "PPPOE" : info.opms_wan_mode;
				
			var currentOperationMode = "";
			switch(opmsWanMode){
				case "BRIDGE":
					currentOperationMode = "opmode_bridge";
					break;
				case "PPP":
					currentOperationMode = "opmode_gateway";
					break;					
				case "PPPOE":
					currentOperationMode = "opmode_cable";
					break;
				default:
					break;
			}
			$("#opmode").attr("data-trans", currentOperationMode).text($.i18n.prop(currentOperationMode));
		});
        // ʱѯģʽ״̬ý״̬
		setInterval(function(){
			var object = service.getConnectionInfo();
			if(object.opms_wan_mode == "DHCP") {
				target.enableFlag(true);
			} else if((object.opms_wan_mode == "PPP" && object.ppp_status != "ppp_disconnected") || (object.opms_wan_mode != "PPP" && object.rj45_state != "idle" && object.rj45_state != "dead")) {
				target.enableFlag(false);
			} else {
				target.enableFlag(true);
			}
		}, 1000);
	}

	function init() {
		var container = $('#currentOpMode')[0];
        ko.cleanNode(container);
        var fwVm = new currentOperationModeViewMode();
        ko.applyBindings(fwVm, container);
	}

	return {
		init:init
	};
});

// operation mode popupģ

define("opmode_popup","knockout service jquery set underscore".split(" "),

    function (ko, service, $, config, _) {
   
    function operationModeViewMode() {
		var target = this;
		var currentSelectedOperationMode = "";
		target.selectedMode = ko.observable("0");	
		
	    // ʼģʽʾ	
		service.getOpMode({}, function(info){
			if(info.blc_wan_mode == "AUTO_PPP"){
                currentSelectedOperationMode = "AUTO";
            }else if(info.blc_wan_mode == "AUTO_PPPOE"){
                currentSelectedOperationMode = "AUTO";
            }else if(info.blc_wan_mode == "PPPOE"){
                currentSelectedOperationMode = "PPPOE";
            }else{
                currentSelectedOperationMode = info.blc_wan_mode;
            }
			target.selectedMode(currentSelectedOperationMode);
		});
		
	    // ģʽ/л	
		target.changeOpMode = function(){
			var userSelectedOperationMode = $('input:radio[name="opMode"]:checked').val();
            var messageText = "";
			if(userSelectedOperationMode == currentSelectedOperationMode) {
				hidePopupSettingWindow();
				return;
			}
            if(userSelectedOperationMode == "LTE_BRIDGE"){
                messageText = "opmode_msg3";
            }else{
                messageText = "opmode_msg2";
            }
			showConfirm(messageText, function(){
                showLoading();
				service.SetOperationMode({
					opMode: userSelectedOperationMode
				},function(info){
					if (info && info.result == "success") {
						var currentOperationMode = "";
						switch(userSelectedOperationMode){
							case "AUTO":
								currentOperationMode = "opmode_auto"
								break;
							case "PPP":
								currentOperationMode = "opmode_gateway";
								break;
							case "PPPOE":
								currentOperationMode = "opmode_cable";
								break;								
							default:
								break;
						}
						$("#opmode").attr("data-trans", currentOperationMode).text($.i18n.prop(currentOperationMode));
						successOverlay();						
					} else {
						errorOverlay();
					}
				});
			});
			
		}
		
	}

	function init() {
		var fwVm = new operationModeViewMode();
		ko.applyBindings(fwVm, $('#popupSettingWindow')[0]);
		
		$("#opmode_form").validate({
			submitHandler: function(){
				fwVm.changeOpMode();
			}
		});
	}

	return {
		init:init
	};
});

define("router","underscore jquery menu set service".split(" "),
    function (_, $, menu, config, service) {
    var currentHash = '';
    var container = $('#container');

    //뿪ʱǷ޸ģʾ
    checkFormContentModify = function (href) {
        if (config.CONTENT_MODIFIED.modified && window.location.hash != href) {
            if (config.CONTENT_MODIFIED.message == 'sms_to_save_draft') {
                config.CONTENT_MODIFIED.callback.ok(config.CONTENT_MODIFIED.data);
                config.resetContentModifyValue();
                window.location.hash = href;
            } else {
                showConfirm(config.CONTENT_MODIFIED.message, {
                    ok: function () {
                        config.CONTENT_MODIFIED.callback.ok(config.CONTENT_MODIFIED.data);
                        config.resetContentModifyValue();
                        window.location.hash = href;
                    },
                    no: function () {
                        var result = config.CONTENT_MODIFIED.callback.no(config.CONTENT_MODIFIED.data);
                        if (!result) {
                            window.location.hash = href;
                            config.resetContentModifyValue();
                        }
                    }
                });
            }
            return false;
        } else {
            return true;
        }
    };

    //ʱ鿴SIM״̬ǰSIM״̬Ϊ״̬δʾnosimcardҳ棬ʾnosimcardҳ,Աⲻرwebui²豸󣬲жSIM״̬
    function checkSimCardStatus() {
        setInterval(function () {
            var data = service.getStatusInfo();
            var match = menu.findMenu();
            if (match.length == 0) {
                return false;
            }
            var requirePinHash = ["phonebook", "sms_list"];
            var isRequirePin = ($.inArray(match[0].path, requirePinHash) != -1);
            if (match[0].checkSIMStatus === true) {
                var simstatus = data.simStatus == "modem_sim_undetected"
                     || data.simStatus == "modem_sim_destroy" || data.simStatus == "modem_waitpin"
                     || data.simStatus == "modem_waitpuk";
                var netlockstatus = data.simStatus == "modem_imsi_waitnck";
                if (data.isLoggedIn && (
                        ($('#div-nosimcard')[0] == undefined && simstatus)
                         || ($('#div-network-lock')[0] == undefined && netlockstatus)
                         || (($('#div-nosimcard')[0] != undefined || $('#div-network-lock')[0] != undefined) && data.simStatus == "modem_init_complete"))) {
                    fixedLoadResources(match[0], data.simStatus, isRequirePin);
                }
            }
        }, 1000);
    }

    //¼ҳ汳
    function checkLoginPageBg() {
        var h = window.location.hash;
        if (h == '#entry' || _.indexOf(config.GUEST_HASH, h) != -1) {
            $("#manageContainer").attr("style", "margin-top:-36px;");
        } else {
            $("#manageContainer").attr("style", "margin-top:0px;");
        }

        if (window.location.hash == '#entry') {
            $("#mainContainer").addClass('loginBackgroundBlue');
        } else {
            var mainContainer = $("#mainContainer");
            if (mainContainer.hasClass('loginBackgroundBlue')) {
                $("#container").css({
                    margin: 0
                });
                mainContainer.removeClass('loginBackgroundBlue').height('auto');
            }
        }
    }
	
    function fixedLoadResources(menuItem, simStatus, isRequirePin) {
        var item = {};
        $.extend(item, menuItem);
        //ûSIMʱhomeҳ治
        //类ʱhomeҳʾҳ
        if (simStatus == "modem_sim_undetected" || simStatus == "modem_sim_destroy") {
            if (!isRequirePin) {
                item.path = "sim_abnormal";
            }
        } else if (simStatus == "modem_waitpin" || simStatus == "modem_waitpuk") {
            item.path = "sim_abnormal";
        } else if (simStatus == "modem_imsi_waitnck") {
            item.path = "locknet";
        }
        //load tmpl and controller js
        loadResources(item);
    }

    //ݲ˵itemضӦԴ
    function loadResources(item) {
        var pId = item.path.replace(/\//g, '_');
        var $body = $('body').removeClass();
        if (pId != 'entry' && pId != 'main') {
            $body.addClass('beautiful_bg page_' + pId);
        } else {
            $body.addClass('page_' + pId);
        }
        clearTimer();
        hideLoading();
        var tmplPath = 'text!tmpl/' + item.path + '.html';
        //TODO: prevent first menu click cover the second menu content, need test with device
        require([tmplPath, item.path], function (tmpl, viewModel) {
            container.stop(true, true);
            container.hide();
            container.html(tmpl);
            viewModel.init();
            //support backward/forward
            menu.refreshMenu();
            $('#container').translate();
            menu.activeSubMenu();

            $("form").attr("autocomplete", "off");
            container.fadeIn();
        });
    }
    //ȶhash״̬, 仯µhashƥ˵,ƥ䲻ʱתhomeҳ, ƥʱ¼hashֵ̬ضӦԴļ
    function hashCheck() {
        if (window.location.hash != currentHash) {
            //½, ½ûʷǵ¼ûʱҳ治ת
            var info = service.getStatusInfo();
            if (window.location.hash == config.defaultRoute || _.indexOf(config.GUEST_HASH, window.location.hash) != -1) {
                if (info.isLoggedIn) {
                    window.location.hash = currentHash == "" ? "#main" : currentHash;
                    return;
                }
            }

            var match = menu.findMenu();

            if (match.length == 0) {
                window.location.hash = config.defaultRoute;
            } else {
                //¼ʱ鹤ģʽģʽҪSIM״̬¼,ģʽ治ҪSIM״̬¼
                if (config.RJ45_SUPPORT && window.location.hash == "#main") {
                    if ((match[0].checkSIMStatus && checkCableMode(info.blc_wan_mode)) || (!match[0].checkSIMStatus && !checkCableMode(info.blc_wan_mode))) {
                        window.location.reload();
                        return;
                    }
                }
                //TODO: ˵Ӧ˵һлʱ¼, TODO: click the same menu ʵַʽ
                var oldMenu = menu.findMenu(currentHash);
                currentHash = match[0].hash;
                if (currentHash == "#entry") {
                    $('#indexContainer').addClass('login-page-bg');
                    menu.rebuild();
                } else {
                    $('#indexContainer').removeClass('login-page-bg');
                }

                if (oldMenu.length != 0 && match[0].path == oldMenu[0].path && match[0].level != oldMenu[0].level && match[0].level != '1' && oldMenu[0].level != '1') {
                    return;
                }

                checkLoginPageBg();
                var requirePinHash = ["phonebook", "sms_list"];
                var isRequirePin = ($.inArray(match[0].path, requirePinHash) != -1);
                if (match[0].checkSIMStatus === true || isRequirePin) {
                    //simStatus is undefined when refreshing page
                    if (info.simStatus == undefined) {
                        showLoading('waiting');
                        function checkSIM() {
                            var data = service.getStatusInfo();
                            if (data.simStatus == undefined || $.inArray(data.simStatus, config.TEMPORARY_MODEM_MAIN_STATE) != -1) {
                                addTimeout(checkSIM, 500);
                            } else {
                                fixedLoadResources(match[0], data.simStatus, isRequirePin);
                                hideLoading();
                            }
                        }
                        checkSIM();
                    } else {
                        fixedLoadResources(match[0], info.simStatus, isRequirePin);
                    }
                } else {
                    loadResources(match[0]);
                }
            }
        }
    }
	
    //ĬҳΪ#main, ʱhash״̬
    function init() {
        checkSimCardStatus();
        window.location.hash = window.location.hash || "#main";
        //if support onhashchange then use. If ie8 in ie7 mode, it doesn't trigger onhashchange.
        if (('onhashchange' in window) && ((typeof document.documentMode === 'undefined') || document.documentMode == 8)) {
            window.onhashchange = hashCheck;
            hashCheck();
        } else {
            setInterval(hashCheck, 200);
        }

        //޸ҳ, 뿪ʱʾ
        $("a[href^='#']").die('click').live('click', function () {
            var $this = $(this);
            config.CONTENT_MODIFIED.checkChangMethod();
            return checkFormContentModify($this.attr('href'));
        });
    }
	
    return {
        init: init
    };
});

// statusBar ģ

define("statusBar", "knockout jquery underscore service set menu tooltip".split(" "), 

    function (ko, $, _, service, config, menu, tooltip) {
	
	var sv__hasCheckedSMSCapacity   = false;	
    var sv__initSMSCompleted        = false;		
    var sv_newSMSMessageInDealing   = false;		
    var sv_fotaUpdateCancel         = null;
	var sv_batteryCheckTimer        = 0;	
    var sv_dbMessageIds             = [];	
    var sv_fotaResultAlertPopuped   = false;
    var sv_isFirstLoadNewMessage    = true;	
    var isLoggedIn                  = true;		
    var sv_messagePopStack          = {};
    var sv_newMessagePopTemplate    = null;	
    var sv_resetTrafficAlertPopuped = false;
    var sv_simMessageListTemplate   = null;
    var sv_smsListTemplate          = null;		
    var sv_trafficAlertPopuped_100  = false;		
    var sv_trafficAlertPopuped      = false;
    var sv_timer                    = 0;

    // ȡ״̬Ϣ硢SIMWIFI
    var getCurrentStatusInfo = function () {
        return service.getStatusInfo();
    };

    function statusViewModel() {
        var target         = this;
        var info           = getCurrentStatusInfo();
		var roamStatus   = info.roamingStatus ? true : false;
		var $langLogoBar = $("#langLogoBar");
		
		
        // ¼
		function sf_connect() {
            showLoading("connecting");
            service.connect({}, function (data) {
                if (data.result) {
                    refreshWifiConnectStatus(target, data.status);
                }
                successOverlay();
            }, function (data) {
                errorOverlay();
            });
        }
        // Ͽ¼
		function sf_disconnect() {
            showLoading("disconnecting");
            service.disconnect({}, function (data) {
                if (data.result) {
                    refreshWifiConnectStatus(target, data.status);
                }
                successOverlay();
            }, function (data) {
                errorOverlay();
            });
        }			
		
        if(info.isLoggedIn){
        	if(!$langLogoBar.hasClass("langborderBg")){
                $langLogoBar.addClass("langborderBg");
        	}
        	$("#statusBar:hidden").show();
        } else {
        	if($langLogoBar.hasClass("langborderBg")){
                $langLogoBar.removeClass("langborderBg");
        	}
        	$("#statusBar:visible").hide();
        }	
		
		
        //target.attachedDevices        = ko.observable(info.attachedDevices);
        target.batteryLevel             = ko.observable(info.batteryLevel + '%');
        target.batteryPers              = ko.observable(sf_getBatteryLevelImage(info.batteryPers, info.batteryStatus));		
        target.batteryStatus            = ko.observable(info.batteryStatus);	
        target.connectionCssClass       = ko.observable("");		
        target.connectStatus            = ko.observable(info.connectStatus);
        target.connectStatusText        = ko.observable();
        target.connectStatusTrans       = ko.observable();
        target.hasWifi                  = ko.observable(config.HAS_WIFI);
        target.hasBattery               = ko.observable(config.HAS_BATTERY);		
        target.isLoggedIn               = ko.observable(info.isLoggedIn);
        target.isShowConnectionIcon     = ko.observable(false);
		target.isShowFotaNewversionIcon = ko.observable(info.new_version_state && info.fota_package_already_download != "yes" && !config.isShowFotaIcon);		
        target.isShowRj45ConnectionIcon = ko.observable(false);
        target.networkOperator          = ko.observable(sf_getNetWorkProvider(info.spn_b1_flag,info.spn_name_data,info.spn_b2_flag,info.networkOperator,roamStatus));		
        target.networkType              = ko.observable(getNetworkType(info.networkType));
        target.pinStatus                = ko.observable(info.pinStatus);
        target.pinStatusText            = ko.observable();	
        target.rj45ConnectionCssClass   = ko.observable("");		
        target.roamingStatus            = ko.observable(info.roamingStatus ? "R" : "");
        target.showAttachedDevices      = ko.observable(info.wifiStatus);		
        target.showSmsDeleteConfirm     = ko.observable(false);
        target.smsUnreadCount           = ko.observable(0);
        target.simStatus                = ko.observable(sf_convertSimStatusToImage(info.simStatus));
        target.signalCssClass           = ko.observable(sf_getSignalCssClass(info.signalImg, info.networkType, info.simStatus));		
        target.updateType               = ko.observable(service.getUpdateType().update_type);
        target.wifiStatusCssClass       = ko.observable(sf_getWifiStatusCssClass(info.wifiStatus, info.wirelessDeviceNum));
        target.wifiStatusImg            = ko.observable(sf_getWifiStatusImage(info.wifiStatus, info.wirelessDeviceNum));
		
        sf_getConnectionCssClass(target, info.connectStatus, info.data_counter, info.connectWifiSSID, info.connectWifiStatus, info.rj45ConnectStatus);	
		
        target.connect    = sf_connect;
        target.disconnect = sf_disconnect;
    }
	
	function sf_gotoSmsList(){
        var s_href = '#msg_main';
        if(window.location.hash == '#msg_main'){
            s_href = '#msg_list';
        }
		config.CONTENT_MODIFIED.checkChangMethod();
        if(checkFormContentModify(s_href)){
            window.location.hash = s_href;
        }
    }
	
    gotoSmsList = sf_gotoSmsList;	

    function sf_getNetWorkProvider(i_spnB1Flag, i_spnNameData, i_spnB2Flag, i_networkProvider, i_roamStatus) {
        if (i_spnNameData == "") {
            return i_networkProvider;
        } else {
            i_spnNameData = decodeMessage(i_spnNameData);
            if (i_spnB1Flag == "0" && i_spnB2Flag == "0") {
                if (i_roamStatus) {//
                    return i_spnNameData == i_networkProvider ? i_networkProvider : (i_spnNameData + '  ' + i_networkProvider);
                } else {//
                    return i_spnNameData;
                }
            }else if (i_spnB1Flag == "1" && i_spnB2Flag == "1") {
                if (i_roamStatus) {//
                    return i_networkProvider;
                } else {//
                    return i_spnNameData == i_networkProvider ? i_networkProvider : (i_spnNameData + '  ' + i_networkProvider);
                }
            } else if (i_spnB1Flag == "1") {
                return i_spnNameData == i_networkProvider ? i_networkProvider : (i_spnNameData + '  ' + i_networkProvider);
            } else if (i_spnB2Flag == "1") {
                if (i_roamStatus) {//
                    return i_networkProvider;
                } else {//
                    return i_spnNameData;
                }
            } 
            return "";
        }
    }
  
    // ¶Ϣʾ
    function sf_addNewMessage(i_message, i_isUpdate, i_type){
    	config.smsMaxId = i_message.id;
    	var now = $.now();
    	sv_messagePopStack["m" + now] = now;
    	var name = i_message.number;
    	if(sv_isFirstLoadNewMessage && config.phonebook && config.phonebook.length == 0){
    		sv_isFirstLoadNewMessage = false;
    		if(config.HAS_PHONEBOOK){
				sf_getPhoneBooks();
			}else{
				config.phonebook = [];
			}
    	}
    	for(i in config.phonebook){
    		if(getLastNumber(config.phonebook[i].pbm_number, config.SMS_MATCH_LENGTH) == getLastNumber(i_message.number, config.SMS_MATCH_LENGTH)){
    			name = config.phonebook[i].pbm_name;
    			break;
    		}
    	}
		var s_newMsg = {
			mark : "m" + now,
			name: name,
			title: $.i18n.prop("sms"),
			titleTrans: "sms",
			tag: i_message.tag,
			content : i_message.content,
			datetime : i_message.time
		};
		if(sv_newMessagePopTemplate == null){
			sv_newMessagePopTemplate = $.template("newMessagePopTmpl", $("#newMessagePopTmpl"));
		}
        $(".bubbleItem:not(.report)", "#buttom-bubble").remove();
        $.tmpl("newMessagePopTmpl", s_newMsg).appendTo("#buttom-bubble");
		if((window.location.hash == "#msg_main" || window.location.hash == "#msg_list") && i_type == "1"){
            //sf_dealChosenNumber(s_newMsg.name, i_message.number);
			var s_inChating = config.currentChatObject && config.currentChatObject == getLastNumber(i_message.number, config.SMS_MATCH_LENGTH);
			var s_itemId = getLastNumber(i_message.number, config.SMS_MATCH_LENGTH);
			var item = $("#smslist-item-" + s_itemId);
			if(item && item.length > 0){
                // Ѵݣݵ˳
				for(var i = 0; config.listMsgs && i < config.listMsgs.length; i++){
					if(getLastNumber(config.listMsgs[i].number, config.SMS_MATCH_LENGTH) == getLastNumber(i_message.number, config.SMS_MATCH_LENGTH)){
						config.listMsgs[i].id = i_message.id;
						config.listMsgs[i].latestId = i_message.id;
						config.listMsgs[i].latestSms = i_message.content;
						config.listMsgs[i].latestTime = i_message.time;
						if(!i_isUpdate){
							config.listMsgs[i].newCount++;
							config.listMsgs[i].totalCount++;
						}
						break;
					}
				}
				item.find(".smslist-item-checkbox p.checkbox").attr("id", i_message.id);
				item.find(".smslist-item-checkbox input:checkbox").val(i_message.id).attr("id", "checkbox" + i_message.id);
				if(!i_isUpdate){
					var s_itemCount = item.find(".smslist-item-total-count").text();
					s_itemCount = Number(s_itemCount.substring(1, s_itemCount.length - 1));
					item.find(".smslist-item-total-count").text("(" + (s_itemCount + 1) + ")");
					if(!config.currentChatObject || config.currentChatObject != getLastNumber(i_message.number, config.SMS_MATCH_LENGTH)){
						var s_newNum = item.find(".smslist-item-new-count").removeClass("hide");
						if(s_newNum && s_newNum.text().length > 0){
							s_newNum.text(Number(s_newNum.text()) + 1);
						}else{
							s_newNum.text(1);
						}
					}
				}
				if(item.find(".smslist-item-draft-flag").length > 0){
					if (config.currentChatObject && config.currentChatObject == getLastNumber(i_message.number, config.SMS_MATCH_LENGTH)) {
					    item.find(" td:nth-child(2)").removeClass("font-weight-bold");
				    } else {
					    item.find(" td:nth-child(2)").addClass("font-weight-bold");
				    }
				}else{
					var msgContent = item.find(".smslist-item-msg").text(i_message.content);
				    msgContent.closest('td').prop('title', i_message.content);
				    item.find("span.clock-time").text(i_message.time);
					if (config.currentChatObject && config.currentChatObject == getLastNumber(i_message.number, config.SMS_MATCH_LENGTH)) {
					    msgContent.closest('tr').removeClass("font-weight-bold");
				    } else {
					    msgContent.closest('tr').addClass("font-weight-bold");
				    }
				}
				item.find(".smslist-item-repeat span").die().click(function() {
					forwardClickHandler(i_message.id);
				});
				
				var s_tmpItem = item;
				item.hide().remove();
				$("#smslist-table").prepend(s_tmpItem.show());
			} else {
                // бвӦϵ˶ϢӦڶб
				var s_theName = "";
				if(config.phonebook && config.phonebook.length > 0) {
					for(i in config.phonebook){
						if(getLastNumber(config.phonebook[i].pbm_number, config.SMS_MATCH_LENGTH) == getLastNumber(i_message.number, config.SMS_MATCH_LENGTH)){
							s_theName = config.phonebook[i].pbm_name;
							break;
						}
					}
				}
				var s_theNewMessage = {
					id : i_message.id,
					name : s_theName,
					number : i_message.number,
					latestId :i_message.id,
					totalCount : 1,
					newCount : s_inChating ? 0 : 1,
					latestSms : i_message.content,
					latestTime : i_message.time,
					checked : false,
					hasDraft : false,
					itemId : getLastNumber(i_message.number, config.SMS_MATCH_LENGTH)
				};
				if(sv_smsListTemplate == null){
					sv_smsListTemplate = $.template("smsTableTmpl", $("#smsTableTmpl"));
				}
				$.tmpl("smsTableTmpl", {data: [s_theNewMessage]}).prependTo("#smslist-table");
            }
            if(config.HAS_PHONEBOOK){
                $(".sms-add-contact-icon").removeClass("hide");
            }else{
                $(".sms-add-contact-icon").addClass("hide");
            }
			if(s_inChating){
				var talkItem = $("#talk-item-" + i_message.id, "#chatlist");
				if (talkItem && talkItem.length > 0) {// ¼
					$(".J_content pre", talkItem).html(dealContent(i_message.content));
					$(".time .smslist-item-time", talkItem).text(i_message.time);
					$(".smslist-item-repeat", talkItem).die().click(
							function() {
								forwardClickHandler(i_message.id);
							});
					$(".smslist-item-delete", talkItem).die().click(
							function() {
								deleteSingleItemClickHandler(i_message.id);
							});
				} else {// µĻظ
					$("#smsOtherTmpl").tmpl(i_message).appendTo("#chatlist");
					$(".clear-container", "#chatpanel").animate({
						scrollTop : $("#chatlist").height()
					});
				}
                if (!config.SMS_SET_READ_WHEN_COMPLETE) {
                    service.setSmsRead({ids: [i_message.id]}, $.noop);
                } else if (config.SMS_SET_READ_WHEN_COMPLETE && i_message.receivedAll) {
                    service.setSmsRead({ids: [i_message.id]}, $.noop);
                }
			}
            enableCheckbox($("#smslist-checkAll"));
		}
		if(window.location.hash == "#msg_sim" && i_type == "0"){
			// бвӦϵ˶ϢӦڶб
				var s_theName = "";
				if(config.phonebook && config.phonebook.length > 0) {
					for(i in config.phonebook){
						if(getLastNumber(config.phonebook[i].pbm_number, config.SMS_MATCH_LENGTH) == getLastNumber(i_message.number, config.SMS_MATCH_LENGTH)){
							s_theName = config.phonebook[i].pbm_name;
							break;
						}
					}
				}
				var s_theNewMessage = {
					id : i_message.id,
					name : s_theName,
					number : i_message.number,
					content : i_message.content,
					time : i_message.time,
					tag: i_message.tag,
					checked : false,
					itemId : getLastNumber(i_message.number, config.SMS_MATCH_LENGTH)
				};
				if(i_isUpdate){
					var s_item = $(".simMsgList-item-class-" + s_theNewMessage.id);
				    s_item.hide().remove();				
				}
				if(sv_simMessageListTemplate == null){
					sv_simMessageListTemplate = $.template("ssimMessageListTemplate", $("#simMessageListTemplate"));
				}
				$.tmpl("simMessageListTemplate", {data: [s_theNewMessage]}).prependTo("#simMsgList_container");
		}
	}
  
 	function sf_checkBatteryStatusForFota(){
	  var s_state = service.getCurrentUpgradeState();
	  if(s_state.current_upgrade_state == 'low_battery'){
			showInfo('ota_low_battery');
			clearInterval(sv_batteryCheckTimer);
		}
	} 
  
    // SIM״̬תΪӦ
    function sf_convertSimStatusToImage(i_status) {
        var s_image;
        switch (i_status) {
            case "modem_destroy":
                s_image = "./pic/simcard_undetected.png";//$.i18n.prop("sim_status_destroy");
                break;
            case "modem_imsi_waitnck":
                s_image = "./pic/simcard_undetected.png";//$.i18n.prop("sim_status_waitnck");
                break;				
            case "modem_init_complete":
                s_image = "./pic/simcard_detected.png";//$.i18n.prop("sim_status_ready");
                break;	
            case "modem_sim_destroy":
                s_image = "./pic/simcard_undetected.png";//$.i18n.prop("sim_status_destroy");
                break;				
            case "modem_sim_undetected":
                s_image = "./pic/simcard_undetected.png";//$.i18n.prop("sim_status_undetected");
                break;
            case "modem_undetected":
                s_image = "./pic/simcard_undetected.png";
                break;				
            case "modem_waitpin":
                s_image = "./pic/simcard_undetected.png";//$.i18n.prop("sim_status_waitpin");
                break;
            case "modem_waitpuk":
                s_image = "./pic/simcard_undetected.png";//$.i18n.prop("sim_status_waitpuk");
                break;

            default:
                s_image = "./pic/simcard_detected.png";//$.i18n.prop("sim_status_ready");
                break;
        }
        return s_image;
    }
	
    function sf_dealChosenNumber(i_choosenName, i_choosenNum) {
        setTimeout(function () {
            var s_choosen  = $("#chosenUserSelect");
            var s_options = $("option", s_choosen);
            for (var index  = 0; index < s_options.length; index++) {
                if (getLastNumber(i_choosenNum, config.SMS_MATCH_LENGTH) == s_options[index].value) {
				
                    s_options[index].text  = i_choosenName + '/' + i_choosenNum;
					s_options[index].value = i_choosenNum;
                    
                    break;
                }
            }
            s_choosen.trigger("liszt:updated");
        }, 0);
    } 
	
	// ˫첽ȡ豸simöϢϲ
	function sf_dealPhoneBooksResult(i_books){
		if($.isArray(i_books.pbm_data) && i_books.pbm_data.length > 0){
			config.phonebook = i_books.pbm_data;
		}
	}	
  
    // µ5Ϣδӵбеĵʾ
    function sf_filterNewMessage(i_messages, i_type){
    	if(!config.dbMsgs){
    		config.dbMsgs = [];
    	}
    	if(sv_dbMessageIds.length == 0){
    		$.each(config.dbMsgs, function(index_1, i_element){
    			sv_dbMessageIds.push(i_element.id);
    		});
    	}
    	$.each(i_messages, function(index_2, i_element){
    		if($.inArray(i_element.id, sv_dbMessageIds) == -1){//¶
    			sv_dbMessageIds.push(i_element.id);
    			config.dbMsgs.push(i_element);
    			if(i_element.tag == '1'){
    				sf_addNewMessage(i_element, false, i_type);
    			}
    		}else{
    			for(var index = 0; index < config.dbMsgs.length; index++){//¼
    				if(config.dbMsgs[index].id == i_element.id && config.dbMsgs[index].content != i_element.content && i_element.tag == '1'){
    					config.dbMsgs[index].content = i_element.content;
    					sf_addNewMessage(i_element, true, i_type);
    					break;
    				}
    			}
    		}
    	});
    }
	
    // תΪӦͼƬ
    function sf_getBatteryLevelImage(pers, i_status) {
    	var s_Image = null;
		if ("0" == i_status) {
			if ("1" == pers) {
				s_Image = "pic/power_one.png";
			} else if ("2" == pers) {
				s_Image = "pic/power_two.png";
			} else if ("3" == pers) {
				s_Image = "pic/power_three.png";
			} else if ("4" == pers) {
				s_Image = "pic/power_full.png";
			} else { //"5" == pers || "0" == pers
				s_Image = "pic/power_out.png";
			}
		} else {
			s_Image = "pic/power_charging.gif";
		}
		return s_Image;
    }

    // ȡ״̬CSSʽ
    function sf_getConnectionCssClass(i_fwVm, i_status, i_data_counter, i_wifiSSID, i_wifiStatus, i_rj45Status) {

        var s_rj45ConnectionStatus = "icon_connection ";
        var s_connectionStatus     = "icon_connection ";

        if(i_rj45Status == "connect"){
            s_rj45ConnectionStatus += "connecting";
        }else if(i_rj45Status == "working"){
            s_rj45ConnectionStatus += "rj45_connected";
        }else{
            s_rj45ConnectionStatus += "disconnect";			
        }

        if (i_status == "ppp_connecting" || i_status == "wifi_connecting") {
            s_connectionStatus += "connecting";
        } else if(i_status == "ppp_connected") {//CPE ppp_statusΪnone readyֵ
            if (i_data_counter.uploadRate != '0' && i_data_counter.downloadRate != '0') {
                s_connectionStatus += "connectionBoth";
            } else if (i_data_counter.uploadRate != '0' && i_data_counter.downloadRate == '0') {
                s_connectionStatus += "connectionUp";
            } else if (i_data_counter.uploadRate == '0' && i_data_counter.downloadRate != '0') {
                s_connectionStatus += "connectionDown";
            } else {
                s_connectionStatus += "connectionNone";
            }
        } else if (i_status == "ppp_disconnected") {
            if (i_wifiSSID && i_wifiStatus == "connect") {
                service.getHotspotList({}, function (data) {
                    var s_cssName = "icon_connection ";
                    var s_css = "connecting ";
                    for (var i = 0, len = data.hotspotList.length; i < len; i++) {
                        if (data.hotspotList[i].connectStatus == "1") {
                            s_css = "wifi_connected";
                            break;
                        }
                    }
                    s_cssName += s_css;
                    i_fwVm.connectionCssClass(s_cssName);
                });
                i_fwVm.rj45ConnectionCssClass(s_rj45ConnectionStatus);
                return;
            } else if (i_wifiSSID && (i_wifiStatus == "connecting" || i_wifiStatus =="dhcping")) {
                s_connectionStatus += "connecting";
            } else {
                s_connectionStatus += "disconnect";
            }
        }  else {
            s_connectionStatus += "disconnect";
        }

        i_fwVm.connectionCssClass(s_connectionStatus);
        i_fwVm.rj45ConnectionCssClass(s_rj45ConnectionStatus);
    }
	
	// ȡ绰Ϣ
	function sf_getPhoneBooks() {
		var s_books = service.getPhoneBooks({
            page : 0,
            data_per_page : 2000,
            orderBy : "id",
            isAsc : false
		});
		sf_dealPhoneBooksResult(s_books);
	}

	// ȡźCSSʽ
    function sf_getSignalCssClass(siganl, networkType, simStatus) {
    	networkType = networkType.toLowerCase();
    	simStatus = simStatus ? simStatus.toLowerCase() : '';
    	if(networkType == '' || networkType == 'limited_service' || networkType == 'no_service' || networkType == 'limited service' || networkType == 'no service'
            || simStatus != 'modem_init_complete'){
    		siganl = '_none';
    	}
        return "signal signal" + siganl;
    }
	
    function sf_getWifiStatusCssClass(i_status, i_deviceSize) {
        if (i_status) {
            if (i_deviceSize == 0) {
                return "wifi_status0";
            } else {
                return "wifi_status" + i_deviceSize;
            }
        } else {
            return "wifi_status_off";
        }
    }
    
    // wifi״̬ȡwifiͼƬԴ
    function sf_getWifiStatusImage(i_status, i_deviceSize) {
		if (i_status) {
			if (i_deviceSize == 0) {
				return "./pic/wlan0.png";
			} else {
				return "./pic/wlan" + i_deviceSize + ".png";
			}
		} else {
			return "./pic/wlan_off.png";
		}
	}	

    // ȡСؽ
    function sf_refreshFotaDownloadProgress(){
        service.getPackSizeInfo({}, function (data) {
            var percents;
            if (parseInt(data.fota_pkg_total_size) == 0) {
                percents = 0;
            } else {
                percents = parseInt(parseInt(data.fota_dl_pkg_size) * 100 / parseInt(data.fota_pkg_total_size));
            }
            if (percents > 100) {
                percents = 100;
            }
            if (percents >= 0) {
                if (percents > 95) {
                    showProgressBar("ota_update", "<br/>" + $.i18n.prop("ota_update_warning"));
                }
                setProgressBar(percents);
            }
        });
    }		
    
    // ŷͱ
    function sf_responseSmsReport(){
    	if(sv_isFirstLoadNewMessage && config.phonebook && config.phonebook.length == 0){
			
    		sv_isFirstLoadNewMessage = false;
			
    		if(config.HAS_PHONEBOOK){
				sf_getPhoneBooks();
			}else{
				config.phonebook = [];
			}
    	}
    	service.getSMSDeliveryReport({
    		page: 0,
    		smsCount: 10
    	}, function(data){
    		var s_messages = data.messages;
    		var s_nums = [];
    		$.each(s_messages, function(i, i_message){
    			if($.inArray(i_message.number, s_nums) == -1){
    				s_nums.push(i_message.number);
                    window.setTimeout(function(){
    					var s_now = $.now();
    					sv_messagePopStack["m" + s_now] = s_now;
    					i_message.name = i_message.number;
    					for(i in config.phonebook){
    						if(getLastNumber(config.phonebook[i].pbm_number, config.SMS_MATCH_LENGTH) == getLastNumber(i_message.number, config.SMS_MATCH_LENGTH)){
    							i_message.name = config.phonebook[i].pbm_name;
    							break;
    						}
    					}
    					var s_msgContent = $.i18n.prop("sms_delivery_report_" + i_message.content);
						
    					var s_newMsg = {
    							mark : "m" + s_now,
    							name: i_message.name,
    							title: $.i18n.prop("sms_report"),
    							titleTrans: "sms_report",
    							content : s_msgContent,
    							datetime : i_message.time,
    							report : 'report'
    					};
						
    					if(sv_newMessagePopTemplate == null){
    						sv_newMessagePopTemplate = $.template("newMessagePopTmpl", $("#newMessagePopTmpl"));
    					}
						
                        $(".report", "#buttom-bubble").remove();
    					$.tmpl("newMessagePopTmpl", s_newMsg).appendTo("#buttom-bubble");
    				}, 100);
    			}
    		});
    	}, function(){
    		//No Deal
    	});
    }
	
    function sf_simStatusInvalid(simStatus){
        return simStatus == 'modem_sim_undetected' || simStatus == 'modem_undetected' || simStatus == 'modem_sim_destroy'
            || simStatus == 'modem_waitpin' || simStatus == 'modem_waitpuk' || simStatus == 'modem_imsi_waitnck';
    }	
	
    // ʾFOTAǰ״̬
    function sf_showFotaCurrentStatus() {
        sv_fotaUpdateCancel = true;
		var r = service.getNewVersionState();
		
        function showProgress() {
            var upgradingState = ["downloading"];
            var info = service.getCurrentUpgradeState();
            if(info.current_upgrade_state.toLowerCase() == "idle") {
                addTimeout(showProgress, 1000);
            } else if(($.inArray(info.current_upgrade_state, upgradingState) != -1)&&(r.fota_new_version_state != "already_has_pkg")) {
                hideLoading();
                sf_showFotaUpgradeStatus();
            }
        }
        if (!($("#progress").is(":visible"))) {
            showProgress();
        }
        var times = 0;
        var getOTAUpgradeState = function () {
            var data = null;
            if (times <= 3) {
                times = times + 1;
                data = service.getCurrentUpgradeState();
            } else {
                data = getCurrentStatusInfo();
            }
            var state = data.current_upgrade_state;
            if(sv_fotaUpdateCancel && isLoggedIn == true){

				if(r.fota_new_version_state == "already_has_pkg"){
					if(state == 'low_battery'){
                        hideProgressBar();
                        sv_fotaUpdateCancel = false;
					    service.removeTimerThings('fota_current_upgrade_state',function(){});
                        showInfo('ota_pkg_low_battery');
                        window.clearTimeout(sv_timer);
                        return;
                    }else if(state == 'prepare_install'){
                        hideProgressBar();
                        sv_fotaUpdateCancel = false;
                        service.removeTimerThings('fota_current_upgrade_state',function(){});
                        showInfo('ota_pkg_download_success');
                        window.clearTimeout(sv_timer);
                        sv_batteryCheckTimer = setInterval(function () {
                            sf_checkBatteryStatusForFota();
                            }, 1000);
                        return;
				    } 
				}else if(state == 'downloading') {
                    sf_refreshFotaDownloadProgress();
                }else if(state == 'download_failed') {
                    hideProgressBar();
                    sv_fotaUpdateCancel = false;
                    showAlert('ota_download_failed');
                    window.clearTimeout(sv_timer);
                    return;
                }else if(state == 'low_battery'){
                    hideProgressBar();
                    sv_fotaUpdateCancel = false;
					service.removeTimerThings('fota_current_upgrade_state',function(){});
                    showInfo('ota_low_battery');
                    window.clearTimeout(sv_timer);
                    return;
                }else if(state == 'prepare_install'){
                    hideProgressBar();
                    sv_fotaUpdateCancel = false;
                    service.removeTimerThings('fota_current_upgrade_state',function(){});
                    showInfo('ota_download_success');
                    window.clearTimeout(sv_timer);
                    sv_batteryCheckTimer = setInterval(function () {
                        sf_checkBatteryStatusForFota();
                    }, 1000);
                    return;
                }else{
                    sv_fotaUpdateCancel = false;
                    hideProgressBar();
                    window.clearTimeout(sv_timer);
                    return;
                }
                sv_timer = window.setTimeout(getOTAUpgradeState , 1000);
            }
        };

        if(sv_fotaUpdateCancel && isLoggedIn == true){
            sv_timer = window.setTimeout(getOTAUpgradeState , 100);
        }else{
            window.clearTimeout(sv_timer);
        }
    }	
	
    // ʾFota
    function sf_showFotaUpdateResult(i_otaResult) {
        if ((!($("#loading").is(":visible"))) && (!($("#confirm").is(":visible")))) {
            var s_message = i_otaResult ? "ota_update_success" : "ota_update_failed";
            sv_fotaResultAlertPopuped = true;
            showAlert(s_message, function () {
                sv_fotaResultAlertPopuped = false;
                if (config.UPGRADE_TYPE == "OTA") {
                    service.clearUpdateResult({}, $.noop());
                }
            });
        } else {
            window.setTimeout(function () {
                sf_showFotaUpdateResult(i_otaResult)
            }, 1000);
        }
    }	
	
    // ʾǰ״̬
    function sf_showFotaUpgradeStatus() {
        var s_data        = service.getMandatory();
        var s_isMandatory = s_data.is_mandatory;
        var s_sizeInfo    =service.getPackSizeInfo();
		var s_percents;
		
        if (parseInt(s_sizeInfo.fota_pkg_total_size) == 0) {
            s_percents = 0;
        } else {
            s_percents = parseInt(parseInt(s_sizeInfo.fota_dl_pkg_size) * 100 / parseInt(s_sizeInfo.fota_pkg_total_size));
        }
        if (s_percents > 100) {
            s_percents = 100;
        }
		
        if (s_isMandatory) {
            showProgressBar("ota_update", "<br/>" + $.i18n.prop("ota_update_warning"));
        } else {
            var cancelHtml = "";
            if (config.UPGRADE_TYPE == "OTA") {
                cancelHtml = "<br/><br/><button id='btnStopUpgrade' onclick='stopOTAUpgrade();' class='btn-1 btn-primary'>" + $.i18n.prop("cancel") + "</button>";
            }
            showProgressBar("ota_update", "<br/>" + $.i18n.prop("ota_update_warning") + cancelHtml);
        }
		
        //setProgressBar(0);
       if (s_percents >= 0) {
            setProgressBar(s_percents);       
       }
    }
	




    function sf_startFotaUpgrade(){
        service.setUpgradeSelectOp({selectOp:'1'},function(result){
            if (result.result == "success"){
                sf_showFotaCurrentStatus();
            }});
    }

    function cancelFotaUpgrade(){
        service.setUpgradeSelectOp({selectOp:'0'},function(result){ });
    }
	
	
    function refreshFotaStatusForUserSelector(choice){
        var info = getCurrentStatusInfo();
        if(choice){
			var modeData = service.getOpMode();
            if (!checkConnectedStatus(info.connectStatus, modeData.rj45_state, info.connectWifiStatus)) {
                showAlert("ota_network_disconnected");
                return;
            }

            if(info.fota_user_selector == 'none'){
                sf_startFotaUpgrade();
            }else if(info.fota_user_selector == 'accept'){
                sf_showFotaCurrentStatus();
            }else if(info.fota_user_selector == 'cancel'){
                showAlert("ota_have_cancel");
            }else if(info.fota_user_selector == 'downloading_cancel'){
                showAlert("ota_have_cancel");
            }
        }else{
            if(info.fota_user_selector == 'none'){
                cancelFotaUpgrade();
            }else if(info.fota_user_selector == 'accept'){
                sf_showFotaCurrentStatus();
            }else if(info.fota_user_selector == 'cancel'){
                // todo: 
            }else if(info.fota_user_selector == 'downloading_cancel'){
                // todo: 
            }
        }
    }


    // ʾ°汾жǷʾ
    function showFotaStatusForUserToConfirm(upgradeState) {
        var upgState = upgradeState.current_upgrade_state;
        if (upgState == 'upgrade_pack_redownload') {
            showConfirm("ota_interrupted", {ok: function () {
                refreshFotaStatusForUserSelector(1);
            }, no: function () {
                refreshFotaStatusForUserSelector(0);
            }});
        } else {
            var upgradingState = ["prepare_install", "low_battery",
                "connecting_server", "connect_server_success", "downloading", "accept"];
            if ($.inArray(upgState, upgradingState) != -1) {
                sf_showFotaCurrentStatus();
            } else {
                
                showConfirm($.i18n.prop('ota_new_version'), {ok: function () {
                    refreshFotaStatusForUserSelector(1);
					config.ISNOW_NOTICE = false;
                }, no: function () {
                    refreshFotaStatusForUserSelector(0);
					config.ISNOW_NOTICE = false;
                }});
            }
        }
    }

    showOTAAlert = function () {
		config.ISNOW_NOTICE = true;
        var is_mandatory = service.getMandatory().is_mandatory;
        if (is_mandatory) {
            sf_showFotaCurrentStatus();
        } else {
            var upgradeState = {};
            upgradeState = service.getCurrentUpgradeState();
            showFotaStatusForUserToConfirm(upgradeState);
        }
    };

    // ֹFota
    stopOTAUpgrade = function () {
        service.setUpgradeSelectOp({selectOp:'2'},function(result){ });
        sv_fotaUpdateCancel = false;
        window.clearTimeout(sv_timer);
        hideLoading();
        showAlert('ota_cancel');
    };

    // Ƿѹ
    function setTrafficAlertPopuped(val){
    	sv_trafficAlertPopuped = !!val;
        sv_trafficAlertPopuped_100 = !!val;
        if(!val){
            sv_resetTrafficAlertPopuped = true;
        }
    }

    function setTrafficAlert100Popuped(val){
        sv_trafficAlertPopuped_100 = !!val;
        if(!val){
            sv_resetTrafficAlertPopuped = true;
        }
    }

    // ṹ
    function getTrafficResult(info){
        var s_trafficResult = {
            showConfirm : false,
            limitPercent : info.limitVolumePercent
        };
        if(info.limitVolumeType == '1'){
            var monthlyTraffic = parseInt(info.data_counter.monthlySent, 10) + parseInt(info.data_counter.monthlyReceived, 10);
            s_trafficResult.usedPercent = monthlyTraffic / info.limitVolumeSize * 100;
            if(s_trafficResult.usedPercent > s_trafficResult.limitPercent){
                s_trafficResult.showConfirm = true;
                s_trafficResult.type = 'data';
            }
        }else{
            s_trafficResult.usedPercent = info.data_counter.monthlyConnectedTime / info.limitVolumeSize * 100;
            if(s_trafficResult.usedPercent > s_trafficResult.limitPercent){
                s_trafficResult.showConfirm = true;
                s_trafficResult.type = 'time';
            }
        }
        return s_trafficResult;
    }

	// ʼ ViewModelͼ
    function init() {
        if(config.PRODUCT_TYPE == 'DATACARD') {
            $('#statusBar').addClass('padding-right-90');
            $('#language').addClass('data-card-language');
        }
        //preload img 
        var imgAlert   = $('<img />').attr('src', 'pic/res_alert.png');
        var imgConfirm = $('<img />').attr('src', 'pic/res_confirm.png');
        var imgInfo    = $('<img />').attr('src', 'pic/res_info.png');
        
        window.setTimeout(function () {
		
            var fwVm = new statusViewModel();
			
            ko.applyBindings(fwVm, $('#statusBar')[0]);
			
            window.setInterval(function () {
                var info          = getCurrentStatusInfo();
				var s_roamStatus    = info.roamingStatus ? true : false;
                var $langLogoBar  = $("#langLogoBar");
                isLoggedIn        = info.isLoggedIn;
				
				
                //fwVm.attachedDevices(info.attachedDevices);	
                fwVm.batteryLevel(info.batteryLevel + '%');				
                fwVm.batteryPers(sf_getBatteryLevelImage(info.batteryPers, info.batteryStatus));
                fwVm.batteryStatus(info.batteryStatus);				
				fwVm.isShowFotaNewversionIcon(info.new_version_state && info.fota_user_selector && info.fota_package_already_download != "yes" && config.ISNOW_NOTICE && fwVm.updateType() == 'mifi_fota');
				fwVm.isShowRj45ConnectionIcon(config.RJ45_SUPPORT);
                fwVm.networkOperator(sf_getNetWorkProvider(info.spn_b1_flag,info.spn_name_data,info.spn_b2_flag,info.networkOperator,s_roamStatus));
                fwVm.networkType(getNetworkType(info.networkType));
                fwVm.pinStatus(info.pinStatus);
                fwVm.roamingStatus(info.roamingStatus ? "R" : "");
                fwVm.showAttachedDevices(info.wifiStatus);
                fwVm.simStatus(sf_convertSimStatusToImage(info.simStatus));				
                fwVm.signalCssClass(sf_getSignalCssClass(info.signalImg, info.networkType, info.simStatus));				
                fwVm.isLoggedIn(info.isLoggedIn);
                fwVm.wifiStatusCssClass(sf_getWifiStatusCssClass(info.wifiStatus, info.wirelessDeviceNum));
                fwVm.wifiStatusImg(sf_getWifiStatusImage(info.wifiStatus, info.wirelessDeviceNum));	
							
				if(config.HAS_SMS ){
					if(!sv__hasCheckedSMSCapacity && info.isLoggedIn){
						checkSMSCapacity(info.smsUnreadCount);
					} else {
						fwVm.smsUnreadCount(info.smsUnreadCount);
					}
                }
				
                sf_getConnectionCssClass(fwVm, info.connectStatus, info.data_counter, info.connectWifiSSID, info.connectWifiStatus, info.rj45ConnectStatus);
                refreshWifiConnectStatus(fwVm, info.connectStatus,info.connectWifiSSID,info.connectWifiStatus);
                checkTrafficLimitAlert(fwVm, info);
                updateStatusBarTrans({simStatus: info.simStatus, wifiStatus: info.wifiStatus, deviceSize: info.wirelessDeviceNum, networkType: info.networkType});
				
                if(info.isLoggedIn){
                	$("#statusBar:hidden").show();
                } else {
                	$("#statusBar:visible").hide();
                }
            }, 500);

            if(config.HAS_SMS){
                window.setInterval(function(){
                    if(fwVm.isLoggedIn()){
                        checkSMSCapacity();
                    }
                }, 10000);
                checkSmsModelReady();
            }

            window.setInterval(function() {
                var data = getCurrentStatusInfo();
				var upgradingState = ["prepare_install", "low_battery", "download_success","downloading"];
       
                if (fwVm.isLoggedIn() == true && !($("#progress").is(":visible")) && data.defaultWanName != ""){                    
					 	if ($.inArray(data.current_upgrade_state, upgradingState) != -1){
                        if(null == sv_fotaUpdateCancel){
                            if(!data.is_mandatory){
                                $.modal.close();
                            }
                            sf_showFotaCurrentStatus();
                        }else if(false == sv_fotaUpdateCancel){
                            sv_fotaUpdateCancel = null;
                        }
                    }
                }
            }, 1000);

            var checkFotaUpgradeResult = function () {
                var info = service.getStatusInfo();
                if (info.isLoggedIn) {
                    service.getUpgradeResult({}, function (data) {
                        if (data.upgrade_result == "success") {
                            sf_showFotaUpdateResult(true);
                        } else if (data.upgrade_result == "fail") {
                            sf_showFotaUpdateResult(false);
                        } else {
                            window.setTimeout(checkFotaUpgradeResult, 1000);
                        }
                    }, function () {
                        window.setTimeout(checkFotaUpgradeResult, 1000);
                    });
                } else {
                    window.setTimeout(checkFotaUpgradeResult, 1000);
                }
            };
            if(fwVm.updateType() == "mifi_fota"){
                checkFotaUpgradeResult();
                window.setInterval(function () {
                    var info = getCurrentStatusInfo();
                    if (info.isLoggedIn && info.defaultWanName != "") { 
                        if(info.new_version_state && info.fota_package_already_download != "yes" && !config.ALREADY_NOTICE){
                            service.getUpgradeResult({}, function (data) {
                                if (data.upgrade_result == "success") {
                                    sf_showFotaUpdateResult(true);
                                } else if (data.upgrade_result == "fail") {
                                    sf_showFotaUpdateResult(false);
                                } else {
                                    if(sv_fotaResultAlertPopuped == false){
                                        config.ALREADY_NOTICE = true;
                                        showOTAAlert();
                                    }
                                }
                            });
                        }
                    }
                }, 1000);
            }
			function checkSMSCapacity(unreadCount){
				service.getSmsCapability({}, function(info){
					var showSmsConfirm = false;
					if(info.nvTotal != 0 && info.nvUsed >= info.nvTotal){
						$("#sms_unread_count").attr("tipTitle", "sms_capacity_is_full");
						showSmsConfirm = true;
					} else if(info.nvTotal != 0 && info.nvUsed + 5 >= info.nvTotal) {
						$("#sms_unread_count").attr("tipTitle", "sms_capacity_will_full");
						showSmsConfirm = true;
					} else {
						$("#sms_unread_count").attr("tipTitle", "sms_unread_count");
					}
					fwVm.showSmsDeleteConfirm(showSmsConfirm);
					if(typeof unreadCount != "undefined"){
						fwVm.smsUnreadCount(unreadCount);
					}
					sv__hasCheckedSMSCapacity = true;
				});
			}
        }, 1200);
        
        tooltip.init();
        
        // Ϣģʼ״̬
        function checkSmsModelReady(){
            var info = getCurrentStatusInfo();
            if(info.isLoggedIn){
                service.getSMSReady({}, function (data) {
                    if (data.sms_cmd_status_result == "1") {
                        window.setTimeout(function(){checkSmsModelReady();}, 1000);
                    } else {
                        sv__initSMSCompleted = true;
                    }
                });
            } else {
                window.setTimeout(function(){checkSmsModelReady();}, 1000);
            }
        }
        
        // ״̬
        checkTrafficLimitAlert = function(fwVm, info){
	    if(window.location.hash == '#entry'){
                return false;
            }
            var APStationEnabled = config.AP_STATION_SUPPORT ? service.getStatusInfo().ap_station_enable : 'undefined';
			var trafficResult    = getTrafficResult(info);
            var inShow           = $("#confirm-container:visible").length > 0;
            var notPPP           = (config.PRODUCT_TYPE == 'CPE' && checkCableMode(info.blc_wan_mode)) ? true : false;
			
            // ȡAp Stationʹ״̬ѷʽ
            if (config.AP_STATION_SUPPORT && (typeof APStationEnabled == "undefined" || APStationEnabled === '')) {
                service.refreshAPStationStatus({}, $.noop());
                return false;
            }
            APStationEnabled = APStationEnabled == 1;

            if (!info.isLoggedIn || inShow || (sv_trafficAlertPopuped && sv_trafficAlertPopuped_100) || !info.limitVolumeEnable || (!APStationEnabled && !(info.connectStatus == "ppp_connected")) || notPPP) {
                return false;
            }
			
            if(sv_resetTrafficAlertPopuped){
                window.setTimeout(function () {
                    sv_resetTrafficAlertPopuped = false;
                }, 2000);
                return false;
            }

        	if(trafficResult.showConfirm){
			
                var confirmMessage = null;
				
                if(trafficResult.usedPercent > 100 && !sv_trafficAlertPopuped_100){
				
                    sv_trafficAlertPopuped     = true;
					sv_trafficAlertPopuped_100 = true;
					
                    confirmMessage = {msg: APStationEnabled ? 'traffic_beyond_msg' : 'traffic_beyond_disconnect_msg'};
					
                } else if (!sv_trafficAlertPopuped) {
				
                    sv_trafficAlertPopuped     = true;
                    sv_trafficAlertPopuped_100 = false;
                    confirmMessage = {msg: APStationEnabled ? 'traffic_limit_msg' : 'traffic_limit_disconnect_msg',
                        params: [trafficResult.limitPercent]};
                }
				
                if (confirmMessage != null) {
                    if (APStationEnabled) {
                        showAlert(confirmMessage);
                    } else {
                        showConfirm(confirmMessage, function () {
                            showLoading("disconnecting");
                            service.disconnect({}, function (data) {
                                if (data.result) {
                                    successOverlay();
                                } else {
                                    errorOverlay();
                                }
                            });
                        });
                    }
                }
            }
            return true;
        };
        
        // ״̬еtooltip
        function updateStatusBarTrans(status){
    		$("#statusItemSimStatus").attr("tipTitle", "sim_status_" + status.simStatus);
    		if (status.wifiStatus) {
				if (status.deviceSize == 0) {
					$("#wifi_status").attr("tipTitle","wifi_status_on");
				} else {
					$("#wifi_status").attr("tipTitle","wifi_status" + status.deviceSize);
				}
			} else {
				$("#wifi_status").attr("tipTitle","wifi_status_off");
			}
        }


        // ˢwifi״̬
        function refreshWifiConnectStatus(fwVm, status, wifiSSID, wifiStatus) {
            fwVm.connectStatus(status);
            if (status == "ppp_disconnecting") {
                fwVm.connectStatusTrans("disconnecting");
                fwVm.connectStatusText($.i18n.prop("disconnecting"));
            } else if (status == "ppp_connecting") {
                fwVm.connectStatusTrans("connecting");
                fwVm.connectStatusText($.i18n.prop("connecting"));
            } else if (status == "ppp_connected") {
                fwVm.connectStatusTrans("connected");
                fwVm.connectStatusText($.i18n.prop("connected"));
            } else if(wifiSSID){
                if(wifiStatus =="dhcping" || wifiStatus =="connecting"){
                    fwVm.connectStatus("wifi_connecting");
                    fwVm.connectStatusTrans("connecting");
                    fwVm.connectStatusText($.i18n.prop("connecting"));
                }else if(wifiStatus =="connect"){
                    fwVm.connectStatus("wifi_connect");
                    fwVm.connectStatusTrans("connected");
                    fwVm.connectStatusText($.i18n.prop("connected"));
                }else{
                    fwVm.connectStatus("ppp_disconnected");
                    fwVm.connectStatusTrans("disconnected");
                    fwVm.connectStatusText($.i18n.prop("disconnected"));
                }
            }else{
                fwVm.connectStatusTrans("disconnected");
                fwVm.connectStatusText($.i18n.prop("disconnected"));
            }
        }
        
        // ȡǰ״̬
        getNetworkType = function(networkType) {
			var networkTypeTmp = networkType.toLowerCase();
			if (networkTypeTmp == '' || networkTypeTmp == 'limited service') {
				networkTypeTmp = 'limited_service';
			}
			if(networkTypeTmp == 'no service') {
				networkTypeTmp = 'no_service';
			}
			if (networkTypeTmp == 'limited_service' || networkTypeTmp == 'no_service') {
				$("#networkType", "#statusBar").attr("data-trans", "network_type_" + networkTypeTmp);
				return $.i18n.prop("network_type_" + networkTypeTmp);
			} else {
                $("#networkType", "#statusBar").removeAttr("data-trans");
                return networkType;
            }
		};
        
		if(config.HAS_SMS && menu.checkIsMenuExist("sms_list")){
            window.setInterval(function () {
                var info = getCurrentStatusInfo();
        		if(window.location.hash == "#entry" || sf_simStatusInvalid(info.simStatus)){
        			return;
        		}
        		for(key in sv_messagePopStack){
        			var val = sv_messagePopStack[key];
        			if($.now() - val > 5000){
        				delete(sv_messagePopStack["m" + val]);
        				var node = $(".bubbleItem#m" + val, "#buttom-bubble");
        				node.fadeOut(1000, function(){
        					$(this).remove();
        				});
        			}
        		}
        		if(info.isLoggedIn){
        			if(info.newSmsReceived && !sv_newSMSMessageInDealing){
                        sv_newSMSMessageInDealing = true;
        				service.resetNewSmsReceivedVar();
        				sf_checkNewMessages();
        			}
        			if(info.smsReportReceived){
        				service.resetSmsReportReceivedVar();
        				sf_responseSmsReport();
        			}
        		}
			}, 1000);

            if(config.SMS_DATABASE_SORT_SUPPORT){
                window.setInterval(function(){
                    if(menu.checkIsMenuExist("sms_list")){
                        var info = getCurrentStatusInfo();
                        if(info.isLoggedIn && sv__initSMSCompleted && !sv_newSMSMessageInDealing && !sf_simStatusInvalid(info.simStatus)){
                            sv_newSMSMessageInDealing = true;
                            sf_checkNewMessages();
                        }
                    }
                }, 20001);
            }
		}

    	function sf_checkNewMessages(){
		
            var s_tags     = 1;		
            var s_smsCount = 5;

            if(!config.dbMsgs || config.dbMsgs.length == 0){
                s_smsCount = 500;
                s_tags     = 10;
            }
            service.getSMSMessages({
                page : 0,
                smsCount : s_smsCount,
                nMessageStoreType : 0,
                tags : s_tags,
                orderBy : "order by id desc"
            }, function(data){
                if(data && data.messages){
                    sf_filterNewMessage(data.messages, 0);
                }
                sv_newSMSMessageInDealing = false;
            });	
            service.getSMSMessages({
                page : 0,
                smsCount : s_smsCount,
                nMessageStoreType : 1,
                tags : s_tags,
                orderBy : "order by id desc"
            }, function(data){
                if(data && data.messages){
                    sf_filterNewMessage(data.messages, 1);
                }
                sv_newSMSMessageInDealing = false;
            });
    	}

        if(config.HAS_SMS){
            $(".bubbleItem", "#buttom-bubble").live("mouseover", function(){
                var $this = $(this);
                delete(sv_messagePopStack[$this.attr("id")]);
            }).live("mouseout", function(){
                    var $this = $(this);
                    var now = $.now();
                    sv_messagePopStack["m" + now] = now;
                    $this.attr("id", "m" + now);
                    $(".bubbleItem h3 a.bubbleCloseBtn", "#buttom-bubble").data("targetid", "m" + now);
                });

            $(".bubbleItem h3 a.bubbleCloseBtn", "#buttom-bubble").die().live("click", function(){
                var id = $(this).data("targetid");
                delete(sv_messagePopStack[id]);
                var node = $(".bubbleItem#" + id, "#buttom-bubble");
                node.fadeOut(1000, function(){
                    $(this).remove();
                });
            });
        }
    }
	
	
    return {
        init:init,
        setTrafficAlertPopuped: setTrafficAlertPopuped,
        setTrafficAlert100Popuped: setTrafficAlert100Popuped,
        getTrafficResult: getTrafficResult,
        showOTAAlert:showOTAAlert
    };
});

// ͳģ
define("status_traffic_alert","jquery knockout service statusBar echarts".split(" "), 

    function ($, ko, service, status, echarts) {
	
    var sv_trafficGraph          = null;
    var sv_sourceData     = null;
    var sv_usedDataModified = false;
    var sv_usedTimeModified = false;	

    var sv_trafficStaticalInfo = {
        // ͼʼֵ
        data: {
            alarm: {          
                
                itemStyle: {
                    normal: {
                        color: '#8CC916'
                    }
                },
				name: '',
				value: 19.7
            },
            alert: {      
                
                itemStyle: {
                    normal: {
                        color: '#FF5500'
                    }
                },
				name: 'ֵ',
				value: 1
            },	
            free: {             
                
                itemStyle: {
                    normal: {
                        color: '#D8D8D8'
                    }
                },
				name: 'δʹ',
				value: 50
            },
            full: {
                
                
                itemStyle: {
                    normal: {
                        color: '#DF4313'
                    }
                },
				name: '',
				value: 30
            },			
            left1: {            
                
                itemStyle: {
                    normal: {
                        color: '#D8D8D8'
                    }
                },
				name: 'ֵδʹ',
				value: 50,
            },			
            start: {
                
                itemStyle: {
                    normal: {
                        color: '#D8D8D8'
                    }
                },
				name: 'ֵδʹ',
				value: 50
            },
            used: {
                
                itemStyle: {
                    normal: {
                        color: '#8CC916'
                    }
                },
				name: 'ʹ',
				value: 30
            }
        },	
        cacheEle: {},
        // Ԫػȡ
        getEle: function (i_elementId) {
            if (this.cacheEle.hasOwnProperty('id')) {
                return this.cacheEle[i_elementId];
            } else {
                this.cacheEle[i_elementId] = $("#" + i_elementId);
                return this.cacheEle[i_elementId];
            }
        },
        // ȡ澯״ֵ̬
        fetchTrafficAlertInfo: function(){
            sv_sourceData = getTrafficAlertInfo();
            return sv_sourceData;
        },		
        // ȡֵͶӦλֵ
        getTrafficStatisticalDatalnfo: function (i_valueInfo) {
            return {
                data: /\d+(.\d+)?/.exec(i_valueInfo)[0],
                unit: /[A-Z]{1,2}/.exec(i_valueInfo)[0]
            }
        },
			
        // ȡʱʱ֡
        getTrafficTimeHours: function (i_time) {
            var s_timeArray = i_time.split(':');
            return {
                h: parseInt(s_timeArray[0], 10),
                m: parseInt(s_timeArray[1], 10),
                s: parseInt(s_timeArray[2], 10)
            }
        },
        // ȡͳʱͶӦλֵ
        getTrafficTimeInfo: function (i_valueInfo) {
            return {
                data: /\d+(.\d+)?/.exec(i_valueInfo)[0],
                unit: /[a-z]{4,6}/.exec(i_valueInfo)[0]
            }
        },
        // ʱ任S
        getTrafficTimeToSeconds: function (i_time) {
            var s_FormattedTime = this.getTrafficTimeHours(i_time);
            return s_FormattedTime.h * 3600 + s_FormattedTime.m * 60 + s_FormattedTime.s;
        },			
        // ͨƻȡλ
        getTrafficUnitByScale: function (i_scale) {
            if (i_scale == '1024') {
                return 'GB';
            } else if (i_scale == '1048576') {
                return 'TB';
            } else {
                return 'MB';
            }
        },			
        // λӦֵȡ
        getTrafficValueByStatisticalUnit: function (i_unit) {
            i_unit = i_unit.toLowerCase();
            if(i_unit == 'minute'){
				return '60';
			} else if (i_unit == 'gb') {
                return '1024';
            } else if(i_unit == 'hour'){
				return '3600';
			} else if (i_unit == 'tb') {
                return '1048576';
            } else {
                return '1';
            }
        },

        // Ƿɱ༭
        isFormEditable: function (fwVm) {
            var s_dataPageEditState = fwVm.dataLimitTypeChecked() == '1' && (fwVm.viewEditUsedData() || fwVm.viewEditAlertData() || fwVm.viewEditTotalData());
            var s_timePageEditState = fwVm.dataLimitTypeChecked() == '0' && (fwVm.viewEditUsedTime() || fwVm.viewEditAlertTime() || fwVm.viewEditTotalTime());
            if (s_dataPageEditState || s_timePageEditState) {
                $('.border-color-transition:visible').addClass('attention-focus');
                addTimeout(function () {
                    $('.border-color-transition:visible').removeClass('attention-focus');
                }, 1500);
                return true;
            } else {
                var s_result = false;
                if (fwVm.dataLimitTypeChecked() == 1) {
                    if (fwVm.alertDataReach() == '0') {
                        fwVm.editAlertDataHandler();
                        s_result = true;
                    }
                    if (fwVm.limitDataMonth() == '0') {
                        fwVm.editTotalDataHandler();
                        s_result = true;
                    }
                } else {
					if (fwVm.alertTimeReach() == '0') {
                        fwVm.editAlertTimeHandler();
                        s_result = true;
                    }
                    if (fwVm.limitTimeMonth() == '0') {
                        fwVm.editTotalTimeHandler();
                        s_result = true;
                    }
                }
				
                if (s_result) {
                    $('.border-color-transition:visible').addClass('attention-focus');
                    addTimeout(function () {
                        $('.border-color-transition:visible').removeClass('attention-focus');
                    }, 1500);
                }
                return s_result;
            }
        },
 
        // ˢͼϢֵʾ

        refreshFlowDiagramInfo: function (fwVm) {
            var s_alarm  = 0;
            var s_left   = 0;
            var s_left1  = 0;
            var s_reach  = 0;	
            var s_total  = 0;
            var s_used   = 0;


            var s_startName = $.i18n.prop("echarts_no");

            if (sv_sourceData.dataLimitChecked == '1') { //if (fwVm.dataLimitChecked() == '1') { //
	        	s_startName = $.i18n.prop("echarts_used");
	        	sv_trafficGraphOptions.series[0].data = [];    
		
				if (fwVm.dataLimitTypeChecked() == '1') { // 
                    sv_trafficGraphOptions.title.text = "";
                    sv_trafficGraphOptions.series[0].data = [];
			
                    if (fwVm.limitDataMonth() == 0) {
                        var s_usedData = sv_trafficStaticalInfo.data.used;
                        s_usedData.value = 1;
                        s_usedData.name = $.i18n.prop("echarts_used");
                        s_usedData.selected = false;
                        sv_trafficGraphOptions.series[0].data.push(s_usedData);
                    } else {
                        s_total = fwVm.limitDataMonth() * fwVm.selectedDataUnit() * 1048576;
                        s_used  = parseInt(sv_sourceData.monthlySent, 10) + parseInt(sv_sourceData.monthlyReceived, 10);
                        s_reach = s_total * fwVm.alertDataReach() / 100;

                        if (s_used >= s_total) {
                            var s_fullData    = sv_trafficStaticalInfo.data.full;
                            s_fullData.value  = 100;
                            s_fullData.name   = $.i18n.prop("echarts_full");
                            sv_trafficGraphOptions.series[0].data.push(s_fullData);
                            s_startName = $.i18n.prop("echarts_full");
                        } else {
                            if (s_reach > s_used) { 
                                s_left1 = s_reach - s_used;
                                s_left  = s_total - s_reach;
                            } else { 
                                s_alarm = s_used - s_reach;
                                s_left  = s_total - s_used;
                            }

                            var s_usedData = sv_trafficStaticalInfo.data.used;
                            if (s_reach - s_used > 0) {
                                s_usedData.value = s_used;
                            } else {
                                s_usedData.value = s_reach;
                            }
                            s_usedData.name = $.i18n.prop("echarts_used");
                            sv_trafficGraphOptions.series[0].data.push(s_usedData);

                            if (s_left1 > 0) {
                                var s_left1Data     = sv_trafficStaticalInfo.data.left1;
                                s_left1Data.value   = s_left1;
                                s_left1Data.name    = $.i18n.prop("echarts_left1");
                                sv_trafficGraphOptions.series[0].data.push(s_left1Data);
                            }

                            var s_alertData         = sv_trafficStaticalInfo.data.alert;
                            s_alertData.value       = s_total / 200;
                            s_alertData.name        = $.i18n.prop("echarts_alert");
                            sv_trafficGraphOptions.series[0].data.push(s_alertData);

                            if (s_alarm > 0) {
                                var s_alarmData     = sv_trafficStaticalInfo.data.alarm;
                                s_alarmData.value   = s_alarm;
                                s_alarmData.name    = $.i18n.prop("echarts_alarm");
                                sv_trafficGraphOptions.series[0].data.push(s_alarmData);
                            }

                            var s_freeData          = sv_trafficStaticalInfo.data.free;
                            s_freeData.value        = s_left;
                            s_freeData.name         = $.i18n.prop("echarts_free");
                            sv_trafficGraphOptions.series[0].data.push(s_freeData);
                        }
                    }	
				
				}else{// ʱ
            
                    sv_trafficGraphOptions.series[0].data = [];
			
                    if (fwVm.limitTimeMonth() == 0) {
                        var s_usedData        = sv_trafficStaticalInfo.data.used;
                        s_usedData.value      = 1;
                        s_usedData.selected   = false;
                        s_usedData.name       = $.i18n.prop("echarts_used");
                        sv_trafficGraphOptions.series[0].data.push(s_usedData);
                    } else {
                        s_total  = fwVm.limitTimeMonth() * fwVm.selectedTimeUnit();
                        s_used   = sv_sourceData.monthlyConnectedTime;
                        s_reach  = s_total * fwVm.alertTimeReach() / 100;
				
                        if (s_used >= s_total) {
                            var fullTime   = sv_trafficStaticalInfo.data.full;
                            fullTime.value = 100;
                            fullTime.name  = $.i18n.prop("echarts_full");
                            sv_trafficGraphOptions.series[0].data.push(fullTime);
                            s_startName    = $.i18n.prop("echarts_full");
                        } else {
                            if (s_reach - s_used > 0) {
                                s_left1 = s_reach - s_used;
                                s_left  = s_total - s_reach;
                            } else {
                                s_alarm = s_used  - s_reach;
                                s_left  = s_total - s_used;
                            }

                            var s_usedTime = sv_trafficStaticalInfo.data.used;
                            if (s_reach - s_used > 0) {
                                s_usedTime.value = s_used;
                            } else {
                                s_usedTime.value = s_reach;
                            }
                            s_usedTime.name = $.i18n.prop("echarts_used");
                            sv_trafficGraphOptions.series[0].data.push(s_usedTime);

                            if (s_left1 > 0) {
                                var s_left1Time    = sv_trafficStaticalInfo.data.left1;
                                s_left1Time.value  = s_left1;
                                s_left1Time.name   = $.i18n.prop("echarts_left1");
                                sv_trafficGraphOptions.series[0].data.push(s_left1Time);
                            }

                            var s_alertTime        = sv_trafficStaticalInfo.data.alert;
                            s_alertTime.value      = s_total / 200;
                            s_alertTime.name       = $.i18n.prop("echarts_alert");
                            sv_trafficGraphOptions.series[0].data.push(s_alertTime);

                            if (s_alarm > 0) {
                                var s_alarmTime      = sv_trafficStaticalInfo.data.alarm;
                                s_alarmTime.value    = s_alarm;
                                s_alarmTime.name     = $.i18n.prop("echarts_alarm");
                                sv_trafficGraphOptions.series[0].data.push(s_alarmTime);
                            }

                            var s_freeTime         = sv_trafficStaticalInfo.data.free;
                            s_freeTime.value       = s_left;
                            s_freeTime.name        = $.i18n.prop("echarts_free");
                            sv_trafficGraphOptions.series[0].data.push(s_freeTime);
                        }
                    }		
                } 
            } else {
                var s_usedData      = sv_trafficStaticalInfo.data.used;
                s_usedData.value    = 1;
                s_usedData.selected = false;
                s_usedData.name     = $.i18n.prop("echarts_no");
		
                sv_trafficGraphOptions.series[0].data = [s_usedData];
                sv_trafficGraphOptions.title.text     = '';			
            }
            sv_trafficStaticalInfo.setFlowDiagramInfo(sv_trafficGraphOptions, s_startName);
        },

		
		// ػͼ
        setFlowDiagramInfo: function (i_options, i_startName) {
            var s_startPart = sv_trafficStaticalInfo.data.start;

            s_startPart.name     = i_startName;			
            s_startPart.selected = false;
            s_startPart.value    = 0;
			
            var s_arr = [s_startPart].concat(i_options.series[0].data);
            i_options.series[0].data = s_arr;
            sv_trafficGraph.setOption(i_options, true);
			
            addTimeout(function () {
                sv_trafficGraph.resize();
            }, 1000);
        }
    };


    // ͼ
    var sv_trafficGraphOptions = {
        animation: false,
        color: ['red', 'red', 'red', 'red', 'red'],
        series: [
            {
                name: '',
                radius: ['0', '75'],
                selectedOffset: 3,				
                type: 'pie',				
                data: [

                ],			
                itemStyle: {
                    normal: {
                        labelLine: {
                            show: false
                        },
                        label: {
                            show: false
                        }
                    }
                }				
            }
        ],		
        title: {
            itemGap: 0,
			      text: '',
            subtextStyle: {
                color: '#FFF',
                fontFamily: '΢ź',
                fontSize: 16,
                fontWeight: 'bolder'
            },				  
            textStyle: {
                color: '#FFF',
                fontFamily: '΢ź',
                fontSize: 20,
                fontWeight: 'bolder'
            },
            x: 'center',
            y: 'center'			
        },
		tooltip: {
            formatter: "{b}"
        }      
    };


    // ȡ
    function getTrafficAlertInfo() {
        return service.getTrafficAlertInfo();
    }


	
    // ViewModel

    function trafficViewModel() {

        var target         = this;
		
        var info                    = sv_trafficStaticalInfo.fetchTrafficAlertInfo();	
        var dataMonth               = info.limitDataMonth.split("_");
		
        sv_usedDataModified         = false;
        sv_usedTimeModified         = false;

        target.alertDataReach               = ko.observable(info.alertDataReach || 0);		
        target.alertTimeReach               = ko.observable(info.alertTimeReach || 0);
        target.dataLimitChecked             = ko.observable(info.dataLimitChecked == '0' ? '0' : '1');
        target.dataLimitTypeChecked         = ko.observable(info.dataLimitTypeChecked == '0' ? '0' : '1');
        target.limitTimeMonth               = ko.observable(info.limitTimeMonth || 0);	

		
        // ע˳ 
        target.usedDataText                 = ko.observable(transUnit(parseInt(info.monthlySent, 10) + parseInt(info.monthlyReceived, 10), false));
        var sv_staticalDataInfo             = sv_trafficStaticalInfo.getTrafficStatisticalDatalnfo(target.usedDataText());
        var sv_staticalInfoData             = sv_staticalDataInfo.data;
        target.dataUsed                     = ko.observable(sv_staticalInfoData);	
        var sv_staticalInfoUnit             = sv_staticalDataInfo.unit;
        target.selectedDataUsedUnit         = ko.observable(sv_trafficStaticalInfo.getTrafficValueByStatisticalUnit(sv_staticalInfoUnit));
        target.usedDataTextDescData         = ko.observable("");
		
        target.limitDataMonth               = ko.observable(dataMonth[0] || 0);		
        target.selectedDataUnit             = ko.observable(dataMonth[1] || 1);		

        var limitDataMonthTmp               = transUnit(target.limitDataMonth() * target.selectedDataUnit() * 1024 * 1024, false);
        var limitDataMonthUnitTmp           = limitDataMonthTmp.substring(limitDataMonthTmp.length-2);
        target.limitDataMonth(limitDataMonthTmp.substring(0, limitDataMonthTmp.length-2));
        target.selectedDataUnit(sv_trafficStaticalInfo.getTrafficValueByStatisticalUnit(limitDataMonthUnitTmp));	
		
        target.usedDataTextDesc             = ko.computed(sf_usedDataTextDesc);	
        target.limitDataMonthDescData       = ko.observable("");
        target.limitDataMonthDesc           = ko.computed(sf_limitDataMonthDesc);	
        target.alertDataReachDescData       = ko.observable("");		
        target.alertDataReachDesc           = ko.computed(sf_alertDataReachDesc);	
        target.leftDataDescData             = ko.observable("");
        target.leftDataDesc                 = ko.computed(sf_leftDataDesc);	
        target.monthlyConnectedTime         = ko.observable(transSecond2Time(info.monthlyConnectedTime));
		
		var sv_timeInfo1                    = sv_trafficStaticalInfo.getTrafficTimeInfo(transTimeUnit(info.monthlyConnectedTime));
        target.usedTime                     = ko.observable(sv_timeInfo1.data);		
		target.selectedTimeUsedUnit         = ko.observable(sv_trafficStaticalInfo.getTrafficValueByStatisticalUnit(sv_timeInfo1.unit));	
		
        target.usedTimeTextDescData         = ko.observable("");
        target.usedTimeTextDesc             = ko.computed(sf_usedTimeTextDesc);		
		
		var  sv_timeInfoNew                 = sv_trafficStaticalInfo.getTrafficTimeInfo(transTimeUnit(parseFloat(target.limitTimeMonth()) * 3600));
		target.selectedTimeUnit             = ko.observable(sv_trafficStaticalInfo.getTrafficValueByStatisticalUnit(sv_timeInfoNew.unit));
		target.limitTimeMonth(sv_timeInfoNew.data);
		
		
        target.limitTimeMonthDescData       = ko.observable("");
		target.limitTimeMonthDescText       = ko.observable("traffic_limit_time_h");		        
        target.limitTimeMonthDesc           = ko.computed(sf_limitTimeMonthDesc);
        target.alertTimeReachDescData       = ko.observable("");       	
        target.alertTimeReachDesc           = ko.computed(sf_alertTimeReachDesc);
        target.leftTimeDescData             = ko.observable("");        
        target.leftTimeDesc                 = ko.computed(sf_leftTimeDesc);
        target.save                         = sf_save;		
        target.viewEditUsedData             = ko.observable(false);
        target.editUsedDataHandler          = sf_editUsedDataHandler;
        target.editUsedDataSaveHandler      = sf_editUsedDataSaveHandler;		
        target.saveUsedData                 = sf_saveUsedData;		
        target.editUsedDataCancelHandler    = sf_editUsedDataCancelHandler;
        target.viewEditTotalData            = ko.observable(false);
		target.editTotalDataHandler         = sf_editTotalDataHandler;
		target.editTotalDataSaveHandler     = sf_editTotalDataSaveHandler;
        target.editTotalDataCancelHandler   = sf_editTotalDataCancelHandler;
        target.viewEditAlertData            = ko.observable(false);
		target.editAlertDataHandler         = sf_editAlertDataHandler;
		target.editAlertDataSaveHandler     = sf_editAlertDataSaveHandler;
		target.editAlertDataCancelHandler   = sf_editAlertDataCancelHandler;
        target.viewEditUsedTime             = ko.observable(false);
		target.editUsedTimeHandler          = sf_editUsedTimeHandler;	
		target.saveUsedTime                 = sf_saveUsedTime;
		target.editUsedTimeSaveHandler      = sf_editUsedTimeSaveHandler;
		target.editUsedTimeCancelHandler    = sf_editUsedTimeCancelHandler;
		target.viewEditTotalTime            = ko.observable(false);
		target.editTotalTimeHandler         = sf_editTotalTimeHandler ;
        target.editTotalTimeSaveHandler     = sf_editTotalTimeSaveHandler;	
		target.editTotalTimeCancelHandler   = sf_editTotalTimeCancelHandler;
		target.viewEditAlertTime            = ko.observable(false);
        target.editAlertTimeHandler         = sf_editAlertTimeHandler;		
        target.editAlertTimeSaveHandler     = sf_editAlertTimeSaveHandler;
        target.editAlertTimeCancelHandler   = sf_editAlertTimeCancelHandler;
        sv_trafficStaticalInfo.refreshFlowDiagramInfo(target);		
		

        // 
		function sf_alertDataReachDesc() {
            if(isNaN(target.limitDataMonth() * target.selectedDataUnit() * target.alertDataReach())) {
                target.alertDataReachDescData(target.alertDataReach() + ', ');
                return $.i18n.prop('traffic_alert_reach_text', target.alertDataReach(), ' ');
            }

            var s_value = transUnit(target.limitDataMonth() * target.selectedDataUnit() * target.alertDataReach() * 1048576 / 100, false);
            target.alertDataReachDescData(target.alertDataReach() + ',' + s_value);
            return $.i18n.prop('traffic_alert_reach_text', target.alertDataReach(), s_value);
        }
		// ʱ
        function sf_alertTimeReachDesc() {
            if(isNaN(target.limitTimeMonth() * target.alertTimeReach())) {
                target.alertTimeReachDescData(target.alertTimeReach() + ', ');
                return $.i18n.prop('traffic_alert_reach_text', target.alertTimeReach(), ' ');
            }
            var s_value = transSecond2Time(target.limitTimeMonth() * target.selectedTimeUnit() * target.alertTimeReach() / 100);
            target.alertTimeReachDescData(target.alertTimeReach() + ',' + s_value);
            return $.i18n.prop('traffic_alert_reach_text', target.alertTimeReach(), s_value);
        }	
	
		
        // ֵȡ༭ť¼
		function sf_editAlertDataCancelHandler() {
            target.alertDataReach(sv_trafficStaticalInfo.getEle('editAlertData').data('oldValue'));
            target.viewEditAlertData(false);
        }		
				
        // ֵ༭ť¼
		function sf_editAlertDataHandler() {
            sv_trafficStaticalInfo.getEle('editAlertData').data('oldValue', target.alertDataReach());
            target.viewEditAlertData(true);
        }
        
        // ֵ༭ť¼
		function sf_editAlertDataSaveHandler() {
            if (sv_trafficStaticalInfo.getEle('alertDataReach').valid()) {
                target.viewEditAlertData(false);
            }
        }
		
        // ʱֵȡ༭ť¼
		function sf_editAlertTimeCancelHandler() {
            target.alertTimeReach(sv_trafficStaticalInfo.getEle('editAlertTime').data('oldValue'));
            target.viewEditAlertTime(false);
        }	 
        // ʱֵ༭ť¼
		function sf_editAlertTimeHandler() {
            sv_trafficStaticalInfo.getEle('editAlertTime').data('oldValue', target.alertTimeReach());
            target.viewEditAlertTime(true);
        } 		
        // ʱֵ༭ť¼
		function sf_editAlertTimeSaveHandler() {
            if (sv_trafficStaticalInfo.getEle('alertTimeReach').valid()) {
                target.viewEditAlertTime(false);
            }
        }		
	
        // ײ༭ť¼
		function sf_editTotalDataHandler() {
            sv_trafficStaticalInfo.getEle('editTotalData').data('oldValue', target.limitDataMonth());
            sv_trafficStaticalInfo.getEle('selectedDataUnit').data('oldValue', target.selectedDataUnit());
            target.viewEditTotalData(true);
        }
        
        // ײ༭ť¼
		function sf_editTotalDataSaveHandler() {
            if (sv_trafficStaticalInfo.getEle('limitDataMonth').valid()) {
                target.usedDataText(transUnit(target.limitDataMonth() * target.selectedDataUnit() * 1048576, false));
                target.viewEditTotalData(false);
            }
        }
        
        // ײȡ༭ť¼
		function sf_editTotalDataCancelHandler() {
            target.limitDataMonth(sv_trafficStaticalInfo.getEle('editTotalData').data('oldValue'));
            target.selectedDataUnit(sv_trafficStaticalInfo.getEle('selectedDataUnit').data('oldValue'));
            target.viewEditTotalData(false);
        }
        // ײʱȡ༭ť¼
		function sf_editTotalTimeCancelHandler() {
            target.limitTimeMonth(sv_trafficStaticalInfo.getEle('editTotalTime').data('oldValue'));
            target.viewEditTotalTime(false);
        }       
        // ײʱ༭ť¼
		function sf_editTotalTimeHandler() {
            sv_trafficStaticalInfo.getEle('editTotalTime').data('oldValue', target.limitTimeMonth());
            target.viewEditTotalTime(true);
        }       
        // ײʱ䱣༭ť¼
		function sf_editTotalTimeSaveHandler() {
            if (sv_trafficStaticalInfo.getEle('limitTimeMonth').valid()) {
                target.viewEditTotalTime(false);
            }
        }		

        // ȡ༭ť¼
		function sf_editUsedDataCancelHandler() {
            target.dataUsed(sv_trafficStaticalInfo.getEle('editUsedData').data('oldValue'));
            target.selectedDataUsedUnit(sv_trafficStaticalInfo.getEle('selectedDataUsedUnit').data('oldValue'));
            sv_trafficStaticalInfo.getEle('editUsedDataCancel').siblings('label.error').hide();
            target.viewEditUsedData(false);
        }	
        // ༭ť¼
		function sf_editUsedDataHandler() {
            sv_trafficStaticalInfo.getEle('editUsedData').data('oldValue', target.dataUsed());
            sv_trafficStaticalInfo.getEle('selectedDataUsedUnit').data('oldValue', target.selectedDataUsedUnit());
            target.dataUsed(target.dataUsed());
            target.viewEditUsedData(true);
        }	
        // 水ť¼
		function sf_editUsedDataSaveHandler() {
            if (sv_trafficStaticalInfo.getEle('dataUsed').valid()) {
                sv_usedDataModified = true;
                target.viewEditUsedData(false);
            }
        }		
        // ʱȡ༭ť¼
		function sf_editUsedTimeCancelHandler() {
            target.usedTime(sv_trafficStaticalInfo.getEle('editUsedTime').data('oldValue'));
            target.viewEditUsedTime(false);
        }		
        // ʱ༭ť¼
		function sf_editUsedTimeHandler() {
            sv_trafficStaticalInfo.getEle('editUsedTime').data('oldValue', target.usedTime());
            target.viewEditUsedTime(true);
        }

        // ʱ䱣༭ť¼
		function sf_editUsedTimeSaveHandler() {
            if (sv_trafficStaticalInfo.getEle('usedTime').valid()) {
                target.monthlyConnectedTime(transSecond2Time(parseFloat(target.usedTime()) * target.selectedTimeUsedUnit()));
                target.viewEditUsedTime(false);
                sv_usedTimeModified = true;
            }
        }

		// ʣ	
        function sf_leftDataDesc() {
            var s_left = (target.limitDataMonth() * target.selectedDataUnit() - target.dataUsed() * target.selectedDataUsedUnit()) * 1048576;
            if(s_left < 0) {
                s_left = 0;
            }

            if(isNaN(s_left)) {
                target.leftDataDescData('');
                return $.i18n.prop('traffic_data_left_text', ' ');
            }

            target.leftDataDescData(transUnit(s_left, false));
            return $.i18n.prop('traffic_data_left_text', transUnit(s_left, false));
        }	
		//ʣʱ
		function sf_leftTimeDesc() {
            var s_surplus = target.limitTimeMonth() * target.selectedTimeUnit() - sv_trafficStaticalInfo.getTrafficTimeToSeconds(target.monthlyConnectedTime());
            if(s_surplus < 0) {
                s_surplus = 0;
            }

            if(isNaN(s_surplus)) {
                target.leftTimeDescData(' ');
                return $.i18n.prop('traffic_data_left_text', ' ');
            }
            target.leftTimeDescData(transSecond2Time(s_surplus));
            return $.i18n.prop('traffic_data_left_text', transSecond2Time(s_surplus));
        }
		// ײ
		function sf_limitDataMonthDesc() {
            if(isNaN(target.limitDataMonth())) {
                target.limitDataMonthDescData("");
                return $.i18n.prop('traffic_limit_data_text', ' ');
            }else{
			    // todo
			}
			
            target.limitDataMonthDescData(target.limitDataMonth() + sv_trafficStaticalInfo.getTrafficUnitByScale(target.selectedDataUnit()));
            return $.i18n.prop('traffic_limit_data_text', target.limitDataMonth() + sv_trafficStaticalInfo.getTrafficUnitByScale(target.selectedDataUnit()));
        }	
		// ײʱ	
		function sf_limitTimeMonthDesc() {
            if(isNaN(target.limitTimeMonth())) {
                target.limitTimeMonthDescData(' ');
				target.limitTimeMonthDescText('traffic_limit_time_h');
                return $.i18n.prop('traffic_limit_time_h', ' ');
            }else{
			    // todo:
			}
			
            target.limitTimeMonthDescData(target.limitTimeMonth());
			
			if(target.selectedTimeUnit() == "60"){
				target.limitTimeMonthDescText('traffic_limit_time_m');
				return $.i18n.prop('traffic_limit_time_m', target.limitTimeMonth());
			}else{
				target.limitTimeMonthDescText('traffic_limit_time_h');
				return $.i18n.prop('traffic_limit_time_h', target.limitTimeMonth());
			}		
        }
		
        // Ӧðť¼
        function sf_save() {
            if (sv_trafficStaticalInfo.isFormEditable(target) && target.dataLimitChecked() == '1') {
                return false;
            }
			
            if (target.selectedDataUnit() == '1' && target.selectedDataUsedUnit() == '1048576' && target.dataLimitTypeChecked() == "1" && target.dataLimitChecked() == '1' && !(parseInt(target.dataUsed(), 10) < parseInt('4096', 10)) ) {
                showAlert('traffic_over_note');
				return false;
            }
			
            showLoading();
            service.setTrafficAlertInfo({
			    alertDataReach: parseInt(target.alertDataReach(), 10),
				alertTimeReach: parseInt(target.alertTimeReach(), 10),
                dataLimitChecked: target.dataLimitChecked(),
                dataLimitTypeChecked: target.dataLimitTypeChecked(),
                limitDataMonth: target.limitDataMonth() + "_" + target.selectedDataUnit(),             
                limitTimeMonth: target.selectedTimeUnit() == "60" ? target.limitTimeMonth()/60 : target.limitTimeMonth()//save by hours               
            }, function (data) {
                if (data.result == 'success') {
                    if(target.dataLimitTypeChecked() == "1" && sv_usedDataModified) {
                        target.saveUsedData();
                    } else if(target.dataLimitTypeChecked() == "0" && sv_usedTimeModified) {
                        target.saveUsedTime();
                    } else {
                        sv_trafficStaticalInfo.fetchTrafficAlertInfo();
                        sv_trafficStaticalInfo.refreshFlowDiagramInfo(target);
                        status.setTrafficAlertPopuped(false);
                        successOverlay();
                    }
                } else {
                    errorOverlay();
                }
            }, function () {
                sv_trafficStaticalInfo.refreshFlowDiagramInfo(target);
                errorOverlay();
            });
        }		
		
        // 	
		function sf_saveUsedData() {
            var val = target.dataUsed() * target.selectedDataUsedUnit();
            service.trafficCalibration({
                way: 'data',
                value: val
            }, function(){
                sv_trafficStaticalInfo.fetchTrafficAlertInfo();
                sv_trafficStaticalInfo.refreshFlowDiagramInfo(target);
                successOverlay();
                target.viewEditUsedData(false);
                status.setTrafficAlertPopuped(false);
                sv_usedDataModified = false;
            }, function(){
                sv_trafficStaticalInfo.fetchTrafficAlertInfo();
                sv_trafficStaticalInfo.refreshFlowDiagramInfo(target);
                errorOverlay();
            });
        }	


		
		function sf_saveUsedTime() {
            service.trafficCalibration({
                way: 'time',
                value: target.selectedTimeUsedUnit() == "60" ? parseFloat(target.usedTime())/60 : target.usedTime()
            }, function(){
                sv_trafficStaticalInfo.fetchTrafficAlertInfo();
                sv_trafficStaticalInfo.refreshFlowDiagramInfo(target);
                successOverlay();
                target.monthlyConnectedTime(transSecond2Time(parseFloat(target.usedTime()) * target.selectedTimeUsedUnit()));
                target.viewEditUsedTime(false);
                status.setTrafficAlertPopuped(false);
                sv_usedTimeModified = false;
            }, function(){
                sv_trafficStaticalInfo.fetchTrafficAlertInfo();
                sv_trafficStaticalInfo.refreshFlowDiagramInfo(target);
                errorOverlay();
            });
        }	

		
        // 	
		function sf_usedDataTextDesc() {
            if(isNaN(target.dataUsed())) {
                target.usedDataTextDescData("");
                return $.i18n.prop('traffic_used_text', ' ');
            }
            target.usedDataTextDescData(target.dataUsed() + sv_trafficStaticalInfo.getTrafficUnitByScale(target.selectedDataUsedUnit()));
            return $.i18n.prop('traffic_used_text', target.dataUsed() + sv_trafficStaticalInfo.getTrafficUnitByScale(target.selectedDataUsedUnit()));
        }		
        // ʱ
        function sf_usedTimeTextDesc() {
            target.usedTimeTextDescData(target.monthlyConnectedTime());
            return $.i18n.prop('traffic_used_text', target.monthlyConnectedTime());
        }			

        
    }
	
    function init() {
        sv_trafficGraph = echarts.init($("#traffic_graphic")[0]);
        window.onresize = sv_trafficGraph.resize;
        var s_container = $('#container');
        ko.cleanNode(s_container[0]);
        var fwVm = new trafficViewModel();
        ko.applyBindings(fwVm, s_container[0]);
        $('#trafficAlertForm').validate({
            submitHandler: function () {
                fwVm.save();
            },
            
			
            errorPlacement: function (error, para) {
                if (para.attr("name") == "alertDataReach") {
                    error.insertAfter("#editAlertDataDiv");
                } else if (para.attr("name") == "alertTimeReach") {
                    error.insertAfter("#editAlertTimeDiv");
                } else if (para.attr("name") == "dataUsed") {
                    error.insertAfter("#editUsedDataDiv");
                } else if (para.attr("name") == "limitDataMonth") {
                    error.insertAfter("#editTotalDataDiv");
                } else if (para.attr("name") == "limitTimeMonth") {
                    error.insertAfter("#editTotalTimeDiv");
                } else if (para.attr("name") == "usedTime") {
                    error.insertAfter("#editUsedTimeDiv");
                } else {
                    error.insertAfter(para);
                }
            },

            rules: {
			    alertDataReach: {
                    range: [ 1, 100 ],
					digits: true
                },
                alertTimeReach: {
                    range: [ 1, 100 ],
                    digits: true
                },
                dataUsed: {
					range : [ 0, 9999 ],
					decimalRange : true
                },
                limitDataMonth: {
					range : [ 1, 9999 ],
					decimalRange : true
                },
                limitTimeMonth: {
					range : [ 1, 9999 ],
					decimalRange : true
                },
				usedTime: {
					range : [ 0, 9999 ],
					decimalRange : true
                }  
            }			
			
        });
		
		var sv_originalLan = window.language;
		window.setInterval(function(){			
			if(sv_originalLan != window.language){
				sv_originalLan = window.language;
				sv_trafficStaticalInfo.refreshFlowDiagramInfo(fwVm);
			}
        }, 1000);

    }

    return {
        init: init
    };
});

// ״̬ʾʵ
define("tooltip",[ "jquery" ], 
    
	function($) {	


			// ԪλϢ
			// @method calculatePositionInfo
			// @param trigger Ԫ
			// @param tooltip ״̬
			// @param {JSON} config λ
			
			function calculatePositionInfo(trigger, tooltip, config) {
				var top      = trigger.offset().top; 
				var left     = trigger.offset().left; 
				var position = config.position[0];
				var height   = tooltip.outerHeight() + trigger.outerHeight();
				var width    = tooltip.outerWidth() + trigger.outerWidth();

				top         -= tooltip.outerHeight() - config.offset[0];
				left        += trigger.outerWidth()  + config.offset[1];

				if (/iPad/i.test(navigator.userAgent)) {
					top -= $(window).scrollTop();
				}

				if (position == 'center') {
					top += height / 2;
				}
				if (position == 'bottom') {
					top += height;
				}
				position = config.position[1];
				if (position == 'center') {
					left -= width / 2;
				}else if (position == 'left') {
					left -= width;
				}
				
				return {
					top : top,
					left : left
				};
			}	
	
			// ״̬ʼ
			function init() {

				$(".statusItem", "#statusBar").each(function(i, n){
					var $this = $(this);
					$this.attr("tipTitle", $this.attr("title")).removeAttr("title");
				}).hover(
						function() {
							var $this = $(this);
							var title = $this.attr("tipTitle");
							var tooltip = $("<div>").addClass("tooltip in").appendTo(document.body).hide()
									.append($this.attr("i18n") ? $.i18n.prop(title) : title);
							if ($this.attr("i18n")) {
								tooltip.attr("data-trans", title).attr("id", "tooltip_" + $this.attr("id"));
							}
							var pos = calculatePositionInfo($this, tooltip, {
								position : [ 'bottom', 'center' ],
								offset : [ 0, 0 ]
							});
							tooltip.css({
								position : 'absolute',
								top : pos.top,
								left : pos.left
							}).show();
						}, function() {
							$(".tooltip").hide().remove();
						});
			}
					
			return {
				init : init
			};
		});

define("menu","set service knockout underscore jquery".split(" "),
    function (set, fnc, libko, libus, libjq) {
    var displayMenuWhenLogout = false;
    var vmMenu;
    var menu = [];
    var menuResource = "";

    function menuExistCheck(path) {
        for (var i = 0; i < menu.length; i++) {
            if (menu[i].path == path) {
                return true;
            }
        }
        return false;
    }

    function getIsLoggedin() {
        var loginStatus = fnc.getLoginStatus();
        return (loginStatus.status == "loggedIn");
    }

    function buildNew() {
        var loggedIn = getIsLoggedin();
        var menuMain = libus.filter(menu, function (param) {
            return (param.level == '1' && ((param.requireLogin && loggedIn) || !param.requireLogin) && param.hash != "#entry");
        });
        vmMenu.menuMain(menuMain);
        vmMenu.loggedIn(loggedIn);

        getMainWth(vmMenu.menuMain().length);
        vmMenu.showMenu(loggedIn || displayMenuWhenLogout);
        libjq("#nav").translate();
    }

    function getMainWth(len) {
        var width = 100 / len;
        libjq('ul#list-nav li').each(function () {
            libjq(this).css('width', width + '%');
        });
    }

    function menuRefresh() {
        var currentHash = window.location.hash;
        var itmRoot = libus.find(menu, function (param) {
            return param.hash == currentHash;
        });
        while (itmRoot.parent) {
            itmRoot = libus.find(menu, function (param) {
                return param.hash == itmRoot.parent;
            });
        }
        if (!itmRoot.parent) {
            libjq("#list-nav li").removeClass("active");
            var mid = itmRoot.hash.substring(1, itmRoot.hash.length);
            libjq("#list-nav li[mid=" + mid + "]").addClass("active");
        }
        vmMenu.changeMenu(itmRoot);
    }

    function menuSearch(hashVal) {
        hashVal = hashVal || window.location.hash;
        var loggedIn = getIsLoggedin();
        return libus.filter(menu, function (param) {
            return (hashVal == param.hash && ((param.requireLogin && loggedIn) || !param.requireLogin));
        });
    }

    function menuRenderSub(level, baseItem) {
        var levelItem = libus.find(menu, function (param) {
            return param.parent == baseItem.hash && param.path == baseItem.path;
        });
        libjq(".menu-" + level + "-level").removeClass("active");
        if (levelItem) {
            if (level == "two") {
                menuRenderSub("three", levelItem);
                //forward/backward support
                clickMenuTrig(levelItem.hash, level);
            }
            libjq(".menu-" + level + "-level." + levelItem.hash.substring(1)).addClass("active");
        }
    }

    function menuActSub() {
        var currentHash = window.location.hash;
        var itmRoot = libus.find(menu, function (param) {
            return param.hash == currentHash;
        });
        if (itmRoot.level == 1) {
            menuRenderSub("two", itmRoot);
        }
        if (itmRoot.level == 2) {
            menuRenderSub("three", itmRoot);
            //forward/backward support
            clickMenuTrig(itmRoot.hash, itmRoot.level);
        }
        if (itmRoot.level == 3) {
            //forward/backward support
            clickMenuTrig(itmRoot.parent, itmRoot.level);
            libjq(".menu-three-level").removeClass("active");
            libjq(".menu-three-level." + itmRoot.hash.substring(1)).addClass("active");
        }
    }

    function clickMenuTrig(hash, level) {
        libjqobj = libjq(".menu-two-level." + hash.substring(1));
        var levelArr = ['3', 'three', '2', 'two'];
        if (libus.indexOf(levelArr, level) != -1 && libjqobj.hasClass('active')) {
            return;
        }

        libjqobj.siblings().removeClass('active');
        libjqobj.addClass('active');

        libjqobj.siblings().not('.menu-two-level').slideUp();
        libjqobj.next().has('ul li').slideDown();
    }

    set.blc_wan_mode = fnc.getOpMode().blc_wan_mode;
    if (!set.RJ45_SUPPORT) {
        menuResource = "menu";
    } else {
        switch (set.blc_wan_mode) {
        case "PPPOE":
        case "AUTO_PPPOE":
            menuResource = "menu_pppoe";
            break;
        default:
            menuResource = "menu";
            break;
        }
    }

    require([set.DEVICE + '/' + menuResource], function (otherMenu) {
        menu = otherMenu;
        if (set.SD_CARD_SUPPORT) {
            menu = menu.concat([{ hash: '#httpshare_guest', path: 'sd_httpshare', level: '', requireLogin: false, checkSIMStatus: false}, 
						{ hash: '#sdcard', path: 'sd', level: '', requireLogin: true, checkSIMStatus: false}, 
						{ hash: '#httpshare', path: 'sd_httpshare', level: '', requireLogin: true, checkSIMStatus: false}]);
        }
    });

    function initialize() {
        vmMenu = new Menu_vm();
    }

    function Menu_vm() {
        var loginState = getIsLoggedin();
		var target = this;
        target.loggedIn = libko.observable(loginState);

        target.showMenu = libko.observable(loginState || displayMenuWhenLogout);

        var menuMain = libus.filter(menu, function (param) {
            return (param.level == '1' && ((param.requireLogin && target.loggedIn()) || !param.requireLogin) && param.hash != "#entry");
        });

        target.menuMain = libko.observableArray(menuMain);
        target.secondMenu = libko.observableArray([]);
        //target.curThirdMenu; cov_2
        target.changeMenu = function (data) {
            var secondMenu = getSubMenu(data);
            if (secondMenu.length == 0) {
                libjq("#container").addClass("fixContainerWidth");
            } else {
                libjq("#container").removeClass("fixContainerWidth");
            }

            target.secondMenu(secondMenu);
            return true;
        };
        target.thirdMenu = function () {
            return target.curThirdMenu;
        };
        target.getThirdMenu = function (data) {
            target.curThirdMenu = getSubMenu(data);
        };
        function getSubMenu(data) {
            return libus.filter(menu, function (param) {
                return ((param.parent && param.parent == data.hash) && ((param.requireLogin && target.loggedIn()) || !param.requireLogin));
            });
        }
    }

    return {
        activeSubMenu: menuActSub,
        checkIsMenuExist: menuExistCheck,
        findMenu: menuSearch,
        rebuild: buildNew,
        refreshMenu: menuRefresh,
		init: initialize
    };
});
	