/****************************************************************************************/
/*  Copyright (c) 2004-2015 NXP Software. All rights are reserved.                      */
/*  Reproduction in whole or in part is prohibited without the prior                    */
/*  written consent of the copyright owner.                                             */
/*                                                                                      */
/*  This software and any compilation or derivative thereof is and                      */
/*  shall remain the proprietary information of NXP Software and is                     */
/*  highly confidential in nature. Any and all use hereof is restricted                 */
/*  and is subject to the terms and conditions set forth in the                         */
/*  software license agreement concluded with NXP Software.                             */
/*                                                                                      */
/*  Under no circumstances is this software or any derivative thereof                   */
/*  to be combined with any Open Source Software in any way or                          */
/*  licensed under any Open License Terms without the express prior                     */
/*  written  permission of NXP Software.                                                */
/*                                                                                      */
/*  For the purpose of this clause, the term Open Source Software means                 */
/*  any software that is licensed under Open License Terms. Open                        */
/*  License Terms means terms in any license that require as a                          */
/*  condition of use, modification and/or distribution of a work                        */
/*                                                                                      */
/*           1. the making available of source code or other materials                  */
/*              preferred for modification, or                                          */
/*                                                                                      */
/*           2. the granting of permission for creating derivative                      */
/*              works, or                                                               */
/*                                                                                      */
/*           3. the reproduction of certain notices or license terms                    */
/*              in derivative works or accompanying documentation, or                   */
/*                                                                                      */
/*           4. the granting of a royalty-free license to any party                     */
/*              under Intellectual Property Rights                                      */
/*                                                                                      */
/*  regarding the work and/or any work that contains, is combined with,                 */
/*  requires or otherwise is based on the work.                                         */
/*                                                                                      */
/*  This software is provided for ease of recompilation only.                           */
/*  Modification and reverse engineering of this software are strictly                  */
/*  prohibited.                                                                         */
/*                                                                                      */
/****************************************************************************************/

/****************************************************************************************/
/*                                                                                      */
/*     $Author: nxp65285 $*/
/*     $Revision: 49390 $*/
/*     $Date: 2013-10-16 18:34:35 +0530 (Wed, 16 Oct 2013) $*/
/*                                                                                      */
/****************************************************************************************/

/** @file
 *  Header file for the application layer interface of the REL_LVVE_HF_NV1_VC_AGC_RX_DRC_RX_WB module
 *
 *  The suffix VID in header file stands for Voice Interface Definition
 *  This files includes all definitions, types, and structures required by the calling
 *  layer. Public functions are defined in the protoypes header files.
 *  All other types, structures and functions are private.
 */

#ifndef __REL_LVVE_HF_NV1_VC_AGC_RX_DRC_RX_WB_VIDPP_H__
#define __REL_LVVE_HF_NV1_VC_AGC_RX_DRC_RX_WB_VIDPP_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/****************************************************************************************/
/*                                                                                      */
/*  Includes                                                                            */
/*                                                                                      */
/****************************************************************************************/
#include "LVC_Types.h"

/****************************************************************************************/
/*                                                                                      */
/*  Definitions                                                                         */
/*                                                                                      */
/****************************************************************************************/
/**
<table border>
    <tr>
        <td><b>Name</b></td>
        <td><b>Value</b></td>
        <td><b>Description</b></td>
    </tr>
    <tr>
        <td>@ref LVVIDHEADER_LVVE_RX_LVFENS_MASK1</td>
        <td>1</td>
        <td>Far End Noise Suppression is present in the LVVE_Rx</td>
    </tr>
    <tr>
        <td>@ref LVVIDHEADER_LVVE_RX_HPF_MASK1</td>
        <td>4</td>
        <td>High Pass Filter is present in the LVVE_Rx</td>
    </tr>
    <tr>
        <td>@ref LVVIDHEADER_LVVE_RX_LVNG_MASK1</td>
        <td>16</td>
        <td>Noise Gate is present in the LVVE_Rx</td>
    </tr>
    <tr>
        <td>@ref LVVIDHEADER_LVVE_RX_EQ_MASK1</td>
        <td>64</td>
        <td>Equalizer is present in the LVVE_Rx</td>
    </tr>
    <tr>
        <td>@ref LVVIDHEADER_LVVE_RX_AGC_MASK1</td>
        <td>128</td>
        <td>Automatic Gain Control is present in the LVVE_Rx</td>
    </tr>
    <tr>
        <td>@ref LVVIDHEADER_LVVE_RX_DRC_MASK1</td>
        <td>256</td>
        <td>Dynamic Range Control is present in the LVVE_Rx</td>
    </tr>
    <tr>
        <td>@ref LVVIDHEADER_LVVE_RX_VOL_MASK1</td>
        <td>512</td>
        <td>Volume Control is present in the LVVE_Rx</td>
    </tr>
    <tr>
        <td>@ref LVVIDHEADER_LVVE_RX_LVVC_MASK1</td>
        <td>1024</td>
        <td>VoiceClarity is present in the LVVE_Rx</td>
    </tr>
</table> */
typedef LVM_UINT16 LVVIDHeader_LVVE_Rx_Mask1_bm;
/**
* @def LVVIDHeader_LVVE_Rx_LVFENS_MASK1
* Far End Noise Suppression is present in the LVVE_Rx
* @see LVVIDHeader_LVVE_Rx_Mask1_bm
*/
#define LVVIDHEADER_LVVE_RX_LVFENS_MASK1 ((LVVIDHeader_LVVE_Rx_Mask1_bm)1)
/**
* @def LVVIDHeader_LVVE_Rx_HPF_MASK1
* High Pass Filter is present in the LVVE_Rx
* @see LVVIDHeader_LVVE_Rx_Mask1_bm
*/
#define LVVIDHEADER_LVVE_RX_HPF_MASK1 ((LVVIDHeader_LVVE_Rx_Mask1_bm)4)
/**
* @def LVVIDHeader_LVVE_Rx_LVNG_MASK1
* Noise Gate is present in the LVVE_Rx
* @see LVVIDHeader_LVVE_Rx_Mask1_bm
*/
#define LVVIDHEADER_LVVE_RX_LVNG_MASK1 ((LVVIDHeader_LVVE_Rx_Mask1_bm)16)
/**
* @def LVVIDHeader_LVVE_Rx_EQ_MASK1
* Equalizer is present in the LVVE_Rx
* @see LVVIDHeader_LVVE_Rx_Mask1_bm
*/
#define LVVIDHEADER_LVVE_RX_EQ_MASK1 ((LVVIDHeader_LVVE_Rx_Mask1_bm)64)
/**
* @def LVVIDHeader_LVVE_Rx_AGC_MASK1
* Automatic Gain Control is present in the LVVE_Rx
* @see LVVIDHeader_LVVE_Rx_Mask1_bm
*/
#define LVVIDHEADER_LVVE_RX_AGC_MASK1 ((LVVIDHeader_LVVE_Rx_Mask1_bm)128)
/**
* @def LVVIDHeader_LVVE_Rx_DRC_MASK1
* Dynamic Range Control is present in the LVVE_Rx
* @see LVVIDHeader_LVVE_Rx_Mask1_bm
*/
#define LVVIDHEADER_LVVE_RX_DRC_MASK1 ((LVVIDHeader_LVVE_Rx_Mask1_bm)256)
/**
* @def LVVIDHeader_LVVE_Rx_VOL_MASK1
* Volume Control is present in the LVVE_Rx
* @see LVVIDHeader_LVVE_Rx_Mask1_bm
*/
#define LVVIDHEADER_LVVE_RX_VOL_MASK1 ((LVVIDHeader_LVVE_Rx_Mask1_bm)512)
/**
* @def LVVIDHeader_LVVE_Rx_LVVC_MASK1
* VoiceClarity is present in the LVVE_Rx
* @see LVVIDHeader_LVVE_Rx_Mask1_bm
*/
#define LVVIDHEADER_LVVE_RX_LVVC_MASK1 ((LVVIDHeader_LVVE_Rx_Mask1_bm)1024)
/**
* @def LVVIDHEADER_LVVE_RX_MASK1_BM_MIN
* Minimal value for LVVIDHeader_LVVE_Rx_Mask1_bm
* @see LVVIDHeader_LVVE_Rx_Mask1_bm
*/
#define LVVIDHEADER_LVVE_RX_MASK1_BM_MIN ((LVVIDHeader_LVVE_Rx_Mask1_bm)0)
/**
* @def LVVIDHEADER_LVVE_RX_MASK1_BM_MAX
* Maximal value for LVVIDHeader_LVVE_Rx_Mask1_bm
* @see LVVIDHeader_LVVE_Rx_Mask1_bm
*/
#define LVVIDHEADER_LVVE_RX_LVFENS_MASK1_FORMAX ((LVVIDHeader_LVVE_Rx_Mask1_bm)1)
#define LVVIDHEADER_LVVE_RX_HPF_MASK1_FORMAX ((LVVIDHeader_LVVE_Rx_Mask1_bm)4)
#define LVVIDHEADER_LVVE_RX_LVNG_MASK1_FORMAX ((LVVIDHeader_LVVE_Rx_Mask1_bm)16)
#define LVVIDHEADER_LVVE_RX_EQ_MASK1_FORMAX ((LVVIDHeader_LVVE_Rx_Mask1_bm)64)
#define LVVIDHEADER_LVVE_RX_AGC_MASK1_FORMAX ((LVVIDHeader_LVVE_Rx_Mask1_bm)128)
#define LVVIDHEADER_LVVE_RX_DRC_MASK1_FORMAX ((LVVIDHeader_LVVE_Rx_Mask1_bm)256)
#define LVVIDHEADER_LVVE_RX_VOL_MASK1_FORMAX ((LVVIDHeader_LVVE_Rx_Mask1_bm)512)
#define LVVIDHEADER_LVVE_RX_LVVC_MASK1_FORMAX ((LVVIDHeader_LVVE_Rx_Mask1_bm)1024)
#define LVVIDHEADER_LVVE_RX_MASK1_BM_MAX (LVVIDHEADER_LVVE_RX_LVFENS_MASK1_FORMAX | LVVIDHEADER_LVVE_RX_HPF_MASK1_FORMAX | LVVIDHEADER_LVVE_RX_LVNG_MASK1_FORMAX | LVVIDHEADER_LVVE_RX_EQ_MASK1_FORMAX | LVVIDHEADER_LVVE_RX_AGC_MASK1_FORMAX | LVVIDHEADER_LVVE_RX_DRC_MASK1_FORMAX | LVVIDHEADER_LVVE_RX_VOL_MASK1_FORMAX | LVVIDHEADER_LVVE_RX_LVVC_MASK1_FORMAX | ((LVVIDHeader_LVVE_Rx_Mask1_bm)0))
/**
<table border>
    <tr>
        <td><b>Name</b></td>
        <td><b>Value</b></td>
        <td><b>Description</b></td>
    </tr>
</table> */
typedef LVM_UINT16 LVVIDHeader_LVVE_Rx_Mask2_bm;
/**
* @def LVVIDHEADER_LVVE_RX_MASK2_BM_MIN
* Minimal value for LVVIDHeader_LVVE_Rx_Mask2_bm
* @see LVVIDHeader_LVVE_Rx_Mask2_bm
*/
#define LVVIDHEADER_LVVE_RX_MASK2_BM_MIN ((LVVIDHeader_LVVE_Rx_Mask2_bm)0)
/**
* @def LVVIDHEADER_LVVE_RX_MASK2_BM_MAX
* Maximal value for LVVIDHeader_LVVE_Rx_Mask2_bm
* @see LVVIDHeader_LVVE_Rx_Mask2_bm
*/
#define LVVIDHEADER_LVVE_RX_MASK2_BM_MAX (((LVVIDHeader_LVVE_Rx_Mask2_bm)0))
/**
<table border>
    <tr>
        <td><b>Name</b></td>
        <td><b>Value</b></td>
        <td><b>Description</b></td>
    </tr>
    <tr>
        <td>@ref LVVIDHEADER_LVVE_TX_LVHF_MASK1</td>
        <td>1</td>
        <td>HandsFree is present in the LVVE_Tx</td>
    </tr>
    <tr>
        <td>@ref LVVIDHEADER_LVVE_TX_EQ_MASK1</td>
        <td>4</td>
        <td>Equalizer is present in the LVVE_Tx</td>
    </tr>
    <tr>
        <td>@ref LVVIDHEADER_LVVE_TX_LVWM_MASK1</td>
        <td>8</td>
        <td>WhisperMode is present in the LVVE_Tx</td>
    </tr>
    <tr>
        <td>@ref LVVIDHEADER_LVVE_TX_DRC_MASK1</td>
        <td>16</td>
        <td>Dynamic Range Control is present in the LVVE_Tx</td>
    </tr>
    <tr>
        <td>@ref LVVIDHEADER_LVVE_TX_VOL_MASK1</td>
        <td>32</td>
        <td>Volume Control is present in the LVVE_Tx</td>
    </tr>
    <tr>
        <td>@ref LVVIDHEADER_LVVE_TX_HPF_MASK1</td>
        <td>128</td>
        <td>HPF is present in the LVVE_Tx</td>
    </tr>
    <tr>
        <td>@ref LVVIDHEADER_LVVE_TX_LVNV_01_MASK1</td>
        <td>512</td>
        <td>NoiseVoid is present in the LVVE_Tx</td>
    </tr>
</table> */
typedef LVM_UINT16 LVVIDHeader_LVVE_Tx_Mask1_bm;
/**
* @def LVVIDHeader_LVVE_Tx_LVHF_MASK1
* HandsFree is present in the LVVE_Tx
* @see LVVIDHeader_LVVE_Tx_Mask1_bm
*/
#define LVVIDHEADER_LVVE_TX_LVHF_MASK1 ((LVVIDHeader_LVVE_Tx_Mask1_bm)1)
/**
* @def LVVIDHeader_LVVE_Tx_EQ_MASK1
* Equalizer is present in the LVVE_Tx
* @see LVVIDHeader_LVVE_Tx_Mask1_bm
*/
#define LVVIDHEADER_LVVE_TX_EQ_MASK1 ((LVVIDHeader_LVVE_Tx_Mask1_bm)4)
/**
* @def LVVIDHeader_LVVE_Tx_LVWM_MASK1
* WhisperMode is present in the LVVE_Tx
* @see LVVIDHeader_LVVE_Tx_Mask1_bm
*/
#define LVVIDHEADER_LVVE_TX_LVWM_MASK1 ((LVVIDHeader_LVVE_Tx_Mask1_bm)8)
/**
* @def LVVIDHeader_LVVE_Tx_DRC_MASK1
* Dynamic Range Control is present in the LVVE_Tx
* @see LVVIDHeader_LVVE_Tx_Mask1_bm
*/
#define LVVIDHEADER_LVVE_TX_DRC_MASK1 ((LVVIDHeader_LVVE_Tx_Mask1_bm)16)
/**
* @def LVVIDHeader_LVVE_Tx_VOL_MASK1
* Volume Control is present in the LVVE_Tx
* @see LVVIDHeader_LVVE_Tx_Mask1_bm
*/
#define LVVIDHEADER_LVVE_TX_VOL_MASK1 ((LVVIDHeader_LVVE_Tx_Mask1_bm)32)
/**
* @def LVVIDHeader_LVVE_Tx_HPF_MASK1
* HPF is present in the LVVE_Tx
* @see LVVIDHeader_LVVE_Tx_Mask1_bm
*/
#define LVVIDHEADER_LVVE_TX_HPF_MASK1 ((LVVIDHeader_LVVE_Tx_Mask1_bm)128)
/**
* @def LVVIDHeader_LVVE_Tx_LVNV_01_MASK1
* NoiseVoid is present in the LVVE_Tx
* @see LVVIDHeader_LVVE_Tx_Mask1_bm
*/
#define LVVIDHEADER_LVVE_TX_LVNV_01_MASK1 ((LVVIDHeader_LVVE_Tx_Mask1_bm)512)
/**
* @def LVVIDHEADER_LVVE_TX_MASK1_BM_MIN
* Minimal value for LVVIDHeader_LVVE_Tx_Mask1_bm
* @see LVVIDHeader_LVVE_Tx_Mask1_bm
*/
#define LVVIDHEADER_LVVE_TX_MASK1_BM_MIN ((LVVIDHeader_LVVE_Tx_Mask1_bm)0)
/**
* @def LVVIDHEADER_LVVE_TX_MASK1_BM_MAX
* Maximal value for LVVIDHeader_LVVE_Tx_Mask1_bm
* @see LVVIDHeader_LVVE_Tx_Mask1_bm
*/
#define LVVIDHEADER_LVVE_TX_LVHF_MASK1_FORMAX ((LVVIDHeader_LVVE_Tx_Mask1_bm)1)
#define LVVIDHEADER_LVVE_TX_EQ_MASK1_FORMAX ((LVVIDHeader_LVVE_Tx_Mask1_bm)4)
#define LVVIDHEADER_LVVE_TX_LVWM_MASK1_FORMAX ((LVVIDHeader_LVVE_Tx_Mask1_bm)8)
#define LVVIDHEADER_LVVE_TX_DRC_MASK1_FORMAX ((LVVIDHeader_LVVE_Tx_Mask1_bm)16)
#define LVVIDHEADER_LVVE_TX_VOL_MASK1_FORMAX ((LVVIDHeader_LVVE_Tx_Mask1_bm)32)
#define LVVIDHEADER_LVVE_TX_HPF_MASK1_FORMAX ((LVVIDHeader_LVVE_Tx_Mask1_bm)128)
#define LVVIDHEADER_LVVE_TX_LVNV_01_MASK1_FORMAX ((LVVIDHeader_LVVE_Tx_Mask1_bm)512)
#define LVVIDHEADER_LVVE_TX_MASK1_BM_MAX (LVVIDHEADER_LVVE_TX_LVHF_MASK1_FORMAX | LVVIDHEADER_LVVE_TX_EQ_MASK1_FORMAX | LVVIDHEADER_LVVE_TX_LVWM_MASK1_FORMAX | LVVIDHEADER_LVVE_TX_DRC_MASK1_FORMAX | LVVIDHEADER_LVVE_TX_VOL_MASK1_FORMAX | LVVIDHEADER_LVVE_TX_HPF_MASK1_FORMAX | LVVIDHEADER_LVVE_TX_LVNV_01_MASK1_FORMAX | ((LVVIDHeader_LVVE_Tx_Mask1_bm)0))
/**
<table border>
    <tr>
        <td><b>Name</b></td>
        <td><b>Value</b></td>
        <td><b>Description</b></td>
    </tr>
</table> */
typedef LVM_UINT16 LVVIDHeader_LVVE_Tx_Mask2_bm;
/**
* @def LVVIDHEADER_LVVE_TX_MASK2_BM_MIN
* Minimal value for LVVIDHeader_LVVE_Tx_Mask2_bm
* @see LVVIDHeader_LVVE_Tx_Mask2_bm
*/
#define LVVIDHEADER_LVVE_TX_MASK2_BM_MIN ((LVVIDHeader_LVVE_Tx_Mask2_bm)0)
/**
* @def LVVIDHEADER_LVVE_TX_MASK2_BM_MAX
* Maximal value for LVVIDHeader_LVVE_Tx_Mask2_bm
* @see LVVIDHeader_LVVE_Tx_Mask2_bm
*/
#define LVVIDHEADER_LVVE_TX_MASK2_BM_MAX (((LVVIDHeader_LVVE_Tx_Mask2_bm)0))
/**
<table border>
    <tr>
        <td><b>Name</b></td>
        <td><b>Value</b></td>
        <td><b>Description</b></td>
    </tr>
    <tr>
        <td>@ref LVVIDHEADER_CONFIGURATIONS_WIDEBAND_MASK1</td>
        <td>2</td>
        <td>WideBand configuration is present in the LVVE</td>
    </tr>
</table> */
typedef LVM_UINT16 LVVIDHeader_Configurations_Mask1_bm;
/**
* @def LVVIDHEADER_CONFIGURATIONS_WIDEBAND_MASK1
* WideBand configuration is present in the LVVE
* @see LVVIDHeader_Configurations_Mask1_bm
*/
#define LVVIDHEADER_CONFIGURATIONS_WIDEBAND_MASK1 ((LVVIDHeader_Configurations_Mask1_bm)2)
/**
* @def LVVIDHEADER_CONFIGURATIONS_MASK1_BM_MIN
* Minimal value for LVVIDHeader_Configurations_Mask1_bm
* @see LVVIDHeader_Configurations_Mask1_bm
*/
#define LVVIDHEADER_CONFIGURATIONS_MASK1_BM_MIN ((LVVIDHeader_Configurations_Mask1_bm)0)
/**
* @def LVVIDHEADER_CONFIGURATIONS_MASK1_BM_MAX
* Maximal value for LVVIDHeader_Configurations_Mask1_bm
* @see LVVIDHeader_Configurations_Mask1_bm
*/
#define LVVIDHEADER_CONFIGURATIONS_WIDEBAND_MASK1_FORMAX ((LVVIDHeader_Configurations_Mask1_bm)2)
#define LVVIDHEADER_CONFIGURATIONS_MASK1_BM_MAX (LVVIDHEADER_CONFIGURATIONS_WIDEBAND_MASK1_FORMAX | ((LVVIDHeader_Configurations_Mask1_bm)0))
/**
<table border>
    <tr>
        <td><b>Name</b></td>
        <td><b>Value</b></td>
        <td><b>Description</b></td>
    </tr>
</table> */
typedef LVM_UINT16 LVVIDHeader_Configurations_Mask2_bm;
/**
* @def LVVIDHEADER_CONFIGURATIONS_MASK2_BM_MIN
* Minimal value for LVVIDHeader_Configurations_Mask2_bm
* @see LVVIDHeader_Configurations_Mask2_bm
*/
#define LVVIDHEADER_CONFIGURATIONS_MASK2_BM_MIN ((LVVIDHeader_Configurations_Mask2_bm)0)
/**
* @def LVVIDHEADER_CONFIGURATIONS_MASK2_BM_MAX
* Maximal value for LVVIDHeader_Configurations_Mask2_bm
* @see LVVIDHeader_Configurations_Mask2_bm
*/
#define LVVIDHEADER_CONFIGURATIONS_MASK2_BM_MAX (((LVVIDHeader_Configurations_Mask2_bm)0))
/**
<table border>
    <tr>
        <td><b>Name</b></td>
        <td><b>Value</b></td>
        <td><b>Description</b></td>
    </tr>
    <tr>
        <td>@ref LVVC_MODE_AVL</td>
        <td>2</td>
        <td>Turns on or off the AGC. If off both AGC and Limiter are bypassed.</td>
    </tr>
    <tr>
        <td>@ref LVVC_MODE_AVL_ADAPT</td>
        <td>4</td>
        <td>Allows turning off the dependency of the AGC upon the nearend noise level. When turned off, the AGC uses the default parameters.</td>
    </tr>
    <tr>
        <td>@ref LVVC_MODE_AVL_SPDETECT</td>
        <td>8</td>
        <td>Allows disabling speech detection in the AGC. When turned off, the AGC adapts its gain all the time.</td>
    </tr>
    <tr>
        <td>@ref LVVC_MODE_LIMITER</td>
        <td>16</td>
        <td>Turns on or off the limiter.</td>
    </tr>
    <tr>
        <td>@ref LVVC_MODE_LPF</td>
        <td>32</td>
        <td>Turns on or off the low-pass filter.</td>
    </tr>
    <tr>
        <td>@ref LVVC_MODE_HPF</td>
        <td>64</td>
        <td>Turns on or off the high-pass filter.</td>
    </tr>
    <tr>
        <td>@ref LVVC_MODE_VC</td>
        <td>128</td>
        <td>Turns on or off the VoiceClarity gain.</td>
    </tr>
</table> */
typedef LVM_UINT16 LVVC_ModeWord_bm;
/**
* @def LVVC_MODE_AVL
* Turns on or off the AGC. If off both AGC and Limiter are bypassed.
* @see LVVC_ModeWord_bm
*/
#define LVVC_MODE_AVL ((LVVC_ModeWord_bm)2)
/**
* @def LVVC_MODE_AVL_ADAPT
* Allows turning off the dependency of the AGC upon the nearend noise level. When turned off, the AGC uses the default parameters.
* @see LVVC_ModeWord_bm
*/
#define LVVC_MODE_AVL_ADAPT ((LVVC_ModeWord_bm)4)
/**
* @def LVVC_MODE_AVL_SPDETECT
* Allows disabling speech detection in the AGC. When turned off, the AGC adapts its gain all the time.
* @see LVVC_ModeWord_bm
*/
#define LVVC_MODE_AVL_SPDETECT ((LVVC_ModeWord_bm)8)
/**
* @def LVVC_MODE_LIMITER
* Turns on or off the limiter.
* @see LVVC_ModeWord_bm
*/
#define LVVC_MODE_LIMITER ((LVVC_ModeWord_bm)16)
/**
* @def LVVC_MODE_LPF
* Turns on or off the low-pass filter.
* @see LVVC_ModeWord_bm
*/
#define LVVC_MODE_LPF ((LVVC_ModeWord_bm)32)
/**
* @def LVVC_MODE_HPF
* Turns on or off the high-pass filter.
* @see LVVC_ModeWord_bm
*/
#define LVVC_MODE_HPF ((LVVC_ModeWord_bm)64)
/**
* @def LVVC_MODE_VC
* Turns on or off the VoiceClarity gain.
* @see LVVC_ModeWord_bm
*/
#define LVVC_MODE_VC ((LVVC_ModeWord_bm)128)
/**
* @def LVVC_MODEWORD_BM_MIN
* Minimal value for LVVC_ModeWord_bm
* @see LVVC_ModeWord_bm
*/
#define LVVC_MODEWORD_BM_MIN ((LVVC_ModeWord_bm)0)
/**
* @def LVVC_MODEWORD_BM_MAX
* Maximal value for LVVC_ModeWord_bm
* @see LVVC_ModeWord_bm
*/
#define LVVC_MODE_AVL_FORMAX ((LVVC_ModeWord_bm)2)
#define LVVC_MODE_AVL_ADAPT_FORMAX ((LVVC_ModeWord_bm)4)
#define LVVC_MODE_AVL_SPDETECT_FORMAX ((LVVC_ModeWord_bm)8)
#define LVVC_MODE_LIMITER_FORMAX ((LVVC_ModeWord_bm)16)
#define LVVC_MODE_LPF_FORMAX ((LVVC_ModeWord_bm)32)
#define LVVC_MODE_HPF_FORMAX ((LVVC_ModeWord_bm)64)
#define LVVC_MODE_VC_FORMAX ((LVVC_ModeWord_bm)128)
#define LVVC_MODEWORD_BM_MAX (LVVC_MODE_AVL_FORMAX | LVVC_MODE_AVL_ADAPT_FORMAX | LVVC_MODE_AVL_SPDETECT_FORMAX | LVVC_MODE_LIMITER_FORMAX | LVVC_MODE_LPF_FORMAX | LVVC_MODE_HPF_FORMAX | LVVC_MODE_VC_FORMAX | ((LVVC_ModeWord_bm)0))
/**
<table border>
    <tr>
        <td><b>Name</b></td>
        <td><b>Value</b></td>
        <td><b>Description</b></td>
    </tr>
    <tr>
        <td>@ref LVFENS_MODE_HS</td>
        <td>1</td>
        <td>Switch ON and OFF Horn Suppressor. Currently Horn Suppressor is not supported.</td>
    </tr>
</table> */
typedef LVM_UINT16 LVFENS_ModeWord_bm;
/**
* @def LVFENS_MODE_HS
* Switch ON and OFF Horn Suppressor. Currently Horn Suppressor is not supported.
* @see LVFENS_ModeWord_bm
*/
#define LVFENS_MODE_HS ((LVFENS_ModeWord_bm)1)
/**
* @def LVFENS_MODEWORD_BM_MIN
* Minimal value for LVFENS_ModeWord_bm
* @see LVFENS_ModeWord_bm
*/
#define LVFENS_MODEWORD_BM_MIN ((LVFENS_ModeWord_bm)0)
/**
* @def LVFENS_MODEWORD_BM_MAX
* Maximal value for LVFENS_ModeWord_bm
* @see LVFENS_ModeWord_bm
*/
#define LVFENS_MODE_HS_FORMAX ((LVFENS_ModeWord_bm)1)
#define LVFENS_MODEWORD_BM_MAX (LVFENS_MODE_HS_FORMAX | ((LVFENS_ModeWord_bm)0))
/**
<table border>
    <tr>
        <td><b>Name</b></td>
        <td><b>Value</b></td>
        <td><b>Description</b></td>
    </tr>
    <tr>
        <td>@ref LVWM_MODE_AVL</td>
        <td>1</td>
        <td>Turns on or off the AVL. If off, both AGC and Limiter are bypassed</td>
    </tr>
    <tr>
        <td>@ref LVWM_MODE_SPDETECT</td>
        <td>2</td>
        <td>Allows disabling speech detection in the AVL. When turned off, the AGC adapts its gain all the time.</td>
    </tr>
    <tr>
        <td>@ref LVWM_MODE_LIMITER</td>
        <td>4</td>
        <td>Turns on or off the limiter.</td>
    </tr>
    <tr>
        <td>@ref LVWM_MODE_EXT_SPDETECT</td>
        <td>8</td>
        <td>Used to tell the WhisperMode module if an external speech detection is available (If 0, there is no external speech detector).</td>
    </tr>
</table> */
typedef LVM_UINT16 LVWM_ModeWord_bm;
/**
* @def LVWM_MODE_AVL
* Turns on or off the AVL. If off, both AGC and Limiter are bypassed
* @see LVWM_ModeWord_bm
*/
#define LVWM_MODE_AVL ((LVWM_ModeWord_bm)1)
/**
* @def LVWM_MODE_SPDETECT
* Allows disabling speech detection in the AVL. When turned off, the AGC adapts its gain all the time.
* @see LVWM_ModeWord_bm
*/
#define LVWM_MODE_SPDETECT ((LVWM_ModeWord_bm)2)
/**
* @def LVWM_MODE_LIMITER
* Turns on or off the limiter.
* @see LVWM_ModeWord_bm
*/
#define LVWM_MODE_LIMITER ((LVWM_ModeWord_bm)4)
/**
* @def LVWM_MODE_EXT_SPDETECT
* Used to tell the WhisperMode module if an external speech detection is available (If 0, there is no external speech detector).
* @see LVWM_ModeWord_bm
*/
#define LVWM_MODE_EXT_SPDETECT ((LVWM_ModeWord_bm)8)
/**
* @def LVWM_MODEWORD_BM_MIN
* Minimal value for LVWM_ModeWord_bm
* @see LVWM_ModeWord_bm
*/
#define LVWM_MODEWORD_BM_MIN ((LVWM_ModeWord_bm)0)
/**
* @def LVWM_MODEWORD_BM_MAX
* Maximal value for LVWM_ModeWord_bm
* @see LVWM_ModeWord_bm
*/
#define LVWM_MODE_AVL_FORMAX ((LVWM_ModeWord_bm)1)
#define LVWM_MODE_SPDETECT_FORMAX ((LVWM_ModeWord_bm)2)
#define LVWM_MODE_LIMITER_FORMAX ((LVWM_ModeWord_bm)4)
#define LVWM_MODE_EXT_SPDETECT_FORMAX ((LVWM_ModeWord_bm)8)
#define LVWM_MODEWORD_BM_MAX (LVWM_MODE_AVL_FORMAX | LVWM_MODE_SPDETECT_FORMAX | LVWM_MODE_LIMITER_FORMAX | LVWM_MODE_EXT_SPDETECT_FORMAX | ((LVWM_ModeWord_bm)0))
/**
<table border>
    <tr>
        <td><b>Name</b></td>
        <td><b>Value</b></td>
        <td><b>Description</b></td>
    </tr>
    <tr>
        <td>@ref MODE_NLMS0</td>
        <td>1</td>
        <td>NLMS0 functionality</td>
    </tr>
    <tr>
        <td>@ref MODE_NLMS1</td>
        <td>2</td>
        <td>NLMS1 functionality</td>
    </tr>
    <tr>
        <td>@ref MODE_BEAMFORMER</td>
        <td>4</td>
        <td>Fiter-and-Sum Beamformer functionality</td>
    </tr>
    <tr>
        <td>@ref MODE_PCD</td>
        <td>8</td>
        <td>Switch between PCD (Path change detector) and BSD (Broadside detector)</td>
    </tr>
    <tr>
        <td>@ref MODE_GSC</td>
        <td>16</td>
        <td>Generalized Sidelobe Canceller functionality</td>
    </tr>
    <tr>
        <td>@ref MODE_DNNS</td>
        <td>32</td>
        <td>Dynamic Non-stationary Noise Suppression functionality</td>
    </tr>
    <tr>
        <td>@ref MODE_DES</td>
        <td>64</td>
        <td>Dynamic Echo Suppression functionality</td>
    </tr>
    <tr>
        <td>@ref MODE_NS</td>
        <td>128</td>
        <td>Stationary Noise Suppression functionality</td>
    </tr>
    <tr>
        <td>@ref MODE_NS_N</td>
        <td>256</td>
        <td>Non-stationary Noise Suppression functionality</td>
    </tr>
    <tr>
        <td>@ref MODE_CAL</td>
        <td>2048</td>
        <td>Switch between initial or continuous calibration</td>
    </tr>
    <tr>
        <td>@ref MODE_HB</td>
        <td>16384</td>
        <td>High Band mute/activated</td>
    </tr>
    <tr>
        <td>@ref MODE_HS</td>
        <td>32768</td>
        <td>Horn Suppressor functionality (if available)</td>
    </tr>
</table> */
typedef LVM_UINT16 LVNV_ModeWord_bm;
/**
* @def MODE_NLMS0
* NLMS0 functionality
* @see LVNV_ModeWord_bm
*/
#define MODE_NLMS0 ((LVNV_ModeWord_bm)1)
/**
* @def MODE_NLMS1
* NLMS1 functionality
* @see LVNV_ModeWord_bm
*/
#define MODE_NLMS1 ((LVNV_ModeWord_bm)2)
/**
* @def MODE_BEAMFORMER
* Fiter-and-Sum Beamformer functionality
* @see LVNV_ModeWord_bm
*/
#define MODE_BEAMFORMER ((LVNV_ModeWord_bm)4)
/**
* @def MODE_PCD
* Switch between PCD (Path change detector) and BSD (Broadside detector)
* @see LVNV_ModeWord_bm
*/
#define MODE_PCD ((LVNV_ModeWord_bm)8)
/**
* @def MODE_GSC
* Generalized Sidelobe Canceller functionality
* @see LVNV_ModeWord_bm
*/
#define MODE_GSC ((LVNV_ModeWord_bm)16)
/**
* @def MODE_DNNS
* Dynamic Non-stationary Noise Suppression functionality
* @see LVNV_ModeWord_bm
*/
#define MODE_DNNS ((LVNV_ModeWord_bm)32)
/**
* @def MODE_DES
* Dynamic Echo Suppression functionality
* @see LVNV_ModeWord_bm
*/
#define MODE_DES ((LVNV_ModeWord_bm)64)
/**
* @def MODE_NS
* Stationary Noise Suppression functionality
* @see LVNV_ModeWord_bm
*/
#define MODE_NS ((LVNV_ModeWord_bm)128)
/**
* @def MODE_NS_N
* Non-stationary Noise Suppression functionality
* @see LVNV_ModeWord_bm
*/
#define MODE_NS_N ((LVNV_ModeWord_bm)256)
/**
* @def MODE_CAL
* Switch between initial or continuous calibration
* @see LVNV_ModeWord_bm
*/
#define MODE_CAL ((LVNV_ModeWord_bm)2048)
/**
* @def MODE_HB
* High Band mute/activated
* @see LVNV_ModeWord_bm
*/
#define MODE_HB ((LVNV_ModeWord_bm)16384)
/**
* @def MODE_HS
* Horn Suppressor functionality (if available)
* @see LVNV_ModeWord_bm
*/
#define MODE_HS ((LVNV_ModeWord_bm)32768)
/**
* @def LVNV_MODEWORD_BM_MIN
* Minimal value for LVNV_ModeWord_bm
* @see LVNV_ModeWord_bm
*/
#define LVNV_MODEWORD_BM_MIN ((LVNV_ModeWord_bm)0)
/**
* @def LVNV_MODEWORD_BM_MAX
* Maximal value for LVNV_ModeWord_bm
* @see LVNV_ModeWord_bm
*/
#define MODE_NLMS0_FORMAX ((LVNV_ModeWord_bm)1)
#define MODE_NLMS1_FORMAX ((LVNV_ModeWord_bm)2)
#define MODE_BEAMFORMER_FORMAX ((LVNV_ModeWord_bm)4)
#define MODE_PCD_FORMAX ((LVNV_ModeWord_bm)8)
#define MODE_GSC_FORMAX ((LVNV_ModeWord_bm)16)
#define MODE_DNNS_FORMAX ((LVNV_ModeWord_bm)32)
#define MODE_DES_FORMAX ((LVNV_ModeWord_bm)64)
#define MODE_NS_FORMAX ((LVNV_ModeWord_bm)128)
#define MODE_NS_N_FORMAX ((LVNV_ModeWord_bm)256)
#define MODE_CAL_FORMAX ((LVNV_ModeWord_bm)2048)
#define MODE_HB_FORMAX ((LVNV_ModeWord_bm)16384)
#define MODE_HS_FORMAX ((LVNV_ModeWord_bm)32768)
#define LVNV_MODEWORD_BM_MAX (MODE_NLMS0_FORMAX | MODE_NLMS1_FORMAX | MODE_BEAMFORMER_FORMAX | MODE_PCD_FORMAX | MODE_GSC_FORMAX | MODE_DNNS_FORMAX | MODE_DES_FORMAX | MODE_NS_FORMAX | MODE_NS_N_FORMAX | MODE_CAL_FORMAX | MODE_HB_FORMAX | MODE_HS_FORMAX | ((LVNV_ModeWord_bm)0))
/**
<table border>
    <tr>
        <td><b>Name</b></td>
        <td><b>Value</b></td>
        <td><b>Description</b></td>
    </tr>
    <tr>
        <td>@ref MODE2_FSB_CARDIOID</td>
        <td>1</td>
        <td>FSB update based on speech detection in cardioid</td>
    </tr>
    <tr>
        <td>@ref MODE2_FSB_WITHINBEAM</td>
        <td>2</td>
        <td>FSB update based on withinbeam detection</td>
    </tr>
    <tr>
        <td>@ref MODE2_CAL_UPDATE</td>
        <td>4</td>
        <td>Switch for calibration functionality between updated or not-updated</td>
    </tr>
    <tr>
        <td>@ref MODE2_BEAMDAMAGE</td>
        <td>8</td>
        <td>Microphone coverage protection</td>
    </tr>
</table> */
typedef LVM_UINT16 LVNV_Mode2Word_bm;
/**
* @def MODE2_FSB_CARDIOID
* FSB update based on speech detection in cardioid
* @see LVNV_Mode2Word_bm
*/
#define MODE2_FSB_CARDIOID ((LVNV_Mode2Word_bm)1)
/**
* @def MODE2_FSB_WITHINBEAM
* FSB update based on withinbeam detection
* @see LVNV_Mode2Word_bm
*/
#define MODE2_FSB_WITHINBEAM ((LVNV_Mode2Word_bm)2)
/**
* @def MODE2_CAL_UPDATE
* Switch for calibration functionality between updated or not-updated
* @see LVNV_Mode2Word_bm
*/
#define MODE2_CAL_UPDATE ((LVNV_Mode2Word_bm)4)
/**
* @def MODE2_BEAMDAMAGE
* Microphone coverage protection
* @see LVNV_Mode2Word_bm
*/
#define MODE2_BEAMDAMAGE ((LVNV_Mode2Word_bm)8)
/**
* @def LVNV_MODE2WORD_BM_MIN
* Minimal value for LVNV_Mode2Word_bm
* @see LVNV_Mode2Word_bm
*/
#define LVNV_MODE2WORD_BM_MIN ((LVNV_Mode2Word_bm)0)
/**
* @def LVNV_MODE2WORD_BM_MAX
* Maximal value for LVNV_Mode2Word_bm
* @see LVNV_Mode2Word_bm
*/
#define MODE2_FSB_CARDIOID_FORMAX ((LVNV_Mode2Word_bm)1)
#define MODE2_FSB_WITHINBEAM_FORMAX ((LVNV_Mode2Word_bm)2)
#define MODE2_CAL_UPDATE_FORMAX ((LVNV_Mode2Word_bm)4)
#define MODE2_BEAMDAMAGE_FORMAX ((LVNV_Mode2Word_bm)8)
#define LVNV_MODE2WORD_BM_MAX (MODE2_FSB_CARDIOID_FORMAX | MODE2_FSB_WITHINBEAM_FORMAX | MODE2_CAL_UPDATE_FORMAX | MODE2_BEAMDAMAGE_FORMAX | ((LVNV_Mode2Word_bm)0))
/**
<table border>
    <tr>
        <td><b>Name</b></td>
        <td><b>Value</b></td>
        <td><b>Description</b></td>
    </tr>
    <tr>
        <td>@ref TUNING_MODE_NLMS1</td>
        <td>1</td>
        <td>NLMS1 output</td>
    </tr>
    <tr>
        <td>@ref TUNING_MODE_FSB</td>
        <td>2</td>
        <td>FSB noise reference output</td>
    </tr>
    <tr>
        <td>@ref TUNING_MODE_WITHINBEAM</td>
        <td>8</td>
        <td>Tuning beep when Withinbeam=1</td>
    </tr>
    <tr>
        <td>@ref TUNING_MODE_UPDATEONOFF</td>
        <td>16</td>
        <td>Tuning beep when FSB is updated</td>
    </tr>
    <tr>
        <td>@ref TUNING_MODE_CAL_MICPOW</td>
        <td>64</td>
        <td>Tuning beep when MicPow is lower than Cal_micPowFloorMin</td>
    </tr>
    <tr>
        <td>@ref TUNING_MODE_BROADSIDE</td>
        <td>128</td>
        <td>Tuning beep when broadside is detected</td>
    </tr>
</table> */
typedef LVM_UINT16 LVNV_TuningModeWord_bm;
/**
* @def TUNING_MODE_NLMS1
* NLMS1 output
* @see LVNV_TuningModeWord_bm
*/
#define TUNING_MODE_NLMS1 ((LVNV_TuningModeWord_bm)1)
/**
* @def TUNING_MODE_FSB
* FSB noise reference output
* @see LVNV_TuningModeWord_bm
*/
#define TUNING_MODE_FSB ((LVNV_TuningModeWord_bm)2)
/**
* @def TUNING_MODE_WITHINBEAM
* Tuning beep when Withinbeam=1
* @see LVNV_TuningModeWord_bm
*/
#define TUNING_MODE_WITHINBEAM ((LVNV_TuningModeWord_bm)8)
/**
* @def TUNING_MODE_UPDATEONOFF
* Tuning beep when FSB is updated
* @see LVNV_TuningModeWord_bm
*/
#define TUNING_MODE_UPDATEONOFF ((LVNV_TuningModeWord_bm)16)
/**
* @def TUNING_MODE_CAL_MICPOW
* Tuning beep when MicPow is lower than Cal_micPowFloorMin
* @see LVNV_TuningModeWord_bm
*/
#define TUNING_MODE_CAL_MICPOW ((LVNV_TuningModeWord_bm)64)
/**
* @def TUNING_MODE_BROADSIDE
* Tuning beep when broadside is detected
* @see LVNV_TuningModeWord_bm
*/
#define TUNING_MODE_BROADSIDE ((LVNV_TuningModeWord_bm)128)
/**
* @def LVNV_TUNINGMODEWORD_BM_MIN
* Minimal value for LVNV_TuningModeWord_bm
* @see LVNV_TuningModeWord_bm
*/
#define LVNV_TUNINGMODEWORD_BM_MIN ((LVNV_TuningModeWord_bm)0)
/**
* @def LVNV_TUNINGMODEWORD_BM_MAX
* Maximal value for LVNV_TuningModeWord_bm
* @see LVNV_TuningModeWord_bm
*/
#define TUNING_MODE_NLMS1_FORMAX ((LVNV_TuningModeWord_bm)1)
#define TUNING_MODE_FSB_FORMAX ((LVNV_TuningModeWord_bm)2)
#define TUNING_MODE_WITHINBEAM_FORMAX ((LVNV_TuningModeWord_bm)8)
#define TUNING_MODE_UPDATEONOFF_FORMAX ((LVNV_TuningModeWord_bm)16)
#define TUNING_MODE_CAL_MICPOW_FORMAX ((LVNV_TuningModeWord_bm)64)
#define TUNING_MODE_BROADSIDE_FORMAX ((LVNV_TuningModeWord_bm)128)
#define LVNV_TUNINGMODEWORD_BM_MAX (TUNING_MODE_NLMS1_FORMAX | TUNING_MODE_FSB_FORMAX | TUNING_MODE_WITHINBEAM_FORMAX | TUNING_MODE_UPDATEONOFF_FORMAX | TUNING_MODE_CAL_MICPOW_FORMAX | TUNING_MODE_BROADSIDE_FORMAX | ((LVNV_TuningModeWord_bm)0))
/**
<table border>
    <tr>
        <td><b>Name</b></td>
        <td><b>Value</b></td>
        <td><b>Description</b></td>
    </tr>
    <tr>
        <td>@ref LVNV_STATUS_LOST_BEAM</td>
        <td>1</td>
        <td>LostBeam detections</td>
    </tr>
    <tr>
        <td>@ref LVNV_STATUS_MIC_COV</td>
        <td>2</td>
        <td>Microphone Coverage detections</td>
    </tr>
    <tr>
        <td>@ref LVNV_STATUS_FSB_UPDATE</td>
        <td>4</td>
        <td>FSB updates</td>
    </tr>
    <tr>
        <td>@ref LVNV_STATUS_BEAM_DAMAGE</td>
        <td>8</td>
        <td>BeamDamage detections</td>
    </tr>
    <tr>
        <td>@ref LVNV_STATUS_GSC_UPDATE</td>
        <td>16</td>
        <td>GSC updates</td>
    </tr>
    <tr>
        <td>@ref LVNV_STATUS_DNNS_WBEAM</td>
        <td>32</td>
        <td>DNNS WithinBeam detections</td>
    </tr>
    <tr>
        <td>@ref LVNV_STATUS_DNNS_ACTIVITY</td>
        <td>64</td>
        <td>DNNS activity detections</td>
    </tr>
    <tr>
        <td>@ref LVNV_STATUS_CAL_MICPOW</td>
        <td>128</td>
        <td>Calibration Microphone Power</td>
    </tr>
    <tr>
        <td>@ref LVNV_STATUS_MICPOWSP</td>
        <td>256</td>
        <td>(LV1008) MicPow Speech detections</td>
    </tr>
    <tr>
        <td>@ref LVNV_STATUS_BROADSIDE_FLAG</td>
        <td>512</td>
        <td>(LV2370) Broadside detection flag</td>
    </tr>
    <tr>
        <td>@ref LVNV_STATUS_CAL_UPDATED</td>
        <td>1024</td>
        <td>(LV8237) Calibration updated flag</td>
    </tr>
    <tr>
        <td>@ref LVNV_STATUS_WBEAM_FIX</td>
        <td>2048</td>
        <td>WithinBeam detection for Fixed Beamformer (if available).</td>
    </tr>
</table> */
typedef LVM_UINT16 LVNV_StatusWord_bm;
/**
* @def LVNV_STATUS_LOST_BEAM
* LostBeam detections
* @see LVNV_StatusWord_bm
*/
#define LVNV_STATUS_LOST_BEAM ((LVNV_StatusWord_bm)1)
/**
* @def LVNV_STATUS_MIC_COV
* Microphone Coverage detections
* @see LVNV_StatusWord_bm
*/
#define LVNV_STATUS_MIC_COV ((LVNV_StatusWord_bm)2)
/**
* @def LVNV_STATUS_FSB_UPDATE
* FSB updates
* @see LVNV_StatusWord_bm
*/
#define LVNV_STATUS_FSB_UPDATE ((LVNV_StatusWord_bm)4)
/**
* @def LVNV_STATUS_BEAM_DAMAGE
* BeamDamage detections
* @see LVNV_StatusWord_bm
*/
#define LVNV_STATUS_BEAM_DAMAGE ((LVNV_StatusWord_bm)8)
/**
* @def LVNV_STATUS_GSC_UPDATE
* GSC updates
* @see LVNV_StatusWord_bm
*/
#define LVNV_STATUS_GSC_UPDATE ((LVNV_StatusWord_bm)16)
/**
* @def LVNV_STATUS_DNNS_WBEAM
* DNNS WithinBeam detections
* @see LVNV_StatusWord_bm
*/
#define LVNV_STATUS_DNNS_WBEAM ((LVNV_StatusWord_bm)32)
/**
* @def LVNV_STATUS_DNNS_ACTIVITY
* DNNS activity detections
* @see LVNV_StatusWord_bm
*/
#define LVNV_STATUS_DNNS_ACTIVITY ((LVNV_StatusWord_bm)64)
/**
* @def LVNV_STATUS_CAL_MICPOW
* Calibration Microphone Power
* @see LVNV_StatusWord_bm
*/
#define LVNV_STATUS_CAL_MICPOW ((LVNV_StatusWord_bm)128)
/**
* @def LVNV_STATUS_MICPOWSP
* (LV1008) MicPow Speech detections
* @see LVNV_StatusWord_bm
*/
#define LVNV_STATUS_MICPOWSP ((LVNV_StatusWord_bm)256)
/**
* @def LVNV_STATUS_BROADSIDE_FLAG
* (LV2370) Broadside detection flag
* @see LVNV_StatusWord_bm
*/
#define LVNV_STATUS_BROADSIDE_FLAG ((LVNV_StatusWord_bm)512)
/**
* @def LVNV_STATUS_CAL_UPDATED
* (LV8237) Calibration updated flag
* @see LVNV_StatusWord_bm
*/
#define LVNV_STATUS_CAL_UPDATED ((LVNV_StatusWord_bm)1024)
/**
* @def LVNV_STATUS_WBEAM_fix
* WithinBeam detection for Fixed Beamformer (if available).
* @see LVNV_StatusWord_bm
*/
#define LVNV_STATUS_WBEAM_FIX ((LVNV_StatusWord_bm)2048)
/**
* @def LVNV_STATUSWORD_BM_MIN
* Minimal value for LVNV_StatusWord_bm
* @see LVNV_StatusWord_bm
*/
#define LVNV_STATUSWORD_BM_MIN ((LVNV_StatusWord_bm)0)
/**
* @def LVNV_STATUSWORD_BM_MAX
* Maximal value for LVNV_StatusWord_bm
* @see LVNV_StatusWord_bm
*/
#define LVNV_STATUS_LOST_BEAM_FORMAX ((LVNV_StatusWord_bm)1)
#define LVNV_STATUS_MIC_COV_FORMAX ((LVNV_StatusWord_bm)2)
#define LVNV_STATUS_FSB_UPDATE_FORMAX ((LVNV_StatusWord_bm)4)
#define LVNV_STATUS_BEAM_DAMAGE_FORMAX ((LVNV_StatusWord_bm)8)
#define LVNV_STATUS_GSC_UPDATE_FORMAX ((LVNV_StatusWord_bm)16)
#define LVNV_STATUS_DNNS_WBEAM_FORMAX ((LVNV_StatusWord_bm)32)
#define LVNV_STATUS_DNNS_ACTIVITY_FORMAX ((LVNV_StatusWord_bm)64)
#define LVNV_STATUS_CAL_MICPOW_FORMAX ((LVNV_StatusWord_bm)128)
#define LVNV_STATUS_MICPOWSP_FORMAX ((LVNV_StatusWord_bm)256)
#define LVNV_STATUS_BROADSIDE_FLAG_FORMAX ((LVNV_StatusWord_bm)512)
#define LVNV_STATUS_CAL_UPDATED_FORMAX ((LVNV_StatusWord_bm)1024)
#define LVNV_STATUS_WBEAM_FIX_FORMAX ((LVNV_StatusWord_bm)2048)
#define LVNV_STATUSWORD_BM_MAX (LVNV_STATUS_LOST_BEAM_FORMAX | LVNV_STATUS_MIC_COV_FORMAX | LVNV_STATUS_FSB_UPDATE_FORMAX | LVNV_STATUS_BEAM_DAMAGE_FORMAX | LVNV_STATUS_GSC_UPDATE_FORMAX | LVNV_STATUS_DNNS_WBEAM_FORMAX | LVNV_STATUS_DNNS_ACTIVITY_FORMAX | LVNV_STATUS_CAL_MICPOW_FORMAX | LVNV_STATUS_MICPOWSP_FORMAX | LVNV_STATUS_BROADSIDE_FLAG_FORMAX | LVNV_STATUS_CAL_UPDATED_FORMAX | LVNV_STATUS_WBEAM_FIX_FORMAX | ((LVNV_StatusWord_bm)0))
/**
<table border>
    <tr>
        <td><b>Name</b></td>
        <td><b>Value</b></td>
        <td><b>Description</b></td>
    </tr>
    <tr>
        <td>@ref LVHF_CONTROL_TUNE_PATHCHANGE</td>
        <td>1</td>
        <td>PCD tuning beep</td>
    </tr>
    <tr>
        <td>@ref LVHF_CONTROL_TUNE_CLIP</td>
        <td>2</td>
        <td>SPDET_x_clip tuning beep</td>
    </tr>
    <tr>
        <td>@ref LVHF_CONTROL_TUNE_FAR_SPEAKS</td>
        <td>4</td>
        <td>SPDET_far tuning beep</td>
    </tr>
    <tr>
        <td>@ref LVHF_CONTROL_TUNE_MIC_SPEAKS</td>
        <td>8</td>
        <td>SPDET_mic tuning beep</td>
    </tr>
    <tr>
        <td>@ref LVHF_CONTROL_TUNE_HB_MUTE</td>
        <td>16</td>
        <td>Mute high band (4kHz-8kHz). Should be disabled by default.</td>
    </tr>
    <tr>
        <td>@ref LVHF_CONTROL_TUNE_TB_MUTE</td>
        <td>32</td>
        <td>Mute top band (above 8kHz). Should be disabled by default.</td>
    </tr>
</table> */
typedef LVM_UINT16 LVHF_TuningModeWord;
/**
* @def LVHF_CONTROL_TUNE_PATHCHANGE
* PCD tuning beep
* @see LVHF_TuningModeWord
*/
#define LVHF_CONTROL_TUNE_PATHCHANGE ((LVHF_TuningModeWord)1)
/**
* @def LVHF_CONTROL_TUNE_CLIP
* SPDET_x_clip tuning beep
* @see LVHF_TuningModeWord
*/
#define LVHF_CONTROL_TUNE_CLIP ((LVHF_TuningModeWord)2)
/**
* @def LVHF_CONTROL_TUNE_FAR_SPEAKS
* SPDET_far tuning beep
* @see LVHF_TuningModeWord
*/
#define LVHF_CONTROL_TUNE_FAR_SPEAKS ((LVHF_TuningModeWord)4)
/**
* @def LVHF_CONTROL_TUNE_MIC_SPEAKS
* SPDET_mic tuning beep
* @see LVHF_TuningModeWord
*/
#define LVHF_CONTROL_TUNE_MIC_SPEAKS ((LVHF_TuningModeWord)8)
/**
* @def LVHF_CONTROL_TUNE_HB_MUTE
* Mute high band (4kHz-8kHz). Should be disabled by default.
* @see LVHF_TuningModeWord
*/
#define LVHF_CONTROL_TUNE_HB_MUTE ((LVHF_TuningModeWord)16)
/**
* @def LVHF_CONTROL_TUNE_TB_MUTE
* Mute top band (above 8kHz). Should be disabled by default.
* @see LVHF_TuningModeWord
*/
#define LVHF_CONTROL_TUNE_TB_MUTE ((LVHF_TuningModeWord)32)
/**
* @def LVHF_TUNINGMODEWORD_MIN
* Minimal value for LVHF_TuningModeWord
* @see LVHF_TuningModeWord
*/
#define LVHF_TUNINGMODEWORD_MIN ((LVHF_TuningModeWord)0)
/**
* @def LVHF_TUNINGMODEWORD_MAX
* Maximal value for LVHF_TuningModeWord
* @see LVHF_TuningModeWord
*/
#define LVHF_CONTROL_TUNE_PATHCHANGE_FORMAX ((LVHF_TuningModeWord)1)
#define LVHF_CONTROL_TUNE_CLIP_FORMAX ((LVHF_TuningModeWord)2)
#define LVHF_CONTROL_TUNE_FAR_SPEAKS_FORMAX ((LVHF_TuningModeWord)4)
#define LVHF_CONTROL_TUNE_MIC_SPEAKS_FORMAX ((LVHF_TuningModeWord)8)
#define LVHF_CONTROL_TUNE_HB_MUTE_FORMAX ((LVHF_TuningModeWord)16)
#define LVHF_CONTROL_TUNE_TB_MUTE_FORMAX ((LVHF_TuningModeWord)32)
#define LVHF_TUNINGMODEWORD_MAX (LVHF_CONTROL_TUNE_PATHCHANGE_FORMAX | LVHF_CONTROL_TUNE_CLIP_FORMAX | LVHF_CONTROL_TUNE_FAR_SPEAKS_FORMAX | LVHF_CONTROL_TUNE_MIC_SPEAKS_FORMAX | LVHF_CONTROL_TUNE_HB_MUTE_FORMAX | LVHF_CONTROL_TUNE_TB_MUTE_FORMAX | ((LVHF_TuningModeWord)0))
/**
<table border>
    <tr>
        <td><b>Name</b></td>
        <td><b>Value</b></td>
        <td><b>Description</b></td>
    </tr>
    <tr>
        <td>@ref LVHF_MODE_NLMS</td>
        <td>1</td>
        <td>NLMS functionality</td>
    </tr>
    <tr>
        <td>@ref LVHF_MODE_DES</td>
        <td>2</td>
        <td>DES (Dynamic Echo Suppression)</td>
    </tr>
    <tr>
        <td>@ref LVHF_MODE_NS</td>
        <td>4</td>
        <td>NS (Noise Suppression)</td>
    </tr>
    <tr>
        <td>@ref LVHF_MODE_CNI</td>
        <td>8</td>
        <td>CNI (Comfort Noise Injection)</td>
    </tr>
    <tr>
        <td>@ref LVHF_MODE_NLES</td>
        <td>16</td>
        <td>NLES (Non Linear Echo Suppression)</td>
    </tr>
    <tr>
        <td>@ref LVHF_MODE_PCD_DT</td>
        <td>64</td>
        <td>DT (Double Talk) protection after PCD</td>
    </tr>
    <tr>
        <td>@ref LVHF_MODE_PCD</td>
        <td>128</td>
        <td>PCD (Path Change Detector)</td>
    </tr>
    <tr>
        <td>@ref LVHF_MODE_INIT_ES</td>
        <td>256</td>
        <td>Initial echo suppression setting by PCD_gamma_e_rescue</td>
    </tr>
    <tr>
        <td>@ref LVHF_MODE_HS</td>
        <td>512</td>
        <td>HornSuppression (if available)</td>
    </tr>
    <tr>
        <td>@ref LVHF_MODE_PRENLMS</td>
        <td>4096</td>
        <td>Pre-NLMS preprocessing</td>
    </tr>
</table> */
typedef LVM_UINT16 LVHF_ModeWord_bm;
/**
* @def LVHF_MODE_NLMS
* NLMS functionality
* @see LVHF_ModeWord_bm
*/
#define LVHF_MODE_NLMS ((LVHF_ModeWord_bm)1)
/**
* @def LVHF_MODE_DES
* DES (Dynamic Echo Suppression)
* @see LVHF_ModeWord_bm
*/
#define LVHF_MODE_DES ((LVHF_ModeWord_bm)2)
/**
* @def LVHF_MODE_NS
* NS (Noise Suppression)
* @see LVHF_ModeWord_bm
*/
#define LVHF_MODE_NS ((LVHF_ModeWord_bm)4)
/**
* @def LVHF_MODE_CNI
* CNI (Comfort Noise Injection)
* @see LVHF_ModeWord_bm
*/
#define LVHF_MODE_CNI ((LVHF_ModeWord_bm)8)
/**
* @def LVHF_MODE_NLES
* NLES (Non Linear Echo Suppression)
* @see LVHF_ModeWord_bm
*/
#define LVHF_MODE_NLES ((LVHF_ModeWord_bm)16)
/**
* @def LVHF_MODE_PCD_DT
* DT (Double Talk) protection after PCD
* @see LVHF_ModeWord_bm
*/
#define LVHF_MODE_PCD_DT ((LVHF_ModeWord_bm)64)
/**
* @def LVHF_MODE_PCD
* PCD (Path Change Detector)
* @see LVHF_ModeWord_bm
*/
#define LVHF_MODE_PCD ((LVHF_ModeWord_bm)128)
/**
* @def LVHF_MODE_INIT_ES
* Initial echo suppression setting by PCD_gamma_e_rescue
* @see LVHF_ModeWord_bm
*/
#define LVHF_MODE_INIT_ES ((LVHF_ModeWord_bm)256)
/**
* @def LVHF_MODE_HS
* HornSuppression (if available)
* @see LVHF_ModeWord_bm
*/
#define LVHF_MODE_HS ((LVHF_ModeWord_bm)512)
/**
* @def LVHF_MODE_PRENLMS
* Pre-NLMS preprocessing
* @see LVHF_ModeWord_bm
*/
#define LVHF_MODE_PRENLMS ((LVHF_ModeWord_bm)4096)
/**
* @def LVHF_MODEWORD_BM_MIN
* Minimal value for LVHF_ModeWord_bm
* @see LVHF_ModeWord_bm
*/
#define LVHF_MODEWORD_BM_MIN ((LVHF_ModeWord_bm)0)
/**
* @def LVHF_MODEWORD_BM_MAX
* Maximal value for LVHF_ModeWord_bm
* @see LVHF_ModeWord_bm
*/
#define LVHF_MODE_NLMS_FORMAX ((LVHF_ModeWord_bm)1)
#define LVHF_MODE_DES_FORMAX ((LVHF_ModeWord_bm)2)
#define LVHF_MODE_NS_FORMAX ((LVHF_ModeWord_bm)4)
#define LVHF_MODE_CNI_FORMAX ((LVHF_ModeWord_bm)8)
#define LVHF_MODE_NLES_FORMAX ((LVHF_ModeWord_bm)16)
#define LVHF_MODE_PCD_DT_FORMAX ((LVHF_ModeWord_bm)64)
#define LVHF_MODE_PCD_FORMAX ((LVHF_ModeWord_bm)128)
#define LVHF_MODE_INIT_ES_FORMAX ((LVHF_ModeWord_bm)256)
#define LVHF_MODE_HS_FORMAX ((LVHF_ModeWord_bm)512)
#define LVHF_MODE_PRENLMS_FORMAX ((LVHF_ModeWord_bm)4096)
#define LVHF_MODEWORD_BM_MAX (LVHF_MODE_NLMS_FORMAX | LVHF_MODE_DES_FORMAX | LVHF_MODE_NS_FORMAX | LVHF_MODE_CNI_FORMAX | LVHF_MODE_NLES_FORMAX | LVHF_MODE_PCD_DT_FORMAX | LVHF_MODE_PCD_FORMAX | LVHF_MODE_INIT_ES_FORMAX | LVHF_MODE_HS_FORMAX | LVHF_MODE_PRENLMS_FORMAX | ((LVHF_ModeWord_bm)0))
/**
<table border>
    <tr>
        <td><b>Name</b></td>
        <td><b>Value</b></td>
        <td><b>Description</b></td>
    </tr>
    <tr>
        <td>@ref LVHF_STATUS_FAR_SPEAKS</td>
        <td>1</td>
        <td>FarEnd is speaking</td>
    </tr>
    <tr>
        <td>@ref LVHF_STATUS_FAR_STARTS</td>
        <td>2</td>
        <td>FarEnd starts to speak</td>
    </tr>
    <tr>
        <td>@ref LVHF_STATUS_MIC_SPEAKS</td>
        <td>4</td>
        <td>Mic activity detected</td>
    </tr>
    <tr>
        <td>@ref LVHF_STATUS_CLIP</td>
        <td>8</td>
        <td>Clipping Detected</td>
    </tr>
    <tr>
        <td>@ref LVHF_STATUS_PATHCHANGE</td>
        <td>16</td>
        <td>Path Change detected</td>
    </tr>
</table> */
typedef LVM_UINT16 LVHF_StatusWord_bm;
/**
* @def LVHF_STATUS_FAR_SPEAKS
* FarEnd is speaking
* @see LVHF_StatusWord_bm
*/
#define LVHF_STATUS_FAR_SPEAKS ((LVHF_StatusWord_bm)1)
/**
* @def LVHF_STATUS_FAR_STARTS
* FarEnd starts to speak
* @see LVHF_StatusWord_bm
*/
#define LVHF_STATUS_FAR_STARTS ((LVHF_StatusWord_bm)2)
/**
* @def LVHF_STATUS_MIC_SPEAKS
* Mic activity detected
* @see LVHF_StatusWord_bm
*/
#define LVHF_STATUS_MIC_SPEAKS ((LVHF_StatusWord_bm)4)
/**
* @def LVHF_STATUS_CLIP
* Clipping Detected
* @see LVHF_StatusWord_bm
*/
#define LVHF_STATUS_CLIP ((LVHF_StatusWord_bm)8)
/**
* @def LVHF_STATUS_PATHCHANGE
* Path Change detected
* @see LVHF_StatusWord_bm
*/
#define LVHF_STATUS_PATHCHANGE ((LVHF_StatusWord_bm)16)
/**
* @def LVHF_STATUSWORD_BM_MIN
* Minimal value for LVHF_StatusWord_bm
* @see LVHF_StatusWord_bm
*/
#define LVHF_STATUSWORD_BM_MIN ((LVHF_StatusWord_bm)0)
/**
* @def LVHF_STATUSWORD_BM_MAX
* Maximal value for LVHF_StatusWord_bm
* @see LVHF_StatusWord_bm
*/
#define LVHF_STATUS_FAR_SPEAKS_FORMAX ((LVHF_StatusWord_bm)1)
#define LVHF_STATUS_FAR_STARTS_FORMAX ((LVHF_StatusWord_bm)2)
#define LVHF_STATUS_MIC_SPEAKS_FORMAX ((LVHF_StatusWord_bm)4)
#define LVHF_STATUS_CLIP_FORMAX ((LVHF_StatusWord_bm)8)
#define LVHF_STATUS_PATHCHANGE_FORMAX ((LVHF_StatusWord_bm)16)
#define LVHF_STATUSWORD_BM_MAX (LVHF_STATUS_FAR_SPEAKS_FORMAX | LVHF_STATUS_FAR_STARTS_FORMAX | LVHF_STATUS_MIC_SPEAKS_FORMAX | LVHF_STATUS_CLIP_FORMAX | LVHF_STATUS_PATHCHANGE_FORMAX | ((LVHF_StatusWord_bm)0))

#define LVVIDHEADER_LVVE_RX_MASK1_LVWIREFORMAT_LENGTH (2) ///< Number of bytes to encode @ref LVVIDHeader_LVVE_Rx_Mask1_bm in LVWireFormat.

#define LVVIDHEADER_LVVE_RX_MASK2_LVWIREFORMAT_LENGTH (2) ///< Number of bytes to encode @ref LVVIDHeader_LVVE_Rx_Mask2_bm in LVWireFormat.

#define LVVIDHEADER_LVVE_TX_MASK1_LVWIREFORMAT_LENGTH (2) ///< Number of bytes to encode @ref LVVIDHeader_LVVE_Tx_Mask1_bm in LVWireFormat.

#define LVVIDHEADER_LVVE_TX_MASK2_LVWIREFORMAT_LENGTH (2) ///< Number of bytes to encode @ref LVVIDHeader_LVVE_Tx_Mask2_bm in LVWireFormat.

#define LVVIDHEADER_CONFIGURATIONS_MASK1_LVWIREFORMAT_LENGTH (2) ///< Number of bytes to encode @ref LVVIDHeader_Configurations_Mask1_bm in LVWireFormat.

#define LVVIDHEADER_CONFIGURATIONS_MASK2_LVWIREFORMAT_LENGTH (2) ///< Number of bytes to encode @ref LVVIDHeader_Configurations_Mask2_bm in LVWireFormat.

#define LVVC_MODEWORD_LVWIREFORMAT_LENGTH (2) ///< Number of bytes to encode @ref LVVC_ModeWord_bm in LVWireFormat.

#define LVFENS_MODEWORD_LVWIREFORMAT_LENGTH (2) ///< Number of bytes to encode @ref LVFENS_ModeWord_bm in LVWireFormat.

#define LVWM_MODEWORD_LVWIREFORMAT_LENGTH (2) ///< Number of bytes to encode @ref LVWM_ModeWord_bm in LVWireFormat.

#define LVNV_MODEWORD_LVWIREFORMAT_LENGTH (2) ///< Number of bytes to encode @ref LVNV_ModeWord_bm in LVWireFormat.

#define LVNV_MODE2WORD_LVWIREFORMAT_LENGTH (2) ///< Number of bytes to encode @ref LVNV_Mode2Word_bm in LVWireFormat.

#define LVNV_TUNINGMODEWORD_LVWIREFORMAT_LENGTH (2) ///< Number of bytes to encode @ref LVNV_TuningModeWord_bm in LVWireFormat.

#define LVNV_STATUSWORD_LVWIREFORMAT_LENGTH (2) ///< Number of bytes to encode @ref LVNV_StatusWord_bm in LVWireFormat.

#define LVHF_TUNINGMODEWORD_LVWIREFORMAT_LENGTH (2) ///< Number of bytes to encode @ref LVHF_TuningModeWord in LVWireFormat.

#define LVHF_MODEWORD_LVWIREFORMAT_LENGTH (2) ///< Number of bytes to encode @ref LVHF_ModeWord_bm in LVWireFormat.

#define LVHF_STATUSWORD_LVWIREFORMAT_LENGTH (2) ///< Number of bytes to encode @ref LVHF_StatusWord_bm in LVWireFormat.

#define LVM_MODE_LVWIREFORMAT_LENGTH (4) ///< Number of bytes to encode @ref LVM_Mode_en in LVWireFormat.

#define LVM_CONFIG_LVWIREFORMAT_LENGTH (4) ///< Number of bytes to encode @ref LVM_Config_en in LVWireFormat.

#define LVM_FS_LVWIREFORMAT_LENGTH (4) ///< Number of bytes to encode @ref LVM_Fs_en in LVWireFormat.

#define LVVIDHEADER_MESSAGEID_LVWIREFORMAT_LENGTH (4) ///< Number of bytes to encode @ref LVVIDHeader_MessageID_en in LVWireFormat.

#define LVVIDHEADER_RETURNSTATUS_LVWIREFORMAT_LENGTH (4) ///< Number of bytes to encode @ref LVVIDHeader_ReturnStatus_en in LVWireFormat.

#define LVVE_RX_MODE_LVWIREFORMAT_LENGTH (4) ///< Number of bytes to encode @ref LVVE_Rx_Mode_en in LVWireFormat.

#define LVVE_TX_MODE_LVWIREFORMAT_LENGTH (4) ///< Number of bytes to encode @ref LVVE_Tx_Mode_en in LVWireFormat.

#define LVVIDHEADER_CONTROLPARAMS_LVWIREFORMAT_LENGTH (7 \
 + LVVIDHEADER_LVVE_RX_MASK1_LVWIREFORMAT_LENGTH \
 + LVVIDHEADER_LVVE_RX_MASK2_LVWIREFORMAT_LENGTH \
 + LVVIDHEADER_LVVE_TX_MASK1_LVWIREFORMAT_LENGTH \
 + LVVIDHEADER_LVVE_TX_MASK2_LVWIREFORMAT_LENGTH \
 + LVVIDHEADER_CONFIGURATIONS_MASK1_LVWIREFORMAT_LENGTH \
 + LVVIDHEADER_CONFIGURATIONS_MASK2_LVWIREFORMAT_LENGTH \
 + LVVIDHEADER_MESSAGEID_LVWIREFORMAT_LENGTH \
 + LVM_FS_LVWIREFORMAT_LENGTH) ///< Number of bytes to encode LVVIDHeader ControlParameters in LVWireFormat.

#define LVVC_CONTROLPARAMS_LVWIREFORMAT_LENGTH (22 \
 + LVM_MODE_LVWIREFORMAT_LENGTH \
 + LVVC_MODEWORD_LVWIREFORMAT_LENGTH) ///< Number of bytes to encode LVVC ControlParameters in LVWireFormat.

#define LVFENS_CONTROLPARAMS_LVWIREFORMAT_LENGTH (2 \
 + LVM_MODE_LVWIREFORMAT_LENGTH \
 + LVFENS_MODEWORD_LVWIREFORMAT_LENGTH) ///< Number of bytes to encode LVFENS ControlParameters in LVWireFormat.

#define LVWM_CONTROLPARAMS_LVWIREFORMAT_LENGTH (14 \
 + LVM_MODE_LVWIREFORMAT_LENGTH \
 + LVWM_MODEWORD_LVWIREFORMAT_LENGTH) ///< Number of bytes to encode LVWM ControlParameters in LVWireFormat.

#define LVDRC_CONTROLPARAMS_LVWIREFORMAT_LENGTH (28 \
 + LVM_MODE_LVWIREFORMAT_LENGTH \
 + LVM_MODE_LVWIREFORMAT_LENGTH) ///< Number of bytes to encode LVDRC ControlParameters in LVWireFormat.

#define LVNG_CONTROLPARAMS_LVWIREFORMAT_LENGTH (26 \
 + LVM_MODE_LVWIREFORMAT_LENGTH) ///< Number of bytes to encode LVNG ControlParameters in LVWireFormat.

#define LVNLPP_CONTROLPARAMS_LVWIREFORMAT_LENGTH (4) ///< Number of bytes to encode LVNLPP ControlParameters in LVWireFormat.

#define LVEQ_CONTROLPARAMS_LVWIREFORMAT_LENGTH (130) ///< Number of bytes to encode LVEQ ControlParameters in LVWireFormat.

#define LVVOL_CONTROLPARAMS_LVWIREFORMAT_LENGTH (2 \
 + LVM_MODE_LVWIREFORMAT_LENGTH) ///< Number of bytes to encode LVVOL ControlParameters in LVWireFormat.

#define LVHPF_CONTROLPARAMS_LVWIREFORMAT_LENGTH (2 \
 + LVM_MODE_LVWIREFORMAT_LENGTH) ///< Number of bytes to encode LVHPF ControlParameters in LVWireFormat.

#define LVMUTE_CONTROLPARAMS_LVWIREFORMAT_LENGTH (LVM_MODE_LVWIREFORMAT_LENGTH) ///< Number of bytes to encode LVMUTE ControlParameters in LVWireFormat.

#define LVVE_RX_CONTROLPARAMS_LVWIREFORMAT_LENGTH (4 \
 + LVVE_RX_MODE_LVWIREFORMAT_LENGTH \
 + LVM_MODE_LVWIREFORMAT_LENGTH \
 + LVM_MODE_LVWIREFORMAT_LENGTH \
 + LVFENS_CONTROLPARAMS_LVWIREFORMAT_LENGTH \
 + LVM_MODE_LVWIREFORMAT_LENGTH \
 + LVNLPP_CONTROLPARAMS_LVWIREFORMAT_LENGTH \
 + LVVC_CONTROLPARAMS_LVWIREFORMAT_LENGTH \
 + LVM_MODE_LVWIREFORMAT_LENGTH \
 + LVEQ_CONTROLPARAMS_LVWIREFORMAT_LENGTH \
 + LVDRC_CONTROLPARAMS_LVWIREFORMAT_LENGTH \
 + LVM_MODE_LVWIREFORMAT_LENGTH \
 + LVWM_CONTROLPARAMS_LVWIREFORMAT_LENGTH \
 + LVNG_CONTROLPARAMS_LVWIREFORMAT_LENGTH) ///< Number of bytes to encode LVVE_Rx ControlParameters in LVWireFormat.

#define LVNV_CONTROLPARAMS_LVWIREFORMAT_LENGTH (122 \
 + LVM_MODE_LVWIREFORMAT_LENGTH \
 + LVNV_MODEWORD_LVWIREFORMAT_LENGTH \
 + LVNV_MODE2WORD_LVWIREFORMAT_LENGTH \
 + LVNV_TUNINGMODEWORD_LVWIREFORMAT_LENGTH) ///< Number of bytes to encode LVNV ControlParameters in LVWireFormat.

#define LVHF_CONTROLPARAMS_LVWIREFORMAT_LENGTH (78 \
 + LVM_MODE_LVWIREFORMAT_LENGTH \
 + LVHF_MODEWORD_LVWIREFORMAT_LENGTH \
 + LVHF_TUNINGMODEWORD_LVWIREFORMAT_LENGTH) ///< Number of bytes to encode LVHF ControlParameters in LVWireFormat.

#define LVBD_CONTROLPARAMS_LVWIREFORMAT_LENGTH (4 \
 + LVM_MODE_LVWIREFORMAT_LENGTH) ///< Number of bytes to encode LVBD ControlParameters in LVWireFormat.

#define LVVE_TX_CONTROLPARAMS_LVWIREFORMAT_LENGTH (8 \
 + LVVE_TX_MODE_LVWIREFORMAT_LENGTH \
 + LVM_MODE_LVWIREFORMAT_LENGTH \
 + LVM_MODE_LVWIREFORMAT_LENGTH \
 + LVM_MODE_LVWIREFORMAT_LENGTH \
 + LVM_MODE_LVWIREFORMAT_LENGTH \
 + LVHF_CONTROLPARAMS_LVWIREFORMAT_LENGTH \
 + LVNV_CONTROLPARAMS_LVWIREFORMAT_LENGTH \
 + LVWM_CONTROLPARAMS_LVWIREFORMAT_LENGTH \
 + LVM_MODE_LVWIREFORMAT_LENGTH \
 + LVEQ_CONTROLPARAMS_LVWIREFORMAT_LENGTH \
 + LVDRC_CONTROLPARAMS_LVWIREFORMAT_LENGTH) ///< Number of bytes to encode LVVE_Tx ControlParameters in LVWireFormat.

/**
* @def LVVIDHEADER_HEADERVERSION_DEFAULT
* Default of HeaderVersion
* @see LVVIDHeader_ControlParams_st
*/
#define LVVIDHEADER_HEADERVERSION_DEFAULT (3)
/**
* @def LVVIDHEADER_HEADERVERSION_MIN
* MinValue of HeaderVersion
* @see LVVIDHeader_ControlParams_st
*/
#define LVVIDHEADER_HEADERVERSION_MIN (0)
/**
* @def LVVIDHEADER_HEADERVERSION_MAX
* MaxValue of HeaderVersion
* @see LVVIDHeader_ControlParams_st
*/
#define LVVIDHEADER_HEADERVERSION_MAX (255)

/**
* @def LVVIDHEADER_BASELINEVERSION_DEFAULT
* Default of BaselineVersion
* @see LVVIDHeader_ControlParams_st
*/
#define LVVIDHEADER_BASELINEVERSION_DEFAULT (51906816)
/**
* @def LVVIDHEADER_BASELINEVERSION_MIN
* MinValue of BaselineVersion
* @see LVVIDHeader_ControlParams_st
*/
#define LVVIDHEADER_BASELINEVERSION_MIN (1)
/**
* @def LVVIDHEADER_BASELINEVERSION_MAX
* MaxValue of BaselineVersion
* @see LVVIDHeader_ControlParams_st
*/
#define LVVIDHEADER_BASELINEVERSION_MAX (4294967295)

/**
* @def LVVIDHEADER_LVVE_RX_ALGOMASK1_DEFAULT
* Default of LVVE_Rx_AlgoMask1
* @see LVVIDHeader_ControlParams_st
*/
#define LVVIDHEADER_LVVE_RX_ALGOMASK1_DEFAULT (LVVIDHEADER_LVVE_RX_MASK1_BM_MAX)

/**
* @def LVVIDHEADER_LVVE_RX_ALGOMASK2_DEFAULT
* Default of LVVE_Rx_AlgoMask2
* @see LVVIDHeader_ControlParams_st
*/
#define LVVIDHEADER_LVVE_RX_ALGOMASK2_DEFAULT (LVVIDHEADER_LVVE_RX_MASK2_BM_MAX)

/**
* @def LVVIDHEADER_LVVE_TX_ALGOMASK1_DEFAULT
* Default of LVVE_Tx_AlgoMask1
* @see LVVIDHeader_ControlParams_st
*/
#define LVVIDHEADER_LVVE_TX_ALGOMASK1_DEFAULT (LVVIDHEADER_LVVE_TX_MASK1_BM_MAX)

/**
* @def LVVIDHEADER_LVVE_TX_ALGOMASK2_DEFAULT
* Default of LVVE_Tx_AlgoMask2
* @see LVVIDHeader_ControlParams_st
*/
#define LVVIDHEADER_LVVE_TX_ALGOMASK2_DEFAULT (LVVIDHEADER_LVVE_TX_MASK2_BM_MAX)

/**
* @def LVVIDHEADER_LVVE_CONFIG_ALGOMASK1_DEFAULT
* Default of LVVE_Config_AlgoMask1
* @see LVVIDHeader_ControlParams_st
*/
#define LVVIDHEADER_LVVE_CONFIG_ALGOMASK1_DEFAULT (LVVIDHEADER_CONFIGURATIONS_MASK1_BM_MAX)

/**
* @def LVVIDHEADER_LVVE_CONFIG_ALGOMASK2_DEFAULT
* Default of LVVE_Config_AlgoMask2
* @see LVVIDHeader_ControlParams_st
*/
#define LVVIDHEADER_LVVE_CONFIG_ALGOMASK2_DEFAULT (LVVIDHEADER_CONFIGURATIONS_MASK2_BM_MAX)

/**
* @def LVVIDHEADER_MESSAGEID_DEFAULT
* Default of MessageID
* @see LVVIDHeader_ControlParams_st
*/
#define LVVIDHEADER_MESSAGEID_DEFAULT (LVVE_RX_PRESET)

/**
* @def LVVIDHEADER_SAMPLERATE_DEFAULT
* Default of SampleRate
* @see LVVIDHeader_ControlParams_st
*/
#define LVVIDHEADER_SAMPLERATE_DEFAULT (LVM_FS_8000)

/**
* @def LVVIDHEADER_VOLUMEINDEX_DEFAULT
* Default of VolumeIndex
* @see LVVIDHeader_ControlParams_st
*/
#define LVVIDHEADER_VOLUMEINDEX_DEFAULT (0)
/**
* @def LVVIDHEADER_VOLUMEINDEX_MIN
* MinValue of VolumeIndex
* @see LVVIDHeader_ControlParams_st
*/
#define LVVIDHEADER_VOLUMEINDEX_MIN (0)
/**
* @def LVVIDHEADER_VOLUMEINDEX_MAX
* MaxValue of VolumeIndex
* @see LVVIDHeader_ControlParams_st
*/
#define LVVIDHEADER_VOLUMEINDEX_MAX (255)

/**
* @def LVVIDHEADER_NUMVOLUMES_DEFAULT
* Default of NumVolumes
* @see LVVIDHeader_ControlParams_st
*/
#define LVVIDHEADER_NUMVOLUMES_DEFAULT (1)
/**
* @def LVVIDHEADER_NUMVOLUMES_MIN
* MinValue of NumVolumes
* @see LVVIDHeader_ControlParams_st
*/
#define LVVIDHEADER_NUMVOLUMES_MIN (0)
/**
* @def LVVIDHEADER_NUMVOLUMES_MAX
* MaxValue of NumVolumes
* @see LVVIDHeader_ControlParams_st
*/
#define LVVIDHEADER_NUMVOLUMES_MAX (255)

/**
* @def LVVC_OPERATINGMODE_DEFAULT
* Default of OperatingMode
* @see LVVC_ControlParams_st
*/
#define LVVC_OPERATINGMODE_DEFAULT (LVM_MODE_OFF)

/**
* @def LVVC_MODE_DEFAULT
* Default of mode
* @see LVVC_ControlParams_st
*/
#define LVVC_MODE_DEFAULT (0)

/**
* @def LVVC_GAIN_LIN_MAX_DEFAULT
* Default of Gain_Lin_Max
* @see LVVC_ControlParams_st
*/
#define LVVC_GAIN_LIN_MAX_DEFAULT (1286)
/**
* @def LVVC_GAIN_LIN_MAX_MIN
* MinValue of Gain_Lin_Max
* @see LVVC_ControlParams_st
*/
#define LVVC_GAIN_LIN_MAX_MIN (512)
/**
* @def LVVC_GAIN_LIN_MAX_MAX
* MaxValue of Gain_Lin_Max
* @see LVVC_ControlParams_st
*/
#define LVVC_GAIN_LIN_MAX_MAX (32767)

/**
* @def LVVC_NOISE_SENSITIVITY_DEFAULT
* Default of Noise_Sensitivity
* @see LVVC_ControlParams_st
*/
#define LVVC_NOISE_SENSITIVITY_DEFAULT (20000)
/**
* @def LVVC_NOISE_SENSITIVITY_MIN
* MinValue of Noise_Sensitivity
* @see LVVC_ControlParams_st
*/
#define LVVC_NOISE_SENSITIVITY_MIN (-6709)
/**
* @def LVVC_NOISE_SENSITIVITY_MAX
* MaxValue of Noise_Sensitivity
* @see LVVC_ControlParams_st
*/
#define LVVC_NOISE_SENSITIVITY_MAX (32767)

/**
* @def LVVC_AVL_TARGET_LEVEL_LIN_DEFAULT
* Default of AVL_Target_level_lin
* @see LVVC_ControlParams_st
*/
#define LVVC_AVL_TARGET_LEVEL_LIN_DEFAULT (16384)
/**
* @def LVVC_AVL_TARGET_LEVEL_LIN_MIN
* MinValue of AVL_Target_level_lin
* @see LVVC_ControlParams_st
*/
#define LVVC_AVL_TARGET_LEVEL_LIN_MIN (0)
/**
* @def LVVC_AVL_TARGET_LEVEL_LIN_MAX
* MaxValue of AVL_Target_level_lin
* @see LVVC_ControlParams_st
*/
#define LVVC_AVL_TARGET_LEVEL_LIN_MAX (32767)

/**
* @def LVVC_AVL_MINGAINLIN_DEFAULT
* Default of AVL_MinGainLin
* @see LVVC_ControlParams_st
*/
#define LVVC_AVL_MINGAINLIN_DEFAULT (256)
/**
* @def LVVC_AVL_MINGAINLIN_MIN
* MinValue of AVL_MinGainLin
* @see LVVC_ControlParams_st
*/
#define LVVC_AVL_MINGAINLIN_MIN (0)
/**
* @def LVVC_AVL_MINGAINLIN_MAX
* MaxValue of AVL_MinGainLin
* @see LVVC_ControlParams_st
*/
#define LVVC_AVL_MINGAINLIN_MAX (512)

/**
* @def LVVC_AVL_MAXGAINLIN_DEFAULT
* Default of AVL_MaxGainLin
* @see LVVC_ControlParams_st
*/
#define LVVC_AVL_MAXGAINLIN_DEFAULT (8192)
/**
* @def LVVC_AVL_MAXGAINLIN_MIN
* MinValue of AVL_MaxGainLin
* @see LVVC_ControlParams_st
*/
#define LVVC_AVL_MAXGAINLIN_MIN (512)
/**
* @def LVVC_AVL_MAXGAINLIN_MAX
* MaxValue of AVL_MaxGainLin
* @see LVVC_ControlParams_st
*/
#define LVVC_AVL_MAXGAINLIN_MAX (32767)

/**
* @def LVVC_AVL_NOMINALGAIN_DEFAULT
* Default of AVL_NominalGain
* @see LVVC_ControlParams_st
*/
#define LVVC_AVL_NOMINALGAIN_DEFAULT (512)
/**
* @def LVVC_AVL_NOMINALGAIN_MIN
* MinValue of AVL_NominalGain
* @see LVVC_ControlParams_st
*/
#define LVVC_AVL_NOMINALGAIN_MIN (0)
/**
* @def LVVC_AVL_NOMINALGAIN_MAX
* MaxValue of AVL_NominalGain
* @see LVVC_ControlParams_st
*/
#define LVVC_AVL_NOMINALGAIN_MAX (32767)

/**
* @def LVVC_AVL_ATTACK_DEFAULT
* Default of AVL_Attack
* @see LVVC_ControlParams_st
*/
#define LVVC_AVL_ATTACK_DEFAULT (12055)
/**
* @def LVVC_AVL_ATTACK_MIN
* MinValue of AVL_Attack
* @see LVVC_ControlParams_st
*/
#define LVVC_AVL_ATTACK_MIN (0)
/**
* @def LVVC_AVL_ATTACK_MAX
* MaxValue of AVL_Attack
* @see LVVC_ControlParams_st
*/
#define LVVC_AVL_ATTACK_MAX (32767)

/**
* @def LVVC_AVL_RELEASE_DEFAULT
* Default of AVL_Release
* @see LVVC_ControlParams_st
*/
#define LVVC_AVL_RELEASE_DEFAULT (32604)
/**
* @def LVVC_AVL_RELEASE_MIN
* MinValue of AVL_Release
* @see LVVC_ControlParams_st
*/
#define LVVC_AVL_RELEASE_MIN (0)
/**
* @def LVVC_AVL_RELEASE_MAX
* MaxValue of AVL_Release
* @see LVVC_ControlParams_st
*/
#define LVVC_AVL_RELEASE_MAX (32767)

/**
* @def LVVC_AVL_RELEASEMAX_DEFAULT
* Default of AVL_ReleaseMax
* @see LVVC_ControlParams_st
*/
#define LVVC_AVL_RELEASEMAX_DEFAULT (32441)
/**
* @def LVVC_AVL_RELEASEMAX_MIN
* MinValue of AVL_ReleaseMax
* @see LVVC_ControlParams_st
*/
#define LVVC_AVL_RELEASEMAX_MIN (0)
/**
* @def LVVC_AVL_RELEASEMAX_MAX
* MaxValue of AVL_ReleaseMax
* @see LVVC_ControlParams_st
*/
#define LVVC_AVL_RELEASEMAX_MAX (32767)

/**
* @def LVVC_AVL_LIMIT_MAXOUTPUTLIN_DEFAULT
* Default of AVL_Limit_MaxOutputLin
* @see LVVC_ControlParams_st
*/
#define LVVC_AVL_LIMIT_MAXOUTPUTLIN_DEFAULT (23170)
/**
* @def LVVC_AVL_LIMIT_MAXOUTPUTLIN_MIN
* MinValue of AVL_Limit_MaxOutputLin
* @see LVVC_ControlParams_st
*/
#define LVVC_AVL_LIMIT_MAXOUTPUTLIN_MIN (0)
/**
* @def LVVC_AVL_LIMIT_MAXOUTPUTLIN_MAX
* MaxValue of AVL_Limit_MaxOutputLin
* @see LVVC_ControlParams_st
*/
#define LVVC_AVL_LIMIT_MAXOUTPUTLIN_MAX (32767)

/**
* @def LVVC_SPDETECT_THRESHOLD_DEFAULT
* Default of SpDetect_Threshold
* @see LVVC_ControlParams_st
*/
#define LVVC_SPDETECT_THRESHOLD_DEFAULT (1024)
/**
* @def LVVC_SPDETECT_THRESHOLD_MIN
* MinValue of SpDetect_Threshold
* @see LVVC_ControlParams_st
*/
#define LVVC_SPDETECT_THRESHOLD_MIN (0)
/**
* @def LVVC_SPDETECT_THRESHOLD_MAX
* MaxValue of SpDetect_Threshold
* @see LVVC_ControlParams_st
*/
#define LVVC_SPDETECT_THRESHOLD_MAX (32767)

/**
* @def LVFENS_OPERATINGMODE_DEFAULT
* Default of OperatingMode
* @see LVFENS_ControlParams_st
*/
#define LVFENS_OPERATINGMODE_DEFAULT (LVM_MODE_OFF)

/**
* @def LVFENS_FENS_LIMIT_NS_DEFAULT
* Default of FENS_limit_NS
* @see LVFENS_ControlParams_st
*/
#define LVFENS_FENS_LIMIT_NS_DEFAULT (10976)
/**
* @def LVFENS_FENS_LIMIT_NS_MIN
* MinValue of FENS_limit_NS
* @see LVFENS_ControlParams_st
*/
#define LVFENS_FENS_LIMIT_NS_MIN (0)
/**
* @def LVFENS_FENS_LIMIT_NS_MAX
* MaxValue of FENS_limit_NS
* @see LVFENS_ControlParams_st
*/
#define LVFENS_FENS_LIMIT_NS_MAX (32767)

/**
* @def LVFENS_MODE_DEFAULT
* Default of Mode
* @see LVFENS_ControlParams_st
*/
#define LVFENS_MODE_DEFAULT (0)

/**
* @def LVWM_OPERATINGMODE_DEFAULT
* Default of OperatingMode
* @see LVWM_ControlParams_st
*/
#define LVWM_OPERATINGMODE_DEFAULT (LVM_MODE_OFF)

/**
* @def LVWM_MODE_DEFAULT
* Default of mode
* @see LVWM_ControlParams_st
*/
#define LVWM_MODE_DEFAULT (7)

/**
* @def LVWM_AVL_TARGET_LEVEL_LIN_DEFAULT
* Default of AVL_Target_level_lin
* @see LVWM_ControlParams_st
*/
#define LVWM_AVL_TARGET_LEVEL_LIN_DEFAULT (16384)
/**
* @def LVWM_AVL_TARGET_LEVEL_LIN_MIN
* MinValue of AVL_Target_level_lin
* @see LVWM_ControlParams_st
*/
#define LVWM_AVL_TARGET_LEVEL_LIN_MIN (0)
/**
* @def LVWM_AVL_TARGET_LEVEL_LIN_MAX
* MaxValue of AVL_Target_level_lin
* @see LVWM_ControlParams_st
*/
#define LVWM_AVL_TARGET_LEVEL_LIN_MAX (32767)

/**
* @def LVWM_AVL_MINGAINLIN_DEFAULT
* Default of AVL_MinGainLin
* @see LVWM_ControlParams_st
*/
#define LVWM_AVL_MINGAINLIN_DEFAULT (128)
/**
* @def LVWM_AVL_MINGAINLIN_MIN
* MinValue of AVL_MinGainLin
* @see LVWM_ControlParams_st
*/
#define LVWM_AVL_MINGAINLIN_MIN (0)
/**
* @def LVWM_AVL_MINGAINLIN_MAX
* MaxValue of AVL_MinGainLin
* @see LVWM_ControlParams_st
*/
#define LVWM_AVL_MINGAINLIN_MAX (512)

/**
* @def LVWM_AVL_MAXGAINLIN_DEFAULT
* Default of AVL_MaxGainLin
* @see LVWM_ControlParams_st
*/
#define LVWM_AVL_MAXGAINLIN_DEFAULT (8189)
/**
* @def LVWM_AVL_MAXGAINLIN_MIN
* MinValue of AVL_MaxGainLin
* @see LVWM_ControlParams_st
*/
#define LVWM_AVL_MAXGAINLIN_MIN (512)
/**
* @def LVWM_AVL_MAXGAINLIN_MAX
* MaxValue of AVL_MaxGainLin
* @see LVWM_ControlParams_st
*/
#define LVWM_AVL_MAXGAINLIN_MAX (32767)

/**
* @def LVWM_AVL_ATTACK_DEFAULT
* Default of AVL_Attack
* @see LVWM_ControlParams_st
*/
#define LVWM_AVL_ATTACK_DEFAULT (25520)
/**
* @def LVWM_AVL_ATTACK_MIN
* MinValue of AVL_Attack
* @see LVWM_ControlParams_st
*/
#define LVWM_AVL_ATTACK_MIN (0)
/**
* @def LVWM_AVL_ATTACK_MAX
* MaxValue of AVL_Attack
* @see LVWM_ControlParams_st
*/
#define LVWM_AVL_ATTACK_MAX (32767)

/**
* @def LVWM_AVL_RELEASE_DEFAULT
* Default of AVL_Release
* @see LVWM_ControlParams_st
*/
#define LVWM_AVL_RELEASE_DEFAULT (32685)
/**
* @def LVWM_AVL_RELEASE_MIN
* MinValue of AVL_Release
* @see LVWM_ControlParams_st
*/
#define LVWM_AVL_RELEASE_MIN (0)
/**
* @def LVWM_AVL_RELEASE_MAX
* MaxValue of AVL_Release
* @see LVWM_ControlParams_st
*/
#define LVWM_AVL_RELEASE_MAX (32767)

/**
* @def LVWM_AVL_LIMIT_MAXOUTPUTLIN_DEFAULT
* Default of AVL_Limit_MaxOutputLin
* @see LVWM_ControlParams_st
*/
#define LVWM_AVL_LIMIT_MAXOUTPUTLIN_DEFAULT (23197)
/**
* @def LVWM_AVL_LIMIT_MAXOUTPUTLIN_MIN
* MinValue of AVL_Limit_MaxOutputLin
* @see LVWM_ControlParams_st
*/
#define LVWM_AVL_LIMIT_MAXOUTPUTLIN_MIN (0)
/**
* @def LVWM_AVL_LIMIT_MAXOUTPUTLIN_MAX
* MaxValue of AVL_Limit_MaxOutputLin
* @see LVWM_ControlParams_st
*/
#define LVWM_AVL_LIMIT_MAXOUTPUTLIN_MAX (32767)

/**
* @def LVWM_SPDETECT_THRESHOLD_DEFAULT
* Default of SpDetect_Threshold
* @see LVWM_ControlParams_st
*/
#define LVWM_SPDETECT_THRESHOLD_DEFAULT (9216)
/**
* @def LVWM_SPDETECT_THRESHOLD_MIN
* MinValue of SpDetect_Threshold
* @see LVWM_ControlParams_st
*/
#define LVWM_SPDETECT_THRESHOLD_MIN (0)
/**
* @def LVWM_SPDETECT_THRESHOLD_MAX
* MaxValue of SpDetect_Threshold
* @see LVWM_ControlParams_st
*/
#define LVWM_SPDETECT_THRESHOLD_MAX (32767)

/**
* @def LVDRC_OPERATINGMODE_DEFAULT
* Default of OperatingMode
* @see LVDRC_ControlParams_st
*/
#define LVDRC_OPERATINGMODE_DEFAULT (LVM_MODE_OFF)

/**
* @def LVDRC_NUMKNEES_DEFAULT
* Default of NumKnees
* @see LVDRC_ControlParams_st
*/
#define LVDRC_NUMKNEES_DEFAULT (5)
/**
* @def LVDRC_NUMKNEES_MIN
* MinValue of NumKnees
* @see LVDRC_ControlParams_st
*/
#define LVDRC_NUMKNEES_MIN (1)
/**
* @def LVDRC_NUMKNEES_MAX
* MaxValue of NumKnees
* @see LVDRC_ControlParams_st
*/
#define LVDRC_NUMKNEES_MAX (5)

/**
* @def LVDRC_COMPRESSORCURVEINPUTLEVELS_DEFAULT
* Default of CompressorCurveInputLevels
* @see LVDRC_ControlParams_st
*/
#define LVDRC_COMPRESSORCURVEINPUTLEVELS_DEFAULT {-96,-70,-50, -24, 0}
/**
* @def LVDRC_COMPRESSORCURVEINPUTLEVELS_MIN
* MinValue of CompressorCurveInputLevels
* @see LVDRC_ControlParams_st
*/
#define LVDRC_COMPRESSORCURVEINPUTLEVELS_MIN (-96)
/**
* @def LVDRC_COMPRESSORCURVEINPUTLEVELS_MAX
* MaxValue of CompressorCurveInputLevels
* @see LVDRC_ControlParams_st
*/
#define LVDRC_COMPRESSORCURVEINPUTLEVELS_MAX (0)
/**
* @def LVDRC_COMPRESSORCURVEINPUTLEVELS_LENGTH
* Length of CompressorCurveInputLevels
* @see LVDRC_ControlParams_st
*/
#define LVDRC_COMPRESSORCURVEINPUTLEVELS_LENGTH (5)

/**
* @def LVDRC_COMPRESSORCURVEOUTPUTLEVELS_DEFAULT
* Default of CompressorCurveOutputLevels
* @see LVDRC_ControlParams_st
*/
#define LVDRC_COMPRESSORCURVEOUTPUTLEVELS_DEFAULT {-96,-70,-38,-12,0}
/**
* @def LVDRC_COMPRESSORCURVEOUTPUTLEVELS_MIN
* MinValue of CompressorCurveOutputLevels
* @see LVDRC_ControlParams_st
*/
#define LVDRC_COMPRESSORCURVEOUTPUTLEVELS_MIN (-96)
/**
* @def LVDRC_COMPRESSORCURVEOUTPUTLEVELS_MAX
* MaxValue of CompressorCurveOutputLevels
* @see LVDRC_ControlParams_st
*/
#define LVDRC_COMPRESSORCURVEOUTPUTLEVELS_MAX (0)
/**
* @def LVDRC_COMPRESSORCURVEOUTPUTLEVELS_LENGTH
* Length of CompressorCurveOutputLevels
* @see LVDRC_ControlParams_st
*/
#define LVDRC_COMPRESSORCURVEOUTPUTLEVELS_LENGTH (5)

/**
* @def LVDRC_ATTACKTIME_DEFAULT
* Default of AttackTime
* @see LVDRC_ControlParams_st
*/
#define LVDRC_ATTACKTIME_DEFAULT (50)
/**
* @def LVDRC_ATTACKTIME_MIN
* MinValue of AttackTime
* @see LVDRC_ControlParams_st
*/
#define LVDRC_ATTACKTIME_MIN (0)
/**
* @def LVDRC_ATTACKTIME_MAX
* MaxValue of AttackTime
* @see LVDRC_ControlParams_st
*/
#define LVDRC_ATTACKTIME_MAX (32767)

/**
* @def LVDRC_RELEASETIME_DEFAULT
* Default of ReleaseTime
* @see LVDRC_ControlParams_st
*/
#define LVDRC_RELEASETIME_DEFAULT (50)
/**
* @def LVDRC_RELEASETIME_MIN
* MinValue of ReleaseTime
* @see LVDRC_ControlParams_st
*/
#define LVDRC_RELEASETIME_MIN (0)
/**
* @def LVDRC_RELEASETIME_MAX
* MaxValue of ReleaseTime
* @see LVDRC_ControlParams_st
*/
#define LVDRC_RELEASETIME_MAX (32767)

/**
* @def LVDRC_LIMITEROPERATINGMODE_DEFAULT
* Default of LimiterOperatingMode
* @see LVDRC_ControlParams_st
*/
#define LVDRC_LIMITEROPERATINGMODE_DEFAULT (LVM_MODE_OFF)

/**
* @def LVDRC_LIMITLEVEL_DEFAULT
* Default of LimitLevel
* @see LVDRC_ControlParams_st
*/
#define LVDRC_LIMITLEVEL_DEFAULT (0)
/**
* @def LVDRC_LIMITLEVEL_MIN
* MinValue of LimitLevel
* @see LVDRC_ControlParams_st
*/
#define LVDRC_LIMITLEVEL_MIN (-96)
/**
* @def LVDRC_LIMITLEVEL_MAX
* MaxValue of LimitLevel
* @see LVDRC_ControlParams_st
*/
#define LVDRC_LIMITLEVEL_MAX (0)

/**
* @def LVNG_OPERATINGMODE_DEFAULT
* Default of OperatingMode
* @see LVNG_ControlParams_st
*/
#define LVNG_OPERATINGMODE_DEFAULT (LVM_MODE_OFF)

/**
* @def LVNG_NUMKNEES_DEFAULT
* Default of NumKnees
* @see LVNG_ControlParams_st
*/
#define LVNG_NUMKNEES_DEFAULT (5)
/**
* @def LVNG_NUMKNEES_MIN
* MinValue of NumKnees
* @see LVNG_ControlParams_st
*/
#define LVNG_NUMKNEES_MIN (1)
/**
* @def LVNG_NUMKNEES_MAX
* MaxValue of NumKnees
* @see LVNG_ControlParams_st
*/
#define LVNG_NUMKNEES_MAX (5)

/**
* @def LVNG_COMPRESSORCURVEINPUTLEVELS_DEFAULT
* Default of CompressorCurveInputLevels
* @see LVNG_ControlParams_st
*/
#define LVNG_COMPRESSORCURVEINPUTLEVELS_DEFAULT {-80,-70,-50, -24, 0}
/**
* @def LVNG_COMPRESSORCURVEINPUTLEVELS_MIN
* MinValue of CompressorCurveInputLevels
* @see LVNG_ControlParams_st
*/
#define LVNG_COMPRESSORCURVEINPUTLEVELS_MIN (-96)
/**
* @def LVNG_COMPRESSORCURVEINPUTLEVELS_MAX
* MaxValue of CompressorCurveInputLevels
* @see LVNG_ControlParams_st
*/
#define LVNG_COMPRESSORCURVEINPUTLEVELS_MAX (0)
/**
* @def LVNG_COMPRESSORCURVEINPUTLEVELS_LENGTH
* Length of CompressorCurveInputLevels
* @see LVNG_ControlParams_st
*/
#define LVNG_COMPRESSORCURVEINPUTLEVELS_LENGTH (5)

/**
* @def LVNG_COMPRESSORCURVEOUTPUTLEVELS_DEFAULT
* Default of CompressorCurveOutputLevels
* @see LVNG_ControlParams_st
*/
#define LVNG_COMPRESSORCURVEOUTPUTLEVELS_DEFAULT {-96,-80,-50, -24, 0}
/**
* @def LVNG_COMPRESSORCURVEOUTPUTLEVELS_MIN
* MinValue of CompressorCurveOutputLevels
* @see LVNG_ControlParams_st
*/
#define LVNG_COMPRESSORCURVEOUTPUTLEVELS_MIN (-96)
/**
* @def LVNG_COMPRESSORCURVEOUTPUTLEVELS_MAX
* MaxValue of CompressorCurveOutputLevels
* @see LVNG_ControlParams_st
*/
#define LVNG_COMPRESSORCURVEOUTPUTLEVELS_MAX (0)
/**
* @def LVNG_COMPRESSORCURVEOUTPUTLEVELS_LENGTH
* Length of CompressorCurveOutputLevels
* @see LVNG_ControlParams_st
*/
#define LVNG_COMPRESSORCURVEOUTPUTLEVELS_LENGTH (5)

/**
* @def LVNG_ATTACKTIME_DEFAULT
* Default of AttackTime
* @see LVNG_ControlParams_st
*/
#define LVNG_ATTACKTIME_DEFAULT (50)
/**
* @def LVNG_ATTACKTIME_MIN
* MinValue of AttackTime
* @see LVNG_ControlParams_st
*/
#define LVNG_ATTACKTIME_MIN (0)
/**
* @def LVNG_ATTACKTIME_MAX
* MaxValue of AttackTime
* @see LVNG_ControlParams_st
*/
#define LVNG_ATTACKTIME_MAX (32767)

/**
* @def LVNG_RELEASETIME_DEFAULT
* Default of ReleaseTime
* @see LVNG_ControlParams_st
*/
#define LVNG_RELEASETIME_DEFAULT (50)
/**
* @def LVNG_RELEASETIME_MIN
* MinValue of ReleaseTime
* @see LVNG_ControlParams_st
*/
#define LVNG_RELEASETIME_MIN (0)
/**
* @def LVNG_RELEASETIME_MAX
* MaxValue of ReleaseTime
* @see LVNG_ControlParams_st
*/
#define LVNG_RELEASETIME_MAX (32767)

/**
* @def LVNLPP_NLPP_LIMIT_DEFAULT
* Default of NLPP_Limit
* @see LVNLPP_ControlParams_st
*/
#define LVNLPP_NLPP_LIMIT_DEFAULT (0)
/**
* @def LVNLPP_NLPP_LIMIT_MIN
* MinValue of NLPP_Limit
* @see LVNLPP_ControlParams_st
*/
#define LVNLPP_NLPP_LIMIT_MIN (-24)
/**
* @def LVNLPP_NLPP_LIMIT_MAX
* MaxValue of NLPP_Limit
* @see LVNLPP_ControlParams_st
*/
#define LVNLPP_NLPP_LIMIT_MAX (0)

/**
* @def LVNLPP_NLPP_HPF_CORNERFREQ_DEFAULT
* Default of NLPP_HPF_CornerFreq
* @see LVNLPP_ControlParams_st
*/
#define LVNLPP_NLPP_HPF_CORNERFREQ_DEFAULT (50)
/**
* @def LVNLPP_NLPP_HPF_CORNERFREQ_MIN
* MinValue of NLPP_HPF_CornerFreq
* @see LVNLPP_ControlParams_st
*/
#define LVNLPP_NLPP_HPF_CORNERFREQ_MIN (50)
/**
* @def LVNLPP_NLPP_HPF_CORNERFREQ_MAX
* MaxValue of NLPP_HPF_CornerFreq
* @see LVNLPP_ControlParams_st
*/
#define LVNLPP_NLPP_HPF_CORNERFREQ_MAX (1000)

/**
* @def LVEQ_EQ_LENGTH_DEFAULT
* Default of EQ_Length
* @see LVEQ_ControlParams_st
*/
#define LVEQ_EQ_LENGTH_DEFAULT (64)
/**
* @def LVEQ_EQ_LENGTH_MIN
* MinValue of EQ_Length
* @see LVEQ_ControlParams_st
*/
#define LVEQ_EQ_LENGTH_MIN (8)
/**
* @def LVEQ_EQ_LENGTH_MAX
* MaxValue of EQ_Length
* @see LVEQ_ControlParams_st
*/
#define LVEQ_EQ_LENGTH_MAX (64)

/**
* @def LVEQ_EQ_COEFS_DEFAULT
* Default of EQ_Coefs
* @see LVEQ_ControlParams_st
*/
#define LVEQ_EQ_COEFS_DEFAULT {4096,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
/**
* @def LVEQ_EQ_COEFS_MIN
* MinValue of EQ_Coefs
* @see LVEQ_ControlParams_st
*/
#define LVEQ_EQ_COEFS_MIN (-32768)
/**
* @def LVEQ_EQ_COEFS_MAX
* MaxValue of EQ_Coefs
* @see LVEQ_ControlParams_st
*/
#define LVEQ_EQ_COEFS_MAX (32767)
/**
* @def LVEQ_EQ_COEFS_LENGTH
* Length of EQ_Coefs
* @see LVEQ_ControlParams_st
*/
#define LVEQ_EQ_COEFS_LENGTH (64)

/**
* @def LVVOL_VOL_OPERATINGMODE_DEFAULT
* Default of VOL_OperatingMode
* @see LVVOL_ControlParams_st
*/
#define LVVOL_VOL_OPERATINGMODE_DEFAULT (LVM_MODE_OFF)

/**
* @def LVVOL_VOL_GAIN_DEFAULT
* Default of VOL_Gain
* @see LVVOL_ControlParams_st
*/
#define LVVOL_VOL_GAIN_DEFAULT (0)
/**
* @def LVVOL_VOL_GAIN_MIN
* MinValue of VOL_Gain
* @see LVVOL_ControlParams_st
*/
#define LVVOL_VOL_GAIN_MIN (-96)
/**
* @def LVVOL_VOL_GAIN_MAX
* MaxValue of VOL_Gain
* @see LVVOL_ControlParams_st
*/
#define LVVOL_VOL_GAIN_MAX (24)

/**
* @def LVHPF_HPF_OPERATINGMODE_DEFAULT
* Default of HPF_OperatingMode
* @see LVHPF_ControlParams_st
*/
#define LVHPF_HPF_OPERATINGMODE_DEFAULT (LVM_MODE_OFF)

/**
* @def LVHPF_HPF_CORNERFREQ_DEFAULT
* Default of HPF_CornerFreq
* @see LVHPF_ControlParams_st
*/
#define LVHPF_HPF_CORNERFREQ_DEFAULT (50)
/**
* @def LVHPF_HPF_CORNERFREQ_MIN
* MinValue of HPF_CornerFreq
* @see LVHPF_ControlParams_st
*/
#define LVHPF_HPF_CORNERFREQ_MIN (50)
/**
* @def LVHPF_HPF_CORNERFREQ_MAX
* MaxValue of HPF_CornerFreq
* @see LVHPF_ControlParams_st
*/
#define LVHPF_HPF_CORNERFREQ_MAX (1500)

/**
* @def LVMUTE_MUTE_DEFAULT
* Default of Mute
* @see LVMUTE_ControlParams_st
*/
#define LVMUTE_MUTE_DEFAULT (LVM_MODE_OFF)

/**
* @def LVVE_RX_OPERATINGMODE_DEFAULT
* Default of OperatingMode
* @see LVVE_Rx_ControlParams_st
*/
#define LVVE_RX_OPERATINGMODE_DEFAULT (LVVE_RX_MODE_OFF)

/**
* @def LVVE_RX_MUTE_DEFAULT
* Default of Mute
* @see LVVE_Rx_ControlParams_st
*/
#define LVVE_RX_MUTE_DEFAULT (LVM_MODE_OFF)

/**
* @def LVVE_RX_VOL_OPERATINGMODE_DEFAULT
* Default of VOL_OperatingMode
* @see LVVE_Rx_ControlParams_st
*/
#define LVVE_RX_VOL_OPERATINGMODE_DEFAULT (LVM_MODE_OFF)

/**
* @def LVVE_RX_VOL_GAIN_DEFAULT
* Default of VOL_Gain
* @see LVVE_Rx_ControlParams_st
*/
#define LVVE_RX_VOL_GAIN_DEFAULT (0)
/**
* @def LVVE_RX_VOL_GAIN_MIN
* MinValue of VOL_Gain
* @see LVVE_Rx_ControlParams_st
*/
#define LVVE_RX_VOL_GAIN_MIN (-96)
/**
* @def LVVE_RX_VOL_GAIN_MAX
* MaxValue of VOL_Gain
* @see LVVE_Rx_ControlParams_st
*/
#define LVVE_RX_VOL_GAIN_MAX (24)


/**
* @def LVVE_RX_NLPP_OPERATINGMODE_DEFAULT
* Default of NLPP_OperatingMode
* @see LVVE_Rx_ControlParams_st
*/
#define LVVE_RX_NLPP_OPERATINGMODE_DEFAULT (LVM_MODE_OFF)



/**
* @def LVVE_RX_EQ_OPERATINGMODE_DEFAULT
* Default of EQ_OperatingMode
* @see LVVE_Rx_ControlParams_st
*/
#define LVVE_RX_EQ_OPERATINGMODE_DEFAULT (LVM_MODE_OFF)



/**
* @def LVVE_RX_HPF_OPERATINGMODE_DEFAULT
* Default of HPF_OperatingMode
* @see LVVE_Rx_ControlParams_st
*/
#define LVVE_RX_HPF_OPERATINGMODE_DEFAULT (LVM_MODE_OFF)

/**
* @def LVVE_RX_HPF_CORNERFREQ_DEFAULT
* Default of HPF_CornerFreq
* @see LVVE_Rx_ControlParams_st
*/
#define LVVE_RX_HPF_CORNERFREQ_DEFAULT (50)
/**
* @def LVVE_RX_HPF_CORNERFREQ_MIN
* MinValue of HPF_CornerFreq
* @see LVVE_Rx_ControlParams_st
*/
#define LVVE_RX_HPF_CORNERFREQ_MIN (50)
/**
* @def LVVE_RX_HPF_CORNERFREQ_MAX
* MaxValue of HPF_CornerFreq
* @see LVVE_Rx_ControlParams_st
*/
#define LVVE_RX_HPF_CORNERFREQ_MAX (1500)



/**
* @def LVNV_OPERATINGMODE_DEFAULT
* Default of OperatingMode
* @see LVNV_ControlParams_st
*/
#define LVNV_OPERATINGMODE_DEFAULT (LVM_MODE_OFF)

/**
* @def LVNV_MODE_DEFAULT
* Default of Mode
* @see LVNV_ControlParams_st
*/
#define LVNV_MODE_DEFAULT (18935)

/**
* @def LVNV_MODE2_DEFAULT
* Default of Mode2
* @see LVNV_ControlParams_st
*/
#define LVNV_MODE2_DEFAULT (14)

/**
* @def LVNV_TUNING_MODE_DEFAULT
* Default of Tuning_mode
* @see LVNV_ControlParams_st
*/
#define LVNV_TUNING_MODE_DEFAULT (0)

/**
* @def LVNV_INPUT_GAIN_MIC0_DEFAULT
* Default of Input_Gain_Mic0
* @see LVNV_ControlParams_st
*/
#define LVNV_INPUT_GAIN_MIC0_DEFAULT (8192)
/**
* @def LVNV_INPUT_GAIN_MIC0_MIN
* MinValue of Input_Gain_Mic0
* @see LVNV_ControlParams_st
*/
#define LVNV_INPUT_GAIN_MIC0_MIN (0)
/**
* @def LVNV_INPUT_GAIN_MIC0_MAX
* MaxValue of Input_Gain_Mic0
* @see LVNV_ControlParams_st
*/
#define LVNV_INPUT_GAIN_MIC0_MAX (32767)

/**
* @def LVNV_INPUT_GAIN_MIC1_DEFAULT
* Default of Input_Gain_Mic1
* @see LVNV_ControlParams_st
*/
#define LVNV_INPUT_GAIN_MIC1_DEFAULT (8192)
/**
* @def LVNV_INPUT_GAIN_MIC1_MIN
* MinValue of Input_Gain_Mic1
* @see LVNV_ControlParams_st
*/
#define LVNV_INPUT_GAIN_MIC1_MIN (0)
/**
* @def LVNV_INPUT_GAIN_MIC1_MAX
* MaxValue of Input_Gain_Mic1
* @see LVNV_ControlParams_st
*/
#define LVNV_INPUT_GAIN_MIC1_MAX (32767)

/**
* @def LVNV_OUTPUT_GAIN_DEFAULT
* Default of Output_Gain
* @see LVNV_ControlParams_st
*/
#define LVNV_OUTPUT_GAIN_DEFAULT (2048)
/**
* @def LVNV_OUTPUT_GAIN_MIN
* MinValue of Output_Gain
* @see LVNV_ControlParams_st
*/
#define LVNV_OUTPUT_GAIN_MIN (0)
/**
* @def LVNV_OUTPUT_GAIN_MAX
* MaxValue of Output_Gain
* @see LVNV_ControlParams_st
*/
#define LVNV_OUTPUT_GAIN_MAX (32767)

/**
* @def LVNV_NLMS0_LB_TAPS_DEFAULT
* Default of NLMS0_LB_taps
* @see LVNV_ControlParams_st
*/
#define LVNV_NLMS0_LB_TAPS_DEFAULT (32)
/**
* @def LVNV_NLMS0_LB_TAPS_MIN
* MinValue of NLMS0_LB_taps
* @see LVNV_ControlParams_st
*/
#define LVNV_NLMS0_LB_TAPS_MIN (16)
/**
* @def LVNV_NLMS0_LB_TAPS_MAX
* MaxValue of NLMS0_LB_taps
* @see LVNV_ControlParams_st
*/
#define LVNV_NLMS0_LB_TAPS_MAX (64)

/**
* @def LVNV_NLMS0_LB_TWOALPHA_DEFAULT
* Default of NLMS0_LB_twoalpha
* @see LVNV_ControlParams_st
*/
#define LVNV_NLMS0_LB_TWOALPHA_DEFAULT (8192)
/**
* @def LVNV_NLMS0_LB_TWOALPHA_MIN
* MinValue of NLMS0_LB_twoalpha
* @see LVNV_ControlParams_st
*/
#define LVNV_NLMS0_LB_TWOALPHA_MIN (0)
/**
* @def LVNV_NLMS0_LB_TWOALPHA_MAX
* MaxValue of NLMS0_LB_twoalpha
* @see LVNV_ControlParams_st
*/
#define LVNV_NLMS0_LB_TWOALPHA_MAX (32767)

/**
* @def LVNV_NLMS0_LB_ERL_DEFAULT
* Default of NLMS0_LB_erl
* @see LVNV_ControlParams_st
*/
#define LVNV_NLMS0_LB_ERL_DEFAULT (1000)
/**
* @def LVNV_NLMS0_LB_ERL_MIN
* MinValue of NLMS0_LB_erl
* @see LVNV_ControlParams_st
*/
#define LVNV_NLMS0_LB_ERL_MIN (64)
/**
* @def LVNV_NLMS0_LB_ERL_MAX
* MaxValue of NLMS0_LB_erl
* @see LVNV_ControlParams_st
*/
#define LVNV_NLMS0_LB_ERL_MAX (32767)

/**
* @def LVNV_NLMS0_HB_TAPS_DEFAULT
* Default of NLMS0_HB_taps
* @see LVNV_ControlParams_st
*/
#define LVNV_NLMS0_HB_TAPS_DEFAULT (24)
/**
* @def LVNV_NLMS0_HB_TAPS_MIN
* MinValue of NLMS0_HB_taps
* @see LVNV_ControlParams_st
*/
#define LVNV_NLMS0_HB_TAPS_MIN (16)
/**
* @def LVNV_NLMS0_HB_TAPS_MAX
* MaxValue of NLMS0_HB_taps
* @see LVNV_ControlParams_st
*/
#define LVNV_NLMS0_HB_TAPS_MAX (64)

/**
* @def LVNV_NLMS0_HB_TWOALPHA_DEFAULT
* Default of NLMS0_HB_twoalpha
* @see LVNV_ControlParams_st
*/
#define LVNV_NLMS0_HB_TWOALPHA_DEFAULT (8192)
/**
* @def LVNV_NLMS0_HB_TWOALPHA_MIN
* MinValue of NLMS0_HB_twoalpha
* @see LVNV_ControlParams_st
*/
#define LVNV_NLMS0_HB_TWOALPHA_MIN (0)
/**
* @def LVNV_NLMS0_HB_TWOALPHA_MAX
* MaxValue of NLMS0_HB_twoalpha
* @see LVNV_ControlParams_st
*/
#define LVNV_NLMS0_HB_TWOALPHA_MAX (32767)

/**
* @def LVNV_NLMS0_HB_ERL_DEFAULT
* Default of NLMS0_HB_erl
* @see LVNV_ControlParams_st
*/
#define LVNV_NLMS0_HB_ERL_DEFAULT (1000)
/**
* @def LVNV_NLMS0_HB_ERL_MIN
* MinValue of NLMS0_HB_erl
* @see LVNV_ControlParams_st
*/
#define LVNV_NLMS0_HB_ERL_MIN (64)
/**
* @def LVNV_NLMS0_HB_ERL_MAX
* MaxValue of NLMS0_HB_erl
* @see LVNV_ControlParams_st
*/
#define LVNV_NLMS0_HB_ERL_MAX (32767)

/**
* @def LVNV_NLMS0_PRESET_COEFS_DEFAULT
* Default of NLMS0_preset_coefs
* @see LVNV_ControlParams_st
*/
#define LVNV_NLMS0_PRESET_COEFS_DEFAULT (0)
/**
* @def LVNV_NLMS0_PRESET_COEFS_MIN
* MinValue of NLMS0_preset_coefs
* @see LVNV_ControlParams_st
*/
#define LVNV_NLMS0_PRESET_COEFS_MIN (0)
/**
* @def LVNV_NLMS0_PRESET_COEFS_MAX
* MaxValue of NLMS0_preset_coefs
* @see LVNV_ControlParams_st
*/
#define LVNV_NLMS0_PRESET_COEFS_MAX (2)

/**
* @def LVNV_NLMS0_OFFSET_DEFAULT
* Default of NLMS0_offset
* @see LVNV_ControlParams_st
*/
#define LVNV_NLMS0_OFFSET_DEFAULT (776)
/**
* @def LVNV_NLMS0_OFFSET_MIN
* MinValue of NLMS0_offset
* @see LVNV_ControlParams_st
*/
#define LVNV_NLMS0_OFFSET_MIN (0)
/**
* @def LVNV_NLMS0_OFFSET_MAX
* MaxValue of NLMS0_offset
* @see LVNV_ControlParams_st
*/
#define LVNV_NLMS0_OFFSET_MAX (32767)

/**
* @def LVNV_NLMS1_LB_TAPS_DEFAULT
* Default of NLMS1_LB_taps
* @see LVNV_ControlParams_st
*/
#define LVNV_NLMS1_LB_TAPS_DEFAULT (32)
/**
* @def LVNV_NLMS1_LB_TAPS_MIN
* MinValue of NLMS1_LB_taps
* @see LVNV_ControlParams_st
*/
#define LVNV_NLMS1_LB_TAPS_MIN (16)
/**
* @def LVNV_NLMS1_LB_TAPS_MAX
* MaxValue of NLMS1_LB_taps
* @see LVNV_ControlParams_st
*/
#define LVNV_NLMS1_LB_TAPS_MAX (32)

/**
* @def LVNV_NLMS1_LB_TWOALPHA_DEFAULT
* Default of NLMS1_LB_twoalpha
* @see LVNV_ControlParams_st
*/
#define LVNV_NLMS1_LB_TWOALPHA_DEFAULT (8192)
/**
* @def LVNV_NLMS1_LB_TWOALPHA_MIN
* MinValue of NLMS1_LB_twoalpha
* @see LVNV_ControlParams_st
*/
#define LVNV_NLMS1_LB_TWOALPHA_MIN (0)
/**
* @def LVNV_NLMS1_LB_TWOALPHA_MAX
* MaxValue of NLMS1_LB_twoalpha
* @see LVNV_ControlParams_st
*/
#define LVNV_NLMS1_LB_TWOALPHA_MAX (32767)

/**
* @def LVNV_NLMS1_LB_ERL_DEFAULT
* Default of NLMS1_LB_erl
* @see LVNV_ControlParams_st
*/
#define LVNV_NLMS1_LB_ERL_DEFAULT (1000)
/**
* @def LVNV_NLMS1_LB_ERL_MIN
* MinValue of NLMS1_LB_erl
* @see LVNV_ControlParams_st
*/
#define LVNV_NLMS1_LB_ERL_MIN (64)
/**
* @def LVNV_NLMS1_LB_ERL_MAX
* MaxValue of NLMS1_LB_erl
* @see LVNV_ControlParams_st
*/
#define LVNV_NLMS1_LB_ERL_MAX (32767)

/**
* @def LVNV_NLMS1_HB_TAPS_DEFAULT
* Default of NLMS1_HB_taps
* @see LVNV_ControlParams_st
*/
#define LVNV_NLMS1_HB_TAPS_DEFAULT (24)
/**
* @def LVNV_NLMS1_HB_TAPS_MIN
* MinValue of NLMS1_HB_taps
* @see LVNV_ControlParams_st
*/
#define LVNV_NLMS1_HB_TAPS_MIN (16)
/**
* @def LVNV_NLMS1_HB_TAPS_MAX
* MaxValue of NLMS1_HB_taps
* @see LVNV_ControlParams_st
*/
#define LVNV_NLMS1_HB_TAPS_MAX (32)

/**
* @def LVNV_NLMS1_HB_TWOALPHA_DEFAULT
* Default of NLMS1_HB_twoalpha
* @see LVNV_ControlParams_st
*/
#define LVNV_NLMS1_HB_TWOALPHA_DEFAULT (8192)
/**
* @def LVNV_NLMS1_HB_TWOALPHA_MIN
* MinValue of NLMS1_HB_twoalpha
* @see LVNV_ControlParams_st
*/
#define LVNV_NLMS1_HB_TWOALPHA_MIN (0)
/**
* @def LVNV_NLMS1_HB_TWOALPHA_MAX
* MaxValue of NLMS1_HB_twoalpha
* @see LVNV_ControlParams_st
*/
#define LVNV_NLMS1_HB_TWOALPHA_MAX (32767)

/**
* @def LVNV_NLMS1_HB_ERL_DEFAULT
* Default of NLMS1_HB_erl
* @see LVNV_ControlParams_st
*/
#define LVNV_NLMS1_HB_ERL_DEFAULT (1000)
/**
* @def LVNV_NLMS1_HB_ERL_MIN
* MinValue of NLMS1_HB_erl
* @see LVNV_ControlParams_st
*/
#define LVNV_NLMS1_HB_ERL_MIN (64)
/**
* @def LVNV_NLMS1_HB_ERL_MAX
* MaxValue of NLMS1_HB_erl
* @see LVNV_ControlParams_st
*/
#define LVNV_NLMS1_HB_ERL_MAX (32767)

/**
* @def LVNV_NLMS1_PRESET_COEFS_DEFAULT
* Default of NLMS1_preset_coefs
* @see LVNV_ControlParams_st
*/
#define LVNV_NLMS1_PRESET_COEFS_DEFAULT (0)
/**
* @def LVNV_NLMS1_PRESET_COEFS_MIN
* MinValue of NLMS1_preset_coefs
* @see LVNV_ControlParams_st
*/
#define LVNV_NLMS1_PRESET_COEFS_MIN (0)
/**
* @def LVNV_NLMS1_PRESET_COEFS_MAX
* MaxValue of NLMS1_preset_coefs
* @see LVNV_ControlParams_st
*/
#define LVNV_NLMS1_PRESET_COEFS_MAX (2)

/**
* @def LVNV_NLMS1_OFFSET_DEFAULT
* Default of NLMS1_offset
* @see LVNV_ControlParams_st
*/
#define LVNV_NLMS1_OFFSET_DEFAULT (776)
/**
* @def LVNV_NLMS1_OFFSET_MIN
* MinValue of NLMS1_offset
* @see LVNV_ControlParams_st
*/
#define LVNV_NLMS1_OFFSET_MIN (0)
/**
* @def LVNV_NLMS1_OFFSET_MAX
* MaxValue of NLMS1_offset
* @see LVNV_ControlParams_st
*/
#define LVNV_NLMS1_OFFSET_MAX (32767)

/**
* @def LVNV_CAL_MICPOWFLOORMIN_DEFAULT
* Default of CAL_micPowFloorMin
* @see LVNV_ControlParams_st
*/
#define LVNV_CAL_MICPOWFLOORMIN_DEFAULT (150)
/**
* @def LVNV_CAL_MICPOWFLOORMIN_MIN
* MinValue of CAL_micPowFloorMin
* @see LVNV_ControlParams_st
*/
#define LVNV_CAL_MICPOWFLOORMIN_MIN (0)
/**
* @def LVNV_CAL_MICPOWFLOORMIN_MAX
* MaxValue of CAL_micPowFloorMin
* @see LVNV_ControlParams_st
*/
#define LVNV_CAL_MICPOWFLOORMIN_MAX (32767)

/**
* @def LVNV_WGTHRESHOLD_DEFAULT
* Default of WgThreshold
* @see LVNV_ControlParams_st
*/
#define LVNV_WGTHRESHOLD_DEFAULT (32767)
/**
* @def LVNV_WGTHRESHOLD_MIN
* MinValue of WgThreshold
* @see LVNV_ControlParams_st
*/
#define LVNV_WGTHRESHOLD_MIN (0)
/**
* @def LVNV_WGTHRESHOLD_MAX
* MaxValue of WgThreshold
* @see LVNV_ControlParams_st
*/
#define LVNV_WGTHRESHOLD_MAX (32767)

/**
* @def LVNV_MPTHRESHOLD_DEFAULT
* Default of MpThreshold
* @see LVNV_ControlParams_st
*/
#define LVNV_MPTHRESHOLD_DEFAULT (6554)
/**
* @def LVNV_MPTHRESHOLD_MIN
* MinValue of MpThreshold
* @see LVNV_ControlParams_st
*/
#define LVNV_MPTHRESHOLD_MIN (0)
/**
* @def LVNV_MPTHRESHOLD_MAX
* MaxValue of MpThreshold
* @see LVNV_ControlParams_st
*/
#define LVNV_MPTHRESHOLD_MAX (32767)

/**
* @def LVNV_FSB_INIT_TABLE0_DEFAULT
* Default of FSB_init_table0
* @see LVNV_ControlParams_st
*/
#define LVNV_FSB_INIT_TABLE0_DEFAULT {32767, 0, 0, 0, 0, 0, 0, 0}
/**
* @def LVNV_FSB_INIT_TABLE0_MIN
* MinValue of FSB_init_table0
* @see LVNV_ControlParams_st
*/
#define LVNV_FSB_INIT_TABLE0_MIN (-32768)
/**
* @def LVNV_FSB_INIT_TABLE0_MAX
* MaxValue of FSB_init_table0
* @see LVNV_ControlParams_st
*/
#define LVNV_FSB_INIT_TABLE0_MAX (32767)
/**
* @def LVNV_FSB_INIT_TABLE0_LENGTH
* Length of FSB_init_table0
* @see LVNV_ControlParams_st
*/
#define LVNV_FSB_INIT_TABLE0_LENGTH (8)

/**
* @def LVNV_FSB_INIT_TABLE1_DEFAULT
* Default of FSB_init_table1
* @see LVNV_ControlParams_st
*/
#define LVNV_FSB_INIT_TABLE1_DEFAULT {0, 0, 0, 0, 0, 0, 0, 0}
/**
* @def LVNV_FSB_INIT_TABLE1_MIN
* MinValue of FSB_init_table1
* @see LVNV_ControlParams_st
*/
#define LVNV_FSB_INIT_TABLE1_MIN (-32768)
/**
* @def LVNV_FSB_INIT_TABLE1_MAX
* MaxValue of FSB_init_table1
* @see LVNV_ControlParams_st
*/
#define LVNV_FSB_INIT_TABLE1_MAX (32767)
/**
* @def LVNV_FSB_INIT_TABLE1_LENGTH
* Length of FSB_init_table1
* @see LVNV_ControlParams_st
*/
#define LVNV_FSB_INIT_TABLE1_LENGTH (8)

/**
* @def LVNV_FSB_TAPS_DEFAULT
* Default of FSB_taps
* @see LVNV_ControlParams_st
*/
#define LVNV_FSB_TAPS_DEFAULT (16)
/**
* @def LVNV_FSB_TAPS_MIN
* MinValue of FSB_taps
* @see LVNV_ControlParams_st
*/
#define LVNV_FSB_TAPS_MIN (8)
/**
* @def LVNV_FSB_TAPS_MAX
* MaxValue of FSB_taps
* @see LVNV_ControlParams_st
*/
#define LVNV_FSB_TAPS_MAX (16)

/**
* @def LVNV_FSB_TWOALPHA_DEFAULT
* Default of FSB_twoalpha
* @see LVNV_ControlParams_st
*/
#define LVNV_FSB_TWOALPHA_DEFAULT (655)
/**
* @def LVNV_FSB_TWOALPHA_MIN
* MinValue of FSB_twoalpha
* @see LVNV_ControlParams_st
*/
#define LVNV_FSB_TWOALPHA_MIN (0)
/**
* @def LVNV_FSB_TWOALPHA_MAX
* MaxValue of FSB_twoalpha
* @see LVNV_ControlParams_st
*/
#define LVNV_FSB_TWOALPHA_MAX (32767)

/**
* @def LVNV_FSB_REF_GAIN_DEFAULT
* Default of FSB_ref_gain
* @see LVNV_ControlParams_st
*/
#define LVNV_FSB_REF_GAIN_DEFAULT (1024)
/**
* @def LVNV_FSB_REF_GAIN_MIN
* MinValue of FSB_ref_gain
* @see LVNV_ControlParams_st
*/
#define LVNV_FSB_REF_GAIN_MIN (0)
/**
* @def LVNV_FSB_REF_GAIN_MAX
* MaxValue of FSB_ref_gain
* @see LVNV_ControlParams_st
*/
#define LVNV_FSB_REF_GAIN_MAX (32767)

/**
* @def LVNV_GSC_TAPS_DEFAULT
* Default of GSC_taps
* @see LVNV_ControlParams_st
*/
#define LVNV_GSC_TAPS_DEFAULT (16)
/**
* @def LVNV_GSC_TAPS_MIN
* MinValue of GSC_taps
* @see LVNV_ControlParams_st
*/
#define LVNV_GSC_TAPS_MIN (8)
/**
* @def LVNV_GSC_TAPS_MAX
* MaxValue of GSC_taps
* @see LVNV_ControlParams_st
*/
#define LVNV_GSC_TAPS_MAX (48)

/**
* @def LVNV_GSC_TWOALPHA_DEFAULT
* Default of GSC_twoalpha
* @see LVNV_ControlParams_st
*/
#define LVNV_GSC_TWOALPHA_DEFAULT (1638)
/**
* @def LVNV_GSC_TWOALPHA_MIN
* MinValue of GSC_twoalpha
* @see LVNV_ControlParams_st
*/
#define LVNV_GSC_TWOALPHA_MIN (0)
/**
* @def LVNV_GSC_TWOALPHA_MAX
* MaxValue of GSC_twoalpha
* @see LVNV_ControlParams_st
*/
#define LVNV_GSC_TWOALPHA_MAX (32767)

/**
* @def LVNV_GSC_ERL_DEFAULT
* Default of GSC_erl
* @see LVNV_ControlParams_st
*/
#define LVNV_GSC_ERL_DEFAULT (256)
/**
* @def LVNV_GSC_ERL_MIN
* MinValue of GSC_erl
* @see LVNV_ControlParams_st
*/
#define LVNV_GSC_ERL_MIN (64)
/**
* @def LVNV_GSC_ERL_MAX
* MaxValue of GSC_erl
* @see LVNV_ControlParams_st
*/
#define LVNV_GSC_ERL_MAX (32767)

/**
* @def LVNV_GSC_OFFSET_DEFAULT
* Default of GSC_offset
* @see LVNV_ControlParams_st
*/
#define LVNV_GSC_OFFSET_DEFAULT (1638)
/**
* @def LVNV_GSC_OFFSET_MIN
* MinValue of GSC_offset
* @see LVNV_ControlParams_st
*/
#define LVNV_GSC_OFFSET_MIN (0)
/**
* @def LVNV_GSC_OFFSET_MAX
* MaxValue of GSC_offset
* @see LVNV_ControlParams_st
*/
#define LVNV_GSC_OFFSET_MAX (32767)

/**
* @def LVNV_DNNS_ECHOGAMMAHI_DEFAULT
* Default of DNNS_EchoGammaHi
* @see LVNV_ControlParams_st
*/
#define LVNV_DNNS_ECHOGAMMAHI_DEFAULT (16384)
/**
* @def LVNV_DNNS_ECHOGAMMAHI_MIN
* MinValue of DNNS_EchoGammaHi
* @see LVNV_ControlParams_st
*/
#define LVNV_DNNS_ECHOGAMMAHI_MIN (0)
/**
* @def LVNV_DNNS_ECHOGAMMAHI_MAX
* MaxValue of DNNS_EchoGammaHi
* @see LVNV_ControlParams_st
*/
#define LVNV_DNNS_ECHOGAMMAHI_MAX (32767)

/**
* @def LVNV_DNNS_ECHOGAMMALO_DEFAULT
* Default of DNNS_EchoGammaLo
* @see LVNV_ControlParams_st
*/
#define LVNV_DNNS_ECHOGAMMALO_DEFAULT (8192)
/**
* @def LVNV_DNNS_ECHOGAMMALO_MIN
* MinValue of DNNS_EchoGammaLo
* @see LVNV_ControlParams_st
*/
#define LVNV_DNNS_ECHOGAMMALO_MIN (0)
/**
* @def LVNV_DNNS_ECHOGAMMALO_MAX
* MaxValue of DNNS_EchoGammaLo
* @see LVNV_ControlParams_st
*/
#define LVNV_DNNS_ECHOGAMMALO_MAX (32767)

/**
* @def LVNV_DNNS_ECHOALPHAREV_DEFAULT
* Default of DNNS_EchoAlphaRev
* @see LVNV_ControlParams_st
*/
#define LVNV_DNNS_ECHOALPHAREV_DEFAULT (12000)
/**
* @def LVNV_DNNS_ECHOALPHAREV_MIN
* MinValue of DNNS_EchoAlphaRev
* @see LVNV_ControlParams_st
*/
#define LVNV_DNNS_ECHOALPHAREV_MIN (0)
/**
* @def LVNV_DNNS_ECHOALPHAREV_MAX
* MaxValue of DNNS_EchoAlphaRev
* @see LVNV_ControlParams_st
*/
#define LVNV_DNNS_ECHOALPHAREV_MAX (32767)

/**
* @def LVNV_DNNS_ECHOTAILPORTION_DEFAULT
* Default of DNNS_EchoTailPortion
* @see LVNV_ControlParams_st
*/
#define LVNV_DNNS_ECHOTAILPORTION_DEFAULT (7000)
/**
* @def LVNV_DNNS_ECHOTAILPORTION_MIN
* MinValue of DNNS_EchoTailPortion
* @see LVNV_ControlParams_st
*/
#define LVNV_DNNS_ECHOTAILPORTION_MIN (0)
/**
* @def LVNV_DNNS_ECHOTAILPORTION_MAX
* MaxValue of DNNS_EchoTailPortion
* @see LVNV_ControlParams_st
*/
#define LVNV_DNNS_ECHOTAILPORTION_MAX (32767)

/**
* @def LVNV_DNNS_NLATTEN_DEFAULT
* Default of DNNS_NlAtten
* @see LVNV_ControlParams_st
*/
#define LVNV_DNNS_NLATTEN_DEFAULT (256)
/**
* @def LVNV_DNNS_NLATTEN_MIN
* MinValue of DNNS_NlAtten
* @see LVNV_ControlParams_st
*/
#define LVNV_DNNS_NLATTEN_MIN (0)
/**
* @def LVNV_DNNS_NLATTEN_MAX
* MaxValue of DNNS_NlAtten
* @see LVNV_ControlParams_st
*/
#define LVNV_DNNS_NLATTEN_MAX (2048)

/**
* @def LVNV_DNNS_NOISEGAMMAS_DEFAULT
* Default of DNNS_NoiseGammaS
* @see LVNV_ControlParams_st
*/
#define LVNV_DNNS_NOISEGAMMAS_DEFAULT (11470)
/**
* @def LVNV_DNNS_NOISEGAMMAS_MIN
* MinValue of DNNS_NoiseGammaS
* @see LVNV_ControlParams_st
*/
#define LVNV_DNNS_NOISEGAMMAS_MIN (0)
/**
* @def LVNV_DNNS_NOISEGAMMAS_MAX
* MaxValue of DNNS_NoiseGammaS
* @see LVNV_ControlParams_st
*/
#define LVNV_DNNS_NOISEGAMMAS_MAX (32767)

/**
* @def LVNV_DNNS_NOISEGAMMAN_DEFAULT
* Default of DNNS_NoiseGammaN
* @see LVNV_ControlParams_st
*/
#define LVNV_DNNS_NOISEGAMMAN_DEFAULT (16384)
/**
* @def LVNV_DNNS_NOISEGAMMAN_MIN
* MinValue of DNNS_NoiseGammaN
* @see LVNV_ControlParams_st
*/
#define LVNV_DNNS_NOISEGAMMAN_MIN (0)
/**
* @def LVNV_DNNS_NOISEGAMMAN_MAX
* MaxValue of DNNS_NoiseGammaN
* @see LVNV_ControlParams_st
*/
#define LVNV_DNNS_NOISEGAMMAN_MAX (32767)

/**
* @def LVNV_DNNS_NOISEGAINMINS_DEFAULT
* Default of DNNS_NoiseGainMinS
* @see LVNV_ControlParams_st
*/
#define LVNV_DNNS_NOISEGAINMINS_DEFAULT (11140)
/**
* @def LVNV_DNNS_NOISEGAINMINS_MIN
* MinValue of DNNS_NoiseGainMinS
* @see LVNV_ControlParams_st
*/
#define LVNV_DNNS_NOISEGAINMINS_MIN (0)
/**
* @def LVNV_DNNS_NOISEGAINMINS_MAX
* MaxValue of DNNS_NoiseGainMinS
* @see LVNV_ControlParams_st
*/
#define LVNV_DNNS_NOISEGAINMINS_MAX (32767)

/**
* @def LVNV_DNNS_NOISEGAINMINN_DEFAULT
* Default of DNNS_NoiseGainMinN
* @see LVNV_ControlParams_st
*/
#define LVNV_DNNS_NOISEGAINMINN_DEFAULT (6554)
/**
* @def LVNV_DNNS_NOISEGAINMINN_MIN
* MinValue of DNNS_NoiseGainMinN
* @see LVNV_ControlParams_st
*/
#define LVNV_DNNS_NOISEGAINMINN_MIN (0)
/**
* @def LVNV_DNNS_NOISEGAINMINN_MAX
* MaxValue of DNNS_NoiseGainMinN
* @see LVNV_ControlParams_st
*/
#define LVNV_DNNS_NOISEGAINMINN_MAX (32767)

/**
* @def LVNV_DNNS_NOISEBIASCOMP_DEFAULT
* Default of DNNS_NoiseBiasComp
* @see LVNV_ControlParams_st
*/
#define LVNV_DNNS_NOISEBIASCOMP_DEFAULT (9830)
/**
* @def LVNV_DNNS_NOISEBIASCOMP_MIN
* MinValue of DNNS_NoiseBiasComp
* @see LVNV_ControlParams_st
*/
#define LVNV_DNNS_NOISEBIASCOMP_MIN (0)
/**
* @def LVNV_DNNS_NOISEBIASCOMP_MAX
* MaxValue of DNNS_NoiseBiasComp
* @see LVNV_ControlParams_st
*/
#define LVNV_DNNS_NOISEBIASCOMP_MAX (32767)

/**
* @def LVNV_DNNS_GAINETA_DEFAULT
* Default of DNNS_GainEta
* @see LVNV_ControlParams_st
*/
#define LVNV_DNNS_GAINETA_DEFAULT (256)
/**
* @def LVNV_DNNS_GAINETA_MIN
* MinValue of DNNS_GainEta
* @see LVNV_ControlParams_st
*/
#define LVNV_DNNS_GAINETA_MIN (0)
/**
* @def LVNV_DNNS_GAINETA_MAX
* MaxValue of DNNS_GainEta
* @see LVNV_ControlParams_st
*/
#define LVNV_DNNS_GAINETA_MAX (32767)

/**
* @def LVNV_DNNS_ACTHRESHOLD_DEFAULT
* Default of DNNS_AcThreshold
* @see LVNV_ControlParams_st
*/
#define LVNV_DNNS_ACTHRESHOLD_DEFAULT (12288)
/**
* @def LVNV_DNNS_ACTHRESHOLD_MIN
* MinValue of DNNS_AcThreshold
* @see LVNV_ControlParams_st
*/
#define LVNV_DNNS_ACTHRESHOLD_MIN (0)
/**
* @def LVNV_DNNS_ACTHRESHOLD_MAX
* MaxValue of DNNS_AcThreshold
* @see LVNV_ControlParams_st
*/
#define LVNV_DNNS_ACTHRESHOLD_MAX (32767)

/**
* @def LVNV_DNNS_WBTHRESHOLD_DEFAULT
* Default of DNNS_WbThreshold
* @see LVNV_ControlParams_st
*/
#define LVNV_DNNS_WBTHRESHOLD_DEFAULT (9216)
/**
* @def LVNV_DNNS_WBTHRESHOLD_MIN
* MinValue of DNNS_WbThreshold
* @see LVNV_ControlParams_st
*/
#define LVNV_DNNS_WBTHRESHOLD_MIN (0)
/**
* @def LVNV_DNNS_WBTHRESHOLD_MAX
* MaxValue of DNNS_WbThreshold
* @see LVNV_ControlParams_st
*/
#define LVNV_DNNS_WBTHRESHOLD_MAX (32767)

/**
* @def LVNV_DNNS_LOSTBEAMTHRESHOLD_DEFAULT
* Default of DNNS_LostBeamThreshold
* @see LVNV_ControlParams_st
*/
#define LVNV_DNNS_LOSTBEAMTHRESHOLD_DEFAULT (320)
/**
* @def LVNV_DNNS_LOSTBEAMTHRESHOLD_MIN
* MinValue of DNNS_LostBeamThreshold
* @see LVNV_ControlParams_st
*/
#define LVNV_DNNS_LOSTBEAMTHRESHOLD_MIN (0)
/**
* @def LVNV_DNNS_LOSTBEAMTHRESHOLD_MAX
* MaxValue of DNNS_LostBeamThreshold
* @see LVNV_ControlParams_st
*/
#define LVNV_DNNS_LOSTBEAMTHRESHOLD_MAX (32767)

/**
* @def LVNV_PCD_BETA_DEFAULT
* Default of PCD_beta
* @see LVNV_ControlParams_st
*/
#define LVNV_PCD_BETA_DEFAULT (230)
/**
* @def LVNV_PCD_BETA_MIN
* MinValue of PCD_beta
* @see LVNV_ControlParams_st
*/
#define LVNV_PCD_BETA_MIN (0)
/**
* @def LVNV_PCD_BETA_MAX
* MaxValue of PCD_beta
* @see LVNV_ControlParams_st
*/
#define LVNV_PCD_BETA_MAX (32767)

/**
* @def LVNV_PCD_THRESHOLD_DEFAULT
* Default of PCD_Threshold
* @see LVNV_ControlParams_st
*/
#define LVNV_PCD_THRESHOLD_DEFAULT (26213)
/**
* @def LVNV_PCD_THRESHOLD_MIN
* MinValue of PCD_Threshold
* @see LVNV_ControlParams_st
*/
#define LVNV_PCD_THRESHOLD_MIN (0)
/**
* @def LVNV_PCD_THRESHOLD_MAX
* MaxValue of PCD_Threshold
* @see LVNV_ControlParams_st
*/
#define LVNV_PCD_THRESHOLD_MAX (32767)

/**
* @def LVHF_OPERATINGMODE_DEFAULT
* Default of OperatingMode
* @see LVHF_ControlParams_st
*/
#define LVHF_OPERATINGMODE_DEFAULT (LVM_MODE_OFF)

/**
* @def LVHF_MODE_DEFAULT
* Default of Mode
* @see LVHF_ControlParams_st
*/
#define LVHF_MODE_DEFAULT (4607)

/**
* @def LVHF_TUNINGMODE_DEFAULT
* Default of TuningMode
* @see LVHF_ControlParams_st
*/
#define LVHF_TUNINGMODE_DEFAULT (0)

/**
* @def LVHF_INPUTGAIN_DEFAULT
* Default of InputGain
* @see LVHF_ControlParams_st
*/
#define LVHF_INPUTGAIN_DEFAULT (8192)
/**
* @def LVHF_INPUTGAIN_MIN
* MinValue of InputGain
* @see LVHF_ControlParams_st
*/
#define LVHF_INPUTGAIN_MIN (0)
/**
* @def LVHF_INPUTGAIN_MAX
* MaxValue of InputGain
* @see LVHF_ControlParams_st
*/
#define LVHF_INPUTGAIN_MAX (32767)

/**
* @def LVHF_OUTPUTGAIN_DEFAULT
* Default of OutputGain
* @see LVHF_ControlParams_st
*/
#define LVHF_OUTPUTGAIN_DEFAULT (2048)
/**
* @def LVHF_OUTPUTGAIN_MIN
* MinValue of OutputGain
* @see LVHF_ControlParams_st
*/
#define LVHF_OUTPUTGAIN_MIN (0)
/**
* @def LVHF_OUTPUTGAIN_MAX
* MaxValue of OutputGain
* @see LVHF_ControlParams_st
*/
#define LVHF_OUTPUTGAIN_MAX (32767)

/**
* @def LVHF_NLMS_LIMIT_DEFAULT
* Default of NLMS_limit
* @see LVHF_ControlParams_st
*/
#define LVHF_NLMS_LIMIT_DEFAULT (0)
/**
* @def LVHF_NLMS_LIMIT_MIN
* MinValue of NLMS_limit
* @see LVHF_ControlParams_st
*/
#define LVHF_NLMS_LIMIT_MIN (-24)
/**
* @def LVHF_NLMS_LIMIT_MAX
* MaxValue of NLMS_limit
* @see LVHF_ControlParams_st
*/
#define LVHF_NLMS_LIMIT_MAX (0)

/**
* @def LVHF_NLMS_LB_TAPS_DEFAULT
* Default of NLMS_LB_taps
* @see LVHF_ControlParams_st
*/
#define LVHF_NLMS_LB_TAPS_DEFAULT (64)
/**
* @def LVHF_NLMS_LB_TAPS_MIN
* MinValue of NLMS_LB_taps
* @see LVHF_ControlParams_st
*/
#define LVHF_NLMS_LB_TAPS_MIN (16)
/**
* @def LVHF_NLMS_LB_TAPS_MAX
* MaxValue of NLMS_LB_taps
* @see LVHF_ControlParams_st
*/
#define LVHF_NLMS_LB_TAPS_MAX (200)

/**
* @def LVHF_NLMS_LB_TWO_ALPHA_DEFAULT
* Default of NLMS_LB_two_alpha
* @see LVHF_ControlParams_st
*/
#define LVHF_NLMS_LB_TWO_ALPHA_DEFAULT (8192)
/**
* @def LVHF_NLMS_LB_TWO_ALPHA_MIN
* MinValue of NLMS_LB_two_alpha
* @see LVHF_ControlParams_st
*/
#define LVHF_NLMS_LB_TWO_ALPHA_MIN (0)
/**
* @def LVHF_NLMS_LB_TWO_ALPHA_MAX
* MaxValue of NLMS_LB_two_alpha
* @see LVHF_ControlParams_st
*/
#define LVHF_NLMS_LB_TWO_ALPHA_MAX (32767)

/**
* @def LVHF_NLMS_LB_ERL_DEFAULT
* Default of NLMS_LB_erl
* @see LVHF_ControlParams_st
*/
#define LVHF_NLMS_LB_ERL_DEFAULT (128)
/**
* @def LVHF_NLMS_LB_ERL_MIN
* MinValue of NLMS_LB_erl
* @see LVHF_ControlParams_st
*/
#define LVHF_NLMS_LB_ERL_MIN (64)
/**
* @def LVHF_NLMS_LB_ERL_MAX
* MaxValue of NLMS_LB_erl
* @see LVHF_ControlParams_st
*/
#define LVHF_NLMS_LB_ERL_MAX (32767)

/**
* @def LVHF_NLMS_HB_TAPS_DEFAULT
* Default of NLMS_HB_taps
* @see LVHF_ControlParams_st
*/
#define LVHF_NLMS_HB_TAPS_DEFAULT (64)
/**
* @def LVHF_NLMS_HB_TAPS_MIN
* MinValue of NLMS_HB_taps
* @see LVHF_ControlParams_st
*/
#define LVHF_NLMS_HB_TAPS_MIN (16)
/**
* @def LVHF_NLMS_HB_TAPS_MAX
* MaxValue of NLMS_HB_taps
* @see LVHF_ControlParams_st
*/
#define LVHF_NLMS_HB_TAPS_MAX (136)

/**
* @def LVHF_NLMS_HB_TWO_ALPHA_DEFAULT
* Default of NLMS_HB_two_alpha
* @see LVHF_ControlParams_st
*/
#define LVHF_NLMS_HB_TWO_ALPHA_DEFAULT (8192)
/**
* @def LVHF_NLMS_HB_TWO_ALPHA_MIN
* MinValue of NLMS_HB_two_alpha
* @see LVHF_ControlParams_st
*/
#define LVHF_NLMS_HB_TWO_ALPHA_MIN (0)
/**
* @def LVHF_NLMS_HB_TWO_ALPHA_MAX
* MaxValue of NLMS_HB_two_alpha
* @see LVHF_ControlParams_st
*/
#define LVHF_NLMS_HB_TWO_ALPHA_MAX (32767)

/**
* @def LVHF_NLMS_HB_ERL_DEFAULT
* Default of NLMS_HB_erl
* @see LVHF_ControlParams_st
*/
#define LVHF_NLMS_HB_ERL_DEFAULT (128)
/**
* @def LVHF_NLMS_HB_ERL_MIN
* MinValue of NLMS_HB_erl
* @see LVHF_ControlParams_st
*/
#define LVHF_NLMS_HB_ERL_MIN (64)
/**
* @def LVHF_NLMS_HB_ERL_MAX
* MaxValue of NLMS_HB_erl
* @see LVHF_ControlParams_st
*/
#define LVHF_NLMS_HB_ERL_MAX (32767)

/**
* @def LVHF_NLMS_PRESET_COEFS_DEFAULT
* Default of NLMS_preset_coefs
* @see LVHF_ControlParams_st
*/
#define LVHF_NLMS_PRESET_COEFS_DEFAULT (1)
/**
* @def LVHF_NLMS_PRESET_COEFS_MIN
* MinValue of NLMS_preset_coefs
* @see LVHF_ControlParams_st
*/
#define LVHF_NLMS_PRESET_COEFS_MIN (0)
/**
* @def LVHF_NLMS_PRESET_COEFS_MAX
* MaxValue of NLMS_preset_coefs
* @see LVHF_ControlParams_st
*/
#define LVHF_NLMS_PRESET_COEFS_MAX (2)

/**
* @def LVHF_NLMS_OFFSET_DEFAULT
* Default of NLMS_offset
* @see LVHF_ControlParams_st
*/
#define LVHF_NLMS_OFFSET_DEFAULT (767)
/**
* @def LVHF_NLMS_OFFSET_MIN
* MinValue of NLMS_offset
* @see LVHF_ControlParams_st
*/
#define LVHF_NLMS_OFFSET_MIN (0)
/**
* @def LVHF_NLMS_OFFSET_MAX
* MaxValue of NLMS_offset
* @see LVHF_ControlParams_st
*/
#define LVHF_NLMS_OFFSET_MAX (32767)

/**
* @def LVHF_DENS_TAIL_ALPHA_LB_DEFAULT
* Default of DENS_tail_alpha_LB
* @see LVHF_ControlParams_st
*/
#define LVHF_DENS_TAIL_ALPHA_LB_DEFAULT (25395)
/**
* @def LVHF_DENS_TAIL_ALPHA_LB_MIN
* MinValue of DENS_tail_alpha_LB
* @see LVHF_ControlParams_st
*/
#define LVHF_DENS_TAIL_ALPHA_LB_MIN (0)
/**
* @def LVHF_DENS_TAIL_ALPHA_LB_MAX
* MaxValue of DENS_tail_alpha_LB
* @see LVHF_ControlParams_st
*/
#define LVHF_DENS_TAIL_ALPHA_LB_MAX (32767)

/**
* @def LVHF_DENS_TAIL_PORTION_LB_DEFAULT
* Default of DENS_tail_portion_LB
* @see LVHF_ControlParams_st
*/
#define LVHF_DENS_TAIL_PORTION_LB_DEFAULT (29491)
/**
* @def LVHF_DENS_TAIL_PORTION_LB_MIN
* MinValue of DENS_tail_portion_LB
* @see LVHF_ControlParams_st
*/
#define LVHF_DENS_TAIL_PORTION_LB_MIN (0)
/**
* @def LVHF_DENS_TAIL_PORTION_LB_MAX
* MaxValue of DENS_tail_portion_LB
* @see LVHF_ControlParams_st
*/
#define LVHF_DENS_TAIL_PORTION_LB_MAX (32767)

/**
* @def LVHF_DENS_GAMMA_E_HIGH_LB_DEFAULT
* Default of DENS_gamma_e_high_LB
* @see LVHF_ControlParams_st
*/
#define LVHF_DENS_GAMMA_E_HIGH_LB_DEFAULT (512)
/**
* @def LVHF_DENS_GAMMA_E_HIGH_LB_MIN
* MinValue of DENS_gamma_e_high_LB
* @see LVHF_ControlParams_st
*/
#define LVHF_DENS_GAMMA_E_HIGH_LB_MIN (0)
/**
* @def LVHF_DENS_GAMMA_E_HIGH_LB_MAX
* MaxValue of DENS_gamma_e_high_LB
* @see LVHF_ControlParams_st
*/
#define LVHF_DENS_GAMMA_E_HIGH_LB_MAX (32767)

/**
* @def LVHF_DENS_GAMMA_E_DT_LB_DEFAULT
* Default of DENS_gamma_e_dt_LB
* @see LVHF_ControlParams_st
*/
#define LVHF_DENS_GAMMA_E_DT_LB_DEFAULT (256)
/**
* @def LVHF_DENS_GAMMA_E_DT_LB_MIN
* MinValue of DENS_gamma_e_dt_LB
* @see LVHF_ControlParams_st
*/
#define LVHF_DENS_GAMMA_E_DT_LB_MIN (0)
/**
* @def LVHF_DENS_GAMMA_E_DT_LB_MAX
* MaxValue of DENS_gamma_e_dt_LB
* @see LVHF_ControlParams_st
*/
#define LVHF_DENS_GAMMA_E_DT_LB_MAX (32767)

/**
* @def LVHF_DENS_GAMMA_E_LOW_LB_DEFAULT
* Default of DENS_gamma_e_low_LB
* @see LVHF_ControlParams_st
*/
#define LVHF_DENS_GAMMA_E_LOW_LB_DEFAULT (256)
/**
* @def LVHF_DENS_GAMMA_E_LOW_LB_MIN
* MinValue of DENS_gamma_e_low_LB
* @see LVHF_ControlParams_st
*/
#define LVHF_DENS_GAMMA_E_LOW_LB_MIN (0)
/**
* @def LVHF_DENS_GAMMA_E_LOW_LB_MAX
* MaxValue of DENS_gamma_e_low_LB
* @see LVHF_ControlParams_st
*/
#define LVHF_DENS_GAMMA_E_LOW_LB_MAX (32767)

/**
* @def LVHF_DENS_NL_ATTEN_LB_DEFAULT
* Default of DENS_NL_atten_LB
* @see LVHF_ControlParams_st
*/
#define LVHF_DENS_NL_ATTEN_LB_DEFAULT (0)
/**
* @def LVHF_DENS_NL_ATTEN_LB_MIN
* MinValue of DENS_NL_atten_LB
* @see LVHF_ControlParams_st
*/
#define LVHF_DENS_NL_ATTEN_LB_MIN (0)
/**
* @def LVHF_DENS_NL_ATTEN_LB_MAX
* MaxValue of DENS_NL_atten_LB
* @see LVHF_ControlParams_st
*/
#define LVHF_DENS_NL_ATTEN_LB_MAX (2048)

/**
* @def LVHF_DENS_TAIL_ALPHA_HB_DEFAULT
* Default of DENS_tail_alpha_HB
* @see LVHF_ControlParams_st
*/
#define LVHF_DENS_TAIL_ALPHA_HB_DEFAULT (25395)
/**
* @def LVHF_DENS_TAIL_ALPHA_HB_MIN
* MinValue of DENS_tail_alpha_HB
* @see LVHF_ControlParams_st
*/
#define LVHF_DENS_TAIL_ALPHA_HB_MIN (0)
/**
* @def LVHF_DENS_TAIL_ALPHA_HB_MAX
* MaxValue of DENS_tail_alpha_HB
* @see LVHF_ControlParams_st
*/
#define LVHF_DENS_TAIL_ALPHA_HB_MAX (32767)

/**
* @def LVHF_DENS_TAIL_PORTION_HB_DEFAULT
* Default of DENS_tail_portion_HB
* @see LVHF_ControlParams_st
*/
#define LVHF_DENS_TAIL_PORTION_HB_DEFAULT (29491)
/**
* @def LVHF_DENS_TAIL_PORTION_HB_MIN
* MinValue of DENS_tail_portion_HB
* @see LVHF_ControlParams_st
*/
#define LVHF_DENS_TAIL_PORTION_HB_MIN (0)
/**
* @def LVHF_DENS_TAIL_PORTION_HB_MAX
* MaxValue of DENS_tail_portion_HB
* @see LVHF_ControlParams_st
*/
#define LVHF_DENS_TAIL_PORTION_HB_MAX (32767)

/**
* @def LVHF_DENS_GAMMA_E_HIGH_HB_DEFAULT
* Default of DENS_gamma_e_high_HB
* @see LVHF_ControlParams_st
*/
#define LVHF_DENS_GAMMA_E_HIGH_HB_DEFAULT (512)
/**
* @def LVHF_DENS_GAMMA_E_HIGH_HB_MIN
* MinValue of DENS_gamma_e_high_HB
* @see LVHF_ControlParams_st
*/
#define LVHF_DENS_GAMMA_E_HIGH_HB_MIN (0)
/**
* @def LVHF_DENS_GAMMA_E_HIGH_HB_MAX
* MaxValue of DENS_gamma_e_high_HB
* @see LVHF_ControlParams_st
*/
#define LVHF_DENS_GAMMA_E_HIGH_HB_MAX (32767)

/**
* @def LVHF_DENS_GAMMA_E_DT_HB_DEFAULT
* Default of DENS_gamma_e_dt_HB
* @see LVHF_ControlParams_st
*/
#define LVHF_DENS_GAMMA_E_DT_HB_DEFAULT (256)
/**
* @def LVHF_DENS_GAMMA_E_DT_HB_MIN
* MinValue of DENS_gamma_e_dt_HB
* @see LVHF_ControlParams_st
*/
#define LVHF_DENS_GAMMA_E_DT_HB_MIN (0)
/**
* @def LVHF_DENS_GAMMA_E_DT_HB_MAX
* MaxValue of DENS_gamma_e_dt_HB
* @see LVHF_ControlParams_st
*/
#define LVHF_DENS_GAMMA_E_DT_HB_MAX (32767)

/**
* @def LVHF_DENS_GAMMA_E_LOW_HB_DEFAULT
* Default of DENS_gamma_e_low_HB
* @see LVHF_ControlParams_st
*/
#define LVHF_DENS_GAMMA_E_LOW_HB_DEFAULT (256)
/**
* @def LVHF_DENS_GAMMA_E_LOW_HB_MIN
* MinValue of DENS_gamma_e_low_HB
* @see LVHF_ControlParams_st
*/
#define LVHF_DENS_GAMMA_E_LOW_HB_MIN (0)
/**
* @def LVHF_DENS_GAMMA_E_LOW_HB_MAX
* MaxValue of DENS_gamma_e_low_HB
* @see LVHF_ControlParams_st
*/
#define LVHF_DENS_GAMMA_E_LOW_HB_MAX (32767)

/**
* @def LVHF_DENS_NL_ATTEN_HB_DEFAULT
* Default of DENS_NL_atten_HB
* @see LVHF_ControlParams_st
*/
#define LVHF_DENS_NL_ATTEN_HB_DEFAULT (0)
/**
* @def LVHF_DENS_NL_ATTEN_HB_MIN
* MinValue of DENS_NL_atten_HB
* @see LVHF_ControlParams_st
*/
#define LVHF_DENS_NL_ATTEN_HB_MIN (0)
/**
* @def LVHF_DENS_NL_ATTEN_HB_MAX
* MaxValue of DENS_NL_atten_HB
* @see LVHF_ControlParams_st
*/
#define LVHF_DENS_NL_ATTEN_HB_MAX (2048)

/**
* @def LVHF_DENS_GAMMA_E_ALPHA_DEFAULT
* Default of DENS_gamma_e_alpha
* @see LVHF_ControlParams_st
*/
#define LVHF_DENS_GAMMA_E_ALPHA_DEFAULT (24000)
/**
* @def LVHF_DENS_GAMMA_E_ALPHA_MIN
* MinValue of DENS_gamma_e_alpha
* @see LVHF_ControlParams_st
*/
#define LVHF_DENS_GAMMA_E_ALPHA_MIN (0)
/**
* @def LVHF_DENS_GAMMA_E_ALPHA_MAX
* MaxValue of DENS_gamma_e_alpha
* @see LVHF_ControlParams_st
*/
#define LVHF_DENS_GAMMA_E_ALPHA_MAX (32767)

/**
* @def LVHF_DENS_GAMMA_N_DEFAULT
* Default of DENS_gamma_n
* @see LVHF_ControlParams_st
*/
#define LVHF_DENS_GAMMA_N_DEFAULT (280)
/**
* @def LVHF_DENS_GAMMA_N_MIN
* MinValue of DENS_gamma_n
* @see LVHF_ControlParams_st
*/
#define LVHF_DENS_GAMMA_N_MIN (0)
/**
* @def LVHF_DENS_GAMMA_N_MAX
* MaxValue of DENS_gamma_n
* @see LVHF_ControlParams_st
*/
#define LVHF_DENS_GAMMA_N_MAX (32767)

/**
* @def LVHF_DENS_SPDET_NEAR_DEFAULT
* Default of DENS_spdet_near
* @see LVHF_ControlParams_st
*/
#define LVHF_DENS_SPDET_NEAR_DEFAULT (512)
/**
* @def LVHF_DENS_SPDET_NEAR_MIN
* MinValue of DENS_spdet_near
* @see LVHF_ControlParams_st
*/
#define LVHF_DENS_SPDET_NEAR_MIN (0)
/**
* @def LVHF_DENS_SPDET_NEAR_MAX
* MaxValue of DENS_spdet_near
* @see LVHF_ControlParams_st
*/
#define LVHF_DENS_SPDET_NEAR_MAX (32767)

/**
* @def LVHF_DENS_SPDET_ACT_DEFAULT
* Default of DENS_spdet_act
* @see LVHF_ControlParams_st
*/
#define LVHF_DENS_SPDET_ACT_DEFAULT (768)
/**
* @def LVHF_DENS_SPDET_ACT_MIN
* MinValue of DENS_spdet_act
* @see LVHF_ControlParams_st
*/
#define LVHF_DENS_SPDET_ACT_MIN (0)
/**
* @def LVHF_DENS_SPDET_ACT_MAX
* MaxValue of DENS_spdet_act
* @see LVHF_ControlParams_st
*/
#define LVHF_DENS_SPDET_ACT_MAX (32767)

/**
* @def LVHF_DENS_LIMIT_NS_DEFAULT
* Default of DENS_limit_ns
* @see LVHF_ControlParams_st
*/
#define LVHF_DENS_LIMIT_NS_DEFAULT (10361)
/**
* @def LVHF_DENS_LIMIT_NS_MIN
* MinValue of DENS_limit_ns
* @see LVHF_ControlParams_st
*/
#define LVHF_DENS_LIMIT_NS_MIN (0)
/**
* @def LVHF_DENS_LIMIT_NS_MAX
* MaxValue of DENS_limit_ns
* @see LVHF_ControlParams_st
*/
#define LVHF_DENS_LIMIT_NS_MAX (32767)

/**
* @def LVHF_DENS_CNI_GAIN_DEFAULT
* Default of DENS_CNI_Gain
* @see LVHF_ControlParams_st
*/
#define LVHF_DENS_CNI_GAIN_DEFAULT (16384)
/**
* @def LVHF_DENS_CNI_GAIN_MIN
* MinValue of DENS_CNI_Gain
* @see LVHF_ControlParams_st
*/
#define LVHF_DENS_CNI_GAIN_MIN (0)
/**
* @def LVHF_DENS_CNI_GAIN_MAX
* MaxValue of DENS_CNI_Gain
* @see LVHF_ControlParams_st
*/
#define LVHF_DENS_CNI_GAIN_MAX (32767)

/**
* @def LVHF_DENS_NFE_BLOCKSIZE_DEFAULT
* Default of DENS_NFE_blocksize
* @see LVHF_ControlParams_st
*/
#define LVHF_DENS_NFE_BLOCKSIZE_DEFAULT (150)
/**
* @def LVHF_DENS_NFE_BLOCKSIZE_MIN
* MinValue of DENS_NFE_blocksize
* @see LVHF_ControlParams_st
*/
#define LVHF_DENS_NFE_BLOCKSIZE_MIN (0)
/**
* @def LVHF_DENS_NFE_BLOCKSIZE_MAX
* MaxValue of DENS_NFE_blocksize
* @see LVHF_ControlParams_st
*/
#define LVHF_DENS_NFE_BLOCKSIZE_MAX (32767)

/**
* @def LVHF_SPDET_FAR_DEFAULT
* Default of SPDET_far
* @see LVHF_ControlParams_st
*/
#define LVHF_SPDET_FAR_DEFAULT (16384)
/**
* @def LVHF_SPDET_FAR_MIN
* MinValue of SPDET_far
* @see LVHF_ControlParams_st
*/
#define LVHF_SPDET_FAR_MIN (0)
/**
* @def LVHF_SPDET_FAR_MAX
* MaxValue of SPDET_far
* @see LVHF_ControlParams_st
*/
#define LVHF_SPDET_FAR_MAX (32767)

/**
* @def LVHF_SPDET_MIC_DEFAULT
* Default of SPDET_mic
* @see LVHF_ControlParams_st
*/
#define LVHF_SPDET_MIC_DEFAULT (16384)
/**
* @def LVHF_SPDET_MIC_MIN
* MinValue of SPDET_mic
* @see LVHF_ControlParams_st
*/
#define LVHF_SPDET_MIC_MIN (0)
/**
* @def LVHF_SPDET_MIC_MAX
* MaxValue of SPDET_mic
* @see LVHF_ControlParams_st
*/
#define LVHF_SPDET_MIC_MAX (32767)

/**
* @def LVHF_SPDET_X_CLIP_DEFAULT
* Default of SPDET_x_clip
* @see LVHF_ControlParams_st
*/
#define LVHF_SPDET_X_CLIP_DEFAULT (0)
/**
* @def LVHF_SPDET_X_CLIP_MIN
* MinValue of SPDET_x_clip
* @see LVHF_ControlParams_st
*/
#define LVHF_SPDET_X_CLIP_MIN (0)
/**
* @def LVHF_SPDET_X_CLIP_MAX
* MaxValue of SPDET_x_clip
* @see LVHF_ControlParams_st
*/
#define LVHF_SPDET_X_CLIP_MAX (32767)

/**
* @def LVHF_PCD_THRESHOLD_DEFAULT
* Default of PCD_threshold
* @see LVHF_ControlParams_st
*/
#define LVHF_PCD_THRESHOLD_DEFAULT (20000)
/**
* @def LVHF_PCD_THRESHOLD_MIN
* MinValue of PCD_threshold
* @see LVHF_ControlParams_st
*/
#define LVHF_PCD_THRESHOLD_MIN (0)
/**
* @def LVHF_PCD_THRESHOLD_MAX
* MaxValue of PCD_threshold
* @see LVHF_ControlParams_st
*/
#define LVHF_PCD_THRESHOLD_MAX (32767)

/**
* @def LVHF_PCD_TAPS_DEFAULT
* Default of PCD_taps
* @see LVHF_ControlParams_st
*/
#define LVHF_PCD_TAPS_DEFAULT (16)
/**
* @def LVHF_PCD_TAPS_MIN
* MinValue of PCD_taps
* @see LVHF_ControlParams_st
*/
#define LVHF_PCD_TAPS_MIN (16)
/**
* @def LVHF_PCD_TAPS_MAX
* MaxValue of PCD_taps
* @see LVHF_ControlParams_st
*/
#define LVHF_PCD_TAPS_MAX (64)

/**
* @def LVHF_PCD_ERL_DEFAULT
* Default of PCD_erl
* @see LVHF_ControlParams_st
*/
#define LVHF_PCD_ERL_DEFAULT (64)
/**
* @def LVHF_PCD_ERL_MIN
* MinValue of PCD_erl
* @see LVHF_ControlParams_st
*/
#define LVHF_PCD_ERL_MIN (64)
/**
* @def LVHF_PCD_ERL_MAX
* MaxValue of PCD_erl
* @see LVHF_ControlParams_st
*/
#define LVHF_PCD_ERL_MAX (32767)

/**
* @def LVHF_PCD_MINIMUM_ERL_DEFAULT
* Default of PCD_minimum_erl
* @see LVHF_ControlParams_st
*/
#define LVHF_PCD_MINIMUM_ERL_DEFAULT (64)
/**
* @def LVHF_PCD_MINIMUM_ERL_MIN
* MinValue of PCD_minimum_erl
* @see LVHF_ControlParams_st
*/
#define LVHF_PCD_MINIMUM_ERL_MIN (64)
/**
* @def LVHF_PCD_MINIMUM_ERL_MAX
* MaxValue of PCD_minimum_erl
* @see LVHF_ControlParams_st
*/
#define LVHF_PCD_MINIMUM_ERL_MAX (32767)

/**
* @def LVHF_PCD_ERL_STEP_DEFAULT
* Default of PCD_erl_step
* @see LVHF_ControlParams_st
*/
#define LVHF_PCD_ERL_STEP_DEFAULT (16800)
/**
* @def LVHF_PCD_ERL_STEP_MIN
* MinValue of PCD_erl_step
* @see LVHF_ControlParams_st
*/
#define LVHF_PCD_ERL_STEP_MIN (16384)
/**
* @def LVHF_PCD_ERL_STEP_MAX
* MaxValue of PCD_erl_step
* @see LVHF_ControlParams_st
*/
#define LVHF_PCD_ERL_STEP_MAX (32767)

/**
* @def LVHF_PCD_GAMMA_E_RESCUE_DEFAULT
* Default of PCD_gamma_e_rescue
* @see LVHF_ControlParams_st
*/
#define LVHF_PCD_GAMMA_E_RESCUE_DEFAULT (5000)
/**
* @def LVHF_PCD_GAMMA_E_RESCUE_MIN
* MinValue of PCD_gamma_e_rescue
* @see LVHF_ControlParams_st
*/
#define LVHF_PCD_GAMMA_E_RESCUE_MIN (0)
/**
* @def LVHF_PCD_GAMMA_E_RESCUE_MAX
* MaxValue of PCD_gamma_e_rescue
* @see LVHF_ControlParams_st
*/
#define LVHF_PCD_GAMMA_E_RESCUE_MAX (32767)

/**
* @def LVBD_BD_OPERATINGMODE_DEFAULT
* Default of BD_OperatingMode
* @see LVBD_ControlParams_st
*/
#define LVBD_BD_OPERATINGMODE_DEFAULT (LVM_MODE_OFF)

/**
* @def LVBD_BULKDELAY_DEFAULT
* Default of BulkDelay
* @see LVBD_ControlParams_st
*/
#define LVBD_BULKDELAY_DEFAULT (0)
/**
* @def LVBD_BULKDELAY_MIN
* MinValue of BulkDelay
* @see LVBD_ControlParams_st
*/
#define LVBD_BULKDELAY_MIN (0)
/**
* @def LVBD_BULKDELAY_MAX
* MaxValue of BulkDelay
* @see LVBD_ControlParams_st
*/
#define LVBD_BULKDELAY_MAX (6400)

/**
* @def LVBD_BD_GAIN_DEFAULT
* Default of BD_Gain
* @see LVBD_ControlParams_st
*/
#define LVBD_BD_GAIN_DEFAULT (8192)
/**
* @def LVBD_BD_GAIN_MIN
* MinValue of BD_Gain
* @see LVBD_ControlParams_st
*/
#define LVBD_BD_GAIN_MIN (0)
/**
* @def LVBD_BD_GAIN_MAX
* MaxValue of BD_Gain
* @see LVBD_ControlParams_st
*/
#define LVBD_BD_GAIN_MAX (32767)

/**
* @def LVVE_TX_OPERATINGMODE_DEFAULT
* Default of OperatingMode
* @see LVVE_Tx_ControlParams_st
*/
#define LVVE_TX_OPERATINGMODE_DEFAULT (LVVE_TX_MODE_OFF)

/**
* @def LVVE_TX_MUTE_DEFAULT
* Default of Mute
* @see LVVE_Tx_ControlParams_st
*/
#define LVVE_TX_MUTE_DEFAULT (LVM_MODE_OFF)

/**
* @def LVVE_TX_BD_OPERATINGMODE_DEFAULT
* Default of BD_OperatingMode
* @see LVVE_Tx_ControlParams_st
*/
#define LVVE_TX_BD_OPERATINGMODE_DEFAULT (LVM_MODE_OFF)

/**
* @def LVVE_TX_BULKDELAY_DEFAULT
* Default of BulkDelay
* @see LVVE_Tx_ControlParams_st
*/
#define LVVE_TX_BULKDELAY_DEFAULT (0)
/**
* @def LVVE_TX_BULKDELAY_MIN
* MinValue of BulkDelay
* @see LVVE_Tx_ControlParams_st
*/
#define LVVE_TX_BULKDELAY_MIN (0)
/**
* @def LVVE_TX_BULKDELAY_MAX
* MaxValue of BulkDelay
* @see LVVE_Tx_ControlParams_st
*/
#define LVVE_TX_BULKDELAY_MAX (6400)

/**
* @def LVVE_TX_BD_GAIN_DEFAULT
* Default of BD_Gain
* @see LVVE_Tx_ControlParams_st
*/
#define LVVE_TX_BD_GAIN_DEFAULT (8192)
/**
* @def LVVE_TX_BD_GAIN_MIN
* MinValue of BD_Gain
* @see LVVE_Tx_ControlParams_st
*/
#define LVVE_TX_BD_GAIN_MIN (0)
/**
* @def LVVE_TX_BD_GAIN_MAX
* MaxValue of BD_Gain
* @see LVVE_Tx_ControlParams_st
*/
#define LVVE_TX_BD_GAIN_MAX (32767)

/**
* @def LVVE_TX_VOL_OPERATINGMODE_DEFAULT
* Default of VOL_OperatingMode
* @see LVVE_Tx_ControlParams_st
*/
#define LVVE_TX_VOL_OPERATINGMODE_DEFAULT (LVM_MODE_OFF)

/**
* @def LVVE_TX_VOL_GAIN_DEFAULT
* Default of VOL_Gain
* @see LVVE_Tx_ControlParams_st
*/
#define LVVE_TX_VOL_GAIN_DEFAULT (0)
/**
* @def LVVE_TX_VOL_GAIN_MIN
* MinValue of VOL_Gain
* @see LVVE_Tx_ControlParams_st
*/
#define LVVE_TX_VOL_GAIN_MIN (-96)
/**
* @def LVVE_TX_VOL_GAIN_MAX
* MaxValue of VOL_Gain
* @see LVVE_Tx_ControlParams_st
*/
#define LVVE_TX_VOL_GAIN_MAX (24)

/**
* @def LVVE_TX_HPF_OPERATINGMODE_DEFAULT
* Default of HPF_OperatingMode
* @see LVVE_Tx_ControlParams_st
*/
#define LVVE_TX_HPF_OPERATINGMODE_DEFAULT (LVM_MODE_OFF)

/**
* @def LVVE_TX_MIC_HPF_CORNERFREQ_DEFAULT
* Default of MIC_HPF_CornerFreq
* @see LVVE_Tx_ControlParams_st
*/
#define LVVE_TX_MIC_HPF_CORNERFREQ_DEFAULT (50)
/**
* @def LVVE_TX_MIC_HPF_CORNERFREQ_MIN
* MinValue of MIC_HPF_CornerFreq
* @see LVVE_Tx_ControlParams_st
*/
#define LVVE_TX_MIC_HPF_CORNERFREQ_MIN (50)
/**
* @def LVVE_TX_MIC_HPF_CORNERFREQ_MAX
* MaxValue of MIC_HPF_CornerFreq
* @see LVVE_Tx_ControlParams_st
*/
#define LVVE_TX_MIC_HPF_CORNERFREQ_MAX (1500)




/**
* @def LVVE_TX_EQ_OPERATINGMODE_DEFAULT
* Default of EQ_OperatingMode
* @see LVVE_Tx_ControlParams_st
*/
#define LVVE_TX_EQ_OPERATINGMODE_DEFAULT (LVM_MODE_OFF)

//adb by xuxinqiang  20150519
#define LVVE_MAX_EQ_LENGTH_NB                32           /* Maximum equaliser length for narrowband configuration */
#define LVVE_MAX_EQ_LENGTH_WB                64           /* Maximum equaliser length for wideband configuration */


/**
* @def LVVC_GAIN_DEFAULT
* Default of Gain
* @see LVVC_ControlParams_st
*/
#define LVVC_GAIN_DEFAULT (0)
/**
* @def LVVC_GAIN_MIN
* MinValue of Gain
* @see LVVC_ControlParams_st
*/
#define LVVC_GAIN_MIN (0)
/**
* @def LVVC_GAIN_MAX
* MaxValue of Gain
* @see LVVC_ControlParams_st
*/
#define LVVC_GAIN_MAX (32767)

/**
* @def LVVC_SPDETECTED_DEFAULT
* Default of SpDetected
* @see LVVC_ControlParams_st
*/
#define LVVC_SPDETECTED_DEFAULT (0)
/**
* @def LVVC_SPDETECTED_MIN
* MinValue of SpDetected
* @see LVVC_ControlParams_st
*/
#define LVVC_SPDETECTED_MIN (0)
/**
* @def LVVC_SPDETECTED_MAX
* MaxValue of SpDetected
* @see LVVC_ControlParams_st
*/
#define LVVC_SPDETECTED_MAX (1)

/**
* @def LVWM_AVL_GAIN_DEFAULT
* Default of AVL_Gain
* @see LVWM_ControlParams_st
*/
#define LVWM_AVL_GAIN_DEFAULT (0)
/**
* @def LVWM_AVL_GAIN_MIN
* MinValue of AVL_Gain
* @see LVWM_ControlParams_st
*/
#define LVWM_AVL_GAIN_MIN (0)
/**
* @def LVWM_AVL_GAIN_MAX
* MaxValue of AVL_Gain
* @see LVWM_ControlParams_st
*/
#define LVWM_AVL_GAIN_MAX (32767)



/**
* @def LVVE_RX_DUMMY_DEFAULT
* Default of dummy
* @see LVVE_Rx_ControlParams_st
*/
#define LVVE_RX_DUMMY_DEFAULT (0)
/**
* @def LVVE_RX_DUMMY_MIN
* MinValue of dummy
* @see LVVE_Rx_ControlParams_st
*/
#define LVVE_RX_DUMMY_MIN (-128)
/**
* @def LVVE_RX_DUMMY_MAX
* MaxValue of dummy
* @see LVVE_Rx_ControlParams_st
*/
#define LVVE_RX_DUMMY_MAX (127)

/**
* @def LVNV_STATUS_DEFAULT
* Default of status
* @see LVNV_ControlParams_st
*/
#define LVNV_STATUS_DEFAULT (0)

/**
* @def LVNV_DUMMY_DEFAULT
* Default of Dummy
* @see LVNV_ControlParams_st
*/
#define LVNV_DUMMY_DEFAULT (0)
/**
* @def LVNV_DUMMY_MIN
* MinValue of Dummy
* @see LVNV_ControlParams_st
*/
#define LVNV_DUMMY_MIN (0)
/**
* @def LVNV_DUMMY_MAX
* MaxValue of Dummy
* @see LVNV_ControlParams_st
*/
#define LVNV_DUMMY_MAX (0)

/**
* @def LVNV_PNLMS0_LB_COEFFS_DEFAULT
* Default of pNLMS0_LB_Coeffs
* @see LVNV_ControlParams_st
*/
#define LVNV_PNLMS0_LB_COEFFS_DEFAULT (0)
/**
* @def LVNV_PNLMS0_LB_COEFFS_MIN
* MinValue of pNLMS0_LB_Coeffs
* @see LVNV_ControlParams_st
*/
#define LVNV_PNLMS0_LB_COEFFS_MIN (-2147483648)
/**
* @def LVNV_PNLMS0_LB_COEFFS_MAX
* MaxValue of pNLMS0_LB_Coeffs
* @see LVNV_ControlParams_st
*/
#define LVNV_PNLMS0_LB_COEFFS_MAX (2147483647)

/**
* @def LVNV_PNLMS0_HB_COEFFS_DEFAULT
* Default of pNLMS0_HB_Coeffs
* @see LVNV_ControlParams_st
*/
#define LVNV_PNLMS0_HB_COEFFS_DEFAULT (0)
/**
* @def LVNV_PNLMS0_HB_COEFFS_MIN
* MinValue of pNLMS0_HB_Coeffs
* @see LVNV_ControlParams_st
*/
#define LVNV_PNLMS0_HB_COEFFS_MIN (-2147483648)
/**
* @def LVNV_PNLMS0_HB_COEFFS_MAX
* MaxValue of pNLMS0_HB_Coeffs
* @see LVNV_ControlParams_st
*/
#define LVNV_PNLMS0_HB_COEFFS_MAX (2147483647)

/**
* @def LVNV_PNLMS1_LB_COEFFS_DEFAULT
* Default of pNLMS1_LB_Coeffs
* @see LVNV_ControlParams_st
*/
#define LVNV_PNLMS1_LB_COEFFS_DEFAULT (0)
/**
* @def LVNV_PNLMS1_LB_COEFFS_MIN
* MinValue of pNLMS1_LB_Coeffs
* @see LVNV_ControlParams_st
*/
#define LVNV_PNLMS1_LB_COEFFS_MIN (-2147483648)
/**
* @def LVNV_PNLMS1_LB_COEFFS_MAX
* MaxValue of pNLMS1_LB_Coeffs
* @see LVNV_ControlParams_st
*/
#define LVNV_PNLMS1_LB_COEFFS_MAX (2147483647)

/**
* @def LVNV_PNLMS1_HB_COEFFS_DEFAULT
* Default of pNLMS1_HB_Coeffs
* @see LVNV_ControlParams_st
*/
#define LVNV_PNLMS1_HB_COEFFS_DEFAULT (0)
/**
* @def LVNV_PNLMS1_HB_COEFFS_MIN
* MinValue of pNLMS1_HB_Coeffs
* @see LVNV_ControlParams_st
*/
#define LVNV_PNLMS1_HB_COEFFS_MIN (-2147483648)
/**
* @def LVNV_PNLMS1_HB_COEFFS_MAX
* MaxValue of pNLMS1_HB_Coeffs
* @see LVNV_ControlParams_st
*/
#define LVNV_PNLMS1_HB_COEFFS_MAX (2147483647)

/**
* @def LVNV_PFSB_COEFFS_DEFAULT
* Default of pFSB_Coeffs
* @see LVNV_ControlParams_st
*/
#define LVNV_PFSB_COEFFS_DEFAULT (0)
/**
* @def LVNV_PFSB_COEFFS_MIN
* MinValue of pFSB_Coeffs
* @see LVNV_ControlParams_st
*/
#define LVNV_PFSB_COEFFS_MIN (-2147483648)
/**
* @def LVNV_PFSB_COEFFS_MAX
* MaxValue of pFSB_Coeffs
* @see LVNV_ControlParams_st
*/
#define LVNV_PFSB_COEFFS_MAX (2147483647)

/**
* @def LVNV_PGSC_COEFFS_DEFAULT
* Default of pGSC_Coeffs
* @see LVNV_ControlParams_st
*/
#define LVNV_PGSC_COEFFS_DEFAULT (0)
/**
* @def LVNV_PGSC_COEFFS_MIN
* MinValue of pGSC_Coeffs
* @see LVNV_ControlParams_st
*/
#define LVNV_PGSC_COEFFS_MIN (-2147483648)
/**
* @def LVNV_PGSC_COEFFS_MAX
* MaxValue of pGSC_Coeffs
* @see LVNV_ControlParams_st
*/
#define LVNV_PGSC_COEFFS_MAX (2147483647)

/**
* @def LVNV_PMICPOWSP_DEFAULT
* Default of pMicPowSp
* @see LVNV_ControlParams_st
*/
#define LVNV_PMICPOWSP_DEFAULT (0)
/**
* @def LVNV_PMICPOWSP_MIN
* MinValue of pMicPowSp
* @see LVNV_ControlParams_st
*/
#define LVNV_PMICPOWSP_MIN (0)
/**
* @def LVNV_PMICPOWSP_MAX
* MaxValue of pMicPowSp
* @see LVNV_ControlParams_st
*/
#define LVNV_PMICPOWSP_MAX (1)

/**
* @def LVNV_PCALFACTOR_DEFAULT
* Default of pCalFactor
* @see LVNV_ControlParams_st
*/
#define LVNV_PCALFACTOR_DEFAULT (0)
/**
* @def LVNV_PCALFACTOR_MIN
* MinValue of pCalFactor
* @see LVNV_ControlParams_st
*/
#define LVNV_PCALFACTOR_MIN (0)
/**
* @def LVNV_PCALFACTOR_MAX
* MaxValue of pCalFactor
* @see LVNV_ControlParams_st
*/
#define LVNV_PCALFACTOR_MAX (32767)

/**
* @def LVNV_PCALREADY_DEFAULT
* Default of pCalReady
* @see LVNV_ControlParams_st
*/
#define LVNV_PCALREADY_DEFAULT (0)
/**
* @def LVNV_PCALREADY_MIN
* MinValue of pCalReady
* @see LVNV_ControlParams_st
*/
#define LVNV_PCALREADY_MIN (0)
/**
* @def LVNV_PCALREADY_MAX
* MaxValue of pCalReady
* @see LVNV_ControlParams_st
*/
#define LVNV_PCALREADY_MAX (2)

/**
* @def LVNV_PBROADSIDE_INTERCC_DEFAULT
* Default of pBroadside_interCC
* @see LVNV_ControlParams_st
*/
#define LVNV_PBROADSIDE_INTERCC_DEFAULT (0)
/**
* @def LVNV_PBROADSIDE_INTERCC_MIN
* MinValue of pBroadside_interCC
* @see LVNV_ControlParams_st
*/
#define LVNV_PBROADSIDE_INTERCC_MIN (0)
/**
* @def LVNV_PBROADSIDE_INTERCC_MAX
* MaxValue of pBroadside_interCC
* @see LVNV_ControlParams_st
*/
#define LVNV_PBROADSIDE_INTERCC_MAX (32767)

/**
* @def LVHF_GAMMAE_DEFAULT
* Default of gammae
* @see LVHF_ControlParams_st
*/
#define LVHF_GAMMAE_DEFAULT (0)
/**
* @def LVHF_GAMMAE_MIN
* MinValue of gammae
* @see LVHF_ControlParams_st
*/
#define LVHF_GAMMAE_MIN (0)
/**
* @def LVHF_GAMMAE_MAX
* MaxValue of gammae
* @see LVHF_ControlParams_st
*/
#define LVHF_GAMMAE_MAX (32767)

/**
* @def LVHF_STATUS_DEFAULT
* Default of status
* @see LVHF_ControlParams_st
*/
#define LVHF_STATUS_DEFAULT (0)

/**
* @def LVHF_PNLMS_LB_COEFS_DEFAULT
* Default of pNLMS_LB_Coefs
* @see LVHF_ControlParams_st
*/
#define LVHF_PNLMS_LB_COEFS_DEFAULT (0)
/**
* @def LVHF_PNLMS_LB_COEFS_MIN
* MinValue of pNLMS_LB_Coefs
* @see LVHF_ControlParams_st
*/
#define LVHF_PNLMS_LB_COEFS_MIN (-2147483648)
/**
* @def LVHF_PNLMS_LB_COEFS_MAX
* MaxValue of pNLMS_LB_Coefs
* @see LVHF_ControlParams_st
*/
#define LVHF_PNLMS_LB_COEFS_MAX (2147483647)

/**
* @def LVHF_PNLMS_HB_COEFS_DEFAULT
* Default of pNLMS_HB_Coefs
* @see LVHF_ControlParams_st
*/
#define LVHF_PNLMS_HB_COEFS_DEFAULT (0)
/**
* @def LVHF_PNLMS_HB_COEFS_MIN
* MinValue of pNLMS_HB_Coefs
* @see LVHF_ControlParams_st
*/
#define LVHF_PNLMS_HB_COEFS_MIN (-2147483648)
/**
* @def LVHF_PNLMS_HB_COEFS_MAX
* MaxValue of pNLMS_HB_Coefs
* @see LVHF_ControlParams_st
*/
#define LVHF_PNLMS_HB_COEFS_MAX (2147483647)

/**
* @def LVHF_PPCD_COEFS_DEFAULT
* Default of pPCD_Coefs
* @see LVHF_ControlParams_st
*/
#define LVHF_PPCD_COEFS_DEFAULT (0)
/**
* @def LVHF_PPCD_COEFS_MIN
* MinValue of pPCD_Coefs
* @see LVHF_ControlParams_st
*/
#define LVHF_PPCD_COEFS_MIN (-2147483648)
/**
* @def LVHF_PPCD_COEFS_MAX
* MaxValue of pPCD_Coefs
* @see LVHF_ControlParams_st
*/
#define LVHF_PPCD_COEFS_MAX (2147483647)




/**
* @def LVVE_TX_DUMMY_DEFAULT
* Default of dummy
* @see LVVE_Tx_ControlParams_st
*/
#define LVVE_TX_DUMMY_DEFAULT (0)
/**
* @def LVVE_TX_DUMMY_MIN
* MinValue of dummy
* @see LVVE_Tx_ControlParams_st
*/
#define LVVE_TX_DUMMY_MIN (-128)
/**
* @def LVVE_TX_DUMMY_MAX
* MaxValue of dummy
* @see LVVE_Tx_ControlParams_st
*/
#define LVVE_TX_DUMMY_MAX (127)

/**
* Enum type for LVVIDHeader_MessageID_en
*/
typedef enum
{
    LVVE_RX_PRESET = 0, ///< VID header Message ID for LVVE_Rx presets
    LVVE_TX_PRESET = 1, ///< VID header Message ID for LVVE_Tx Presets
    LVVIDHEADER_MESSAGEID_EN_DUMMY = LVM_MAXENUM
} LVVIDHeader_MessageID_en;

/**
* Enum type for LVVIDHeader_ReturnStatus_en
*/
typedef enum
{
    LVVIDHEADER_NULLADDRESS = 0, ///< LVVIDHeader module returns NULL address error
    LVVIDHEADER_SUCCESS = 1, ///< LVVIDHeader module returns with success
    LVVIDHEADER_RETURNSTATUS_EN_DUMMY = LVM_MAXENUM
} LVVIDHeader_ReturnStatus_en;

/**
* Enum type for LVVE_Rx_Mode_en
*/
typedef enum
{
    LVVE_RX_MODE_OFF = 0, ///< Rx voice engine is turned off
    LVVE_RX_MODE_ON = 1, ///< Rx voice in will run
    LVVE_RX_MODE_BYPASS = 2, ///< Rx voice engine will run but output will be ignored
    LVVE_RX_MODE_EN_DUMMY = LVM_MAXENUM
} LVVE_Rx_Mode_en;

/**
* Enum type for LVVE_Tx_Mode_en
*/
typedef enum
{
    LVVE_TX_MODE_OFF = 0, ///< Tx in LVVE engine is disabled
    LVVE_TX_MODE_ON = 1, ///< TX in LVVE is enabled
    LVVE_TX_MODE_BYPASS_MIC0 = 2, ///< TX in LVVE engine will run but output will be Mic0 signal
    LVVE_TX_MODE_BYPASS_MIC1 = 3, ///< Tx in LVVE engine will run but output will be Mic1 signal
    LVVE_TX_MODE_BYPASS_REF = 4, ///< Tx in LVVE engine will run but output will be Ref signal
    LVVE_TX_MODE_EN_DUMMY = LVM_MAXENUM
} LVVE_Tx_Mode_en;

/****************************************************************************************/
/*                                                                                      */
/*  Structures                                                                          */
/*                                                                                      */
/****************************************************************************************/
/**
* The status parameters are used to retrieve the status of the module.
* @see LVVC_GetStatusParameters
*/
typedef struct
{
    /**
    The internal gain setting used by VoiceClarity.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>6.9</td>
        <td>@ref LVVC_GAIN_MIN (0)</td>
        <td>@ref LVVC_GAIN_DEFAULT (0)</td>
        <td>@ref LVVC_GAIN_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 Gain;          ///< Gain

    /**
    0 (no detection) or 1 (detection).
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>15.0</td>
        <td>@ref LVVC_SPDETECTED_MIN (0)</td>
        <td>@ref LVVC_SPDETECTED_DEFAULT (0)</td>
        <td>@ref LVVC_SPDETECTED_MAX (1)</td>
    </tr>
    </table> */
    LVM_INT16 SpDetected;          ///< The speech detector flag.

} LVVC_StatusParams_st;

/**
* The status parameters are used to retrieve the status of the module.
* @see LVWM_GetStatusParameters
*/
typedef struct
{
    /**
    The internal gain setting used by WhisperMode in dB.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>6.9</td>
        <td>@ref LVWM_AVL_GAIN_MIN (0)</td>
        <td>@ref LVWM_AVL_GAIN_DEFAULT (0)</td>
        <td>@ref LVWM_AVL_GAIN_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 AVL_Gain;          ///< gain (dB)

} LVWM_StatusParams_st;

/**
* The status parameters are used to retrieve the status of the module.
* @see LVVE_Rx_GetStatusParameters
*/
typedef struct
{
    /**
    Voice Clarity Status Parameter Structure.
    */
    LVVC_StatusParams_st VC_StatusParams;          ///< Voice Clarity Status Parameter Structure

    /**
    Whisper Mode Status Parameter Structure.
    */
    LVWM_StatusParams_st WM_StatusParams;          ///< Whisper Mode Status Parameter Structure

    /**
    Dummy Param.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>1.7</td>
        <td>@ref LVVE_RX_DUMMY_MIN (-128)</td>
        <td>@ref LVVE_RX_DUMMY_DEFAULT (0)</td>
        <td>@ref LVVE_RX_DUMMY_MAX (127)</td>
    </tr>
    </table> */
    LVM_INT8 dummy;          ///< Dummy Param

} LVVE_Rx_StatusParams_st;

/**
* The status parameters are used to retrieve the status of the module.
* @see LVNV_GetStatusParameters
*/
typedef struct
{
    /**
    Bit mask describing the current state of LVNV, used for debugging.
    */
    LVNV_StatusWord_bm status;          ///< current state

    /**
    To keep correct memory alignment. To be removed when LVNV_StatusWord_bm has
    become int32 as it should.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>0.15</td>
        <td>@ref LVNV_DUMMY_MIN (0)</td>
        <td>@ref LVNV_DUMMY_DEFAULT (0)</td>
        <td>@ref LVNV_DUMMY_MAX (0)</td>
    </tr>
    </table> */
    LVM_INT16 Dummy;          ///< Dummy for memory alignment.

    /**
    Pointer to the coefficients of the primary low-band (0-4kHz) NLMS filter
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>1.30</td>
        <td>@ref LVNV_PNLMS0_LB_COEFFS_MIN (-2147483648)</td>
        <td>@ref LVNV_PNLMS0_LB_COEFFS_DEFAULT (0)</td>
        <td>@ref LVNV_PNLMS0_LB_COEFFS_MAX (2147483647)</td>
    </tr>
    </table> */
    LVM_INT32* pNLMS0_LB_Coeffs;          ///< NLMS0 lowband filter coefficients

    /**
    Pointer to the coefficients of the primary high-band (4-8kHz) NLMS filter
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>1.30</td>
        <td>@ref LVNV_PNLMS0_HB_COEFFS_MIN (-2147483648)</td>
        <td>@ref LVNV_PNLMS0_HB_COEFFS_DEFAULT (0)</td>
        <td>@ref LVNV_PNLMS0_HB_COEFFS_MAX (2147483647)</td>
    </tr>
    </table> */
    LVM_INT32* pNLMS0_HB_Coeffs;          ///< NLMS0 highband filter coefficients

    /**
    Pointer to the coefficients of the secondary low-band (0-4kHz) NLMS filter
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>1.30</td>
        <td>@ref LVNV_PNLMS1_LB_COEFFS_MIN (-2147483648)</td>
        <td>@ref LVNV_PNLMS1_LB_COEFFS_DEFAULT (0)</td>
        <td>@ref LVNV_PNLMS1_LB_COEFFS_MAX (2147483647)</td>
    </tr>
    </table> */
    LVM_INT32* pNLMS1_LB_Coeffs;          ///< NLMS1 lowband filter coefficients

    /**
    Pointer to the coefficients of the secondary high-band (4-8kHz) NLMS filter
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>1.30</td>
        <td>@ref LVNV_PNLMS1_HB_COEFFS_MIN (-2147483648)</td>
        <td>@ref LVNV_PNLMS1_HB_COEFFS_DEFAULT (0)</td>
        <td>@ref LVNV_PNLMS1_HB_COEFFS_MAX (2147483647)</td>
    </tr>
    </table> */
    LVM_INT32* pNLMS1_HB_Coeffs;          ///< NLMS1 highband filter coefficients

    /**
    Pointer to the coefficients of the FSB0 and FSB1 filters
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>16.15</td>
        <td>@ref LVNV_PFSB_COEFFS_MIN (-2147483648)</td>
        <td>@ref LVNV_PFSB_COEFFS_DEFAULT (0)</td>
        <td>@ref LVNV_PFSB_COEFFS_MAX (2147483647)</td>
    </tr>
    </table> */
    LVM_INT32* pFSB_Coeffs;          ///< FSB0 and FSB1 coefficients

    /**
    Pointer to the coefficients of the GSC filter
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>1.30</td>
        <td>@ref LVNV_PGSC_COEFFS_MIN (-2147483648)</td>
        <td>@ref LVNV_PGSC_COEFFS_DEFAULT (0)</td>
        <td>@ref LVNV_PGSC_COEFFS_MAX (2147483647)</td>
    </tr>
    </table> */
    LVM_INT32* pGSC_Coeffs;          ///< GSC coefficients

    /**
    Pointer to the MicPowSp detection flag
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>15.0</td>
        <td>@ref LVNV_PMICPOWSP_MIN (0)</td>
        <td>@ref LVNV_PMICPOWSP_DEFAULT (0)</td>
        <td>@ref LVNV_PMICPOWSP_MAX (1)</td>
    </tr>
    </table> */
    LVM_INT16* pMicPowSp;          ///< MicPow Speech detection flag

    /**
    Pointer to the variable of Calibration factor
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>2.13</td>
        <td>@ref LVNV_PCALFACTOR_MIN (0)</td>
        <td>@ref LVNV_PCALFACTOR_DEFAULT (0)</td>
        <td>@ref LVNV_PCALFACTOR_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16* pCalFactor;          ///< Calibration factor value

    /**
    Pointer to the variable of Calibration ready
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>15.0</td>
        <td>@ref LVNV_PCALREADY_MIN (0)</td>
        <td>@ref LVNV_PCALREADY_DEFAULT (0)</td>
        <td>@ref LVNV_PCALREADY_MAX (2)</td>
    </tr>
    </table> */
    LVM_INT16* pCalReady;          ///< Calibration ready value

    /**
    Pointer to the inter-channel correlation value used in broadside detection.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>0.15</td>
        <td>@ref LVNV_PBROADSIDE_INTERCC_MIN (0)</td>
        <td>@ref LVNV_PBROADSIDE_INTERCC_DEFAULT (0)</td>
        <td>@ref LVNV_PBROADSIDE_INTERCC_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16* pBroadside_interCC;          ///< Broadside correlation

} LVNV_StatusParams_st;

/**
* The status parameters are used to retrieve the status of the module.
* @see LVHF_GetStatusParameters
*/
typedef struct
{
    /**
    Current value of the echo subtraction factor.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>5.10</td>
        <td>@ref LVHF_GAMMAE_MIN (0)</td>
        <td>@ref LVHF_GAMMAE_DEFAULT (0)</td>
        <td>@ref LVHF_GAMMAE_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 gammae;          ///< multiplicator factor of echo suppression

    /**
    Bit mask describing the current state of LVHF, used for debugging.
    */
    LVHF_StatusWord_bm status;          ///< current state

    /**
    Pointer to the coefficients of the LB NLMS.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>1.30</td>
        <td>@ref LVHF_PNLMS_LB_COEFS_MIN (-2147483648)</td>
        <td>@ref LVHF_PNLMS_LB_COEFS_DEFAULT (0)</td>
        <td>@ref LVHF_PNLMS_LB_COEFS_MAX (2147483647)</td>
    </tr>
    </table> */
    LVM_INT32* pNLMS_LB_Coefs;          ///< NLMS lowband filter coefficients

    /**
    Pointer to the coefficients of the HB NLMS.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>1.30</td>
        <td>@ref LVHF_PNLMS_HB_COEFS_MIN (-2147483648)</td>
        <td>@ref LVHF_PNLMS_HB_COEFS_DEFAULT (0)</td>
        <td>@ref LVHF_PNLMS_HB_COEFS_MAX (2147483647)</td>
    </tr>
    </table> */
    LVM_INT32* pNLMS_HB_Coefs;          ///< NLMS highband filter coefficients

    /**
    Pointer to the coefficients of the PCD NLMS.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>1.30</td>
        <td>@ref LVHF_PPCD_COEFS_MIN (-2147483648)</td>
        <td>@ref LVHF_PPCD_COEFS_DEFAULT (0)</td>
        <td>@ref LVHF_PPCD_COEFS_MAX (2147483647)</td>
    </tr>
    </table> */
    LVM_INT32* pPCD_Coefs;          ///< PCD NLMS filter coefficients

} LVHF_StatusParams_st;

/**
* The status parameters are used to retrieve the status of the module.
* @see LVVE_Tx_GetStatusParameters
*/
typedef struct
{
    /**
    HandsFree Status Parameter Structure.
    */
    LVHF_StatusParams_st HF_StatusParams;          ///< HandsFree Status Parameters Structure

    /**
    NoiseVoid Status Parameter Structure.
    */
    LVNV_StatusParams_st NV_StatusParams;          ///< NoiseVoid Status Parameters Structrue

    /**
    WhisperMode Status Parameter Structure.
    */
    LVWM_StatusParams_st WM_StatusParams;          ///< WhisperMode Status Parameter Structrue

    /**
    Dummy Param.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>1.7</td>
        <td>@ref LVVE_TX_DUMMY_MIN (-128)</td>
        <td>@ref LVVE_TX_DUMMY_DEFAULT (0)</td>
        <td>@ref LVVE_TX_DUMMY_MAX (127)</td>
    </tr>
    </table> */
    LVM_INT8 dummy;          ///< Dummy Param

} LVVE_Tx_StatusParams_st;

/**
* The control parameters are used to control the overall module behavior. These parameters may
* be changed at any time during processing using the LVVIDHeader_SetControlParameters function but they
* will not take effect until the next call to the LVVIDHeader_Process function.
*
* @see LVVIDHeader_SetControlParameters
* @see LVVIDHeader_Process
*/
typedef struct
{
    /**
    This number always increments by one when there is change in the header format.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>8.0</td>
        <td>@ref LVVIDHEADER_HEADERVERSION_MIN (0)</td>
        <td>@ref LVVIDHEADER_HEADERVERSION_DEFAULT (3)</td>
        <td>@ref LVVIDHEADER_HEADERVERSION_MAX (255)</td>
    </tr>
    </table> */
    LVM_UINT8 HeaderVersion;          ///< Header Format Version

    /**
    Initially This variable holds value of the baseline version. The value is in
    format of xxyyzzpp where xx is major number of the library, yy is minor number,
    zz is second minor number and pp is patch number of the baseline.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>32.0</td>
        <td>@ref LVVIDHEADER_BASELINEVERSION_MIN (1)</td>
        <td>@ref LVVIDHEADER_BASELINEVERSION_DEFAULT (51906816)</td>
        <td>@ref LVVIDHEADER_BASELINEVERSION_MAX (4294967295)</td>
    </tr>
    </table> */
    LVM_UINT32 BaselineVersion;          ///< This is LVVE tagged version name

    /**
    First LVVE_Rx algorithm mask which holds information of which LVVE_Rx
    algorithms are present.
    */
    LVVIDHeader_LVVE_Rx_Mask1_bm LVVE_Rx_AlgoMask1;          ///< This variable forms first part of LVVE_Rx algorithm mask

    /**
    Second LVVE_Rx algorithm mask which holds information of which LVVE_Rx
    algorithms are present.
    */
    LVVIDHeader_LVVE_Rx_Mask2_bm LVVE_Rx_AlgoMask2;          ///< This variable forms second part of LVVE_Rx algorithm mask

    /**
    First LVVE_Tx algorithm mask which holds information of which LVVE_Tx
    algorithms are present.
    */
    LVVIDHeader_LVVE_Tx_Mask1_bm LVVE_Tx_AlgoMask1;          ///< This variable forms first part of LVVE_Tx mask

    /**
    Second LVVE_Tx algorithm mask which holds information of which LVVE_Tx
    algorithms are present.
    */
    LVVIDHeader_LVVE_Tx_Mask2_bm LVVE_Tx_AlgoMask2;          ///< This variable forms second part of LVVE_Tx mask

    /**
    First LVVE configuration mask which holds information of which configurations
    of LVVE_Tx and LVVE_Rx algorithm are present.
    */
    LVVIDHeader_Configurations_Mask1_bm LVVE_Config_AlgoMask1;          ///< This variable forms first part of common LVVE_Tx and LVVE_Rx configuration mask

    /**
    Second LVVE configuration mask which holds information of which configurations
    of LVVE_Tx and LVVE_Rx algorithm are present.
    */
    LVVIDHeader_Configurations_Mask2_bm LVVE_Config_AlgoMask2;          ///< This variable forms second part of common LVVE_Tx and LVVE_Rx configuration mask

    /**
    Messge ID is used to identify stream
    */
    LVVIDHeader_MessageID_en MessageID;          ///< This param holds message ID of the buffer

    /**
    This parameter specifies the sample rate information of the buffer.
    */
    LVM_Fs_en SampleRate;          ///< Sample rate information of the buffer.

    /**
    This parameter specifies the volume index corresponding to the subsequent data.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>8.0</td>
        <td>@ref LVVIDHEADER_VOLUMEINDEX_MIN (0)</td>
        <td>@ref LVVIDHEADER_VOLUMEINDEX_DEFAULT (0)</td>
        <td>@ref LVVIDHEADER_VOLUMEINDEX_MAX (255)</td>
    </tr>
    </table> */
    LVM_UINT8 VolumeIndex;          ///< Volume index corresponding to the subsequent data.

    /**
    This parameter specifies how many volumes are present in the binary file.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>8.0</td>
        <td>@ref LVVIDHEADER_NUMVOLUMES_MIN (0)</td>
        <td>@ref LVVIDHEADER_NUMVOLUMES_DEFAULT (1)</td>
        <td>@ref LVVIDHEADER_NUMVOLUMES_MAX (255)</td>
    </tr>
    </table> */
    LVM_UINT8 NumVolumes;          ///< Number of volumes present in the binary file.

} LVVIDHeader_ControlParams_st;

/**
* The control parameters are used to control the overall module behavior. These parameters may
* be changed at any time during processing using the LVVC_SetControlParameters function but they
* will not take effect until the next call to the LVVC_Process function.
*
* @see LVVC_SetControlParameters
* @see LVVC_Process
*/
typedef struct
{
    /**
    Control the operating mode (ON/OFF) of the algorithm.
    */
    LVM_Mode_en OperatingMode;          ///< Operating mode

    /**
    The mode word to enable/disable internal algorithm blocks of VoiceClarity.
    */
    LVVC_ModeWord_bm mode;          ///< Mode word

    /**
    Maximum Gain applied to the signal.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>6.9</td>
        <td>@ref LVVC_GAIN_LIN_MAX_MIN (512)</td>
        <td>@ref LVVC_GAIN_LIN_MAX_DEFAULT (1286)</td>
        <td>@ref LVVC_GAIN_LIN_MAX_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 Gain_Lin_Max;          ///< Maximum Gain.

    /**
    The Noise_Sensitivity parameter sets how sensitive VoiceClarity will be to the
    background noise level. The Noise_Sensitivity parameter allows adjusting the
    sensitivity of those processing blocks to the nearend noise level. For high
    values of the Noise_Sensitivity the effect of the mentioned processing blocks
    will be big, even at low to moderate nearend noise levels. For low values of
    the Noise_Sensitivity the effect of the processing blocks will be smaller, even
    for high nearend noise levels.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>0.15</td>
        <td>@ref LVVC_NOISE_SENSITIVITY_MIN (-6709)</td>
        <td>@ref LVVC_NOISE_SENSITIVITY_DEFAULT (20000)</td>
        <td>@ref LVVC_NOISE_SENSITIVITY_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 Noise_Sensitivity;          ///< Noise Sensitivity.

    /**
    The desired output level of the AGC. <br>
    AVL_Target_level_lin = \f$32767*10^{Target_Level_dB/20}\f$
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>0.15</td>
        <td>@ref LVVC_AVL_TARGET_LEVEL_LIN_MIN (0)</td>
        <td>@ref LVVC_AVL_TARGET_LEVEL_LIN_DEFAULT (16384)</td>
        <td>@ref LVVC_AVL_TARGET_LEVEL_LIN_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 AVL_Target_level_lin;          ///< The desired output level of the AGC.

    /**
    The maximal attenuation of the AGC. <br>
    AVL_MinGainLin = \f$512*10^{MinGain_dB/20}\f$
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>6.9</td>
        <td>@ref LVVC_AVL_MINGAINLIN_MIN (0)</td>
        <td>@ref LVVC_AVL_MINGAINLIN_DEFAULT (256)</td>
        <td>@ref LVVC_AVL_MINGAINLIN_MAX (512)</td>
    </tr>
    </table> */
    LVM_INT16 AVL_MinGainLin;          ///< The maximal attenuation of the AGC.

    /**
    The maximal gain of the AGC. <br>
    AVL_MaxGainLin = \f$512*10^{MaxGain_dB/20}\f$
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>6.9</td>
        <td>@ref LVVC_AVL_MAXGAINLIN_MIN (512)</td>
        <td>@ref LVVC_AVL_MAXGAINLIN_DEFAULT (8192)</td>
        <td>@ref LVVC_AVL_MAXGAINLIN_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 AVL_MaxGainLin;          ///< The maximal gain of the AGC.

    /**
    The nominal gain of the AGC.<br>
    AVL_NominalGain = \f$512*10^{NominalGain_dB/20}\f$
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>6.9</td>
        <td>@ref LVVC_AVL_NOMINALGAIN_MIN (0)</td>
        <td>@ref LVVC_AVL_NOMINALGAIN_DEFAULT (512)</td>
        <td>@ref LVVC_AVL_NOMINALGAIN_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 AVL_NominalGain;          ///< The nominal gain of the AGC.

    /**
    The gain of the AGC is smoothed across time. The time constant of the smoothing
    depends on whether the gain is increasing or decreasing. When a sudden loud
    signal is encountered (e.g. attack of speech), the attack time is used. When
    the gain is increasing (e.g. long period of whispered speech), the release time
    is used. <br>

    AVL_Attack = \f$32767*\exp(-1/(100*AttackTimeSec))\f$
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>0.15</td>
        <td>@ref LVVC_AVL_ATTACK_MIN (0)</td>
        <td>@ref LVVC_AVL_ATTACK_DEFAULT (12055)</td>
        <td>@ref LVVC_AVL_ATTACK_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 AVL_Attack;          ///< The attack time of the AGC.

    /**
    The gain of the AGC is smoothed across time. The time constant of the smoothing
    depends on whether the gain is increasing or decreasing. When a sudden loud
    signal is encountered (e.g. attack of speech), the attack time is used. When
    the gain is increasing (e.g. long period of whispered speech), the release time
    is used. <br>

    AVL_Release = \f$32767*\exp(-1/(100*ReleaseTimeSec))\f$
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>0.15</td>
        <td>@ref LVVC_AVL_RELEASE_MIN (0)</td>
        <td>@ref LVVC_AVL_RELEASE_DEFAULT (32604)</td>
        <td>@ref LVVC_AVL_RELEASE_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 AVL_Release;          ///< The release time of the AGC.

    /**
    The release time at maximum noise level.<br>

    AVL_ReleaseMax = \f$32767*\exp(-1/(100*ReleaseMaxTimeSec))\f$
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>0.15</td>
        <td>@ref LVVC_AVL_RELEASEMAX_MIN (0)</td>
        <td>@ref LVVC_AVL_RELEASEMAX_DEFAULT (32441)</td>
        <td>@ref LVVC_AVL_RELEASEMAX_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 AVL_ReleaseMax;          ///< The release time at maximum noise level.

    /**
    AVL_Limit_MaxOutputLin = \f$32767*10^{TargetLimiterLeveldB/20}\f$
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>0.15</td>
        <td>@ref LVVC_AVL_LIMIT_MAXOUTPUTLIN_MIN (0)</td>
        <td>@ref LVVC_AVL_LIMIT_MAXOUTPUTLIN_DEFAULT (23170)</td>
        <td>@ref LVVC_AVL_LIMIT_MAXOUTPUTLIN_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 AVL_Limit_MaxOutputLin;          ///< The level to which the signal will be limited.

    /**
    The higher the value of the threshold, the less speech detections will occur.
    <br>
    SpDetect_Threshold = \f$512 * [0,64]\f$
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>6.9</td>
        <td>@ref LVVC_SPDETECT_THRESHOLD_MIN (0)</td>
        <td>@ref LVVC_SPDETECT_THRESHOLD_DEFAULT (1024)</td>
        <td>@ref LVVC_SPDETECT_THRESHOLD_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 SpDetect_Threshold;          ///< The threshold used in the speech detector of VoiceClarity.

} LVVC_ControlParams_st;

/**
* The control parameters are used to control the overall module behavior. These parameters may
* be changed at any time during processing using the LVFENS_SetControlParameters function but they
* will not take effect until the next call to the LVFENS_Process function.
*
* @see LVFENS_SetControlParameters
* @see LVFENS_Process
*/
typedef struct
{
    /**
    */
    LVM_Mode_en OperatingMode;          ///< Operating Mode

    /**
    The maximum amount of noise suppression. <br>
    Unit: dB<br>
    FENS_limit_ns = \f$32767*10^{-max noise reduction[dB]/20}\f$
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>0.15</td>
        <td>@ref LVFENS_FENS_LIMIT_NS_MIN (0)</td>
        <td>@ref LVFENS_FENS_LIMIT_NS_DEFAULT (10976)</td>
        <td>@ref LVFENS_FENS_LIMIT_NS_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 FENS_limit_NS;          ///< FENS Noise Suppression Limit

    /**
    The mode word to control the internal operation of FENS.
    */
    LVFENS_ModeWord_bm Mode;          ///< Mode word

} LVFENS_ControlParams_st;

/**
* The control parameters are used to control the overall module behavior. These parameters may
* be changed at any time during processing using the LVWM_SetControlParameters function but they
* will not take effect until the next call to the LVWM_Process function.
*
* @see LVWM_SetControlParameters
* @see LVWM_Process
*/
typedef struct
{
    /**
    Control the operating mode (ON/OFF) of the algorithm.
    */
    LVM_Mode_en OperatingMode;          ///< Operating mode

    /**
    The mode word to enable/disable internal algorithm blocks of WhisperMode.
    */
    LVWM_ModeWord_bm mode;          ///< Mode word

    /**
    The desired output level of the AGC. <br>
    AVL_Target_level_lin = \f$32767*10^{TargetLeveldB/20}\f$
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>0.15</td>
        <td>@ref LVWM_AVL_TARGET_LEVEL_LIN_MIN (0)</td>
        <td>@ref LVWM_AVL_TARGET_LEVEL_LIN_DEFAULT (16384)</td>
        <td>@ref LVWM_AVL_TARGET_LEVEL_LIN_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 AVL_Target_level_lin;          ///< The desired output level of the AGC.

    /**
    The maximal attenuation of the AGC. <br>
    AVL_MinGainLin = \f$512*10^{MinGaindB/20}\f$
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>6.9</td>
        <td>@ref LVWM_AVL_MINGAINLIN_MIN (0)</td>
        <td>@ref LVWM_AVL_MINGAINLIN_DEFAULT (128)</td>
        <td>@ref LVWM_AVL_MINGAINLIN_MAX (512)</td>
    </tr>
    </table> */
    LVM_INT16 AVL_MinGainLin;          ///< The maximal attenuation of the AGC.

    /**
    The maximal gain of the AGC. <br>
    AVL_MaxGainLin = \f$512*10^{MaxGaindB/20}\f$
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>6.9</td>
        <td>@ref LVWM_AVL_MAXGAINLIN_MIN (512)</td>
        <td>@ref LVWM_AVL_MAXGAINLIN_DEFAULT (8189)</td>
        <td>@ref LVWM_AVL_MAXGAINLIN_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 AVL_MaxGainLin;          ///< The maximal gain of the AGC.

    /**
    The gain of the AGC is smoothed across time. The time constant of the smoothing
    depends on whether the gain is increasing or decreasing. When a sudden loud
    signal is encountered (e.g. attack of speech), the attack time is used. When
    the gain is increasing (e.g. long period of whispered speech), the release time
    is used. <br>

    AVL_Attack = \f$32767*\exp(-1/(100*AttackTimeSec))\f$
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>0.15</td>
        <td>@ref LVWM_AVL_ATTACK_MIN (0)</td>
        <td>@ref LVWM_AVL_ATTACK_DEFAULT (25520)</td>
        <td>@ref LVWM_AVL_ATTACK_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 AVL_Attack;          ///< The attack time of the AGC.

    /**
    The gain of the AGC is smoothed across time. The time constant of the smoothing
    depends on whether the gain is increasing or decreasing. When a sudden loud
    signal is encountered (e.g. attack of speech), the attack time is used. When
    the gain is increasing (e.g. long period of whispered speech), the release time
    is used. <br>

    AVL_Release = \f$32767*\exp(-1/(100*ReleasTimeSec))\f$
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>0.15</td>
        <td>@ref LVWM_AVL_RELEASE_MIN (0)</td>
        <td>@ref LVWM_AVL_RELEASE_DEFAULT (32685)</td>
        <td>@ref LVWM_AVL_RELEASE_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 AVL_Release;          ///< The release time of the AGC.

    /**
    AVL_Limit_MaxOutputLin = \f$32767*10^{TargetLimiterLeveldB/20}\f$
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>0.15</td>
        <td>@ref LVWM_AVL_LIMIT_MAXOUTPUTLIN_MIN (0)</td>
        <td>@ref LVWM_AVL_LIMIT_MAXOUTPUTLIN_DEFAULT (23197)</td>
        <td>@ref LVWM_AVL_LIMIT_MAXOUTPUTLIN_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 AVL_Limit_MaxOutputLin;          ///< The level to which the signal will be limited.

    /**
    The higher the value of the threshold, the less speech detections will occur.
    <br>
    SpDetect_Threshold = \f$512 * [0,64]\f$
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>6.9</td>
        <td>@ref LVWM_SPDETECT_THRESHOLD_MIN (0)</td>
        <td>@ref LVWM_SPDETECT_THRESHOLD_DEFAULT (9216)</td>
        <td>@ref LVWM_SPDETECT_THRESHOLD_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 SpDetect_Threshold;          ///< The threshold used in the speech detector of WhisperMode.

} LVWM_ControlParams_st;

/**
* The control parameters are used to control the overall module behavior. These parameters may
* be changed at any time during processing using the LVDRC_SetControlParameters function but they
* will not take effect until the next call to the LVDRC_Process function.
*
* @see LVDRC_SetControlParameters
* @see LVDRC_Process
*/
typedef struct
{
    /**
    Operating mode for DRC
    */
    LVM_Mode_en OperatingMode;          ///< Operating mode

    /**
    Sets the number of sections (knee points) in the compressor curve
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>16.0</td>
        <td>@ref LVDRC_NUMKNEES_MIN (1)</td>
        <td>@ref LVDRC_NUMKNEES_DEFAULT (5)</td>
        <td>@ref LVDRC_NUMKNEES_MAX (5)</td>
    </tr>
    </table> */
    LVM_UINT16 NumKnees;          ///< Number of Knee points in compressor curve

    /**
    An array of size 5(maximum) containing the knee points specified by the
    compression curve in dBFs. The number of knee points in use is limited by the
    NumKnees parameter. Th input level for the first knee should be equal to or
    larger than -96dB, and the input level for the last knee should be 0dB.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>15.0</td>
        <td>@ref LVDRC_COMPRESSORCURVEINPUTLEVELS_MIN (-96)</td>
        <td>@ref LVDRC_COMPRESSORCURVEINPUTLEVELS_DEFAULT {-96,-70,-50, -24, 0}</td>
        <td>@ref LVDRC_COMPRESSORCURVEINPUTLEVELS_MAX (0)</td>
    </tr>
    </table> */
    LVM_INT16 CompressorCurveInputLevels[LVDRC_COMPRESSORCURVEINPUTLEVELS_LENGTH];          ///< Compressor Curve Input Levels

    /**
    An array of size 5(maximum) containing the knee points specified by the
    compression curve in dBFs. The number of knee points in use is limited by the
    NumKnees parameter. The output level for the first knee should be equal to or
    larger than -96dB, and the output level for the last knee should be equal to or
    smaller than 0dB.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>15.0</td>
        <td>@ref LVDRC_COMPRESSORCURVEOUTPUTLEVELS_MIN (-96)</td>
        <td>@ref LVDRC_COMPRESSORCURVEOUTPUTLEVELS_DEFAULT {-96,-70,-38,-12,0}</td>
        <td>@ref LVDRC_COMPRESSORCURVEOUTPUTLEVELS_MAX (0)</td>
    </tr>
    </table> */
    LVM_INT16 CompressorCurveOutputLevels[LVDRC_COMPRESSORCURVEOUTPUTLEVELS_LENGTH];          ///< Compressor Curve Output Levels

    /**
    The AttackTime parameter is the time constant controlling the rate of reaction
    to increase in signal level. The AttackTime is specified in increments of 100s
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>15.0</td>
        <td>@ref LVDRC_ATTACKTIME_MIN (0)</td>
        <td>@ref LVDRC_ATTACKTIME_DEFAULT (50)</td>
        <td>@ref LVDRC_ATTACKTIME_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 AttackTime;          ///< Attack Time

    /**
    The ReleaseTime parameter is the time constant controlling the rate of reaction
    to decrease in signal level. The ReleaseTime is specified in increments of
    100s.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>15.0</td>
        <td>@ref LVDRC_RELEASETIME_MIN (0)</td>
        <td>@ref LVDRC_RELEASETIME_DEFAULT (50)</td>
        <td>@ref LVDRC_RELEASETIME_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 ReleaseTime;          ///< Release Time

    /**
    Enable or Disable limiter with soft clipping.
    */
    LVM_Mode_en LimiterOperatingMode;          ///< Enable or Disable limiter with soft clipping

    /**
    Sets the limit level of the compressor in dB.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>15.0</td>
        <td>@ref LVDRC_LIMITLEVEL_MIN (-96)</td>
        <td>@ref LVDRC_LIMITLEVEL_DEFAULT (0)</td>
        <td>@ref LVDRC_LIMITLEVEL_MAX (0)</td>
    </tr>
    </table> */
    LVM_INT16 LimitLevel;          ///< Sets the limit level of the compressor in dB

} LVDRC_ControlParams_st;

/**
* The control parameters are used to control the overall module behavior. These parameters may
* be changed at any time during processing using the LVNG_SetControlParameters function but they
* will not take effect until the next call to the LVNG_Process function.
*
* @see LVNG_SetControlParameters
* @see LVNG_Process
*/
typedef struct
{
    /**
    Operating mode for Noise Gate
    */
    LVM_Mode_en OperatingMode;          ///< Operating mode

    /**
    Sets the number of sections (knee points) in the compressor curve
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>16.0</td>
        <td>@ref LVNG_NUMKNEES_MIN (1)</td>
        <td>@ref LVNG_NUMKNEES_DEFAULT (5)</td>
        <td>@ref LVNG_NUMKNEES_MAX (5)</td>
    </tr>
    </table> */
    LVM_UINT16 NumKnees;          ///< Number of Knee points in compressor curve

    /**
    An array of size 5(maximum) containing the knee points specified by the
    compression curve in dBFs. The number of knee points in use is limited by the
    NumKnees parameter. The input level for the first knee should be equal to or
    larger than -96dB, and the input level for the last knee should be 0dB.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>15.0</td>
        <td>@ref LVNG_COMPRESSORCURVEINPUTLEVELS_MIN (-96)</td>
        <td>@ref LVNG_COMPRESSORCURVEINPUTLEVELS_DEFAULT {-80,-70,-50, -24, 0}</td>
        <td>@ref LVNG_COMPRESSORCURVEINPUTLEVELS_MAX (0)</td>
    </tr>
    </table> */
    LVM_INT16 CompressorCurveInputLevels[LVNG_COMPRESSORCURVEINPUTLEVELS_LENGTH];          ///< Compressor Curve Input Levels

    /**
    An array of size 5(maximum) containing the knee points specified by the
    compression curve in dBFs. The number of knee points in use is limited by the
    NumKnees parameter. The output level for the first knee should be equal to or
    larger than -96dB, and the output level for the last knee should be equal to or
    smaller than 0dB.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>15.0</td>
        <td>@ref LVNG_COMPRESSORCURVEOUTPUTLEVELS_MIN (-96)</td>
        <td>@ref LVNG_COMPRESSORCURVEOUTPUTLEVELS_DEFAULT {-96,-80,-50, -24, 0}</td>
        <td>@ref LVNG_COMPRESSORCURVEOUTPUTLEVELS_MAX (0)</td>
    </tr>
    </table> */
    LVM_INT16 CompressorCurveOutputLevels[LVNG_COMPRESSORCURVEOUTPUTLEVELS_LENGTH];          ///< Compressor Curve Output Levels

    /**
    The AttackTime parameter is the time constant controlling the rate of reaction
    to increase in signal level. The AttackTime is specified in increments of 100s
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>15.0</td>
        <td>@ref LVNG_ATTACKTIME_MIN (0)</td>
        <td>@ref LVNG_ATTACKTIME_DEFAULT (50)</td>
        <td>@ref LVNG_ATTACKTIME_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 AttackTime;          ///< Attack Time

    /**
    The ReleaseTime parameter is the time constant controlling the rate of reaction
    to decrease in signal level. The ReleaseTime is specified in increments of
    100s.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>15.0</td>
        <td>@ref LVNG_RELEASETIME_MIN (0)</td>
        <td>@ref LVNG_RELEASETIME_DEFAULT (50)</td>
        <td>@ref LVNG_RELEASETIME_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 ReleaseTime;          ///< Release Time

} LVNG_ControlParams_st;

/**
* The control parameters are used to control the overall module behavior. These parameters may
* be changed at any time during processing using the LVNLPP_SetControlParameters function but they
* will not take effect until the next call to the LVNLPP_Process function.
*
* @see LVNLPP_SetControlParameters
* @see LVNLPP_Process
*/
typedef struct
{
    /**
    Limits the signal level compared to digital full scale in dB.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>15.0</td>
        <td>@ref LVNLPP_NLPP_LIMIT_MIN (-24)</td>
        <td>@ref LVNLPP_NLPP_LIMIT_DEFAULT (0)</td>
        <td>@ref LVNLPP_NLPP_LIMIT_MAX (0)</td>
    </tr>
    </table> */
    LVM_INT16 NLPP_Limit;          ///< NLPP Limit

    /**
    Sets the -3dB corner frequency of the high-pass filter in Hz.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>16.0</td>
        <td>@ref LVNLPP_NLPP_HPF_CORNERFREQ_MIN (50)</td>
        <td>@ref LVNLPP_NLPP_HPF_CORNERFREQ_DEFAULT (50)</td>
        <td>@ref LVNLPP_NLPP_HPF_CORNERFREQ_MAX (1000)</td>
    </tr>
    </table> */
    LVM_UINT16 NLPP_HPF_CornerFreq;          ///< NLPP HPF Corner Frequency

} LVNLPP_ControlParams_st;

/**
* The control parameters are used to control the overall module behavior. These parameters may
* be changed at any time during processing using the LVEQ_SetControlParameters function but they
* will not take effect until the next call to the LVEQ_Process function.
*
* @see LVEQ_SetControlParameters
* @see LVEQ_Process
*/
typedef struct
{
    /**
    Sets the length of the Equalizer impulse response. This must never be more than
    the value of EQ_MaxLength set at initialization time. The EQ_Length must be a
    multiple of 8.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>16.0</td>
        <td>@ref LVEQ_EQ_LENGTH_MIN (8)</td>
        <td>@ref LVEQ_EQ_LENGTH_DEFAULT (64)</td>
        <td>@ref LVEQ_EQ_LENGTH_MAX (64)</td>
    </tr>
    </table> */
    LVM_UINT16 EQ_Length;          ///< EQ Tap Length

    /**
    Pointer to an array containing the samples of the Equalizer impulse response.
    The format of the array content is specified below. The samples of the
    Equalizer impulse response must be in Q3.12 format.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>3.12</td>
        <td>@ref LVEQ_EQ_COEFS_MIN (-32768)</td>
        <td>@ref LVEQ_EQ_COEFS_DEFAULT {4096,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}</td>
        <td>@ref LVEQ_EQ_COEFS_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 *pEQ_Coefs;          ///< Equalizer impulse response

} LVEQ_ControlParams_st;



/*[Begin] [lvwenhua-2013/10/21]*/
typedef struct
{
    LVM_INT16                     EqCoefs[LVVE_MAX_EQ_LENGTH_NB];
} LVEQ_Coefs_st;
/*[End] [lvwenhua-2013/10/21]*/






/**
* The control parameters are used to control the overall module behavior. These parameters may
* be changed at any time during processing using the LVVOL_SetControlParameters function but they
* will not take effect until the next call to the LVVOL_Process function.
*
* @see LVVOL_SetControlParameters
* @see LVVOL_Process
*/
typedef struct
{
    /**
    Turns on/off VOL_Gain.
    */
    LVM_Mode_en VOL_OperatingMode;          ///< Turns on/off VOL_Gain

    /**
    The volume control gain can be used to set the overall volume level of the
    signal. The gain is set in dB with steps of 1dB.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>15.0</td>
        <td>@ref LVVOL_VOL_GAIN_MIN (-96)</td>
        <td>@ref LVVOL_VOL_GAIN_DEFAULT (0)</td>
        <td>@ref LVVOL_VOL_GAIN_MAX (24)</td>
    </tr>
    </table> */
    LVM_INT16 VOL_Gain;          ///< Apply Gain to Input signal

} LVVOL_ControlParams_st;

/**
* The control parameters are used to control the overall module behavior. These parameters may
* be changed at any time during processing using the LVHPF_SetControlParameters function but they
* will not take effect until the next call to the LVHPF_Process function.
*
* @see LVHPF_SetControlParameters
* @see LVHPF_Process
*/
typedef struct
{
    /**
    Turns on/off High Pass filter.
    */
    LVM_Mode_en HPF_OperatingMode;          ///< Turns on/off High Pass filter

    /**
    Sets the 3dB corner frequency of the high-pass filter. In case NoiseVoid is
    enabled, the same high-pass filter will be applied to the second microphone
    channel.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>16.0</td>
        <td>@ref LVHPF_HPF_CORNERFREQ_MIN (50)</td>
        <td>@ref LVHPF_HPF_CORNERFREQ_DEFAULT (50)</td>
        <td>@ref LVHPF_HPF_CORNERFREQ_MAX (1500)</td>
    </tr>
    </table> */
    LVM_UINT16 HPF_CornerFreq;          ///< High Pass Filter Corner Frequency in Hz

} LVHPF_ControlParams_st;

/**
* The control parameters are used to control the overall module behavior. These parameters may
* be changed at any time during processing using the LVMUTE_SetControlParameters function but they
* will not take effect until the next call to the LVMUTE_Process function.
*
* @see LVMUTE_SetControlParameters
* @see LVMUTE_Process
*/
typedef struct
{
    /**
    This param can mute unmute the Rx/Tx engine output.
    */
    LVM_Mode_en Mute;          ///< This param can mute unmute the Rx/Tx engine output

} LVMUTE_ControlParams_st;

/**
* The control parameters are used to control the overall module behavior. These parameters may
* be changed at any time during processing using the LVVE_Rx_SetControlParameters function but they
* will not take effect until the next call to the LVVE_Rx_Process function.
*
* @see LVVE_Rx_SetControlParameters
* @see LVVE_Rx_Process
*/
typedef struct
{
    /**
    This enumerated type is used to set the operating mode of the Rx path. The
    processing can be separately set to enable all processing modules (i.e., ON),
    to disable all processing modules (i.e., OFF) or to bypass all processing
    modules (i.e., BYPASS). When bypassed, all processing modules keep on running,
    but their output is not used.
    */
    LVVE_Rx_Mode_en OperatingMode;          ///< This param controls the on/off of RX voice engine.

    /**
    This param can mute unmute the Rx/Tx engine output.
    */
    LVM_Mode_en Mute;          ///< This param can mute unmute the Rx/Tx engine output

    /**
    Turns on/off VOL_Gain.
    */
    LVM_Mode_en VOL_OperatingMode;          ///< Turns on/off VOL_Gain

    /**
    The volume control gain can be used to set the overall volume level of the
    signal. The gain is set in dB with steps of 1dB.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>15.0</td>
        <td>@ref LVVE_RX_VOL_GAIN_MIN (-96)</td>
        <td>@ref LVVE_RX_VOL_GAIN_DEFAULT (0)</td>
        <td>@ref LVVE_RX_VOL_GAIN_MAX (24)</td>
    </tr>
    </table> */
    LVM_INT16 VOL_Gain;          ///< Apply Gain to Input signal

    /**
    Far End Noise Suppression Control Parameter Structure.
    */
    LVFENS_ControlParams_st FENS_ControlParams;          ///< Far End Noise Suppression Control Parameter Structure

    /**
    Turns on/off NLPP.
    */
    LVM_Mode_en NLPP_OperatingMode;          ///< Turns on/off NLPP

    /**
    NLPP Control Parameter Structure.
    */
    LVNLPP_ControlParams_st NLPP_ControlParams;          ///< NLPP Control Parameter Structure

    /**
    Voice Clarity Control Parameter Structure.
    */
    LVVC_ControlParams_st VC_ControlParams;          ///< Voice Clarity Control Parameter Structure

    /**
    Equalizer Operating mode.
    */
    LVM_Mode_en EQ_OperatingMode;          ///< Equalizer Operating mode

    /**
    Equalizer Control Parameters Structure.
    */
    LVEQ_ControlParams_st EQ_ControlParams;          ///< Equalizer Control Parameters Structure

    /**
    DRC Control Parameter Strcuture.
    */
    LVDRC_ControlParams_st DRC_ControlParams;          ///< DRC Control Parameter Strcuture

    /**
    Turns on/off High Pass filter.
    */
    LVM_Mode_en HPF_OperatingMode;          ///< Turns on/off High Pass filter

    /**
    Sets the 3dB corner frequency of the high-pass filter. In case NoiseVoid is
    enabled, the same high-pass filter will be applied to the second microphone
    channel.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>16.0</td>
        <td>@ref LVVE_RX_HPF_CORNERFREQ_MIN (50)</td>
        <td>@ref LVVE_RX_HPF_CORNERFREQ_DEFAULT (50)</td>
        <td>@ref LVVE_RX_HPF_CORNERFREQ_MAX (1500)</td>
    </tr>
    </table> */
    LVM_UINT16 HPF_CornerFreq;          ///< High Pass Filter Corner Frequency in Hz

    /**
    Whisper Mode Control Parameter Strcuture.
    */
    LVWM_ControlParams_st WM_ControlParams;          ///< Whisper Mode Control Parameter Strcuture

    /**
    Noise Gate Control Parameter Structure.
    */
    LVNG_ControlParams_st NG_ControlParams;          ///< Noise Gate Control Parameter Structure

} LVVE_Rx_ControlParams_st;

/**
* The control parameters are used to control the overall module behavior. These parameters may
* be changed at any time during processing using the LVNV_SetControlParameters function but they
* will not take effect until the next call to the LVNV_Process function.
*
* @see LVNV_SetControlParameters
* @see LVNV_Process
*/
typedef struct
{
    /**
    */
    LVM_Mode_en OperatingMode;          ///< Operating Mode

    /**
    The mode word to enable/disable internal algorithm blocks of LVNV.
    */
    LVNV_ModeWord_bm Mode;          ///< Mode word

    /**
    The mode2 word to allow switching or combining different blocks inside LVNV.
    */
    LVNV_Mode2Word_bm Mode2;          ///< Mode2 word

    /**
    The tuning mode word to enable/disable internal algorithm tuning capabilities
    in the different blocks of LVNV. Only one bit is allowed to be enabled at a
    time.
    */
    LVNV_TuningModeWord_bm Tuning_mode;          ///< Tuning mode word

    /**
    Gain applied at the primary channel in the Tx input. Used to scale the
    microphone signal in order to give the NLMS0_LB and NLMS0_HB filters headroom
    for correct operation.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>2.13</td>
        <td>@ref LVNV_INPUT_GAIN_MIC0_MIN (0)</td>
        <td>@ref LVNV_INPUT_GAIN_MIC0_DEFAULT (8192)</td>
        <td>@ref LVNV_INPUT_GAIN_MIC0_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 Input_Gain_Mic0;          ///< The primary input gain.

    /**
    Gain applied at the secondary channel in the Tx input. Used to scale the
    microphone signal in order to give the NLMS1_LB and NLMS1_HB filters headroom
    for correct operation.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>2.13</td>
        <td>@ref LVNV_INPUT_GAIN_MIC1_MIN (0)</td>
        <td>@ref LVNV_INPUT_GAIN_MIC1_DEFAULT (8192)</td>
        <td>@ref LVNV_INPUT_GAIN_MIC1_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 Input_Gain_Mic1;          ///< The secondary input gain.

    /**
    Gain applied at the Tx output of LVNV. Compensates the applied Input_Gain_Mic0
    in order to preserve the overall Tx gain.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>4.11</td>
        <td>@ref LVNV_OUTPUT_GAIN_MIN (0)</td>
        <td>@ref LVNV_OUTPUT_GAIN_DEFAULT (2048)</td>
        <td>@ref LVNV_OUTPUT_GAIN_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 Output_Gain;          ///< The output gain.

    /**
    Length of the low-band (0-4kHz) adaptive echo cancellation filter for the
    primary channel. The Length should be chosen such that most of the energy of
    the impulse response is covered by the filter. The length should be a multiple
    of 8.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>16.0</td>
        <td>@ref LVNV_NLMS0_LB_TAPS_MIN (16)</td>
        <td>@ref LVNV_NLMS0_LB_TAPS_DEFAULT (32)</td>
        <td>@ref LVNV_NLMS0_LB_TAPS_MAX (64)</td>
    </tr>
    </table> */
    LVM_UINT16 NLMS0_LB_taps;          ///< Number of NLMS0 low-band taps.

    /**
    Step size for the update of the low-band adaptive filter coefficients for the
    primary channel. It is recommended not to change the default value.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>0.15</td>
        <td>@ref LVNV_NLMS0_LB_TWOALPHA_MIN (0)</td>
        <td>@ref LVNV_NLMS0_LB_TWOALPHA_DEFAULT (8192)</td>
        <td>@ref LVNV_NLMS0_LB_TWOALPHA_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 NLMS0_LB_twoalpha;          ///< NLMS0 low-band step size

    /**
    Adaptive step-size control for the low-band adaptive echo cancellation filter
    for the primary channel. This parameter is used to slow down the update speed
    of the adaptive filter during double talk situations.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>9.6</td>
        <td>@ref LVNV_NLMS0_LB_ERL_MIN (64)</td>
        <td>@ref LVNV_NLMS0_LB_ERL_DEFAULT (1000)</td>
        <td>@ref LVNV_NLMS0_LB_ERL_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 NLMS0_LB_erl;          ///< NLMS0 low-band erl

    /**
    Length of the high-band (4-8kHz) adaptive echo cancellation filter for the
    primary channel. The Length should be chosen such that most of the energy of
    the impulse response is covered by the filter. The length should be a multiple
    of 8.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>16.0</td>
        <td>@ref LVNV_NLMS0_HB_TAPS_MIN (16)</td>
        <td>@ref LVNV_NLMS0_HB_TAPS_DEFAULT (24)</td>
        <td>@ref LVNV_NLMS0_HB_TAPS_MAX (64)</td>
    </tr>
    </table> */
    LVM_UINT16 NLMS0_HB_taps;          ///< Number of NLMS0 high-band taps.

    /**
    Step size for the update of the high-band adaptive filter coefficients for the
    primary channel. It is recommended not to change the default value.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>0.15</td>
        <td>@ref LVNV_NLMS0_HB_TWOALPHA_MIN (0)</td>
        <td>@ref LVNV_NLMS0_HB_TWOALPHA_DEFAULT (8192)</td>
        <td>@ref LVNV_NLMS0_HB_TWOALPHA_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 NLMS0_HB_twoalpha;          ///< NLMS0 high-band step size

    /**
    Adaptive step-size control for the high-band adaptive echo cancellation filter
    for the primary channel. This parameter is used to slow down the update speed
    of the adaptive filter during double talk situations.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>9.6</td>
        <td>@ref LVNV_NLMS0_HB_ERL_MIN (64)</td>
        <td>@ref LVNV_NLMS0_HB_ERL_DEFAULT (1000)</td>
        <td>@ref LVNV_NLMS0_HB_ERL_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 NLMS0_HB_erl;          ///< NLMS0 high-band erl

    /**
    Indicates whether a preset of adaptive filter coefficients should be done.<br>
    0 = No preset (coefficients as they are).<br>
    1 = Preset with internally calculated coefficients.<br>
    2 = Preset with zero coefficients.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>15.0</td>
        <td>@ref LVNV_NLMS0_PRESET_COEFS_MIN (0)</td>
        <td>@ref LVNV_NLMS0_PRESET_COEFS_DEFAULT (0)</td>
        <td>@ref LVNV_NLMS0_PRESET_COEFS_MAX (2)</td>
    </tr>
    </table> */
    LVM_INT16 NLMS0_preset_coefs;          ///< NLMS0 preset

    /**
    Offset added to the normalization of the adaptation of the filter.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>0.15</td>
        <td>@ref LVNV_NLMS0_OFFSET_MIN (0)</td>
        <td>@ref LVNV_NLMS0_OFFSET_DEFAULT (776)</td>
        <td>@ref LVNV_NLMS0_OFFSET_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 NLMS0_offset;          ///< NLMS0 offset

    /**
    Length of the low-band (0-4kHz) adaptive echo cancellation filter for the
    secondary channel. The Length should be chosen such that most of the energy of
    the impulse response is covered by the filter. The length should be a multiple
    of 8.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>16.0</td>
        <td>@ref LVNV_NLMS1_LB_TAPS_MIN (16)</td>
        <td>@ref LVNV_NLMS1_LB_TAPS_DEFAULT (32)</td>
        <td>@ref LVNV_NLMS1_LB_TAPS_MAX (32)</td>
    </tr>
    </table> */
    LVM_UINT16 NLMS1_LB_taps;          ///< Number of NLMS1 low-band taps.

    /**
    Step size for the update of the low-band adaptive filter coefficients for the
    secondary channel. It is recommended not to change the default value.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>0.15</td>
        <td>@ref LVNV_NLMS1_LB_TWOALPHA_MIN (0)</td>
        <td>@ref LVNV_NLMS1_LB_TWOALPHA_DEFAULT (8192)</td>
        <td>@ref LVNV_NLMS1_LB_TWOALPHA_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 NLMS1_LB_twoalpha;          ///< NLMS1 low-band step size

    /**
    Adaptive step-size control for the low-band adaptive echo cancellation filter
    for the secondary channel. This parameter is used to slow down the update speed
    of the adaptive filter during double talk situations.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>9.6</td>
        <td>@ref LVNV_NLMS1_LB_ERL_MIN (64)</td>
        <td>@ref LVNV_NLMS1_LB_ERL_DEFAULT (1000)</td>
        <td>@ref LVNV_NLMS1_LB_ERL_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 NLMS1_LB_erl;          ///< NLMS1 low-band erl

    /**
    Length of the high-band (4-8kHz) adaptive echo cancellation filter for the
    secondary channel. The Length should be chosen such that most of the energy of
    the impulse response is covered by the filter. The length should be a multiple
    of 8.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>16.0</td>
        <td>@ref LVNV_NLMS1_HB_TAPS_MIN (16)</td>
        <td>@ref LVNV_NLMS1_HB_TAPS_DEFAULT (24)</td>
        <td>@ref LVNV_NLMS1_HB_TAPS_MAX (32)</td>
    </tr>
    </table> */
    LVM_UINT16 NLMS1_HB_taps;          ///< Number of NLMS1 high-band taps.

    /**
    Step size for the update of the high-band adaptive filter coefficients for the
    secondary channel. It is recommended not to change the default value.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>0.15</td>
        <td>@ref LVNV_NLMS1_HB_TWOALPHA_MIN (0)</td>
        <td>@ref LVNV_NLMS1_HB_TWOALPHA_DEFAULT (8192)</td>
        <td>@ref LVNV_NLMS1_HB_TWOALPHA_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 NLMS1_HB_twoalpha;          ///< NLMS1 high-band step size

    /**
    Adaptive step-size control for the high-band adaptive echo cancellation filter
    for the secondary channel. This parameter is used to slow down the update speed
    of the adaptive filter during double talk situations.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>9.6</td>
        <td>@ref LVNV_NLMS1_HB_ERL_MIN (64)</td>
        <td>@ref LVNV_NLMS1_HB_ERL_DEFAULT (1000)</td>
        <td>@ref LVNV_NLMS1_HB_ERL_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 NLMS1_HB_erl;          ///< NLMS1 high-band erl

    /**
    Indicates whether a preset of adaptive filter coefficients should be done.<br>
    0 = No preset (coefficients as they are).<br>
    1 = Preset with internally calculated coefficients.<br>
    2 = Preset with zero coefficients.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>15.0</td>
        <td>@ref LVNV_NLMS1_PRESET_COEFS_MIN (0)</td>
        <td>@ref LVNV_NLMS1_PRESET_COEFS_DEFAULT (0)</td>
        <td>@ref LVNV_NLMS1_PRESET_COEFS_MAX (2)</td>
    </tr>
    </table> */
    LVM_INT16 NLMS1_preset_coefs;          ///< NLMS1 preset

    /**
    Offset added to the normalization of the adaptation of the filter.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>0.15</td>
        <td>@ref LVNV_NLMS1_OFFSET_MIN (0)</td>
        <td>@ref LVNV_NLMS1_OFFSET_DEFAULT (776)</td>
        <td>@ref LVNV_NLMS1_OFFSET_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 NLMS1_offset;          ///< NLMS1 offset

    /**
    A parameter representing a threshold for the detection of instrumental noise.
    The higher the value for this parameter, the lower noise suppression
    performance.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>0.15</td>
        <td>@ref LVNV_CAL_MICPOWFLOORMIN_MIN (0)</td>
        <td>@ref LVNV_CAL_MICPOWFLOORMIN_DEFAULT (150)</td>
        <td>@ref LVNV_CAL_MICPOWFLOORMIN_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 CAL_micPowFloorMin;          ///< Instrumental noise threshold

    /**
    Threshold for Windgush detector. The higher the value, the less sensitive the
    detection.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>6.9</td>
        <td>@ref LVNV_WGTHRESHOLD_MIN (0)</td>
        <td>@ref LVNV_WGTHRESHOLD_DEFAULT (32767)</td>
        <td>@ref LVNV_WGTHRESHOLD_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 WgThreshold;          ///< Windgush threshold

    /**
    Threshold for speech detector based on power comparison between primary and
    secondary microphones. The higher the value, the less sensitive the detection.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>3.12</td>
        <td>@ref LVNV_MPTHRESHOLD_MIN (0)</td>
        <td>@ref LVNV_MPTHRESHOLD_DEFAULT (6554)</td>
        <td>@ref LVNV_MPTHRESHOLD_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 MpThreshold;          ///< MicPow threshold

    /**
    Set of first 8 coefficients for adaptive filter FSB0. These values should be
    determined for the given microphone configuration
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>0.15</td>
        <td>@ref LVNV_FSB_INIT_TABLE0_MIN (-32768)</td>
        <td>@ref LVNV_FSB_INIT_TABLE0_DEFAULT {32767, 0, 0, 0, 0, 0, 0, 0}</td>
        <td>@ref LVNV_FSB_INIT_TABLE0_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 FSB_init_table0[LVNV_FSB_INIT_TABLE0_LENGTH];          ///< FSB0 initial coefficients.

    /**
    Set of first 8 coefficients for adaptive filter FSB1. These values should be
    determined for the given microphone configuration
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>0.15</td>
        <td>@ref LVNV_FSB_INIT_TABLE1_MIN (-32768)</td>
        <td>@ref LVNV_FSB_INIT_TABLE1_DEFAULT {0, 0, 0, 0, 0, 0, 0, 0}</td>
        <td>@ref LVNV_FSB_INIT_TABLE1_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 FSB_init_table1[LVNV_FSB_INIT_TABLE1_LENGTH];          ///< FSB1 initial coefficients.

    /**
    Length of the FSB to model the acoustical paths between the speech source and
    two microphones. The length must be equal to 16 for the handset application.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>16.0</td>
        <td>@ref LVNV_FSB_TAPS_MIN (8)</td>
        <td>@ref LVNV_FSB_TAPS_DEFAULT (16)</td>
        <td>@ref LVNV_FSB_TAPS_MAX (16)</td>
    </tr>
    </table> */
    LVM_UINT16 FSB_taps;          ///< Number of FSB taps

    /**
    Step-size to update the coefficients of the adaptive filters. A higher value
    leads to a faster speed of the adaptation, while a lower value provides more
    stability, but a slow adaption speed.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>0.15</td>
        <td>@ref LVNV_FSB_TWOALPHA_MIN (0)</td>
        <td>@ref LVNV_FSB_TWOALPHA_DEFAULT (655)</td>
        <td>@ref LVNV_FSB_TWOALPHA_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 FSB_twoalpha;          ///< FSB step size control

    /**
    Gain applied on the samples of the second FSB reference signal (fsbref[1]).
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>5.10</td>
        <td>@ref LVNV_FSB_REF_GAIN_MIN (0)</td>
        <td>@ref LVNV_FSB_REF_GAIN_DEFAULT (1024)</td>
        <td>@ref LVNV_FSB_REF_GAIN_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 FSB_ref_gain;          ///< FSB ref gain

    /**
    Length of the GSC to model the transfer function between the noise reference
    and the residual signal, in order to reduce the noise and interfering sounds
    from the desired signal. This number should be a multiple of 8.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>16.0</td>
        <td>@ref LVNV_GSC_TAPS_MIN (8)</td>
        <td>@ref LVNV_GSC_TAPS_DEFAULT (16)</td>
        <td>@ref LVNV_GSC_TAPS_MAX (48)</td>
    </tr>
    </table> */
    LVM_UINT16 GSC_taps;          ///< Number of GSC taps

    /**
    Step-size to update the coefficients of the adaptive filter. A higher value
    leads to a faster speed of the adaptation, while a lower value provides more
    stability, but a slow adaption speed.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>0.15</td>
        <td>@ref LVNV_GSC_TWOALPHA_MIN (0)</td>
        <td>@ref LVNV_GSC_TWOALPHA_DEFAULT (1638)</td>
        <td>@ref LVNV_GSC_TWOALPHA_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 GSC_twoalpha;          ///< GSC step size control

    /**
    Adaptive step-size control for GSC to avoid divergence of the adaptive filter
    during desired speech. In general, GSC_erl is lower than NLMS_erl and ranges
    between 0 and 30 dB.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>9.6</td>
        <td>@ref LVNV_GSC_ERL_MIN (64)</td>
        <td>@ref LVNV_GSC_ERL_DEFAULT (256)</td>
        <td>@ref LVNV_GSC_ERL_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 GSC_erl;          ///< GSC erl

    /**
    Offset added to the computation of the power of the noise reference to avoid
    that the power converges towards zero when the input is low.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>0.15</td>
        <td>@ref LVNV_GSC_OFFSET_MIN (0)</td>
        <td>@ref LVNV_GSC_OFFSET_DEFAULT (1638)</td>
        <td>@ref LVNV_GSC_OFFSET_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 GSC_offset;          ///< GSC offset

    /**
    Echo subtraction factor applied during farend-only.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>2.13</td>
        <td>@ref LVNV_DNNS_ECHOGAMMAHI_MIN (0)</td>
        <td>@ref LVNV_DNNS_ECHOGAMMAHI_DEFAULT (16384)</td>
        <td>@ref LVNV_DNNS_ECHOGAMMAHI_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 DNNS_EchoGammaHi;          ///< High echo subtraction factor

    /**
    Echo subtraction factor applied during double talk and nearend-only.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>2.13</td>
        <td>@ref LVNV_DNNS_ECHOGAMMALO_MIN (0)</td>
        <td>@ref LVNV_DNNS_ECHOGAMMALO_DEFAULT (8192)</td>
        <td>@ref LVNV_DNNS_ECHOGAMMALO_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 DNNS_EchoGammaLo;          ///< Low echo subtraction factor

    /**
    Parameter related to the reverberation time of the acoustical environment,
    which represents the decay in energy over time of the echo tail of the impulse
    response.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>0.15</td>
        <td>@ref LVNV_DNNS_ECHOALPHAREV_MIN (0)</td>
        <td>@ref LVNV_DNNS_ECHOALPHAREV_DEFAULT (12000)</td>
        <td>@ref LVNV_DNNS_ECHOALPHAREV_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 DNNS_EchoAlphaRev;          ///< Echo reverberation factor

    /**
    Parameter representing the portion of the echo tail (estimated by the NLMS
    filter) that has to be extrapolated in time.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>0.15</td>
        <td>@ref LVNV_DNNS_ECHOTAILPORTION_MIN (0)</td>
        <td>@ref LVNV_DNNS_ECHOTAILPORTION_DEFAULT (7000)</td>
        <td>@ref LVNV_DNNS_ECHOTAILPORTION_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 DNNS_EchoTailPortion;          ///< Echo tail portion

    /**
    Non-linear echo subtraction factor applied during double talk and nearend-only.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>4.11</td>
        <td>@ref LVNV_DNNS_NLATTEN_MIN (0)</td>
        <td>@ref LVNV_DNNS_NLATTEN_DEFAULT (256)</td>
        <td>@ref LVNV_DNNS_NLATTEN_MAX (2048)</td>
    </tr>
    </table> */
    LVM_INT16 DNNS_NlAtten;          ///< Non-linear echo subtraction factor

    /**
    Gain factor for stationary noise oversubtraction.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>2.13</td>
        <td>@ref LVNV_DNNS_NOISEGAMMAS_MIN (0)</td>
        <td>@ref LVNV_DNNS_NOISEGAMMAS_DEFAULT (11470)</td>
        <td>@ref LVNV_DNNS_NOISEGAMMAS_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 DNNS_NoiseGammaS;          ///< Stationary noise oversubtraction factor

    /**
    Gain factor for non-stationary noise oversubtraction.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>2.13</td>
        <td>@ref LVNV_DNNS_NOISEGAMMAN_MIN (0)</td>
        <td>@ref LVNV_DNNS_NOISEGAMMAN_DEFAULT (16384)</td>
        <td>@ref LVNV_DNNS_NOISEGAMMAN_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 DNNS_NoiseGammaN;          ///< Non-stationary noise oversubtraction factor

    /**
    The maximum amount of stationary noise suppression.<br>
    DNNS_NoiseGainMinS = \f$2*32767*10^{MaxNoiseReductiondB/20}\f$
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>-1.16</td>
        <td>@ref LVNV_DNNS_NOISEGAINMINS_MIN (0)</td>
        <td>@ref LVNV_DNNS_NOISEGAINMINS_DEFAULT (11140)</td>
        <td>@ref LVNV_DNNS_NOISEGAINMINS_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 DNNS_NoiseGainMinS;          ///< Maximum stationary noise suppression.

    /**
    The maximum amount of non-stationary noise suppression.<br>
    DNNS_NoiseGainMinN = \f$2*32767*10^{MaxNoiseReductiondB/20}\f$
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>-1.16</td>
        <td>@ref LVNV_DNNS_NOISEGAINMINN_MIN (0)</td>
        <td>@ref LVNV_DNNS_NOISEGAINMINN_DEFAULT (6554)</td>
        <td>@ref LVNV_DNNS_NOISEGAINMINN_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 DNNS_NoiseGainMinN;          ///< Maximum non-stationary noise suppression.

    /**
    Bias compensation factor for stationary noise estimation.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>2.13</td>
        <td>@ref LVNV_DNNS_NOISEBIASCOMP_MIN (0)</td>
        <td>@ref LVNV_DNNS_NOISEBIASCOMP_DEFAULT (9830)</td>
        <td>@ref LVNV_DNNS_NOISEBIASCOMP_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 DNNS_NoiseBiasComp;          ///< Bias compensation factor.

    /**
    Echo oversubtraction factor applied to the estimated non-stationary noise
    floor.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>3.12</td>
        <td>@ref LVNV_DNNS_GAINETA_MIN (0)</td>
        <td>@ref LVNV_DNNS_GAINETA_DEFAULT (256)</td>
        <td>@ref LVNV_DNNS_GAINETA_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 DNNS_GainEta;          ///< Echo oversubtraction factor.

    /**
    Detection threshold for microphone activity.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>3.12</td>
        <td>@ref LVNV_DNNS_ACTHRESHOLD_MIN (0)</td>
        <td>@ref LVNV_DNNS_ACTHRESHOLD_DEFAULT (12288)</td>
        <td>@ref LVNV_DNNS_ACTHRESHOLD_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 DNNS_AcThreshold;          ///< Activity threshold.

    /**
    Detection threshold for activity within the beam of FSB.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>3.12</td>
        <td>@ref LVNV_DNNS_WBTHRESHOLD_MIN (0)</td>
        <td>@ref LVNV_DNNS_WBTHRESHOLD_DEFAULT (9216)</td>
        <td>@ref LVNV_DNNS_WBTHRESHOLD_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 DNNS_WbThreshold;          ///< WithinBeam threshold.

    /**
    Detection threshold for lost beam where the nearend speaker is speaking outside
    the beam of the FSB.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>9.6</td>
        <td>@ref LVNV_DNNS_LOSTBEAMTHRESHOLD_MIN (0)</td>
        <td>@ref LVNV_DNNS_LOSTBEAMTHRESHOLD_DEFAULT (320)</td>
        <td>@ref LVNV_DNNS_LOSTBEAMTHRESHOLD_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 DNNS_LostBeamThreshold;          ///< Lost beam threshold.

    /**
    Smoothing factor applied to get a smoothed value of the inter-channel
    correlation.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>9.6</td>
        <td>@ref LVNV_PCD_BETA_MIN (0)</td>
        <td>@ref LVNV_PCD_BETA_DEFAULT (230)</td>
        <td>@ref LVNV_PCD_BETA_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 PCD_beta;          ///< ICC smoothing factor.

    /**
    Detection threshold for broadside when the nearend speaker is not in end-fire
    position with respect to the microphone configuration.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>9.6</td>
        <td>@ref LVNV_PCD_THRESHOLD_MIN (0)</td>
        <td>@ref LVNV_PCD_THRESHOLD_DEFAULT (26213)</td>
        <td>@ref LVNV_PCD_THRESHOLD_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 PCD_Threshold;          ///< Broadside detection threshold.

} LVNV_ControlParams_st;

/**
* The control parameters are used to control the overall module behavior. These parameters may
* be changed at any time during processing using the LVHF_SetControlParameters function but they
* will not take effect until the next call to the LVHF_Process function.
*
* @see LVHF_SetControlParameters
* @see LVHF_Process
*/
typedef struct
{
    /**
    */
    LVM_Mode_en OperatingMode;          ///< Operating Mode

    /**
    The mode word to enable/disable internal algorithm blocks of HandsFree
    */
    LVHF_ModeWord_bm Mode;          ///< Mode Word

    /**
    The tuning mode is used to enable/disable internal algorithm tuning
    capabilities in the different blocks of HandsFree. Only one bit allowed to be
    enabled at a time.
    */
    LVHF_TuningModeWord TuningMode;          ///< Tuning Mode

    /**
    Gain applied at the Tx input of LVHF. Used to scale the microphone signal in
    order to give the NLMS filter headroom for correct operation.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>2.13</td>
        <td>@ref LVHF_INPUTGAIN_MIN (0)</td>
        <td>@ref LVHF_INPUTGAIN_DEFAULT (8192)</td>
        <td>@ref LVHF_INPUTGAIN_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 InputGain;          ///< Input Gain

    /**
    Gain applied at the Tx output of LVHF. Compensates the applied InputGain in
    order to preserve the overall Tx gain.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>4.11</td>
        <td>@ref LVHF_OUTPUTGAIN_MIN (0)</td>
        <td>@ref LVHF_OUTPUTGAIN_DEFAULT (2048)</td>
        <td>@ref LVHF_OUTPUTGAIN_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 OutputGain;          ///< Output Gain

    /**
    Limit the NLMS reference signal. Value in dB Full Scale.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>15.0</td>
        <td>@ref LVHF_NLMS_LIMIT_MIN (-24)</td>
        <td>@ref LVHF_NLMS_LIMIT_DEFAULT (0)</td>
        <td>@ref LVHF_NLMS_LIMIT_MAX (0)</td>
    </tr>
    </table> */
    LVM_INT16 NLMS_limit;          ///< Limit the NLMS reference signal.

    /**
    Length of the low-band (0-4kHz) adaptive echo cancellation filter. The Length
    should be chosen such that most of the energy of the impulse response is
    covered by the filter. The length should be a multiple of 8.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>16.0</td>
        <td>@ref LVHF_NLMS_LB_TAPS_MIN (16)</td>
        <td>@ref LVHF_NLMS_LB_TAPS_DEFAULT (64)</td>
        <td>@ref LVHF_NLMS_LB_TAPS_MAX (200)</td>
    </tr>
    </table> */
    LVM_UINT16 NLMS_LB_taps;          ///< Number of taps for LB NLMS.

    /**
    Step size for the update of the low-band (0-4kHz) adaptive filter coefficients.
    It is recommended not to change the default value.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>0.15</td>
        <td>@ref LVHF_NLMS_LB_TWO_ALPHA_MIN (0)</td>
        <td>@ref LVHF_NLMS_LB_TWO_ALPHA_DEFAULT (8192)</td>
        <td>@ref LVHF_NLMS_LB_TWO_ALPHA_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 NLMS_LB_two_alpha;          ///< Step Size of LB NLMS

    /**
    Adaptive step size control for the low-band (0-4kHz) adaptive echo cancellation
    filter. This parameter is used to slow down the update speed of the adaptive
    filter during double talk situations.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>9.6</td>
        <td>@ref LVHF_NLMS_LB_ERL_MIN (64)</td>
        <td>@ref LVHF_NLMS_LB_ERL_DEFAULT (128)</td>
        <td>@ref LVHF_NLMS_LB_ERL_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 NLMS_LB_erl;          ///< ERL of LB NLMS

    /**
    Length of the high-band (4-8kHz) adaptive echo cancellation filter. The Length
    should be chosen such that most of the energy of the impulse response is
    covered by the filter. The length should be a multiple of 8. In case of
    narrowband processing, this parameter has no effect.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>16.0</td>
        <td>@ref LVHF_NLMS_HB_TAPS_MIN (16)</td>
        <td>@ref LVHF_NLMS_HB_TAPS_DEFAULT (64)</td>
        <td>@ref LVHF_NLMS_HB_TAPS_MAX (136)</td>
    </tr>
    </table> */
    LVM_UINT16 NLMS_HB_taps;          ///< Number of taps for HB NLMS.

    /**
    Step size for the update of the high-band (4-8kHz) adaptive filter
    coefficients. It is recommended not to change the default value. In case of
    narrowband processing, this parameter has no effect.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>0.15</td>
        <td>@ref LVHF_NLMS_HB_TWO_ALPHA_MIN (0)</td>
        <td>@ref LVHF_NLMS_HB_TWO_ALPHA_DEFAULT (8192)</td>
        <td>@ref LVHF_NLMS_HB_TWO_ALPHA_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 NLMS_HB_two_alpha;          ///< Step Size of HB NLMS

    /**
    Adaptive step size control for the high-band (4-8kHz) adaptive echo
    cancellation filter. This parameter is used to slow down the update speed of
    the adaptive filter during double talk situations. In case of narrowband
    processing, this parameter has no effect.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>9.6</td>
        <td>@ref LVHF_NLMS_HB_ERL_MIN (64)</td>
        <td>@ref LVHF_NLMS_HB_ERL_DEFAULT (128)</td>
        <td>@ref LVHF_NLMS_HB_ERL_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 NLMS_HB_erl;          ///< ERL of HB NLMS

    /**
    Indicates whether a preset of adaptive filter coefficients should be done. <br>
    0 = No preset (Coefficients as they are)<br>
    1= Preset with internally calculated coefficients.<br>
    2= Preset with zero coefficients.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>15.0</td>
        <td>@ref LVHF_NLMS_PRESET_COEFS_MIN (0)</td>
        <td>@ref LVHF_NLMS_PRESET_COEFS_DEFAULT (1)</td>
        <td>@ref LVHF_NLMS_PRESET_COEFS_MAX (2)</td>
    </tr>
    </table> */
    LVM_INT16 NLMS_preset_coefs;          ///< Coefficient preset.

    /**
    Offset added to the normalization of the adaptation of the filter.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>0.15</td>
        <td>@ref LVHF_NLMS_OFFSET_MIN (0)</td>
        <td>@ref LVHF_NLMS_OFFSET_DEFAULT (767)</td>
        <td>@ref LVHF_NLMS_OFFSET_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 NLMS_offset;          ///< NLMS offset

    /**
    Parameter related to the reverberation of the acoustic environment. It
    represents the decay in time of the energy of the echo tail of the impulse
    response for the LB.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>0.15</td>
        <td>@ref LVHF_DENS_TAIL_ALPHA_LB_MIN (0)</td>
        <td>@ref LVHF_DENS_TAIL_ALPHA_LB_DEFAULT (25395)</td>
        <td>@ref LVHF_DENS_TAIL_ALPHA_LB_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 DENS_tail_alpha_LB;
    /**
    Parameter related to the portion of the echo tail that has to be extrapolated
    in time for LB.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>0.15</td>
        <td>@ref LVHF_DENS_TAIL_PORTION_LB_MIN (0)</td>
        <td>@ref LVHF_DENS_TAIL_PORTION_LB_DEFAULT (29491)</td>
        <td>@ref LVHF_DENS_TAIL_PORTION_LB_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 DENS_tail_portion_LB;
    /**
    Echo subtraction factor applied during farend-only for the LB.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>7.8</td>
        <td>@ref LVHF_DENS_GAMMA_E_HIGH_LB_MIN (0)</td>
        <td>@ref LVHF_DENS_GAMMA_E_HIGH_LB_DEFAULT (512)</td>
        <td>@ref LVHF_DENS_GAMMA_E_HIGH_LB_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 DENS_gamma_e_high_LB;          ///< FE Echo subtraction LB

    /**
    Echo subtraction factor applied during double talk for the LB.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>7.8</td>
        <td>@ref LVHF_DENS_GAMMA_E_DT_LB_MIN (0)</td>
        <td>@ref LVHF_DENS_GAMMA_E_DT_LB_DEFAULT (256)</td>
        <td>@ref LVHF_DENS_GAMMA_E_DT_LB_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 DENS_gamma_e_dt_LB;          ///< DT Echo subtraction factor LB

    /**
    Echo subtraction factor applied during nearend-only for the LB.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>7.8</td>
        <td>@ref LVHF_DENS_GAMMA_E_LOW_LB_MIN (0)</td>
        <td>@ref LVHF_DENS_GAMMA_E_LOW_LB_DEFAULT (256)</td>
        <td>@ref LVHF_DENS_GAMMA_E_LOW_LB_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 DENS_gamma_e_low_LB;          ///< NE Echo subtraction factor LB

    /**
    The amount of extra non-linear suppression relative to the maximum linear echo
    suppression for the LB. The use of these non-linear echo suppression mechanisms
    should be avoided as much as possible since it affects the double talk
    performance.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>4.11</td>
        <td>@ref LVHF_DENS_NL_ATTEN_LB_MIN (0)</td>
        <td>@ref LVHF_DENS_NL_ATTEN_LB_DEFAULT (0)</td>
        <td>@ref LVHF_DENS_NL_ATTEN_LB_MAX (2048)</td>
    </tr>
    </table> */
    LVM_INT16 DENS_NL_atten_LB;          ///< LB Non linear attenuation

    /**
    Parameter related to the reverberation of the acoustic environment. It
    represents the decay in time of the energy of the echo tail of the impulse
    response for the HB.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>0.15</td>
        <td>@ref LVHF_DENS_TAIL_ALPHA_HB_MIN (0)</td>
        <td>@ref LVHF_DENS_TAIL_ALPHA_HB_DEFAULT (25395)</td>
        <td>@ref LVHF_DENS_TAIL_ALPHA_HB_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 DENS_tail_alpha_HB;
    /**
    Parameter related to the portion of the echo tail that has to be extrapolated
    in time for HB.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>0.15</td>
        <td>@ref LVHF_DENS_TAIL_PORTION_HB_MIN (0)</td>
        <td>@ref LVHF_DENS_TAIL_PORTION_HB_DEFAULT (29491)</td>
        <td>@ref LVHF_DENS_TAIL_PORTION_HB_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 DENS_tail_portion_HB;
    /**
    Echo subtraction factor applied during farend-only for the HB.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>7.8</td>
        <td>@ref LVHF_DENS_GAMMA_E_HIGH_HB_MIN (0)</td>
        <td>@ref LVHF_DENS_GAMMA_E_HIGH_HB_DEFAULT (512)</td>
        <td>@ref LVHF_DENS_GAMMA_E_HIGH_HB_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 DENS_gamma_e_high_HB;          ///< FE Echo subtraction HB

    /**
    Echo subtraction factor applied during double talk for the HB.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>7.8</td>
        <td>@ref LVHF_DENS_GAMMA_E_DT_HB_MIN (0)</td>
        <td>@ref LVHF_DENS_GAMMA_E_DT_HB_DEFAULT (256)</td>
        <td>@ref LVHF_DENS_GAMMA_E_DT_HB_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 DENS_gamma_e_dt_HB;          ///< DT Echo subtraction factor HB

    /**
    Echo subtraction factor applied during nearend-only for the HB.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>7.8</td>
        <td>@ref LVHF_DENS_GAMMA_E_LOW_HB_MIN (0)</td>
        <td>@ref LVHF_DENS_GAMMA_E_LOW_HB_DEFAULT (256)</td>
        <td>@ref LVHF_DENS_GAMMA_E_LOW_HB_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 DENS_gamma_e_low_HB;          ///< NE Echo subtraction factor HB

    /**
    The amount of extra non-linear suppression relative to the maximum linear echo
    suppression. for the HB. The use of these non-linear echo suppression
    mechanisms should be avoided as much as possible since it affects the double
    talk performance.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>4.11</td>
        <td>@ref LVHF_DENS_NL_ATTEN_HB_MIN (0)</td>
        <td>@ref LVHF_DENS_NL_ATTEN_HB_DEFAULT (0)</td>
        <td>@ref LVHF_DENS_NL_ATTEN_HB_MAX (2048)</td>
    </tr>
    </table> */
    LVM_INT16 DENS_NL_atten_HB;          ///< NE Echo subtraction factor HB

    /**
    Smoothing factor applied when switching between gamma_e values.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>0.15</td>
        <td>@ref LVHF_DENS_GAMMA_E_ALPHA_MIN (0)</td>
        <td>@ref LVHF_DENS_GAMMA_E_ALPHA_DEFAULT (24000)</td>
        <td>@ref LVHF_DENS_GAMMA_E_ALPHA_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 DENS_gamma_e_alpha;          ///< Smoothing factor for gamma_e

    /**
    Gain factor for Noise subtraction.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>7.8</td>
        <td>@ref LVHF_DENS_GAMMA_N_MIN (0)</td>
        <td>@ref LVHF_DENS_GAMMA_N_DEFAULT (280)</td>
        <td>@ref LVHF_DENS_GAMMA_N_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 DENS_gamma_n;          ///< Gain factor

    /**
    Threshold for nearend activity detection.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>7.8</td>
        <td>@ref LVHF_DENS_SPDET_NEAR_MIN (0)</td>
        <td>@ref LVHF_DENS_SPDET_NEAR_DEFAULT (512)</td>
        <td>@ref LVHF_DENS_SPDET_NEAR_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 DENS_spdet_near;
    /**
    Threshold for microphone activity detection.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>7.8</td>
        <td>@ref LVHF_DENS_SPDET_ACT_MIN (0)</td>
        <td>@ref LVHF_DENS_SPDET_ACT_DEFAULT (768)</td>
        <td>@ref LVHF_DENS_SPDET_ACT_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 DENS_spdet_act;
    /**
    The maximum amount of noise suppression. <br>
    DENS_limit_ns = \f$32767*10^{-MaxNoiseReduction[dB]/20}\f$
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>0.15</td>
        <td>@ref LVHF_DENS_LIMIT_NS_MIN (0)</td>
        <td>@ref LVHF_DENS_LIMIT_NS_DEFAULT (10361)</td>
        <td>@ref LVHF_DENS_LIMIT_NS_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 DENS_limit_ns;          ///< Maximum noise suppression.

    /**
    The amount of comfort noise insertion.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>1.14</td>
        <td>@ref LVHF_DENS_CNI_GAIN_MIN (0)</td>
        <td>@ref LVHF_DENS_CNI_GAIN_DEFAULT (16384)</td>
        <td>@ref LVHF_DENS_CNI_GAIN_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 DENS_CNI_Gain;          ///< CNI gain

    /**
    The window length (expressed in integer multiples of 10ms) for the estimation
    of the noise components. It is recommended to keep this parameter at its
    default value.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>0.15</td>
        <td>@ref LVHF_DENS_NFE_BLOCKSIZE_MIN (0)</td>
        <td>@ref LVHF_DENS_NFE_BLOCKSIZE_DEFAULT (150)</td>
        <td>@ref LVHF_DENS_NFE_BLOCKSIZE_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 DENS_NFE_blocksize;          ///< NFE blocksize

    /**
    Threshold for farend activity detection.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>0.15</td>
        <td>@ref LVHF_SPDET_FAR_MIN (0)</td>
        <td>@ref LVHF_SPDET_FAR_DEFAULT (16384)</td>
        <td>@ref LVHF_SPDET_FAR_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 SPDET_far;
    /**
    Threshold for microphone activity detection.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>0.15</td>
        <td>@ref LVHF_SPDET_MIC_MIN (0)</td>
        <td>@ref LVHF_SPDET_MIC_DEFAULT (16384)</td>
        <td>@ref LVHF_SPDET_MIC_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 SPDET_mic;
    /**
    Threshold to activate the non-linear echo-suppression.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>0.15</td>
        <td>@ref LVHF_SPDET_X_CLIP_MIN (0)</td>
        <td>@ref LVHF_SPDET_X_CLIP_DEFAULT (0)</td>
        <td>@ref LVHF_SPDET_X_CLIP_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 SPDET_x_clip;
    /**
    Threshold to detect acoustical path changes.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>0.15</td>
        <td>@ref LVHF_PCD_THRESHOLD_MIN (0)</td>
        <td>@ref LVHF_PCD_THRESHOLD_DEFAULT (20000)</td>
        <td>@ref LVHF_PCD_THRESHOLD_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 PCD_threshold;          ///< PCD threshold

    /**
    Length of the background adaptive filter. The length should be chosen such that
    only the main peak of the impulse response is covered by the filter. The length
    should be a multiple of 8.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>16.0</td>
        <td>@ref LVHF_PCD_TAPS_MIN (16)</td>
        <td>@ref LVHF_PCD_TAPS_DEFAULT (16)</td>
        <td>@ref LVHF_PCD_TAPS_MAX (64)</td>
    </tr>
    </table> */
    LVM_INT16 PCD_taps;          ///< Number of taps of background NLMS.

    /**
    Adaptive step size control for the background adaptive filter.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>9.6</td>
        <td>@ref LVHF_PCD_ERL_MIN (64)</td>
        <td>@ref LVHF_PCD_ERL_DEFAULT (64)</td>
        <td>@ref LVHF_PCD_ERL_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 PCD_erl;          ///< Step size of background NLMS.

    /**
    If a path change is detected, NLMS_erl of the NLMS is set to this value, to
    ensure a fast adapting filter.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>9.6</td>
        <td>@ref LVHF_PCD_MINIMUM_ERL_MIN (64)</td>
        <td>@ref LVHF_PCD_MINIMUM_ERL_DEFAULT (64)</td>
        <td>@ref LVHF_PCD_MINIMUM_ERL_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 PCD_minimum_erl;          ///< Step size of NLMS after PCD.

    /**
    After a path change the NLMS_erl of the NLMS increases back to the nominal
    value. The speed to increase can be controlled by this parameter.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>1.14</td>
        <td>@ref LVHF_PCD_ERL_STEP_MIN (16384)</td>
        <td>@ref LVHF_PCD_ERL_STEP_DEFAULT (16800)</td>
        <td>@ref LVHF_PCD_ERL_STEP_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 PCD_erl_step;          ///< Step of ERL increase after PCD.

    /**
    Gain factor applied to the echo subtraction during acoustical path change.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>7.8</td>
        <td>@ref LVHF_PCD_GAMMA_E_RESCUE_MIN (0)</td>
        <td>@ref LVHF_PCD_GAMMA_E_RESCUE_DEFAULT (5000)</td>
        <td>@ref LVHF_PCD_GAMMA_E_RESCUE_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 PCD_gamma_e_rescue;          ///< gamma_e after PCD

} LVHF_ControlParams_st;

/**
* The control parameters are used to control the overall module behavior. These parameters may
* be changed at any time during processing using the LVBD_SetControlParameters function but they
* will not take effect until the next call to the LVBD_Process function.
*
* @see LVBD_SetControlParameters
* @see LVBD_Process
*/
typedef struct
{
    /**
    Set Bulk Delay operating mode on/off.
    */
    LVM_Mode_en BD_OperatingMode;          ///< Set Bulk Delay operating mode on/off

    /**
    This parameter compensates for the fixed delay in the echo path and can be
    measured in advance. This delay is caused by the audio I/O buffering, AD/DA
    converter and propagation time between the loudspeaker and microphone. The unit
    of 'BulkDelay' is [number of samples] at the respective sampling rate.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>16.0</td>
        <td>@ref LVBD_BULKDELAY_MIN (0)</td>
        <td>@ref LVBD_BULKDELAY_DEFAULT (0)</td>
        <td>@ref LVBD_BULKDELAY_MAX (6400)</td>
    </tr>
    </table> */
    LVM_UINT16 BulkDelay;          ///< Sets Bulk Delay

    /**
    This param sets the gain for the Echo reference signal. Value 8192 belong to
    0dB
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>2.13</td>
        <td>@ref LVBD_BD_GAIN_MIN (0)</td>
        <td>@ref LVBD_BD_GAIN_DEFAULT (8192)</td>
        <td>@ref LVBD_BD_GAIN_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 BD_Gain;          ///< Apply Gain to Echo reference signal

} LVBD_ControlParams_st;

/**
* The control parameters are used to control the overall module behavior. These parameters may
* be changed at any time during processing using the LVVE_Tx_SetControlParameters function but they
* will not take effect until the next call to the LVVE_Tx_Process function.
*
* @see LVVE_Tx_SetControlParameters
* @see LVVE_Tx_Process
*/
typedef struct
{
    /**
    This enumerated type is used to set the operating mode of the Tx path. The
    processing can be separately set to enable all processing modules (i.e., ON),
    to disable all processing modules (i.e., OFF) or to bypass all processing
    modules (i.e., BYPASS). When bypassed, all processing modules keep on running,
    but their output is not used. When bypassing the Tx processing, the user can
    select which buffer should be copied to the output buffer, if required: @li
    Input microphone signal (or secondary microphone signal in case of
    two-microphone setups); @li Rx reference signal; These operations ensure that
    the input data is correctly transferred to the output buffer for all
    combinations of input and output buffer types and input format. When OFF, the
    input is copied to the output and the LVVE can be provided with invalid
    parameters for modules. The sub module functions are not executed in this
    scenario. Their combined functionality is summarized in follwoing table. <br>
    <div align="center"> <table cellspacing="1" cellpadding="4" border="3">
    <caption>LVVE Tx operating mode in combination with LVVE microphone routing
    mode</caption> <tr> <th></th> <th colspan="2">MICROUTING_MODE_DEFAULT</th> <th
    colspan="2">MICROUTING_MODE_SWAPPED</th> </tr> <tr> <th width="70"></th> <th
    width="70">Process</th> <th width="70">Output</th> <th width="70">Process</th>
    <th width="70">Output</th> </tr> <tr align="left"> <td>LVVE_TX_MODE_OFF</td>
    <td>None</td> <td>Tx input 0</td> <td>None</td> <td>Tx input 1</td> </tr> <tr
    align="left"> <td>LVVE_TX_MODE_ON</td> <td>Tx input 0</td> <td>Tx output</td>
    <td>Tx input 1</td> <td>Tx output</td> </tr> <tr align="left">
    <td>LVVE_TX_MODE_BYPASS_MIC0</td> <td>Tx input 0</td> <td>Tx input 0</td>
    <td>Tx input 1</td> <td>Tx input 1</td> </tr> <tr align="left">
    <td>LVVE_TX_MODE_BYPASS_MIC1</td> <td>Tx input 0</td> <td>Tx input 1</td>
    <td>Tx input 1</td> <td>Tx input 0</td> </tr> <tr align="left">
    <td>LVVE_TX_MODE_BYPASS_REF</td> <td>Tx input 0</td> <td>Tx ref input</td>
    <td>Tx input 1</td> <td>Tx ref input</td> </tr> </table> </div>
    */
    LVVE_Tx_Mode_en OperatingMode;          ///< TX Operating mode

    /**
    This param can mute unmute the Rx/Tx engine output.
    */
    LVM_Mode_en Mute;          ///< This param can mute unmute the Rx/Tx engine output

    /**
    Set Bulk Delay operating mode on/off.
    */
    LVM_Mode_en BD_OperatingMode;          ///< Set Bulk Delay operating mode on/off

    /**
    This parameter compensates for the fixed delay in the echo path and can be
    measured in advance. This delay is caused by the audio I/O buffering, AD/DA
    converter and propagation time between the loudspeaker and microphone. The unit
    of 'BulkDelay' is [number of samples] at the respective sampling rate.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>16.0</td>
        <td>@ref LVVE_TX_BULKDELAY_MIN (0)</td>
        <td>@ref LVVE_TX_BULKDELAY_DEFAULT (0)</td>
        <td>@ref LVVE_TX_BULKDELAY_MAX (6400)</td>
    </tr>
    </table> */
    LVM_UINT16 BulkDelay;          ///< Sets Bulk Delay

    /**
    This param sets the gain for the Echo reference signal. Value 8192 belong to
    0dB
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>2.13</td>
        <td>@ref LVVE_TX_BD_GAIN_MIN (0)</td>
        <td>@ref LVVE_TX_BD_GAIN_DEFAULT (8192)</td>
        <td>@ref LVVE_TX_BD_GAIN_MAX (32767)</td>
    </tr>
    </table> */
    LVM_INT16 BD_Gain;          ///< Apply Gain to Echo reference signal

    /**
    Turns on/off VOL_Gain.
    */
    LVM_Mode_en VOL_OperatingMode;          ///< Turns on/off VOL_Gain

    /**
    The volume control gain can be used to set the overall volume level of the
    signal. The gain is set in dB with steps of 1dB.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>15.0</td>
        <td>@ref LVVE_TX_VOL_GAIN_MIN (-96)</td>
        <td>@ref LVVE_TX_VOL_GAIN_DEFAULT (0)</td>
        <td>@ref LVVE_TX_VOL_GAIN_MAX (24)</td>
    </tr>
    </table> */
    LVM_INT16 VOL_Gain;          ///< Apply Gain to Input signal

    /**
    Turns on/off High Pass filter.
    */
    LVM_Mode_en HPF_OperatingMode;          ///< Turns on/off High Pass filter

    /**
    Sets the 3dB corner frequency of the high-pass filter. In case NoiseVoid is
    enabled, the same high-pass filter will be applied to the second microphone
    channel.
    <table border>
    <tr>
        <td><b>Q-format</b></td>
        <td><b>Min</b></td>
        <td><b>Default</b></td>
        <td><b>Max</b></td>
    </tr>
    <tr>
        <td>16.0</td>
        <td>@ref LVVE_TX_MIC_HPF_CORNERFREQ_MIN (50)</td>
        <td>@ref LVVE_TX_MIC_HPF_CORNERFREQ_DEFAULT (50)</td>
        <td>@ref LVVE_TX_MIC_HPF_CORNERFREQ_MAX (1500)</td>
    </tr>
    </table> */
    LVM_UINT16 MIC_HPF_CornerFreq;          ///< High Pass Filter Corner Frequency in Hz

    /**
    HandsFree Control Parameter Strcuture.
    */
    LVHF_ControlParams_st HF_ControlParams;          ///< HandsFree Control Parameter Structure

    /**
    NoiseVoid Control Parameter Structure.
    */
    LVNV_ControlParams_st NV_ControlParams;          ///< NoiseVoid Control Parameter Structure

    /**
    WhisperMode Control Parameter Structure.
    */
    LVWM_ControlParams_st WM_ControlParams;          ///< WhisperMode Control Parameter Structure

    /**
    Equalizer Operating mode.
    */
    LVM_Mode_en EQ_OperatingMode;          ///< Equalizer Operating mode

    /**
    Equalizer Control Parameter Structure.
    */
    LVEQ_ControlParams_st EQ_ControlParams;          ///< Equalizer Control Parameters Structure

    /**
    DRC Control Parameter Structure.
    */
    LVDRC_ControlParams_st DRC_ControlParams;          ///< DRC Control Parameter Structure

} LVVE_Tx_ControlParams_st;



/*[Begin] [lvwenhua-2012/3/12]*/
#define LVVC_VOLUME_NUM             12

typedef struct
{
    LVM_INT16                   NoiseSensitivity[LVVC_VOLUME_NUM];
} LVVC_NoiseSens_st;
/*[End] [lvwenhua-2012/3/12]*/

/*[Begin] [lvwenhua-2011/8/23]*/
typedef struct
{
    LVVE_Tx_ControlParams_st    Tx_ControlParams;
    LVVE_Rx_ControlParams_st    Rx_ControlParams;
    LVEQ_Coefs_st TxEqCoefs;
    LVEQ_Coefs_st RxEqCoefs;
    /*[Begin] [lvwenhua-2012/3/12]*/
    LVVC_NoiseSens_st RxVcNoiseSens;
    /*[End] [lvwenhua-2012/3/12]*/
} LVVE_ControlParams_st;
typedef struct
{
    LVM_UINT32 isVpParamInNv;
    LVVE_ControlParams_st    Handset_ControlParams;
    LVVE_ControlParams_st    Handsfree_ControlParams;
    LVVE_ControlParams_st    Headset_ControlParams;
    LVVE_ControlParams_st    Bluetooth_ControlParams;
} LVVE_ControlParams_All_st;
/*[End] [lvwenhua-2011/8/23]*/







#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif      /* __REL_LVVE_HF_NV1_VC_AGC_RX_DRC_RX_WB_VIDPP_H__ */

/* End of file */
