/**************************************************************************
*
*                  Copyright (c) 2012 ZTE Corporation.
*
***************************************************************************
* ģ   : ose_kernel.c
*    : ose_kernel.c
* ļ : 
* ʵֹ : ϵͳ,ϵͳĻ
*      : κ
*      : V1.0
*  : 2007/06/01
* ˵ :          
**************************************************************************/
/**************************************************************************
* ޸ļ¼
**************************************************************************/
/**************************************************************************
* ޸ı : 0001
*    : κ  
* ޸ : 2008/02/12
* ޸ : ṩ߳̿ռ
**************************************************************************/
/**************************************************************************
* ޸ı : 0002
*    : junkuiZhao
* ޸ : 2012/09/15
* ޸ : PC-LINTڱ淶޸ EC: 617001781881  
**************************************************************************/
/**************************************************************************
* ޸ı : 0003
*    : junkuiZhao
* ޸ : 2012/10/10
* ޸ : ߲ EC: 617001781957
**************************************************************************/

/**************************************************************************
* #include
**************************************************************************/
#include "oss_api.h"
#include "ose_typedef.h"
#include "osa.h"
#include "sup.h"
#include "bios.h"
#include "hwtimer.h"
#include "Dyn_config.h"
#include <time.h>
#include "rtc.h"
#include "sysparam.h"

#ifdef __cplusplus
extern "C"
{
#endif

/**************************************************************************
* 궨
**************************************************************************/
#define THREAD_MSG_HEAD_SIZE        sizeof( T_THREAD_MSG_HEAD )
#define THREAD_MSG_HEAD(buf)        (T_THREAD_MSG_HEAD *)((UINT8 *)(buf) - THREAD_MSG_HEAD_SIZE)
#define THREAD_MSG_BUF(head)        (VOID *)((UINT8 *)(head) + THREAD_MSG_HEAD_SIZE)
#define THREAD_MSG_SIZE(size)       ((size) + THREAD_MSG_HEAD_SIZE)
#define THREAD_MSG_MAGIC            0x3A3A3A3A

#define THREAD_MSG_HOOK_TYPE_MAX    ZOSS_SETHOOKFLAG_INTER
#define THREAD_MSG_HOOK_DIRE_MAX    ZOSS_MSGDIRE_INOUT

/**************************************************************************
* ݽṹ
**************************************************************************/
typedef struct
{
    SIGSELECT   sig_no; /* Աڽṹеλòܸı */
    UINT32      id;
    UINT32      buf_size;
    UINT32      magic;
}T_THREAD_MSG_HEAD;

typedef struct
{
    T_ZOss_Node     Node;                           /* λòܸı             */
    ZOSS_THREAD_ID  thread_id;
    UINT8           dire[THREAD_MSG_HOOK_TYPE_MAX]; /* 0: ZOSS_SETHOOKFLAG_MONI=1   */
    THREAD_MSG_HOOK func[THREAD_MSG_HOOK_TYPE_MAX]; /* 0: ZOSS_SETHOOKFLAG_MONI=1   */
}THREAD_MSG_HOOK_CONTENT;

/**************************************************************************
* ȫֳ/
**************************************************************************/
T_ZOsa_ThreadUserArea   **gp_OsaThreadUserArea  = NULL;     /* ߳ûռַ     */
static long int         hwt_handle              = 0;
static UINT32           gOsa_SwapLastTime       = 0;
static  UINT32          gOsa_CpuStartTime       = 0;        /* ʼͳִ߳ʱ     */
static BOOL             gOsa_SwapFlag           = FALSE;    /* ߳hook־         */
static ZOSS_TASK_ID     *gOsa_AllTaskIdArray    = NULL;
BOOL                    gOsa_SwapTimeFlag       = FALSE;    /* ߳л¼cpuʱ־  */
UINT32                  gOse_maxthreads         = 0;
UINT32                  gOsa_SysCpuFreq         = 0;        /* ӲƵ           */

VOID zOss_checkUBlist(VOID);

#ifdef _USE_TRACE_INT_THREAD

UINT32          gSwapInIndex            = 0;
ZOSS_THREAD_ID  gSwapInThreadsID[5000];
UINT32          gSwapInTimes[5000];
UINT32          gSum                    = 0;

UINT32          gSwapOutIndex           = 0;
ZOSS_THREAD_ID  gSwapOutThreadsID[5000];
UINT32          gSwapOutTimes[5000];

#endif

static T_ZOss_List  s_thread_msg_hook_list = { 0 };
/************************************************************************** 
* ⲿ
**************************************************************************/   
extern UINT32           gMem_UBStart ;    /* ڴʼָ   */

/**************************************************************************  
* ⲿ
**************************************************************************/ 
extern UINT32 MEM_Init(VOID);
extern VOID Osa_SysErrHndInit(VOID);
extern VOID FS_Init(VOID);
#ifdef _USE_PSM
extern UINT32 zOss_PsmAdjustFreq312M(VOID);
#endif

/*************************************************************************
* ֲʵ
*************************************************************************/
/*************************************************************************
* : zOss_IdVerify
* : ֤ʵضIDĴ
* ˵:
*   ֵ: ZOSS_SUCCESS:ЧID;ZOSS_ERROR:ЧID
* ˵:
*************************************************************************/
static UINT32 zOss_IdVerify(ZOSS_THREAD_ID thread_id)
{
    enum PROCESS_TYPE  ProcessType;

    zOss_AssertEx(NULL != thread_id, ZOSS_ERROR);
    ProcessType = get_ptype((PROCESS) thread_id);

    if (OS_ILLEGAL == ProcessType || OS_ZOOMBIE == ProcessType)   /* Ч߳ID */
    {
        return ZOSS_ERROR;
    }
    else
    {
        return ZOSS_SUCCESS;
    }
}

/**************************************************************************
* : Osa_OseThreadEntry
* : OSEں
* ˵: (IN)
*   ֵ:
* ˵: ֻzOss_CreateThread(),OSE߳ں,
*           úڲִû߳ʵ庯.OSE ̻߳ԭ
*           ʵֵʵ庯ʵ庯β.
**************************************************************************/
static VOID Osa_OseThreadEntry(VOID)
{
    PROCESS         thread_id   = current_process();
    ZOSS_THREAD_FUN thread_fun  = (ZOSS_THREAD_FUN)get_envp((PROCESS)thread_id, OSA_THREADFUN); /* ָ */
    SINT32          arg         = (SINT32)get_envp((PROCESS)thread_id, OSA_THREADARG);          /* ָ */

    if (NULL == thread_fun)
    {
        zOss_ASSERT(NULL != thread_fun);
        zOss_ExitThread();/* ʽ˳,ִ߳Ȼ  */
        return;
    }

    thread_fun(arg);    /* ִûʵ庯                         */
    zOss_ExitThread();  /* ʽ˳,ִ߳Ȼ    */
}

static THREAD_MSG_HOOK_CONTENT* find_thread_content( ZOSS_THREAD_ID thread_id )
{
    THREAD_MSG_HOOK_CONTENT *p_content = (THREAD_MSG_HOOK_CONTENT *)zOss_ListFirst( &s_thread_msg_hook_list );
    while ( NULL != p_content )
    {
        if ( thread_id == p_content->thread_id )
        {
            break;
        }
        p_content = (THREAD_MSG_HOOK_CONTENT *)zOss_ListNext( (T_ZOss_Node *)p_content );
    }

    return p_content;
}

#ifdef _USE_THREADMSG_HOOK
static BOOL is_sender_task( VOID *senderId )
{
    ZOSS_TASK_ID task_id = zOss_GetSelfTaskID();
    if ( ZOSS_INVALID_TASK_ID != task_id )
    {
        *(UINT32 *)senderId = (UINT32)task_id;
        return TRUE;
    }
    else
    {
        *(UINT32 *)senderId = (UINT32)zOss_GetCurThreadID();
        return FALSE;
    }    
}

static UINT32 proc_thread_msg_hook( UINT8 dire, 
                                    UINT32 msg_id, 
                                    VOID *p_buf, 
                                    UINT16 buf_size, 
                                    ZOSS_THREAD_ID thread_id )
{
    UINT32 i = 0;
    
    THREAD_MSG_HOOK_CONTENT *p_content = find_thread_content( thread_id );
    if ( NULL == p_content )
    {
        return 0;
    }

    for ( ; i < THREAD_MSG_HOOK_TYPE_MAX; i++ )
    {
        if ( 0 != (dire & p_content->dire[i])  )
        {
            (VOID)(p_content->func[i]( msg_id, p_buf, buf_size, dire ));
        }
    }

    return (0 != (dire & p_content->dire[ZOSS_SETHOOKFLAG_INTER - 1])) ? ZOSS_SETHOOKFLAG_INTER : 0;
}

static UINT32 proc_task_msg_hook( UINT8 dire, 
                                  UINT32 msg_id, 
                                  VOID *p_buf, 
                                  UINT16 buf_size, 
                                  ZOSS_TASK_ID task_id )
{
    T_ZOss_TCB          *task_tcb   = (T_ZOss_TCB *)task_id;
    T_ZOss_TaskMsgHead  msg_head    = { 0 };
    UINT32              i           = 0;

    msg_head.msgID = msg_id;
    for ( ; i < THREAD_MSG_HOOK_TYPE_MAX; i++ )
    {
        if ( 0 != (dire & task_tcb->dire[i])  )
        {
            (VOID)(task_tcb->HookEntry[i]( &msg_head, dire ));
        }
    }

    return (0 != (dire & task_tcb->dire[ZOSS_SETHOOKFLAG_INTER - 1])) ? ZOSS_SETHOOKFLAG_INTER : 0;
}

static UINT32 proc_msg_hook( UINT32 msg_id, VOID *p_buf, UINT16 buf_size, ZOSS_THREAD_ID d_thread_id )
{
    VOID    *senderId   = NULL;
    UINT32  ret         = 0;
    
    if ( is_sender_task(&senderId) )
    {
        ret = proc_task_msg_hook( ZOSS_MSGDIRE_OUT, msg_id, p_buf, buf_size, (ZOSS_TASK_ID)senderId );
    }
    else
    {
        ret = proc_thread_msg_hook( ZOSS_MSGDIRE_OUT, msg_id, p_buf, buf_size, (ZOSS_THREAD_ID)senderId );
    }
    if ( ZOSS_SETHOOKFLAG_INTER == ret )
    {
        return ret;
    }

    ret = proc_thread_msg_hook( ZOSS_MSGDIRE_IN, msg_id, p_buf, buf_size, d_thread_id );
    return ret;
}
#endif
/**************************************************************************
* :  zOss_PsmSleep
* : (ʡ汾)ʹ߳˯һʱ,ƽ̨ʱģʼ
* ˵: (IN) time_in_ms: ߳˯ʱ,λΪ
*   ֵ:
* ˵:
**************************************************************************/
static VOID sleepCallBack(SINT32 th_param)
{
    zOss_PutSemaphore((ZOSS_SEMAPHORE_ID)th_param);
}

static VOID zOss_PsmSleep(UINT32 time_len)
{  
    UINT32          status      = 0;
    ZOSS_TIMER_ID   timerId     = NULL; 
    ZOSS_THREAD_ID  threadId    = zOss_GetCurThreadID();
    UINT32          iIndex      = 0;
    T_ZOsa_ThreadUserArea *ua   = NULL;

    if (time_len == 0 || threadId == NULL)
    {
        return;
    }

    zOss_AssertExN(get_ptype((PROCESS)threadId) == OS_PRI_PROC);
    iIndex = OSA_PID_TO_INDEX(threadId);
    ua     = gp_OsaThreadUserArea[iIndex];
    if(NULL == ua)
    {
        delay((OSTIME)time_len);
        return;
    }
    
    if(ua->sleepsem == NULL)
    {
        ua->sleepsem = zOss_CreateSemaphore("SleepSem", 0);
        zOss_AssertExN(ua->sleepsem != NULL);
    }
    timerId = zOss_CreateTimer("psmSleep", (ZOSS_TIMER_FUN)sleepCallBack, (SINT32)ua->sleepsem, FALSE);
    zOss_AssertExN(timerId != NULL);
    ua->sleepTimerId    = timerId;
    status = zOss_StartTimer(timerId, time_len, (ZOSS_TIMER_FUN)sleepCallBack, (SINT32)ua->sleepsem);
    zOss_AssertExN(status == ZOSS_SUCCESS);
    zOss_GetSemaphore(ua->sleepsem, ZOSS_WAIT_FOREVER);
    zOss_KillTimer(timerId);
    ua->sleepTimerId = NULL;    
}

/**************************************************************************
* :  obtain_timebase_frequency
* :
* ˵: (IN)    :
*   ֵ:
* ˵:
**************************************************************************/
static UINT32 obtain_timebase_frequency(VOID)
{
    UINT32 freq = 0;

    hwt_handle = (long int)biosOpen(HWTIMER_BIOSNAME);

    if (hwt_handle == 0)
    {
        return 0;
    }

    freq = hwtimer_freq(hwt_handle, -1);

    if (freq == 0)
    {
        OSPRIORITY  oldpri  = get_pri(current_process());
        UINT32         begin   = 0;

        set_pri(0);
        /* Short delay to synchronize with system tick. */
        delay(1);
        begin   = hwtimer_read(hwt_handle);
        delay(1000);
        freq    = hwtimer_read(hwt_handle) - begin;
        set_pri(oldpri);
        zOss_ASSERT(freq != 0);
    }

    return freq;
}

/**************************************************************************
* ȫֺʵ
**************************************************************************/

/**************************************************************************
* :  OSA_Init
* :  OSAģʼ,ڲϵͳʱ
* ˵:
*   ֵ:  ɹ:ZOSS_SUCCESS;ʧ:ZOSS_ERROR
* ˵:  ظʼZOSS_ERROR(ýӿδʼǰڴ\ͷŽӿ)
**************************************************************************/
UINT32 OSA_Init(VOID)
{
    static BOOL             bOsaInit    = TRUE;
    UINT32                  status      = ZOSS_ERROR;
    UINT32                  nRet        = ZOSS_SUCCESS;
    T_ZOsa_ThreadUserArea   **ua        = NULL;
    
    if (bOsaInit)
    {
        /*==========================================
                  Initialize Mem
         ==========================================*/
        nRet = MEM_Init();
        if (nRet != ZOSS_SUCCESS)
        {
            zOss_RamLog((CHAR *)"SysEntry: MEM_Init Fail, Code = 0x%x!", nRet);
            return nRet;
        }
        zOss_RamLog((CHAR *)"SysEntry(%u): MEM_Init Start OK!", zOss_GetTickCount());
      
        gOse_maxthreads = max_processes();
        if (gp_OsaThreadUserArea == NULL)/* · */
        {
            ua = (T_ZOsa_ThreadUserArea **)zOss_Malloc(gOse_maxthreads * sizeof (VOID *));
            zOss_AssertEx(ua != NULL, ZOSS_ERROR);
            zOss_Memset(ua, 0, gOse_maxthreads * sizeof (VOID *));
            gp_OsaThreadUserArea = ua;
        }  
        zOss_ListInit(&s_thread_msg_hook_list); /* Initialize Thread List Info,֧߳Ϣhook */

        FS_Init();

        Osa_SysErrHndInit();

        status      = ZOSS_SUCCESS;
        bOsaInit    = FALSE;
    }
    else
    {
        status = ZOSS_ERROR;
    }

    return status;
}

/**************************************************************************
* ƣ OSA_IdentifyThread
*  жһ߳ǷЧ
* ˵ (IN)
                  ZOSS_THREAD_ID : ߳ID
             (OUT)
*   ֵ ɹZOSS_SUCCESS;ʧܷZOSS_ERROR
* ˵ 
**************************************************************************/
UINT32 OSA_IdentifyThread( ZOSS_THREAD_ID threadID )
{
    return zOss_IdVerify(threadID);
}

/**************************************************************************
* : zOss_GetprioCfg
* : ȡȼֵ
* ˵: iIndex ȡֵΪ0~31
*   ֵ: ȷȼֵ󷵻ZOSS_ERROR
* ˵: iIndex ȡֵΪ0~31
**************************************************************************/
UINT32 zOss_GetPrioCfg(UINT8 offset)
{
    T_OSS_PARAM *pOssParam = NULL;

    zOss_AssertEx(offset <= 31, ZOSS_ERROR);

    pOssParam = zOss_GetOssCfg();

    if (NULL != pOssParam->OsaCfg.pPrioMap)
    {
        return (UINT32)(*(pOssParam->OsaCfg.pPrioMap))[offset];
    }
    else
    {
        return(UINT32)(offset);
    }
}
/**************************************************************************
* :  zOss_CreateThread
* :  ̴߳
* ˵:  (IN)   thread_name:߳;
                    entry:ûʵ庯
                    arg:߳ʵ庯Ĳ;
                    stack_size:߳ӵеĶջС;
                    priority:̵߳ȵȼ0-31;
                    preempt:ͬȼ߳Ƿռ,0ֵΪռ߳,
                            0ֵΪռ߳,ǷִʱƬ;
                    auto_start:̺߳ǷԶִ;

*   ֵ:  ɹ:߳ID;ʧ:ZOSS_INVALID_THREAD_ID
* ˵:
**************************************************************************/
ZOSS_THREAD_ID zOss_CreateThread(const CHAR *thread_name, VOID (*entry)(SINT32),
                                 SINT32 arg, UINT32 stack_size, UINT32 priority, UINT32 preempt, UINT32 auto_start)
{
    PROCESS                 Process_ID  = 0;
    enum PROCESS_TYPE       ProcessType = OS_PRI_PROC;
    OSTIME                  timeslice   = 0;
    UINT32                  iIndex      = 0;
    T_ZOsa_ThreadUserArea   *ua         = NULL;

    zOss_AssertEx(NULL != thread_name && 
                  NULL != entry && 
                  0 < stack_size && 
                  priority <= OSA_LOWESTPRIORITY, 
                  (ZOSS_THREAD_ID)ZOSS_INVALID_THREAD_ID);

    if (strlen((char *)thread_name) > MAX_THREADNAME_LEN)
    {
        return(ZOSS_THREAD_ID)ZOSS_INVALID_THREAD_ID;
    }

    if (0 == preempt)/* ռ */
    {
        timeslice = 0;
    }
    else
    {
        timeslice = OSA_TIMESLICE;
    }

    Process_ID = create_process(ProcessType, (char *)thread_name, Osa_OseThreadEntry,
                                (OSADDRESS)stack_size, (OSPRIORITY)priority, (OSTIME)timeslice,
                                (PROCESS) 0, (struct OS_redir_entry *) NULL, (OSVECTOR) 0, (OSUSER) 0);

    /* ʹset_envp()в */
    if (!set_envp((PROCESS)Process_ID, OSA_THREADFUN, (OSADDRESS)entry))
    {
        kill_proc(Process_ID);
        return(ZOSS_THREAD_ID)ZOSS_INVALID_THREAD_ID;
    }

    if (!set_envp((PROCESS)Process_ID, OSA_THREADARG, (OSADDRESS)arg))
    {
        kill_proc(Process_ID);
        return(ZOSS_THREAD_ID)ZOSS_INVALID_THREAD_ID;
    }

    if (!set_envp((PROCESS)Process_ID, OSA_THREADPREEMPT, (OSADDRESS)preempt))
    {
        kill_proc(Process_ID);
        return(ZOSS_THREAD_ID)ZOSS_INVALID_THREAD_ID;
    }

    iIndex = OSA_PID_TO_INDEX(Process_ID);

    if (!gOsa_SwapFlag)/* ûд߳лhook */
    {
        /* ƽ̨˳߳ûռͷţûռ*/
        if (NULL == gp_OsaThreadUserArea[iIndex])
        {
            ua = (T_ZOsa_ThreadUserArea *)zOss_Malloc(sizeof(T_ZOsa_ThreadUserArea));
            zOss_AssertEx(ua != NULL, (ZOSS_THREAD_ID)ZOSS_INVALID_THREAD_ID);
            gp_OsaThreadUserArea[iIndex] = ua;
        }
        else
        {
            /* ÷ƽ̨˳߳ûռδͷţֱʹ*/
            ua = gp_OsaThreadUserArea[iIndex];
        }        
        zOss_Memset(gp_OsaThreadUserArea[iIndex], 0, sizeof(T_ZOsa_ThreadUserArea));
    }
    else
    {
        ua = gp_OsaThreadUserArea[iIndex];
    }
    zOss_AssertEx(ua != NULL, (ZOSS_THREAD_ID)ZOSS_INVALID_THREAD_ID);
    /* ߳ûռ䲿Ϣ,ϢOsa_GetThreadUserAreaڸ */
    ua->threadid    = (ZOSS_THREAD_ID)Process_ID;
    ua->topstack    = 0;    /* Osa_GetThreadUserAreaʹøֵжԲи    */
    ua->heapsize    = 0;
    ua->ubsize      = 0;
    ua->ptrf        = 0;
    ua->curtaskid   = 0;
    ua->sleepsem    = NULL;

    if (auto_start != 0)
    {
        start(Process_ID);
    }

    return(ZOSS_THREAD_ID)Process_ID;
}

/**************************************************************************
* : zOss_ExitThread
* : ˳ǰ߳
* ˵:
*   ֵ:
* ˵:
**************************************************************************/
VOID zOss_ExitThread(VOID)
{
    T_ZOsa_ThreadUserArea   *ua         = NULL;
    PROCESS                 thread_id   = current_process();
    UINT32                  iIndex      = OSA_PID_TO_INDEX(thread_id);

    ua                           = gp_OsaThreadUserArea[iIndex];
    gp_OsaThreadUserArea[iIndex] = NULL;

    /* ose 78MƵ˳̵߳µGP0 */
#ifdef _USE_PSM
    zOss_PsmAdjustFreq312M();
#endif

    if (!gOsa_SwapFlag && ua)
    {
        if (ua->curpath)
        {
            zOss_Free(ua->curpath);/*ɾ̵߳ǰ·ռ*/
        }

        zOss_Free(ua);   /*ɾ߳ûռ*/
    }

    kill_proc(thread_id);
}

/**************************************************************************
* : zOss_SuspendThread
* : ߳
* ˵: (IN)  thread_id:߳ID;
*   ֵ: ɹ:ZOSS_SUCCESS;ʧ:ZOSS_ERROR
* ˵:
**************************************************************************/
UINT32 zOss_SuspendThread(ZOSS_THREAD_ID thread_id)
{
    UINT32          status = ZOSS_ERROR;
    struct OS_pcb   *pPcb  = NULL;

    zOss_AssertEx(NULL != thread_id, ZOSS_ERROR);

    pPcb = get_pcb((PROCESS)thread_id);

    if (NULL != pPcb && OS_ILLEGAL != pPcb->type && OS_ZOOMBIE != pPcb->type)   /* Ч߳ID */
    {
        stop((PROCESS)thread_id);
        status = ZOSS_SUCCESS;
    }
    else/* Ч߳ID */
    {
        status = ZOSS_ERROR;
    }

    if (NULL != pPcb)/* ͷſռ */
    {
        free_buf( (union SIGNAL **) &pPcb);
    }

    return status;
}

/**************************************************************************
* :  zOss_ResumeThread
* :  ָ̻߳ʹ̴̬߳ת״̬
* ˵:  (IN) thread_id:߳ID;
*   ֵ:  ZOSS_SUCCESS:ɹ;ZOSS_ERROR:ʧ
* ˵:
**************************************************************************/
UINT32  zOss_ResumeThread(ZOSS_THREAD_ID thread_id)
{
    struct OS_pcb   *pPcb   = NULL;
    UINT32          status  = ZOSS_ERROR;

    zOss_AssertEx(NULL != thread_id, ZOSS_ERROR);

    pPcb = get_pcb( (PROCESS)thread_id);

    if (NULL != pPcb && OS_ILLEGAL != pPcb->type && OS_ZOOMBIE != pPcb->type)   /* Ч߳ID */
    {
        start((PROCESS)thread_id);
        status = ZOSS_SUCCESS;
    }
    else
    {
        status = ZOSS_ERROR;
    }

    if (NULL != pPcb)/* ͷſռ */
    {
        free_buf( (union SIGNAL **) &pPcb);
    }

    return status;
}

/**************************************************************************
* : zOss_Sleep
* : ʹ߳˯һʱ
* ˵: (IN) time_in_ms: ߳˯ʱ,λΪ
*   ֵ:
* ˵:
**************************************************************************/
VOID zOss_Sleep(UINT32 time_in_ms)
{
    if (!Osa_GetTimerInitStatus())
    {
        delay((OSTIME)time_in_ms);
    }
    else
    {
        zOss_PsmSleep(time_in_ms);
    }   
}

/**************************************************************************
* : zOss_DeleteThread
* : ߳ɾ
* ˵: (IN)    thread_id:߳ID
*   ֵ: ZOSS_SUCCESS:ɹ;ZOSS_ERROR:ʧ
* ˵:
**************************************************************************/
UINT32  zOss_DeleteThread(ZOSS_THREAD_ID thread_id)
{
    UINT32 iIndex;
    T_ZOsa_ThreadUserArea *ua = NULL;

    zOss_AssertEx(NULL != thread_id, ZOSS_ERROR);

    if (ZOSS_ERROR == zOss_IdVerify(thread_id))   /* Ч߳ID */
    {
        return  ZOSS_ERROR;
    }

    iIndex                       = OSA_PID_TO_INDEX(thread_id);
    ua                           = gp_OsaThreadUserArea[iIndex];
    gp_OsaThreadUserArea[iIndex] = NULL;

    if ((PROCESS)thread_id == current_process())/* ɱ */
    {
        if (!gOsa_SwapFlag && ua)
        {
            if (ua->curpath)
            {
                zOss_Free(ua->curpath);/* ɾ̵߳ǰ·ռ */
            }

            zOss_Free(ua);   /* ɾ߳ûռ */
        }

        kill_proc((PROCESS)thread_id);
    }
    else
    {
        kill_proc((PROCESS)thread_id);

        if (!gOsa_SwapFlag && ua)
        {
            if (ua->curpath)
            {
                zOss_Free(ua->curpath);/* ɾ̵߳ǰ·ռ */
            }

            if (ua->sleepTimerId)
            {
                zOss_KillTimer(ua->sleepTimerId);
            }

            zOss_Free(ua);   /* ɾ߳ûռ */
        }
    }

    return ZOSS_SUCCESS;
}

/**************************************************************************
* : zOss_GetCurThreadID
* : ȡǰ̵߳ID
* ˵:
*   ֵ: ɹ:ǰ̵߳ID;ʧ:ZOSS_INVALID_THREAD_ID
* ˵:
**************************************************************************/
ZOSS_THREAD_ID zOss_GetCurThreadID(VOID)
{
    return (ZOSS_THREAD_ID)current_process();
}

/**************************************************************************
* : zOss_GetThreadIDByName
* : ߳ȡ߳ID
* ˵: (IN)        thread_name:߳
*   ֵ: ɹ:ǰ̵߳ID;ʧ:ZOSS_INVALID_THREAD_ID;
* ˵:
**************************************************************************/
ZOSS_THREAD_ID zOss_GetThreadIDByName (const CHAR *thread_name)
{
    PROCESS     thread_id   = 0;
    OSBOOLEAN   status      = hunt((char *)thread_name, 0, &thread_id, NULL);/*  */

    if (status)/* ȡɹ */
    {
        return(ZOSS_THREAD_ID)thread_id;
    }
    else
    {
        return ZOSS_INVALID_THREAD_ID;
    }
}

/**************************************************************************
* :     ݲṩ߳idȡ̵߳߳
* ˵:     
*   ()  thread_id:      ȡ߳Ƶ߳id
*   ()  thread_name:    ߳ƴŵַ
*   ֵ:     ɹָ߳룻ϵͳԻ򷵻ؿָ
* ˵:     OSEϵͳУget_pcbӿڻȡ߳ϢҪ߳
                ƴϢпûṩ߳ƴŵַȻͷŸ
                Ϣthread_nameΪǿָ룬ķֵʼΪ
                ûthread_name
**************************************************************************/
CHAR *zOss_GetThreadName(ZOSS_THREAD_ID thread_id, CHAR *thread_name)
{
    struct OS_pcb *pPcb = NULL;

    zOss_AssertEx(NULL != thread_id, NULL);
    zOss_AssertEx(NULL != thread_name, NULL);

    pPcb = get_pcb((PROCESS)thread_id);
    if(NULL == pPcb)
    {
        return NULL;
    }

    if(OS_ILLEGAL == pPcb->type || OS_ZOOMBIE == pPcb->type)
    {
        free_buf((union SIGNAL **)&pPcb);
        return NULL;
    }

    strcpy((char *)thread_name, &pPcb->strings[pPcb->name]);
    free_buf((union SIGNAL **)&pPcb);

    return thread_name;
}

/**************************************************************************
* : zOss_GetThreadInfo
* : ߳IDȡ߳ϸϢ
* ˵: (IN)
                 thread_id:̵߳ID;
            (OUT)
                 thread_name:߳,û߳ռ
                 stat:̵߳״̬,ͬλвͬϢ
                 priority:0-31
                 preempt:0ֵΪռ,Ƿط0ֵ
*   ֵ: ZOSS_SUCCESS:ɹ;ZOSS_ERROR:ʧ
* ˵:
**************************************************************************/
UINT32 zOss_GetThreadInfo(ZOSS_THREAD_ID thread_id, CHAR *thread_name, UINT32 *stat,
                          UINT32 *priority, UINT32 *preempt)
{
    struct OS_pcb   *pPcb       = NULL;
    char            *name       = NULL;
    PROCESS         process_id  = (PROCESS)thread_id;
    
    zOss_AssertEx(NULL != thread_id, ZOSS_ERROR);
    
    pPcb = get_pcb(process_id);
    if(NULL == pPcb)
    {
        return ZOSS_ERROR;
    }
    
    if(OS_ILLEGAL == pPcb->type || OS_ZOOMBIE == pPcb->type)
    {
        free_buf((union SIGNAL **)&pPcb);
        return ZOSS_ERROR;
    }
    
    /* Ч߳ID */
    if (NULL != thread_name)
    {
        name = &pPcb->strings[pPcb->name];/* pcbеnameָpcbstringsеƫ */
        strcpy((char *)thread_name, name);
    }
    
    if (NULL != stat)
    {
        if (pPcb->status == 0) /* running or ready sets none bits */
        {
            if (process_id == current_process()) /* current is running */
            {
                *stat = ZOSS_OS_RUN;
            }
            else /* or ready */
            {
                *stat = ZOSS_OS_READY;
            }
        }
        else
        {
            *stat = ZOSS_OS_BLOCK;
        }
    }
    
    if (NULL != priority)
    {
        *priority = (UINT32)(pPcb->priority);
    }
    
    if (NULL != preempt)
    {
        *preempt = (UINT32)get_envp(process_id, OSA_THREADPREEMPT);
    }
    
    free_buf((union SIGNAL **)&pPcb);
    return ZOSS_SUCCESS;
}

/**************************************************************************
* : zOss_SetThreadPri
* : ߳ȼ
* ˵: (IN)  thread_id:̵߳ID
                  priority:߳ȼ
*   ֵ: óɹ, ZOSS_SUCCESS; 򷵻ZOSS_ERROR
* ˵:
**************************************************************************/
UINT32  zOss_SetThreadPri(ZOSS_THREAD_ID thread_id, UINT32 priority)
{
    OSPRIORITY OldPrio  = 0;
    OSPRIORITY Prio     = 0;

    if (ZOSS_ERROR == zOss_IdVerify(thread_id))/* Ч߳ID,zOss_IdVerify()ںthread_id */
    {
        return  ZOSS_ERROR;
    }

    zOss_AssertEx(priority <= OSA_LOWESTPRIORITY, ZOSS_ERROR);

    OldPrio = get_pri((PROCESS )thread_id);

    if (OldPrio == (OSPRIORITY)priority)   /* ¾߳ȼһ, */
    {
        return ZOSS_SUCCESS;
    }
    else
    {
        Prio = set_pri_for((PROCESS)thread_id, (OSPRIORITY)priority);
    }

    if (Prio == OldPrio)   /* ߳ȼʧ */
    {
        return ZOSS_ERROR;
    }
    else
    {
        return ZOSS_SUCCESS;
    }
}

/**************************************************************************
* :  zOss_GetThreadPri
* : ȡ߳ȼ
* ˵: (IN)    thread_id:̵߳ID
                 (OUT)    priority:߳ȼ
*   ֵ: ȡɹ, ZOSS_SUCCESS; 򷵻ZOSS_ERROR
* ˵:
**************************************************************************/
UINT32 zOss_GetThreadPri(ZOSS_THREAD_ID thread_id, UINT32 *priority)
{
    OSPRIORITY  Prio    = 0;
    UINT32      status  = zOss_IdVerify(thread_id);

    /* Ч߳ID,zOss_IdVerify()ںthread_id */
    zOss_AssertEx(NULL != priority && ZOSS_ERROR != status, ZOSS_ERROR);

    Prio        = get_pri((PROCESS)thread_id);
    *priority   = (UINT32)Prio ;
    return ZOSS_SUCCESS;
}

/**************************************************************************
* :     ֤һ߳ǷЧ
* ˵:     
*   ()  thread_id:  ֤߳id
*   ()  void
*   ֵ:     ߳ЧZOSS_SUCCESSϵͳ
* ˵:     void
**************************************************************************/
UINT32 zOss_IdentifyThread(ZOSS_THREAD_ID threadID)
{
    return zOss_IdVerify(threadID);
}

/*******************************************************************************
* : ȡ߳ûݿռָ
* ˵:     
*           ()    thread_id:  ȡûݿռָ߳id
*           ()    VOID
*   ֵ: ̵߳ûݿռָ
* ˵: VOID
*******************************************************************************/
T_ZOsa_ThreadUserArea *zOss_GetThreadUserArea(ZOSS_THREAD_ID thread_id)
{
    UINT32                  thread_index    = 0;
    T_ZOsa_ThreadUserArea   *user_area      = NULL;

    zOss_ASSERT(thread_id != NULL);
    thread_index    = OSA_PID_TO_INDEX(thread_id);
    user_area       = gp_OsaThreadUserArea[thread_index];
    
    return user_area;
}

/**************************************************************************
* : zOss_SendMsg
* : Ϣ,㿽,͵ָ
* ˵: (IN)  thread_id:
                  msg_ptr:zOss_GetUB()صϢַָ
                  size:ʵռֽ
                  timeout:Ϣʱ,ȴʱ.ò ֧,
                           .ܱ֤ȷϢ
*   ֵ: ZOSS_SUCCESS:ɹ;ZOSS_ERROR:ʧ.
* ˵:
**************************************************************************/
UINT32 zOss_SendMsg(ZOSS_THREAD_ID thread_id, VOID *msg_ptr, UINT32 size, UINT32 timeout)
{
    T_OsaMsgSig* pmsgsig = NULL;

    zOss_AssertEx(msg_ptr != NULL && thread_id != NULL, ZOSS_ERROR);

    /* sigalָתԶ׼signal,ʧΪ
    OSE쳣迼 */
    pmsgsig             = (T_OsaMsgSig *)alloc(sizeof(T_OsaMsgSig), SIGNAL_MSG_NUMBER);
    pmsgsig->msg_ptr    = msg_ptr;
    pmsgsig->size       = size;/* ʵϢĳ */
    send((union SIGNAL **)&pmsgsig, (PROCESS)thread_id);
    return ZOSS_SUCCESS;
}

/**************************************************************************
* : zOss_RecvMsg
* : շ͸̵߳Ϣ,㿽,յָ
                û,zOss_RetUB()ͷ
* ˵: (IN)    msg_ptr:ָϢָ
                    size:ռֽ,ΪNULL
                    timeout:Ϣпʱ,ȴʱ.
*   ֵ: ZOSS_SUCCESS:ɹ;ZOSS_ERROR:ʧ.
* ˵: жϺʱ,ʱtimeoutĬΪZOSS_NO_WAIT,
*           ҲֻOSS_NO_WAIT.,ڲΪOSS_NO_WAIT.
*           ʱ,úǷʽ.
**************************************************************************/
UINT32 zOss_RecvMsg(VOID **msg_ptr, UINT32 *size, UINT32  timeout)
{
    static const SIGSELECT  any_sig[]   = {0};
    T_OsaMsgSig             *pmsgsig    = NULL;
    UINT32                  status      = 0;

    zOss_AssertEx(msg_ptr != NULL && size != NULL, ZOSS_ERROR);

    if (ZOSS_WAIT_FOREVER == timeout)
    {
        pmsgsig = (T_OsaMsgSig *)receive(any_sig);

        if (NIL != (union SIGNAL *)pmsgsig && pmsgsig->sig_no == SIGNAL_MSG_NUMBER)
        {
            *msg_ptr    = pmsgsig->msg_ptr;
            *size       = pmsgsig->size;
            free_buf((union SIGNAL **)&pmsgsig);
            status      = ZOSS_SUCCESS;
        }
        else if (NIL != (union SIGNAL *)pmsgsig && pmsgsig->sig_no != SIGNAL_MSG_NUMBER)
        {
            free_buf((union SIGNAL **)&pmsgsig);
            status = ZOSS_ERROR;
        }
        else
        {
            status = ZOSS_ERROR;
        }
    }
    else
    {
        pmsgsig = (T_OsaMsgSig *)receive_w_tmo((OSTIME)timeout, any_sig);

        if ((union SIGNAL *)pmsgsig != NIL && pmsgsig->sig_no == SIGNAL_MSG_NUMBER)
        {
            *msg_ptr    = pmsgsig->msg_ptr;
            *size       = pmsgsig->size;
            free_buf((union SIGNAL **)&pmsgsig);
            status      = ZOSS_SUCCESS;
        }
        else if (NIL != (union SIGNAL *)pmsgsig && pmsgsig->sig_no != SIGNAL_MSG_NUMBER)
        {
            free_buf((union SIGNAL **)&pmsgsig);
            status = ZOSS_ERROR;
        }
        else
        {
            status = ZOSS_ERROR;
        }
    }

    return status;
}

VOID* zOss_ThreadGetMsgBuf( UINT32 size )
{
    T_THREAD_MSG_HEAD *p_msg_head = NULL;
    
    zOss_AssertEx( 0 != size, NULL );
    
    p_msg_head = (T_THREAD_MSG_HEAD *)alloc( THREAD_MSG_SIZE(size), SIGNAL_MSG_NUMBER );
    zOss_AssertEx( p_msg_head != NULL, NULL );

    p_msg_head->magic = THREAD_MSG_MAGIC;

    return THREAD_MSG_BUF(p_msg_head);
}

VOID zOss_ThreadRetMsgBuf( VOID *p_buf )
{
    T_THREAD_MSG_HEAD *p_msg_head = NULL;
    
    zOss_AssertExN( p_buf != NULL );

    p_msg_head = THREAD_MSG_HEAD( p_buf );

    free_buf( (union SIGNAL **)&p_msg_head );
}

UINT32 zOss_ThreadSendMsg( UINT32 msg_id, VOID *p_buf, UINT16 buf_size, ZOSS_THREAD_ID thread_id )
{
    T_THREAD_MSG_HEAD   *p_msg_head = NULL;
    UINT32              status      = OSA_IdentifyThread(thread_id);

    zOss_AssertEx(  status == ZOSS_SUCCESS, ZOSS_ERROR );

#ifdef _USE_THREADMSG_HOOK
    if ( ZOSS_SETHOOKFLAG_INTER == proc_msg_hook(msg_id, p_buf, buf_size, thread_id) )
    {
        if ( NULL != p_buf )
        {
            zOss_ThreadRetMsgBuf( p_buf );
        }
        return ZOSS_SUCCESS;
    }
#endif

    if ( (NULL == p_buf) || (0 == buf_size) )
    {
        buf_size = 0;   /* make sure the bufer size is zero */

        /* for emtpy message, buffer should be alloced by ourself */
        p_msg_head          = (T_THREAD_MSG_HEAD *)alloc( THREAD_MSG_SIZE(0), SIGNAL_MSG_NUMBER );
        zOss_AssertEx( p_msg_head != NULL, ZOSS_ERROR );
        p_msg_head->magic   = THREAD_MSG_MAGIC;
    }
    else
    {
        p_msg_head = THREAD_MSG_HEAD( p_buf );
        zOss_AssertEx( THREAD_MSG_MAGIC == p_msg_head->magic, ZOSS_ERROR );
    }
    p_msg_head->id       = msg_id;
    p_msg_head->buf_size = buf_size;

    send( (union SIGNAL **)&p_msg_head, (PROCESS)thread_id );

    return ZOSS_SUCCESS;
}

UINT32 zOss_ThreadRecvMsg( UINT32 *p_msg_id, VOID **p_buf, UINT32 *p_buf_size, UINT32 timeout )
{
    T_THREAD_MSG_HEAD       *p_msg_head = NULL;
    static const SIGSELECT  any_sig[]   = { 0 };

    zOss_AssertEx( (p_msg_id != NULL) && (p_buf != NULL) && (p_buf_size != NULL), ZOSS_ERROR );

    if ( ZOSS_WAIT_FOREVER == timeout )
    {
        p_msg_head = (T_THREAD_MSG_HEAD *)receive( any_sig );
    }
    else
    {
        p_msg_head = (T_THREAD_MSG_HEAD *)receive_w_tmo( (OSTIME)timeout, any_sig );
    }
    zOss_AssertEx( THREAD_MSG_MAGIC == p_msg_head->magic, ZOSS_ERROR );

    *p_msg_id   = p_msg_head->id;
    *p_buf_size = p_msg_head->buf_size;
    if ( 0 == p_msg_head->buf_size )
    {
        *p_buf  = NULL;
        /* for empty message, buffer is alloced by ourself */
        free_buf( (union SIGNAL **)&p_msg_head );
    }
    else
    {
        *p_buf  = THREAD_MSG_BUF( p_msg_head );
    }

    return ZOSS_SUCCESS;
}

UINT32 zOss_RegThreadMsgHook( ZOSS_THREAD_ID thread_id, UINT8 type, UINT8 dire, THREAD_MSG_HOOK func )
{
    THREAD_MSG_HOOK_CONTENT *p_content  = NULL;
    UINT32                  status      = OSA_IdentifyThread(thread_id);
    zOss_AssertEx( ((ZOSS_SUCCESS == status)&& 
                    (THREAD_MSG_HOOK_TYPE_MAX >= type) && 
                    (THREAD_MSG_HOOK_DIRE_MAX >= dire) && 
                    (NULL != func)), 
                    ZOSS_ERROR );
    
    p_content = find_thread_content( thread_id );
    if ( NULL == p_content )
    {
        p_content = (THREAD_MSG_HOOK_CONTENT *)zOss_Malloc( sizeof(THREAD_MSG_HOOK_CONTENT) );
        zOss_Memset( p_content, 0, sizeof(THREAD_MSG_HOOK_CONTENT) );
        p_content->thread_id = thread_id;
        zOss_ListAdd( &s_thread_msg_hook_list, (T_ZOss_Node *)p_content );
    }

    p_content->dire[type - 1] = dire;
    p_content->func[type - 1] = func;

    return ZOSS_SUCCESS;
}

/**************************************************************************
* : zOss_CreateSemaphore
* : ź
* ˵: (IN)   name_ptr:ź,˴,óNULL
                   initial_count:źĳʼ״̬, ΪǸ,ͨΪ01;
*   ֵ: ɹ:źID;ʧ:ZOSS_NULL
* ˵:
**************************************************************************/
ZOSS_SEMAPHORE_ID zOss_CreateSemaphore(const CHAR *name_ptr, UINT32 initial_count)
{
    if (name_ptr)
    {
        name_ptr = name_ptr;
    }

    return (ZOSS_SEMAPHORE_ID)create_sem((OSSEMVAL) initial_count);
}

/**************************************************************************
* : zOss_GetSemaphore
* : ȡź
* ˵: (IN)   sem_id:źID
                   timeout:ȴ,ΪZOSS_WAIT_FOREVER,OSS_NO_WAIT.
                   timeoutʱ䲻֧ZOSS_NO_WAITͬԴ
*   ֵ: ȡɹ, ZOSS_SUCCESS; 򷵻ZOSS_ERROR
* ˵:
**************************************************************************/
UINT32 zOss_GetSemaphore(ZOSS_SEMAPHORE_ID sem_id,  UINT32 timeout)
{
    OSPRIORITY  OldPri = 0;
    SINT32      count  = 0;

    zOss_AssertEx(sem_id != NULL, ZOSS_ERROR);
    OldPri = get_pri(current_process());

    if ((ZOSS_WAIT_FOREVER == timeout) || (0 > (SINT32)timeout))   /* һֱȴ */        
    {
        wait_sem((SEMAPHORE *)sem_id);
        return ZOSS_SUCCESS;
    }
    else if (ZOSS_NO_WAIT == timeout)
    {
        set_pri(0);   /* ʱѽȼ,ֹл */

        if (get_sem((SEMAPHORE *)sem_id) > 0)
        {
            wait_sem((SEMAPHORE *)sem_id);
            set_pri(OldPri);                           /* ԭĽȼ */
            return ZOSS_SUCCESS;
        }
        else
        {
            set_pri(OldPri);                           /* ԭĽȼ */
            return ZOSS_ERROR;
        }
    }
    else
    {
        count = (SINT32)timeout;

        while (count > 0)
        {
            if (get_sem((SEMAPHORE *)sem_id) > 0)
            {
                wait_sem((SEMAPHORE *)sem_id);
                return ZOSS_SUCCESS;
            }

            delay(OSA_TIMEOUT_INTERVAL);
            count -= OSA_TIMEOUT_INTERVAL;
        }

        return ZOSS_ERROR;
    }
}
/**************************************************************************
* : zOss_PutSemaphore
* : ͷź
* ˵: (IN)   sem_id:źID
*   ֵ: ɹ:ZOSS_SUCCESS; ʧ:ZOSS_ERROR
* ˵:
**************************************************************************/
UINT32 zOss_PutSemaphore(ZOSS_SEMAPHORE_ID sem_id)
{
    zOss_AssertEx(sem_id != NULL, ZOSS_ERROR);

    signal_sem((SEMAPHORE *)sem_id);
    return(UINT32)ZOSS_SUCCESS;
}

/**************************************************************************
* : zOss_GetSemaphoreCount
* : ȡźֵ
* ˵: (IN)   sem_id:źID
*   ֵ: ɹ, صǰֵ; 򷵻ZOSS_ERROR
* ˵: Чsem_id,ܻϵͳ쳣
**************************************************************************/
UINT32 zOss_GetSemaphoreCount(ZOSS_SEMAPHORE_ID sem_id)
{
    OSSEMVAL result = 0;
    
    zOss_AssertEx(sem_id != NULL, ZOSS_ERROR);

    result = get_sem((SEMAPHORE *) sem_id);
    result = result < 0 ? 0 : result;/* oseźΪֵϵͳһ */
    return(UINT32)result;
}

/**************************************************************************
* : OSS_DeleteSemaphore
* : ɾź
* ˵: (IN)        sem_id:źID
*   ֵ: ɹ:OSS_SUCCESS;ʧ:ZOSS_ERROR
* ˵: ɾ̬ź
**************************************************************************/
UINT32 zOss_DeleteSemaphore(ZOSS_SEMAPHORE_ID sem_id)
{
    zOss_AssertEx(sem_id != NULL, ZOSS_ERROR);

    if (0 <= get_sem((SEMAPHORE *)sem_id))   /* źûбʹ,԰ȫɾ */
    {
        kill_sem((SEMAPHORE *)sem_id);
        return ZOSS_SUCCESS;
    }
    else
    {
        return ZOSS_ERROR;
    }
}

/**************************************************************************
* : zOss_CreateMutex
* : 
* ˵: (IN)name_ptr:ָ,˴,óNULL.
                priority_inherit:ZOSS_INHERIT,ȼȡ;
                                 ZOSS_NO_INHERIT,˳ȡ.
*   ֵ: ɹ,ػźָ;,ZOSS_NULL
* ˵: default:ZOSS_NO_INHERIT
**************************************************************************/
ZOSS_MUTEX_ID zOss_CreateMutex(const CHAR *name_ptr, UINT32 priority_inherit)
{
    MUTEX       *mutex_id   = NULL;
    OSADDRESS   attr        = 0;

    if (name_ptr)
    {
        name_ptr = name_ptr;
    }

    mutex_id = (MUTEX *)malloc(sizeof(MUTEX)); /* ƽ̨װmem_mallocлڻ崴
                                                   ޸Ļѭ */

    if (NULL == mutex_id)   /* û㹻Ŀռ */
    {
        return(ZOSS_MUTEX_ID)NULL;
    }

    if (ZOSS_NO_INHERIT == priority_inherit)
    {
        attr =  OSE_MUTEX_RECURSIVE;    /* ͬһ߳̿ԶεOSS_GetMutex() */
    }
    else/*ZOSS_INHERIT*/
    {
        /* ȼȡ,ͬһ߳̿ԶεzOss_GetMutex() */
        attr = OSE_MUTEX_PRIO_INHERIT | OSE_MUTEX_RECURSIVE;
    }

    ose_mutex_init(mutex_id, attr);

    return(ZOSS_MUTEX_ID)mutex_id;

}

/**************************************************************************
* :  zOss_GetMutex
* : ȡ
* ˵: (IN) mutex_id:ID
                 timeout:ZOSS_WAIT_FOREVER,һֱȴ
                         ZOSS_NO_WAIT,
                         :ȴʱʱ,λms,
                                 ZOSS_NO_WAITͬԴ.
*   ֵ: ZOSS_SUCCESS:ȡɹ;ZOSS_ERROR:ȡʧ.
* ˵: ͬһ߳̿ԶεzOss_GetMutex(),
            zOss_PutMutex()ɶʹ
**************************************************************************/
UINT32 zOss_GetMutex( ZOSS_MUTEX_ID mutex_id,  UINT32 timeout)
{
    zOss_AssertEx(mutex_id != NULL, ZOSS_ERROR);

    if ((ZOSS_WAIT_FOREVER == timeout) || (0 > (SINT32)timeout))   /* һֱȴ */
    {
        ose_mutex_lock((MUTEX *)mutex_id);
        return ZOSS_SUCCESS;
    }
    else if (ZOSS_NO_WAIT == timeout)
    {
        if (ose_mutex_trylock((MUTEX *)mutex_id) != 0 )
        {
            return ZOSS_SUCCESS;
        }
    }
    else/* ʱ */
    {
        UINT32 count   = timeout;

        while (count > 0)
        {
            if (ose_mutex_trylock((MUTEX *)mutex_id) != 0 )
            {
                return ZOSS_SUCCESS;
            }
            delay(OSA_TIMEOUT_INTERVAL);
            count -= OSA_TIMEOUT_INTERVAL;
        }
    }

    return ZOSS_ERROR;
}

/**************************************************************************
* : zOss_PutMutex
* : ͷŻź.ͻȡź
*           zOss_GetMutex()ɶʹ,ͬһ߳̿Զεøú.
* ˵: (IN)    mutex_id:ID
*   ֵ: ZOSS_SUCCESS:ͷųɹ;ZOSS_ERROR:ͷʧ.
* ˵:
**************************************************************************/
UINT32 zOss_PutMutex(ZOSS_MUTEX_ID mutex_id)
{
    zOss_AssertEx(mutex_id != NULL, ZOSS_ERROR);

    ose_mutex_unlock((MUTEX *)mutex_id);/* Чmutex_idOSE쳣 */
    return ZOSS_SUCCESS;
}

/**************************************************************************
* : zOss_DeleteMutex
* : ɾ
* ˵: (IN)    mutex_id:ID
*   ֵ: ZOSS_SUCCESS:ɾɹ;ZOSS_ERROR:ɾʧ.
* ˵: ɾһʹõĻ彫ϵͳ
**************************************************************************/
UINT32 zOss_DeleteMutex(ZOSS_MUTEX_ID mutex_id)
{
    zOss_AssertEx(mutex_id != NULL, ZOSS_ERROR);

    ose_mutex_destroy((MUTEX *)mutex_id);   /* Чmutex_idOSE쳣  */
    free(mutex_id);                         /* ͷڴ                     */
    return ZOSS_SUCCESS;
}

/**************************************************************************
* : zOss_GetTickCount
* : ϵͳӵ󵽵ǰtick,tickλɲϵͳãOSE
            ϵͳãkrn/system_timer= 1 ʾ 1 tick = 1 ms
* ˵:
*   ֵ: tick
* ˵:  
**************************************************************************/
UINT32 zOss_GetTickCount(VOID)
{
#ifdef _USE_PSM
# ifdef _USE_PSM_NEW_FRAMEWORK
    return (UINT32)(get_ticks() + zOss_CompensateTicks());
# else
    return (UINT32)(get_ticks() + zOss_GetSleepTimeForTicks());
# endif
#else
    return (UINT32)(get_ticks());
#endif
}

/**************************************************************************
* : Osa_GetThreadUserArea
* : ʾ߳ϸϢ
* ˵: (IN)
                thread_id:߳ID
*   ֵ: ɹ:߳ûռָ;ʧ:
* ˵: ߳лhookУbupdateֻΪFALSE,߳ID
*           Чж
**************************************************************************/
T_ZOsa_ThreadUserArea *Osa_GetThreadUserArea(ZOSS_THREAD_ID thread_id, BOOL bupdate)
{
    struct OS_pcb           *pPcb       = NULL;
    T_ZOsa_ThreadUserArea   *ua         = NULL;
    UINT32                  iIndex      = 0;
    UINT32                  *pbot       = NULL;
    UINT32                  *ptop       = NULL;
    ZOSS_THREAD_ID          cur_id      = NULL;

    zOss_AssertEx(thread_id != NULL, NULL);

    iIndex = OSA_PID_TO_INDEX(thread_id);

    if (!bupdate)
    {
        if (iIndex < gOse_maxthreads && gp_OsaThreadUserArea[iIndex] != NULL && gp_OsaThreadUserArea[iIndex]->threadid == thread_id)
        {
            return gp_OsaThreadUserArea[iIndex];
        }
        else
        {
            return NULL;/* Ч߳ID */
        }
    }

    pPcb = get_pcb((PROCESS)thread_id);

    if (pPcb == NULL || OS_ILLEGAL == pPcb->type || OS_ZOOMBIE == pPcb->type)   /* Ч߳ID */
    {
        return NULL;
    }

    if (!gp_OsaThreadUserArea[iIndex])/* zOss_CreateThread߳ */
    {
        ua = (T_ZOsa_ThreadUserArea *)zOss_Malloc(sizeof(T_ZOsa_ThreadUserArea));
        zOss_AssertEx(ua != NULL, NULL);
        zOss_Memset(ua, 0, sizeof(T_ZOsa_ThreadUserArea));
        ua->threadid = thread_id;
        gp_OsaThreadUserArea[iIndex] = ua;
    }
    else
    {
         ua = gp_OsaThreadUserArea[iIndex];
    }

    cur_id          = zOss_GetCurThreadID();
    ua->priority    = (UINT8)(pPcb->priority);

    if (ua->topstack == 0)
    {
        /* pcbеnameָpcbstringsеƫ */
        strncpy((char *)ua->threadname, &pPcb->strings[pPcb->name], 16);
        ua->threadname[15]  = 0;
        ua->topstack        = pPcb->stack_limit;    /* ջ͵ַ,TRACE32һ */
        ua->stacksize       = (pPcb->stack_top - pPcb->stack_limit) + 1;
        ua->threadid        = thread_id;
        ua->heapsize        = 0xFFFFFFFF;           /* mallocͳδʵ         */
    }

    ua->msgnum = pPcb->sig_cnt_in_q;
    if (ua->runtime > 0)
    {
        ua->RunTimeInMs = ua->runtime / 1000;   /* runtimeλ:΢ */
//        ua->RunTimeInMs = (UINT32)((FLOAT)ua->runtime / (gOsa_SysCpuFreq / 1000));
    }

    /* ջʹ */
    pbot = (UINT32 *)pPcb->stack_limit;
    ptop = (UINT32 *)pPcb->stack_top + 1;

    while (pbot < ptop && *pbot == 0xEEEEEEEE)
    {
        pbot++;
    }

    if (pbot < ptop)
    {
        ua->maxstack = (UINT8)(((UINT32)ptop - (UINT32)pbot) * 100 / ua->stacksize);
    }
    else/* ջδʹ */
    {
        ua->maxstack = 0;
    }

    switch (pPcb->status)
    {
    case 0:
        if (thread_id == cur_id)
        {
            ua->runstatus = ZOSS_OS_RUN;
        }
        else
        {
            ua->runstatus = ZOSS_OS_READY;
        }
        
        break;
    default:/*OS_RECEIVE,OS_DELAY,OS_SEMAPHORE,OS_FSEMAPHORE,OS_REMOTE,OS_STOPPED and OS_INTERCEPTED */
        ua->runstatus = ZOSS_OS_BLOCK;
        break;
    }

    free_buf( (union SIGNAL **) &pPcb);
    return ua;
}

/**************************************************************************
* : Osa_GetAllThreadId
* : ȡ߳ID
* ˵: (IN)
            (OUT)
                  threadarray:߳IDָ
*   ֵ: ߳
* ˵: ߳Ϊ0ʱ,ռûͷ
**************************************************************************/
UINT32 Osa_GetAllThreadId(ZOSS_THREAD_ID *threadarray[])
{
    struct OS_pid_list  *bidlist    = NULL;
    struct OS_pid_list  *pidlist    = NULL;
    UINT8               i           = 0;
    UINT8               j           = 0;
    UINT32              count       = 0;
    ZOSS_THREAD_ID      *thread_id  = NULL;

    count       = (UINT32)gOse_maxthreads;
    thread_id   = (ZOSS_THREAD_ID *)zOss_Malloc(count * sizeof(ZOSS_THREAD_ID));
    zOss_AssertEx(thread_id != NULL, 0);
    bidlist     = get_bid_list(0);
    count       = 0;

    for (i = 0; i < bidlist->count; i++)
    {
        pidlist = get_pid_list(bidlist->list[i]);

        for (j = 0; j < pidlist->count; j++)
        {
            thread_id[count] = (ZOSS_THREAD_ID)pidlist->list[j];
            count++;
        }

        free_buf((union SIGNAL **) &pidlist);
    }

    free_buf((union SIGNAL **) &bidlist);

    if (count > 0)
    {
        *threadarray = thread_id;
    }
    else
    {
        zOss_Free(thread_id);
        *threadarray = NULL;
    }

    return count;
}

/**************************************************************************
* :  Osa_create_handler
* :
* ˵: (IN)    thread_id:
*   ֵ: ɹ:task_id;ʧ:NULL
* ˵:
**************************************************************************/
VOID Osa_create_handler(T_ZOsa_ThreadUserArea *ua, PROCESS pid, PROCESS parent_pid)
{
    UINT32 iIndex = OSA_PID_TO_INDEX(pid);

    if (0 == gOsa_SysCpuFreq)
    {
        gOsa_SwapFlag       = TRUE;
        gOsa_SwapLastTime   = Osa_HwTimeRead();
#if defined (_USE_PSM) && defined (_USE_CPU_DFM)
        zOss_RecordPsmLastSwapTime();
#endif
        gOsa_SysCpuFreq     = obtain_timebase_frequency();
    }

    zOss_AssertExN(ua != NULL);
    zOss_Memset(ua, 0, sizeof(T_ZOsa_ThreadUserArea));
    
    ua->threadid    = (ZOSS_THREAD_ID)pid;
    ua->runcount    = 0;
    ua->cputime     = 0;
    ua->psmCpuTime  = 0;
    if (gp_OsaThreadUserArea != NULL)
    {
        gp_OsaThreadUserArea[iIndex] = ua;
    }
}

/**************************************************************************
* : Osa_kill_handler
* :
* ˵: (IN)    thread_id:
*   ֵ: ɹ:task_id;ʧ:NULL
* ˵:
**************************************************************************/
VOID Osa_kill_handler(T_ZOsa_ThreadUserArea *ua, PROCESS pid)
{
    if (gp_OsaThreadUserArea != NULL)
    {
        gp_OsaThreadUserArea[OSA_PID_TO_INDEX(pid)] = NULL;
    }
}

/**************************************************************************
* :  Osa_swapin_handler
* :
* ˵: (IN) thread_id:
*   ֵ:  ɹ:task_id;ʧ:NULL
* ˵:
**************************************************************************/
VOID Osa_swapin_handler(T_ZOsa_ThreadUserArea *ua)
{
    UINT32  iIndex  = 0;
    UINT32  nowtime = 0;
    
    zOss_AssertExN(ua != NULL);
    
#ifdef _USE_TRACE_INT_THREAD
    if(gSum <= 5000)
    {
        gSum++;
    }
    else
    {
        gSwapInThreadsID[gSwapInIndex] = ua->threadid;
        gSwapInTimes[gSwapInIndex]     = Osa_HwTimeRead();
        gSwapInIndex++;
        if ( gSwapInIndex >= 5000 )
        {
            gSwapInIndex = 0;
        }
    }
#endif

    if (gp_OsaThreadUserArea != NULL)
    {
        iIndex = OSA_PID_TO_INDEX(ua->threadid);

        if (gp_OsaThreadUserArea[iIndex] == NULL)
        {
            gp_OsaThreadUserArea[iIndex] = ua;
        }
    }
#if defined (_USE_PSM) && defined (_USE_CPU_DFM)
    zOss_ThreadSwapInPsmHook((T_ZOsa_ThreadUserArea *)ua);
#endif
    
    if (gOsa_SwapTimeFlag)
    {
        UINT32  len = 0;
        (ua->runcount)++;
        nowtime = Osa_HwTimeRead();
        len = nowtime - gOsa_SwapLastTime;
        ua->cputime += len;
        ua->runtime += len;
        if (NULL != ua->curtaskid)
        {
            T_ZOss_TCB *pTCB = NULL;
            pTCB = (T_ZOss_TCB *)(ua->curtaskid);
            pTCB->cputime += len;
            pTCB->runtime += len;
            pTCB->task_time = nowtime;
        }
        gOsa_SwapLastTime = nowtime;
    }
}

/**************************************************************************
* :  Osa_swapout_handler
* :
* ˵: (IN) thread_id:
*   ֵ:  ɹ:task_id;ʧ:NULL
* ˵:
**************************************************************************/
VOID Osa_swapout_handler(T_ZOsa_ThreadUserArea *ua)
{
    UINT32 nowtime = 0;

    zOss_AssertExN(ua != NULL);
            
#ifdef _USE_TRACE_INT_THREAD
    if(gSum > 5000)
    {
        gSwapOutThreadsID[gSwapOutIndex]    = ua->threadid;
        gSwapOutTimes[gSwapOutIndex]        = (UINT32)Osa_HwTimeRead();
        gSwapOutIndex++;
        if ( gSwapOutIndex >= 5000 )
        {
            gSwapOutIndex = 0;
        }
    }
#endif

#if defined (_USE_PSM) && defined (_USE_CPU_DFM)
    zOss_ThreadSwapOutPsmHook((T_ZOsa_ThreadUserArea *)ua);
#endif

    if (gOsa_SwapTimeFlag)
    {
        UINT32      len     = 0;
        T_ZOss_TCB  *pTCB   = NULL;
        
        nowtime = Osa_HwTimeRead();
        len = nowtime - gOsa_SwapLastTime; /* ִ߳ʱ */
        ua->cputime += len;
        ua->runtime += len;
        if (NULL != ua->curtaskid)
        {
            pTCB = (T_ZOss_TCB *)(ua->curtaskid);
            len = nowtime - pTCB->task_time; 
            pTCB->cputime += len;
            pTCB->runtime += len;
        }
        gOsa_SwapLastTime = nowtime;
    }
}

/**************************************************************************
* :  Osa_SwapCtl
* :
* ˵:  (IN) :
*   ֵ:  ɹ:task_id;ʧ:NULL
* ˵:
**************************************************************************/
VOID Osa_SwapCtl(BOOL enableRunTime)
{
    UINT32      i           = 0;
    PROCESS     my_pid      = 0;
    OSPRIORITY  my_pri      = 0;
    UINT32      maxthread   = 0;

    if ((enableRunTime == gOsa_SwapTimeFlag))
    {
        return;
    }
    my_pid = current_process();
    my_pri = get_pri(my_pid);
    set_pri(0);

    if ((enableRunTime == TRUE) && (gOsa_SwapTimeFlag == FALSE))
    {
        if (NULL == gOsa_AllTaskIdArray)
        {
            T_OSS_PARAM *pPlatCfg = NULL;

            pPlatCfg            = zOss_GetOssCfg();
            gOsa_AllTaskIdArray = (VOID **)zOss_Malloc(sizeof(ZOSS_TASK_ID) * pPlatCfg->TaskCfg.max_task_num);
            zOss_ASSERT(gOsa_AllTaskIdArray != NULL);
        }

        maxthread = (UINT32)gOse_maxthreads;
        while (i < maxthread)
        {
            if (NULL != gp_OsaThreadUserArea[i])
            {
                gp_OsaThreadUserArea[i]->cputime = 0;
            }
            i++;
        }
        gOsa_CpuStartTime = Osa_HwTimeRead();
        gOsa_SwapLastTime = gOsa_CpuStartTime;
    }
    gOsa_SwapTimeFlag   = enableRunTime;
    set_pri(my_pri);
}

/**************************************************************************
* :  Osa_UpdateCpu
* :
* ˵:  (IN) :
*   ֵ:
* ˵:
**************************************************************************/
VOID Osa_UpdateCpu(VOID)
{
    if (gOsa_SwapTimeFlag)//ֻм¼мcpuıҪ
    {
        UINT32                  i           = 0;
        UINT32                  totaltime   = 0;
        UINT32                  nowtime     = 0;
        UINT32                  excetime    = 0;
        UINT32                  maxthread   = gOse_maxthreads;
        PROCESS                 my_pid      = 0;
        OSPRIORITY              my_pri      = 0;
        T_ZOsa_ThreadUserArea   *pUa        = NULL;

        my_pid = current_process();
        my_pri = get_pri(my_pid);
        set_pri(0);
        nowtime = Osa_HwTimeRead();
        totaltime = nowtime - gOsa_CpuStartTime; /* ִ߳ʱ */
        for (i = 0; i < maxthread; i++)
        {
            pUa = gp_OsaThreadUserArea[i];
            if (pUa)
            {
                if (pUa->cputime > totaltime)
                {
                    pUa->cputime = 0xFFFFFFFF - pUa->cputime;
                }

                if (pUa->cputime > 0x28F5C28) /* ̫󣬳100UINT32 */
                {
                    excetime        = (pUa->cputime >> 10 ) * 100;
                    pUa->cpupercent = (((FLOAT)excetime) / (totaltime >> 10));
                }
                else
                {
                    excetime        = pUa->cputime * 100;
                    pUa->cpupercent = (((FLOAT)excetime) / totaltime);
                }
                pUa->cputime = 0;/* ˽cputime 0*/
            }

        }

        if (gOsa_AllTaskIdArray)
        {
            T_ZOss_TCB *pTCB = NULL;

            maxthread = zOss_GetAllTaskID(gOsa_AllTaskIdArray);

            for (i = 0; i < maxthread; i++)
            {
                pTCB = (T_ZOss_TCB *)gOsa_AllTaskIdArray[i];
                if (pTCB != pTCB->task_id)
                {
                    continue;/* may SDL task */
                }

                if (pTCB->cputime > totaltime)
                {
                    pTCB->cputime = 0xFFFFFFFF - pTCB->cputime;
                }

                if (pTCB->cputime > 0x28F5C28) /* ̫󣬳100UINT32 */
                {
                    excetime            = (pTCB->cputime >> 10 ) * 100;
                    pTCB->cpupercent    = ((FLOAT)excetime) / (totaltime >> 10);
                }
                else
                {
                    excetime            = pTCB->cputime * 100;
                    pTCB->cpupercent    = (((FLOAT)excetime) / totaltime);
                }
                pTCB->cputime = 0;/* ˽cputime0 */

            }

        }
        gOsa_CpuStartTime = Osa_HwTimeRead();
        gOsa_SwapLastTime = gOsa_CpuStartTime;

        set_pri(my_pri);
    }
}
/**************************************************************************
* :  Osa_DisplayThreadExecInfo
* :
* ˵:  (IN) :
*   ֵ:
* ˵:
**************************************************************************/
UINT32 Osa_DisplayThreadExecInfo(PROCESS pid)
{        
    T_ZOsa_ThreadUserArea *pt = NULL;
    
    if (gOsa_SwapTimeFlag)
    {
        pt = Osa_GetThreadUserArea((ZOSS_THREAD_ID)pid, TRUE);
        zOss_Printf(SUBMDL_EXCEP, PRINT_LEVEL_NORMAL, "%-20s  %-16s  %16s  %16s  %16s  %16s",
                    "ThreadName", "ThreadID", "CpuPercent", "RunTimeInMs", "MsgNum", "RunCount");
        if (NULL != pt->threadid)
        {
            zOss_Printf(SUBMDL_EXCEP, PRINT_LEVEL_NORMAL, "%-20s  0x%08x   %16.2f  %16u   %16u   %16u",
                        pt->threadname, pt->threadid, pt->cpupercent,  pt->RunTimeInMs, pt->msgnum,pt->runcount);
        }
        else
        {
            zOss_Printf(SUBMDL_EXCEP, PRINT_LEVEL_ABNORMAL, "ûҵ߳0x%08x", (UINT32)pid);
            return ZOSS_ERROR;
        }
    }

    return ZOSS_SUCCESS;
}
/**************************************************************************
* :  Osa_DisplayThreadsExecInfo
* :
* ˵:  (IN) :
*   ֵ:
* ˵:
**************************************************************************/
UINT32 Osa_DisplayThreadsExecInfo(UINT32 type)
{
    UINT32                  i                   = 0;
    UINT32                  excetime            = 0;
    UINT32                  thread_num          = 0;    /* ߳               */
    ZOSS_THREAD_ID          *AllThreadIdArray   = NULL; /* ߳IDָ   */
    T_ZOsa_ThreadUserArea   *pThreadInfo        = NULL; /* ߳UAָ           */

    if (gOsa_SwapTimeFlag)
    {
        thread_num = Osa_GetAllThreadId(&AllThreadIdArray);/* ռ */
        if (0 == thread_num || NULL == AllThreadIdArray)
        {
            return ZOSS_ERROR;
        }
        zOss_Printf(SUBMDL_EXCEP, PRINT_LEVEL_NORMAL, "%-20s  %-16s  %16s  %16s  %16s  %16s",
                    "ThreadName", "ThreadID", "CpuPercent", "RunTimeInMs", "MsgNum", "RunCount");
        for (i = 0;i < thread_num;i++)
        {
            pThreadInfo = Osa_GetThreadUserArea(AllThreadIdArray[i], TRUE);
            excetime    = pThreadInfo->runtime;
            if ((type & SUP_THREAD_LIVE_BIT) && 0 == excetime)
            {
                continue;/* ûл߳ */
            }
            else if ((type & SUP_THREAD_LAZY_BIT) && 0 != excetime)
            {
                continue;/* ߳ */
            }
            
            zOss_Printf(SUBMDL_EXCEP, PRINT_LEVEL_NORMAL, "%-20s  0x%08x   %16.2f   %16u   %16u    %16u",
                        pThreadInfo->threadname, pThreadInfo->threadid, pThreadInfo->cpupercent, pThreadInfo->RunTimeInMs, pThreadInfo->msgnum, pThreadInfo->runcount);
        }
        zOss_Free(AllThreadIdArray);
    }

    return ZOSS_SUCCESS;
}

/**************************************************************************
* :  Osa_DisplayThreadsExecInfo
* :
* ˵:  (IN) :
*   ֵ:
* ˵:
**************************************************************************/
FLOAT Osa_GetProcessCPU(ZOSS_THREAD_ID tid)
{
    UINT32 i = 0;

    if (gOsa_SwapTimeFlag)
    {
        for (i = 0; i < gOse_maxthreads; i++)
        {
            if ((gp_OsaThreadUserArea[i] != NULL) && (tid == (ZOSS_THREAD_ID) gp_OsaThreadUserArea[i]->threadid))
            {
                return gp_OsaThreadUserArea[i]->cpupercent;
            }
        }
    }

    return 0;
}

#ifdef __cplusplus
}
#endif

