/***********************************************************************
* Copyright (C) 2001, ZTE Corporation.
*
* File Name:  aud_nv.h
* File Mark:
* Description:  Provide audio NV function prototype declaration and type declaration. The audio NV type declaration is moved from eep.h.
* Others:
* Version:   v0.5
* Author:   Wangjun
* Date:         2009-02-14
*
* History 1:
*     Date:
*     Version:
*     Author:
*     Modification:
* History 2:
**********************************************************************/

#ifndef _AUD_NV_H
#define _AUD_NV_H



/**************************************************************************
 *                                  Include files                                                                             *
 **************************************************************************/



/**************************************************************************
 *                                  Macro                                                                                      *
 **************************************************************************/
#ifndef int16
#define int16  short int
#endif
#ifndef int32
#define int32  long
#endif

/* Defines to determine array sizes */
#if 0
#define EEP_AUD_BIQUAD_FILTERS_UL   30
#define EEP_AUD_BIQUAD_FILTERS_DL   20
#define EEP_AUD_BIQUAD_FILTERS_CBUF 10
#endif
#if 0
#define EEP_AUD_FIR_FILTERS_UL       5
#define EEP_AUD_FIR_FILTERS_DL       5
#define EEP_AUD_FIR_FILTERS_CBUF     5
#endif
#if 0
#define EEP_AUD_HF                   8
#endif
#if 0
#define EEP_AUD_ASP_UL               5
#define EEP_AUD_DL_NR                5
#endif
#define EEP_AUD_UPLINK_PATHS        22
#define EEP_AUD_DOWNLINK_PATHS      29

#define AUDIO_PATHS 10            /*defined multiple places -also in aud_data.h*/

/*[Begin] [lvwenhua-2010/9/16]*/
#define EEP_CODEC_UPLINK_PATHS        3 //MAX_CODEC_INPUT_PATH
#define EEP_CODEC_DOWNLINK_PATHS      5 //MAX_CODEC_OUTPUT_PATH
#define EEP_VOICE_OUTPUT_VOL_LEVELS     12 /* MAX_VOICE_OUTPUT_VOL_LEVEL */
#define EEP_MIDI_OUTPUT_VOL_LEVELS      12 /* MAX_MIDI_OUTPUT_VOL_LEVEL  */
#define EEP_TONE_OUTPUT_VOL_LEVELS      12 /* MAX_TONE_OUTPUT_VOL_LEVEL  */
#define EEP_PCM_OUTPUT_VOL_LEVELS       12 /* MAX_AUDIO_OUTPUT_VOL_LEVEL */
/*[End] [lvwenhua-2010/9/16]*/

#define EEP_AUD_CEPT         0
#define EEP_AUD_ANSI         1
#define EEP_AUD_JAPAN        2
#define EEP_AUD_REGION_END   3

typedef struct
{
    UINT16 gain_out;                  /********************************************************************************
                                               ܣ    teak еgain_out棻
                                               ȡֵΧ0 0x7FFF,
                                                         0 db ֵΪ0x1FFF
                                               ֵ
                                                         ,n =0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,23,25,26,27,28ʱ:
                                                             aud_audio_downlink_parms[n].downlink_gain_cells.gain_out = 8192;
                                                         n =20,21,22,24ʱ:
                                                             aud_audio_downlink_parms[n].downlink_gain_cells.gain_out = 0;
                                              *********************************************************************************/

    UINT16 gain_out_use;              /********************************************************************************
                                               ܣ    teak еgain_outǷNVã
                                               ȡֵΧ0:  ʹ
                                                         1:  ʹNV

                                               ֵ
                                                         ,n =0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,21,22,25,26,27,28ʱ:
                                                             aud_audio_downlink_parms[n].downlink_gain_cells.gain_out_use=1;
                                                         n =20,23,24ʱ:
                                                             aud_audio_downlink_parms[n].downlink_gain_cells.gain_out_use=0;
                                              *********************************************************************************/

    UINT16 kappa0;                    /********************************************************************************
                                               ܣ    teak еkappa0棻
                                               ȡֵΧ0 0x7FFF,
                                                         0 db ֵΪ0x7FFF
                                               ֵ
                                                         ,n =0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,23,25,26,27,28ʱ:
                                                             aud_audio_downlink_parms[n].downlink_gain_cells.kappa0=32767;
                                                         n =21,22,24ʱ:
                                                             aud_audio_downlink_parms[0].downlink_gain_cells.kappa0=0;
                                              *********************************************************************************/

    UINT16 kappa0_use;                /********************************************************************************
                                               ܣ    teak еkappa0ǷNVã
                                               ȡֵΧ0:  ʹ
                                                         1:  ʹNV

                                               ֵ
                                                         ,n =0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,25,26,27,28ʱ:
                                                             aud_audio_downlink_parms[n].downlink_gain_cells.kappa0_use = 1;
                                                         n =20,21,22,23,24ʱ:
                                                             aud_audio_downlink_parms[n].downlink_gain_cells.kappa0_use = 0;
                                              *********************************************************************************/

    UINT16 mix_afe;                   /********************************************************************************
                                               ܣ    teak еĻϵAFEmix_afe棻
                                               ȡֵΧ0 0x7FFF,
                                                         0 db ֵΪ0x3FFF
                                               ֵ
                                                         ,n =0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,24,25,26,27,28ʱ:
                                                             aud_audio_downlink_parms[n].downlink_gain_cells.mix_afe=1;
                                                         n =21,22,23ʱ:
                                                             aud_audio_downlink_parms[n].downlink_gain_cells.mix_afe=0;
                                              *********************************************************************************/

    UINT16 mix_afe_use;               /********************************************************************************
                                               ܣ    teak еĻϵAFEmix_afeǷNVã
                                               ȡֵΧ0:  ʹ
                                                         1:  ʹNV

                                               ֵ
                                                         ,n =0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,24,25,26,27,28ʱ:
                                                             aud_audio_downlink_parms[n].downlink_gain_cells.mix_afe_use=0;
                                                         n =21,22,23ʱ:
                                                             aud_audio_downlink_parms[n].downlink_gain_cells.mix_afe_use=1;
                                              *********************************************************************************/
}
eep_aud_downlink_gain_cells_type;

typedef struct
{
    SINT16          hf_algorithm_init;         /********************************************************************************
                                               ܣ    teak handsfreeĵһ
                                               ȡֵΧ00xFF

                                               ֵ
                                                         Уaud_hf[3].hf_algorithm_init=0඼Ϊ397
                                              *********************************************************************************/

    SINT16          hf_algorithm_restart;      /********************************************************************************
                                               ܣ    teak handsfree
                                               ȡֵΧ00xFF

                                               ֵ
                                                         Уaud_hf[3].hf_algorithm_restart=0඼Ϊ270
                                              *********************************************************************************/

    UINT16 step_width;                /********************************************************************************
                                               ܣ    teak handsfreeLMSڵĲ
                                               ȡֵΧ032767

                                               ֵ
                                                         2200
                                              *********************************************************************************/

    UINT16 lms_length;                /********************************************************************************
                                               ܣ    teak LMS˲ϵ
                                               ȡֵΧ2400

                                               ֵ
                                                         250
                                              *********************************************************************************/

    UINT16 lms_offset;                /********************************************************************************
                                               ܣ    teak LMS˲ϵƫƣ
                                               ȡֵΧ0400

                                               ֵ
                                                         8
                                              *********************************************************************************/

    UINT16 block_length;              /********************************************************************************
                                               ܣ    teak LMSȣ
                                               ȡֵΧ2458

                                               ֵ
                                                         5
                                              *********************************************************************************/

    SINT16          rxtx_relation;             /********************************************************************************
                                               ܣ    teakĹϵ
                                               ȡֵΧ-960960

                                               ֵ
                                                         :
                                                         aud_hf[0].rxtx_relation=-200
                                                         aud_hf[1].rxtx_relation=150
                                                         ඼Ϊ-400
                                                         
                                              *********************************************************************************/

    UINT16 add_atten;                 /********************************************************************************
                                               ܣ    teakԶģ˥
                                               ȡֵΧ0960

                                               ֵ
                                                         0
                                              *********************************************************************************/

    UINT16 min_atten;                 /********************************************************************************
                                               ܣ    teakԶģС˥
                                               ȡֵΧ0960

                                               ֵ
                                                         0
                                              *********************************************************************************/

    UINT16 max_atten;                 /********************************************************************************
                                               ܣ    teakԶģ˥
                                               ȡֵΧ0960

                                               ֵ
                                                         500
                                              *********************************************************************************/

    UINT16 nr_sw_2;                   /********************************************************************************
                                               ܣ    teakģ˥
                                               ȡֵΧ032767

                                               ֵ
                                                         16384
                                              *********************************************************************************/

    UINT16 nr_u_fak_0;                /********************************************************************************
                                               ܣ    teakģĴ0Ľأ
                                               ȡֵΧ016384

                                               ֵ
                                                         16384
                                              *********************************************************************************/

    UINT16 nr_u_fak;                  /********************************************************************************
                                               ܣ    teakģĴ17Ľأ
                                               ȡֵΧ016384

                                               ֵ
                                                         16384
                                              *********************************************************************************/
}
eep_aud_hf_type;

typedef struct
{
    UINT16 coeffi;                    /********************************************************************************
                                               ܣ    teak biquad˲˲˲
                                               ȡֵΧ0: 
                                                         1: 
                                                         2: CBuf

                                               ֵ
                                                         е˲(aud_uplink_biquad_filters)Ϊ: 0
                                                         е˲(aud_downlink_biquad_filters)Ϊ: 1
                                                         CBuf ˲ Ϊ: 2
                                              *********************************************************************************/

    UINT16 a1_1;                      /********************************************************************************
                                               ܣ    teak biquad˲
                                               ȡֵΧ00xFFFF

                                               ֵ
                                                         ˲aud_uplink_biquad_filters[0].a1_1=14878඼Ϊ0
                                                         ˲aud_downlink_biquad_filters[0].a1_1=35445඼Ϊ0
                                                         CBuf ˲aud_cbuf_biquad_filters[0].a1_1=57878; ඼Ϊ0
                                              *********************************************************************************/

    UINT16 b1_1;                      /********************************************************************************
                                               ܣ    teak biquad˲
                                               ȡֵΧ00xFFFF

                                               ֵ
                                                         ˲aud_uplink_biquad_filters[0].b1_1=13372඼Ϊ0
                                                         ˲aud_downlink_biquad_filters[0].b1_1=35572඼Ϊ0
                                                         CBuf ˲aud_cbuf_biquad_filters[0].b1_1=45294඼Ϊ0
                                              *********************************************************************************/

    UINT16 a2_1;                      /********************************************************************************
                                               ܣ    teak biquad˲
                                               ȡֵΧ00xFFFF

                                               ֵ
                                                         ˲a2_1Ϊ0
                                                         ˲aud_downlink_biquad_filters[0].a2_1=30091඼Ϊ0
                                                         CBuf ˲aud_cbuf_biquad_filters[0].a2_1=5321඼Ϊ0
                                              *********************************************************************************/

    UINT16 b2_1;                      /********************************************************************************
                                               ܣ    teak biquad˲
                                               ȡֵΧ00xFFFF

                                               ֵ
                                                         ˲b2_1Ϊ0
                                                         ˲aud_downlink_biquad_filters[0].b2_1=27668඼Ϊ0
                                                         CBuf ˲aud_cbuf_biquad_filters[0].b2_1=14049඼Ϊ0
                                              *********************************************************************************/

    UINT16 a0_1;                      /********************************************************************************
                                               ܣ    teak biquad˲
                                               ȡֵΧ00xFFFF

                                               ֵ
                                                         ˲aud_uplink_biquad_filters[0].a0_1=29756඼Ϊ32767
                                                         ˲aud_downlink_biquad_filters[0].a0_1=30091඼Ϊ32767
                                                         CBuf ˲aud_cbuf_biquad_filters[0].a0_1=14315඼Ϊ32767
                                              *********************************************************************************/

    UINT16 a1_2;                      /********************************************************************************
                                               ܣ    teak biquad˲
                                               ȡֵΧ00xFFFF

                                               ֵ
                                                         ˲aud_uplink_biquad_filters[0].a1_2=39151඼Ϊ0
                                                         ˲aud_downlink_biquad_filters[0].a1_2=26488඼Ϊ0
                                                         CBuf ˲a1_2Ϊ0
                                              *********************************************************************************/

    UINT16 b1_2;                      /********************************************************************************
                                               ܣ    teak biquad˲
                                               ȡֵΧ00xFFFF

                                               ֵ
                                                         ˲aud_uplink_biquad_filters[0].b1_2=36192඼Ϊ0
                                                         ˲aud_downlink_biquad_filters[0].b1_2=24996඼Ϊ0
                                                         CBuf ˲b1_2Ϊ0
                                              *********************************************************************************/

    UINT16 a2_2;                      /********************************************************************************
                                               ܣ    teak biquad˲
                                               ȡֵΧ00xFFFF

                                               ֵ
                                                         ˲aud_uplink_biquad_filters[0].a2_2=26385඼Ϊ0
                                                         ˲aud_downlink_biquad_filters[0].a2_2=26488඼Ϊ0
                                                         CBuf ˲a2_2Ϊ0
                                              *********************************************************************************/

    UINT16 b2_2;                      /********************************************************************************
                                               ܣ    teak biquad˲
                                               ȡֵΧ00xFFFF

                                               ֵ
                                                         ˲aud_uplink_biquad_filters[0].b2_2=26962඼Ϊ0
                                                         ˲aud_downlink_biquad_filters[0].b2_2=23168඼Ϊ0
                                                         CBuf ˲b2_2Ϊ0
                                              *********************************************************************************/

    UINT16 a0_2;                      /********************************************************************************
                                               ܣ    teak biquad˲
                                               ȡֵΧ00xFFFF

                                               ֵ
                                                         ˲aud_uplink_biquad_filters[0].a0_2=26385඼Ϊ32767
                                                         ˲aud_downlink_biquad_filters[0].a0_2=26488඼Ϊ32767
                                                         CBuf ˲a0_2Ϊ32767
                                              *********************************************************************************/
}
eep_aud_biquad_filters_type;


typedef struct
{
    eep_aud_downlink_gain_cells_type downlink_gain_cells;     /********************************************************************************
                                                               ܣ    teak е棻
                                                               ȡֵΧeep_aud_downlink_gain_cells_typeṹ

                                                               ֵ
                                                                         eep_aud_downlink_gain_cells_typeṹ
                                                              *********************************************************************************/

    #if 0
    int16          biquad_filter_dl_index_8kHz;               /********************************************************************************
                                                               ܣ    8KHZ biquad_filterֵ
                                                               ȡֵΧ020

                                                               ֵ
                                                                         ,n =0,1,2,3,4,6,7,10,11,12,13,14,15,16,17,18,19,20,23,24,25,26,27,28ʱ:
                                                                             aud_audio_downlink_parms[n].biquad_filter_dl_index_8kHz=0;
                                                                         n =5,8,9,21,22,ʱ:
                                                                             aud_audio_downlink_parms[n].biquad_filter_dl_index_8kHz=1;
                                                              *********************************************************************************/
    #endif
    eep_aud_biquad_filters_type biquad_filter_dl_8kHz;

    #if 0
    int16          biquad_filter_dl_index_16kHz;              /********************************************************************************
                                                               ܣ    16KHZ biquad_filterֵ
                                                               ȡֵΧ020

                                                               ֵ
                                                                         ,n =0,1,2,3,4,6,7,10,11,12,13,14,15,16,17,18,19,20,23,24,25,26,27,28ʱ:
                                                                             aud_audio_downlink_parms[n].biquad_filter_dl_index_16kHz=0;
                                                                         n =5,8,9,21,22,ʱ:
                                                                             aud_audio_downlink_parms[n].biquad_filter_dl_index_16kHz=1;
                                                              *********************************************************************************/
    #endif
    eep_aud_biquad_filters_type biquad_filter_dl_16kHz;

    #if 0
    int16          biquad_filter_cbuf_index;                  /********************************************************************************
                                                               ܣ    CBUF biquad_filterֵ
                                                               ȡֵΧ010

                                                               ֵ
                                                                         ,n =0,1,2,3,4,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28ʱ:
                                                                             aud_audio_downlink_parms[n].biquad_filter_cbuf_index=0;
                                                                         n =5ʱ:
                                                                             aud_audio_downlink_parms[n].biquad_filter_cbuf_index=1;
                                                              *********************************************************************************/
    #endif
    eep_aud_biquad_filters_type biquad_filter_cbuf;

    #if 0
    int16          fir_filter_dl_index;                       /********************************************************************************
                                                               ܣ     teakеfir_filterֵ
                                                               ȡֵΧ05

                                                               ֵ
                                                                         0
                                                              *********************************************************************************/

    int16          fir_filter_cbuf_index;                     /********************************************************************************
                                                               ܣ     teakCBUF fir_filterֵ
                                                               ȡֵΧ05

                                                               ֵ
                                                                         0
                                                              *********************************************************************************/

    int16          dl_nr_index;                               /********************************************************************************
                                                               ܣ     teakеƵֵͨ
                                                               ȡֵΧ05

                                                               ֵ
                                                                         0
                                                              *********************************************************************************/

    #endif
    UINT16 side_tone_fact;                            /********************************************************************************
                                                               ܣ     teakside_toneֵ
                                                               ȡֵΧ00x7FFF

                                                               ֵ
                                                                         ,n =0,1,2,4,6,7,8,9,10,11,12,13,16,17,18,19,24,25,26,27,28ʱ:
                                                                             aud_audio_downlink_parms[n].side_tone_fact=500;
                                                                         n =3,5,14,15,20,23,ʱ:
                                                                             aud_audio_downlink_parms[n].side_tone_fact=0;
                                                                         n =21,22,ʱ:
                                                                             aud_audio_downlink_parms[n].side_tone_fact=5787;
                                                              *********************************************************************************/

    UINT16 side_tone_fact_use;                        /********************************************************************************
                                                               ܣ    teak side_toneֵǷNVã
                                                               ȡֵΧ0:  ʹ
                                                                         1:  ʹNV

                                                               ֵ
                                                                         ,n =0,1,2,3,4,5,6,7,8,9,10,11,12,13,16,17,18,19,20,21,22,24,25,26,27,28ʱ:
                                                                             aud_audio_downlink_parms[n].side_tone_fact_use=1;
                                                                         n =14,15,23ʱ:
                                                                             aud_audio_downlink_parms[n].side_tone_fact_use=0;
                                                              *********************************************************************************/
}
eep_audio_downlink_parms_type; /* 14*2 bytes */

typedef struct
{
    UINT16 scal_mic;                  /********************************************************************************
                                               ܣ    teak еscal_mic棻
                                               ȡֵΧ0 0x7FFF,
                                                         0 db ֵΪ0x1FFF
                                               ֵ
                                                         ,n = 0,1,4,6,7,9,13,18,19,20,21ʱ:
                                                             aud_audio_uplink_parms[n].uplink_gain_cells.scal_mic=6143;
                                                         n = 2,3,5,12,14ʱ:
                                                             aud_audio_uplink_parms[2].uplink_gain_cells.scal_mic=8192;
                                                         n = 10,11ʱ:
                                                             aud_audio_uplink_parms[2].uplink_gain_cells.scal_mic=8191;
                                                         n = 8,15,16,17ʱ:
                                                             aud_audio_uplink_parms[n].uplink_gain_cells.scal_mic=0;
                                              *********************************************************************************/

    UINT16 scal_mic_use;              /********************************************************************************
                                               ܣ    teak еscal_micǷNVã
                                               ȡֵΧ0:  ʹ
                                                         1:  ʹNV

                                               ֵ
                                                         ,n =0,1,2,3,4,6,7,8,9,10,11,13,14,18,19,20,21ʱ:
                                                             aud_audio_uplink_parms[n].uplink_gain_cells.scal_mic_use=1;
                                                         n =5,12,15,16,17ʱ:
                                                             aud_audio_uplink_parms[n].uplink_gain_cells.scal_mic_use=0;
                                              *********************************************************************************/

    UINT16 lambda0;                   /********************************************************************************
                                               ܣ    teak еlambda0棻
                                               ȡֵΧ0 0x7FFF,
                                                         0 db ֵΪ0x7FFF
                                               ֵ
                                                         ,n =0,1,2,3,4,5,6,7,9,12,13,14,19,20,21ʱ:
                                                             aud_audio_uplink_parms[n].uplink_gain_cells.lambda0=32767;
                                                         n =8,10,11,15,16,17,18ʱ:
                                                             aud_audio_uplink_parms[n].uplink_gain_cells.lambda0=0;
                                              *********************************************************************************/

    UINT16 lambda0_use;               /********************************************************************************
                                               ܣ    teak еlambda0ǷNVã
                                               ȡֵΧ0:  ʹ
                                                         1:  ʹNV

                                               ֵ
                                                        ,n =0,1,2,3,4,6,7,8,9,13,19,20,21ʱ:
                                                             aud_audio_uplink_parms[n].uplink_gain_cells.lambda0_use=1;
                                                         n =5,10,11,12,14,15,16,17,18ʱ:
                                                             aud_audio_uplink_parms[n].uplink_gain_cells.lambda0_use=0;
                                              *********************************************************************************/

    UINT16 gamma0;                    /********************************************************************************
                                               ܣ    teak еgamma0棻
                                               ȡֵΧ0 0x7FFF,
                                                         0 db ֵΪ0x7FFF
                                               ֵ
                                                         ,n =0,1,2,3,4,5,6,7,8,9,12,13,14,19,20,21ʱ:
                                                             aud_audio_uplink_parms[n].uplink_gain_cells.gamma0=32767;
                                                         n =10,11,15,16,17,18ʱ:
                                                             aud_audio_uplink_parms[n].uplink_gain_cells.gamma0=0;
                                              *********************************************************************************/

    UINT16 gamma0_use;                /********************************************************************************
                                               ܣ    teak еgamma0ǷNVã
                                               ȡֵΧ0:  ʹ
                                                         1:  ʹNV

                                               ֵ
                                                         ,n =5,8,10,11,12,14,15,16,17,18ʱ:
                                                             aud_audio_uplink_parms[n].uplink_gain_cells.gamma0_use=0
                                                         n =0,1,2,3,4,6,7,9,13,19,20,21ʱ:
                                                             aud_audio_uplink_parms[n].uplink_gain_cells.gamma0_use=1
                                              *********************************************************************************/

    UINT16 scal_afe;                  /********************************************************************************
                                               ܣ    teak еscal_afe棻
                                               ȡֵΧ0 0x7FFF,
                                                         0 db ֵΪ0x1FFF
                                               ֵ
                                                         Уaud_audio_uplink_parms[5].uplink_gain_cells.scal_afe=8192,
                                                         ඼Ϊ0.
                                              *********************************************************************************/

    UINT16 scal_afe_use;              /********************************************************************************
                                               ܣ    teak еscal_afeǷNVã
                                               ȡֵΧ0:  ʹ
                                                         1:  ʹNV

                                               ֵ
                                                         Уaud_audio_uplink_parms[5].uplink_gain_cells.scal_afe_use=1,
                                                         aud_audio_uplink_parms[n].uplink_gain_cells.scal_afe_use=0.
                                              *********************************************************************************/

    UINT16 scal_mic2;                 /********************************************************************************
                                               ܣ    teak еscal_mic2棻
                                               ȡֵΧ0 0x7FFF,
                                                         0 db ֵΪ0x1FFF
                                               ֵ
                                                         ,aud_audio_uplink_parms[5].uplink_gain_cells.scal_mic2=8192;
                                                         ඼Ϊ0.
                                              *********************************************************************************/

    UINT16 scal_mic2_use;             /********************************************************************************
                                               ܣ    teak еscal_mic2ǷNVã
                                               ȡֵΧ0:  ʹ
                                                         1:  ʹNV

                                               ֵ
                                                         ,n =0,1,2,3,4,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21ʱ:
                                                             aud_audio_uplink_parms[n].uplink_gain_cells.scal_mic2_use=0;
                                                         n =5ʱ:
                                                             aud_audio_uplink_parms[n].uplink_gain_cells.scal_mic2_use=1;
                                              *********************************************************************************/

    UINT16 afe_tone;                  /********************************************************************************
                                               ܣ    teak еafe_tone棻
                                               ȡֵΧ0 0x7FFF,
                                                         0 db ֵΪ0x3FFF
                                               ֵ
                                                         ,aud_audio_uplink_parms[5].uplink_gain_cells.afe_tone=16384;
                                                         ඼Ϊ0.
                                              *********************************************************************************/

    UINT16 afe_tone_use;              /********************************************************************************
                                               ܣ    teak еafe_toneǷNVã
                                               ȡֵΧ0:  ʹ
                                                         1:  ʹNV

                                               ֵ
                                                         ,aud_audio_uplink_parms[5].uplink_gain_cells.afe_tone_use=1;
                                                         ඼Ϊ0.
                                              *********************************************************************************/

    UINT16 mix_pcmrec;                /********************************************************************************
                                               ܣ    teak еĻPCMֵmix_pcmrec棻
                                               ȡֵΧ0 0x7FFF,
                                                         0 db ֵΪ0x3FFF
                                               ֵ
                                                         ,aud_audio_uplink_parms[12].uplink_gain_cells.mix_pcmrec=1;
                                                         ඼Ϊ0.
                                              *********************************************************************************/
}
eep_aud_uplink_gain_cells_type;


typedef struct
{
    eep_aud_uplink_gain_cells_type  uplink_gain_cells;        /********************************************************************************
                                                               ܣ    teak е棻
                                                               ȡֵΧeep_aud_uplink_gain_cells_typeṹ

                                                               ֵ
                                                                         eep_aud_uplink_gain_cells_typeṹ
                                                              *********************************************************************************/

    #if 0
    int16          biquad_filter_ul_index_8kHz;               /********************************************************************************
                                                               ܣ    8KHZ biquad_filterֵ
                                                               ȡֵΧ030

                                                               ֵ
                                                                         ,n =0,1,2,4,5,6,7,8,9,12,13,14,15,16,17,18,19,20,21ʱ:
                                                                             aud_audio_uplink_parms[n].biquad_filter_ul_index_8kHz=0;
                                                                         n =3,10,11ʱ:
                                                                             aud_audio_uplink_parms[n].biquad_filter_ul_index_8kHz=1;
                                                              *********************************************************************************/
    #endif
    eep_aud_biquad_filters_type biquad_filter_ul_8kHz;

    #if 0
    int16          biquad_filter_ul_index_16kHz;              /********************************************************************************
                                                               ܣ    16KHZ biquad_filterֵ
                                                               ȡֵΧ030

                                                               ֵ
                                                                         ,n =0,1,2,4,5,6,7,8,9,12,13,14,15,16,17,18,19,20,21ʱ:
                                                                             aud_audio_uplink_parms[n].biquad_filter_ul_index_16kHz=0;
                                                                         n =3,10,11ʱ:
                                                                             aud_audio_uplink_parms[n].biquad_filter_ul_index_16kHz=1;
                                                              *********************************************************************************/
    #endif
    eep_aud_biquad_filters_type biquad_filter_ul_16kHz;

    #if 0
    int16          biquad_filter_ul_index_48kHz;              /********************************************************************************
                                                               ܣ    48KHZ biquad_filterֵ
                                                               ȡֵΧ030

                                                               ֵ
                                                                         ,n =0,1,2,4,5,6,7,8,9,12,13,14,15,16,17,18,19,20,21ʱ:
                                                                             aud_audio_uplink_parms[n].biquad_filter_ul_index_48kHz=0;
                                                                         n =3,10,11ʱ:
                                                                             aud_audio_uplink_parms[n].biquad_filter_ul_index_48kHz=1;
                                                              *********************************************************************************/
    #endif
    eep_aud_biquad_filters_type biquad_filter_ul_48kHz;

    #if 0
    int16          fir_filter_ul_index;                       /********************************************************************************
                                                               ܣ     teakеfir_filterֵ
                                                               ȡֵΧ05

                                                               ֵ
                                                                         0
                                                              *********************************************************************************/
    #endif

    #if 0
    int16          hf_index;                                  /********************************************************************************
                                                               ܣ     teakhandsfreeֵ
                                                               ȡֵΧ08

                                                               ֵ
                                                                         ,n =0,6,8,9,20,21ʱ:
                                                                             aud_audio_uplink_parms[n].hf_index=0;
                                                                         n =1,2,4,5,10,11,12,13,14,15,16,17,18,19ʱ:
                                                                             aud_audio_uplink_parms[n].hf_index=1;
                                                                         n =7ʱ:
                                                                             aud_audio_uplink_parms[n].hf_index=2;
                                                                         n =3ʱ:
                                                                             aud_audio_uplink_parms[n].hf_index=3;
                                                              *********************************************************************************/
    #endif
    eep_aud_hf_type hf;

    #if 0
    int16          asp_ul_index;                              /********************************************************************************
                                                               ܣ     teakеASPֵ
                                                               ȡֵΧ05

                                                               ֵ
                                                                         0
                                                              *********************************************************************************/
    #endif

    UINT16 mic_gain;                                  /********************************************************************************
                                                               ܣ     teakеmic_gain棻
                                                               ȡֵΧ0x00x10

                                                               ֵ
                                                                         ,n =0,1,4,7,12,13,14,18,20,21ʱ:
                                                                             aud_audio_uplink_parms[n].mic_gain=10;
                                                                         n =2,3,ʱ:
                                                                             aud_audio_uplink_parms[n].mic_gain=6;
                                                                         n =5,ʱ:
                                                                             aud_audio_uplink_parms[n].mic_gain=2;
                                                                         n =6,19ʱ:
                                                                             aud_audio_uplink_parms[n].mic_gain=14;
                                                                         n =8,9,ʱ:
                                                                             aud_audio_uplink_parms[n].mic_gain=5;
                                                                         n =10,11,15,16,17,ʱ:
                                                                             aud_audio_uplink_parms[n].mic_gain=0;
                                                              *********************************************************************************/

    UINT16 mic_gain_use;                              /********************************************************************************
                                                               ܣ    teak еmic_gainǷNVã
                                                               ȡֵΧ0:  ʹ
                                                                         1:  ʹNV

                                                               ֵ
                                                                         ,n =0,1,2,4,5,6,7,9,10,11,13,14,18,19,20,21ʱ:
                                                                             aud_audio_uplink_parms[n].mic_gain_use=1;
                                                                         n =8,12,15,16,17ʱ:
                                                                             aud_audio_uplink_parms[n].mic_gain_use=0;
                                                              *********************************************************************************/

    #if 0
    UINT16 tx_dither;                                 /********************************************************************************
                                                               ܣ    AFEã
                                                               ȡֵΧnot used


                                                               ֵ
                                                                         0
                                                              *********************************************************************************/

    UINT16 tx_dither_use;                             /********************************************************************************
                                                               ܣ    AFEǷNVã
                                                               ȡֵΧ0:  ʹ
                                                                         1:  ʹNV

                                                               ֵ
                                                                         0
                                                              *********************************************************************************/
    #endif
}
eep_audio_uplink_parms_type;   /* 23*2 bytes */

typedef struct
{
    unsigned char                  audio_parms_from_eep_used;  /********************************************************************************
                                                                ܣ    teak ǷʹNVֵ
                                                                ȡֵΧ0: ʹ (false)
                                                                          1:  ʹã(true)
                                                                ֵ
                                                                          1
                                                               *********************************************************************************/

    #if 0
    unsigned char                  aud_use_filters_ul;         /********************************************************************************
                                                                ܣ    teak Ƿʹͨ·˲
                                                                ȡֵΧ0: ʹ (none)
                                                                          1:  ʹfir˲            (fir)
                                                                          4:  ʹbiquad˲      (biquad)
                                                                          5:  ʹfir+biquad˲(fir+biquad)
                                                                ֵ
                                                                          1
                                                               *********************************************************************************/


    unsigned char                  aud_use_filters_dl;         /********************************************************************************
                                                                ܣ    teak Ƿʹͨ·˲
                                                                ȡֵΧ0: ʹ (none)
                                                                          1:  ʹfir˲            (fir)
                                                                          4:  ʹbiquad˲      (biquad)
                                                                          5:  ʹfir+biquad˲(fir+biquad)
                                                                ֵ
                                                                          1
                                                               *********************************************************************************/

    unsigned char                  aud_use_filters_cbuf;       /********************************************************************************
                                                                ܣ    teak Ƿʹcircular buffer 48KHZͨ·ϵ˲
                                                                ȡֵΧ0: ʹ (none)
                                                                          1:  ʹfir˲            (fir)
                                                                          4:  ʹbiquad˲      (biquad)
                                                                          5:  ʹfir+biquad˲(fir+biquad)
                                                                ֵ
                                                                          1
                                                               *********************************************************************************/

    #endif
    #if 0
    eep_aud_biquad_filters_type    aud_uplink_biquad_filters[EEP_AUD_BIQUAD_FILTERS_UL];   /********************************************************************************
                                                                                            ܣ    teak еbiquad˲
                                                                                            ȡֵΧ
                                                                                                      eep_aud_biquad_filters_typeṹ壻
                                                                                            ֵ
                                                                                                      eep_aud_biquad_filters_typeṹ壻
                                                                                           *********************************************************************************/


    eep_aud_biquad_filters_type    aud_downlink_biquad_filters[EEP_AUD_BIQUAD_FILTERS_DL]; /********************************************************************************
                                                                                            ܣ    teak еbiquad˲
                                                                                            ȡֵΧ
                                                                                                      eep_aud_biquad_filters_typeṹ壻
                                                                                            ֵ
                                                                                                      eep_aud_biquad_filters_typeṹ壻
                                                                                           *********************************************************************************/

    eep_aud_biquad_filters_type    aud_cbuf_biquad_filters[EEP_AUD_BIQUAD_FILTERS_CBUF];   /********************************************************************************
                                                                                            ܣ    teak circular buffer 48KHZͨ·ϵ˲
                                                                                            ȡֵΧ
                                                                                                      eep_aud_biquad_filters_typeṹ壻
                                                                                            ֵ
                                                                                                      eep_aud_biquad_filters_typeṹ壻
                                                                                           *********************************************************************************/

    #endif
    #if 0
    eep_aud_fir_filter_type        aud_uplink_fir_filters[EEP_AUD_FIR_FILTERS_UL];         /********************************************************************************
                                                                                            ܣ    teak  еfir˲
                                                                                            ȡֵΧ
                                                                                                      eep_aud_fir_filter_typeṹ壻
                                                                                            ֵ
                                                                                                      eep_aud_fir_filter_typeṹ壻
                                                                                           *********************************************************************************/

    eep_aud_fir_filter_type        aud_downlink_fir_filters[EEP_AUD_FIR_FILTERS_DL];       /********************************************************************************
                                                                                            ܣ    teak  еfir˲
                                                                                            ȡֵΧ
                                                                                                      eep_aud_fir_filter_typeṹ壻
                                                                                            ֵ
                                                                                                      eep_aud_fir_filter_typeṹ壻
                                                                                           *********************************************************************************/


    eep_aud_fir_filter_type        aud_cbuf_fir_filters[EEP_AUD_FIR_FILTERS_CBUF];         /********************************************************************************
                                                                                            ܣ    teakcircular buffer 48KHZͨ·ϵ˲
                                                                                            ȡֵΧ
                                                                                                      eep_aud_fir_filter_typeṹ壻
                                                                                            ֵ
                                                                                                      eep_aud_fir_filter_typeṹ壻
                                                                                           *********************************************************************************/

    eep_aud_hf_type                aud_hf[EEP_AUD_HF];                                     /********************************************************************************
                                                                                            ܣ    teakhandsfreeĲ
                                                                                            ȡֵΧ
                                                                                                      eep_aud_hf_typeṹ壻
                                                                                            ֵ
                                                                                                      eep_aud_hf_typeṹ壻
                                                                                           *********************************************************************************/

    #endif
    #if 0
    eep_aud_asp_ul_type            aud_asp_ul[EEP_AUD_ASP_UL];                             /********************************************************************************
                                                                                            ܣ    teakͨ𵴱Ĳ
                                                                                            ȡֵΧ
                                                                                                      eep_aud_asp_ul_typeṹ壻
                                                                                            ֵ
                                                                                                      eep_aud_asp_ul_typeṹ壻
                                                                                           *********************************************************************************/

    eep_aud_dl_nr_type             aud_dl_nr[EEP_AUD_DL_NR];                               /********************************************************************************
                                                                                            ܣ    teakͨϽĲ
                                                                                            ȡֵΧ
                                                                                                      eep_aud_dl_nr_typeṹ壻
                                                                                            ֵ
                                                                                                      eep_aud_dl_nr_typeṹ壻
                                                                                           *********************************************************************************/

    #endif
    eep_audio_uplink_parms_type    aud_audio_uplink_parms[EEP_AUD_UPLINK_PATHS];           /********************************************************************************
                                                                                            ܣ    teakͨ·ϵĲ
                                                                                            ȡֵΧ
                                                                                                      eep_audio_uplink_parms_typeṹ壻
                                                                                            ֵ
                                                                                                      eep_audio_uplink_parms_typeṹ壻
                                                                                           *********************************************************************************/

    eep_audio_downlink_parms_type  aud_audio_downlink_parms[EEP_AUD_DOWNLINK_PATHS];       /********************************************************************************
                                                                                            ܣ    teakͨ·ϵĲ
                                                                                            ȡֵΧ
                                                                                                      eep_audio_downlink_parms_typeṹ壻
                                                                                            ֵ
                                                                                                      eep_audio_downlink_parms_typeṹ壻
                                                                                           *********************************************************************************/

    #if 0
    unsigned char          fill[2];                                                        /********************************************************************************
                                                                                            ܣ    λ
                                                                                            ȡֵΧ0  255

                                                                                            ֵ
                                                                                                      255
                                                                                           *********************************************************************************/
    #endif
}
eep_aud_path_data_type;

typedef struct
{
    SINT16         mix_afe;             /********************************************************************************
                                               ܣ    ûϵAFEƵԴֵ
                                               ȡֵΧ0 0x7FFF,
                                                         0 db ֵΪ0x3FFF
                                               ֵ
                                                         aud_cbuf_mix_parms[5].mix_afe=0,඼Ϊ32767
                                              *********************************************************************************/

    SINT16         mix_i2s1;            /********************************************************************************
                                               ܣ    ûϵI2S1ƵԴֵ
                                               ȡֵΧ0 0x7FFF,
                                                         0 db ֵΪ0x3FFF
                                               ֵ
                                                         aud_cbuf_mix_parms[5].mix_i2s1=0඼Ϊ32767
                                              *********************************************************************************/
}
eepaud_static_cbuf_mix_parms_type;

typedef SINT16 eep_aud_region_type;

/********************************************************************************
ܣ    teakͨ棻
ȡֵΧ0 0x7FFF,
          0 db ֵΪ0x1FFF

ֵ
          ڳΪһ32λ
          [0]  [31] У[3]Ϊ0x5000඼Ϊ0x2000
*********************************************************************************/
typedef struct
{
    SINT16         scal_in;              
}
eepaud_static_scal_in_parms_type;

/********************************************************************************
ܣ    teakͨ棻
ȡֵΧ0 0x7FFF,
         0 db ֵΪ0x1FFF

ֵ
         0x2000
*********************************************************************************/
typedef struct
{
    SINT16         scal_out;           
}
eepaud_static_scal_out_parms_type;

/*[Begin] [lvwenhua-2010/9/16]*/
typedef struct
{
    SINT16         scal_i2s1;  
}
eepaud_static_scal_i2s1_parms_type;

typedef struct
{
    SINT16         scal_rec;  
}
eepaud_static_scal_rec_parms_type;
/*[End] [lvwenhua-2010/9/16]*/

typedef struct
{
    UINT16 gain[EEP_VOICE_OUTPUT_VOL_LEVELS];           
} eep_voice_volume_config_type;

typedef struct
{
    UINT16 gain[EEP_MIDI_OUTPUT_VOL_LEVELS];           
} eep_midi_volume_config_type;

typedef struct
{
    UINT16 gain[EEP_TONE_OUTPUT_VOL_LEVELS];           
} eep_tone_volume_config_type;

#ifdef _USE_CODEC_TLV3212
typedef enum
{
    PMIC_MIC_GAIN_MINUS_12DB = 0,
    PMIC_MIC_GAIN_MINUS_9DB,
    PMIC_MIC_GAIN_MINUS_6DB,
    PMIC_MIC_GAIN_MINUS_3DB,
    PMIC_MIC_GAIN_0DB,
    PMIC_MIC_GAIN_PLUS_3DB,
    PMIC_MIC_GAIN_PLUS_6DB,
    PMIC_MIC_GAIN_PLUS_9DB,
    PMIC_MIC_GAIN_PLUS_12DB,
    PMIC_MIC_GAIN_PLUS_15DB,
    PMIC_MIC_GAIN_PLUS_18DB,
    PMIC_MIC_GAIN_MAX
    
} EEP_PMIC_AUDIO_MIC_GAIN;

typedef enum
{
    PMIC_OUTPGA_GAIN_PLUS_24DB = 0,
    PMIC_OUTPGA_GAIN_PLUS_21DB,
    PMIC_OUTPGA_GAIN_PLUS_18DB,
    PMIC_OUTPGA_GAIN_PLUS_15DB,
    PMIC_OUTPGA_GAIN_PLUS_12DB,
    PMIC_OUTPGA_GAIN_PLUS_9DB,
    PMIC_OUTPGA_GAIN_PLUS_6DB,
    PMIC_OUTPGA_GAIN_PLUS_3DB,
    PMIC_OUTPGA_GAIN_0DB,
    PMIC_OUTPGA_GAIN_MINUS_3DB,
    PMIC_OUTPGA_GAIN_MINUS_6DB,
    PMIC_OUTPGA_GAIN_MINUS_9DB,
    PMIC_OUTPGA_GAIN_MINUS_12DB,
    PMIC_OUTPGA_GAIN_MINUS_15DB,
    PMIC_OUTPGA_GAIN_MINUS_18DB,
    PMIC_OUTPGA_GAIN_MINUS_21DB,
    PMIC_OUTPGA_GAIN_MINUS_24DB,
    PMIC_OUTPGA_GAIN_MINUS_27DB,
    PMIC_OUTPGA_GAIN_MINUS_30DB,
    PMIC_OUTPGA_GAIN_MINUS_33DB,
    PMIC_OUTPGA_GAIN_MINUS_36DB,
    PMIC_OUTPGA_GAIN_MINUS_39DB,
    PMIC_OUTPGA_GAIN_MINUS_42DB,
    PMIC_OUTPGA_GAIN_MINUS_45DB,
    PMIC_OUTPGA_GAIN_MINUS_48DB,
    PMIC_OUTPGA_GAIN_MINUS_51DB,
    PMIC_OUTPGA_GAIN_MINUS_54DB,
    PMIC_OUTPGA_GAIN_MINUS_57DB,
    PMIC_OUTPGA_GAIN_MINUS_60DB,
    PMIC_OUTPGA_GAIN_MINUS_63DB,     
    PMIC_OUTPGA_GAIN_MAX  

} EEP_PMIC_AUDIO_OUTPUT_PGA_GAIN;
/*added by miaolin 20130805*/

#else

typedef enum
{
    PMIC_MIC_GAIN_MINUS_12DB = 0,
    PMIC_MIC_GAIN_MINUS_9DB,
    PMIC_MIC_GAIN_MINUS_6DB,
    PMIC_MIC_GAIN_MINUS_3DB,
    PMIC_MIC_GAIN_0DB,
    PMIC_MIC_GAIN_PLUS_3DB,
    PMIC_MIC_GAIN_PLUS_6DB,
    PMIC_MIC_GAIN_PLUS_9DB,
    PMIC_MIC_GAIN_PLUS_12DB,
    PMIC_MIC_GAIN_PLUS_15DB,
    PMIC_MIC_GAIN_PLUS_18DB,
    PMIC_MIC_GAIN_MAX
    
} EEP_PMIC_AUDIO_MIC_GAIN;

typedef enum
{
    PMIC_OUTPGA_GAIN_PLUS_24DB = 0,
    PMIC_OUTPGA_GAIN_PLUS_21DB,
    PMIC_OUTPGA_GAIN_PLUS_18DB,
    PMIC_OUTPGA_GAIN_PLUS_15DB,
    PMIC_OUTPGA_GAIN_PLUS_12DB,
    PMIC_OUTPGA_GAIN_PLUS_9DB,
    PMIC_OUTPGA_GAIN_PLUS_6DB,
    PMIC_OUTPGA_GAIN_PLUS_3DB,
    PMIC_OUTPGA_GAIN_0DB,
    PMIC_OUTPGA_GAIN_MINUS_3DB,
    PMIC_OUTPGA_GAIN_MINUS_6DB,
    PMIC_OUTPGA_GAIN_MINUS_9DB,
    PMIC_OUTPGA_GAIN_MINUS_12DB,
    PMIC_OUTPGA_GAIN_MINUS_15DB,
    PMIC_OUTPGA_GAIN_MINUS_18DB,
    PMIC_OUTPGA_GAIN_MINUS_21DB,
    PMIC_OUTPGA_GAIN_MINUS_24DB,
    PMIC_OUTPGA_GAIN_MINUS_27DB,
    PMIC_OUTPGA_GAIN_MINUS_30DB,
    PMIC_OUTPGA_GAIN_MINUS_33DB,
    PMIC_OUTPGA_GAIN_MINUS_36DB,
    PMIC_OUTPGA_GAIN_MINUS_39DB,
    PMIC_OUTPGA_GAIN_MINUS_42DB,
    PMIC_OUTPGA_GAIN_MINUS_45DB,
    PMIC_OUTPGA_GAIN_MINUS_48DB,
    PMIC_OUTPGA_GAIN_MINUS_51DB,
    PMIC_OUTPGA_GAIN_MINUS_54DB,
    PMIC_OUTPGA_GAIN_MINUS_57DB,
    PMIC_OUTPGA_GAIN_MINUS_60DB,
    PMIC_OUTPGA_GAIN_MINUS_63DB,     
    PMIC_OUTPGA_GAIN_MAX  

} EEP_PMIC_AUDIO_OUTPUT_PGA_GAIN;
#endif

#ifndef _USE_DATACARD
typedef struct
{
    EEP_PMIC_AUDIO_OUTPUT_PGA_GAIN gain[EEP_PCM_OUTPUT_VOL_LEVELS];           
} eep_pcm_volume_config_type;
#endif


typedef struct 
{
    eep_voice_volume_config_type voice_vol_gain_config[EEP_CODEC_DOWNLINK_PATHS];
    eep_midi_volume_config_type midi_vol_gain_config[EEP_CODEC_DOWNLINK_PATHS];
    eep_tone_volume_config_type tone_vol_gain_config[EEP_CODEC_DOWNLINK_PATHS];
#ifndef _USE_DATACARD
    eep_pcm_volume_config_type pcm_vol_gain_config[EEP_CODEC_DOWNLINK_PATHS];
#endif
}aud_eep_volume_config_type;


#ifndef _USE_DATACARD
typedef struct 
{
    EEP_PMIC_AUDIO_MIC_GAIN pga_tx;
}aud_pmic_eep_pga_tx_type;

typedef struct 
{
    EEP_PMIC_AUDIO_OUTPUT_PGA_GAIN pga_rx;    
}aud_pmic_eep_pga_rx_type;
/*[End] [lvwenhua-2010/9/16]*/
#endif

typedef volatile struct _aud_eep_static_type
{
    eep_aud_path_data_type              aud_path_data;                     /********************************************************************************
                                                                            ܣ    teak ͨ·ϵ˲ȣ
                                                                            ȡֵΧýṹȡֵΧeep_aud_path_data_typeṹ壻

                                                                            ֵ
                                                                                      eep_aud_path_data_typeṹ壻
                                                                           *********************************************************************************/

    #if 0
    eep_external_audio_type             external_audio;                    /********************************************************************************
                                                                            ܣ    teak ǷʹⲿƵ豸
                                                                            ȡֵΧ0:  ʹ
                                                                                      1:  ʹܣ
                                                                            ֵ
                                                                                      0
                                                                           *********************************************************************************/
    #endif

    eepaud_static_cbuf_mix_parms_type   aud_cbuf_mix_parms[AUDIO_PATHS];   /********************************************************************************
                                                                            ܣ    ûϵI2S1AFEƵԴֵ
                                                                            ȡֵΧ0 0x7FFF,
                                                                                      0 db ֵΪ0x3FFF
                                                                            ֵ
                                                                                      eepaud_static_cbuf_mix_parms_typeṹ壻
                                                                           *********************************************************************************/


    #if 0
    eep_aud_fm_radio_type               aud_fm_radio;                      /********************************************************************************
                                                                            ܣ    teakãûʹøùܣ
                                                                                      ڽṹпȥ
                                                                            ȡֵΧýṹȡֵΧeep_aud_fm_radio_typeṹ塣

                                                                            ֵ
                                                                                      eep_aud_fm_radio_typeṹ塣
                                                                           *********************************************************************************/
    #endif

    eep_aud_region_type                 aud_region;                        /********************************************************************************
                                                                            ܣ    teakʹ
                                                                            ȡֵΧ0:  EEP_AUD_CEPT
                                                                                      1:  EEP_AUD_ANSI
                                                                                      2:  EEP_AUD_JAPAN
                                                                            ֵ
                                                                                      0
                                                                           *********************************************************************************/

    eepaud_static_scal_in_parms_type    aud_scal_in_parms[EEP_AUD_UPLINK_PATHS];             /********************************************************************************
                                                                            ܣ    teakͨ棻
                                                                            ȡֵΧ0 0x7FFF,
                                                                                      0 db ֵΪ0x1FFF

                                                                            ֵ
                                                                                      eepaud_static_scal_in_parms_typeṹ塣
                                                                           *********************************************************************************/

    eepaud_static_scal_out_parms_type   aud_scal_out_parms[EEP_AUD_DOWNLINK_PATHS];            /********************************************************************************
                                                                            ܣ    teakͨ棻
                                                                            ȡֵΧ0 0x7FFF,
                                                                                      0 db ֵΪ 0x1FFF

                                                                            ֵ
                                                                                      eepaud_static_scal_out_parms_typeṹ塣
                                                                           *********************************************************************************/
    /*[Begin] [lvwenhua-2010/9/16]*/
    eepaud_static_scal_i2s1_parms_type    aud_scal_i2s1_parms[EEP_AUD_DOWNLINK_PATHS];           
    eepaud_static_scal_rec_parms_type    aud_scal_rec_parms[EEP_AUD_DOWNLINK_PATHS];            
    /*[End] [lvwenhua-2010/9/16]*/

#ifndef _USE_DATACARD
    /*[Begin] [lvwenhua-2010/9/16]*/
    aud_pmic_eep_pga_tx_type pmic_pga_tx_parms[EEP_AUD_UPLINK_PATHS];
    aud_pmic_eep_pga_rx_type pmic_pga_rx_parms[EEP_AUD_DOWNLINK_PATHS];  
#endif
    
    aud_eep_volume_config_type aud_volume_config;
    /*[End] [lvwenhua-2010/9/16]*/
}
aud_eep_static_type;

#endif  /* _AUD_NV_H */


