/*******************************************************************************
 * Copyright (C) 2007, ZTE Corporation.
 *
 * File Name: drvs_rf.h   
 * File Mark:    
 * Description:  
 * Others:        
 * Version:       v1.2.1
 * Author:        wangxia
 * Date:          2009-4-17
 * History 1:      
 *     Date: 
 *     Version:
 *     Author: 
 *     Modification:  
 * History 2: 
  ********************************************************************************/

#ifndef _DRVS_RF_H
#define _DRVS_RF_H


/****************************************************************************
* 	                                        Include files
****************************************************************************/


/****************************************************************************
* 	                                        Macros
****************************************************************************/


/****************************************************************************
* 	                                        Types
****************************************************************************/
typedef struct
{
	UINT32 i2s2_wa_sel:1;
	UINT32 i2s2_clk_sel:1;
	UINT32 i2s1_wa_sel:1;
	UINT32 i2s1_clk_sel:1;
	UINT32 gpio_clkout3_sel:1;
	UINT32 gpio_clkout2_sel:1;
	UINT32 gpio_clkout1_sel:1;
	UINT32 gpio_clkout0_sel:1;
	UINT32 td_spi_sel:1;
	UINT32 reserved9_15:7;
	UINT32 td_time2_ind_en:1;
	UINT32 td_time1_ind_en:1;
	UINT32 rc_out1_en:1;
	UINT32 rc_out0_en:1;
	UINT32 clkout3_en:1;
	UINT32 clkout2_en:1;
	UINT32 clkout0_en:1;
	UINT32 clkout1_en:1;
	UINT32 reserved24_31:8;	
}T_ZDrvRf_I2s_ClkOut;


typedef struct
{
	UINT32 spi_gpio_oen:14;
	UINT32 reserved14_15:2;
	UINT32 spi_gpio_in:14;
	UINT32 reserved30_31:2;
}T_ZDrvRf_SpiEn;


typedef struct
{
	UINT32 spi_gpio_out:14;
	UINT32 reserved14_15:2;
	UINT32 spi_gpio_sel:14;
	UINT32 reserved30_31:2;
}T_ZDrvRf_SpiSel;



/****************************************************************************
* 	                                        Constants
****************************************************************************/

/****************************************************************************
* 	                                        Global  Variables
****************************************************************************/

/****************************************************************************
* 	                                        Function Prototypes
****************************************************************************/

/*******************************************************************************
 * Function: zDrvRf_GsmSelect
 * Description: select GSM   rf through GPIO
 * Parameters: 
 *   Input:gsmgpio   0~7
 *
 *   Output:
 *
 * Returns: 
 *
 *
 * Others: 
 ********************************************************************************/
SINT32 zDrvRf_GsmSelect(UINT32 gsmgpio);


/*******************************************************************************
 * Function: zDrvRf_TdSelect
 * Description: select  TD  rf through GPIO
 * Parameters: 
 *   Input:tdgpio   0~8
 *
 *   Output:
 *
 * Returns: 
 *
 *
 * Others: 
 ********************************************************************************/
SINT32 zDrvRf_TdSelect(UINT32 tdgpio);

/*******************************************************************************
 * Function: zDrvRf_I2sClkOutSel
 * Description: select I2S & Clk Out
 * Parameters: 
 *   Input:
 *
 *   Output:
 *
 * Returns: 
 *
 *
 * Others: 
 ********************************************************************************/
VOID zDrvRf_I2sClkOutSel(T_ZDrvRf_I2s_ClkOut i2s_clkout);

/*******************************************************************************
 * Function: zDrvRf_SpiGpioOen
 * Description: 
 * Parameters: 
 *   Input:
 *
 *   Output:
 *
 * Returns: 
 *
 *
 * Others: 
 ********************************************************************************/
VOID zDrvRf_SpiGpioOen(T_ZDrvRf_SpiEn spioen);

/*******************************************************************************
 * Function: zDrvRf_SpiGpioSel
 * Description: 
 * Parameters: 
 *   Input:
 *
 *   Output:
 *
 * Returns: 
 *
 *
 * Others: 
 ********************************************************************************/
VOID zDrvRf_SpiGpioSel(T_ZDrvRf_SpiSel spisel);




#endif/*_DRVS_RF_H*/

